-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: localhost    Database: updated_um_sql_2576
-- ------------------------------------------------------
-- Server version	8.0.42-0ubuntu0.24.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Ratings`
--

DROP TABLE IF EXISTS `Ratings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Ratings` (
  `ratingId` int NOT NULL AUTO_INCREMENT,
  `ratingCustomerId` int NOT NULL,
  `ratingVenderId` int NOT NULL,
  `ratingFromUserId` int NOT NULL,
  `ratingReqId` int NOT NULL,
  `ratingComment` varchar(255) DEFAULT NULL,
  `ratingStars` int NOT NULL,
  `ratingPic` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ratingId`),
  KEY `ratingCustomerId` (`ratingCustomerId`),
  KEY `ratingVenderId` (`ratingVenderId`),
  KEY `ratingReqId` (`ratingReqId`),
  CONSTRAINT `Ratings_ibfk_1` FOREIGN KEY (`ratingCustomerId`) REFERENCES `users` (`userId`),
  CONSTRAINT `Ratings_ibfk_2` FOREIGN KEY (`ratingVenderId`) REFERENCES `users` (`userId`),
  CONSTRAINT `Ratings_ibfk_3` FOREIGN KEY (`ratingReqId`) REFERENCES `requests` (`reqId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Ratings`
--

LOCK TABLES `Ratings` WRITE;
/*!40000 ALTER TABLE `Ratings` DISABLE KEYS */;
/*!40000 ALTER TABLE `Ratings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `catId` int NOT NULL AUTO_INCREMENT,
  `catQty` tinyint(1) DEFAULT '0',
  `catName` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`catId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,0,'خدمة منزلية'),(2,0,'خدمة  عامة'),(3,0,'خدمة نقل'),(4,0,'خدمة بيك اب');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_old`
--

DROP TABLE IF EXISTS `categories_old`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_old` (
  `catId` int NOT NULL AUTO_INCREMENT,
  `catQty` tinyint(1) DEFAULT '0',
  `catName` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`catId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_old`
--

LOCK TABLES `categories_old` WRITE;
/*!40000 ALTER TABLE `categories_old` DISABLE KEYS */;
INSERT INTO `categories_old` VALUES (1,0,'خدمة منزلية'),(2,0,'خدمة  عامة'),(3,0,'خدمة نقل'),(4,0,'خدمة بيك اب');
/*!40000 ALTER TABLE `categories_old` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactInfo`
--

DROP TABLE IF EXISTS `contactInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contactInfo` (
  `contactId` int NOT NULL AUTO_INCREMENT,
  `facebookUrl` varchar(255) DEFAULT NULL,
  `instagramUrl` varchar(255) DEFAULT NULL,
  `snapchatUrl` varchar(255) DEFAULT NULL,
  `youtubeUrl` varchar(255) DEFAULT NULL,
  `linkedinUrl` varchar(255) DEFAULT NULL,
  `whatsappUrl` varchar(255) DEFAULT NULL,
  `facebookLogo` varchar(255) DEFAULT NULL,
  `instagramLogo` varchar(255) DEFAULT NULL,
  `snapchatLogo` varchar(255) DEFAULT NULL,
  `youtubeLogo` varchar(255) DEFAULT NULL,
  `linkedinLogo` varchar(255) DEFAULT NULL,
  `whatsappLogo` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`contactId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactInfo`
--

LOCK TABLES `contactInfo` WRITE;
/*!40000 ALTER TABLE `contactInfo` DISABLE KEYS */;
INSERT INTO `contactInfo` VALUES (1,'https://www.facebook.com/pickum.jo/','https://www.instagram.com/pickum.jo/','https://www.snapchat.com/add/pickum.jo','https://www.youtube.com/@pickum-jo','https://www.linkedin.com/company/100229612/admin/feed/posts/','https://wa.me/962781058132','brand-facebook.svg','brand-instagram.svg','brand-snapchat.svg','brand-youtube.svg','brand-linkedin.svg','brand-whatsapp.svg');
/*!40000 ALTER TABLE `contactInfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `issues`
--

DROP TABLE IF EXISTS `issues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `issues` (
  `issueId` int NOT NULL AUTO_INCREMENT,
  `issueCustomerId` int NOT NULL,
  `issueVenderId` int NOT NULL,
  `issueFromUserId` int NOT NULL,
  `issueDetails` varchar(255) DEFAULT NULL,
  `issueReqId` int DEFAULT NULL,
  PRIMARY KEY (`issueId`),
  KEY `issueCustomerId` (`issueCustomerId`),
  KEY `issueVenderId` (`issueVenderId`),
  KEY `issueFromUserId` (`issueFromUserId`),
  CONSTRAINT `issues_ibfk_1` FOREIGN KEY (`issueCustomerId`) REFERENCES `users` (`userId`),
  CONSTRAINT `issues_ibfk_2` FOREIGN KEY (`issueVenderId`) REFERENCES `users` (`userId`),
  CONSTRAINT `issues_ibfk_3` FOREIGN KEY (`issueFromUserId`) REFERENCES `users` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `issues`
--

LOCK TABLES `issues` WRITE;
/*!40000 ALTER TABLE `issues` DISABLE KEYS */;
/*!40000 ALTER TABLE `issues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `notId` int NOT NULL AUTO_INCREMENT,
  `notToUserId` int NOT NULL,
  `notificationContent` varchar(255) DEFAULT NULL,
  `notTitle` varchar(255) DEFAULT NULL,
  `notificationTimestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`notId`),
  KEY `notToUserId` (`notToUserId`),
  CONSTRAINT `notifications_ibfk_1` FOREIGN KEY (`notToUserId`) REFERENCES `users` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_methods`
--

DROP TABLE IF EXISTS `payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_methods` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `inAdminPanel` int DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_methods`
--

LOCK TABLES `payment_methods` WRITE;
/*!40000 ALTER TABLE `payment_methods` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_methods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `requests`
--

DROP TABLE IF EXISTS `requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requests` (
  `reqId` int NOT NULL AUTO_INCREMENT,
  `reqDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `reqUserId` int NOT NULL,
  `reqVenderId` int DEFAULT NULL,
  `reqSubSpecId` int NOT NULL,
  `reqStatus` enum('new','pending','rejected','completed','canceled','half_completed') DEFAULT NULL,
  `reqFrom` varchar(255) DEFAULT NULL,
  `reqTo` varchar(255) DEFAULT NULL,
  `reqUnit` varchar(255) DEFAULT NULL,
  `reqPrice` decimal(10,2) DEFAULT NULL,
  `reqQty` varchar(100) DEFAULT NULL,
  `reqFromLat` decimal(10,6) DEFAULT NULL,
  `reqFromLong` decimal(10,6) DEFAULT NULL,
  `reqToLat` decimal(10,6) DEFAULT NULL,
  `reqToLong` decimal(10,6) DEFAULT NULL,
  `reqTotalPrice` decimal(10,2) DEFAULT NULL,
  `reqRate` int DEFAULT NULL,
  `updatedByCron` int DEFAULT '0',
  `hasworkers` int DEFAULT '0',
  `workersCount` int DEFAULT '0',
  `reqSteps` int DEFAULT '0',
  PRIMARY KEY (`reqId`),
  KEY `reqUserId` (`reqUserId`),
  KEY `reqVenderId` (`reqVenderId`),
  KEY `reqSubSpecId` (`reqSubSpecId`),
  CONSTRAINT `requests_ibfk_1` FOREIGN KEY (`reqUserId`) REFERENCES `users` (`userId`),
  CONSTRAINT `requests_ibfk_2` FOREIGN KEY (`reqVenderId`) REFERENCES `users` (`userId`),
  CONSTRAINT `requests_ibfk_3` FOREIGN KEY (`reqSubSpecId`) REFERENCES `subSpecialties` (`subSpecId`)
) ENGINE=InnoDB AUTO_INCREMENT=1088 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `requests`
--

LOCK TABLES `requests` WRITE;
/*!40000 ALTER TABLE `requests` DISABLE KEYS */;
INSERT INTO `requests` VALUES (1006,'2024-10-13 20:35:00',48,63,3,'pending','PWH5+M9, Aanjar, Lebanon','PWH5+M9, Aanjar, Lebanon','4 م',20.00,'0',33.730147,35.909550,33.730147,35.909550,22.00,NULL,0,0,0,0),(1007,'2024-10-13 20:40:11',48,651,3,'rejected','PWH5+M9, Aanjar, Lebanon','PWH5+M9, Aanjar, Lebanon','4 م',20.00,'0',33.730141,35.909544,33.730141,35.909544,22.00,NULL,0,0,0,0),(1008,'2024-10-13 20:46:39',48,651,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1009,'2024-10-13 20:50:16',48,63,3,'pending','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1010,'2024-10-13 20:57:24',48,63,3,'completed','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1011,'2024-10-15 18:51:01',48,63,3,'completed','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1012,'2024-10-15 19:06:27',48,63,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1013,'2024-10-15 19:10:30',48,63,3,'completed','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1014,'2024-10-15 19:13:06',48,63,3,'rejected','QVGV+P4R, Marj, Lebanon','QVGV+P4R, Marj, Lebanon','4 م',20.00,'0',33.777329,35.893138,33.777329,35.893138,22.00,NULL,0,0,0,0),(1015,'2024-10-15 19:15:08',48,63,3,'completed','QVGV+4WQ, Bar Elias, Lebanon','QVGV+4WQ, Bar Elias, Lebanon','4 م',20.00,'0',33.775262,35.895285,33.775262,35.895285,22.00,NULL,0,0,0,0),(1016,'2024-10-15 19:18:05',48,63,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1017,'2024-10-15 19:26:06',48,63,19,'completed','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1018,'2024-10-15 19:28:29',48,63,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1019,'2024-10-15 19:30:17',48,63,19,'completed','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,1,2,0),(1020,'2024-10-15 19:32:42',48,63,19,'completed','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1021,'2024-10-15 19:34:38',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1022,'2024-10-15 19:41:27',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1023,'2024-10-15 19:43:29',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1024,'2024-10-15 19:47:47',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1025,'2024-10-15 19:49:37',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1026,'2024-10-15 19:51:17',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1027,'2024-10-15 19:53:12',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1028,'2024-10-15 19:56:32',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1029,'2024-10-15 19:58:32',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1030,'2024-10-15 20:02:18',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1031,'2024-10-15 20:05:02',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1032,'2024-10-15 20:07:53',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1033,'2024-10-15 20:08:26',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1034,'2024-10-15 20:10:33',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1035,'2024-10-15 20:11:28',48,NULL,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1036,'2024-10-15 20:14:07',48,651,3,'rejected','QVGV+JG6, Bar Elias, Lebanon','QVGV+JG6, Bar Elias, Lebanon','4 م',20.00,'0',33.776453,35.893912,33.776453,35.893912,22.00,NULL,0,0,0,0),(1037,'2024-10-16 20:17:25',48,NULL,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1038,'2024-10-16 20:21:00',48,NULL,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1039,'2024-10-16 20:22:11',656,NULL,3,'rejected','QVFX+M6C, Bar Elias, Lebanon','QVFX+M6C, Bar Elias, Lebanon','م 6',25.00,'0',33.774664,35.897656,33.774664,35.897656,27.00,NULL,0,0,0,0),(1040,'2024-10-16 20:55:22',48,651,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1041,'2024-10-16 20:57:26',48,651,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1042,'2024-10-16 21:00:19',48,651,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,2,0,0,0,0),(1043,'2024-10-17 14:48:43',48,600,19,'completed','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,4,0,0,0,1),(1044,'2024-10-17 15:29:39',48,NULL,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1045,'2024-10-17 15:35:56',48,651,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1046,'2024-10-17 15:56:15',48,600,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,1),(1047,'2024-10-17 16:19:22',48,651,3,'rejected','QVHV+274, Marj, Lebanon','QVHV+274, Marj, Lebanon','4 م',20.00,'0',33.777258,35.892965,33.777258,35.892965,22.00,NULL,0,0,0,0),(1048,'2024-10-17 16:24:55',48,651,3,'rejected','QVFR+W78, Bar Elias, Lebanon','QVFR+W78, Bar Elias, Lebanon','4 م',20.00,'0',33.774710,35.890804,33.774710,35.890804,22.00,NULL,0,0,0,0),(1049,'2024-10-17 16:27:52',48,651,3,'rejected','QVFR+W78, Bar Elias, Lebanon','QVFR+W78, Bar Elias, Lebanon','4 م',20.00,'0',33.774972,35.890899,33.774972,35.890899,22.00,NULL,0,0,0,0),(1050,'2024-10-17 16:30:01',48,651,3,'completed','QVFR+W78, Bar Elias, Lebanon','QVFR+W78, Bar Elias, Lebanon','4 م',20.00,'0',33.775027,35.889784,33.775027,35.889784,22.00,NULL,0,0,0,0),(1051,'2024-10-17 17:50:41',48,600,19,'rejected','PWJ6+FC Aanjar, Lebanon','PWP8+6X9, Lebanon','1 ك',1.00,'0',33.731174,35.911073,33.735572,35.916794,26.00,NULL,0,1,1,1),(1052,'2024-10-17 19:52:40',48,NULL,3,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1053,'2024-10-17 20:00:17',48,NULL,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,0),(1054,'2024-10-17 20:01:04',48,600,19,'rejected','Zahleh','BareLias','20 ليتر',1.00,'3',33.730141,35.909544,33.730141,35.909544,5.00,NULL,0,0,0,1),(1055,'2024-10-19 11:25:58',701,NULL,3,'rejected','R2HR+23F, Deir El Ghazal, Lebanon','R2HR+23F, Deir El Ghazal, Lebanon','4 م',20.00,'0',33.827367,36.040234,33.827367,36.040234,22.00,NULL,0,0,0,0),(1056,'2024-10-19 11:27:44',701,NULL,3,'rejected','R2HR+67H, Raiit, Lebanon','R2HR+67H, Raiit, Lebanon','4 م',20.00,'0',33.827996,36.040658,33.827996,36.040658,22.00,NULL,0,0,0,0),(1057,'2024-10-19 12:07:53',48,600,19,'pending','PWM9+R27, Aanjar 1802, Lebanon','QW56+3HJ, Deir Zenoun, Lebanon','1 ك',1.00,'0',33.733601,35.918097,33.757753,35.911395,16.00,NULL,0,0,0,1),(1058,'2024-10-19 12:23:23',703,NULL,2,'rejected','Kamaliyeh Cir., Amman, Jordan','Kamaliyeh Cir., Amman, Jordan','16 كيلو',7.00,'1',32.028744,35.825436,32.028744,35.825436,7.00,NULL,0,0,0,0),(1059,'2024-10-19 12:25:47',703,NULL,2,'rejected','Kamaliyeh Cir., Amman, Jordan','Kamaliyeh Cir., Amman, Jordan','16 كيلو',7.00,'1',32.028744,35.825436,32.028744,35.825436,7.00,NULL,0,0,0,0),(1060,'2024-10-19 12:39:46',703,NULL,2,'rejected','Kamaliyeh Cir., Amman, Jordan','Kamaliyeh Cir., Amman, Jordan','16 كيلو',7.00,'1',32.028744,35.825436,32.028744,35.825436,7.00,NULL,0,0,0,0),(1061,'2024-10-19 13:20:17',701,NULL,3,'rejected','R2HR+67H, Raiit, Lebanon','R2HR+67H, Raiit, Lebanon','4 م',20.00,'0',33.828473,36.041209,33.828473,36.041209,22.00,NULL,0,0,0,0),(1062,'2024-10-19 14:03:23',48,651,3,'completed','QVFR+W78, Bar Elias, Lebanon','QVFR+W78, Bar Elias, Lebanon','4 م',20.00,'0',33.774715,35.890445,33.774715,35.890445,22.00,NULL,0,0,0,0),(1063,'2024-10-27 14:45:41',329,NULL,22,'rejected','Q. Aliaa St. 19, Amman, Jordan','7VFW+VC8, Jerash, Jordan','1 ك',0.42,'0',31.984462,35.901501,32.274652,35.896076,22.34,NULL,0,0,0,0),(1064,'2024-11-17 13:36:47',96,NULL,2,'rejected','2V78+R4H, Amman, Jordan','2V78+R4H, Amman, Jordan','16 كيلو',7.00,'1',32.013689,35.865239,32.013689,35.865239,7.00,NULL,0,0,0,0),(1065,'2024-11-23 07:52:30',682,NULL,2,'rejected','2V78+R4H, Amman, Jordan','2V78+R4H, Amman, Jordan','16 كيلو',7.00,'1',32.014058,35.865307,32.014058,35.865307,7.00,NULL,0,0,0,0),(1066,'2024-11-23 10:09:42',706,NULL,2,'rejected','3R6G+JQR, Ein Al-Basha, Jordan','3R6G+JQR, Ein Al-Basha, Jordan','16 كيلو',7.00,'1',32.061415,35.826525,32.061415,35.826525,7.00,NULL,0,0,0,0),(1067,'2024-12-20 12:06:35',714,NULL,2,'rejected','2RPH+V3P, Safut, Jordan','2RPH+V3P, Safut, Jordan','16 كيلو',7.00,'1',32.036695,35.826531,32.036695,35.826531,7.00,NULL,0,0,0,0),(1068,'2024-12-20 12:40:29',714,NULL,2,'rejected','2RPH+V3P, Safut, Jordan','2RPH+V3P, Safut, Jordan','16 كيلو',7.00,'1',32.036695,35.826531,32.036695,35.826531,7.00,NULL,0,0,0,0),(1069,'2024-12-20 12:43:08',714,NULL,2,'rejected','2RPH+V3P, Safut, Jordan','2RPH+V3P, Safut, Jordan','16 كيلو',7.00,'1',32.036694,35.826528,32.036694,35.826528,7.00,NULL,0,0,0,0),(1070,'2024-12-24 12:34:00',715,NULL,2,'rejected','227G+8QG, Russeifa, Jordan','227G+8QG, Russeifa, Jordan','16 كيلو',7.00,'1',32.012948,36.026734,32.012948,36.026734,7.00,NULL,0,0,0,0),(1071,'2024-12-24 12:35:31',715,NULL,2,'rejected','227G+8QG, Russeifa, Jordan','227G+8QG, Russeifa, Jordan','16 كيلو',7.00,'1',32.012928,36.026805,32.012928,36.026805,7.00,NULL,0,0,0,0),(1072,'2024-12-25 10:18:53',655,NULL,2,'rejected','WW2G+4XP, Abu Bakr Al-Siddeeq St عمّان, Amman, Jordan','WW2G+4XP, Abu Bakr Al-Siddeeq St عمّان, Amman, Jordan','16 كيلو',7.00,'1',31.900461,35.927456,31.900461,35.927456,7.00,NULL,0,0,0,0),(1073,'2025-01-02 11:23:25',703,NULL,2,'rejected','Kamaliyeh Cir., Amman, Jordan','Kamaliyeh Cir., Amman, Jordan','16 كيلو',7.00,'1',32.028744,35.825436,32.028744,35.825436,7.00,NULL,0,0,0,0),(1074,'2025-01-15 09:26:59',635,NULL,20,'rejected','XW9F+R99, Tamim Ar-Rimawi St., Amman, Jordan','2RGX+XWJ, Amman, Jordan','1 ك',1.00,'0',31.969676,35.923381,32.027469,35.849763,36.00,NULL,0,1,2,0),(1075,'2025-01-15 09:28:55',635,NULL,20,'rejected','XW9F+V7M, Amman, Jordan','2RFW+RC7, Amman, Jordan','1 ك',1.00,'0',31.969725,35.923250,32.024326,35.845917,36.00,NULL,0,1,2,0),(1076,'2025-01-15 09:30:53',635,NULL,20,'rejected','XWCC+5WP, Amman, Jordan','XW9F+V7M, Amman, Jordan','1 ك',1.00,'0',31.970488,35.922576,31.969725,35.923250,36.00,NULL,0,1,2,0),(1077,'2025-01-15 09:51:27',635,NULL,20,'rejected','XW9F+V7M, Amman, Jordan','2RFW+RC7, Amman, Jordan','1 ك',1.00,'0',31.969725,35.923250,32.024326,35.845917,36.00,NULL,0,1,2,0),(1078,'2025-01-30 13:36:49',720,NULL,3,'rejected','WX4X+3CF, Amman, Jordan','WX4X+3CF, Amman, Jordan','22 م',50.00,'0',31.905352,35.998302,31.905352,35.998302,52.00,NULL,0,0,0,0),(1079,'2025-01-30 13:38:25',720,290,3,'pending','WX4X+3CF, Amman, Jordan','WX4X+3CF, Amman, Jordan','22 م',50.00,'0',31.905395,35.998335,31.905395,35.998335,52.00,NULL,0,0,0,0),(1080,'2025-02-02 12:56:53',721,NULL,2,'rejected','Sami Msharbash St. 25, Amman, Jordan','Sami Msharbash St. 25, Amman, Jordan','16 كيلو',7.00,'2',32.048198,35.878187,32.048198,35.878187,14.00,NULL,0,0,0,0),(1081,'2025-02-02 12:58:58',721,NULL,2,'rejected','Sami Msharbash St. 25, Amman, Jordan','Sami Msharbash St. 25, Amman, Jordan','16 كيلو',7.00,'2',32.048220,35.878171,32.048220,35.878171,14.00,NULL,0,0,0,0),(1082,'2025-02-28 13:12:28',686,NULL,2,'rejected','24VM+6V5, Zarqa, Jordan','24VM+6V5, Zarqa, Jordan','16 كيلو',7.00,'1',32.042405,36.134286,32.042405,36.134286,7.00,NULL,0,0,0,0),(1083,'2025-02-28 13:14:18',686,NULL,2,'rejected','24VM+6V5, Zarqa, Jordan','24VM+6V5, Zarqa, Jordan','16 كيلو',7.00,'1',32.042333,36.134341,32.042333,36.134341,7.00,NULL,0,0,0,0),(1084,'2025-03-04 19:26:03',96,NULL,3,'rejected','العبدلي، عمّان، Amman, Jordan','العبدلي، عمّان، Amman, Jordan','م 6',25.00,'0',31.959194,35.918422,31.959194,35.918422,27.00,NULL,0,0,0,0),(1085,'2025-03-04 19:28:24',48,NULL,3,'rejected','K. Hussein St. 505, Amman, Jordan','K. Hussein St. 505, Amman, Jordan','م 6',25.00,'0',31.958871,35.918077,31.958871,35.918077,27.00,NULL,0,0,0,0),(1086,'2025-03-06 07:23:43',682,NULL,2,'rejected','2V87+2X2, Ibn Abi Halah St., Amman, Jordan','2V87+2X2, Ibn Abi Halah St., Amman, Jordan','16 كيلو',7.00,'1',32.014351,35.864629,32.014351,35.864629,7.00,NULL,0,0,0,0),(1087,'2025-03-20 18:55:50',682,382,3,'pending','3R3P+PMH, Ein Al-Basha, Jordan','3R3P+PMH, Ein Al-Basha, Jordan','4 م',20.00,'0',32.054169,35.836732,32.054169,35.836732,22.00,NULL,0,0,0,0);
/*!40000 ALTER TABLE `requests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `specUnitsPrice`
--

DROP TABLE IF EXISTS `specUnitsPrice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `specUnitsPrice` (
  `dpId` int NOT NULL AUTO_INCREMENT,
  `subSpecId` int NOT NULL,
  `unit` varchar(255) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `maxDistance` double DEFAULT '0',
  `minDistance` double DEFAULT '0',
  PRIMARY KEY (`dpId`),
  KEY `subSpecId` (`subSpecId`),
  CONSTRAINT `specUnitsPrice_ibfk_1` FOREIGN KEY (`subSpecId`) REFERENCES `subSpecialties` (`subSpecId`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `specUnitsPrice`
--

LOCK TABLES `specUnitsPrice` WRITE;
/*!40000 ALTER TABLE `specUnitsPrice` DISABLE KEYS */;
INSERT INTO `specUnitsPrice` VALUES (1,1,'20 ليتر',1.00,0,0),(2,2,'16 كيلو',7.00,0,0),(3,3,'4 م',20.00,0,0),(4,3,'م 6',25.00,0,0),(5,3,'8 م',30.00,0,0),(6,3,'12 م',34.00,0,0),(7,3,'18 م',40.00,0,0),(8,3,'22 م',50.00,0,0),(9,4,'250 ليتر',200.00,0,0),(10,4,'300 ليتر',250.00,0,0),(11,4,'400 ليتر',400.00,0,0),(12,4,'550 ليتر',450.00,0,0),(13,4,'800 ليتر',700.00,0,0),(14,4,'1000 ليتر',1000.00,0,0),(15,5,'15 متر',35.00,0,0),(18,8,'1 ك',1.15,0,0),(20,10,'1 ك',1.15,85,15),(26,16,'1 ك',1.00,100,15),(29,19,'1 ك',1.00,100,15),(32,22,'1 ك',0.42,85,2),(36,5,'28 متر',40.00,0,0),(37,5,'32 متر',45.00,0,0),(42,19,'1 ك',0.80,200,100),(43,19,'1 ك',0.70,300,200),(44,19,'1 ك',0.60,2000,300),(45,16,'1 ك',0.80,200,100),(46,16,'1 ك',0.70,300,200),(47,16,'1 ك',0.60,2000,300),(50,14,'1 ك',1.00,100,15),(51,14,'1 ك',0.80,200,100),(52,14,'1 ك',0.70,300,200),(53,14,'1 ك',0.60,2000,300),(54,12,'1 ك',1.00,100,15),(55,12,'1 ك',0.80,200,100),(56,12,'1 ك',0.70,300,200),(57,12,'1 ك',0.60,2000,300),(58,21,'1 ك',1.15,100,15),(59,21,'1 ك',1.00,200,100),(60,21,'1 ك',0.90,300,200),(61,21,'1 ك',0.70,2000,300),(62,23,'1 ك',1.15,100,15),(63,23,'1 ك',1.00,200,100),(64,23,'1 ك',0.90,300,200),(65,23,'1 ك',0.70,2000,300),(66,24,'1 ك',1.15,100,15),(67,24,'1 ك',1.00,200,100),(68,24,'1 ك',0.90,300,200),(69,24,'1 ك',0.70,2000,300),(70,25,'1 ك',1.15,100,15),(71,25,'1 ك',1.00,200,100),(72,25,'1 ك',0.90,300,200),(73,25,'1 ك',0.70,2000,300),(74,13,'1 ك',1.00,100,15),(75,13,'1 ك',0.90,200,100),(76,13,'1 ك',0.85,300,200),(77,13,'1 ك',0.80,2000,300),(78,15,'1 ك',1.00,100,15),(79,15,'1 ك',0.80,200,100),(80,15,'1 ك',0.70,300,200),(81,15,'1 ك',0.60,2000,300),(82,17,'1 ك',1.00,100,15),(83,17,'1 ك',0.80,200,100),(84,17,'1 ك',0.70,300,200),(85,17,'1 ك',0.60,2000,300),(86,20,'1 ك',1.00,100,15),(87,20,'1 ك',0.80,200,100),(88,20,'1 ك',0.70,300,200),(89,20,'1 ك',0.60,2000,300),(90,11,'1 ك',0.80,100,15),(91,11,'1 ك',0.70,200,100),(92,11,'1 ك',0.60,300,200),(93,11,'1 ك',0.50,2000,300),(94,18,'1 ك',0.80,100,15),(95,18,'1 ك',0.75,200,100),(96,18,'1 ك',0.70,300,200),(97,18,'1 ك',0.65,2000,300),(98,6,'1 ك',1.00,100,15),(99,6,'1 ك',0.80,200,100),(100,6,'1 ك',0.70,300,200),(101,6,'1 ك',0.60,2000,300),(102,27,'1 ك',1.00,100,15),(103,27,'1 ك',0.80,200,100),(104,27,'1 ك',0.70,300,200),(105,27,'1 ك',0.60,2000,300),(106,7,'1 ك',1.25,100,15),(107,7,'1 ك',1.00,200,100),(108,7,'1 ك',0.80,300,200),(109,7,'1 ك',0.60,2000,300),(110,22,'1 ك',0.38,200,100),(111,22,'1 ك',0.35,300,200),(112,22,'1 ك',0.32,2000,300),(113,28,'20 ليتر',1.00,0,0),(114,29,'20 ليتر',5.00,0,0),(115,30,'20 ليتر',3.50,0,0),(116,32,'16 كيلو',42.00,0,0),(117,9,'1 ك',1.00,85,15),(118,9,'1 ك',0.80,200,100),(119,9,'1 ك',0.70,300,200),(120,9,'1 ك',0.60,2000,300),(121,10,'1 ك',0.90,200,100),(122,10,'1 ك',0.80,300,200),(123,10,'1 ك',0.70,2000,300);
/*!40000 ALTER TABLE `specUnitsPrice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `specialties`
--

DROP TABLE IF EXISTS `specialties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `specialties` (
  `specId` int NOT NULL AUTO_INCREMENT,
  `catId` int DEFAULT NULL,
  `specNameAr` varchar(255) DEFAULT NULL,
  `specPhoto` varchar(255) DEFAULT NULL,
  `specOrderBy` int DEFAULT '0',
  `isAvailable` int DEFAULT '1',
  PRIMARY KEY (`specId`),
  KEY `catId` (`catId`),
  CONSTRAINT `specialties_ibfk_1` FOREIGN KEY (`catId`) REFERENCES `categories` (`catId`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `specialties`
--

LOCK TABLES `specialties` WRITE;
/*!40000 ALTER TABLE `specialties` DISABLE KEYS */;
INSERT INTO `specialties` VALUES (1,1,'قارورة ماء','قارورة-ماء.jpg',1,1),(2,1,'اسطوانة غاز','اسطوانة-غاز.jpg',2,1),(3,2,'تنك مي','cat02-water-tank.jpg',1,1),(4,2,'محروقات','محروقات.jpg',2,1),(5,2,'صهريج نضح','صهريج-نضح.jpg',3,1),(6,3,'ونش سيارات','ونش-سيارات.jpg',1,1),(7,3,'آليات ثقيلة','آليات-ثقيلة.jpg',3,1),(8,3,'نقل كونتينر','نقل-كونتينر.jpg',4,1),(9,4,'شادر','شادر1.jpeg',2,1),(10,4,'مغلق','kia-bongo-close.webp',3,1),(11,4,'ثلاجة','ثلاجة.jpg',4,1),(12,4,'مفتوح','kia-bongo-open.webp',1,1),(13,4,'باص','باص1.jpeg',5,1),(15,4,'باص 2','باص3.jpg',5,1);
/*!40000 ALTER TABLE `specialties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subSpecialties`
--

DROP TABLE IF EXISTS `subSpecialties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subSpecialties` (
  `subSpecId` int NOT NULL AUTO_INCREMENT,
  `subSpecNameAr` varchar(255) DEFAULT NULL,
  `specId` int DEFAULT NULL,
  `subSpecPhoto` varchar(255) DEFAULT NULL,
  `serviceFee` float DEFAULT NULL,
  `vendorPrecentage` float DEFAULT NULL,
  `distanceMin` float DEFAULT '0',
  `openCounter` float DEFAULT '0',
  `hasWorkers` int DEFAULT '0',
  `workerPrice` int DEFAULT '0',
  `isAvailable` int DEFAULT '1',
  `isFromTo` int DEFAULT '0',
  `serviceTypeAr` varchar(250) DEFAULT '',
  PRIMARY KEY (`subSpecId`),
  KEY `specId` (`specId`),
  CONSTRAINT `subSpecialties_ibfk_1` FOREIGN KEY (`specId`) REFERENCES `specialties` (`specId`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subSpecialties`
--

LOCK TABLES `subSpecialties` WRITE;
/*!40000 ALTER TABLE `subSpecialties` DISABLE KEYS */;
INSERT INTO `subSpecialties` VALUES (1,'تبديل سعودية',1,'watergallon.png',0,10,0,0,0,0,1,0,'تبديل'),(2,'تبديل اسطوانة',2,'gascylinder.png',0,0,0,0,0,0,1,0,'تبديل'),(3,'تنك مي',3,'6709950fc102f.png',2,10,0,0,0,0,1,0,'أجرة'),(4,'محروقات',4,'669327f304215.png',1,0,0,0,0,0,0,0,'أجرة'),(5,'تنك نضح',5,'670995ebc0158.png',2,10,0,0,0,0,1,0,'أجرة'),(6,'صغير',6,'6692902c2ecb1.png',1,10,15,20,0,0,1,1,'أجرة'),(7,'كبير',6,'66a4df9b64870.png',1,10,15,50,0,0,1,1,'أجرة'),(8,'البي',7,'669290115e934.png',1,10,0,0,0,0,1,1,'أجرة'),(9,'20 قدم',8,'6693280c2df53.png',1,10,15,0,0,0,1,1,'أجرة'),(10,'40 قدم',8,'66932819c8501.png',1,10,15,0,0,0,1,1,'أجرة'),(11,'هايلكس',9,'chader.png',1,10,15,10,0,0,1,1,'أجرة'),(12,'بينغو',9,'669328464e358.png',1,10,15,15,0,0,1,1,'أجرة'),(13,'ديانا',9,'669328573277b.png',1,10,15,15,0,0,1,1,'أجرة'),(14,'بينغو',10,'box-bongo.png',1,10,15,15,0,0,1,1,'أجرة'),(15,'ديانا',10,'box-dyna.png',1,10,15,15,0,0,1,1,'أجرة'),(16,'بينغو',11,'refrigerator-bongo.png',1,10,15,15,0,0,1,1,'أجرة'),(17,'ديانا',11,'refrigerator-dyna.png',1,10,15,15,0,0,1,1,'أجرة'),(18,'هايلكس',12,'open.png',1,10,15,10,0,0,1,1,'أجرة'),(19,'بينغو',12,'flatbed-bongo.png',1,10,15,15,1,10,1,1,'أجرة'),(20,'ديانا',12,'flatbed-dyna.png',1,10,15,15,1,10,1,1,'أجرة'),(21,'البي',12,'flatbed-albi.png',1,10,15,50,0,0,1,1,'أجرة'),(22,'باص',13,'6693289183fae.png',1,10,2,2,0,0,1,1,'أجرة'),(23,'البي',9,'6693286a5554b.png',1,10,15,50,0,0,1,1,'أجرة'),(24,'البي',10,'box-albi.png',1,10,15,50,0,0,1,1,'أجرة'),(25,'البي',11,'refrigerator-albi.png',1,10,15,50,0,0,1,1,'أجرة'),(27,'كهرباء EVCars',6,'669290402fa34.png',1,10,15,30,0,0,1,1,'أجرة'),(28,'تبديل اردنية',1,'watergallon.png',0,10,0,0,0,0,1,0,'تبديل'),(29,'شراء سعودية',1,'watergallon.png',0,10,0,0,0,0,0,0,'شراء'),(30,'شراء اردنية',1,'watergallon.png',0,10,0,0,0,0,0,0,'شراء'),(32,'شراء اسطوانة',2,'gascylinder.png',1,2.5,0,0,0,0,0,0,'شراء'),(33,'باص 100',15,'bus-h100.png',0,10,2,2,0,0,1,1,'أجرة');
/*!40000 ALTER TABLE `subSpecialties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tempRequestVendors`
--

DROP TABLE IF EXISTS `tempRequestVendors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tempRequestVendors` (
  `tempReqVendorId` int NOT NULL AUTO_INCREMENT,
  `tempRequestId` int DEFAULT NULL,
  `tempVendorId` int DEFAULT NULL,
  `tempCreatedAt` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tempReqVendorId`),
  KEY `tempRequestId` (`tempRequestId`),
  KEY `tempVendorId` (`tempVendorId`),
  CONSTRAINT `tempRequestVendors_ibfk_1` FOREIGN KEY (`tempRequestId`) REFERENCES `requests` (`reqId`),
  CONSTRAINT `tempRequestVendors_ibfk_2` FOREIGN KEY (`tempVendorId`) REFERENCES `users` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=1321 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tempRequestVendors`
--

LOCK TABLES `tempRequestVendors` WRITE;
/*!40000 ALTER TABLE `tempRequestVendors` DISABLE KEYS */;
INSERT INTO `tempRequestVendors` VALUES (1120,1006,651,'2024-10-13 20:35:00'),(1121,1007,651,'2024-10-13 20:40:11'),(1122,1008,651,'2024-10-13 20:46:39'),(1123,1009,651,'2024-10-13 20:50:16'),(1124,1010,651,'2024-10-13 20:57:24'),(1125,1011,651,'2024-10-15 18:51:01'),(1126,1012,651,'2024-10-15 19:06:27'),(1127,1013,651,'2024-10-15 19:10:30'),(1128,1014,651,'2024-10-15 19:13:06'),(1129,1015,651,'2024-10-15 19:15:08'),(1130,1016,600,'2024-10-15 19:18:05'),(1131,1017,600,'2024-10-15 19:26:06'),(1132,1018,600,'2024-10-15 19:28:29'),(1133,1019,600,'2024-10-15 19:30:17'),(1134,1020,600,'2024-10-15 19:32:42'),(1135,1021,600,'2024-10-15 19:34:38'),(1136,1022,600,'2024-10-15 19:41:27'),(1137,1023,600,'2024-10-15 19:43:29'),(1138,1024,600,'2024-10-15 19:47:47'),(1139,1025,600,'2024-10-15 19:49:37'),(1140,1026,600,'2024-10-15 19:51:17'),(1141,1027,600,'2024-10-15 19:53:12'),(1142,1028,600,'2024-10-15 19:56:32'),(1143,1029,600,'2024-10-15 19:58:32'),(1144,1030,600,'2024-10-15 20:02:18'),(1145,1031,600,'2024-10-15 20:05:02'),(1146,1032,600,'2024-10-15 20:07:53'),(1147,1033,600,'2024-10-15 20:08:26'),(1148,1034,600,'2024-10-15 20:10:33'),(1149,1035,651,'2024-10-15 20:11:28'),(1150,1036,651,'2024-10-15 20:14:07'),(1151,1037,651,'2024-10-16 20:17:25'),(1152,1038,651,'2024-10-16 20:21:00'),(1153,1039,651,'2024-10-16 20:22:11'),(1154,1040,651,'2024-10-16 20:55:22'),(1155,1041,651,'2024-10-16 20:57:26'),(1156,1042,651,'2024-10-16 21:00:19'),(1157,1043,600,'2024-10-17 14:48:43'),(1158,1044,651,'2024-10-17 15:29:39'),(1159,1045,651,'2024-10-17 15:35:56'),(1160,1046,600,'2024-10-17 15:56:15'),(1161,1047,651,'2024-10-17 16:19:22'),(1162,1048,651,'2024-10-17 16:24:55'),(1163,1049,651,'2024-10-17 16:27:52'),(1164,1050,651,'2024-10-17 16:30:01'),(1165,1051,600,'2024-10-17 17:50:41'),(1166,1052,651,'2024-10-17 19:52:40'),(1167,1053,600,'2024-10-17 20:00:17'),(1168,1054,600,'2024-10-17 20:01:04'),(1169,1055,702,'2024-10-19 11:25:58'),(1170,1055,651,'2024-10-19 11:25:58'),(1171,1056,702,'2024-10-19 11:27:44'),(1172,1056,651,'2024-10-19 11:27:44'),(1173,1057,600,'2024-10-19 12:07:53'),(1174,1058,71,'2024-10-19 12:23:23'),(1175,1058,495,'2024-10-19 12:23:23'),(1176,1058,208,'2024-10-19 12:23:23'),(1177,1059,71,'2024-10-19 12:25:47'),(1178,1059,495,'2024-10-19 12:25:47'),(1179,1059,208,'2024-10-19 12:25:47'),(1180,1060,71,'2024-10-19 12:39:46'),(1181,1060,495,'2024-10-19 12:39:46'),(1182,1060,208,'2024-10-19 12:39:46'),(1183,1061,702,'2024-10-19 13:20:17'),(1184,1061,651,'2024-10-19 13:20:17'),(1185,1062,651,'2024-10-19 14:03:23'),(1186,1062,702,'2024-10-19 14:03:23'),(1187,1063,312,'2024-10-27 14:45:41'),(1188,1063,438,'2024-10-27 14:45:41'),(1189,1063,362,'2024-10-27 14:45:41'),(1190,1063,347,'2024-10-27 14:45:41'),(1191,1063,211,'2024-10-27 14:45:41'),(1192,1063,428,'2024-10-27 14:45:41'),(1193,1064,495,'2024-11-17 13:36:48'),(1194,1064,109,'2024-11-17 13:36:48'),(1195,1064,71,'2024-11-17 13:36:48'),(1196,1064,618,'2024-11-17 13:36:48'),(1197,1065,495,'2024-11-23 07:52:30'),(1198,1065,109,'2024-11-23 07:52:30'),(1199,1065,71,'2024-11-23 07:52:30'),(1200,1065,157,'2024-11-23 07:52:30'),(1201,1065,618,'2024-11-23 07:52:30'),(1202,1066,71,'2024-11-23 10:09:42'),(1203,1067,495,'2024-12-20 12:06:35'),(1204,1067,157,'2024-12-20 12:06:35'),(1205,1067,208,'2024-12-20 12:06:35'),(1206,1068,495,'2024-12-20 12:40:29'),(1207,1068,157,'2024-12-20 12:40:29'),(1208,1068,208,'2024-12-20 12:40:29'),(1209,1069,495,'2024-12-20 12:43:08'),(1210,1069,157,'2024-12-20 12:43:08'),(1211,1069,208,'2024-12-20 12:43:08'),(1212,1070,451,'2024-12-24 12:34:00'),(1213,1071,451,'2024-12-24 12:35:31'),(1214,1072,160,'2024-12-25 10:18:53'),(1215,1072,71,'2024-12-25 10:18:53'),(1216,1072,89,'2024-12-25 10:18:53'),(1217,1072,213,'2024-12-25 10:18:53'),(1218,1072,533,'2024-12-25 10:18:53'),(1219,1072,145,'2024-12-25 10:18:53'),(1220,1072,183,'2024-12-25 10:18:53'),(1221,1072,472,'2024-12-25 10:18:53'),(1222,1073,495,'2025-01-02 11:23:25'),(1223,1073,157,'2025-01-02 11:23:25'),(1224,1073,208,'2025-01-02 11:23:25'),(1225,1074,161,'2025-01-15 09:26:59'),(1226,1074,316,'2025-01-15 09:26:59'),(1227,1074,176,'2025-01-15 09:26:59'),(1228,1074,286,'2025-01-15 09:26:59'),(1229,1075,161,'2025-01-15 09:28:55'),(1230,1075,316,'2025-01-15 09:28:55'),(1231,1075,176,'2025-01-15 09:28:55'),(1232,1075,286,'2025-01-15 09:28:55'),(1233,1076,161,'2025-01-15 09:30:53'),(1234,1076,316,'2025-01-15 09:30:53'),(1235,1076,176,'2025-01-15 09:30:53'),(1236,1076,286,'2025-01-15 09:30:53'),(1237,1077,161,'2025-01-15 09:51:27'),(1238,1077,316,'2025-01-15 09:51:27'),(1239,1077,176,'2025-01-15 09:51:27'),(1240,1077,286,'2025-01-15 09:51:27'),(1241,1078,649,'2025-01-30 13:36:49'),(1242,1078,366,'2025-01-30 13:36:49'),(1243,1078,405,'2025-01-30 13:36:49'),(1244,1078,397,'2025-01-30 13:36:49'),(1245,1078,239,'2025-01-30 13:36:49'),(1246,1078,402,'2025-01-30 13:36:49'),(1247,1078,390,'2025-01-30 13:36:49'),(1248,1078,407,'2025-01-30 13:36:49'),(1249,1078,363,'2025-01-30 13:36:49'),(1250,1078,290,'2025-01-30 13:36:49'),(1251,1078,622,'2025-01-30 13:36:49'),(1252,1078,227,'2025-01-30 13:36:49'),(1253,1078,288,'2025-01-30 13:36:49'),(1254,1078,159,'2025-01-30 13:36:49'),(1255,1078,621,'2025-01-30 13:36:49'),(1256,1079,649,'2025-01-30 13:38:25'),(1257,1079,366,'2025-01-30 13:38:25'),(1258,1079,405,'2025-01-30 13:38:25'),(1259,1079,397,'2025-01-30 13:38:25'),(1260,1079,239,'2025-01-30 13:38:25'),(1261,1079,402,'2025-01-30 13:38:25'),(1262,1079,390,'2025-01-30 13:38:25'),(1263,1079,407,'2025-01-30 13:38:25'),(1264,1079,363,'2025-01-30 13:38:25'),(1265,1079,290,'2025-01-30 13:38:25'),(1266,1079,622,'2025-01-30 13:38:25'),(1267,1079,227,'2025-01-30 13:38:25'),(1268,1079,288,'2025-01-30 13:38:25'),(1269,1079,159,'2025-01-30 13:38:25'),(1270,1079,621,'2025-01-30 13:38:25'),(1271,1080,495,'2025-02-02 12:56:53'),(1272,1081,495,'2025-02-02 12:58:58'),(1273,1082,140,'2025-02-28 13:12:28'),(1274,1083,140,'2025-02-28 13:14:18'),(1275,1084,366,'2025-03-04 19:26:03'),(1276,1084,239,'2025-03-04 19:26:03'),(1277,1084,288,'2025-03-04 19:26:03'),(1278,1084,405,'2025-03-04 19:26:03'),(1279,1084,363,'2025-03-04 19:26:03'),(1280,1084,622,'2025-03-04 19:26:03'),(1281,1084,397,'2025-03-04 19:26:03'),(1282,1084,649,'2025-03-04 19:26:03'),(1283,1084,407,'2025-03-04 19:26:03'),(1284,1084,390,'2025-03-04 19:26:03'),(1285,1084,621,'2025-03-04 19:26:03'),(1286,1084,227,'2025-03-04 19:26:03'),(1287,1084,159,'2025-03-04 19:26:03'),(1288,1084,402,'2025-03-04 19:26:03'),(1289,1085,366,'2025-03-04 19:28:24'),(1290,1085,239,'2025-03-04 19:28:24'),(1291,1085,288,'2025-03-04 19:28:24'),(1292,1085,405,'2025-03-04 19:28:24'),(1293,1085,363,'2025-03-04 19:28:24'),(1294,1085,622,'2025-03-04 19:28:24'),(1295,1085,397,'2025-03-04 19:28:24'),(1296,1085,649,'2025-03-04 19:28:24'),(1297,1085,407,'2025-03-04 19:28:24'),(1298,1085,390,'2025-03-04 19:28:24'),(1299,1085,621,'2025-03-04 19:28:24'),(1300,1085,227,'2025-03-04 19:28:24'),(1301,1085,159,'2025-03-04 19:28:24'),(1302,1085,402,'2025-03-04 19:28:24'),(1303,1086,495,'2025-03-06 07:23:43'),(1304,1086,157,'2025-03-06 07:23:43'),(1305,1086,618,'2025-03-06 07:23:43'),(1306,1087,621,'2025-03-20 18:55:50'),(1307,1087,622,'2025-03-20 18:55:50'),(1308,1087,363,'2025-03-20 18:55:50'),(1309,1087,288,'2025-03-20 18:55:50'),(1310,1087,366,'2025-03-20 18:55:50'),(1311,1087,239,'2025-03-20 18:55:50'),(1312,1087,397,'2025-03-20 18:55:50'),(1313,1087,407,'2025-03-20 18:55:50'),(1314,1087,382,'2025-03-20 18:55:50'),(1315,1087,405,'2025-03-20 18:55:50'),(1316,1087,227,'2025-03-20 18:55:50'),(1317,1087,159,'2025-03-20 18:55:50'),(1318,1087,390,'2025-03-20 18:55:50'),(1319,1087,649,'2025-03-20 18:55:50'),(1320,1087,402,'2025-03-20 18:55:50');
/*!40000 ALTER TABLE `tempRequestVendors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tempUser`
--

DROP TABLE IF EXISTS `tempUser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tempUser` (
  `tempUserId` int NOT NULL AUTO_INCREMENT,
  `tempUserPhone` varchar(255) DEFAULT NULL,
  `tempUserCode` varchar(255) DEFAULT NULL,
  `otp_generation_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`tempUserId`)
) ENGINE=InnoDB AUTO_INCREMENT=835 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tempUser`
--

LOCK TABLES `tempUser` WRITE;
/*!40000 ALTER TABLE `tempUser` DISABLE KEYS */;
INSERT INTO `tempUser` VALUES (789,'785476014','68922','2024-10-18 06:35:25'),(796,'772268684','57281','2024-10-30 13:24:23'),(805,'780068360','78392','2024-12-17 03:31:42'),(807,'779371471','35698','2024-12-22 13:03:33'),(808,'781136108','97370','2024-12-23 19:20:29'),(810,'791313220','69952','2024-12-24 20:02:08'),(815,'797646464','12721','2025-01-17 03:42:56'),(828,'792003614','26827','2025-03-05 03:24:04'),(829,'775788963','44585','2025-03-13 15:36:55'),(832,'778800000','38729','2025-05-23 12:12:48'),(833,'793377727','23446','2025-07-19 07:54:24'),(834,'782605651','66251','2025-07-19 13:27:24');
/*!40000 ALTER TABLE `tempUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `provider_id` int NOT NULL,
  `amount` int NOT NULL,
  `payment_method_id` int NOT NULL,
  `timestamp` datetime DEFAULT CURRENT_TIMESTAMP,
  `transaction_type` enum('credit','debit') NOT NULL,
  `order_id` int DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `admin_id` (`provider_id`),
  KEY `payment_method_id` (`payment_method_id`),
  CONSTRAINT `transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`userId`),
  CONSTRAINT `transactions_ibfk_2` FOREIGN KEY (`provider_id`) REFERENCES `users` (`userId`),
  CONSTRAINT `transactions_ibfk_3` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transactions`
--

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `userId` int NOT NULL AUTO_INCREMENT,
  `userRole` enum('customer','vendor','admin','subAdmin','viewer','sales','crm') NOT NULL,
  `userPassword` varchar(255) NOT NULL,
  `userMobile` varchar(15) DEFAULT NULL,
  `userEmail` varchar(255) NOT NULL,
  `userFirstName` varchar(255) DEFAULT NULL,
  `userLastName` varchar(255) DEFAULT NULL,
  `userCreatedAt` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `userPic` varchar(255) DEFAULT NULL,
  `userStatus` enum('active','inactive') DEFAULT 'active',
  `userVerificationCode` int DEFAULT NULL,
  `otp_generation_time` timestamp NULL DEFAULT NULL,
  `userAddress` varchar(255) DEFAULT NULL,
  `userFcm` varchar(500) DEFAULT NULL,
  `userCredit` float DEFAULT NULL,
  `userState` varchar(255) DEFAULT NULL,
  `userLatitude` decimal(10,6) DEFAULT NULL,
  `userLongitude` decimal(10,6) DEFAULT NULL,
  `userVerifiedStatus` varchar(100) DEFAULT NULL,
  `userAppversionNumber` varchar(100) DEFAULT NULL,
  `platform` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=740 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'admin','$2y$10$vlha0AqxyGjRS0VXTMLQCO8OeyyRVBuk8N4SFbdNAghM1Nje5amq.','3955088','admin@admin.com','mohamad','mrad','2023-11-27 12:51:24',NULL,'inactive',12031,'2023-11-27 12:58:06','jordan','uuuuu',15,'Amman',33.775063,35.889796,'enabled',NULL,NULL),(48,'customer','$2b$12$RXC6NNZVKVORZCJDocbUr..wfIKuNkhK.Mlvy8F5LAps35NqfMIte\r\n$2b$12$RXC6NNZVKVORZCJDocbUr..wfIKuNkhK.Mlvy8F5LAps35NqfMIte\r\n','782303071','alaa.alzaibk@gmail.com','alaaa','customer','2023-12-26 15:19:04',NULL,'inactive',52859,'2024-10-13 20:24:25','Italian Hospital St 76, Amman, Jordan','fQ8IAenFTRiEqLmO0gVVDS:APA91bG_XeQCT1aakb6zsVQ1iFA1Ld0FuOodelvr5_J7k8XBm_jRMHN0oC1Mbe7q3nVVGcE82j5JD0uOV0gyRatWoK8fkDG7wh2xWLarlq0lnKDuCz4VU04',NULL,'Amman Governorate',31.944366,35.929668,'enabled','1.0.13','android'),(63,'vendor','$2y$10$5JGpOEviSvLw0aesT31qt.iyOxcLzn2tDeX6teaASz5DuU1qAKEw6','781799992','mostafaspotify29@gmail.com ','Mustafa ','lgzawi','2024-01-15 10:21:45',NULL,'inactive',54152,'2024-03-26 10:46:17','Abdali Amman, Amman, Jordan','fL9I0P6URCOBv7UPv-wVtT:APA91bF3j73g98wiAVQn7NbZH2cOTBwMTAgIOmJvta-d9d7WNcKAOW04VYUD10rA-gFGAQdzU-02lOHywgoeOoL88LiqXbJuAjvvX83xkgAbqU5u2BhnmKY',3.6,'Amman Governorate',31.958967,35.918076,'enabled','0.0.1','android'),(64,'vendor','$2y$10$/o5XRNSD6yn5tt0sSvimH.kr8zpMOZ8pUgtWErXgJKc.kI71jj8uG','795119611','nasrallahahmad02@gmail.com','Ahmad','Nasrallah','2024-01-16 07:29:53',NULL,'inactive',NULL,NULL,'WXHP+XR2, Al-Jusoor Al-Ashra St, Amman, Jordan','eoEGMILpSZKVUd5l81W2t1:APA91bF8oVkQS1hTxT5L_TdBzO5L3ciVjRntzYy6ODCV3_zHnSaVMLhl5Ll0BxKJfdoCtsv3weH7sefdMtl98jlof3ycX7aLa5AQgAN9J1z_ACVZmyyDquw',0,'Amman Governorate',31.929647,35.987135,'enabled','1.0.15','android'),(65,'vendor','$2y$10$xScP5rdlU.KnJcWDi66WYOukBLsK/k6yLCBwHLCggKK9JjWauCrC2','797715306','sharkljnk7000@gmail.com','yazan','abo sherbi','2024-01-16 08:02:52',NULL,'active',NULL,NULL,'Damya St. 35, Amman, Jordan','dInohxkaRj6kqNOpKGGzqT:APA91bHhLR3tZs9h8MMwOC1CJXgda8GXWA0nwOnIeyUH3PeJL7SpMffz8punpujKwWpO1Yzq31vq9j9uEz16nGM64RFBuhO_tn5mtPse5bqFmuSeXjtWRu_msnaj_JI7WLJZBBCm1xPG',0,'Amman Governorate',31.974950,35.929172,'enabled',NULL,NULL),(66,'vendor','$2y$10$Y4y/a8SFrhZhF/18nTZab.I5xh2vNxBPJmowzIBAiHRKGFy.zdw/i','796206575','waseewwwwoo99@gmail ','wadee','salah','2024-01-16 08:47:06',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 18, Amman, Jordan','dr3ox2NyQEe6wCTrQMScAq:APA91bEmUsq_yo4BOvZxCXVUWyVntD3qgWF82RmawvMtewQMDZ0Hy68RrsythyDNcyf1VBr5iU9bHDN-Pm44JhPckB0OJU6Moh9uGxKj61mZBoQBkC-8oA0IdO3upH7yln-GrPz28D5H',0,'Amman Governorate',31.989801,35.871353,'enabled',NULL,NULL),(67,'vendor','$2y$10$8ILnche9F9GQ6wDvQHfkI.4GRIIVZr5QpYOswVPoyjiMCmV0iN7.u','799675727','thaeraalkahatab@gmail.com','Thaer','alkhattab','2024-01-16 11:03:09',NULL,'active',NULL,NULL,'Al-Madina Al-Monawara St 49, Amman, Jordan','c9qczPBPRaWmwlwhi97tyW:APA91bEpTg-lcwykIhq6E07fogzhBR_zAfGN0PJB3R_l4V1gZg-lnenJdWQEHRazxqIBuIFV-aXdwfUhILvVdwaL7jHDQ9TE7jlbl4EtatRBPo95N_ALtRuj_d12ya2V3imoC9r9EGcg',0,'Amman Governorate',31.966258,35.863557,'enabled','1.0.15','android'),(68,'vendor','$2y$10$ebbzafh.K5P8mRUTkRIso.LDaqHkuWMRtl981MCrFeMDH2IDLLOai','777303017','rafatawad1112@gmail.com','رافت','عوض','2024-01-17 06:54:44',NULL,'active',NULL,NULL,'WWRW+C5G, Salim Al-Yaaqoubi St., Amman, Jordan','cAzXssffTs6_aJLrT0dJL-:APA91bGxXzrLlHW5wTnHDjpAswqBXo9hcMpuP5CdcExG25FNVoXhBuVvc1COMDHHdUzD3TyGNI8Z4aI3GNJYrxupDfy5OkcouNEwA6HbWEyNzDo-nxvJb06_gLA7Mqcsz0NYCC9xmeFJ',29.5,'Amman Governorate',31.940978,35.945183,'enabled','1.0.15','android'),(69,'vendor','$2y$10$9CFY/YW8zuMmpHQNzzsvI.vZVOmb87/RaVJYh8tu.T0Z7/Q54QNkq','797684286','Mohammadariqat55@icloud.com','Mohammad','ariqat','2024-01-17 08:14:08',NULL,'active',NULL,NULL,'RMW9+H2 Ar-Rawda, Jordan','cCEkM-i5S3WJWeb22df82q:APA91bFQcrMxb1x6XpNMXIW6uyUUJnRRxmnUEL-VrLt7SBfPQlrRcBLZM00fQj-yIK8yxdTtJPF0or-0RUQjCUdRgMk8COoNK_lYnqfcIWHezcUXNTK-OnAOS1nFQ2CK8Rw09EzenkkK',0,'Balqa Governorate',31.846422,35.666851,'enabled','1.0.15','android'),(70,'vendor','$2y$10$MLr1vv.mMxYKYi25KwOBOeLDBGypbptCTP4Oc3QnJLHtZq3tEc822','798029152','greenflamegas123@gmail.com','Ahmad','Abo sary','2024-01-17 09:56:11',NULL,'inactive',NULL,NULL,'WW42+5MP, Hasan Farraj St., Amman, Jordan','dXdDbOL5Qrq2vab7h2UQtS:APA91bGMb25isFBzg7MfL05tApCGkWO-w0v68XeEM08eGv9I503fpQu86jNOfM46_XVZxIXJBNo0XodWP1xgwZwm0ICR4V0rSvtoGbo403petSlDSK7Z2yFuni9Upp1YsH5myeBLlYFo',0,'Amman Governorate',31.905437,35.901907,'enabled',NULL,NULL),(71,'vendor','$2y$10$/o5XRNSD6yn5tt0sSvimH.kr8zpMOZ8pUgtWErXgJKc.kI71jj8uG','798029151','tarekalshobaki@icloud.com','Tarek','alshubaki','2024-01-17 10:06:22',NULL,'inactive',NULL,NULL,'WV5R+WH Amman, Jordan','eoEGMILpSZKVUd5l81W2t1:APA91bEk0qKIS-Le_Kz55SC09QhWZTg4hzSXEqeyYjkYOdp43soIhGrFnNiKFQaC6-g00uN97FFHz99ViSAFuwEwuOk68PO8JX-AjbiqfI4ATLYARDxJDtU',0,'Amman Governorate',31.909813,35.891384,'enabled','1.0.15','android'),(72,'vendor','$2y$10$AkKvFqgUoc/u2HioXDe5G.g8blQD/eOKFTvZEzpOxbIdblgS8B4Ce','786165370','ggold6049@gmail.com ','khalid','najjar','2024-01-18 08:16:26',NULL,'inactive',NULL,NULL,'3RGW+WM Al Hanou, Jordan','dgUoT9ypQY2Fdp4hkzgo5k:APA91bFlAPce62UJtFOhsgqYvyncLEx9UyYuA8oYjjS1LCo_-U74yi4265-1vUih3EcIIUMQL_yLj1ScKwsan8SODfNlbb5s6KUFBdFfeYLF-ZP3lxJlcad9XQLso51f0iuWHcZxtH1z',0,'Balqa Governorate',32.077295,35.846675,'enabled',NULL,NULL),(73,'vendor','$2y$10$2A1gvz8GqBVLwUCTOieohuhrUJMxrlvGLkTEET5.eqAruSK/BE4ny','795124484','albadyt71@gmail.com','hekmat','sakarneh','2024-01-18 09:29:33',NULL,'inactive',NULL,NULL,'XQCP+98, Amman, Jordan','cdJLucrMSAKeEpLyvAPb9j:APA91bGIO5bLJwUDQOOCr4rgh7qJ0TAOq_iAVKCVBCBAwVGz8h8PS4B8tAF6_3TrYZJ4dcMWtrSwLzHUmxvwNC8w4_aIyQL0FihoLsJemG6lK94icbBkAJSFpsWTUxzhjjD60sLf4LC2',0,'Amman Governorate',31.970647,35.785986,'enabled',NULL,NULL),(74,'vendor','$2y$10$BclW7tdHFtaYlkwM5dApheF0MS4Kz5i4zctfCS1XZ.X9sNQgXsLA.','799554694','mohammadsulaym123@gmail.com','Mohamad','abdulrahman','2024-01-20 11:19:16',NULL,'inactive',NULL,NULL,'XVGM+HPF, Amman, Jordan','eo9EJn9NQeebCh7V4dyBoV:APA91bG6lQrlQUYjh9XzwMXLvMlvI86w4Fmpd5KWOC0FPto0eu8Gi5obGaKgybpUc6k-M4CCSmvmfWQi8NeNOYBUYlMCkPtjypCb7rpxyTduRrqMvFRPf3Qw8hv6iqiy4fe4WQaJn8Z9',0,'Amman Governorate',31.976424,35.884367,'enabled',NULL,NULL),(75,'vendor','$2y$10$2gbJb18UFtEK8ePp5UnCruHYwzsgm5TpxEPTar/ZMRL8XDfFFITWe','000000000','aa@aa.aa','alaa ','alaa','2024-01-20 12:30:22',NULL,'active',NULL,NULL,'Wasfi At-Tall St. 139،, Amman, Jordan','d7haFDm3RyGXd9dI5MndnS:APA91bHBGRTQ5oqcFhcBV22eAuUxIfIyTzuFW4nHU0T9S5P3L7ipYRtpr9Z7X-AQ8jEonrsQ8VNRGmT4tvVaX7enhIf_SvDLR3EsNM9BP1IN434dIBImwc-KcjBChcfrr7DibXAgv-Sc',0,'Amman Governorate',31.989899,35.871399,'enabled',NULL,NULL),(76,'vendor','$2y$10$FM4nZEsTZjROwVEIMzGH3.0fZoHyQP.ifMMRCnjtKHENCknj12h3G','780108301','s3982068@gmail.com','fayez','manaseer','2024-01-21 08:15:55',NULL,'inactive',NULL,NULL,'شارع عامر بن مالك مجمع الزيادات التجاري مبنى ٧١ مكتب رقم ١٠٢ الطابق الاول, عمّان،الاردن، Amman, Jordan','egn5aoBdRjGSrDeEbTSliu:APA91bGV1iIImAwPcOWPytuB352nFxwFq57nAXs7rRg8W8OBg6xvRkO39ySvMGQFT2g7d8axkdNwdFOiyUdb8KqbJtAEJ3IUgcV0z2Jl79Hhg5cdQCYXPOuj1aDY8cPxz-fHWxNcVsLd',0,'Amman Governorate',31.991494,35.849062,'enabled',NULL,NULL),(77,'vendor','$2y$10$dIBNw.SmHgOPpQczjzDwW.VJ03CzdSQXvbMQhqvdf7VSLBR3AQoWS','797791314','sadamsahory1jz@gmail.com','sadam','surakhy','2024-01-21 10:40:05',NULL,'active',NULL,NULL,'WWH3+34F, Salim Al-Jazaeri St., Amman, Jordan','ciWGS7MPTHeOeEWK0eK_uY:APA91bEP0gGaRBxVfEMxIzWOKZi5UfSLWnA_lxXgOY7du7qTToYe8wM_EDpyC_9klwCZZSMHrGpb1bBWin7rLnUHGvzpyayLn0wEVK53r-7umluMCS6nyQFvHV-cUHkg7-WCtFRp0OAm',0,'Amman Governorate',31.927721,35.902775,'enabled',NULL,NULL),(78,'vendor','$2y$10$0fGTwYOYcmOBVj5HEudLN.h0t1tIkFLj47eONI3MbY7XEtOP5T8Mm','797475703','hymwrly01@gmail.com','ali','hamour','2024-01-21 12:08:24',NULL,'inactive',NULL,NULL,'Nour Ad-Din Zenki St. 129،, Amman, Jordan','fxCq4RRuQ4628ANKn5YKk5:APA91bHPif8M27ORgn-pD-aWlhmpqLaCRqhFVu85253JoegOyMyc2WxtJxcWlHAAhkjYPRD9-SrKUaBRC6cY0YaIeI5DuwCIy1faj6cWT-uz3GXmOdEcASRu3n4WMXXqIaoDJqAVDHA_',0,'Amman Governorate',31.946563,35.913948,'enabled',NULL,NULL),(79,'vendor','$2y$10$iAIJjCEQThemO5PsJcfhjOhK1sSwSWKFMD6X4nJoqVNpKqJb0JORO','791441506','tamaramobile@gmail.com','عادل','علي','2024-01-21 12:34:12',NULL,'inactive',42386,'2024-05-09 05:30:36','Complex No 60 Saif Al Dawleh Al, ش. سيف الدولة الحمداني 60، عمّان، Jordan','fXb1Bz5ITM2HhJE9g_ZT7Y:APA91bHV0xshVuWzDWejyzmO2kmjsU1CpwlfpNNfGmBeDTy9klbadhh_GUpkdh3v6BZZyYBV-Q0rHcYSqHu0j8hE6oOQ-eFaTSrIwXo_1o1znKoQxg00gcSa4m92gymrCnxPn58nQYBB',0,'محافظة العاصمة',31.941692,35.919081,'enabled',NULL,NULL),(80,'vendor','$2y$10$AJH5MzWm9GtvHGYtL0mxcutnaicPe5ZzGmW0ievprh1Flnzz6SRLa','791985360','Mohammedshaher132@gmail.com ','nohammad','basher','2024-01-22 08:10:03',NULL,'active',NULL,NULL,'ش. أبو العلاء المعري، عمّان،،, XWCJ+26G، عمّان، Jordan','eStNlu3DScC-O-ZD2AMbce:APA91bFJ0KEna8YMi7INjls4XxcItIHbBdnHGkvbEVGlLpa6al_cb6rGOyxWY3Qpy611VPD24wsJKdABK0C80_PB10H6sZS8Z58fgMlAr-bd70gBR_v3OMdG1Qv2INPIc3cluuIwZyqg',0,'محافظة العاصمة',31.970100,35.930536,'enabled','1.0.15','android'),(81,'vendor','$2y$10$ov2CqfBNsuZTECSu/F8ii.izivULhiE6RNF8qGa/TZqjqkWyo8fQe','795855260','fadyalramhy806@gmail.com','fadi','alramhi','2024-01-22 09:00:26',NULL,'inactive',NULL,NULL,'WWQJ+FWH, Abu Dhabi St., Amman, Jordan','dVXJbERAS4uh2_vkOW3uc0:APA91bE6uviIKeqDO3NaHM8WeetIBkxdrvcPcYBDP-IIKH4Ftlndi9P3wxydn0sqZf3_OHXrzaB0bgBGb9a6oRO3plx9xhLgg78K-rmhad0C1uslIDTB9d3pj4Q0YZqSuOfm23W1CsnU',0,'Amman Governorate',31.938893,35.932186,'enabled','1.0.15','android'),(82,'vendor','$2y$10$puyaJl97hSRtMlEJykWHfOiUBNJFpNvELuMT1l2hnL3uZdQ8buDn6','791162126','slymalkatwat@gmail.com','معاذ','الدن','2024-01-22 12:14:12',NULL,'inactive',NULL,NULL,'النهارية،، WXF3+R2G، عمّان،، Amman, Jordan','fIqXwBM5TyybuLBeF7V6nl:APA91bGayUlLCxvAc8yJ03pVzxt4oYlK3Bas8GJBVRh3QAv-9z4VoWvQnxNdgS23d2D-vGwjHZZhOnN1K8MpJyESkkRPZgftI6NGj2JIRoNgT6Wy_LgGzMaeNepqkByG2v-9EWexZgLI',0,'Amman Governorate',31.924379,35.952998,'enabled',NULL,NULL),(83,'vendor','$2y$10$yquvcBZX4mJ5w1vag9Sx0eQj3xKrchs4AnKzlHUt4TB2d0lz9ZFry','797269187','sydaldn05@gmail.com','سعيد','الدن','2024-01-22 12:19:42',NULL,'inactive',NULL,NULL,'القويسمة، عمّان،، WXG2+24X, Amman, Jordan','clBjzX43Sn-dgIsCzqBI5z:APA91bG1QudE_ypmc1Vy7zl3J9sXOu5j9_Obrf7JfTgpwf45zQAIK3hv1DfabpUiavJ-En7rg7ucV-aPLxGJ-4i5hyaYDpDihxbdSKTH5bdueKtcdXB7FTKoY2fG2t9p2vPB5AwTHINp',0,'Amman Governorate',31.925015,35.950565,'enabled',NULL,NULL),(84,'vendor','$2y$10$i1Of8wfnDIB4jp7aUa4Hf.hDH3U6QEUpMXYg36kbs48dDi4Tjvp8i','781162124','mamwnaldn5@gmail com','مأمون','الدن','2024-01-22 13:10:29',NULL,'inactive',NULL,NULL,'WWMM+VGJ، شارع ذي المجاز، Amman, Jordan','d7haFDm3RyGXd9dI5MndnS:APA91bHBGRTQ5oqcFhcBV22eAuUxIfIyTzuFW4nHU0T9S5P3L7ipYRtpr9Z7X-AQ8jEonrsQ8VNRGmT4tvVaX7enhIf_SvDLR3EsNM9BP1IN434dIBImwc-KcjBChcfrr7DibXAgv-Sc',0,'Amman Governorate',31.934402,35.933723,'enabled',NULL,NULL),(85,'vendor','$2y$10$vi3AyTGXHmwGCZM0/plOBup4CoqUeQPrL/.HfSxivaMSEL4X8x66W','793002737','zubaidaaldouri@gmail.com','zubaida','aldour','2024-01-22 13:44:57',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 138, Amman, Jordan','eE-CkLGNTZKuz3gAkhT1jU:APA91bFfpPVkqFvJgMZLOe783VAJFTVKBEhfGyDQFBvUPniFkj_3dXLmJxF09rHMN93WTCCkG6lU9SaJlifBI65coxl0-H9Ea5Gi7x8qK8WVhkKKKkN4P-kd7mdQgzLTqzFyXVczYfjy',0,'Amman Governorate',31.989872,35.871463,'enabled',NULL,NULL),(86,'vendor','$2y$10$rVuxilVYgWcBop9Uf2SN0e.qymQMBlIPtF8YACVBB.mA7QtnTRQ5u','791305865','msbabwalyh1@gmail.com','روابي','المملكة','2024-01-22 20:44:45',NULL,'inactive',NULL,NULL,'VWQ6+MW8, Habar Ben Al-Aswad St., Amman, Jordan','fYJYf0w1TLaqpcG4gP4rg0:APA91bELeXvhgkMS04Sdft39xPAsHSFBbqM_6cxckkjrBqvNk5EQD7Mu3NgcfX7xS_zMyfoXeI9PkfUFyulcBmfEHK9V7WjXMQxEXv7VHwYcNWc-gIQRd2M-_WHUILm8RBI1xp6MgeEt',0,'Amman Governorate',31.889148,35.912334,'enabled',NULL,NULL),(87,'vendor','$2y$10$Xvjs8bpBxSqL8TLCXUgg6efSTYIbzdTlZISJbHMFOBYc8beeae672','797773294','ramiadwan03@gmail.com','رامي','العدوان','2024-01-29 10:39:46',NULL,'active',NULL,NULL,'ش. عماد أبو جاموس، عمّان،، Amman, Jordan','cZ1-8tSQQK6-7lsXnWJxsu:APA91bGtp78g7ziDVWv1eBX6NIq9aWYn0shBs6cz0S9HVxlKnDRBU-wrnicpMc91OihI-dgbMRzqX1JxUNVtR0s7Q9pzmktdzn_zyHXLRsGnPM2KJ_-wAFKahOACnP_Pd1bS77mdE2E2',0,'Amman Governorate',32.013019,35.938488,'enabled',NULL,NULL),(88,'vendor','$2y$10$f34HADHwRAHZpZrmmcUWkO7btMRG4DWhEEaYqx1gm1bMOAyYZxsvS','782303073','ali_f_jarrar@yahoo.com','علي جرار','جرار','2024-02-01 06:51:34',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 139،, Amman, Jordan','eiK6W782Tg2YHhK7HUI6f3:APA91bEINZnfNzr0Rc76MRTHXWssIQHlJ4AKSvreScL2-LkBBc0nCzZPuj9k-IEg-wkADDGjEAFJ8MltJoGEYjaK-VjOle704a7pdjUG91bESUBPPJ2-Unu0h_nCAywltWBRDDOLzm1x',-1.1,'Amman Governorate',31.989881,35.871408,'enabled',NULL,NULL),(89,'vendor','$2y$10$xTDVfa5xij.uuNsXDZIUtuR2I7ZbUUgayXjmTWuQjWMI0R49O1bte','786454708','ahmadsaed92@hotmail.com ','احمد','النشار','2024-02-03 07:18:29',NULL,'active',89003,'2024-03-27 11:51:52','VW9G+VG8 حديقةعون الشاعر، Amman, Jordan','fgbCejdJQLy2HJ3U8c1in1:APA91bFTMxepMTC0U5r4ZePUCFVh5n7t1WBCY7uBedzcMlfJLHNv38d8J_AbXYASlu8xjdsUhleJd2ceCfksrVVztfGPJszo-UwEgLfPrF0Iwq4WL3cTlf7wZECZiK6wF6n-Ty_ekk5L',0,'Amman Governorate',31.868339,35.926852,'enabled','1.0.15','android'),(90,'vendor','$2y$10$nv4g5YB/wy1uohE3s4DwYOXZAV0ZH9WyzxOW.ItS4LC7mFDuuolpC','795051561','hashemhashem2752001@gmail.com','هاشم','العيسى','2024-02-03 07:22:58',NULL,'active',93629,'2024-06-29 08:20:18','33GM+4H, Zarqa, Jordan','eblwE4InQrqXQ-xlHTsHnw:APA91bEPUBDsegSk6Tg9GieWVkDiUYxJnOeP4o9_Q74baW8ZM-0v4gj6-pVsN8I_Ry58Wa3K9SlIR7YLJuhOQnsWiRO2fcSO8Hi6QdotV4SM00osnc-FGMdKjLfywpD_jI4c-SQD_xxw',0,'Zarqa Governorate',32.075491,36.084304,'enabled','1.0.15','android'),(91,'subAdmin','$2y$10$VFtHb5p811cH4urnMhqsNOoanZLFJIFycQfn9cN0VoKHt8Xo00BMa','781799992','mostafaspotify29@gmail.com	','mostafa','lgzawi','2024-02-10 17:55:23',NULL,'active',54152,'2024-03-26 10:46:17',NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(94,'customer','$2y$10$txMoTVlH2B7KxdTl.CmtF.VwEK8tQ8J14nvgPbNBaVPOUoETrn5TS','777303012','nour.ardomly@gmail.com','nour','ardomly','2024-02-17 20:46:37',NULL,'inactive',NULL,NULL,'XV65+8R9, At-Tabashir St., Amman, Jordan','ezJrixMkSFuHoVDTwnjC8x:APA91bGVvGuGKEZNrzRgpQWbb5r7zrVkYoNynYXbM9MOrbP2YiW7ej0cuCkghR3CaCQFfXffk_oD2pBuaVcX0Kjj7VjNqd6mR--4w3YLoY0mD-3JY1uOJOYXK5llzt3-KlVXIBws36Xa',NULL,'Amman Governorate',31.960689,35.859613,'enabled',NULL,NULL),(95,'customer','$2y$10$4SIkMFVc7UgwnGhYGTWixeiizAFf25VLlMcqgR2ucv5sL2/Yp2/3S','787209154',' hamodaalsahore136@gmail.com',' محمد','الساحوري','2024-02-19 11:06:23',NULL,'inactive',NULL,NULL,'At-Taj St. 294, Amman, Jordan','f8FSsCPQRBuh9ioe2ucwB6:APA91bHA_hwbculWB9hCJSApyNH2y-sNK7XpdZ3S9dPxmDanwfsIoTG4A-J3jHmvcnYJZLAieNfERcP8SHMwebxlST5ETeagY_FGUWddZJnhzUDobWMrjZt8SdMxVDkB3i8ThyVLh6-h',NULL,'Amman Governorate',31.938806,35.938186,'enabled',NULL,NULL),(96,'customer','$2y$10$viB1wrnAF8MjpRTPOGO0l.bp5SsCcF7ml77xEhmI7PbnKM/6U.isO','797772576','Refatawad81@gaiml.com','رفعت','عوض','2024-02-19 14:35:29',NULL,'inactive',41641,'2025-05-18 08:16:07','Wasfi At-Tall St. 136, Amman, Jordan','eNbv4P6ORQqK90HYy-D6jk:APA91bFcjppCXWnOvl_K2-hV9rB9D7Y78XsLT7gAqPs-P4HYsnA0srHxoRaLdJKIxIR7pXv1NQJdjfIBT92BHx0-m0sOUQu5PsasssM3ABoxjkQwhDUwXlc',NULL,'Amman Governorate',31.990333,35.872035,'enabled','1.0.13','ios'),(97,'customer','$2y$10$zqkRSP39lSrf8wRXSOQxxOcjrZUUJ7fk5KAQoM45.LePIt91PWag2','777303016','qusaikhazaleh.qk@gmail.com','qusai','khazaleh','2024-02-19 14:37:30',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 18, Amman, Jordan','d7lPGTjvS4ezOT90Nuy90c:APA91bGD6zWEGFVetYr3y35cnyklZMq8ado-Sz5OOke9e4MqgNr2HdoBeqdwRF_Q8coeyvJCf0LeHWFgYXJ7Wv7NRbXJGBwGUHivkpCKloS3PcQsE0qXjgkqy1azt_u_FRtc7VfyRUFW',NULL,'Amman Governorate',31.989800,35.871347,'enabled',NULL,NULL),(98,'customer','$2y$10$QTEtpx5Gn/jIgAQnpbjGnOUGCUeAcnbfzhkETJ.WUMasmWnxhxO9.','795900299','bara9009@gmail.com','bara','atalah','2024-02-19 14:46:30',NULL,'inactive',NULL,NULL,'Al-Quds St. 124, Amman, Jordan','eL_hqVDhRpGf8uSh1uz4bP:APA91bENFb0K0epTG_yZqK44xmmOjVf8fpcg8mb3b4pssyx_KbUQ0OauWYRhmorjBj7HM5zl86IoN1fHPvA8joqnMkA82Ei506RLXcCk4CLuagJoJQFrm-d1g1bsI58EPZpjYA_kxzGv',NULL,'Amman Governorate',31.934558,35.922524,'enabled',NULL,NULL),(99,'customer','$2y$10$cqIH4h5204kwECMnt13r/u47i.PJ/ccxEFsVThy16vREo9HvKszwy','790450207','nagah.alyan@icloud.com','نجاح','عليان','2024-02-19 14:56:33',NULL,'inactive',NULL,NULL,'3R4P+V72, Ein Al-Basha, Jordan','fF88rrXAg0VTlaOTB-KMTQ:APA91bGphm7EzK4oXm_QItw7TLiKGHeeY3ze4pXAI3eqwgcNnXRDxuRcwEFLx3Jp4fSqmnKMHNlH2vz7GACKw-TXdLfFBiA6tR53WKqaeeAMJwloF6F6SPPE-R3tf9VikPmIiGm7RQbE',NULL,'Balqa Governorate',32.057122,35.835938,'enabled','1.0.10',NULL),(100,'customer','$2y$10$GKW18q7DKSLhir4zwG6r0.JdW/U4w5x1trOG2dkX9q8C4X0wRoYiS','791241724','rolasharar90@gmail.com','روان ','أبو شرار','2024-02-19 15:09:11',NULL,'inactive',NULL,NULL,'Al-Quds St. 124, Amman, Jordan','dcNG8l5vQg2V4tQjC8RVk1:APA91bH2zT5PttCI-vWR9xy2JhbXfpZMaXm7HGDxoNwaqzilTFmc0l_yC3yd5joWtJzjh7rbFjOEACBS7kphNDbolKCTJBo_uo3gou0kcDgJ4hRlwJVz2puy4usejErDkZ2SqmtaVu8i',NULL,'Amman Governorate',31.934560,35.922520,'enabled',NULL,NULL),(101,'customer','$2y$10$Ovx1NKu523oPUMfvsE2Nk.iXTfdca778TRwKS4joWg4bw.mey4ZWi','777303016','qusaikhazaleh@yahoo.com','qusai','khazaleh','2024-02-19 15:38:47',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 18, Amman, Jordan','fydX6GGPTNScvHF-XYWIPX:APA91bFTn_e-Pzg_BJE9Id0OhLkdU3xdUEYginOqeBAhwLnMd9y4b8mSCSyU--6jBQ78Rt_6F1D8yh3Mr_vVuHT5TGbDWfEq8oIKICFYp0ifQBzUabWOC1Muk2-P1gVexLyVgr0aDQIs',NULL,'Amman Governorate',31.989794,35.871357,'enabled',NULL,NULL),(102,'customer','$2y$10$dlZmrG2TSBjY2lRu.NkRUucR0lpPiz8ceeSU4vIs2quV3AA05./NS','792500023','rameznaffa@icloud.com','رامز ','نفاع','2024-02-19 17:50:45',NULL,'inactive',90478,'2024-03-21 09:49:57','2Q8W+P2, Fuheis, Jordan','e7Mr4YKiTRiW3ey09GBsaI:APA91bEM4EmT_TE771CQncFD69yEUNouzWmT2yA2WffDGPOK1tXkoJciQr7_M6q-TOPh218KFXL4iUfWzSWGbgjP6GYyPqVjY5ovPYk3iW4la8jV4XuLGy_jWFnlMjFGmW6cnsS5hDqr',NULL,'Balqa Governorate',32.016797,35.794339,'enabled','1.0.13',NULL),(103,'vendor','$2y$10$v78UGCW.D0zcl7Jccj6x9eEe1qVviHaLmNHeS.thsjWpql.nW45am','787470111','mohannadraetal@gmail.com','مهند','عليان','2024-02-21 07:54:39',NULL,'inactive',NULL,NULL,'XWMH+38F, Amman, Jordan','f_YhWBuyT1mVMnpc2IF6bU:APA91bFpDyel8tkmCT8YIzjPPKTbAYu0qn9jTLBzdVdP-iQcjbCTZvlMLJYXv1qp6Up8hUX0LZXhk6ZcQZaJAOD5MdW5enmnhTwE-baiJ1hsI59sHjI1pLIjNGyXyg3OFk-j3U2Khsa9',0,'Amman Governorate',31.983044,35.928279,'enabled',NULL,NULL),(104,'customer','$2y$10$fxSoqdEaWbqu34x/hCTQuelvQHmXf01mmci2eLJWcLFu/TbE8rO6i','797030464','mhmabuhamda','محمد','ابوحمدة','2024-02-21 13:39:11',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 18, Amman, Jordan','caLQImCTSMG3s85astDx3h:APA91bE5xGK7oWgqxMgvvFWXnkLlNx6j1jSXn6S3CpAaGQEV7CXCau8mLC-VU5Bj2yOTjQe8HPoCZUhzrrGHtEkgntHfxLdO0i0Gh5Pv6L7c_iarfVDovxcGh-rOQb9g7ouwMnBbVxlI',NULL,'Amman Governorate',31.989852,35.871351,'enabled',NULL,NULL),(105,'vendor','$2y$10$QsU3q37oJz52tHrMYQaAr.bZTIN07NdY9/4nWWAyHb6VnVoG1K6ZK','795169051','moshtakhadi@gmail.com','مشتاق','هادي','2024-02-26 07:51:08',NULL,'inactive',96345,'2024-03-30 11:25:50','2QCF+R9 As-Salt, Jordan','c34bwm9LS22AF6wdzlpMuv:APA91bEzovyMEtf72RefALoUnE6JyzZ43kZkFM4BRu3QXARk4YEAHdcTLakm01rEr7Uo7kKeQnYXB7-sbhvzh84EkowjPZ9Da7Jm7qT_4lvyA93whdeMCn_2f-ppfh8PJCCeI9SRZHG4',0,'Balqa Governorate',32.022100,35.773379,'enabled',NULL,NULL),(106,'vendor','$2y$10$orxjMx8QKe1sUkJzjhv3PegcEjtTSFZ31/LXHL9b6quxQeu722S/O','780712573','thaermoh954@gmail.com','ثائر محمد','فريد حسن','2024-02-26 07:58:26',NULL,'inactive',56588,'2024-03-30 11:15:55','2PWQ+QX5, As-Salt, Jordan','fJkiXnamQzCwrQUanXt0E9:APA91bFZYX7QZ2loBOidVwU11RnejY2ye32ub-ttdBqRkgGS-GqCN3yJ1UI77Vp8_hJpWm3bKopl0QXtr-X56H38ztnNMFV3Qvs87I5zkkFp-Lqp4UtMHQXzD_0TlLxsngHIgGUdDpoZ',0,'Balqa Governorate',32.047588,35.739925,'enabled',NULL,NULL),(107,'vendor','$2y$10$quRI.ICaRPWedGZBiv/CPus0XIJqfv/M/ctKpeJvb2mm.dMLXxRmu','776554841','alkhrabshhmhmd496@gmail.com','Mohammad ','Al Kharabsheh ','2024-02-26 08:13:08',NULL,'inactive',NULL,NULL,'2PVR+WHW, Q. Rania St., As-Salt, Jordan','epN-WO2UR9m0BNrydKZGH2:APA91bF2J3IkCJAMJUlvpGL4KwiWNWm0xG50bgjEHxqHFBZfs54zY4eyYL02RVqZMDKn1NuYEV8CVM5Zw8ZT-kWkjnnaqMhRgdHvTwEaURsm-_cIaroTeYcRQAnSUnMN0f2_HbNioWe5',0,'Balqa Governorate',32.044637,35.741230,'enabled',NULL,NULL),(108,'vendor','$2y$10$DknWxoFUsLvUmLkOIUqDAeWNZiEcaR/4azWnEPbaHynVDFeOpvTKK','790039376','thetower571@gmail.com','ابراهيم','خرابشه','2024-02-26 09:01:44',NULL,'inactive',NULL,NULL,'3Q3G+87F, As-Salt, Jordan','e3Dj3YlNQACXRfJCtw_Pj5:APA91bHphXqexeQwhnOcm8t7M2I9qLUNKR2JNSCaeNnuiYNXUAZDApJFkHxUmv6jwu90jSNp4iMA0ckvEhNZ6Dx1lbda0sKrmC3x5Xauoqrydc6GbEatLDJPYmiyOwlDdOGJkS3pV12k',0,'Balqa Governorate',32.053408,35.775892,'enabled',NULL,NULL),(109,'vendor','$2y$10$oa7Eh3A0uYoRGJA.anrrzOPBg580g9EByJ/WGO3urIqnRxsihuFbe','776861296','hasenbsam3@gmail.com','بسام','حسن','2024-02-26 09:02:49',NULL,'active',19166,'2024-07-04 13:22:01','PX8X+RP, Amman, Jordan','fky1qEllTeqQCOEfZ7kyhk:APA91bHxwNWDUfEQ1FkfeGluipHhHUdFYHlwohm_JPGuaVUxaqt17Zwd-yZkDAIQGtFIjbtvhLtHRAW-ZxqpV8oR4GagH2UqbkHht4D1F0-7LBC1z62NrjuDZ_39NwRfIM4gmDAPZXWX',0,'Amman Governorate',31.996656,35.668812,'enabled','1.0.15','android'),(110,'vendor','$2y$10$2cdc9zRq.6.PDT5JtiK.E.BdpVAC5dqQ8KKb7z7rACpbHuMmYFpsi','790412711','moh.mohammad212322@yahoo.com','محمد','فريد','2024-02-26 09:33:09',NULL,'inactive',NULL,NULL,'2QCF+VF As-Salt, Jordan','ckTIFMSRRaWnCNuEZlMftJ:APA91bGV5GNME3ZZWX4jxD9tS1NYkvUr2NqaAnr2VZvT6ZpVsRAkcJnBI6Rfb5KMqg-q_qVjjHchOhy-k-BtAn6ThbYqlppfFE_EXfqH1fqXTZuNqvVajgyfZq5XuxKg9f2kvNOd9kG2',0,'Balqa Governorate',32.022227,35.773689,'enabled',NULL,NULL),(111,'vendor','$2y$10$8n3LNA9etBiFqsc0EZP08uhMD8B3BaP0HpYGHlH/57Z.M6t3DtJ5u','790950724','mosayosef456@gmail.com','معتز','موسى','2024-02-26 10:37:57',NULL,'inactive',11589,'2024-08-20 06:10:38','3Q34+JX3, As-Salt, Jordan','dHLCOp9SSgusJ7jirdcPWV:APA91bGZhdihOhn_1tZCXiE9G35kBtBsWh-Kq7BoK2VpfeNOGp6eH1FfVi_onWcVIjDX3NgJReVrmY362ULklmFq3VyMt0LMhTyw4pNV08Mmcfqo1OnwM_C4MpYF1o-t3dj4hUvpPGMP',0,'Balqa Governorate',32.054054,35.757637,'enabled',NULL,NULL),(112,'vendor','$2y$10$JKBwmSuMaakSfLIuiVo7Be23BIjx8mtM.AjrLbkteATXQ646NiA7y','778677954','adammakamra63@gnail.com','ali','esmail','2024-02-26 11:03:58',NULL,'inactive',NULL,NULL,'2Q4W+9J2, Fuheis, Jordan','dqbDgGwATq-wjqXQoj9GUL:APA91bHouhxcCUpH4IOxJPi0pNn7z4BaQO7gngVDl4ddp1yC2-waXy8YMdJgCVoFlXdxR7EOfjEjIPSRHdjU0ymLdSR5OkkSNRVqc-fZhHMinjraMYfnbu_qg-meBv31Em3kdatoXAhs',0,'Balqa Governorate',32.006371,35.796115,'enabled',NULL,NULL),(114,'vendor','$2y$10$qaTRtqDh5X604uQlYK10z.hoK9VBvghdEwlMv7XPgzzFuevIq.3QK','779680805','rr9878542@gmail.com','رسلان','فريد','2024-02-26 11:09:07',NULL,'active',66391,'2024-03-30 10:50:59','3P6V+6JW, As-Salt, Jordan','cSw9-UTQQ_Ocol7tdRnlnj:APA91bHGtELubI1sj2KgsNR8ga3hPxY8fzufiE7_OK4eCD_UtQmT6aemQf8aiJT8yH4mpDBNv6aW9aE9MKGBQMDf10YSRfuYikPAWEU0aicB0YAJ1MExGaIJNyFmOtLkPZrmJn6T2LiG',0,'Balqa Governorate',32.060838,35.743204,'enabled','1.0.15','android'),(115,'vendor','$2y$10$xoKTrnhLcw9y/rElv8Nfj.80mcs9mhnIXzvz/FlcUMTgLFtpluGyi','775158195','mowhmadaboali@gmail.com','محمد','علي','2024-02-26 11:57:56',NULL,'inactive',NULL,NULL,'2PWR+W8R, As-Salt, Jordan','dsQa9_33TIOP5bZusZUKEp:APA91bHDYvopKO4zv0DOPEf0hbUA2_pOUl4sBgesSXhJ3k5mFm1A55mZaetvib0h3r2EooYHcpp-wuWmbLZhoC3Exp-iRmIoEAdtp_C5EPd3B8ZSzgOV7Kz8NnWekKfW6zlwIAJsweZ1',0,'Balqa Governorate',32.047336,35.740761,'enabled',NULL,NULL),(116,'vendor','$2y$10$57fso.k7v/nmZ.BDCXaoQ.DQhZmLkMc26fVGwNspAWQqFz5UKYy4K','790179498','moosamalek32@gmail.com','موسى','مالك','2024-02-26 12:37:43',NULL,'inactive',NULL,NULL,'3P64+RQ, As-Salt, Jordan','foSupQ3xQt-xEYHdlgGpnK:APA91bFWD7I_aTcHYw9j5jVI5g-zxMnTqVZlx42Vh5B5aGwpoTKygpa7Ft2-QnQbEiVysCl4G7WW3eYu_MGVGjWkumd_Zf7G4SGeNHzzQE2KtNZaP6bbiEmlGU9C7ivS2hXu_0-KHeAI',0,'Balqa Governorate',32.062467,35.707623,'enabled',NULL,NULL),(117,'vendor','$2y$10$fdBtwqp/DTUoBqP4/CkJR.SdW/CB/6chamfJb37V3Oi32ClQoiyae','796862701','vhffg649@gmail.com','ابراهيم','الشرايعة','2024-02-27 08:51:37',NULL,'inactive',NULL,NULL,'Abd Ar-Rahman Khalifah St. 12, Amman, Jordan','dSStJ1nOSraqkhkKbFOyGR:APA91bGt7KAhGdGOw6b-VJ5WAqpiJOoFHD4iML0t99qDOD_4BgAqze2A51FDgdbAItsF3TJgSMZeH3xO0uA4apr4W5ruxHt-j3t2zxBEJ9pWIRF6P3uZITLk-HpUHmNW8HNpPnQSGKMX',48,'Amman Governorate',31.960070,35.856903,'enabled',NULL,NULL),(118,'vendor','$2y$10$2KLDVYubXMG5/BYrzkjPKuYLTBMpHqCUzWeWkedEceQmeCVsAbVLK','795457251','moot709@gmail.com','محمود','اسماعيل','2024-02-27 09:00:13',NULL,'inactive',NULL,NULL,'XWHC+G32, Abdul Rahman Al-Ansari St., Amman, Jordan','d6lt0OQSQe-tnu9qqQ5rAj:APA91bH_mtYkLaO2VNOs-IIdMTAtvk12kTzYw7Calw47qGIjgowpmGH_0s2pOWY7cmu6ys4KzDYdYDAO4hOV5ITb7Zx3vRsHgIo8w8lTlhB_G_51V8LSAfILGNlstsAHtQQoBnXqHBw8',0,'Amman Governorate',31.978643,35.920375,'enabled',NULL,NULL),(119,'vendor','$2y$10$qAPlP1KSKt6S.0gKesfDjeMBut3ReVqA/mIHPMlgLZKF0zasN3Hiq','795824792','khderabuaresh@gmail.com','خضر','ابو عريش','2024-02-27 09:08:50',NULL,'inactive',38808,'2024-03-27 11:02:23','As-Sakhrah Al-Musharrafah St. 147،, Amman, Jordan','ezpW-3jMR6CwQRzZI__B-G:APA91bGk7a6pHGyvQce5Qpe-eFdzNNhqnaFkL96-YkjCLQXm-NDjqmqmpK8KhDbFUEaqwDY8Kw9DnMw9raw9Xqhl6GdZiEubVJNBUSRq3OjSKh6MA0PobKZ8xwif40nZ8xApT9u0n8xu',0,'Amman Governorate',31.914365,35.914946,'enabled',NULL,NULL),(120,'vendor','$2y$10$vcuUzy95.Slzp5izniseRefz2gPu3aa0BB7mvcQGp4zbwBa.A.4je','780496277','zezozezo909@gmail.com','عبدالله','يوسف','2024-02-27 09:24:43',NULL,'inactive',NULL,NULL,'2QCF+VF As-Salt, Jordan','dnYzzoY0Qt2Sj5kBrG9ISZ:APA91bF4bsFa-z-O1rvQbvY9ezPhNA9UhkJb7ZwZpRz-_ezxAW8V0_XS48SJp25qVo4E-S2BNcECnrUghrnhzNkzFbSBNfPCOHcZ64akm1Y5CLwObzesbiAPaCJYD4NnRg-84L_OdlZd',0,'Balqa Governorate',32.022232,35.773713,'enabled',NULL,NULL),(121,'vendor','$2y$10$R0x16BnO3sE87hlvZtkq3ORs22ejMUgtylkqraGBG3D7JyGSvrUTe','797110401','smy67731','طايل','المناصير','2024-02-27 09:31:34',NULL,'inactive',NULL,NULL,'XV59+3WG, Amman, Jordan','cOReEsqFQVOQi09lrMg7pc:APA91bEkW4RHPcF8oKPQNGWW8cJ7T74zuIWYBtWmVMcI5RW3JeSn5YZfd3s4tYmVafy2VHXQJb6Uhp9aQ4vBZuJgyMynZT0rDvGaLXNN0qHnEvsr7cEieUUYwWYrAIHrzpY2t6lDKFP4',50,'Amman Governorate',31.957736,35.869897,'enabled',NULL,NULL),(122,'vendor','$2y$10$w6pSMTit7miMjjnrviRyxu/Luo0mahZ9joTf1O1nobGnpKSvLZT5C','795543737','baderkhaled850@gmail.com','خالد','بدر','2024-02-27 09:40:26',NULL,'inactive',NULL,NULL,'VVM2+56Q, Amman, Jordan','chUFiTgPRQGYbmYDJgh5hq:APA91bEA0CvQszFSC95KRpapvWuWAXAWKfSzwuQAlo_MNsIJjfeXqFxY-LDxTyk5fAcWjT_oBtpHsKE-lg-YYgVQWI4CVANVVKLCHr6BhX0mDUFimBlZ7zqkKccVl7r1EO9eKK-06juI',50,'Amman Governorate',31.883377,35.850052,'enabled',NULL,NULL),(123,'vendor','$2y$10$r.TOfkCKLB/Yr3BO.6KRIeeBTytfbe1mQmc9lateejz5jlHhmFZR.','795640577','alhwramyn@gmail.com ','امين','محمد','2024-02-27 09:45:19',NULL,'inactive',NULL,NULL,'حمزة، عمّان،، XXRR+GQV, Amman, Jordan','egF7D-8nQ4iGGbQ9J7p4a8:APA91bGD3FAgB8iMJ_WSFzqS5t8iWM4jBHW8sSQMuNG9jhqPdOe7tyf7kFb_iCBTf4HNOT_liQdpi_wJL1b-MZVaEV1jIeIt280JH8iSYLoDfqgyUp-CRjpTBMEnF0RPaNcB31wJEYob',50,'Amman Governorate',31.991302,35.992062,'enabled','0.0.1','android'),(124,'vendor','$2y$10$EP.MRuMk/cdp6cvrBfOJUu7Qc6VWm8t/BrEa3BhsEJO.XNbjBGYLe','790331727','moshtakhadi2@gmail.com','معن','الخرابشة','2024-02-27 10:14:35',NULL,'inactive',NULL,NULL,'3Q2W+3MF, As-Salt, Jordan','eq1--HamSE-xEG1R_ipPW0:APA91bEAUG1Azzlq4CaPLzobNp2sBm9kMSHl-5qvwwcw-YVKTCeYaj1WhNZdX0PfYU1oZoW2UhqIyojNmIAsUN8Cfi8vTMEFxpVmAkH5b1p-cKaJlFLk3OaL84SbBeseNiW0nmFmgTwP',0,'Balqa Governorate',32.050216,35.796169,'disabled',NULL,NULL),(125,'vendor','$2y$10$gBuEoRZYK5KuQsuvvtvIoOuWuOIQhgaq4UnWf4zDk2cWaSVwukvyu','788834557','foazalmanaser@gmail.com','فواز','المناصير ','2024-02-27 10:31:35',NULL,'inactive',40117,'2024-03-05 14:16:18','Mawloud Mukhalles St. 35, Amman 11194, Jordan','fdTGKSGkT8ak-7Ws8MRCKz:APA91bF2Y5VJFDuP8o09dO874Oq8zWkB4ENAKOdx_Sd95uNUPfbDmMiK-L4MgKmeZ30s2ZkzPzZoJXtapzQV2jjfJFpKIDJ40RE2GR4nn9OcbJEZpaESZr4_CvewpDcN61Elyj_slczA',46,'Amman Governorate',31.957799,35.871200,'enabled',NULL,NULL),(126,'vendor','$2y$10$fuBgLvoMxF43UoZjrjr8ZOtOWRY6IQYqGJdOvmIsgkD.X7tbegN/y','776378990','elian23.jbor@gmail.com','عليان','الجبور','2024-02-27 10:52:24',NULL,'inactive',NULL,NULL,'XV4C+X6C, Prs. Alia St., Amman, Jordan','cidkbzwdTECuO71P8fNdT8:APA91bEA5FAXmAXLjRbphwnYGvgKfVyXLOXRMRDx89al1yAv5rXf--Or1qTcV9FoRvAZN4Cg_TKysKLgW2_L_HH4SXcVScS0NTB8w3ZrII6z58trt6l8kz_ej4_KFxVCISBADhomYn9n',50,'Amman Governorate',31.957367,35.870637,'enabled',NULL,NULL),(127,'vendor','$2y$10$pVKxYzV6dSxrOCuZkzT2ZOJ0uS7.JaBtv53C1Enoi5Tj03tzs1MNm','790832648','aseeem089@gmail.com','اسامة','عطية','2024-02-27 10:53:18',NULL,'inactive',NULL,NULL,'2WQJ+5VH, Amman, Jordan','fRlp_2SvQHWwP5UhhiQYAN:APA91bGxpowD1TL4RgG9FfteZJQSs2LaCi0uQ3lP8QHU41z46JjuqreL8e8HhwYuPPaA-H5Jv-uWLKoLHbyYZ5tRmx85GYuWhPY5RjIUeaeAZ3CnPnHtTbvjY9TXuUmSf4UdM5LVLsu6',50,'Amman Governorate',32.037166,35.931057,'enabled',NULL,NULL),(128,'vendor','$2y$10$daRpUi.LGVxzouieH4q1/.YAjNT5EDs9EWw347sSRDp8Z37SC.nRe','796608867','mwsyalshrayt@gmail.com','موسى','الشرايعة','2024-02-27 11:29:12',NULL,'inactive',NULL,NULL,'Rushdi As-Safadi St. 4, Amman, Jordan','caBtgY5FRP-5jsMpuHi8OL:APA91bEEaWLwNhClV2M5u0wfz8s06NG22XX1_s1twXbjqTP7NPhwUqaIhjf-hp83Hsa71R1zVEAH019tUsYs25ESR4E7xWsh-fvD_hjmXvZ5PePr44aHHGQ_HOEpRwbcGpqECGddgbRR',50,'Amman Governorate',31.958153,35.870175,'enabled',NULL,NULL),(129,'vendor','$2y$10$B7whD7RdHT4yhIYDHjtzO.0X0e8lK.89b.lNcZbmymdzmzyMQGtEi','797552430','dyalnyzat4@gmail.com','عدي','بركات','2024-02-27 11:54:31',NULL,'inactive',NULL,NULL,'Amman, Swefieh, Ofiice 718, 7th floor, Park Plaza, Salah Smihat ST Swefieh,الصوفية، Salah Al-Shemat St., Amman, Jordan','f3zC4PfkRVCC0I4Q7lS_gL:APA91bGzu0jGpdE3fTCcMeaooeXBdMAtySsLpS6Xi903jO1aX1yyPG3jKSOPj641j96KjktKpyJXWlWLPH6EqF12GOJDWRtFrywjVnwK4EoadAOjSW6M_FlLbcyjNi78qLnK_PAHxr1u',50,'Amman Governorate',31.958423,35.869192,'enabled',NULL,NULL),(130,'vendor','$2y$10$rAlKTPwU5vkybzWFy5qJyeGi3reuGOMMCcDRRwZQg2fmebhjFw7s2','785703901','khaldonk445@gmail.com','خلدون','المناصير','2024-02-27 12:55:45',NULL,'inactive',12133,'2024-03-31 20:28:47','WRWJ+JVM, Amman, Jordan','cpaW6pftQSKsL__xhqPKEl:APA91bE2mXjm_aCAVOkb8r06eMvb1qTjUCpZPO5uGP38Cgund9KDhJhgmJGx9-5RAoKxNEKxdDCygb2BkUQZ1jNjFX8RoxNy0dwVCxSdfvC-T8gQ-Duw5pMZ87YfYBVg8pWkDN8dCnrx',50,'Amman Governorate',31.946817,35.832022,'enabled','1.0.15','android'),(131,'vendor','$2y$10$zquVW33arHDNzRr3CRv47.kpT1yiIcB.ilg.1YXHvzzpqLrbumNa2','795002465','bkralhwr@gmail.com','بكر','محمد','2024-02-28 07:08:55',NULL,'inactive',NULL,NULL,'XXRV+G59, Amman, Jordan','enXqAw4GRf2KxyCsHGmJWl:APA91bEa6pZp_GWNGTX7JJHIVVaD80bSYqwlXSEZrJYUAXdlASPA1vEsso4ZpfDekZsa-W0D2VsUgGQiC52wOdG1KbcKeIOzAHzx5xkWOHi0iYSna0jl7O37MCFPjJsKvF12AH44hgvF',50,'Amman Governorate',31.991074,35.992938,'enabled',NULL,NULL),(132,'vendor','$2y$10$TEdQsmsN9ZxUyP9HoDbduOrwZVHMlLnW7nLFcuMctX48ZPtBe21xe','796243507','mhmdalfywmy552@gmail.com','محمد','ابراهيم','2024-02-28 07:49:09',NULL,'inactive',NULL,NULL,'Ammar St 21, Amman, Jordan','eZfwoHofRNWwt2_Jg2hlBB:APA91bEQBPsUQtn6T1qXdce7zf1eAAnDQWc5XuHMlrVw_Z03YOU078TocFOXgqTnGKr8_Cc3wpLgSycyaHek7zzYMEqEcdfplU-siubCT-ql2MXorkQvVm6xovjdH_5fF-09gW1hhLOA',50,'Amman Governorate',31.895841,35.834741,'enabled',NULL,NULL),(133,'vendor','$2y$10$2k0hGqRnWCYI50/bkqroIu7mgA7v3T0P0VxcUpZGkA0F3itkoYTnu','795926895','Salhaktot@gmail.com ','صالح','كتكوت','2024-02-28 07:57:53',NULL,'inactive',NULL,NULL,'22GG+JP3, Russeifa, Jordan','e9Lejzb2RGezgCU8C8RA9M:APA91bG2OfZW-5zyEKc1ySBMFZNiVXymQzhw9gWfXbRwHq2Pd19_C1obj4-bKiQlPQ8YhEH59QqaedIHpAUAmNPzVkCDsGbCkw-SlPJvsu6X_Y4k4dUiXkaKePxD4qrvAbXRgI5HHkTj',50,'Zarqa Governorate',32.026608,36.026771,'enabled',NULL,NULL),(134,'vendor','$2y$10$xCfypueZ80mRM9qTSizDE.EaymdmRq6Zbys4BzLuNI/KZXFstvRZ.','788543381','zakekalaede@gmail.com','زكي','العايدي','2024-02-28 08:20:51',NULL,'inactive',NULL,NULL,'34Q5+GCP, Zarqa, Jordan','f7pW1Z6sQX2DzxUw4HlX-X:APA91bEuLZjukniSNjzskKj9px0SmM1DwdhhsBlhw2DSRTD_NDT8O_ur2ZztdY3f0Mo2Dek70U8HaE4DI32BjJqkCuzPjjyf_wzhDfkrF3YkCYj5NKRbOdX0PpwMdjcSL5y_2HUKFGfH',50,'Zarqa Governorate',32.088580,36.108446,'enabled',NULL,NULL),(135,'vendor','$2y$10$WDo7oQL5nHyDjGYav33HmeC6Ip406quOrseORUq/y9VEP.ATXmWq6','790585067','abedalsalam2021@gmail.com','عبدالسلام','الكتكوت','2024-02-28 08:29:00',NULL,'inactive',NULL,NULL,'عين غزال، عمّان،، Amman, Jordan','d8ayc81wTS6aYt4ynXeojl:APA91bHWNQpOexv4ArqGeY5mT2bZG-27hBv0h5dtY5s7wkvl-cYDEauTXBDFJtFMAfLETUT66QQpMqcvaPugIAJn4vJHlU1pSIh3gMJ-hlsGxfd0h9QtIs5xgS_m3OOGbExbtDaeUi1t',50,'Amman Governorate',31.984035,35.976267,'enabled',NULL,NULL),(136,'vendor','$2y$10$aAtHufLlsh0jNNvy3853fOwhLFXmJs3DrrcTqxmrekjUNNO0Ayeuy','797090874','foadnabdsi@gmail.com','فؤاد','قنازع','2024-02-28 08:37:08',NULL,'inactive',NULL,NULL,'34Q5+C7Q اشارة الجيزاوي، Al-Mesfat St, Az-Zarqa, Jordan','fD7vKTDtRzKx-lnG2QEJzE:APA91bH9Jww3x-UgHWi1xU95Vk4VzfQvVd9w8YSeeeyoag5dfvpdh73wzmo9OXrKjWA457-hvcsrXxrp2v-1FCKc9UfaecM8sMwonj09UjFaFMV4xK7mCBF8DK3ggMT2WvbE_D3vT-2h',50,'Zarqa Governorate',32.088390,36.108179,'enabled',NULL,NULL),(137,'vendor','$2y$10$LJ6FYlDk8sJD4XNc5siZiO.gqLbUCbUz1QtUs5/SHLdRhogaWqhc6','799903522','ms1871610@gmail.com','محمد','جبر','2024-02-28 08:49:25',NULL,'inactive',NULL,NULL,'XXMG+7HW, Amman, Jordan','foEz0ZoUSyKqFbkNPvQyaq:APA91bGyJpVysDJ1iPKb3A5HloMVmAbNeJHTOntZBIBattACh8ymB-aDA6e7n6HRA9hBzPDsTinnHjl-vo7dONp4A2ZRAok76D8_KrDrAjmE25A4dRsuWY7qTCBkLYK40fDJXNCrpg6I',50,'Amman Governorate',31.983827,35.976806,'enabled',NULL,NULL),(138,'vendor','$2y$10$XuG9XkjA0RzjpGs2uNzC8.bp0G9VrxF9DtEXhBnAi2qCN3szmxwmq','788252071','nbbhh6969@gmail.com','نزار','عريقات','2024-02-28 08:51:25',NULL,'inactive',NULL,NULL,'34Q5+C7Q اشارة الجيزاوي، Al-Mesfat St, Az-Zarqa, Jordan','fKStMmxRTKyBT8JvQHZMsJ:APA91bG-Dj_R9KvrtHv_Hx1CquQlsAwuYVsHb3LEAKjT3fucmIkfxrdRIqu08-Dv3kcQOB00bcCKqulAnRIIERDDsyIkl3-yLShjmonf5PyAccVQT8VGmyNQ7to5t5TqUYhtEtNBzUwW',50,'Zarqa Governorate',32.088661,36.108227,'enabled',NULL,NULL),(139,'vendor','$2y$10$BR.R9V0YLyLAEfMURnXYQ.AO/FmmlEnMJGlfvDf7s9wh4Hd7n4Otq','795619774','ahmad.abushikekh@gmail.com','احمد','محمد','2024-02-28 09:52:19',NULL,'inactive',32830,'2024-03-27 16:38:52','VW79+CW, Amman, Jordan','fZAgoYzuQJSpn5Ey3Ebo3P:APA91bEyoAI1TnxXA5yqEupuC1qLns7T4rf48EZihN_MPZPi4vroaoZKytHLV70gm0ZCWH2YThQFrNsC8sSGDq5sOmJDdLJeRCJW2YGLfjQFaN-3mMftgWdHYM8m7uN67spEW24_hNr0',50,'Amman Governorate',31.863945,35.919125,'enabled',NULL,NULL),(140,'vendor','$2y$10$HZCKc4nkhiJg2TqGktlRHOS7kdGuyVf/BWlWC2hHuWTNpQGJ45rFa','792673111','zuainat@gmail.com','عز الدين','زعينات','2024-02-28 10:09:45',NULL,'active',NULL,NULL,'33CV+4P4, Zarqa, Jordan','dq4UiyBrS1uMxtJpVQfjA_:APA91bFLHxBU2qD1gRjNDo2cg80WnsyUBurTMI8NzS6tFkAmwzkSh7AgDVWzD_a_wn94oTrkk5uTplRMbUu4Tb2bmvaqVQW6-a20dzClFRhZVpisDTksQ-2YaKp-BWzuwt4cEhhxmYa6',0,'Zarqa Governorate',32.070015,36.094465,'enabled',NULL,NULL),(141,'vendor','$2y$10$MSyUE8BL0bMvCzyHxXR7geDQCSJ2d1/Mzadjv7QzVSW6d/UpPaxLu','797369676','marofmohamad825@gmail.com','كمال ','اسماعيل','2024-02-29 07:08:57',NULL,'inactive',NULL,NULL,'شارع الجيش، عمّان،، XXMG+5PQ, Amman, Jordan','cDGP1vvNSciYxWoVcy3Zga:APA91bG-gtXp4lTNIBVojOcFIzgQI7SWUi_lYPjjtSZOuZGgei6dAg2FLPuS8uUBcCa1D2DIyzrsl2KzrTOl7lGKbAYJG5QouIuu_jvlkTFRi4ZXAxcdY5fT0glV7s2JI5eXmIwtk7te',50,'Amman Governorate',31.983499,35.977443,'enabled',NULL,NULL),(142,'vendor','$2y$10$80en/iKwcVaI7uGtnZ5pJeTxzIecsMNTaAcPTSLDb3nEilrjfQt26','792881685','ahmadaljazawi@gmail.com','احمد','قاسم','2024-02-29 07:36:14',NULL,'inactive',NULL,NULL,'224Q+7XR, Army St, Amman, Jordan','cQimyMOUR5ifzbQ9nUo32L:APA91bEn7YwBOQMxloDlBi1tMGfVb7TNFl4uV6h1vBXzqSWTnda3OW5vUqiiLpeSKzmARxfNOGm0GhbUx5850hlktCbLb3hYF8asYNo_z23H5Dnh8atd_wcNTOxRdHun3sx9lYW0JwSm',50,'Amman Governorate',32.005382,36.040915,'enabled',NULL,NULL),(143,'vendor','$2y$10$CHY/ibGTOSmf4kEPn7Trc.iAuBqwtBy4GX1.gK15g9XzBRxPd7qTy','799736076','.@gmail.cimmhmwdjwr622','محمود','بدوي','2024-02-29 07:46:49',NULL,'active',NULL,NULL,'Al-Bayader St. 28, Amman, Jordan','co75lkYcTyq8XDaImxd0RL:APA91bHl3n8g_0AcR5uvUMIqwFY9lLD8k-8O2fWhwUZ_RfnFc84DRrzI9GSqdXYTs9dBwOJO2BSISU5PR6tw1vi5KqBxyGtdy1CT9IbLix0FByonQxX0bA06gBPjNBMDJyuWnVOa3_TS',50,'Amman Governorate',31.955028,35.842978,'enabled','1.0.15','android'),(144,'vendor','$2y$10$dpjN3gAeb8OxlPL.iF6q1eUfUfLgCUp8QOOyuhcTiF6nBQ9g6jzue','790342225','cncnjdjd86@gmail.com','محمود','شعبان','2024-02-29 07:46:55',NULL,'inactive',NULL,NULL,'XX2R+GW3, Amman, Jordan','cUaDtfAURtCEBQjxvIW9BO:APA91bGm0MP8sC3_cyowW2tbIYJzTzaeext8rsRYHD2rSsEQY9Pkvt0GGeNKD7H1pcGjo8bADj6gX9mA4fz5O3WHQb2ixAmMO-bs8cRkJ1Cb7InGNk4EG1CSuUqAbwPTyjTXIqML2LlX',50,'Amman Governorate',31.951220,35.991820,'enabled',NULL,NULL),(145,'vendor','$2y$10$JfFz5hI1I1jG3nEqU0NV1./8F53NpMrxauQ7UIlfofNXwx6qqGDYm','797688017','mhmwdr62@gmail.cim','صالح ','بدوي','2024-02-29 07:57:37',NULL,'active',NULL,NULL,'WWV9+7JP, Hashem Al-Atasi St., Amman, Jordan','eKd59nWzQTugI00dlVqqyr:APA91bF38cEoEJvbmAs7GSJBpQOIhlJXTvD-0kjW_Mb1gnV1VQpUIZkhV-Xq4B6JdCE6--hn1KOcEelRWsoGZGmWHTdXyoPXvAUU3WiJtZw_NCPQGSCVPJ6KUTmsXPwy6UACaZOK3Mjb',0,'Amman Governorate',31.943006,35.919623,'enabled','1.0.15','android'),(146,'vendor','$2y$10$23or9JxhDUAq8wFxtaDoIuKSVqK/6ZqWwwatnSNKV1L5gqe4siZVu','795155341','mohamadalzaqzouq3@gmail.com','محمد','الزقزوق','2024-02-29 08:04:48',NULL,'active',NULL,NULL,'XX7C+2VF, Al-Furouseyah St., Amman, Jordan','cB8v3uY8Su-i5H4uSZFKUg:APA91bGSm3GfpYgvaSYq1BxYLRzPkp4gc3C1gCaStthRoLFoF__QF6wJXKGryR2x_iA_UG5dVzYjHVkBUIfaWxeDf_hNv775uyEBPhdZ-uTS2NrIRLti3OHFuV5lWasskrK_s8Q0I4Qd',50,'Amman Governorate',31.962593,35.971935,'enabled','1.0.15','android'),(147,'vendor','$2y$10$pMv4ke.Z6zlvwTvLbKGOp.8JvUY.WUgDiOAT7w5dl/KX3VGs43v0u','792824253','ibrahim.98.alfayome@gmail.com','جمال','الفيومي','2024-02-29 08:12:29',NULL,'inactive',NULL,NULL,'WXHQ+6J8, Amman, Jordan','e73gACtZQ9SbY0LWGNFC30:APA91bEmIfJCtJ-8JCkQIsgk1JqpRk4BDjlpbkNGD6vvCWzgL-7HGhUR5cQF7XxmOikhkVbtZfsOcBk_OfaPJzdRueuWYwO8e0rbyL4DeXsyge-Oz1drxKk0qtxT_fI-dy3sTzEMxueC',50,'Amman Governorate',31.928388,35.989368,'enabled',NULL,NULL),(148,'vendor','$2y$10$Ko/L..He6fBnUzeIYzwt8.43bIwhNn8vPR.EbB7QcKLC.2J4H8BW6','788832921','vhhgf66ggg@gmail','ضياء','القاسم','2024-02-29 09:41:28',NULL,'inactive',NULL,NULL,'WWGQ+CHM, Amman, Jordan','f0yZgxVsSZS5gwmXgx2E7b:APA91bHEf_oRFyJ2GBCkN0R9KQPCtzw7sLEMBFYGjic1CUFeug9MPAAyvf7VOisTrHZjGrfqPQ10PiiQjpwoFPsN8qMr6eUByxg6vFD40TJMIr2oysFMOp4at-KMiGVldQzmPlgWvJct',50,'Amman Governorate',31.926118,35.938888,'enabled',NULL,NULL),(149,'vendor','$2y$10$u9TU5/ba3cXuMujLW4ZBfe69quRmvUgrm6H.ZY7otRM6tkR/wi9Ra','799919589','hamzaalnajar6@gmail.com','حمزه','النجار','2024-02-29 10:48:42',NULL,'inactive',NULL,NULL,'WW8Q+Q53, Seif Ad-Din Al-Khatib St., Amman, Jordan','e9q3Z1aWQMat7X71G-tXbF:APA91bGLDNXV3JQ_B-GKIoH1Q70W6r05f0Mecwi3v6SWtvk6Dox45O1EClLCmbMnJlORXo30647uQoB_fGvtBuD6c2Y2QPadzXyrIu1rD2HVTx2DctT3ILGiGokhd4JibIJbZx5DMOtm',50,'Amman Governorate',31.916947,35.936894,'enabled',NULL,NULL),(150,'vendor','$2y$10$h1DMXNGac2BhgpPF743XGOMza6borhADKI0.dqX27bAFkdd3/dbzG','795433737','myarmira129@gmail.com','عبد','ابو سل','2024-02-29 10:55:22',NULL,'inactive',42477,'2024-03-27 11:54:05','XWPG+HRF, Amman, Jordan','dcggKbcwSaKuiCJQmeZlPx:APA91bEfwkeUX4n5XEDds0hQspfbkfEWdnwCHwISsoZpAWj0MaGpbWjUgtto7DD0uw5VBQUIn48k-hZbI0KTcalElOmmObEglv0vHtNgGSOe_7PSU0Vit1K-eQdD-xAU9n9yPTj-h3Hi',48,'Amman Governorate',31.986386,35.926907,'enabled',NULL,NULL),(151,'vendor','$2y$10$dNMBHcWME7U5.7Ef1344O.eBsRgBhpePbUBe/epdJ9/9XTBpUtQRW','798286252','mohamad.malik@gmail.com','محمد','الملك','2024-02-29 11:07:09',NULL,'inactive',NULL,NULL,'WWFR+M9W, Amman, Jordan','fKIk0HsDQdKtjEjOk1QPLD:APA91bFa-p8jYQ4P4MHmJ_UCMpMIjEAOl0x40tJoqqs2RhPXYqe8MMUktMLiSlLizFkgUFcREElgGKyRqXG8FjrfQQ3lhuGUJFcfBp56gzZrvdJI4JwDZsROqVKY1lpti1MOS1qTqYdK',50,'Amman Governorate',31.924219,35.940954,'enabled',NULL,NULL),(152,'vendor','$2y$10$OMQX0jt0RrTPdaJS5SffcuYm7h23wBWnXKizhrXwZCaQC4itzzdLi','799896985','،accirnfrx275gmail\'com','محمود','محمد','2024-02-29 11:23:43',NULL,'inactive',NULL,NULL,'WXJ4+R97, Amman, Jordan','dR5tDGrVSyi5KYrrDXRoUG:APA91bEzulQnRM_jzm8X0BB8EdxQFE6NRvTUSGyzC4ShDNWVxi8II8fP6fsnwdZJI-Vlgss7PLqOAp_t2jdmyu_Sf9zYd6eIujpUQQ-H-_IDl892-r97h6lqSDFcF2qdEDgmAaeBRq0V',50,'Amman Governorate',31.932164,35.956214,'enabled','1.0.15','android'),(153,'vendor','$2y$10$Y2oyX4uII.fhiqwLEim3KuF5HpUJfm9cEWGqTDFL5Q/arMUMxfHQm','782303080','the.md@hotmail.com','محمد','مراد','2024-02-29 20:45:08',NULL,'inactive',87946,'2024-06-10 08:29:27','QVFR+W78, Bar Elias, Lebanon','eH8cTTJwRvWNYqnpiFG6Yj:APA91bHkPGRGQ8zkTKdRJgKh0M5mXNirvKqHogUWgwUI2V-DJKWj9IiI0G1fZgP2f6ukMPkntl5LuKkT2q29ENvVh7CJaEmTkBcoLqso5xSRXIF0FqufDnhbAD0bXVCdcW9avsQiHJ7x',974.4,'Beqaa Governorate',33.775085,35.889692,'enabled','1.0.15','android'),(154,'vendor','$2y$10$kNYhdO.CQdXU2GJrZn/tueN/Cm/S73P9eT11Ar7FBF9UvGvoUcNd6','777303013','Khaled@gamil.com','خالد','غيث','2024-02-29 21:01:25',NULL,'inactive',NULL,NULL,'Rafee Othman St. 25, Amman, Jordan','dC9jJPpcSRKrqHgxLw7c4a:APA91bEiHGOsCfiEG-Tk8fahMG1OqvqLKJ4A8OhyeCoBHSvyCz6oS_cXbmSSHzYCy97RKu1xOfSGWjBsc3Dca7znJNmAoYls0d3JFcYZw4fhwC26v_T0wruHlP5sWqdBmQcfOsrUTzoB',0,'Amman Governorate',31.985510,35.867282,'enabled',NULL,NULL),(155,'vendor','$2y$10$SqE2UFUefd5JgQZo75Wz9OzhfDk6V09PAErRKIn.XWkseovp9xSjy','777303011','Khaled@gamil.com ','خالد','غيث','2024-02-29 21:25:06',NULL,'inactive',55873,'2024-05-02 15:53:15','30M, Lebanon','cXSb6Ts2STCSQGV3QoyOkQ:APA91bHQ6aL_w5uFGKGEq6eImKAk_iSg6ZKG7CzU_o7DBOjuJ7LZhjKkV9Wy0LIrM0I-M7zcKL5o13BQCmRFM0bpHpjppOgahgJon1tv4I4u_3OPerPUtNIEqm8ZUWRV4GB4tas2rcTM',91.6,'Jabal Lubnan',33.809066,35.748150,'enabled',NULL,NULL),(156,'vendor','$2y$10$lLaty5Gg6PvqsV4LYNxd5ONjgrUCS1naGVFVKJDvCSdJaXlEpg4EO','791301030','alnimerkhalil006@gmail.com','محمد','السيد','2024-03-02 06:52:07',NULL,'active',24064,'2024-04-06 05:05:11','Khalil As-Salem St. 72, Amman, Jordan','eeIRn2yaSBmuXePh7o-b7B:APA91bFkA5Ootvgw2Yt1ub5hfMCgF4RDA7L3JmXMIfCjv6S5leuZG0ZMLyy6n2lx5KDbwb5eUJqINFkVjGspdSFp0_7xBQgkGb4BIgiOHAI_Lr00MGykcyH8Bo-Z3AHYvsCzpp9Oh7FS',0,'Amman Governorate',31.990377,35.977412,'enabled',NULL,NULL),(157,'vendor','$2y$10$WiMiDFPvQ0HueNgcd1RHpeQQ4Ple83mFI.Pb.cnXyIl3pxAL6J6Y6','791112032','alsayeshusssin@gmail.com','حسين ','السايس','2024-03-02 07:21:28',NULL,'active',72720,'2024-03-31 09:27:46','XVX9+JGF, Khalil As-Salem St., Amman, Jordan','ca4b2QfERJCxBec2xgo_P8:APA91bHhTSfkWiY3UuFPb0NO54T-iE9mfJqS5ZH-kORBIoTFm967OY-XF8jRpiSabYCOgNST_6d8ZJRdEmPPdSZR7PdEISdn_RPgS-qgYFbSip9e2c0RO4MBRR5gHY1rDM_078vm24g0',0,'Amman Governorate',31.999171,35.868226,'enabled','1.0.15','android'),(158,'vendor','$2y$10$BQDMDEfgTe.QqXx.l1XR2eMbDzQDOryS9ckXmmkErQvkPgEs5kBVC','780369899','e381644@gmail.com','عماد','عواد','2024-03-02 08:47:13',NULL,'inactive',NULL,NULL,'K. Abdullah I St. 54, Amman, Jordan','crqUn2a1RgyB4CGnz_Wh37:APA91bHf4dGWqkEdlI9bq5FSpszjAkBhjowWwwcSsI3FbvDJvp7UmrPshE5Wce4ILWkx0p7f1jmPe_ZFOadRlYe_YmVEcSkgBkfy5Lfs7ecw7HlCHTITUm_fCRGbhT-ShE37_lNRSLGO',42,'Amman Governorate',31.954531,35.953286,'enabled',NULL,NULL),(159,'vendor','$2y$10$PDt/g6tQR/bflV9etd8sL.df6Oh7aCevO1yhklUgsoy5HFFBzbIHO','791543845','saifalmanaseer28@gmail.com','سيف','احمد','2024-03-03 00:00:07',NULL,'active',NULL,NULL,'WQ3W+GVX, Amman, Jordan','fwX9Nop-Tv-xobGdJCC2zC:APA91bFa1buBRj4Ga9ubwYz5TXK3k_WdAeK7yPVnVkEnsAXFJRXboT_JyXFZTSrmXeazMiisqDQvhqOAOjLzIqD7Aa69cYJRSWWt8rqnxZoRoOgOwwiEqb0u4JdHh9a9ME3Z5gsxqlcr',50,'Amman Governorate',31.903581,35.797639,'enabled',NULL,NULL),(160,'vendor','$2y$10$4bV6MmBiipU60CY8VVPeaeYmJ7IBhCPB2nVDC8fQzs9F4Xb7TwIB.','791908849','mktabakrmabwsdhllghaz@gmil.com','محمود','ابو سعده','2024-03-03 07:08:27',NULL,'active',NULL,NULL,'RXQJ+4R2, Amman, Jordan','cv5RFni0SAGRt0bC8ccGWW:APA91bELBCr71LrIkSfy1XQNNAvVMMzk2NV0XUoxdMHfr-x4Jaxk7yObiB1ng7LOj6yQscprGeOFCsBvoRoHU-JLiIECGsh9Ax1T-crIFzFezRboywk-DHGPeDNvLRkgpb7zFuFZVHnI',0,'Amman Governorate',31.838106,35.982345,'enabled','1.0.15','android'),(161,'vendor','$2y$10$iiBld2a1h967L9LAEAC47OojSfDMhRijAb/YnvnxgmkhI/BtnAH2G','795537934','yaseenbaker234@gmail.com','بكر','ياسين','2024-03-03 08:14:12',NULL,'active',NULL,NULL,'amman quaismah, WWFV+GGC، عمّان، Jordan','d_89nQLRStOcy1d3HiztYm:APA91bG16ILqKtxf7cxiqm11ritdCLeUwurWcMG7u38Fw76XTTsuRdVJMWQ_Og-N_E8m3xF4uiRuSpDC2LMPzzOcFb7c6900rNlHbkPUB_fSAGqZTJ2RCITcsX0Z8RneD5zg0bXDaYU-',50,'محافظة العاصمة',31.923995,35.943143,'enabled',NULL,NULL),(162,'vendor','$2y$10$SBUXEvW2YjTK9NPZ6YdU1./MXIAKQmMdGDnX/a7ortAuaaU9BZP1G','796507368',' besoalksba@gmail.com','خالد','الكسبه','2024-03-03 08:30:10',NULL,'active',NULL,NULL,'Al-Quds St. 86،, Amman, Jordan','fUt7c84gTgSLggQxYGouoA:APA91bH1wFbhHYMTniSeLb_0NcOIDKKFmribmugLoDEplOq1OcpYWJWrRXM7Pp-KuHA9dW7sPFmve84FR4ZEd9XIAO86pY6amaSgDAi420yRmHD4YhP6as0ZwAfwg1DQ6m62iGJ26klM',50,'Amman Governorate',31.938481,35.922746,'enabled',NULL,NULL),(163,'vendor','$2y$10$4Jj/YqUSvMrX27.x5tstdeWci/TdzsIppRePKxLvPRCI4Tc.p4HpG','780660924','moh756397@gmail.com','محمد','ابو خطاب','2024-03-03 09:10:45',NULL,'inactive',80628,'2024-06-27 08:57:45','WWJJ+CQ4, Amman, Jordan','enT9EBl5QFeLYFfBmHSIez:APA91bEWgXr7tHZg1ecLAs7jcKdLzzTXwwzssaIs8yhSNPRuGlajyeFMDJbm4AwGuc94VQVBrCWQ2LfDiwGeRebNlDScX0rvQWt-BIPahSLX1D5bNLQjCBINJzTZw4vSlLuCLsxADokz',0,'Amman Governorate',31.931349,35.932398,'enabled',NULL,NULL),(164,'vendor','$2y$10$PofgL99jGxys0FGEvSJbXOWQBiA//al5zu8wwQUgeeTGvWHKpUSeq','796395577','iawamleh64@gmail.com','ابراهيم ','العواملة','2024-03-03 11:37:50',NULL,'active',NULL,NULL,'Hussein Khawjah St. 83, Amman, Jordan','ctZvYRbSQz6YchGEfDaWic:APA91bElEg3RdF6HZBhMRNiwZQ8xoT2TbdAtA_O2___HeWjGk9KBw6YRC4oiwySwbFgXSXXgIChssWna_puc3bgFmiNczUTjnmaJIEy0dh97IHGRS9GlUnTE7kpwHFtmFbkmtBkyvJ_x',0,'Amman Governorate',31.955132,35.839923,'enabled','1.0.15','android'),(165,'vendor','$2y$10$RWmx99/nhbGtF81eh51/rO//RLCQpatQVXcgI6zizLe0tcGLZ/r9u','797065140','ahmed.khader219@gmail.com','احمد','ابو خضر','2024-03-03 12:09:18',NULL,'inactive',NULL,NULL,'As-Sanhouri St. 11, Amman, Jordan','c7GaJw8TRCKrQReHrky__x:APA91bG0cPb-_w5NjXp_aPsQxbbkW4EzK1wn_mZcFZ2DJhvnw_1nDbXmQazhAD6Y7V3Fa1K5NTmQT2HnrgIwStWNMg415CbMZRZSw7zqJkBID_wg0aD5ax80B4UDgAQ-sTYMewKsRZQC',0,'Amman Governorate',31.971231,35.928482,'disabled',NULL,NULL),(166,'vendor','$2y$10$wR5vfJ.Gr/sVxKFwKFtKNOI.DcG9e1owwK2Mu7Vy1G5W/nxdB0UK.','792228040',' mr.omaralaasaf@gmail.com','عمر','عساف','2024-03-04 06:34:46',NULL,'inactive',NULL,NULL,'XVV8+45X, Amman, Jordan','ci_b4-9fQw2fSE13XSMOly:APA91bHdIqo_FVMu66Hlfbjg2G-hWXgvLNfkwAfuFIk9gXqFEfXNBRlKvvXWNoffVs7iDE76fqVcBY6Tc6EqDTBXXd9nceM9RtNb5bjpkkfwMdLVLiDWro7j9cJAG20h1ms76IHfFJFR',50,'Amman Governorate',31.992822,35.865882,'enabled',NULL,NULL),(167,'vendor','$2y$10$tjYDTK8ZGcoUi/BK6L9DUOi4ShTlGD6b7sNhLsrCEb5XV52iTqHG2','788161045','alsyrawyndalasyrawy@gmail.com','نضال','السيراوي','2024-03-04 06:40:43',NULL,'inactive',NULL,NULL,'WXF3+CJX, Amman, Jordan','cvaRiiOBTQyOUmtZ69afh4:APA91bFwmCsTb72Gv0yIe5ujIe-agRL5Klal-_Y4sqXcYMlOW1Kmh5FUpI52sZA_LuuKh-jykVx_XzQqmPS7Sqml-mFYIOdnwQbQ48YGofBKBeUVaf1fxt1AUrJEQofyrLMn9vseeMgc',0,'Amman Governorate',31.923920,35.954005,'enabled',NULL,NULL),(168,'vendor','$2y$10$1w2kjcBqtORJ1hglhaoazeQpiGa9p91pp3NPy081NK4hvy1iAUTN2','796960389','anoahmed696@gmail.com ','احمد','مصطفى','2024-03-04 07:23:30',NULL,'active',95436,'2024-04-15 11:06:27','Prs. Tasnim St., Amman, Jordan','cGryySO6RcC_e9gxfI7SQT:APA91bE4NLHP37tqewNqIxcclMZWlEKhtReHmr1Ja1W4CEENSWFxxlWPFgF-xmnBroOokKPEHJULTgCRK_vi_u9u_58iBaa8yAG5ocJvp75cm-24OcNUuSGvEHILHLK6ki-EbVcZrCZH',50,'Amman Governorate',32.020157,35.815440,'enabled',NULL,NULL),(169,'vendor','$2y$10$zbP5nYdh1vlQX5LGE3p5M.apLUigKPc1Cxm24bSHHZhcs35LQ3Rxa','799318940','shadimosleh95@gmail.com','شادي','درويش','2024-03-04 07:31:20',NULL,'inactive',NULL,NULL,'WV4M+J32، الاردن ، عمان ، حي الصحابه، Jordan','dqOhrDuuQi-gPKtuw7-BQ3:APA91bGXMRCL-6PKWRCwkYo-6kH1d_jkFOOxYpIPU4E-H9M1BNhtaNBBrkjRJkOVDWAxZs8u-6gA76Pfy3fWDOsAuvgcVFAOCn2c7fUnZhP0w7SIhDvpRArI-uXi3UD-QJn9HlHhSUYV',50,'Amman Governorate',31.906577,35.883169,'enabled',NULL,NULL),(170,'vendor','$2y$10$FvxV6TF4hcSGBAmaym.p3O1TIZqRiZ6oS0q89KTOcdO2hsxQdE9Sa','790114043','altaweelyazan811@gmail.com','يزن','الطويل','2024-03-04 07:44:52',NULL,'inactive',NULL,NULL,'2QW8+5Q As-Salt, Jordan','cVMv5LvFR3ydFzlvCbM1qS:APA91bHkLmAFvBOFAXY50MtjFGWNi2DRFRABanJwViZld0ASCSxodKsORF7vdpqO2Ud_SIK5D25czQ1YN3dyv-KaGLluvvyv2ao3kvWBChfhe9q_zTj-CMroHgjAKvUKdl5eDmiE7r4n',48,'Balqa Governorate',32.045382,35.766931,'enabled',NULL,NULL),(171,'vendor','$2y$10$IWEu2Q5vWzQ8TSZ/sHswvuDyEqvtyD26jUEhP6idGRI3/4De4f6Mq','798257470','hamzaadnan98@yahoo.com','حمزه ','ابو نواس ','2024-03-04 08:31:42',NULL,'inactive',NULL,NULL,'2259+RP Russeifa, Jordan','cINaNuvRR6Wk9U24hrFZut:APA91bGVwGn66YXA8huxQSP95gdJPDvFvd1RIV4qh_7kqhIQS73-s5I9QAgyf_UKqWWAh7w-AKeFcmfjWy61UhUEhf4H2Gt8Y-_xgZBIzKyAdF_TYcaUDeVhOxdLNDTNOzEC7NDKkqz3',0,'Zarqa Governorate',32.009512,36.019343,'enabled',NULL,NULL),(172,'vendor','$2y$10$88jptdNNkhZ1b1dojcq3NOI2Chju4rEQ3Ygu3KwTfEYu2bj6cxTya','785983085','ramyalswdb@gmail.com ','رامي ','السعودي ','2024-03-04 08:59:42',NULL,'inactive',NULL,NULL,'2W6W+F9V, Amman, Jordan','f11r7bp5SHSnJID3DZYAxx:APA91bGvHrr3i-pqs5xUoudTeU8J-uOrGwBpGtQ4H-G5lUWmGkEG_bpCgGiw-NFLalehPAr50r4dswvp1g4CShpSqS98O1q4AnAJboL8psh7nHsLqbXHkYinCnxtaan7NYDHvOPWnq2v',0,'Amman Governorate',32.012167,35.946236,'enabled',NULL,NULL),(173,'vendor','$2y$10$bbXqLY5wny7psGT3dLC3VOtZtX3/sPrBn3yQSJFKmyYroALsCU.d2','790488325','hdhjj1981@gmail.com','خليل','خواجا','2024-03-04 09:09:35',NULL,'inactive',NULL,NULL,'XX96+FHJ, Amman, Jordan','eArkn9lpSCORrSRasvwXI6:APA91bGOh9O3V4ynuis_Qz0Qf4W5NFYwyKe7bkzc8CHHKrrZU7PMUO2E2W9Y2Za2tnqfgof-O_IRxNEOfQshHIxwIB3uGPQgDfe1klY53d-f9x1Ir0rBoVTurxmGJ2A46fxFV5l7mmde',50,'Amman Governorate',31.968524,35.961421,'enabled',NULL,NULL),(174,'vendor','$2y$10$rYEp49ZE6YK1GT3kReSOf.2WrIAjm1UHApLqLSKO7ANYWGD6asg1O','799275175','emranzaqzoq75@gmail.com','عمران','الزقزوق','2024-03-04 09:25:31',NULL,'active',NULL,NULL,'As-Sayedah Zeinab St. 21, Amman, Jordan','dUbFAjLaQoqd8qvB1HF3Vd:APA91bEFIsj8iDkaUoexACUFn8kDZ2cLObjyJiun1nGRgUInUga4XdlDG5HT5JMSBdOiK4GbIK-dPvJZW3TpkuvaVlbv-IhYFuJX7bwFGtBI234B7Sf-jIrNvE-UM1P4m3EEtga9s_Pq',48,'Amman Governorate',31.963816,35.963935,'enabled',NULL,NULL),(175,'vendor','$2y$10$WeRzvJ8g72Zja7IsCrS.gec4gP9Ww/QLc54U6H3BIUV7nFCK/3Ca2','795927665','hly935041@gmail.com','حسن ','علي','2024-03-04 10:35:45',NULL,'inactive',NULL,NULL,'Ahmad As-Sukhni St. 12, Amman, Jordan','dXy0Q2tTR9evfXQLhBFK2e:APA91bHN-ECt79QpZ6ZuLM7ZisiIRtFd-Biauxvx7GqoYLZCaEaK3IV51CBx19PF59PutiUYi7BQttr6hJG7VfpqlwGjzJFiukvZUX4n7MrcSUguCx0lmxT4uKGS13I0vy98qy2dPLJV',50,'Amman Governorate',31.959108,35.870200,'enabled',NULL,NULL),(176,'vendor','$2y$10$2Ro54AzPnyzNTr21QOlQQeSVyYo0c9mDOqVIyYBl2LUVq4u2pnKam','790622929','habashsamer1@gmail.com','سامر','حبش','2024-03-04 10:49:20',NULL,'active',NULL,NULL,'Ibrahim Al-Habashenah St. 106, Amman, Jordan','ecH-RgIpR9ajRvxRHw5HCB:APA91bGRPYtTSHp-B8kJ8MmoUeMDLnfwsgqltdl9MwInHdWfQ4wgsVnY3IRsrADuvG1vtxBrLSHgGmeX4AWJByoalTkJIILoDSZcE_LlytYS2Z9IxHDWns8TZK3Cafl4K9VDTlESWpVF',50,'Amman Governorate',31.991933,35.984004,'enabled',NULL,NULL),(177,'vendor','$2y$10$sldmPl3lnGvnUKK4xXWZnOEi0RAAyEc0Kj08UhFjNmFx1Nq/UgYni','798710388','mahr56745fa@gmail.com','ماهر','فايز','2024-03-04 11:06:22',NULL,'active',NULL,NULL,'Ahmad As-Sukhni St. 12, Amman, Jordan','fftuydNSSVG8JcNj5yMb-v:APA91bHmZIEE_z6dK7cxbRS7bTyWdvYg3qD3B-qonosjp6ivKZjeGVwSq3qjO3KPqDqq50RQRvpiHGzIeePwukVHj4h536a_iNJRF6aXQEkG-zR2xoT_GMz9t3dJ1nBkOU4s26gWMiUv',50,'Amman Governorate',31.959063,35.870305,'enabled',NULL,NULL),(178,'vendor','$2y$10$VuNhhiuCsj6eH8ahjGsNg.AprSukdmVHMvqPRseFekejqvrINTehm','797403057',' abd.karmoh@gmail.com ','عبدالكريم','محمد','2024-03-04 11:41:59',NULL,'inactive',NULL,NULL,'XXMG+7HW, Amman, Jordan','cuN04HmlQJOlEs-3uaP74v:APA91bF9YtTrsdBb3Tj7SQJbRrqYMz-HjN34o82P5QRz2jz3sVuxyIXfLdsvCxD_keunNKoMZhrT52NZf3kIi4SnU_pKqYdXXMzo6wtZBwwcUsbgc76Cd4nt2rfh78ktcNBOiwOIlT01',50,'Amman Governorate',31.983927,35.976812,'enabled',NULL,NULL),(179,'vendor','$2y$10$LVcXLnNBdiVHWkwnMB8cS.1GHYGabYLJohaTvdM4YB0uuQyatopt.','788297967','uduufu657@gmail.com','محمد ','الزغموري ','2024-03-04 12:25:41',NULL,'inactive',NULL,NULL,'2W2Q+6RJ, Salem Al-Habarneh St., Amman, Jordan','d7s5LuKgRRiV8jH1qk7JsT:APA91bHE2Bw-kM5hp5I04hxnjTZE0_fHzRiiGa_T_KxfiVpC381WIzLY-L6NQj3BYWqlZZfUWR0ZpRu-BXgnPcR-zrV0xe_aXn2E9iPRW_QvsSOxVwNed5V2aVIE2QpGNIMX5Q2VSpYS',50,'Amman Governorate',32.000939,35.940192,'enabled',NULL,NULL),(180,'vendor','$2y$10$DANXPDA5od0wQlcAWSoac.U5A8/HYp7b9vmUd5jvHKvwkUG2dKPCy','789067391','bda154350@gmail.com','عبد','البزلميط','2024-03-04 13:13:19',NULL,'active',NULL,NULL,'WXW4+9GW, Ibn Mosque St., Amman, Jordan','fItmdDVfRWm38uGvjqxZQY:APA91bEMixxQ8WIW3jYl_JF1GCnfBs_QN9aulROxlEkg7EGTdgdAZBy58OpfgNa0de5ZwSR1EkdXkzJBFGV4DQI_D7w_YUC8BsOfH8wslHllgUvgX5siE0bgR93ZWmtsTX1FZRByYL4u',0,'Amman Governorate',31.946147,35.956388,'enabled','1.0.15','android'),(181,'customer','$2y$10$aRIlG0Q.LQBR5p2DXWxl6eFVeCsfx4EZt95Tl9OMfzjDaa2zp8MVi','782303075','rafatawad1114@gmail.com','rafat','awad','2024-03-05 09:46:03',NULL,'inactive',62658,'2024-06-24 11:45:40','WWRW+C5G, Salim Al-Yaaqoubi St., Amman, Jordan','dPLflG4xSCmDkUKi_avBbY:APA91bED5V_Y4YKnj3Dk-VOMek1Z8gv_j9amXD3n7TJC7sdVIGUphdOjf9MzSPBuFPiCdEuOaOp9S6PDqlEDyOjGO4FCKzKTPJ3Dxh-fLnlaxnR0F310LgVmNu5CHLd13AdxhgwyvTd3',NULL,'Amman Governorate',31.940883,35.945639,'enabled','1.0.13',NULL),(182,'customer','$2y$10$QNZ/Vmru1UvmIdjqZjx/o.vTR4bXicNDxPoIf7tKXKhH8hrwSOV8W','782303099','khaled@gmail.com','خالد','غيث','2024-03-05 10:01:57',NULL,'inactive',33209,'2024-03-06 10:21:40','QVFR+W78, Bar Elias, Lebanon','eBCMRJyARVCiwZYBgHgb3T:APA91bEp6o8AtFsxbCi-5Svi4iUkeZI4dxzRSsCw0djndmJhLJLtKEHrM_HeZ6J4Jed4aWMdNYbYjpST1wVAYed5tHZz9oTg6AChDoixI1Rs3glwbvHo54nuxEyhyShaOQSax_WaRKyg',NULL,'Beqaa Governorate',33.775111,35.889848,'enabled',NULL,NULL),(183,'vendor','$2y$10$YcMFodbLheHxmp5HlIpwL.4zn6c3di8G1ihMjw14tOTHybctlAXAK','786237667','moong4030@gmail.com','محمد','ماهر','2024-03-05 10:27:21',NULL,'active',NULL,NULL,'WW5Q+CX4, Amman, Jordan','foxsw0ttSMaZU1-iNxpOVP:APA91bE-XJG6022HHVEzFCJb6ATfPjG5BrimOXtXOwjmZ1H5FRnDFg1_gJNU0eiX5GsNRBiYQd-4gVnmCqUjIyqB1pJ2tXNfqZMHITrbjnl3psxFKwPzFXBl-Iu82V7VkSDFbv6vWGD7',0,'Amman Governorate',31.908225,35.940505,'enabled','1.0.15','android'),(184,'vendor','$2y$10$XnsLEXPU29jFbhxnBvDPb.ZrVy8OvscdkMbPsFRh87Oap4x5QN3Fa','798032123','abrahymrba779@gmail.com','ابراهيم','رباع','2024-03-05 10:53:33',NULL,'inactive',NULL,NULL,'WX26+JPC, ZaAl-At-Tarawenah St., Amman, Jordan','f2k_5r8aSzKlSKDCDM7Yft:APA91bHcZfBB2eb7fYBvu6iUKOltOFX630gO9ksafAfgWfia0bbyaFB4b9BSzXV1l-J17B5D-W72vVzSLXDdP8EmxJ5o-FmaAdKELhN71ZPm-ksLExDGOOxbdVwjEPB5D1OI-P3fp0yk',0,'Amman Governorate',31.901153,35.960761,'enabled',NULL,NULL),(185,'vendor','$2y$10$USA..pvp.d1NEKtUqiVrfu.HUdgceYexVCyHZGK0JwetQPJ39GJWy','796292331','alharas 123@gmail.com','عقيل','الحراسيس','2024-03-05 11:32:44',NULL,'inactive',24979,'2024-06-29 11:28:36','WXG5+MGJ, Amman, Jordan','fD0sqIrQQZGcvqoXT9kIpt:APA91bHWfTzG8mO1Ba_uVvbwviOtgmdD68w5wk0tjaq_drawH5L-Zuci31pXGjOpUpBQhgErP5KefeKKR-w6jhiSWsJfhweSscS8WMweIN7fDhIpK3x1o_qTXxX7JIgGG1zNlV9fxgJ7',0,'Amman Governorate',31.926822,35.958798,'enabled','1.0.15','android'),(188,'customer','$2y$10$IjsqN61RboWpGdTVXbHobez3zQuBlkCdX2dpCyqP9IBaVXbw5YjlS','782303078','mostafalgzawi7@gmail.com ','Mustafa','Lgzawi','2024-03-05 21:35:36',NULL,'inactive',57265,'2024-03-06 10:48:33','Wasfi At-Tall St. 18, Amman, Jordan','f6TtWr_QRaKumZe58W7BqA:APA91bF9skVsPVvo7nfYffgltg3uVm8upA0xyM6mwEE0JvqkO2lo6zqS44q1ONsbbdIVqVHZkVM0D2aoDVz3x5Z28LqVTdD5CthFhveWI7dMQFZyshvzhfvc_xUKSjpg2S3oluFqOjZw',NULL,'Amman Governorate',31.989842,35.871389,'enabled','1.0.10',NULL),(189,'vendor','$2y$10$EWYppAaX1NW3qg3/AQ2eQOBeBH4YIOjhPvM1h28VVbrvj.HSIeAbu','799749920','thqaqq@gmail.com','امجد','الكسجي','2024-03-06 08:27:32',NULL,'inactive',NULL,NULL,'Pr. Nayef St. 12, Amman, Jordan','d2aJA2_QSc2uiu3ovmXgT1:APA91bHIdUecT3-v-dz0REJK8BL-NktjWVkvzhJWnjADQfqVW-IlMY41rcKPUsgfJ8_XzVK4ukbGiZ0YU9j3cdwd2C4FA6JB-m7tKsKzsLKJdncIK0SMes99iNUOqjTLIfEH2ujqVXof',5,'Amman Governorate',31.929906,35.951712,'enabled',NULL,NULL),(190,'vendor','$2y$10$QLFktbYa3mrCZde2S1iOOeFkorhrYlb6uLZk5B43SAVigRs1NNe/u','785486802','wahedmoamd62@gmail.com','وحيد','محمد','2024-03-06 08:32:36',NULL,'inactive',NULL,NULL,'XRRX+32W, Amman, Jordan','c28nH5TTRaCpUngp6SGy5n:APA91bEOje0ulS2eNv3sfB6RrLqyDN-ioxHWWB1tQd5EI7QyJEEAi0KHMC6fbPNjqCa7f2NcJbJK2bdgePJ6DbAZko3CkW_1xT3cnzlHRqHne4kbb88ja2RIv5UZlq0xvR7KcbWJngS4',0,'Amman Governorate',31.990319,35.847589,'enabled',NULL,NULL),(191,'vendor','$2y$10$/XoRmJRXcsN2DDKQlwQbm.IlBkje7Rk1GXlOp8xTipKI8SvyuJfA6','788583943','dbhmstfy73@gmail.com','مصطفى','محمود','2024-03-06 09:07:45',NULL,'inactive',NULL,NULL,'ش.سليمان طوقان , بناية رقم 13, عمّان، Jordan','f1vwdCKMRV-e0aJQA-f71D:APA91bFrKq5MqkAY8HB0eu3jNsHxi2avaE8laxMmB7fIbbm3Va8T8zO7YyQiJFkJMuKpu5UBT4VIiwAAPJcAFoRRRyw3gUllb6Pyzb8AqefNobgtf5aoMWYDQVX8fFtTQhXjzjgLj_Gm',0,'محافظة العاصمة',31.980774,35.856400,'enabled',NULL,NULL),(192,'vendor','$2y$10$FLq5KDmOvSWDby5LjPRpEuQh7W1EAgGCnbdkaPO0KftYUwdC6LG7.','788117015','tahseentubakhi@gmail.com ','تحسين','الطباخي','2024-03-06 09:36:17',NULL,'inactive',NULL,NULL,'PWRR+4JV, Amman, Jordan','dPWW3kdcSnatRfr7OCy_XE:APA91bFeGOacNl2a1hZbY1tYPenjJzvO6eCNHp392-wIA-kS0Po5Cb0DOc_r5ZxDBuqbDrFx-S0fVqmov-MAde3405t29dqWX5Ro7eblB2erx3ja6W6Eqw_bWjbV7Z91EchlJpsLpNJ_',50,'Amman Governorate',31.739789,35.942353,'enabled',NULL,NULL),(193,'vendor','$2y$10$.2bRzikSXGXN/bidSQKS.Oo1bKNOK7VZO6qEW.IhBl2xBeCEiRaFq','791751850','asamhabwslym3@gmail ','رعد ','ابو سليم','2024-03-06 09:53:06',NULL,'inactive',NULL,NULL,'الصالحين،، XRPX+9G2, Amman, Jordan','cpEAND_kRtm-bYeSv4_5Bd:APA91bGkHLIkAF8YOjzPyBl7Da82HrHmrHaJd7X1j2jimta9m0B7DYDuPxHVm5hiaaF7y14UjM_C0L0vQ4YN9kwrB8avk4UgpsrfDukzyYxUh-NTcD_HJ2H3fktalIk82YZ1-r1R-oF_',0,'Amman Governorate',31.986317,35.848837,'enabled',NULL,NULL),(194,'vendor','$2y$10$TnIdvGSjQXZUQirOILJNMeucw7ssN7x.E1ToZqQWZPT8AOzS9gs2i','799789127','esamghunaim86@gmail.com','عصام','غنيم','2024-03-06 11:30:57',NULL,'inactive',NULL,NULL,'Musaab Ben Omeir St. 28, Amman, Jordan','dqn4rOJRQg-iU7_q35-Lyk:APA91bH2IJ1d7RSS2V9HcxT7RxmY5_yn3k9JAysA53MLVBXgJYizEbQ939iCt9uDow9TpudaDem1wTW5PdMXsuG9D2nER8QQpSdKZPhoNQmNNvCO7rLgk1vMS3ivY86obAVIs1cYAAYU',50,'Amman Governorate',31.920585,35.933745,'enabled',NULL,NULL),(195,'vendor','$2y$10$dLl6xGDrMOzoCgDS5Na7LuR3KTt2D4OhGHvmtI/bErGQoCWVlKue2','796519950','ahmdtym985@gmail.com','احمد','تيم','2024-03-06 12:41:22',NULL,'inactive',NULL,NULL,'Kasseb Al-Jazi St. 57, Amman, Jordan','cbyQPb9rSA-tdVpwN9wBr6:APA91bETjzo9kav4dyYkwqGyRHwUutkJAmzRODzNvWSvIf5nQa6J-87M1zZaTYOOxW8Cms2KfGZcpnq0u9tjM5-66p10-tOT_5K7YrxmZTnsYiHm4mbAjCv1LAOB5g_zwYuxo8cm_bvd',0,'Amman Governorate',31.868951,35.902945,'enabled','1.0.15','android'),(196,'vendor','$2y$10$Mu07syyR9TL3UQZ9RaJG8OVUV1qPLxCVTov5SMqB436F28Rbrpndi','790835628','adayekh999@gmail.com','علي','الكردي ','2024-03-06 13:08:57',NULL,'inactive',NULL,NULL,'XX5G+PFQ, Muhammad Az-Zoobi St., Amman, Jordan','dyfW-X-VRW2RwrAwrOrX-3:APA91bGW2KY4Qq93rJvzohi-eISXZXjwBz2WsB3j32vUgXHHX1dr8iaAb_12Tlg7JLo1FWTchSLLteiQ1rVqPQSIJibhAQWfPxkV_Y6sVMCKoTrWyS4y9RhyjLtVr40evzieK253AVK9',0,'Amman Governorate',31.959019,35.975974,'enabled',NULL,NULL),(197,'vendor','$2y$10$n4c/exxQxup8wejLftn5s.rTf8nR/7HQNbtmICfqShUf26F.E5I4.','791919707','aa53aaaai@gmail.com','نزار','رفاعي','2024-03-07 07:24:35',NULL,'inactive',NULL,NULL,'XRWX+F9R, Amman, Jordan','d86k0g2kTSOXISzVPFYgWE:APA91bF9Jn8YDQ5Taelnwm3YLqLZwGTSeva4kx1qVrJuFmCxy07GrGDEoVQKlJLTm04LwI12mQEmr39kfi1GpkuNug30s9ZTEs4Km7AJr7KE_3Pr82YSjKhl75eqV17_vIG8ZSSD-P7V',0,'Amman Governorate',31.996212,35.848333,'enabled',NULL,NULL),(198,'vendor','$2y$10$FyGs4.MDkmhMvtJvKPwIv.oyxQ88e9E18/3XCTd0FLhW74NmVIrsO','778482873','jedadalm55@gmail.com','جهاد','المحاميد','2024-03-07 08:30:22',NULL,'inactive',NULL,NULL,'البيادر - شارع الصناعة الرئيسي مباشرة بعد الاشارة الثانية من دوار النهضة, عمّان، Jordan','fIhq59xCQTyUpjBoENFvOP:APA91bEuLau8fBhypgCCg_yOxxNRsqL5ub2X5G5xVQDH8kl-SI_PmFvdP1npEKyY3E4iXvJKEAKzjGuBEEvgN4kLe5xkHhxyLfgvCjF3U91k0wbnkyur2iShQxKNbBP32sNRE5RA_7TE',44.242,'محافظة العاصمة',31.946287,35.839401,'enabled',NULL,NULL),(199,'vendor','$2y$10$9Bp8LL5zd9LYvqjAhkbPd.XyjBsjGTBrk4CGKgCDakmWdvfhU8zJ6','775803531','h71823703@gmail.com','حازم','عيسى','2024-03-07 08:32:07',NULL,'active',NULL,NULL,'WRWQ+8PR, Amman, Jordan','eBodd00ITnmtOdcaF_NBr-:APA91bEn7D1FZujeXrVGi7SgSvsDeG-gc5GDRIMsm2aKfnu4ZEuOZ-Zqj2LBCrDTeuNvVE11hYMNyqcCZkvBbP6p17Jts7g1Pa99nTopi8vGJjbYvl3r0MrZ0ZcwpeVO1fpP0lGRciN8',50,'Amman Governorate',31.945957,35.839215,'enabled',NULL,NULL),(200,'vendor','$2y$10$tIMdFQn2ZreIxBnPDsrWEeWLNpm1u.74aPzroUmdx9O2N/r6f7opK','795730888','nailalherbawe@gmail.com','نائل ','الحرباوي','2024-03-07 09:28:36',NULL,'active',NULL,NULL,'2X4C+Q5R, Amman, Jordan','estjsa9ITBOSqq9IQL4rWy:APA91bHQ3jSybRbIqsZfnMnVKSzc1DqNUX2eAxRbr20uy42zmVzKHp52SCzEB2NkUYLNMhSJKnNHtHfkKTYAb8YLmH308-RWf6lwZxHiggtpL8WcSLQ53_HZ3uxyb9jnzJAXo4E26xdM',0,'Amman Governorate',32.006742,35.969951,'enabled',NULL,NULL),(201,'vendor','$2y$10$3NnCIFryhu7HsnnY6kkISeiEgtN53RbHYmsm8s3V3KVfzpyDjpIYO','776058115','alrafr93@gmail.com','عايد','محمد','2024-03-07 11:12:15',NULL,'inactive',NULL,NULL,'الدمينة،، WRFQ+MWJ, Amman, Jordan','eGG5H6xaTd6mFcQ1sh8SVz:APA91bFxeaWEZwdz6oCHfsY6eogWiSEWDTC6f_GrgdEAXM16KYb1gzELsYcb0-DgYCd3B4EKEo97g7v_hFYpv13vAG-oG33kOJnMboUxS2zJs-xnTw0lOwcDlal6V296Ozt7ZFGm0a6S',0,'Amman Governorate',31.923787,35.840223,'enabled',NULL,NULL),(202,'vendor','$2y$10$Iy7O8RUBiknS.ryPP6hsfuoyll.3SJfkNn/jFcNyM.jf3whzju8xi','791070955','cjjdcdijff@gmail.com','زياد','العبيات','2024-03-09 07:47:29',NULL,'inactive',NULL,NULL,'Musaab Ben Omeir St. 28, Amman, Jordan','d4EYeNaHS5GlE9_u00FzE0:APA91bHuHdtt3xBLpEfH_r_uw1WNASlIMaC1kehR-F_rnrPjQev1j7RrUAUH79DT-OhBqKRPej6JIOYxmg8OsjqkGkiff1wBuX6bKaNqH6BkoboEdLLW6P9Plhg1tM_b9MFQUlvweRN1',50,'Amman Governorate',31.920300,35.933580,'enabled',NULL,NULL),(203,'vendor','$2y$10$PtEh7DJV6pbiyvuV4KF4nOuFfIY/OGR.bTeb0AfdlzrmJu/uKVDiK','795001887','alselawiimustafa@gmail.com','مصطفى','السيلاوي','2024-03-09 08:14:39',NULL,'active',NULL,NULL,'الاندلس،، VWP8+8HX, Amman, Jordan','cdJ8FyLsSRmKqBNlHa5o20:APA91bGU5Yobl9HiaPK4C74E_1qS1Lfyjtgz16Dggg2YKb6_wRPThY2SMcftHgk8k3vBy-7akohsbEsht8J0hnUBGi_bW7jPLNlAIEtJVEKD5apKU7yfx3F4VPj1xjadIY85DlFFwT3_',48,'Amman Governorate',31.886333,35.916915,'enabled','1.0.15','android'),(204,'vendor','$2y$10$e2KlVkNg8qP9VHWA4F9P5uk.zH4KfqQKcV.GCbzhKjIgcYDYXaDPa','793030993','bandarsameer578@gmail.com','بندر','سمير','2024-03-09 08:46:25',NULL,'active',23036,'2024-06-27 15:19:38','XR2Q+J5Q, Abd Ar-Rahman Al-Husami St., Amman, Jordan','fG77UYpATTCQJcKPfgzQG3:APA91bHrRYMdVmcD0EbmOAwAZevZczqPOEA-tWoffDs6vqFc2xvokW3ALJfTloa_jIpJpEXOeqp9rA0WaaVqp51JgxgomJdiS7P4byxZzJFXz0997EAHz-9X7yEHVq-Y5d69lcxJVbCq',50,'Amman Governorate',31.951158,35.837764,'enabled','1.0.15','android'),(205,'vendor','$2y$10$IEhp22zZET3UyEYwseTmk.1HeZ/sUtyz9npz5squxxQ.QOfGgblk6','797229393','aa8931121@gmail.com','عبدالله','التعامرة','2024-03-09 08:47:37',NULL,'active',NULL,NULL,'العاصمة عمان، Amman, Jordan','d0_euICsR6m3aeXhkWz04q:APA91bGQEY3z9Br7ufKYd02sHl82f7FwJ_OHr6kAypDahUWr8C6gQcJpR04zs2q32xd1PVRGrWuzpHPD2wSnZre1krbRKQdZXxUbIXoj5yxmUDZXCiOpxve_XlbsgAyjczxG9VRQqg95',50,'Amman Governorate',31.958860,35.870587,'enabled',NULL,NULL),(206,'vendor','$2y$10$WGPeygIOgZXaavmLQiwp9eqbKjHLmkiiiZaiKcwl/z1i4EHDH79J2','777764443','rami.jreisattt@gmail.com','رامي','جريسات','2024-03-09 09:40:37',NULL,'inactive',42697,'2024-06-29 08:17:13','2QCV+F8, As-Salt, Jordan','c7bB_HiySvCklXoxQwW7ux:APA91bGwMMPRobg4-1gUsn82aZdW9dVQsy1a7O7GqC50ZAXDetTdQk6b6mZ2O4dbVR6QOC8irJercXk_SSLFV2YacUwE71-prklrZ8aamZzEFuh4MliOP3TCrGx0L328UAU4B-AEBOJa',0,'Balqa Governorate',32.021783,35.792096,'enabled',NULL,NULL),(207,'vendor','$2y$10$nAGw.uGazcMs/zhYLFdgUukHxTZrctJeZmBq2HriO7YMHMhIrMy26','796847561','gg619695@gmail.com','خالد','السوالمة','2024-03-09 09:42:00',NULL,'inactive',70135,'2024-06-29 10:26:18','2R8V+V5G, Amman, Jordan','cA0u5zb1QciQarxYfX7aX8:APA91bETEfZ3Z7OqOjH-jx-ak1IDYrbbD4iVsF5_MyKDBx828LPj4kWVyh2QyH6A6B22Env7pgaqpusbcGrAqiVHdItSQ4kN3RkZppZnCizkZvEj3eO8JyRamPCA487XGLY0vRnTQEaY',0,'Amman Governorate',32.017128,35.843056,'enabled',NULL,NULL),(208,'vendor','$2y$10$J6jPNmhodgPYyDwi4R8V0eXc/wWyKxzfgIiMHG.wsLuTQrjQZ7ZT6','795408702','Adsm63169@gmail.co ','ادم','حاج علي','2024-03-09 10:02:32',NULL,'active',NULL,NULL,'Pre.tasniem Street Fuhies -balqa, Jordan','cx2U7QCkREO0K-40t0KOss:APA91bGewj0EcNwUr79BU-b3-qg5paxDrMJSy4mUC69bkBlsgyG2zDSRX68Re_T6urew4lgmnhSr-12qCCD4I0rZlqsCrps4AfM-KdpJitCwLLKkTrYzM6jHIA5iXvO8r6Hh6s6W7yPG',0,'Balqa Governorate',32.006163,35.787721,'enabled',NULL,NULL),(209,'vendor','$2y$10$yxQVvD5X7vRkWpEhkkQJXuMxG/Gm1YJ6c9Aqko3xluf1o.S/ZMQ8e','785230001','mahmoodsokar9@gmail.com','محمود','سكر','2024-03-09 10:30:30',NULL,'active',60750,'2024-07-04 12:53:03','شارع جرش 35، Jordan','dXYPDLseSJq7hhIYBV7P5M:APA91bG-r6yYfNhF6NiEWHj-m0PCkSFbKjw1sj7t6-1kymkb_paSxSuU7ZfASNnS3-iRaOtPH2AjMbNcTeWd7WMTywt88cS7GFQt5cQfgbGPpnUVnPXyAD3t20hKTouwMELDBJJJEJBG',0,'Balqa Governorate',32.062447,35.841182,'enabled','1.0.15','android'),(210,'vendor','$2y$10$hKlCxEtzrjhLRAtgfVMbBuRN6zv.m98QZwX/MnjjmjIF90K0X2QPa','786533333','ibshalan19988@gmail.com','ابراهيم','الشعلان','2024-03-09 10:34:44',NULL,'active',47799,'2024-06-23 11:00:52','2RCP+42P, Amman, Jordan','e79t_MY5SqeHbZhjpW1Jag:APA91bFinpNzDR8Hmq_hROzpk4myQ-Fy5qooESaHXCpEmJCrHt9Cui1Ls05UYbhDaQQvKTXJWi8mk9I_1WuUI0N11tZUs2J0ys-x5Vhz0ABclWnKSO0183qyVxRxGjylKD1BAL67RtkR',0,'Amman Governorate',32.020473,35.835233,'enabled',NULL,NULL),(211,'vendor','$2y$10$EdnCOXmOjbhYdgqVO6OqtuvAoL.6M/iaWdlBBHkn45E4yC0N3kKc6','785201619','o.alashqar79@gmail.com','اسامه','الاشقر','2024-03-09 11:57:47',NULL,'active',NULL,NULL,'X2MV+43X, Amman, Jordan','ewbPfjlKR5CnaqlEZaCGoX:APA91bHWGaKgAvPKAWS2Fc50A9FO0EMOOZ1rLzSoo_RZEgvuJcuwAaXODGx5SemcMuKwGGNbqsQycDxJMh4uqM3v9WOUM79lWmHlQ4-J66LHfj7kdnv-tbj7Ta5-TGEdwTfIEQBuUQ4W',5,'Amman Governorate',31.983340,36.042367,'enabled',NULL,NULL),(212,'vendor','$2y$10$hhfdxU4xc9udgFRNCywZ1.0h/9A7CiEBT.yl8mjar7HEADoDpRCee','790301314','arjanwhater@gmail.com','علاء ','ملحم','2024-03-09 12:11:35',NULL,'active',NULL,NULL,'XWPJ+V5C, Amman, Jordan','f8gNPnz8RBm3YWWKqNcDYn:APA91bGMinezPwF6hoRRvh2pFFxxYU4Z4fBhXmWkk_Ew30moy1ooM7BluyNr6GicaT2JVUfi2zFaFq4QTvUfOHKQj3Ip8HTCugX-uJVJkL7z82oU-PfranFmIt7XDJqhjmSBFCoNkTwv',0,'Amman Governorate',31.986993,35.930213,'enabled',NULL,NULL),(213,'vendor','$2y$10$Iy3xDPTxt4BFrpMz8SWHzusM6oMphmT9TxQIItPc9eecpjhyw3rSe','798732062','ans964967@gmail.com ','انس','ابو كف','2024-03-09 13:10:59',NULL,'active',NULL,NULL,'WWG3+V2 Amman, Jordan','dmRIgex4SkW1ZqYjQkZllC:APA91bHaJGo_WlwEsKPefhv_ix7EoBJHg9jV_Kzu9atJ4xcRW537QZwzITbrfNEaLQgf0lhsp5H6cO7FmNctQ_-A6syv6j-rq_xRpnfVUtRz24XoyZ7K0vZRrxR2tDndm4rwBAtODfs8',0,'Amman Governorate',31.927190,35.902582,'enabled','1.0.15','android'),(214,'vendor','$2y$10$BhkqVt1D432y8.3EV2rQteMRQhO9N/PdG09cHzn6WIL2qYijN3X4C','782121455','eman. negem344@gmail.com','انس','قبلان','2024-03-09 13:55:50',NULL,'inactive',NULL,NULL,'Khadija Bent Khuwayled St. 21, Amman, Jordan','eQB3jvuUQZKnX0fJfJ5RQ5:APA91bEOjTO_Z0IppnxdzdB0l6l_Z8-IHuna6b7p2bXbFRQRyxK6guEDHt-1StdbBmMHZhhrDLgp6gLWFtbit_9JOUjXbmgKjZrylZne3zS6nMUvctPRMn-gX4k0h9CzhMY42hnsn5nA',0,'Amman Governorate',31.918076,35.936406,'enabled',NULL,NULL),(215,'vendor','$2y$10$a.MGzW5pQWgNdkC/GqffjuTRanPnkMK/ez9MyUI.BBBF/ghzbrvYa','796060889','mhmdadbwwdhoi4@gmail.com','محمد','خليل','2024-03-10 07:15:20',NULL,'inactive',NULL,NULL,'WW7W+MP3, Amman, Jordan','cer6PjRFSKuoSDPHEF2qxq:APA91bE-C-im3BIa0sz8meBdtY0-tydXvqVgUtpQjRaJxDuIqsSnOkf7wsh04fFQcGYo-xZDCAyyRKS_yGnD5wsObwAQxVFSnnlr6HUMYx0uikqNfKI82ixs7IXwMuhhzevmKAQdAB81',50,'Amman Governorate',31.913767,35.946981,'enabled',NULL,NULL),(216,'vendor','$2y$10$NJ3tqbpxgrKPwCG3n/6JG.nx7bp.YZkpxcknEFkcYjvYDRVNvrTMS','798690445','mmmabwmhmd89@gmail.com','خالد','حمدان','2024-03-10 07:17:16',NULL,'inactive',NULL,NULL,'3R5J+PXG, Ein Al-Basha, Jordan','c6D-De3gSFKtEd-WpQeEB8:APA91bGfb-p541-2me8S7g_uFFo5ejxDpBaUpw42ifw6JwlwKgEbocdoZQuKOpgfoeYoa4vBeqIC1gmyxYpF9RYUx0LjveJKhfo1CbxUoNnD_XA0u_w6msu8zol9hbG5EbM88A97XLtc',48,'Balqa Governorate',32.059312,35.832893,'enabled',NULL,NULL),(217,'vendor','$2y$10$AyL16.STz8gxg7bD4frCTOEXUsMIGmYdWWX8.wJHh/InMmRqzWwZy','777804500','almanaseerkhaled21@gmail.com','خالد','المناصير ','2024-03-10 07:41:30',NULL,'inactive',NULL,NULL,'WRWG+VH3, Amman, Jordan','e1CHvxTRRM6veToCF7Mu0z:APA91bHxeIevoqrcwiRC_tHMuD0tDHoJH_Ggx_dV7p1cz47sWROBezBzsfWGjVj0nwiCl5IaqLvavVkP51wtYdBGu_QvEdLZE9cN7ZDWYFMLrCAVBj_QVr4Wy1nHlsvoIPi1NKdADq4W',46,'Amman Governorate',31.946963,35.827248,'enabled',NULL,NULL),(218,'vendor','$2y$10$dICneXje5x6EbpwqpJlHo.ghm4HlEFiXHGo2eqGNZ/k6VgR5g6IX.','795788216','huufvvco@gmail.com','حبر','الناطور','2024-03-10 08:27:34',NULL,'inactive',NULL,NULL,'WWCJ+6XC، عمّان،، Amman, Jordan','c6XCpmdPTs6FQ2Hy3FNB56:APA91bFcz0GmzFCY7l06Yfl5DFnid-HczYnUyb0ig6ZISYYIcpWB9bB37BZaYEDVo8QYe1obA6InqlQUsjFxMNwnW1Xw7CwgplRgakXWm0zqKlAmCdWklolrqUJWJA2PfydkIKyV4NzH',50,'Amman Governorate',31.920351,35.931895,'enabled',NULL,NULL),(219,'vendor','$2y$10$pqhfM.hNdQwW/QkYs1W4s.waOc2QGKNNyfLi5A1JhVoDTj4eYM8Zi','790365610','aboodwahdan78@gmail.com','عبدالله','محمد','2024-03-10 08:56:26',NULL,'inactive',NULL,NULL,'2VH6+CR4, Yajouz Rd., Amman, Jordan','cDWuJkAsRDaVqZ-Q35pc-f:APA91bFxsCPDuqQ3G1UF_qOXkcAzsUgpIdfJekhbBXbbJZrmm7FIotD8BQSkhm0DZdofmDwX4544fko8r5X2hBLn2LMpjjVbvVdO5t1aFY8ixVQ27vwQzKlUu1cGDi4TRMBJBSiiT9N6',45.9,'Amman Governorate',32.028581,35.861980,'enabled',NULL,NULL),(220,'vendor','$2y$10$rlKK2bq.3t7BZdGuRra/POM2wDplSLMVMHvXHm3H8tPpEwz0MOZcq','788461610','kamal28556@gmail.com','كمال','الزعاتره','2024-03-10 08:59:46',NULL,'inactive',NULL,NULL,'WWGH+X24, Amman, Jordan','e44n8DRjQUWBeL9pwn-sHE:APA91bH6gkHm_MyIxJAIHcxb4AfyeQ4THVaFpYq89sxanUq42ChE7L-xyPbxCrgz50plbrJL_yYNNkUpTY5CoXYb4PYeOytb9f_mG1FBfS94pSBEpZE5PljabdNNDEjQtRuvQA2P9Xxf',50,'Amman Governorate',31.926741,35.927437,'enabled',NULL,NULL),(221,'vendor','$2y$10$nKkrHVKRbUdessbq3SNs6.HfOCqwucMGzYQXTITQo6u4jkmmnEfm6','777200609','feras_znemah@yahoo.com ','فرلس','البلوي','2024-03-10 09:18:58',NULL,'active',18666,'2024-07-09 20:21:45','البسالة،، Amman, Jordan','c72VWQ4sT0mZEoRrfLDd7p:APA91bHeyCTLZD56IGK612AqgrSaGb8uLZEYtw0HEt_TvbVsf4CaqFTRr0blmmJN5p1jN3Tc0ao9XgBHDCSePY9BfkAMlTEeVbxrA5Ryvr2cYqkILqMkicXtQ85laHlX-y8OaHKfNDW7',47.5,'Amman Governorate',32.052395,35.878405,'enabled',NULL,NULL),(222,'vendor','$2y$10$PcjZx.4Ke5vyeqRcHcynpuZsmjBm2AEqQ0aLhSppfcyeAmp/quVSm','795277021','fares.mahmob2002@gmail.com','فارس','الكوز','2024-03-10 09:19:19',NULL,'active',NULL,NULL,'WWFR+P75, Al-Mukhtar Ath Thaqafi St., Amman, Jordan','fPIBie6SQs2NYXXSZGl1Rl:APA91bGEU6HnHWkokfOeq_uN3O5kITSO25b-x2FXPjMpiV1qQ2L7lMCviX4XftsxCZHzU1DgO5GuEviuJEvbPmc69FHLcnQPiEawrmZ90bBHXvSoN60d7tikSvDiZPTymcWu4yIGDuVL',50,'Amman Governorate',31.924328,35.940878,'enabled',NULL,NULL),(223,'vendor','$2y$10$ZnKbraVTOL5YlvdZsrKm1.pSNm98VwaosfPBqjO.RuW//I1xgm0VK','795371477','ayaamahmoud1982,gmail.com','محمود','العيه','2024-03-10 09:41:40',NULL,'inactive',NULL,NULL,'WXQ9+3FF, Amman, Jordan','d-ADlc8SQoqUlTdjJ7tEHw:APA91bE_914osBIO1ut08ffj47qhEsQHvH8XXNSB6h1TmbKv_d2H9b5LvcUOOzQeOK5OCE3tELaMrGHhjmFNXzMsUQ7p2VoPukxBLcsMvr7CtM-51vmayPrZ1mW-ik1BWiZlJOzMlypO',10,'Amman Governorate',31.937385,35.968299,'enabled',NULL,NULL),(224,'vendor','$2y$10$EU4TucltIr/BLbLG3sZSKexVQNBt8Bu8g3808mTwNE4GH1PrG5W1u','790275710','abobodshanab68@gmail.com','عبدالحميد','ابو شنب','2024-03-10 10:09:53',NULL,'inactive',NULL,NULL,'King Abdullah II St 393, Amman, Jordan','dThXwbdZRuaWfWRACBAXWZ:APA91bG2kfvJBQETal1sc_i-hIT6spie9OQQjEhA22Xh8MqA86n6NvVMPqTNpNoHMKOrZdraYlTgPnUzQZWrSYhLabuNrxVcubp59xTnEMFYoP-GFcwX6dSIogVE0StG0AqrRbxvXWR-',50,'Amman Governorate',31.967118,35.842347,'enabled',NULL,NULL),(225,'vendor','$2y$10$SjOWForPjgRH6We9OahKEOha3dzgG/fuU3geHWdbrLONtVvxT9c/6','791259495','fadealabade120@gmail.com','فادي','سليمان','2024-03-10 10:51:05',NULL,'inactive',NULL,NULL,'WRQF+HR Amman, Jordan','d3KXhp88QX-bhL24rrcaVJ:APA91bF11IU-phCWFkQupSxhmOKub2BU32NNXYYODnfKbje0yOV2vs3_4OWVrPEZYKQyhPyrDQNuV0dboTBCfhX-zYbxdRv7jBjQKEHjGj2THNHyp2MOaxYnTUw7zGTA2gTOyaV4nvHG',10,'Amman Governorate',31.938880,35.824550,'enabled',NULL,NULL),(226,'vendor','$2y$10$eVfmzgTuEuQBpwau0EiWMufDeTrJI1RdV.OsxaNSx4nClyLYS8MEW','776587967','ghha97449@gmail.com','محمد','المغاربة','2024-03-10 11:04:07',NULL,'inactive',NULL,NULL,'WRWJ+JMP, Amman, Jordan','eLrkBnetS3OdQ6kUl7uNKO:APA91bFXg2y6BFJG2nR6FD1cK6KKIza3CYAJ77Ze8lYvYSIKph_87DQclAepoRwDwiEkcL9zCIuK_sJMuBlbJyens2fOsEJa8r6RnWtldcGlPjLzWi6NqGqGHlLf9esBEqefyqiczu6Z',10,'Amman Governorate',31.946534,35.831716,'enabled',NULL,NULL),(227,'vendor','$2y$10$tFpA28OYxHSWeWHQNVq9tedgfJtMAflvFSCKsRSaqxSoAykJ3XWla','797655987','hhhyyyyfc@gmail.com','احمد','العبادي','2024-03-10 11:11:47',NULL,'active',NULL,NULL,'منطقة مرج الحمام،، WR42+4F8, Amman, Jordan','fy__2nmxQ6uvj8fvSG1Jum:APA91bE-COpcwgUW_LHd_-gHsfiMfE6IPYPX-MaTdUhLqSw8g7V74G6TUsFPIKoaUzosx1ePkfbD8z-Up7_p9YFDcUF2yY6U2D0Ak7GBxl4Jf70NBjqWjBO2pmuZ3XHTMbB_sRoGPTYO',10,'Amman Governorate',31.905514,35.800552,'enabled',NULL,NULL),(228,'vendor','$2y$10$oa69hh8mXTorMGXk2A6PQupKUNAieiYGERSlKnss5cApANRZT0OBe','790383955','mhmadajam62@gmail.com','محمد','عجمي','2024-03-10 11:12:44',NULL,'inactive',NULL,NULL,'Amir Ben Malek St. 114, Amman, Jordan','f-G5STIYQpqOZCIg9r7NOf:APA91bEbKE7H150OTWzMsEEZWBy_JfmKqW_YLhOg6yjjFSsCs_LhkkZg0nv_ptlcGUI54RN9Ula0G2tWHndvBvf_511hNeiB9VHRoxbMK3vc772oHgqu8ZgY9zXkepHrIX9qmrq0mfT-',3,'Amman Governorate',31.995907,35.849020,'enabled',NULL,NULL),(229,'vendor','$2y$10$fH/GWaWO7N5.mUKbKDZoAOQBilycS06thl3ypssQonh8yV8KaLjLa','780240380','grgsh7@gmail.com','حسام','قرقش','2024-03-10 11:23:55',NULL,'active',NULL,NULL,'XWHM+JQ5, Al-Quradhi St., Amman, Jordan','cryMMiI2TTiDR9rwmVxKfK:APA91bEOtY-KeSRY-9pujaxKCch54FJPfLtbUzdWElPXr3TWaiUBc1qTqFRhCRzym3hblnW5Hw4_frGAK4kVoaFztjbS8R9gOs3ReA93vaqrvuWQMWM9MREJvv7VmQBYUoPE_LHVbQb1',50,'Amman Governorate',31.978508,35.934383,'enabled',NULL,NULL),(230,'vendor','$2y$10$Q0jveOqeMWKqznLkAQXgMOb1QD0suIRaISxf.PLXv07muO920Twn.','778571287','ahmadalslehat1998@gmail.com','احمد','سليحات','2024-03-10 11:33:17',NULL,'inactive',NULL,NULL,'XVWF+H6W, Amman, Jordan','c4LQ-ENWQZyXHaII-XGew6:APA91bGczt9S3fhNY02nsOPT-ItHDtHryincSoSjbS7RDYnmiQ-vmpPXYNl58RyiHjgl8cXesZU5UDhe9KOjbUsHXoaEJ60yW5mHu8-1Jn0ZAD83DI2uSzbugdJcrc2jK-miJSGiePNL',8,'Amman Governorate',31.996670,35.873011,'enabled',NULL,NULL),(231,'vendor','$2y$10$4n77Gyb0U8uHR6/lIl75n.7qe8wyq6stNY5PQVjndaLJTnnmguVpO','799501852','saadalsalhi43@gmail.com','سعد','الصالحي','2024-03-10 12:35:56',NULL,'active',25699,'2024-07-28 07:58:01','XRJX+83P, Amman, Jordan','cbMOk1sTRueuteSWGHFNfK:APA91bE58ipRuTUZryUelRWbfei2xUlz43FzRYxuK9X5bWuexj1PWNxjo7480plaHo6RovjWKkl3p_ipOj-Fxd0BO4I2Wip3nZaa_nq13OFHV17cUoRswQfIdkaBEyIpqJNGUADVJgbg',46,'Amman Governorate',31.981006,35.847539,'enabled','1.0.15','android'),(232,'vendor','$2y$10$zMnGIrx9P4JJ5oMUZtyBM.PoLDzB6QcAF.6s5hrBqHwdizZyXaP/i','788364791','Ayman1ahmad2.b@gmail.com ','ايمن','برغش','2024-03-10 13:33:15',NULL,'inactive',NULL,NULL,'XX2H+FVC, Amman, Jordan','fGy7SpwVSVCxnmUsrw-tzN:APA91bGgOdB8pPS1yTgIXH_K04XS7mDZNi5ZZ6u9tG6H_vdJ7K-3IKNVweQOFY0pYgQwB6sWasvgT1k70-8fvqDqYaFMQbgF1ufVbWEbcX_xibOdfbiVAmJtBXq6ljMW_rUCjcgMiyNo',5,'Amman Governorate',31.951043,35.980195,'enabled',NULL,NULL),(233,'vendor','$2y$10$eR9uXB8y6bypG//fV8nUg.6uuFCq9CjgjPfTyRcMX8t.SPJwql6Ea','785634382','ayadabwslb45@gmail.com','اياد','أبو صلب','2024-03-11 07:40:43',NULL,'inactive',NULL,NULL,'Queen Rania St 376, Amman, Jordan','cyQgDKn8Qw6Jb4iRLZTZK7:APA91bH7hewG9mvDWGI5AjeA2GJMBGwzWDa896xR8NWmwDLBqi2-W8m_swvkWh9Twmgu2RyLK6yrU3uwaHsdw0XXPdwLqGa2e8iHdt0QkgvouCLWFw0rU0NJ6qZAol4yj8MnmWAQfWOH',10,'Amman Governorate',32.024753,35.852997,'disabled',NULL,NULL),(234,'vendor','$2y$10$szGeDfS8hgpw2ReMCaDJJeqW8.w.dFs1xcHx63EjnoBP6BLu3WxY.','795996882','laithhussie@gmail.com','ليث','حسين','2024-03-11 09:32:29',NULL,'inactive',NULL,NULL,'Al-Madina Al-Monawara St 210, Amman, Jordan','fbUamaGtR5y-OhRHuAUCwC:APA91bFJiPEW48ZiFXsMj5-5JyCM-FrptHX2dVditQNpCfbHHsV0q01ARiYOzuWlIGVayL9LDoXIgEcMNulMQt5oB5jv4zZAgayezzuGPCJGQO9Y-5n3UEiIL8trwFp7biKgg8iv7XfG',0,'Amman Governorate',31.989748,35.868037,'enabled','1.0.15','android'),(235,'vendor','$2y$10$gBt4W8UV2HITZXq.xt4Xt.GYsGhGatiGCo3ZY0jIvjBqZpGyHP96m','780151617','jarrahmoath6@gmail.com','moath','jarrah','2024-03-11 10:01:30',NULL,'inactive',NULL,NULL,'2RXH+4H, Safut, Jordan','cs_0Nie-SNuaPS5qUFInRy:APA91bGJB9nrudOcC52yGv1ci1x56TbdyB-IniFZ63w8OJHJSBKJV5rgXQEa-eYKFKx6kKk0c6__55ZSVBYlJW6CX-KKrNaqXAOt9fLtnsRHVHwCIK3oc-nJmdIJKCN8SJXq8YP3FVaB',0,'Balqa Governorate',32.048131,35.828685,'enabled',NULL,NULL),(236,'vendor','$2y$10$.ZftzyvH/ItgouDTUT1rP.wGfqB9UKaDQ2BdbeDQKkcPH6cwn95mm','799414150','alblbieseo@gmail.com','عمر','البلبيسي','2024-03-11 10:08:07',NULL,'active',NULL,NULL,'XWXX+JM2, An-Nahdah St., Amman, Jordan','d2eDLrVmRs6inih12gIDqz:APA91bGnpVdS3n-1kf0r1DjYIjCdy0LNjtwz3RjyKDDKVXpL0xkqeUFJg0fZ5Dt2guiQFZ-Xger9TnAVG2CVBUBhp7b0keZjz5VnfACc_MLnKcn0Uq0yUimpeMOGjb-6Pba6hcaixbUx',5,'Amman Governorate',31.998837,35.949172,'enabled',NULL,NULL),(237,'vendor','$2y$10$wKsNZealfNbco1vs/VTRY.CFqz..5kQWMo090plKwOyTW6ckly5hO','780907191','mohammadalaa.2.m@gmail.com ','محمد','البحيصي','2024-03-11 10:20:29',NULL,'inactive',NULL,NULL,'Damascus St. 64, Amman, Jordan','d2Vj0Se9Rnyarf4ZS0e9RV:APA91bGS_XSme0FaazieBS7gXZLryEpEUg4WV4VsTTQrfi0E0CHOlvtONr1F9-V_nL_lGf8YTDQNxuUc29xh-g2OFvjVF38IB4JPIBQI4vIDhSW5KrvJ9eqEl6QgGe0LGR8D9d0EMx5m',0,'Amman Governorate',31.943241,35.901452,'enabled',NULL,NULL),(238,'vendor','$2y$10$Et.9wX6MgvB0cExkfeAkMuQnhA5po/ugzRk8QwxEu1rmOwDd9NSPC','795221398','alqtawiahmd95@gmail.com ','احمد','القطاوي','2024-03-11 10:34:07',NULL,'inactive',NULL,NULL,'Damascus St. 64, Amman, Jordan','dSFqAlTmS7KNWGe2G-ekQE:APA91bEEQvkzB-kjdsEPwc9Ptwq6j4ZzJmwpZ8K316iK_TKveezdvQsQc_eV8kxMO08R2dyZqSP8bMgMOa9fD0cctLgOF7MsubcLah33Qdm97cYXBa8Ik-pc731yhtZ5KiZrH7wcvcoR',0,'Amman Governorate',31.943255,35.901455,'enabled',NULL,NULL),(239,'vendor','$2y$10$fjAb7ImRhYD2rdScxuk6X.7rNZXblqUAvIjAR/gJAgQjXFrKXXTp6','799531138','alslyhatmnswr@gmail.com ','منصور','صليحات','2024-03-11 10:42:13',NULL,'active',NULL,NULL,'العاصمة عمان، Amman, Jordan','e3SBlr_uTIKhJPjKHJP7NG:APA91bGte3xwNKU3NTlNpZ3ymVzbu5mWwGGVKWr-0hMCLsNwUqtOpMobNnpcDpyjgEa54YhxjXzijWjVfeorJGcSq36n3JuSh5cnXtQFNzJarAmRVy050_KT9W0f0NMGHffoP9jmYAz_',50,'Amman Governorate',31.958455,35.870326,'enabled',NULL,NULL),(240,'vendor','$2y$10$0jxfD5jG3WygPm9NAAby3ezfFcv6t5tP.ZE9qIKtv1NhL.8GV5fuq','795034237','morad.alabady@yahoo.com ','مراد ','الرحامنة','2024-03-12 08:34:01',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 166, Amman, Jordan','cgutgJAhSZSfMpKfVKbk6O:APA91bGukXy2uvEdvh4TzCMdBlOTk0HbW5_1OTWDm-WwFlnP0Q3gkBmQHjuBDelGRe-4_wbL-Slt9NrPxONzjFXozAT1adbubTQ1PZx9b9V_0Tt4Q2cw0lzw_ocdhiGOt7zi_5YJ76jI',3,'Amman Governorate',31.991788,35.867010,'enabled',NULL,NULL),(241,'vendor','$2y$10$l0quCg1CXR04mZ26IrGN0uOoXa7GSXvBN7kmkl1mBrKXjBcg1KS8W','796303002','aboodawrtane115@gmail.com','عبدالله','سعيد','2024-03-12 09:10:00',NULL,'active',NULL,NULL,'البيادر،، XR2F+VV5, Amman, Jordan','en5BIYQDQPmSWdM-kmWnT-:APA91bFiglmJSG4133pk83n2IpK9gLYg6eId5fJLfKFoOw76vjoYwLdLIJULENAaqCKHpYkkwF7WayGujvwfAzKKAtx6qDKrYcdj17L265wIpvTNKK-NGs5TjWeqFza618_S0BokSVBt',5,'Amman Governorate',-25.877451,25.652932,'enabled','1.0.15','android'),(242,'vendor','$2y$10$TJ4Lk.8Tf9jbexlMKHy9euvCGhIvN0kvSaZhW.USJ8Z1VxhDorjbq','787711494','Ahmed.cat23@yahoo.com ','احمد','البس','2024-03-12 09:37:53',NULL,'active',NULL,NULL,'As-Senaah St. 2, Amman, Jordan','d1mv6qmLT_ifzeBP5GNLXS:APA91bEWpyjp6M0Vegreem6Lkwb8-Ssk5Ai5j9g9Fi3KaRdFX1M3lX_2NF5hw2d5sGGHiL0xjc1HmIVCzP-U93mnZ1JAlDrJL1becgA5cNgFQNuqIk_zhi0Sfb0NXBjQTj92vKX2bLsO',5,'Amman Governorate',31.935398,35.817327,'enabled',NULL,NULL),(243,'vendor','$2y$10$rYv9wNRrNLAGBSQUM3PnXu8Tx4.e2en8xqXCRM9PdNevQrL0JMmNi','777576785','druhs568tr3@gmail.com ','علي','حمودة','2024-03-12 10:24:56',NULL,'inactive',NULL,NULL,'WRWJ+QMF, Youssef Tawghaj St., Amman, Jordan','fFcdNuv6T7egi8JyqmiGgD:APA91bEtMl5aUfbnjzUT14GisQbJHt6tttQ1ZS0DmWmNlDEedtmIeDe7-CpbfvBiNRI_lmMIEnfufJHju3_q8uYRDuJRLUCkyzB4yc3AgKHiYDnEYZXnGoZp-dKTGJuUagCRyjfqV-e7',0,'Amman Governorate',31.947009,35.831650,'disabled',NULL,NULL),(244,'vendor','$2y$10$5BTkVzhGNBZxcQdoB1KGW.fYvKezxGc1nDVTmU8FRH9ftUqSh5Nvi','796244374','ddaalk52@gmail.com','مصطفى','خاطر','2024-03-12 10:34:57',NULL,'active',NULL,NULL,'XW5Q+89J, Dulaywan Al-Majali St., Amman, Jordan','dQwp97rVTiajwuqlaGZ9DK:APA91bEY0Uub3d8_557vFZO_UfV4MIdn674-Lt3xjAm-UmYGlx0xYdi3cOyczIaG2jEMcCbASMiKRcYeRfWa8PrssNSKctOWOP4NyBjzGqFL8fiH72Re4ktnz6UGALdjFUzlrpAgsoUv',50,'Amman Governorate',31.958285,35.937764,'enabled',NULL,NULL),(245,'vendor','$2y$10$AUwsCNnTV0HCc4Pf478zUu8vOXll9bQ9nAkjOJRsgaQBB776eLpJy','797379366','mwbaylalashbal190@gmail.com','محمود','الميمي','2024-03-12 11:28:08',NULL,'inactive',NULL,NULL,'WX89+C8G, Amman, Jordan','dGME5DkcSHek2Ej6iy8uuG:APA91bGHQIQtOnuIG0DQrYxO4FmrlioZLsMZ8xPtSSygSpiwz92YDY5zR2CXzlRA8_ttvlCp6JacS5YRo3-PYmYeaSE2lUReITgRbtgFFX_pIJY1646AhG5Y0DYXEREkTu5NEvRr__lX',50,'Amman Governorate',31.917199,35.968475,'enabled',NULL,NULL),(246,'vendor','$2y$10$NwlXqePWKUr4xJtPR/YU..Nro99np3EDeaLanpBKbA2WlluEMBYS6','796091356',' ywsfalflwjy29#hmsil.com','عرفات','القنيني','2024-03-12 12:06:30',NULL,'inactive',NULL,NULL,'ش. أبو الحسن السلمي، عمّان،، VW7H+FM9, Amman, Jordan','dutebYsHTL-FCMj-Xyhgk_:APA91bFgcl_Ve8QM74K6OBb3ktg5C6CUdD5peup7-kUKibIWKpmXHNcrcDU8HlB-TJSUEcQi4Fxm2aOb_A8S6mkbkquq6ga5HTz6Q9jDOfEugeXL57bOXeSOi3KowBpmrEeLprhKzhF0',50,'Amman Governorate',31.863492,35.928393,'enabled',NULL,NULL),(247,'customer','$2y$10$1memU5YmT2nNCjy8DHxhl.Ofj08VodmlfheJzeh8VJzUN5hn9Co4q','796045904','kordehmohammed@gmail.com','Mohammad','Kurdieh','2024-03-12 13:11:33',NULL,'inactive',NULL,NULL,'Tabarbour amman, عمّان، Jordan','cFiYtcLwdUmli09wrmP4HT:APA91bG0wCFMQ6XVgY71HrVU9PyPP8hi7BNIqS3X48FO-E-Go7uo4b7o0IaJcNZ2c2PK8TmjI35OaDnQdAfpNbjM5ySJrLi66WtbuS2Zg332ewH6G_W-3X3MVUAmNmC0nPXapNCEFmSW',NULL,'محافظة العاصمة',32.009159,35.952156,'enabled',NULL,NULL),(248,'customer','$2y$10$guDz8iUeZHG0XlD504eG4OIOiSAtiAtUy7PWHqjg0maTDhTqn/oPi','796885362','raghad.daher.33@gmail.com','raghad','daher','2024-03-13 07:29:51',NULL,'inactive',NULL,NULL,'XVQC+XH4, Amman, Jordan','eokvoGmQ409IjJB6ZjLQ1U:APA91bECBmhspHlSLLIXZZz9Ou5Cmwgj8vKzA5GSxeS3Z7zG3SHpus0c8Dx47qXMyeFpcKsLlgex26Uob7zLJNNWfA6SJG1oXxr6Vf8VRWa89Kt-TL3-4F-zFav34cj_qTA0--0_005e',NULL,'Amman Governorate',31.989939,35.871478,'enabled',NULL,NULL),(249,'customer','$2y$10$HI6mHJUtfzlfdkLqjk8wb.PCj6MvMk4czEWFrwPBdmKFUHyUmC2nq','799795313','amerayyad00@yahoo.com','Amer','Ayyad','2024-03-13 08:14:08',NULL,'inactive',NULL,NULL,'WR6H+5WJ, Amman, Jordan','e0gc8ch5OkK8pPLDX4njWR:APA91bHoc017ABfEbTjRtLUYct_mPFonMdDgL_AhDe2xj15V1deUSza-eFRaksCoBcvhMoEbF4c3pRkTHiQ9EJElQ0lDFZOdowJzUnA97sqVJp8TgwGrR_OrZjzldkROn-74wnLGRjFO',NULL,'Amman Governorate',31.911250,35.828505,'enabled',NULL,NULL),(250,'vendor','$2y$10$6W43naeGAkZRPw5nRtcmdug5PoxwS7a5MA7YzKY6gr00KBaUqLOVu','798127798','amerdweik7@gmail.com ','عامر','دويك','2024-03-13 08:21:27',NULL,'inactive',54548,'2024-05-14 09:55:46','XVQC+PXF, Amman, Jordan','eN90OTnXRYiSbE5j00udIo:APA91bGnCWf_wPeVxNDuZKDP_IGV5Z6PRvtvEZNZfvTYM1pr6BTF6c1p4YEgIRxhfwM1xptq3G628uYaO_6Nku_XVUOKAMBg7z2e_Xg9Kf0LBT4OQ676yB0Ub6h8tJYsi90Co9bCixgm',35,'Amman Governorate',31.986307,35.867613,'enabled',NULL,NULL),(251,'vendor','$2y$10$7nXQbJs39ShwIfJrZrDbQOuEfnLuQFgebowuqSYpdBAuQWSF/YFaW','782303077','pickum.sales76@gmail.com','sales','PICKUM ','2024-03-13 09:34:01',NULL,'inactive',NULL,NULL,'2Q8W+P2, Fuheis, Jordan','cAzXssffTs6_aJLrT0dJL-:APA91bEnRqfhfip4LzcOSIxT1VVsH2gIHv4J7D06wMHQaGtOzqNHOsjq5JcMEzkopjt3zLye5tkDQSEtSNexTBFWZkefXzBDEhMuh61xbnEJLhiEeJe3IwpiyC6-vxfGp-8eV0fqc0k8',-2.5,'Balqa Governorate',32.016621,35.794461,'enabled','1.0.15','android'),(252,'customer','$2y$10$M.bXYjO0B2QUtT3et3yJxOUjq8fgaocfEx.Mpz.R1EZRJFVqYS02i','782303072','lyannjah502@gmail.com','نانا','عوض','2024-03-13 09:45:45',NULL,'inactive',NULL,NULL,'XRMQ+875, Al-Aayan St., Amman, Jordan','fF88rrXAg0VTlaOTB-KMTQ:APA91bGQXxwwU5D3hIY_JpyBIyu-BH8u6JgcIwVCpmGu7wABvuVSLJ73FUv5C0RRFTgpU1grPGQ7pMFeEuyF_53eQKmyqXWKO9aOvlfzx-Dlwb5RTLxFaxP1q_zKL2SB9tgyZEUA7eao',NULL,'Amman Governorate',31.983463,35.838252,'enabled','1.0.13','ios'),(253,'customer','$2y$10$SxAWOvMl/NqdXwQ0Z4vdT.WSG36DC5daAvtDqswZ0idtLoVp4b5Qa','782303074','alijar112@gmail.com','علي','جرار','2024-03-13 10:03:20',NULL,'inactive',55128,'2024-06-09 11:03:48','Wasfi At-Tall St. 18, Amman, Jordan','dFuM_MRVRWCnUksg_qft9n:APA91bFoP1sqCMcZCAYIayGyVeZyTQg71ZR3AE2EYQJlGo5JPmnm8kvxv2gmAKWGvkxnzHVPQFsgfAnmbsHwF8dVsILYtU_xMv1nOevEVxudypL6Zv3j0YCctXuuaZ1UG5VoRS1AfQIR',NULL,'Amman Governorate',31.989841,35.871400,'enabled','1.0.10',NULL),(254,'vendor','$2y$10$cbSIvgwfTN.5ywsEz9MrNejZSE.XO6.5BoauOdg7Fp4UsvVp8uv.W','788856179','ahmedatteat257@gmail.com','احمد','عطيات','2024-03-13 10:36:36',NULL,'active',NULL,NULL,'VVQV+94Q, Amman, Jordan','e3DmsX2TQOyyu-3lB4mYx8:APA91bG0sVPoqz3Gdx3mqUh8RxieqJmIt5Rt-ttY-v4BuTasCH-e5bITLSk6xmMeEJa4L8Dpg-VerO3doKiZUit1dl7NxFqbSzdC7gnMxPY49gFlGlpWpvoMukn66iNwX9yssunBDJ-j',5,'Amman Governorate',31.887879,35.892767,'enabled',NULL,NULL),(255,'vendor','$2y$10$VoD3VT3XKe8xItsc9BclZedZc/tjtlXr4ZOOxYlztkkUc2bOkN2iK','796523738','ramyabwsnwbr@gmail.com','رامي','جميل','2024-03-13 10:53:25',NULL,'active',60244,'2024-06-07 17:44:04','Al-Arab St. 1, Amman, Jordan','f_zf2AxYStebMkb2PvqlkH:APA91bH0w1MDqa6mO6LcPosKGeIk_R3Bk1PhpAQdgqgx_KrBLZ4j7DMSuVjj8DsuQ9ZXuyx9XnUZijs41kBKbsGbVSG7WDv4-gpb7NkKWeVORlIssQ2isvXcteVY7E4sBf1Dn7ftEdZ2',15,'Amman Governorate',32.050142,35.885473,'enabled','1.0.15','android'),(256,'vendor','$2y$10$qYzjLK7D3E1s19kJGSA4reXM2BJDVBfcjSaJ91u9JZoLE/AVPriHa','796507993','alishanab95@gmail.com','علي','ابو شنب','2024-03-13 11:32:12',NULL,'inactive',NULL,NULL,'WW8V+9GP, Haram Ben Malhan St., Amman, Jordan','eLHX317aRjyHO2MKfzPZ1P:APA91bHHW_4MMKvvULN4SlpIcWaaA5HbqHz0jUsPNlqLPpVr1bFJ1ZAnWUVLTdWLCYEZ6PPIoTafG_kyGP5HoO8AKHEgM49nVvyvWXUX18UQ9IKtcMH4XGCsn0MGLk6UskJI6c7rB4zu',50,'Amman Governorate',31.915969,35.943506,'enabled','1.0.15','android'),(257,'vendor','$2y$10$CeaDFmHXlStqlksDvdiRU.pjnuYiW5ChaihrV1E6WFb69MmPi1S.a','791159646','hmdyabwshqra@gmail.com',' حمدي','قرقش','2024-03-13 12:03:21',NULL,'inactive',NULL,NULL,'WWGW+WXJ, Amman, Jordan','d3bTZOboSxmI5irIoVuLsl:APA91bG1lMsQYGtLBveQbKCkjKDiJ6FFiXG-5MGttdAFf1u-r9S80eJughkeFRobGfnbH8mqklJRDZ4PpYjQ3RfZjM4dTg2URJcRzynBz7SAdwilW6-ffmb5eH2M5jsQ1Tneg2HXs-IH',50,'Amman Governorate',31.927435,35.947234,'enabled',NULL,NULL),(258,'vendor','$2y$10$IZ2y0xOa8cEfobIAEnW07.xorOsYZiKnR2GzK31/2l6HZ1cuJSMK2','786994929','alkheebabdullah@gmail.com','عبدالله','الخطيب','2024-03-13 12:14:32',NULL,'inactive',NULL,NULL,'شارع الرئيسي الدولي الشارع الرئيسي صافوط صويلح, Jordan','d9_NFm-OTZOrx-1tkv6rX3:APA91bFFxFFuxcm5x56RtwIw1RhytYT9-t2nQhUjpBq7ELTHatws5NOW_tTdlCpG2vqDb7cH2Dp0isBSPtBMbqMVGerudwyyKJStyFo1-yAycPX3h9vfnvORG9fSYHmlW-aC6nNPg9iV',5,'Balqa Governorate',32.042004,35.836834,'disabled','1.0.15','android'),(259,'vendor','$2y$10$oZ75MCYAb9XzxA5ZFIkPc.k6yJJPUoaul29SGn27B1v5122z5rz8W','781736994','mmdoaa2005@gmail.com','دعاء','الصنابره','2024-03-13 16:22:16',NULL,'inactive',NULL,NULL,'2RGW+M25, Amman, Jordan','fAsB3GmRS5GiMjfPHaibNm:APA91bHTeX3KdtMhgKs0TizhPCft2USThym3T97BRY_rNNjTXqzdS1wEkw1bDq0n_9OuBvcgxYJYV7f4FOkMGP1EwohzRdzHjyurQ5N7dIfO2TQ0d6R-UR68jInS4Sp5i24T_Q3mj9aQ',0,'Amman Governorate',32.026400,35.844149,'disabled',NULL,NULL),(260,'customer','$2y$10$xaz6r3f.2lt2imsXJEuTWuSVv/oXtJnF9agUudySNY4m1GSfyHFgG','795252579','Raad.naffaa@gmail.com','raad','naffaa','2024-03-13 16:38:45',NULL,'inactive',NULL,NULL,'2Q8W+P2, Fuheis, Jordan','cc9SN97kS_e4vWZyDSh0iG:APA91bFehBcNAsrcnPPSBNWmS2d8Bquc73nHuPKnidZFRiWvS9evkDDDrgamsnityOMRkJB6sPIGhegToTHqM0GCC8z-sFrT4E-7H2QwARITf6FfRByh9Ll7qOICynmwfMfdrkEZicus',NULL,'Balqa Governorate',32.016672,35.794398,'enabled',NULL,NULL),(261,'customer','$2y$10$Jk/r.lKVe86f1RrZFKz25enrk1W9yHxWqX8qHXOSj3wL1iGspb5Am','796688999','Osama-abuhamda@hotmail.com','osama','Abo hamdeh','2024-03-13 18:46:21',NULL,'inactive',NULL,NULL,'2W3P+9JC, Tarek St., Amman, Jordan','ctFbz7R7ZEc4mTrKhBQbUN:APA91bGXdMm7mZLtzJO0x-XQIF7BNQeR6p4TClTwCWwmQ9KFeVOiCpoYeBbHqTUVXk2Hmmo0G6zoE1yKt8SheLprg-k0CTX3uxRXNTUO5kao7BM9zmNI0CTz85PnbhG2u3AaI_dtihj1',NULL,'Amman Governorate',32.003377,35.936495,'enabled','1.0.13','ios'),(262,'vendor','$2y$10$wWuIoxQPIaqPqcUOxRu4q.EJ3stOH8GrJOqEBCdXfm81cQK1XuhN6','780847880','aliaboadam49@gmail.com','علي','الحاج','2024-03-14 07:57:24',NULL,'inactive',NULL,NULL,'Al-Imam Al-Bukhari St. 4, Amman, Jordan','fXB0DBUjSxCO8hDxlt2g8L:APA91bEn_zfn7br13rDFGfWuCT8-qG5cPOZEeOb--U5EsePN2rIaZJh5sZKo98SktAZehJiBv6WYMlLvtfIEe2doTyR9MEMhRnoFNZj6QSDceIlrkpZv-5i4FOmEi9rVxwaM9U9U0ecI',0,'Amman Governorate',31.940824,35.947172,'enabled',NULL,NULL),(263,'vendor','$2y$10$7Z8tGrCZ1uK.dQggoSvNVu.8ZzZGOLwvYPvM/ycWONxlay7S4HOTu','790676433','omar.88.ahmad@gmail.com','عمر','علي','2024-03-14 08:39:21',NULL,'inactive',NULL,NULL,'X2R5+H3 Amman, Jordan','e6Dxm5EAQryo-wlRc7bnoV:APA91bHx33P0vlA3oAOifKySxwMIBtRN20U1J6bzxLETq51GuvFupK-_vGN_0BLv9pS0S_c6G6hZ9BHgRJ4BOixIhXdExa4BFaVv2BSq8ySCEitSe6GGr1kzEbGZ3ldamlMRTE58CSTP',5,'Amman Governorate',31.991439,36.007729,'enabled','1.0.15','android'),(264,'vendor','$2y$10$fhKwBu3ZSlAN1XH9NQd2gugx/vY8GSxbC4pWCys/3vBaO69MTSFJm','797037162','raed.alakdt@gmail.com','رعد','رائد','2024-03-14 08:41:37',NULL,'inactive',NULL,NULL,'QXVG+WR Amman, Jordan','egWOuCnFRNiuQxVnMEKLGY:APA91bFjDKckqOOhuCgkpk_jSut-CmcQGuaxL7e1S6uMPNaw1j4WmlKgISa3cTJifJL0l6uaGLth9bfQC95cOkla92rQtOQObK3POkxqVjPmdaf0HiDhPW8x-qdXhs1gZa_GTY7a7ZKQ',5,'Amman Governorate',31.794825,35.977073,'enabled',NULL,NULL),(265,'vendor','$2y$10$pmGU3EbP6a042LYKfUN78uFIGzUmjAsl3eahL5DOmuS24LTpovUVO','781503088','alhymwnyalhymwny@gmail.com','زياد','الهيموني','2024-03-14 08:54:35',NULL,'inactive',59816,'2024-07-17 12:45:59','VXRF+X6M, Amman, Jordan','dXkbVh-dQiSXS1FGLNNruC:APA91bFhRPstEYIVwl6ZrDcQSLW2s-oD5bV9mJ1KYLayUVdijeqdyYB57HlB8s_LJe5qCO_Hr1lcFxczEVhK4oNQB1n2O4bCP94zyVkvfvOkvGGX-0Oqp8lhnc_MMGiM9Dn5ovyy96O_',50,'Amman Governorate',31.892527,35.973082,'enabled',NULL,NULL),(266,'vendor','$2y$10$TwOg.Ctg2nWXb3bu68anM.2bUJ07XCTbFsTWa9R/PJLZaTe/h4iVm','799695920','shhdbdbdvdvdv@gmail.com','محمد','صبري','2024-03-14 08:57:25',NULL,'inactive',NULL,NULL,'XX6M+V56, Amman, Jordan','eU8OZQPfS8iW2RvAlsDiTZ:APA91bGY4Uu7CH_xil9jDFAzS22essUW_Sd1GqpbZsThthXIpkfpyf7JWYqkoFzhRemqGvvPuNJUk97wuoGlJz4cK7kcw-xA-AQkzLQb-cQgbBoXMuB_Mmftrco6uVe935M-31jx6IHw',5,'Amman Governorate',31.962297,35.982764,'enabled',NULL,NULL),(267,'vendor','$2y$10$TV2CuRy0GL3ribIOAU3OPO6SetyIYXrtF3JiXdOXTypzh7AR1UCYy','790481971','huseinyousef1234@yahoo.com','حسين','يوسف','2024-03-14 09:27:27',NULL,'inactive',NULL,NULL,'Prince Faisal street Amman, Amman, Jordan','cBI1qjsZQr-7WRhCxoYH5U:APA91bFR0DRy5D1yqsgQqzNUymg6Y19kd4V1E4p1_fCCSoa9RqMBnkZXJo02JplEs8NaRJldQPnIPKtjQJ8T_dmrT69Q6sBwl0jtmz2KU7qIZ7uifnZwl_5vGqQ23x3_17c44idMVlYR',5,'Amman Governorate',31.990312,35.976680,'enabled','1.0.15','android'),(268,'vendor','$2y$10$vnu.Y7wN0vVDBVTfCw24guzXqWHPIRq7FZRcOIpVgyFjrfH7aJ4hu','798720093','osama.mesleh56@gmail.com','اسامة','مصلح','2024-03-14 09:32:15',NULL,'active',NULL,NULL,'VV56+F54, Amman, Jordan','dvZXoZTuSeGfZE_Z3eaozm:APA91bGnMK9elGT2GQda8DApKtsoo2V94qBeWU4d0r-jLY1z5ZzMk5J81fl7HjasMCB0Eq3V0LVF5sA5XfAeYtDVb7gY_GavjoEG5ipvW23WRorHFESYYxl6LEKZB3Ab7TLSqO-MTLYj',5,'Amman Governorate',31.858745,35.860855,'enabled','1.0.15','android'),(269,'vendor','$2y$10$3zHL5cKCGLvoWQLJwKixueT4JLdtrpx3eQ54njSPxKwEW9s4Gs3jC','796033158','wesamallala70@gmail.com','وسام','بدر','2024-03-14 10:32:01',NULL,'inactive',NULL,NULL,'XXHG+997, Mahmoud Al-Ghezawi St., Amman, Jordan','cgxidVCtQyibX-vq29dLcZ:APA91bH6l1_VNZhcLOAt-YQPYooUy7dr-E6h_o0AtMdTrLiDd-RVXpOKqgSlU8qXYxXketIo4cx2Sv9sCFC92Ck_-a25wDwObfrQ7d103Yntf_6XKKbwjxrxy1pO69_6Qh1XCnULNoyz',5,'Amman Governorate',31.978663,35.976207,'enabled',NULL,NULL),(270,'vendor','$2y$10$7JeS8OgPgTkzewouHzjCy.MFcmTYwoXk74p0o6JSZ1ven.QL1LN6y','790184733','shgd6269@gmail.com','منذر','محمود','2024-03-14 10:40:37',NULL,'inactive',NULL,NULL,'Prince Faisal street Amman, Amman, Jordan','esmPEFTZTp6cJAThBPe6wB:APA91bEPiz7TUdZJejK0YIQeV1t7IP7KJ4LsD9NoI5_Whl-4wfBnOljBcFVaXqAGoptHj1B5JWYyyoECWORoijiZqRrYbuKclb7N0WamBNv9EIB49g7VnZEkrlM94xP_55MAYIivVNwT',5,'Amman Governorate',31.990289,35.976671,'enabled',NULL,NULL),(271,'vendor','$2y$10$OfO84RPkH6XzxnBCnKptNOps.16S/hrUngBrg3ZrYzDDjk.Yu18gK','785839524','alobadeieyousseif@gmal.com','يوسف','الخطيب','2024-03-14 10:45:12',NULL,'inactive',NULL,NULL,'2X27+V77, Amman, Jordan','fVGsJdxmTWK_93jnSEoQD9:APA91bGYxXAXREvMct-YaCQAiit8b3XSBehVdl_ZMYlpK9Rtmkf93ss4g5mcEOFkgo-3BocD2f_oijxdxFoYQLeNjl0otA1M_04wjQA-cUjHNa47RRX8X2US8qEz9i6jhFZDBsAGAObm',5,'Amman Governorate',32.002209,35.963193,'enabled',NULL,NULL),(272,'customer','$2y$10$NUn7nkMRbTSGGsXyXLcdFeewaTWL0IDNqMHhS/JJWLajcXCLaSFPq','798400581','mhmdlyna005@gmail.com','  محمد','عليان','2024-03-14 16:39:47',NULL,'inactive',73016,'2024-07-05 18:03:28','3R6M+937, Ein Al-Basha, Jordan','e1gnkTs9Ra-BAhGZLbVCvp:APA91bHiiktquLzpTKA4ksSCNEuf3cuosS5Ot73vAYALxvmwvCJCcgGYTbhFrniTAHQOnRbnTSdDk6KdJwBmAKHo2r8Th1pflpCcKA2GACsN1dWzwFy2jHuJg1jKy-a4NZpyk0xXt7QS',NULL,'Balqa Governorate',32.061022,35.831740,'enabled','1.0.10',NULL),(273,'customer','$2y$10$Hl3EihvH5/DcVwj/.3NjA.KLL.Fx0ZxqFnQuILy.1b1mPzldvdXfu','772341139','jafal8888@gmail.com','محمد ','ابو تايه ','2024-03-15 11:01:27',NULL,'inactive',78041,'2024-06-03 17:44:51','Bayaat Ar-Radwan St. 88, Amman, Jordan','dMgpSxURQ3iyAVq5VJzCvj:APA91bFSQhJT8n7ykS7JAjaxlNQmscNNBDaE8Ucf9-BQkQRVuVFu97CViH8vOAV-X4I-FxOeOkt78pLmR-K2ropMqB0Jd2Zg_e6osuH7PqPIG4EGNvvezATa-3CYgNd1Ek33uZQmJGp5',NULL,'Amman Governorate',32.000003,35.969872,'enabled','1.0.13','android'),(274,'customer','$2y$10$ZAE340vW3w9Ub27867fjvegMfwiUmZJHOjyBrnbQEI.q6xjdQE50y','782720639','sulimanmohammad1996@gmail.com','سليمان ','عرجاني','2024-03-15 19:45:27',NULL,'inactive',NULL,NULL,'GVMV+CQ4, GVMW+47J،, حوارة،،, Jordan','cU1c6VQ9QKeZ8n0I5m7DPu:APA91bFkNIDgYZ5V8DybKY-ZhsEuE2XrgQv9qouSAodnWbvsDrBhOGHSplmHZvx-lsoQZ_fFspF_AsIgHrXvQwUpEcJjKJ2JLGum0UK9WXBbupf4HVq57OlMpSbd7HqBv7diov2lzhVJ',NULL,'Irbid Governorate',32.533507,35.894308,'enabled',NULL,NULL),(275,'vendor','$2y$10$5n98a6fQQb4SUHAcHvnbDeKxDplm4lLO5NwKW/SJsPvo/pxifUpNK','776224040','abdallahahmad889000@gmail.com','عبدالله ','حياري','2024-03-16 08:46:25',NULL,'inactive',NULL,NULL,'Salah Al-Shemat St. 24, Amman, Jordan','e6DtrTZFQJSH3-YJn52oNr:APA91bEOq6mWOSxy4A_KiUFralZvDczzTw63KBHI0xMVyWoimyxxU7i0lAKkSoQtaKetAZqhFWnF-Ip0oegKZdO-WO2F5vVtXGYzjsivrahQN12OST3ClyKxqTO6FfxfgC_jLQf9tbn8',5,'Amman Governorate',31.958441,35.869590,'enabled',NULL,NULL),(276,'vendor','$2y$10$vVjJ0.RMjh4kAVN5tw33e.KVOew/z61j4vh7F7IsharRVgeZmlFtK','799403943','jdgd1880@gmail.com','انور','صالح','2024-03-16 08:49:29',NULL,'inactive',NULL,NULL,'XV4C+X6C, Prs. Alia St., Amman, Jordan','ePVmS4KlQR2rtfIj55jVIx:APA91bECFlqnp8nhmFKhzYw35uFE1T0OwxuKkVJW7-G5q30PLa8s7xhKHqBEWIShBu8k-xze_irWF5BxgM9E60OePHCBFI2Qf8jg5gei5yXB5lZFX4YXMZr3U3nuHrwEV9H2OR4YXu6R',3,'Amman Governorate',31.957734,35.870523,'enabled',NULL,NULL),(277,'vendor','$2y$10$arTRLbnCY0OM4w0LnayQ4.BNcgxUpfqZyFjR9gVsbmZbuvQEoq05C','798597576','tameerial4@gmail.com','ابراهيم','مصطفى','2024-03-16 08:55:25',NULL,'inactive',NULL,NULL,'Thabet Ben Jith St. 2, Amman, Jordan','dM0-3qxiScWJ7KtlHz5d3G:APA91bGaBK1uXYqMIbe76e32S-tn9MPkOkr5sv7r_ZT7PmUSR1fP2f_f9fqS34dCtcJsiuQefBtWq2t0pO6-fuOWXZe2-tMQGqhj0A2bkk9zZXi8_UIkczaYaIFb0e4yAyxW0yjeMxrb',5,'Amman Governorate',31.896928,35.905316,'enabled',NULL,NULL),(278,'vendor','$2y$10$S3sedSgokn0MQhJWgeyp0egKw0gn9ejcTHmUKpceE3lgNa4jLjTc6','795770292','dugxhg07@gmail.com','خالد','سلامة','2024-03-16 09:09:40',NULL,'inactive',NULL,NULL,'Q. Zein Al-Sharaf St. 138-144, Amman, Jordan','c-elVFFgSPuncHKQLC_aNd:APA91bE07tCHWSQmEhycoK3yxboYwJYEVCujHf3HwEuOxTi_lvkybdXx_kjnMG2cRJ30KQOd-szCt2JjTwbe49SctsPjgBRx2kKMtxyZ7OXFUu1vpVMFiRDFDVe_hQXqsepZycW0oWzh',5,'Amman Governorate',31.945448,35.857847,'enabled',NULL,NULL),(279,'vendor','$2y$10$Z.T61aKk/WV3SQ4ihUOJ.uK9Hy/lj73E5wwuGBmek.FFhyF5bpKSm','790085014','souhaibatar78@gmail.com','صهيب','العطار','2024-03-16 09:24:55',NULL,'inactive',NULL,NULL,'Muhammad Ad-Daajah St. 71, Amman, Jordan','cZcsCvC1S_GHIHWocnnvDs:APA91bECwPz7XQHikWufsDwmoOVgbuXhn8qs2kPxpbTARo0xm8GaftMLFeH1ViYjH0QhWHcnTh9HEc_GoiETIg65-1Ibb_G2zUN1wbxZi7Z44Rp7fyrZUbrXXHsPvXEbOekQgtAoJtfE',5,'Amman Governorate',31.970070,35.839585,'enabled',NULL,NULL),(280,'vendor','$2y$10$CBHE/qfI7s5ovvtER6f.eu1LSES1PJDX9j7ZfhlEGRFs7hQyxEzai','776168635','hvvcbbhv@gmail.com','معن','العبادي','2024-03-16 09:27:46',NULL,'inactive',NULL,NULL,'WRWQ+7Q, Amman, Jordan','cDAcg2QXT9GhA0zxlq22YA:APA91bEuqw0WqFhf2JlLFejTtbgeAAa80nSZdnJkap70hT-DCNmD3tVQvxuHbZY7WplVFIjpKPKyBQc1Ee-1dgpAWsRNn3bJuJMSEnQ6IwmYvYMCx0oMHOoDKVNyA3-_K502LTvsVAGo',5,'Amman Governorate',31.945816,35.839399,'enabled','1.0.15','android'),(281,'vendor','$2y$10$PnDdvb5ba1HO60mLlqge9e6Ik4E1P6KE.Q5VACpSE..ewXYJRAxbW','798691161','mohammadalabadii40@gmail.com','علي','المغاربة','2024-03-16 09:34:26',NULL,'active',57476,'2024-06-20 20:41:53','WRWQ+FF3, As-Senaah St., Amman, Jordan','cV2VRNDpStqf2hC8E7MWfk:APA91bGnAbfOm8yWF88tIKdL1zc8WqudPXCb-Owbx20nHFB_Ayg3gJBqNwz-727_uz5Hht4IBZIxnDUOkyBugSn5e7y6LytdF_qbDnpncMKWq43Z5RgnJxrPc4wzwIanyYLKsp6_ITKU',3,'Amman Governorate',31.946071,35.838983,'enabled',NULL,NULL),(282,'vendor','$2y$10$b58vpPdvcxlEFBNclj.Wg.n4xXxONR5BV.2y0H1sJvKijDBW3quKq','795743501','omohsen094@gmail.com','عمر','الديسي','2024-03-16 09:39:19',NULL,'inactive',NULL,NULL,'البيادر - شارع الصناعة الرئيسي مباشرة بعد الاشارة الثانية من دوار النهضة, عمّان، Jordan','eB2h2_QBTHWFZmK3tqtqGX:APA91bGzICXZRZCt9bXUn3kIo4m1kZF2I62cEwoNSNxqYzwUbyKdnofXJmqhjzqv4qCXOVQ6eZHUuLbbUfm2jXm7FP4590BqkioI-aPyE_cWLUDFlQd8P1_ad53P3D47MOAPvpjwdPi2',5,'محافظة العاصمة',31.945985,35.839455,'enabled',NULL,NULL),(283,'vendor','$2y$10$wsYdY3ZA2DwIHCZVSPENBe01rgKSKEYgd0aVBszLyhVqUgwgxw9Sa','772506413','jvkfkgbk@gmail.com','صهيب ','السليحات ','2024-03-16 09:41:03',NULL,'inactive',NULL,NULL,'WRWQ+HX3, Amman, Jordan','dMJe6M9jR-OTPEhpIIrXAU:APA91bGqu_okG6FI9lgcmJq8d8-LzChQWNlJbdHYE_2bdQpF7-YFYFDZxU1qG-Zud9ui8dPT21cleKETHErimO01ZW-v8bsck3-IPs3kWRgx8HenTAO1wSFI5kVo9Qrfbg1pJiDrXPR4',5,'Amman Governorate',31.946297,35.839774,'enabled',NULL,NULL),(284,'vendor','$2y$10$9.aCggazLcrMKdvqgL..RODKMmR4PsJlirE/u8ePqBGTnG135cIZW','791822043','amhdhyfhalbady07@gmail.com','خالد','المغاربة','2024-03-16 09:41:35',NULL,'inactive',NULL,NULL,'الصناعة،، WRVQ+XM3, Amman, Jordan','eKSktawKS0KkXaH9O-ZLso:APA91bEQ5XyoP60yYKc4Zl5UWE8ZrBeAO5spCPqhBy4RQyqBD7o_s9ER7hcxxjCQmJnQM3kIQwGyrBCcAc7i14dPDevZ0YQEYBdFH83EJaSg1MCR-DA9lXIuS6EqHOvbMSsc2Bpl6zRL',5,'Amman Governorate',31.944871,35.838949,'enabled',NULL,NULL),(285,'vendor','$2y$10$d7JwSwVWnwgUuzlu5TRia.nZ9g5AxXde3JzDogUMG4TgdsxYk2s76','799672490','ibraheeemabade39@gmail.com','عماد','موسى','2024-03-16 09:50:55',NULL,'active',NULL,NULL,'XQ3W+JH6, Amman, Jordan','fmdSqXCySye3H57s1yaoZs:APA91bEOly6yHt5OZgAryCD5uU8tpZtYWy7XsAglFlkHucQM9I4Xy_Am5NQXchrbW2wHbQrrdQWbmn6C-ZabblG4v43yrTI4Z7YPvcK-rfVWQQLZrls03SVsYTTrb9yaEwDILVQs5oFV',5,'Amman Governorate',31.954190,35.796364,'enabled',NULL,NULL),(286,'vendor','$2y$10$RSF0cAaQ8Qk2HBpUz1nUce2VkbFgLaIIj3/ICPcvNDVL2gsC5w1vy','776349010','dhehehhdheh44@gmail.com','عناد','العبادي','2024-03-16 09:58:15',NULL,'active',NULL,NULL,'As-Senaah St. 11814, Amman, Jordan','fm6nvpU8T3KEb3BpBzyJxW:APA91bFvLDHQUgiiMSxCB0hGv29pVkB2wwsVx-KEAIgoxXn4FOlcYRbC497c-bxD_hxmIMmuXlOzxmUP4zscDDrMqhKelAQkVaVErNsuPawh6kCUQUP3ZeSmSDf_4NR1wJZ5A-WkFJE5',5,'Amman Governorate',31.938221,35.819979,'enabled',NULL,NULL),(287,'vendor','$2y$10$O9yZ1XzAQ0c/OlnFUVSFYeTm.pPHqE3cnrOQPbQgCbSPJlvHypwcS','781766662','mahran600600@gmail.com','مهران','الاغا','2024-03-16 10:09:41',NULL,'inactive',NULL,NULL,'WWQQ+MQH, Amman, Jordan','f1DQ4XG3SIysdv2jhtmpzt:APA91bGqdVyAd1b_liMB4RO4ISma2JK2fc9N72US1iJD76d3WSA75-gNEG1nbDTECyD5YemxBJt-rh2Wx-Co9SM8jU_kcJUFBKkhPu7_QIsN2T2rUPZyuVNHQ4UYsh_f26B7ZjSxx3F1',3,'Amman Governorate',31.939313,35.939517,'enabled',NULL,NULL),(288,'vendor','$2y$10$VUCse/1aMboyjQ/1QPDl5uUDtLyCKZYDZvritQ7gfpqiCv7sHgsRq','778168467','aaaeee0778168467@gmail.com','محمد','علي','2024-03-16 10:27:43',NULL,'active',35072,'2024-07-11 23:58:42','XV53+9JG, Amman, Jordan','cKnsp94NTcyPeFM8EeCQHV:APA91bGUSBc8_Des7dfgVgyZVNdDucNHoIGJFsWuJgmp72GwCXjBP5D-fJ_vUn-B01HxDjfC6B2qu98ws6KIE4sOleHctFmihbBTDJgrnX5dM8qk546ZpxRqV1uwBf2khtbxz_sG-C60',5,'Amman Governorate',31.958553,35.854026,'enabled','1.0.15','android'),(289,'vendor','$2y$10$luMOY984eDaOMOA9YRiVp.pS8K9SQPbQlZgDS3nEhaVVYa204cm3y','799429743','jhfriifcfh@gmail.com','سعد','الزيود','2024-03-16 10:41:34',NULL,'inactive',63911,'2024-04-09 15:47:55','XQ7Q+7W9, Amman, Jordan','cNoSBNh1T4WUrn1OOqysfd:APA91bE5mo8cFlGMbhGNLHQiKo0BTFQV3d8EJ5yNSiH6CvJop_00SuPWl62VZ_jtJQl29PkU741M1CEZr57Jgbytjws59fiW0Idr8wX8pCTNDnDRFcB_lDFrB4VC0zwwB8mDxvTXCA-i',5,'Amman Governorate',31.962883,35.789640,'enabled',NULL,NULL),(290,'vendor','$2y$10$oVFSQxwm.DzouoKM7ZAix.BZ1rokUIyTCj912J5pyY0B8wIlEx.ia','776705662','almgharbtysy4@gmail.com','سليمان ','المغاربة','2024-03-16 10:54:26',NULL,'active',NULL,NULL,'WRPH+X64, Amman, Jordan','dqDm7py9S5OYS7B_KcIbHh:APA91bFH9-GEaV6OPDibuB9NYr1TyP-wAqOBaKAD8Jn_xVQZVGnithbkZz_0fc8CbEBAFIe9vvdzqJ3Qh692x2yN8G79xv9rNTT35QhCCeA7Hisneu4N84mRjmkU0ZdoUh8S8IpJ0UCp',10,'Amman Governorate',31.937909,35.827606,'enabled','1.0.15','android'),(291,'vendor','$2y$10$hJqNs4iTK5KI16LpRYTFyeZhys5qyWH5FTwhGbSQ6jkRxaQiCKque','775661318','nsemsaeed@gmail.com','سعيد','حسين','2024-03-16 11:10:41',NULL,'inactive',18004,'2024-07-17 12:26:36','Iraq Al-Amir St. 1, Amman, Jordan','dldi3aNQQe-Hu2GxahvR-7:APA91bFpLH4MMK466x7x7SiJJHiWzqp_0E9k3aLf7jz9qAjkx3e2c9JbbirijLvwMnDtn0QtmK_B7VWEBiYwyomblP849vXQ3YPchararyoFJhFBjpfYgkRwvvNTcrC0V-NmqICKC2-r',5,'Amman Governorate',31.952744,35.820096,'enabled',NULL,NULL),(292,'vendor','$2y$10$oksutb9Tm6z0cINB4/ZEPO69bADqxZqO7KRJRs3oQl.tpSbLL1KJi','795073163','lftawesaif@gmail.com','عثمان','اللفتاوي','2024-03-16 11:19:27',NULL,'inactive',68769,'2024-07-17 12:11:47','Ishak Hujeirat St. 28, Amman 11814, Jordan','dz_5p-S8Ro-6ve2t9ONx3J:APA91bE6GlX3LrR36LRLiVbftYgN41tvMXJWvncGRiTGGHXTqFLfwSv-DyBfE_nw7ZOlvEK58Wl3cNDSWm-IQGPTw7W0-T0Zu-A2oPZ2cLmiOuAt2Ekh0c23lKP6tXBzAXx82uObfhpV',5,'Amman Governorate',31.953544,35.834048,'enabled','1.0.15','android'),(293,'vendor','$2y$10$Vz/42uvQuZDxY1MRx1JQH.doX7NDh2lgtkoxhkuOMjeen/euMOVFi','798678172','albhlwza@gmail.com','ابراهيم ','البحلوز ','2024-03-16 11:37:00',NULL,'inactive',NULL,NULL,'Al Wehdat Medical Complex, ش. الأمير راشد 224، عمّان، Jordan','fv4uRyJ_Sd-BO6_Mt9mMJX:APA91bGAC5eDWKHTQzyu1EXXsL5bbiZph3vm5e0yDnhCh7c1JNJ2CjUcrnDxLRCYLsu7CpUqoum2l07K1gskYmSB0m8EBVnCotl7DKpCjrV2kAQc4GUm-EFl9ngq689KueIxJwefxxtc',5,'محافظة العاصمة',31.971467,35.949666,'enabled',NULL,NULL),(294,'vendor','$2y$10$oaeOdlqWnXzol5visYHPLeD..92s0ienKYNyuvCs9hTg.7Uz3qsU2','795622552','ahmadalattar905@gmail.com','احمد','العطار','2024-03-16 11:38:23',NULL,'active',NULL,NULL,'الاندلس،، VWP8+8HX, Amman, Jordan','chrTi_VgQlaYR7kOmQHo1g:APA91bFNIRZbz3CzOFbJMzQJfSXPXzJvOKdGGXxgV4-jA_hN0O_2SZ_WLz4kud-l8DGzkVvGCDK9mz6SSOB7KU9YxLN-HTw-083h1S5_DatZar8IacN0lRHBCfQyO6NoIZcnsBGIlKHs',5,'Amman Governorate',31.886360,35.916887,'enabled',NULL,NULL),(295,'customer','$2y$10$83Q1a5C.zl5pJJiT8W8mreHBFjxWGke.4CmA9Qcp5/l14.YqtK4d6','795212341','aboud_sisan@yahoo.com','abed elkareem','al sisan','2024-03-16 12:10:38',NULL,'inactive',NULL,NULL,'VVWM+PF2, Adnan Al-Junaydi St., Amman, Jordan','fT_FrudiQ36Dd16dvt07GX:APA91bEPP8Kr5yhjQAp8qWvE5S5bsEDPXH-QgEB-b_O6PQnMQXVWcsCA9MRdReG4WJxgqZqKK3i7FKB2ILZuDGZOZuhINXY179hb_j-vyCrJFNmUfMehJopzBJktRz72gkBHFabgwP6c',NULL,'Amman Governorate',31.896540,35.883581,'enabled','1.0.10',NULL),(296,'vendor','$2y$10$SsHVbW0QL5qv7OtUrQq46eOxvoFrML8lUBqUmECgu5gqGATipMjsW','795253251','atfalhtamlh7@gmail.com','عاطف','قاسم','2024-03-17 07:20:20',NULL,'inactive',NULL,NULL,'WWGQ+CHM, Amman, Jordan','dP2VZ1HvRVqfLkzXkSUOcT:APA91bH6CyykywSAEj0LDQgDvIUdh1g3hFQhXvSInA1WmAr1WoJDsipr450d5n33Cav2FZWsCKqKxKG1QwzKZD2eZ_BXrQxM_d_lAOFnx1WjART6EfUTXAW0pMS59esdQg8rn5zkPEe9',5,'Amman Governorate',31.926249,35.938868,'enabled',NULL,NULL),(297,'vendor','$2y$10$fvHUtTRoAa.Bo2DsNDyGuu084J5qz3UyAuAp0yIE0pNdBfSKpmpBy','790055789','morad.hayyeh2014@gmail.com','مراد','ابوحيه','2024-03-17 07:33:34',NULL,'inactive',NULL,NULL,'Al-Mukhtar Ath Thaqafi St. 51, Amman, Jordan','dNEGPXlmSXKjzv9lMnLy_g:APA91bHj1eKZdCv5T9Ln_urbXfvq39eIBLPQOlRQL86CcWoPFsaTtFmHHa3ICAeiFAAvbFshNVKfm8IzrfCOb1rS4pm9mFivHuQ-NnfQhIr3p9CfEUAGvp7H2LxuI8w0Q2RLR40g33fK',5,'Amman Governorate',31.925309,35.938841,'enabled',NULL,NULL),(298,'vendor','$2y$10$Tag3pMN0Ibx8uXwJh9aqRucelP8BGyzO8b/Il0weCK2/xjUpYkSB2','796451523','thtylkh@gmail.com','باسل','جميل','2024-03-17 07:37:26',NULL,'inactive',NULL,NULL,'WWGQ+GR5, Al-Aayedin St., Amman, Jordan','c0ryVc97QEiKgLMoXPlmB6:APA91bGkMdVcHP2NxJTqWKPB932rqzqenn5psHTy1-l4tCxC5kDBYCCe6_II1FvH7yIer47NQN-fdcdXjpsCcFpyOoNp2PzEWmVpRCPHPKiXvA9OcD_RJSV4YuBAWf2nIskJzPgTkpsG',5,'Amman Governorate',31.926303,35.939523,'enabled',NULL,NULL),(299,'vendor','$2y$10$ZwaKVHWrXJLIWZZcb7EEGOEhCPCAG5KPs69aco8Y/nhYWFutH1vfS','798833971','Ahmad.88.awad90@gmail.com','احمد','عوض','2024-03-17 07:41:09',NULL,'inactive',NULL,NULL,'WWGQ+GM5, Al-Aayedin St., Amman, Jordan','eGTsnjDLTfyUjU4lMHvygm:APA91bFwxBFSkwZ8rjXHirR4ejbNeZiFbRzHgZj0TfQUpNyVfcBfiiGRU0u0V1QmkYyGYLdQ-AVk4Tb9j03Wqh06YBipUQVnynl9i-fet03DPIqfDDvBIdBtpSYUn7o891sYIXjICUGQ',5,'Amman Governorate',31.926258,35.939207,'enabled',NULL,NULL),(300,'vendor','$2y$10$qOsHAh8OlfCXpYhBzuZdDuAUPNiNk4uzL7Fe/vRnFRnTZYbC8lzcC','782593339','abusharkhahmad65@gmail.com','بهاء الدين','ابو شرخه','2024-03-17 07:49:47',NULL,'inactive',NULL,NULL,'XV48+Q56, Al-Qimma St., Amman, Jordan','dWT5hAJCRv6b7d28sKo_fI:APA91bHFzWKF4Fm4ulBfq2Bg6gadpZWEJ3vFRHk1JqU2YkOwZTwihr3ZDvSaF5K8aY5-jfzGA5dnEn5GnYFhWWPsw8CUij4rHDAahDxIUdgFFhxXBkwoLuSq5deEurv5dX_fFhDbli9l',5,'Amman Governorate',31.956807,35.865423,'enabled',NULL,NULL),(301,'vendor','$2y$10$jWEmZJ9GQRLxJrC1sfUWTuFSidjZEer44Yn5KM/gauGmYpuFVcgvy','795040877','lwshshms81@gmail.com','انس','طبازة','2024-03-17 07:57:53',NULL,'inactive',63709,'2024-03-18 19:50:07','WW5Q+25Q, Pr. Hasan St., Amman, Jordan','exocCa37SpauxsGepKSUEo:APA91bFPRP1eToDzXXNTAPAubH94JpJjeipfx5gk32hehhZxVw9hA8Sa-0TLxX3JFIyjbFvX0qTh8jXk1os9OLfuMtayDWx18VWOKp0sTwIsz4WdiJdXUqCOcJB5uAG5XudBOC6Biy7k',5,'Amman Governorate',31.907625,35.938040,'enabled',NULL,NULL),(302,'vendor','$2y$10$Fc/SiisuPo7trRsVFSSr0.m5RqgGDga/oUzA4uvd2Qhyaa0bdSVSC','787780831','ashrfnadi0788@hotmail.com','اشرف','ناجح','2024-03-17 07:59:03',NULL,'inactive',24510,'2024-03-18 09:32:25','WW9R+CXF, Amman, Jordan','eD7YoBnHSR29LDB8vc9_Z5:APA91bGNR0oU-PeSvzC8MOFgqV_J4HVOJA9MHoJG_lbKipyq4KT5qcwOEqwArPRo4AYbTdwMLenS0hWV1r5srGcXwOH2Fcrqb3IEY7svo-gpqaDzld2948Bg_27nF5AEmCMIL6BkOvsV',5,'Amman Governorate',31.918667,35.942160,'enabled',NULL,NULL),(303,'vendor','$2y$10$ngeatYZERvNI/j.QYT9i1eBoUqd4vFWepkh8epnmmbj4XrQqeqiZK','799489006','shahaherm136@gmail.com','شاعر','عيسى','2024-03-17 08:02:45',NULL,'inactive',NULL,NULL,'PRVP+4W Amman, Jordan','ebR5QyabQWKggMEIHSASuH:APA91bFQWK5S6M3JQBDg0EM42FmIwjqiOVNreiiSbDd3Xyl9nuDmoKamtKt3JJMWiW0j0SeETFTsMDISu97py0UY5hjUKzqir3nbsuLUzpXz4dvJzFhvto5enxjoGVbYC_DKSsC5vvTq',5,'Amman Governorate',31.742774,35.837369,'enabled','1.0.15','android'),(304,'vendor','$2y$10$f.DOc3iTJkQT0Zl8Cv2pNe6xBRQuayhfDY6hO6l0bW8jscnIcL72C','795043818','odayhamdan437@gmail.com','عدي','حمدان','2024-03-17 08:03:12',NULL,'inactive',NULL,NULL,'Khalaf Al Fayez Complex Ali Sedu Al Kurdi St 46 Abdoun Al Shamali Amman, عمّان، Jordan','epaxMQmOQAKJok7qkUEQ45:APA91bHs_Itr2rI31_g9Wp8WYh-uENF_HrfkBcAsMx3DSnIYH3018yTJlSTGYXuJ08X9sgpAy2_Sb8nPb2Eo9M32XoyFebc-ykieLeP3AwILkcz2n6OQdV18TC-GtALA5mNh3TP8KUdQ',5,'محافظة العاصمة',31.947355,35.874610,'enabled',NULL,NULL),(305,'vendor','$2y$10$Q/0hSff2cIIiy8J9DxJlQOsfdcf4F9eTfOxaBsFCZd8Bas3t7JBgW','795248614','amrtabazh@gmail.com','عامر','طبازة','2024-03-17 08:13:51',NULL,'inactive',NULL,NULL,'WWGR+98R, Amman, Jordan','cflyS-OIQPKZj6mriSG1Mk:APA91bEuKgeRO_588mQv5iIjl00ow9J1uRvAaSk9s4Hktz6fBmr5NhIk_KF88fOrc7U_y0u75Xe8iOGw78Hh9BR-swj4zqU8vdB3Lmhj_WLIa_15HjxzUTBFXWIO8SORdioufggtNLjq',5,'Amman Governorate',31.926168,35.940505,'enabled',NULL,NULL),(306,'vendor','$2y$10$wTWjKCR5fHF1fBxj72Zu0.XJ8p1SzzgXw4M67IXpOi0qI/YBBDKIy','795775846','azmishaher.alkouz@gmail.com','عزني','شاهر','2024-03-17 08:28:16',NULL,'inactive',NULL,NULL,'WWFR+X34, Sumayah St., Amman, Jordan','fYpj84KhQzWgmFD9ANT8By:APA91bHzQYpTSBCU5Wd1aHg0z9OWxEvlgagBT_0FKMl109PIU0iMf8SfdBS1aAcz5h8EDP9gGDmc4VmjC3yllFFBD3Rvm9iYCcf-lw0JzLDPdUBFHfWtCt2GKjzGzehkb3yOnZCdWxfN',5,'Amman Governorate',31.924878,35.940184,'enabled',NULL,NULL),(307,'vendor','$2y$10$v8pKZXL38YSZIhmNyd5jZOf09ctw.g7ZY.SbtB0Vp6BQnNhj5/dkK','796148248','Mustafahmh88@gmail.com','Mustafa','Hassoneh','2024-03-17 08:31:19',NULL,'inactive',13400,'2024-04-15 00:30:57','Al-Mukhtar Ath Thaqafi St. 51, Amman, Jordan','d2n1yoK2QuCF6dCcev8Bl8:APA91bFGAIqb6qmwCmVP4ZCCG1ys7OWd477mLMTLW7OpSL27CWZo_kI1eZt_AmrHzzJ5HnuV8jmEbhaBlkfb8ZHF9IqQ1wHjLi-Pt214VoKJ6o1afSqpo53TsFKgTvAJ-Y00fTFZuRYN',0,'Amman Governorate',31.925401,35.938802,'enabled',NULL,NULL),(308,'vendor','$2y$10$F2qiXrS.aeLiPGURNUXYYO6ALvekI/Ah3tSk00/fhmDTh3xc6GESy','797911262','ramzihasan62@gmail.com','رمزي','الهيموني','2024-03-17 08:58:07',NULL,'inactive',NULL,NULL,'Pr. Hasan St. 317, Amman, Jordan','f7yIiaO1Sym3j6YgogO7C2:APA91bFGDJN_bH9nGKLtXB_ccdbTO4Bw64bUIZd8C-uVvyjAEuCRztvcxnjh3tvMp_jVjFbyhwEY2JyaSjWer2mxGkBOSZvl1wU-mi5g1el5HqJnb3z_tYrV0vhPPfvC_0gJEoiPT-Ef',5,'Amman Governorate',31.921670,35.938388,'enabled',NULL,NULL),(309,'vendor','$2y$10$hi.dekTamV8XMEKmDfPmQOV0QcOstwoGG4yMHy8MxWuzKvs57DDpC','798006461','sakherbaker1122334455@gmail.com','صخر','العودات','2024-03-17 08:59:17',NULL,'inactive',NULL,NULL,'العوده،، Amman, Jordan','f66Bsd-3R5mPGyDVJXWGB4:APA91bFmYhKZBFq4rI-tPTGrO8LB_RdeqiI8U0WxeVja4EoliUTrXBAZZAOw7lcY4ZRxw6TWy20IwqBPsR9CQXv2X7wKQHjeN7_P2YeWka4Z0lXkjpsl-Bgv50a2-nZVcUFSAJTUrlOX',1,'Amman Governorate',31.926251,35.938963,'enabled','1.0.15','android'),(310,'vendor','$2y$10$ZlbEQeIoMla33o8LlMwiLODbVjtCvmN7L3KxYJU2p/eBfjU6nSHWC','796553332','mshwqhmhmd2@gmail.com','ابراهيم','ابو عطيه','2024-03-17 09:06:24',NULL,'inactive',NULL,NULL,'240، Pr. Hasan St. 252, Amman, Jordan','eL8YURdXRiSdyVm1-_ILWP:APA91bEDQr-HetJPXPTfPuSAojpZEBKdmp-Fpf-Kk12Jo_RI4Q_je8GdHV_NVn0nyejL3TOBIR5PO2l_KCq7aPHnbHAm94n8NoMPx9uILLbemmyQzX7Bser_4V1RoNXyt65j6_hm3tJK',3,'Amman Governorate',31.926034,35.938724,'enabled',NULL,NULL),(311,'vendor','$2y$10$hvn3.lBWrChpn1Lbg3NPiO7UwFirYsitcStZEKDCP4jqjMMEEIle2','796552170','alihsuoneh@gmail.com','علي','حسونة','2024-03-17 09:10:22',NULL,'active',NULL,NULL,'WX94+6XF, Amman, Jordan','e6bFNjeOQh2M6xa2jLkMHm:APA91bGN8a95xKK67IGFEv4Mx5CwHP30ox5GfnQRciBWDcnx47qehl7kzN1Ez2IrJ22506TSkvpfyfQTWLyTgNvMtypaVWKOUCtQ7DRiuAwb2Er_XlDxddHSgLNVcxsD1cR5OfNm_mxb',5,'Amman Governorate',31.918107,35.957353,'enabled','1.0.15','android'),(312,'vendor','$2y$10$aqqpn6oDVpVH93SjtVPL/OeJB6poUHw3PyEoUe5DJpV7Z1M/.CaOW','798943592','aqelmaher5@gmail.com','ماهر','عقل','2024-03-17 09:11:11',NULL,'active',NULL,NULL,'WWPV+2RQ, Amman, Jordan','f7hRnm5ESZicv9DMyVogkz:APA91bEVR4AKIl2fJEtPixf8MeU48B9JD9OAyXYGiS5C4VHUCf7-zYfMs-2CY-ASd8Zu8MalejXnhmFQVAMnJ6x4tr9AXvOsigpsjC7nCEiBUFEzjg0qg3Dmm7UkAGqlVeMnpx2rlbYz',3,'Amman Governorate',31.935117,35.945807,'enabled','1.0.15','android'),(313,'vendor','$2y$10$qinYrCawzDVRD6JQQA0xbuFu543gAyC4SIXAX5x2m3mrMEx.zrPAC','797515282','aaaaiutr4321@gmail.com','منصور','ابو رجب','2024-03-17 09:12:45',NULL,'inactive',NULL,NULL,'WV3V+78V, Amman, Jordan','fM_TITx3Qna333_qM_nFuV:APA91bGH0UYDuJewyXxdZeVaEW-9dZMgMGEIUuS55KWfQSHGH2b_7C6XDOBtV7dWOL-dFRq638CYzAPPg0oPVGmxdnRn7XFb_cUDOGxhtMlBVuRuOTeomK3FwBKZX3OX66JO551_YKRu',5,'Amman Governorate',31.903155,35.893377,'enabled',NULL,NULL),(314,'vendor','$2y$10$xC4.S5XK63kU0yScz0tY8eMklynOzbtE8gD1i/NuRC6r1SOtGYjde','795173358','nedalaltamari9@gmail.com','نضال','عبيات','2024-03-17 09:16:08',NULL,'inactive',67763,'2024-08-21 21:16:59','240، Pr. Hasan St. 252, Amman, Jordan','cx5gaLBMSd2dinGTzcyY4S:APA91bF9J574F5klkHuzFID95uSGymnqfB7s2d4Vy2VJmdR1kZVGOxEJ7VAb7I8KaZMVf6cKUW1dBK64RLQ8x2xEx3aHm31XTet7ivHrNZTDm4II_Bw1zRwrATbOn9mlotk3qLGWLnD8',5,'Amman Governorate',31.926129,35.938768,'enabled','1.0.15','android'),(315,'vendor','$2y$10$RBmA5GxpDTMeyV6isKkIx.k5TVj5jHQ.4Ex7.36wueGzoG9VUVbIu','795778718','ja758261@gmail.com','جهاد','محفوظ','2024-03-17 09:17:15',NULL,'inactive',NULL,NULL,'Al-Khemar St. 11, Amman, Jordan','cJVH45VMQvu7FbyaiGLpZv:APA91bG7qnAm6mSyIGhxepzUFosIAuNZ3ylq5Etzb3dY4Pq4FRq6vdlRdjNZ-oh5RSPS70_9MU8mO4IhBjYAZc67J6rQ9m4Eiy3X-nF9X69jP340MBKYkJy07jmUpEsfPXwJEJTvyqCn',3,'Amman Governorate',31.904310,35.977914,'enabled','1.0.15','android'),(316,'vendor','$2y$10$vhF0dHJ3SA2uxH91INK9lexJF59/2fjh3Fpj5iD8Abr0Opm7wwAOG','797318487','hanyabwalynyn1@gmail.com','هاني','ابو العينين','2024-03-17 09:28:31',NULL,'active',NULL,NULL,'2X38+WCH, Amman, Jordan','f-F_ediCSc6N-Cn35sLTdz:APA91bHStWdDQYaAUzxBEHde8zGyMcIf54TkhRyCUClzP4ZQc51l4aRKtVWNomdbAENwc2tDP4uMvdj7x7oRsSJOOf6ktWRgnCAJaIpbHmHJB3GiNDM2JbsErBZHqWRaMoSboqKCE2AX',5,'Amman Governorate',32.004795,35.966028,'enabled',NULL,NULL),(317,'vendor','$2y$10$2loGYEDzdqZwdRfoKkH3EOSlR0aYTNX8egbK/xOa9UBapNfez6jKy','797163461','amqsyalsrfndy@gmail.com','مروان','نضال','2024-03-17 09:44:39',NULL,'inactive',NULL,NULL,'X229+V7 Amman, Jordan','feEhq8J_T2CMR16mWP5kti:APA91bHRy4GtGFREQFqFfxsCtD3R1OFD3zsIiX0Xar4XT6juMO2CmAvnsDmvqnW2EdHFFz7lQbmR-Jue-Iedn3nTUw4TFatNWhxlb-sYIZZie8MKoYc3GsfAkdbbC0uv0vUTFUpuGny8',5,'Amman Governorate',31.952135,36.018133,'enabled',NULL,NULL),(318,'vendor','$2y$10$HtECCO7fm0HdVNeSdKgTtOtxkmSmWIW8f8N4trg.8jqmJK87SedTe','785536393','barhmmohmmad407@gmail.com','محمد','ربيع','2024-03-17 09:48:49',NULL,'inactive',NULL,NULL,'العوده،، Amman, Jordan','cFXl1GZyR4GgEzTbdxMx6k:APA91bFv0I7gitb-b7sDeHuHSZrO9Xk0yCyBRZrAhPWVKcPkZMn77GTBi57_mtZFvm9TqZPkO6qzZe1R4hTDHJjxRP9-nnjOYeuCqEvwCR1rVzS4nTNEgTTlcYgdUlvbbErOamnRtwO1',5,'Amman Governorate',31.926233,35.938968,'enabled',NULL,NULL),(319,'vendor','$2y$10$pXxZt.fSUAyVqbgm3rUdMuKAiOy8YzsW5CdRBNi8Tp1esWE1CUDKK','785917064','apdaaa622727@gmail.com','عبدالله','محمد علي','2024-03-17 09:52:16',NULL,'active',NULL,NULL,'X3R2+WW5, Amman, Jordan','fpmohBm3RY-KV9Ym9rJ75s:APA91bEzFJXSCVpMI0pBQISa87K7-8BwzHmoIZDL9M3j_JOaS4HpOhiKmyFBk_I6Du4G4LpVF2yL4G7nrxQle9XafyP0W4rAd3g-ftAG980-MUL9iqjycgle3T-hwbd736MPIsYpHrWK',5,'Amman Governorate',31.991479,36.052863,'enabled','1.0.15','android'),(320,'vendor','$2y$10$si0HZ1DBNioF2cQJnlO8D.EaMy9STw.yGm1AEmloupxxFU4cUrQY.','795966149','qwwweeedddd55@gmail.com','قصي','قدومي','2024-03-17 09:54:15',NULL,'inactive',NULL,NULL,'WXXQ+83M, Yaaqoub Al-Khawaldeh St., Amman, Jordan','ebRBxYXzTXy7eU6qWO1m0L:APA91bHHLyU-7Gy2qLDsLpoUOPr3poF3qWm2M_q0FX59irW0mPu2eA-NO1TKJHJSB_YkZEchowuQMmAeT29mr1YrHOX5oCM6IVLFI6vYw0otBBxpysS-tGXeKip1bd9PvhzkQL7kHPe4',5,'Amman Governorate',31.948017,35.987881,'enabled',NULL,NULL),(321,'vendor','$2y$10$4ODr4vqTa5DaxRO.caslne9y3/7chgZI47QL7Om9O6ZglIyC6HyRy','797492058','khattabalkhattab8@gmail.com','خطاب','سعدو','2024-03-17 10:24:22',NULL,'inactive',NULL,NULL,'Al-Mukhtar Ath Thaqafi St. 142, Amman, Jordan','eiLcQ61vQeCsVs1i_Y-Cs5:APA91bEfVVNl6589JQ-QH1-Hf5CnCBg6v_mqqdc6oyKL5tsxGd8sFIN6slct99LjexTNLRxDq4lbb6fvTj9Vxn8Ex1gFVRjkCorRf2IzKg3SHrCO0GT1p_CL5I4cGxfeyG0mUV4fqAq5',5,'Amman Governorate',31.925590,35.939047,'enabled',NULL,NULL),(322,'vendor','$2y$10$xbmxYZVxqCyTDv9f2HqxTuOx4iMn2cO/1LKbLSAsythrj5ouHjRru','798015215','0798015215aa@gmail.com','احمد','حمدان','2024-03-17 10:37:17',NULL,'inactive',NULL,NULL,'VXQ9+4M9, Al-Oumaraa St., Amman, Jordan','cc8rUdZ6T6S06E0SpiBr3h:APA91bFI1-BErNG2UK42vgMvv10WJQk7sKtZz_hmNeYSPAK1E_9ZKgJ0DyHwC7BY4Wxm1k4UtmyrTpD9A6f8GwcYGv20xjzEedSOcvpKjoHmuWAMKJtfhdgnK4fq_JZT93wwc3AGTmpP',5,'Amman Governorate',31.887688,35.969294,'enabled',NULL,NULL),(323,'vendor','$2y$10$HFtqyGTNUiCmB3fmwEQ7f.Nb/0tmKZLK.vfUW93K0wI5HmTfpXK1W','798706896','sameerabuokal@gmail.com','سمير','يونس','2024-03-17 10:40:37',NULL,'inactive',NULL,NULL,'العوده،، Amman, Jordan','citMUk08QSqkXxZEXUbUoI:APA91bGUIVO3SEqmkzQs_nWB3LnOmL8pSR9lVQzIJNvnj-g-1UbbKdl4fpQYahIdjDm7-50VbuhcHb7Oe9pKy9yvd-QMF6Izo-LRs7C8JF_JkC0CsyQeUXgIiNKnkumQxE-lZ6AIAWFA',5,'Amman Governorate',31.926240,35.938982,'enabled',NULL,NULL),(324,'vendor','$2y$10$xnacg9DmDPu.WxZ0PFhvFOAGbCEaQtF9kkL9IbuTiRgVf/5DUGSjy','799258787','ahmadwreikat56@gmail.com','احمد','الوريكات','2024-03-17 10:45:16',NULL,'inactive',NULL,NULL,'Abu Nseir Commercial Complex Abu Nuseir St 181، Amman, Jordan','dVnM_93wQ8WLirDKHfzF8C:APA91bF6F8VCcpOsRdECMdJgKpErKy7f0hQHDIiHc0poqhG1TqPPgJ1HZT4VGK-g--fyqYHat79o7IYB2g_sayoyZw7QWQszZcLThN2meAqRDh6Vaw-Yjg0WA3F76CgMPkKQ8CJ-2ZA1',5,'Amman Governorate',32.052224,35.878202,'enabled',NULL,NULL),(325,'vendor','$2y$10$u5WnBs9/mZ977zJbEt6yWeziC56YR/MyuKLhxyGDI.ODcOVZfyDWK','798959340','ehudaib@miyahuna.com.jo','عماد','هديب','2024-03-17 10:51:55',NULL,'inactive',NULL,NULL,'3RFR+M5 Al Hanou, Jordan','faae9ZEzRPeUFca1JWn6Pg:APA91bFEzE-HW8KIIiD5xOSIMH7IwRtJzPZ4fLkBAUrh288AAX9qhBgPXDn8MrP7wkQ3fD9DrAi8yH6ShdvaNJKISujZAVpt3S0dhKE0rqZqTu8ZarhB8vPlsLqfDRcL1kaGi3Zu-AkW',5,'Balqa Governorate',32.074206,35.840482,'enabled',NULL,NULL),(326,'vendor','$2y$10$sy5/T53i78zR4oEyWYHN7uy5vLT7D.HANK9XeSGfHmpH1pJpXFla6','795264561','mhmwdmhmwdabdalhmyd501@gmail.com','محمود','عبدالحميد ','2024-03-17 10:59:30',NULL,'inactive',NULL,NULL,'Jawa St. 8, Amman, Jordan','eLk7O6wOSPqpih-kNgHoHK:APA91bFJt4ind0S5ni1n92RKo5xUaayA9KWfcjZ9ZRXESWRJdynzKFeZR9C0WTYRcadEUN789GpvUxq0xjpl3t29JTAIutb0Ic9dahvtAS3lwiOqFgB4kfHMdhjwSr1NP_AEzV3tpaFa',5,'Amman Governorate',31.853269,35.939441,'enabled','1.0.15','android'),(327,'vendor','$2y$10$vZxJgo7nRsbDGMR3AYByWuLGef4l8bT1ofD.mj.RBbQkCNhzyr3XW','790494922','mohammed89159@gmail.com','محمد','حمد','2024-03-17 11:04:55',NULL,'inactive',NULL,NULL,'WWGQ+CHM, Amman, Jordan','e5W05PniReuk_tFFh5cH0i:APA91bF0oVqulcknJsfzOut9jPPPjriqV-76nU8RFrXMr_cBilj0k7luvyaVyY4o469OqNKJYcCTNIPQwOkFeSWtK_e2bd9JSVkyrbzzn5OLcFVufutmNm5xbrm0wHTQZUFdkOZrdt-i',5,'Amman Governorate',31.929262,35.959053,'enabled',NULL,NULL),(328,'customer','$2y$10$Qw3W9KTbvVnjbCbsBgblg.Ct7WoYCD0qEJNRVEV6z6NoVtFxmQgXu','797980605','abanisalameh@miyahuna.com','amer ','bani salameh ','2024-03-17 18:42:07',NULL,'inactive',NULL,NULL,'الرواق،، XWGM+MHQ, Amman, Jordan','d5idWyPjTyevXVa4bvS-0Y:APA91bHW-klcGqOLfjRfOLcjNn4oVIYwHf5xE9riQz5UCo4NPN35FzDmczk61OGIxEAbPGSXrUTFBa3EeXN9klbMDf0k2QyM82QFC0l9qTJw4hC1FLvjuPEuQF92Mgz9lOjaenOt2IAl',NULL,'Amman Governorate',31.977116,35.933826,'enabled',NULL,NULL),(329,'customer','$2y$10$uTIEnjmMVZXqggaZzJuJMOp.aqh78qTt39VbkZnXeDIa0slAN8RQ6','797325444','jooryjameel@gmail.com','Reham','orjani','2024-03-17 18:55:55',NULL,'inactive',76802,'2024-07-18 17:28:26','XWJV+6X3, Adh Dhaher Al-Ayoubi St., Amman, Jordan','fJ-jMPq-RkGVIYAxS0MAgS:APA91bFM8W0njNy6H9_E74w7FcV8DXbmVQxKNzSgFGpA4HXwMrjiDvfogmmbB5CGgUnSvAkL5udQ80WMTXMU6Cout8aP9Zox1lYsNt6E4e-OZspslEU0-FYB_Z_zgqPl2kOOv_kTrcoE',NULL,'Amman Governorate',31.980721,35.944464,'enabled','1.0.13',NULL),(330,'vendor','$2y$10$B9c.6GdFkHV4Ws4mNWup5eXEWSON40sfc/0SyqA2hZEiEa99nrNu6','780990187','shalanfatimah@gmail.com','عماد','التعمري','2024-03-18 07:11:18',NULL,'inactive',NULL,NULL,'WWM7+8C7، عمّان، Jordan','f97Ira8RQo6eF6nQl8G2df:APA91bGW_IKftywWyezathbC7logUnkoke5HLF6kCxLw5iTdsqcTN9RM8LEWWuXf7eLC0BGwxkCDaEjwhNIrWSQ70gGDYYot790AiUCyE8bV9xA8RaQ9HyTN377rTbGtI2l4HSSU5ko7',5,'محافظة العاصمة',31.933287,35.913515,'enabled',NULL,NULL),(331,'vendor','$2y$10$ty/ujn49TzDjyK6CvECV8.2mO97ZnAxJ.ejk3ZG2oxoQEtoqLwrbm','799438911','mhmdaltmry076@gmail.com','محمد','التعمري','2024-03-18 07:12:12',NULL,'inactive',NULL,NULL,'Ad-Dustour St 98, Amman, Jordan','f7-9KVDYQcCcFXZjy_aVtR:APA91bG66d2DO2oCImpDF8YuCvpQlcpjvJanuUZZfKp3WkBsNu72fRNIJASc6q7cf0lPLYCieWRFQYSH81uOuKaJOT7J-0jY1owsYp3m4N-w1cwG-WyruS4vULG8scasx9wc9uV5PveJ',5,'Amman Governorate',31.933125,35.913360,'enabled',NULL,NULL),(332,'vendor','$2y$10$qn2aPqenlqCvYFIJ3BbH/u385w.Zp6DqQ4DZ6xxeLUH/UtQMa.zLa','795125980','dserf133@gmail.com','عيسى','محمد','2024-03-18 07:18:02',NULL,'inactive',NULL,NULL,'Ad-Dustour St 123, Amman, Jordan','d10HsyrZTbe8PLfWGbfjfr:APA91bGr5XwEaLnphwCFceS2wsGCSkh_FRv9CbCxPP4KYMTqRDUYbc6DhgFbX3wGEdLdxjAqpVeFIhUek3RigzHmshNEenNfGoWggQfAczOUTLnVPpUBSji4bFwhmp7S_3mxQzPX1o6G',5,'Amman Governorate',31.932633,35.912878,'enabled',NULL,NULL),(333,'vendor','$2y$10$OUs7SjnyZcZSdvTJrkZ2heUtboIkMLsEUbkQcJSMgWhIcQiTA6urO','786986169','altmryahmd801@gmail.com','محمد','ابراهيم','2024-03-18 07:28:11',NULL,'inactive',NULL,NULL,'الاخضر،، WWM7+559, Amman, Jordan','cVGbwpfsRfmdfkk7z0rYgA:APA91bHaUACpVjgow43CdQpyBhVVqGGHR1VxGEIn4pg0tZE7ZELqxThxO3WCwuN0WUQkECVbyqnMbFsREYhgI4b-iFz1JJ5Eqp99bwqaHDcAdmgfaqMZ1pLznFqVgRcbxducCKfi59ND',5,'Amman Governorate',31.932882,35.913035,'enabled',NULL,NULL),(334,'vendor','$2y$10$vCkgUNrIMG/yT2LuKks6F.OjAXD/BfyQcGPLYHeyXO.GEL8sCYeHq','799695132','tamaramobile5@gmail.com','جهاد','محمود','2024-03-18 07:30:44',NULL,'inactive',NULL,NULL,'حي نزال،، WWM7+34W, Amman, Jordan','e_L-kPz-Sg2C4soCBntlM6:APA91bF0FHWqkeVIL8rXo2LFUW4WmK92eLJ9HnRLs6QVqhzXxIb_5f7x3swWw9RZdtvzbbRpYaYat5KTrV_DKbqrf_r6xw9hvN-3lQDuAffmyMwyFBObKQOXrQBYNppas_1ivPJ8fCp8',5,'Amman Governorate',31.932792,35.912829,'enabled',NULL,NULL),(335,'vendor','$2y$10$1Z7FPbxRSvwfYZljpdQ/A.ye81yOVLSNNcVDqbqZ3iFWZAOZAuVPi','799698975','innnaoo90@gmail.com','حسن','صالح','2024-03-18 07:40:09',NULL,'inactive',NULL,NULL,'Issa Al Qaysi, Amman, Jordan','eQ21oaEzSRy7X0sAAfShuX:APA91bGkZA1ZvCgAvxq494WODiZ1ehG2tNpmRWhwezXL3x_xSy4oZGVxSPtun5KG1IHSURYX8LKLSZ2H_XSYX6kcrP6MlKmnDfpZ6uwIr_MsFsNYjdZbVSpyVre60ZxXWt66tb5mrkB7',5,'Amman Governorate',31.935525,35.918486,'enabled',NULL,NULL),(336,'vendor','$2y$10$cYmp2v2Y8hdFIKSODSQ.3unDU74fi8kymxNr3q3MZsB4pn4Oj6e5K','795801587','jcufkvhgh@gmail.com','درويش ','موسى','2024-03-18 07:47:27',NULL,'inactive',NULL,NULL,'الذراع،, عمّان، Jordan','c1_njKxiQSih6pjAI-u5NY:APA91bHCkky1my71p-zXmU71cfXeWo5VBNKkF-RRAUVUf8F5CASj9AB1qVQ_0srR6kC3Qt0gX1xheeGcugQS0rTG_Le6-FiPNVqxPjD5EYlPJnC7GrmQSEfE7DLOVUUV5MfhYpCZi5x5',5,'محافظة العاصمة',31.932891,35.913968,'enabled',NULL,NULL),(337,'vendor','$2y$10$F4r6oxkw7iRlf/EfgGQncucTmOqAuLjv7XO/uC.Ocj/OyKtJ7kuBm','789607730','ayoubabormas@gmail.com','ايوب','التعمري','2024-03-18 07:50:13',NULL,'inactive',NULL,NULL,'WWM7+7GF, Muhammad Al-Ayasreh St., Amman, Jordan','dMeOlKU6SBydUwySW1KfG0:APA91bEisOb_WhHJWM8v-Tuscenc9gC5O5R2RitIxJ8vbeQNeXtn3A1w11mwPZYP3AxMJX93j2uj_SJ-uD34cSjoJTAZfZOZc98Oz9jcBSEjQykOFGNziktBD2fPmclgD7CiyNz5GKrS',5,'Amman Governorate',31.932983,35.913865,'enabled',NULL,NULL),(338,'vendor','$2y$10$KN1KlFWZfQPXUo23WW/OSOaRlNT665KgRrYNf.SexUG6XvZ5uICQ2','796271127','ahm170747@gmail.com','احمد','الزواهرة','2024-03-18 07:55:37',NULL,'active',NULL,NULL,'31.939374,35.915767 amman، Amman, Jordan','dyracTnVT-uheO02DYZzyJ:APA91bGzfBtHTs-3q1r-JxTu4gloMIOwZ-lCHoFXDiy3Vi8mOWciWGmj0Re_zTnj0zfbAAdM2pB-eqq5weM4tUTOCx7U4jBi2hwEj8nya0qMA7s7M4xtQDf_z0KoaCVnvy7Kxxi-Qfgc',5,'Amman Governorate',31.939982,35.915313,'enabled','1.0.15','android'),(339,'vendor','$2y$10$pB.Tlpw1/Pkf1ifzSmn75uqTgRWgrNwXZUfLcBceTGiiw/tZnPb96','798226383','wdalbywy9@gmail.com','عوض','ابراهيم ','2024-03-18 08:02:45',NULL,'inactive',NULL,NULL,'الاخضر،، WWM7+559, Amman, Jordan','fTJtCyxFRGa30UA1ezNbte:APA91bF7mUs0SfGwjL0k0ELY0tlEtuWC9HOSnG2Fg1Yju8pNDcpkjRIau2bKlJizyKOg525yl6y4D5FNiAI3fvgE7Jy_bS08cKcLVtwpyeKhBHvjzhe8KllvlWd_l1RI_zrUYgp4mNlz',5,'Amman Governorate',31.932899,35.912953,'enabled','1.0.15','android'),(340,'vendor','$2y$10$c8XcfzdCq0BKX5pK8kX2NOB5NbuKa3/.HnWhTi8doXOU8H6H47eIe','796904659','jasrbrham@gmail.com','جاسر','احمد','2024-03-18 08:32:07',NULL,'inactive',NULL,NULL,'الزهور،، WWCH+9Q9, Amman, Jordan','fiYeWfsTQ5Cbl8f20Lg83t:APA91bH-rQcsqWDIjxUmdr_Qw5AmuoNdeceNeIXMJpiHtOVT-CiIesSli_DUncU2rgEiTJ_WlFmsFMXTP-iK8IJrMEvDaL7fmMyHDPdx76Vabx9VzK1D9Darse0SpIMMoHQv1KGwc-Da',5,'Amman Governorate',0.000000,0.000000,'enabled',NULL,NULL),(341,'vendor','$2y$10$Oz4QlS1WAroAhHNAYIP9nO896Z.5idvYgZHQ/niOQ3AF7HH0Zpzj2','799923077','naserabumosa@gmail.com','ناصر','آبو موسى','2024-03-18 08:36:11',NULL,'inactive',NULL,NULL,'WW9M+JFG, Amman, Jordan','eMBPRfWnSE-GcFqTg0fX8f:APA91bGSmkIlj64HQKfjH6spgqU4HlwV8C6qn7yqIGv0ZUw6xqEel-egNo73_25bqt7Tx9dz6lqi8kO-eEl8cmkdIEtl6CB5iT7Ym6WeKE0JJ6BOeMg-qnXGQN1S4oUK0ZvqZIKpO02Y',5,'Amman Governorate',31.919643,35.931018,'enabled',NULL,NULL),(342,'vendor','$2y$10$yYNU5kzO28yXy9qZ5GHgkOIEFSg7CwZvBQMYRv0OTU86rh1j5I6MO','796844561','lwjynalswyr@gmail.com','خليل','غازي','2024-03-18 08:37:53',NULL,'inactive',NULL,NULL,'WW3V+VH6, Saed Al-Qarea St., Amman, Jordan','d280osbPTUutC39SrH6jFn:APA91bFchZ8YEFO5G2NLb8bj4lfErjYWWPJTe2-JZsV35Bd5qm7-BxhI5B2vE2OW0prHH19_TkvHEeN3Eq64akAW6f6ltDJCjonrizwBUEoBqXJBzzWvk_h70tStP7D1WQYndd00dZ3N',5,'Amman Governorate',31.904426,35.944744,'enabled','1.0.15','android'),(343,'vendor','$2y$10$P6G50OJ.utUBAr3h2/Anuu4OzJn9zngxcBrypEp/PkdJ7m3xGhmCG','796044732','amenaldardese@gmail.com','امين','الغزاوي','2024-03-18 08:48:45',NULL,'inactive',NULL,NULL,'WWGP+22W, Al-Maghazi St., Amman, Jordan','dKDvsKpUSxe6csoZ0yqQ5X:APA91bHJy-Hra0h4Y0xvaAtP45wbi4iaNtLsJxPjqo6HtJ0fNQzMoMhhUJWZHx0gQscKoZjmZw17kuyJDBOKSXxxABzca2Eo9n5Yp8Nb5LMB799qf9bmhJ7tZh7fuff8FR1EDQmxEFao',5,'Amman Governorate',31.925393,35.935128,'enabled','1.0.15','android'),(344,'vendor','$2y$10$Oqu98XJsdkVe4qizKTY87.WJQfzX3612QvBLcsK4TMbGk.cUhgPd.','795412485','jh7697755@gmail.com','جميل','حسني','2024-03-18 08:54:36',NULL,'inactive',NULL,NULL,'WW3P+VWJ, Pr. Hasan St., Amman, Jordan','cJKy0JssTqSsMslAV5zSBa:APA91bFHPI6ho5BfcQj9pveLKhwuq6dXDoHIyqk1yJXPJuowa0EFBqvS-beRBODJwWlrq9bl6rGGl-0x06SMdTePlnCjRae4XxZ-wddIa_oFhJXBcpCMGSXTtzTb_2NHzoGq4KOAMHhP',5,'Amman Governorate',31.904536,35.936889,'enabled',NULL,NULL),(345,'vendor','$2y$10$l3s4k7nTUN5llmz53kbTXOSkMRDP8fC6KhvE4KQc8e1ZctiDp.Imu','796414427','munerabuawwad@gmail.com','منير','ابو عواد','2024-03-18 09:06:55',NULL,'inactive',NULL,NULL,'WW99+6M2, Amman, Jordan','cFM6ICzHRpipnKdCga5Tus:APA91bET9QpTXHKJPoP5EXETaWN14fipwxe_Rb2SYVQOHw0hrtr64gBSQsVswlhcj5hOZ8TyGVu1t_tSk5ZYalMUQSy_RM9kKzHX13Jorw8iivj2Y94XBWzAtwYhAanKKwgEC7GNpDzl',5,'Amman Governorate',31.917757,35.919689,'enabled',NULL,NULL),(346,'vendor','$2y$10$wEpiIpxGkM0BdxZ3bl1LKOGpkjoseCiSyqsB488X7baKR93CUQJvW','798525914','ahmedalzaatreh466@gmail.com','احمد ','الزاعترة','2024-03-18 09:14:35',NULL,'inactive',NULL,NULL,'WW9M+JFG, Amman, Jordan','cZCLnjeQSCGjLtlnAJXtiI:APA91bG_BMdFpt4-c9I4qYHyBtjUdXYTXx-8IXF19PmAepDpjv9xR0Dbi8YVizNBNvAPSlya136Tj7MlFYD_SS1byPHIrMV9MxCyD1Docfy8108FUygY1dt-5-kENRegy34TarBXs5RY',5,'Amman Governorate',31.919837,35.931498,'enabled','1.0.15','android'),(347,'vendor','$2y$10$3M3S8.A90CeP264RVF2jxOUICK8D4wYlspwLQHE9ANFMWPTKplzeS','785319582','mohammadabogharbie@gmail.com','محمد','ابراهيم','2024-03-18 09:20:31',NULL,'active',NULL,NULL,'X2RF+5C9, Amman, Jordan','ffR_37iLTBiRoF9sjojtww:APA91bGP-LnSsk_oNdpgesgfIGjsrCYELgGHt0oqoIpbyoE9xo_h5_aUDMqdFVlyO7w4LkKgzq-90FkaKNIng-i4EtUaFucCqlSS5vXFHAvC_CBFKGQaHZIpPHLVkZ_VfQrUTDNyJto7',5,'Amman Governorate',31.990443,36.023669,'enabled','1.0.15','android'),(348,'vendor','$2y$10$RRw8n87zxIreTj48VYOeW.7MOuNr1LdXedQSUxHQ30x4BrlbHmHVC','795589405','headm9598@gmail.com','عبدالكريم','جابر','2024-03-18 09:58:17',NULL,'inactive',NULL,NULL,'Ghazwat Dawmat Al-Jandal St. 1, Amman, Jordan','ckBhKPO9Qwa7CI_lpRWyqD:APA91bFulLQx10RtgC2zB4fTh7Ghjd1HYDzmtGti-9LSjtqTJQS9i-vwXxCkVGx0tj5A7veondwciPFA7SmxkhXbKbaU3imOZvysX9_tuI8bdAym_RwRS_aa1uFu4k_Bdo80uP54HHEV',5,'Amman Governorate',31.921792,35.933692,'enabled',NULL,NULL),(349,'vendor','$2y$10$24/Cb5gFYk2q4Rcz/SRrMektVHLJYdhlP6pkTP6gG.2EsAU3Nh2ru','790956193','asmaylabwrjb570@gmail.com','اسماعيل','ابو رجب','2024-03-18 10:02:41',NULL,'inactive',82041,'2024-07-06 09:18:08','Khawlah Bent Al-Azwar St. 78, Amman, Jordan','caFqIhr5QLi0dWAfevEX4E:APA91bGgzJxOdB4AqtGfmIdkYyccWRGTM6RhnuhXMuaNVBIljcgeC9O8QcC94NbJaFCJ-eBRFdTQHO6SPn9f-0Ycj9fV5vAP9zaYafCV_BTMAzg2PxofVFG-nNcB1qtrw8o_CmBkIxyl',5,'Amman Governorate',31.922317,35.934111,'enabled',NULL,NULL),(350,'vendor','$2y$10$50Pnc7ZQdfoM3HmDn4DI1Or6HTt16UTptIdDy2y/hkq4ciGAKysAC','795812684','wdhfras@gmail.com','فراس','عودة','2024-03-18 10:47:25',NULL,'active',NULL,NULL,'WWCR+CHV, Amman, Jordan','dH9Y4ApiR2y7xzvqdDTg9e:APA91bHHzAfYLx66Xp-MO_3zjHrCelmhFPkHbGyNXYC2cR6fwjvUnkuu0KnLATtp1DW7WVnqYoUqvmtZ0KiutlsA-KRbt1045PZYvAql2FacfEdnk2IV-Y8HaAwQ4i3cjFHGIGpqmcrn',5,'Amman Governorate',31.921536,35.941813,'enabled','1.0.15','android'),(351,'vendor','$2y$10$q0x39/jyGiOfMSscA0VWY.mZahV/gTbQ7xOMhK8KOgKgXpDW8FY0W','796141900','zaaainnnnn1234455@gmail.com','ماهر','العجوري','2024-03-18 10:49:19',NULL,'inactive',NULL,NULL,'WWCR+CHV, Amman, Jordan','fpLtXu_kSlGzpTUE5GbAk0:APA91bEQ6G4sf7vlyXQyibiI4JURu7levjJYrQ5Xb6vSZ7kh-URL-TDo_CHMpYwPekWERbxFzAsDdOytOakqioEDbTcu9NrYuWcc2G1iiB01v_5MWTPRtJxU1p35VdS5QJiYa9qUV_tj',5,'Amman Governorate',31.921732,35.941138,'enabled','1.0.15','android'),(352,'vendor','$2y$10$SsNxbEoAEs5DWY4aN8niEuae9oU/2fEoZpsCJdDApqFhEuAyg.6eu','791565209','ayadm1772@gmail.com','اياد','محمد','2024-03-18 11:09:55',NULL,'inactive',NULL,NULL,'القويسمة، عمّان،، WW8X+V68, Amman, Jordan','fuQjZgjZTyKOQDEFObrccq:APA91bEns14b-gvwV7PA--0hhw5m2SKiXosdkxtzvT49Cv8jcykYd96vje-cfVe2DQJJIIdfNfqO9TAdYusf_yONPjzLdMu64tJifswDR4z_ItiZLrgwpc8HaGA9CEAvYy5bVhTT9YhW',5,'Amman Governorate',31.917223,35.948074,'enabled',NULL,NULL),(353,'vendor','$2y$10$nEPPnc5HEDHKH5yPa3tDiehB11Eq68eTQ7iTJfCpOBqv.s96pbXBS','790646026','helme07906460@gmail.com','حلمي','الحسنات','2024-03-18 11:35:10',NULL,'inactive',NULL,NULL,'W357+XG Amman, Jordan','ePJCqUTUS2i0Xe7xgI1Wba:APA91bHKO8Y6LR6OsAc8y07XEbcTTV-Opdvzw0IlQnpP1dTtLv8YUylttA7GHq26SDmQ63_EOoLjMD0ja20bhszHeoZNyDjYz4yHtvfPB9iocbGLSUIkiW3sqlFAtFRu5xMAVGvV-C5g',5,'Amman Governorate',31.909970,36.063832,'enabled',NULL,NULL),(354,'vendor','$2y$10$5gTstuR5aNpEx5zVSLE1He5xGntm7lzSPWWBeqHj/zlMIguP68Lzy','795632883','mahmoudalqadi9@gmail.com','محمود ','حسين','2024-03-18 11:35:48',NULL,'inactive',NULL,NULL,'WWJ7+J25, Amman, Jordan','ckJFY-DSSKOt_Z0U9CNBmS:APA91bErpY9rV8tzgYlbDEUgKQV0rnexgAwf4p1yWX0s7cqTY5CbCn8JOqVn62lnAJ6CXwhrD42xvw9aD0tMvB0pICvytdx_abq6OIG8N6RsKheLymQ0HVp2z5Pk7QVQTpymBXybP98k',5,'Amman Governorate',31.931385,35.912620,'enabled','1.0.15','android'),(355,'vendor','$2y$10$yoa/i1KMKxq.h70XHdoWKOf7MmAktrHpwbJKXugbe8yJQvrLiNp8K','786366231','mohammadqutmosh0@gmail.com','محمد','عيسى','2024-03-18 11:36:49',NULL,'inactive',NULL,NULL,'amman quaismah, WWFV+GGC، عمّان، Jordan','ck2FdBJXSFWTag1BuCPEbN:APA91bFkS4J-xTbMkGBYbuFpavU7H1bDpStQMI9G8FcQwra0UX3FdhBl0WQj7_JH273P0N6uScswMZ0bjEGYSMje15Ph3aeWPC7LimIPQwVBtFMfg8_d95yd2zOnuUt_K0CTI1QnlrUs',5,'محافظة العاصمة',31.924041,35.943653,'enabled',NULL,NULL),(356,'vendor','$2y$10$baGDhoYadDmD1KOA77slOeqA3mGPRF7FjlZ6Sr4XHDN2Z8xlpVlye','796310419','mom139951@gmail.com','محمد ','أحمد ','2024-03-18 11:38:35',NULL,'inactive',NULL,NULL,'amman quaismah, WWFV+GGC، عمّان، Jordan','fz-ML9UaSKaoKoxHyx354N:APA91bFaDwss2UjpN66PunnwDCYpM5YqIdSP3Yasjlnlm04TL_fferr1rGRk-HRtoAhnyTv_Tv07nxOKUhiNi4Ict2-Zvjf5VOdYenyYYmjE5HN1Rsk6xwxGEhXsdsMo9Utw4jY8kAkl',5,'محافظة العاصمة',31.924088,35.943430,'enabled',NULL,NULL),(357,'vendor','$2y$10$PoFUz.Acffj3z3yirOFCNu3AzLrc1orLwHPkq3N26o6kYsLKeKh.e','798502935','ahmadyassin77ahmad@gmail.com','احمد','الياسن','2024-03-18 11:44:43',NULL,'active',NULL,NULL,'amman quaismah, WWFV+GGC، عمّان، Jordan','fUJ7sebIR4aqM26ZOTzAj3:APA91bG8iCgSLVZTL2fAaAaO15h6ImxWhDhOWws14liFWcAwKklMp4pNue5pE0paoevCHIRAjkwSO4F4Sc4xtCayzZjVJuVtO49WPV3CorWhcecMzWjIntZr1YIKcXqboSTe8BhF6Him',5,'محافظة العاصمة',31.921426,35.939058,'enabled',NULL,NULL),(358,'vendor','$2y$10$.hIzrlyHuGmKh3jZPIkpQOmnrwvT0oYQ5fPpl5ECDnlafGpmYA5hS','789795524','a7medosh2@gmail.com','ahmed','thlejan','2024-03-18 12:11:16',NULL,'inactive',NULL,NULL,'البيادر،، Amman, Jordan','cKj2oSCETry4REJ6kCeiKU:APA91bFf8N5Jh9-AmHqq_lWL_TMdYLJ36yUc7fU_c1BK1KBepOjLabI7D22AVPU0vMItclkSRH3v0Y5nbcISNsFvecUzRKa0ZSAKFcx_6RohlS_ZLFibv_EKSZqyAKrw-WCivwZc0g_9',0,'Amman Governorate',31.952482,35.822471,'disabled',NULL,NULL),(359,'customer','$2y$10$/LnS5wD4quGYSVrvoOREm.lo06NMX80bGlIevrWC1kBrGMA2M8b7O','781102072','daldebsi@gmail.com','Diya','Aldebsi','2024-03-18 21:11:06',NULL,'inactive',NULL,NULL,'Al-Haram Al-Ibrahimi St. 18, Amman, Jordan','cZyv6K6OIEvzogVtr6pqOR:APA91bFy-vh8ePrLVIPWlhgIa9XwwL1RWCkGTwrCzq5_MF5h-n1GH6OudS-jqYmgtLlB8ZTFuQ_ZOLyXIm1VZZeZo74WcudCrvxdSZuF6l7vbICll9FsiaY85wmPW9oCW4bKghasbh1o',NULL,'Amman Governorate',31.915761,35.931193,'enabled',NULL,NULL),(360,'vendor','$2y$10$rFl9PEJMeodTnA6Xp85D9.AmP1SaWcn6AhGoGYDsAQp4R1N17Da2K','796040303','0796040303sa@gmail.com','سليمان','ابو شنب','2024-03-19 08:15:39',NULL,'active',74703,'2024-07-17 12:00:07','Al-Urdon St. 363, Amman, Jordan','dYekAg8vSF-kot-usb21vZ:APA91bGTdrpELZZkR1n5DSCFphBxBERZ__5vgXhpnBEjt8rE7FLKlu831wAgMCpzMrgDynqgkW7aTqtJYe1FtQV9kZFkzo3EJ0Erz4CceUAUj_LWhcn2S2jSw4HMz85GFqAtViCBoyBC',5,'Amman Governorate',31.968903,35.926839,'enabled','1.0.15','android'),(361,'vendor','$2y$10$A/5HDbPXUgSuAw/Ch05yEOoU5hqnat37llePA3RyXHXuzRVyP9Ida','787528042','saed45258@gmail.com','محمد','غوشة','2024-03-19 08:58:07',NULL,'inactive',NULL,NULL,'Complex No 6 Sufian Al Thawri St 6، Amman, Jordan','d-PvbWymQgaTtHpmpeeTnX:APA91bFwGvqeWjM9FMZBoWPnULg1esAaFytcZf9RiwCZ9LtDfsgQpNiXjGkSS-eVrT8Eax757-Y0KKKjfY3owPo00IBFJQN3VSizdP7A5qWNc_G8lsE89-uazKeZ0IN508jgS3KfW81_',5,'Amman Governorate',31.979839,35.983346,'enabled',NULL,NULL),(362,'vendor','$2y$10$Pdm6kqt6dluT27G1s7y9PO.XK7.28URLR2NhAaPykHSwGSQVvxzB2','799314170','alialqarioty123@gmail.com','علي','عوضالله','2024-03-19 09:11:51',NULL,'active',NULL,NULL,'VXXG+MM9, Suleiman Az-Zaghloul St., Amman, Jordan','cxqS516yQa2yEh7whPsQ79:APA91bHiz1SJ8aR9l2l8zwoLJrc-9hRcG8WlVjNOvKYWvWl-z-7vcMbfk2Utx5ptv7Bj3BJwm_D-6U6lyk_8vez0HVUY55whhQUp5hrnbGwdpJMLm7ItHEk-c_oheTs09fHxNfftJsju',5,'Amman Governorate',31.898728,35.975506,'enabled','1.0.15','android'),(363,'vendor','$2y$10$9N4V6tgNGULFekzGNlozQ.8o9yM4YAsAQex5wQR6AGdCqTuEERRJa','795158671','eahabhassan96@gmail.com','ايهاب ','يوسف','2024-03-20 07:40:50',NULL,'active',NULL,NULL,'2VCW+GM5, Amman, Jordan','fiPEr59uTEyJMMlLkX5Axu:APA91bHInhJRyu9Opijs-z8E_ugIAmFStiwQ-2k_oe_zXEazng5T0joUCfRot7Fadc_HVp4n9uOlk0p059d-PpUiSl994onn-cjRRbBr-j4uElz2_-er_W9zhPlLt33KdRInYR-BlT5j',5,'Amman Governorate',32.020848,35.897141,'enabled','1.0.15','android'),(364,'vendor','$2y$10$MqZZwReWVRQgmlU7woWEXe2dOXRdTbj.V3k3Q7.yGzSISdttc4qu.','787120652','thaerabuyehya@gamail.com','صهيب','عماد','2024-03-20 07:48:08',NULL,'inactive',NULL,NULL,'XXQP+625, Amman, Jordan','fhqehE5JTJey0LMsm9fy1U:APA91bEyrHBzKENy7o1WLhFuXhlI5smGFG_FMTIdbJqMAlapM82NioYzoZ93QmK_S1WznGJGK-fSZ7ix6xQXLztpq9KspaM3xJeIef5vWNFNy-7DqH_KNq-CygwA68E6ZZmiwHWQ0MwN',5,'Amman Governorate',31.988622,35.985476,'enabled',NULL,NULL),(365,'vendor','$2y$10$L8fZi/bZRzZHqq8sE.sc8.1Hj1lJqdr/MEALEaCnCraSAvw.yRXVm','789465193','alsbawa984@gmail.com','محمد ','ياسر ابو يحيى ','2024-03-20 07:49:38',NULL,'inactive',NULL,NULL,'Prince Faisal street Amman, Amman, Jordan','fuD-djDKQm-454HcWwUJ_8:APA91bFKDUopybg0hwOmhGsEJlTNJNxETgHUPcexOXc7LslbBAxHzCZ8Oe2CYANrTTUGmciF-olDcqbiqMlly9JaLapR7d8dH7yamjadcRq4IxlWpGNzno76LfcIPLGa7C0CiCt4an6e',5,'Amman Governorate',31.990285,35.976834,'enabled',NULL,NULL),(366,'vendor','$2y$10$Pe.aVTU9rWQ55aDLrWmeC.pWPCuKSypkNvaD8M5dg9ng67x3dhJkW','791428552','jwadabw29@gmail.com','خالد','حسن','2024-03-20 08:34:13',NULL,'active',NULL,NULL,'Kaeb Ben Malek St. ٢, Amman, Jordan','cILG64ZCSiCc8IfdUBBIgu:APA91bGQbEvez68NFPYwd9xucHg2uXwM_yVmPTdadT14g9L15TMumUf8bT5mH4nuj1O-btbE_M2e6N7KBXVtLBkB6X60xmIJFd1kmReVFO5UzfsdxOd4q1uvBIH8hOS6g-07e5jVpkSf',5,'Amman Governorate',31.987889,35.923875,'enabled',NULL,NULL),(367,'vendor','$2y$10$.wgmZPB51ZzxchemJGG4LuzAXUIqVIFXloAg7yCqjcH1ywsZJs2VG','790366892','khaldalmdahnh7@gmail.com','خالد','المداهنه','2024-03-20 08:35:39',NULL,'inactive',NULL,NULL,'Ali Othman Commercial Complex Khalid Bin Al Walid St, عمّان، Jordan','dXrjorwISfWbQt2PvEvaE3:APA91bEpTl8YpMErOOvbeiYbB8nMLGJiIX8F9J_M5whqxClmsdyA4Un0n88gSwnsHrwjcMEecDmVQXnOQORYKhzJveEDywSrL5_JVcZeJez_7oyCbIZbsXeVmnSTv7jzb06oonaSBBJ_',5,'محافظة العاصمة',31.967463,35.916658,'enabled',NULL,NULL),(368,'vendor','$2y$10$F2oT..JWeqzbQaaKiMBW9ucDFLGiDDNs4X6jx9gZPHOgs/olmyABG','777846977','malkalgtawe475@gmail.com','مالك','القطاوي','2024-03-20 08:39:20',NULL,'inactive',NULL,NULL,'XWPF+XFR, Amman, Jordan','fe-U8OiHT3qI0ZJo6PR-wx:APA91bE2uiP6_UPKbWWXUpidlii0Pm4TNfKpo9QVIeV4wh7MrIcYX4c_8ndqfguKZeAAnKz-r5dRNEDUIPr6QxOjAg-LE33Id36Ry1nC5mPzmHdJHMJJ7kr4dUgppZZksheMu-C_xF2d',0.5,'Amman Governorate',31.987510,35.923563,'enabled',NULL,NULL),(369,'vendor','$2y$10$N8HguSPp.NWQJd8qwBrgNeuXc.PhJ/ZeyTosCza4rKRKXHb60amPa','795426103','zalabadi929@gmail.com','زيد','الشرايعة ','2024-03-20 10:04:30',NULL,'inactive',NULL,NULL,'WQ3W+GVX, Amman, Jordan','eyMt8HkBRHiLnptopbpUTi:APA91bF6MDx9YCILkTDsnqPCRl_V6P6hGaYzzvw4PpKmK-E68kZehnSYA-_CYUHqG9aPS9qOJNNs6KbkkhtchFOCB_W1pnb8FYNAF_4o9-oy1lBpc-fmpZC9Ia7nkJNdZK_fCuJjTTqO',5,'Amman Governorate',31.903086,35.797923,'enabled',NULL,NULL),(370,'vendor','$2y$10$EEfSWrVNWwCdQRGW5zIroOzjno80Gs6uaWfryTPxK9JB0efPFTmAO','797355813','rademoham03@gmail.com','غيث','المناصير','2024-03-20 10:21:54',NULL,'inactive',NULL,NULL,'Q. Zein Al-Sharaf St. 23, Amman, Jordan','eSTbXa_7R5GZXATj7N_Vcz:APA91bFXJkiqheZfMuulOC51Yw--lwuhyORcefuc-US-6sQ8t8KWBn9QatHRkV1pwrcd9GFYwbYdXUqDBb3swDSFt4cgIeXSgf6H0IXXnxqfyXU0lQsYPeGjNijiTY863e7Wh21-Kk84',5,'Amman Governorate',31.946859,35.877860,'enabled',NULL,NULL),(371,'vendor','$2y$10$o3pRa4hv8uHNKNCdGNURg.O6TY5s75U6.wW6Xpm12DIEP22F/S5hW','779808019','ahmadmanaseer902@gmail.com','احمد','المناصير','2024-03-20 10:27:10',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','cgH4CRuNSUmhcvCLFjUEPb:APA91bH-qPJmTISaITKLuMaxurjIDMtdLvcrJPXQJ3LvXuU-5Ci1kb7kV0nUX22xXpoP8IMYuizD-rSmayCgfsQ46FchGcJdCJfS2Z5xz22acJwfv_MKk_Gc1lpcQjy0DKK1lPGi_k7Y',5,'Amman Governorate',31.904752,35.804000,'enabled',NULL,NULL),(372,'vendor','$2y$10$kfns944N90KvPUzJS4aK8.0sGtLkvpLKhoqWEFfWIQ/nLHdTtaVDi','780541388','hvv255235@gmail.com','احمد','العراكزة','2024-03-20 10:33:51',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','etEq79hxTKW79eTzc4Bk86:APA91bEZlzcvEneqPjaiCHpkhSI1PLSc4T_qi-Hl-ROG2Scq7mWPuNakZshVXLwEzvfLPJ_7eXOl67VLA01kUXZPUY7Sr_Zwg9FKnHepuGk9zTiunNNoo_0mcvU9dz-lSVvbzcfyduiR',5,'Amman Governorate',31.903431,35.803996,'enabled','1.0.15','android'),(373,'vendor','$2y$10$j8ay8z4DVvlEwW9xJ1GddO2BYUNFpnYQcqAPN22uiNLteJVdtIwyy','795275033','gghfc111@gmail.com','صالح','عبدالحميد','2024-03-20 10:44:03',NULL,'inactive',NULL,NULL,'Othman Naseef St 47, Amman, Jordan','do0_XxnJR6mQZOwIB-Ph7i:APA91bGFo18rv4VsEx3Wt8zbD0bHLIwc2l-6XHDsWSHIxz2aG5ixdkS166_CHlBm5YcS48gEdCXdPn_lRyjBFOtBjQfL_pmfeihaKeOGPYJ33q5l61PZscz7cNAqCSkzkrxPJdSSLQKJ',5,'Amman Governorate',31.889119,35.869642,'enabled','1.0.15','android'),(374,'vendor','$2y$10$VJNObTn8iBo40..20Aa8WOhsAFhI.Q.XDJNumkR/4Y2zU38xIfTMK','789356699','54543hyhy@gmail.com','عبدلله ','احمد','2024-03-20 10:44:14',NULL,'inactive',NULL,NULL,'3RCQ+XH الحنو،، Jordan','cR2zYlz8TQyMUBYv1tf9UR:APA91bHCv_OS_ISJG4ZyQ24FnBDV-P_LMaYMTlWcbT9aASQlfT1LkpqkMFkrUFxFvpPlkM24vmtyXOXUlOs9XFvZ1XRfr9QrUakerlNyH7RLKV2MCiwUZqhsFKIKNnS8EAB7yNZGYEEz',2.469,'Balqa Governorate',32.072327,35.838922,'enabled','1.0.15','android'),(375,'vendor','$2y$10$O9l6j17hh1W0CSAA/dQCCe7FNbCOTlO/Ac22HXtJIueeUYwnH7vE6','777968391','byanbyrawy4@gmail.com','فراس','المناصير','2024-03-20 10:49:31',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','dqbQgMz6Rze5zbV78E3p4K:APA91bGbPYnZ0NKcjCQAIU-lGVcA-saUpiLZkYNfiDLCRHxuGV1e1_mCN1qPZra0_K1MCzZO9znzMXoBbW97c7ZniZYM9Qw-QgMLO1FrpPF6VY3De6Jm2ScDxeig-HofuGNd0HCAT1qS',5,'Amman Governorate',31.904800,35.804738,'enabled',NULL,NULL),(376,'vendor','$2y$10$9/bzzNL9WjCwmOJrA8iMrOF0lEU6hwG2tioLnM1JyUI0i62A.F2au','787446403','raedghanem@gmail.com','رائد','غانم','2024-03-20 10:49:33',NULL,'inactive',NULL,NULL,'35، Jordan','c4p7wRumQjud487LtOQOYp:APA91bGSOImTdA0fgvbqBtFHP6FR9U6kRYWgSvLzz-ZcxoaGCaSMk-l8PtqpZkl-9W7TxaqtMBRUsqwB5Om0Yr3y5qdPemzLWckp8wh3qrFx-lz8-DPj1_hD9Zc0IptKS9cbCEcvcMFe',5,'Balqa Governorate',32.064100,35.839033,'enabled',NULL,NULL),(377,'vendor','$2y$10$QshjoJBpYuSyviMz.20pLuU9HRTSX0PvPYFgQ6cUwypDszei2i1jW','789206383','osamaabujoumaa@gmail.com','اسامة','جمعة','2024-03-20 10:50:18',NULL,'active',NULL,NULL,'3RGW+J8 Al Hanou, Jordan','cTAUq-UTQ4ayDrc5nW_Url:APA91bHWi4RCUtIV0cQIrUGUuImj2oz3VJA2u1hxPJMk3ysA_8WgYZhVayZF6CGkhTPGgDTKNSuAuEmN-sRfJgrRId8G5wJDAKZRpObCx5lPLSyahO4itAgLB-czg3M_v0TAPMduIhpe',5,'Balqa Governorate',32.076612,35.845852,'enabled',NULL,NULL),(378,'vendor','$2y$10$NSdERBlg0Rm8zlEO.xCAlOtnMYS7LQpqJsbXiZVk.0pbTh1ndVtQC','785540191','smsm23133@gmail.com','احمد','ابو حلوه','2024-03-20 10:50:24',NULL,'inactive',NULL,NULL,'35، Jordan','cxevDSTdRrq8thUX-9UQjZ:APA91bGoJWgl7jYH-13sUgglfBpU292B-ZHyjsER_02tSAoKGneL_BVO9JmMbs9VxR2sYp3lNWsSqVne5PuaCOcl5crZY8pixfCxK1sVnrqzR0895UhGC1af9Mrr8zYjV0SuFbFs3Z_t',5,'Balqa Governorate',NULL,NULL,'enabled',NULL,NULL),(379,'vendor','$2y$10$eWbnKKjmXa0K76XW2MjN8evhv0V/ERVFPcw1h26FmW2O1JRSn.kZe','787535095','mwydashqyrat838@gmail.com','مؤيد ','شقيرات','2024-03-20 10:56:18',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','fRIAh39SS9yP5mpn9AqM59:APA91bHis9UepRdQ0jnBLLUWisLFvnA0K50zf4Lh5a0LbT8Uu6vgZ1GED3oVnhLNiJtzwsf2e645BQ2IjB4vSpYe0oY0l2p1rnTQl_FsKHhybs0XK3mFOVv5muzIb2VHYTqYRjSKVzxt',0,'Balqa Governorate',32.065013,35.839267,'disabled',NULL,NULL),(380,'vendor','$2y$10$vvKHAIxP9UT2Q5mo7phwCOS1AOb68mPqCZfxGvl7j4dJzbZLfLjem','795705220','jhahmad366@gmail.com','احمد','الجهلاني','2024-03-20 11:05:59',NULL,'inactive',NULL,NULL,'شارع ابو حلاوة 2, البقعة, Jordan','e1Kmbr7RQiSbc1kvjUkys-:APA91bFbGm9IMjDP5MTUYtZQ-BvZk2K_TORwU1fLXeHeYlo95jh85ixZxOAlVx9UNC4xY43FTlmWXW-YH0n6TMQ-5EOCYWNWR_e0frHRq9_FcKxeEX5hrFR74VRVYUUbmAdg4WYO14HS',5,'Balqa Governorate',32.071508,35.840048,'enabled',NULL,NULL),(381,'vendor','$2y$10$Wl5Ns/l2IjYdBY2cmdpTbOiUiNNGPkqUqwCZE2Brr2MFKW.A5gpRu','795916736','yazanclip663@gmail.com','يزن','كليب','2024-03-20 11:07:00',NULL,'inactive',NULL,NULL,'3R7P+3X عين الباشا،، Jordan','fDlhIfkwQS-xiL9HoTyvv7:APA91bEgp1uNKydjnCSQT2snKZZw9blhI43krOVWdj8cSwCU1qTLQekngKzJixm5Dm9N7AhTYQTg636JCFFSHtvRuixfPeWeb2AB0Edm_jsibfFxQihJiDjKknQ_SONHPx_6kFXEyVw-',5,'Balqa Governorate',32.063048,35.837837,'enabled',NULL,NULL),(382,'vendor','$2y$10$mk7x4zmk9.TZUpfrqffaC.lquZW7tiy1FTWSLWCUYlLFpZkGkyase','776115789','alrakztb@gmail.com','عبدالرحمن ','العراكزة','2024-03-20 11:12:43',NULL,'active',NULL,NULL,'WR74+W2 Amman, Jordan','fgn-I3HBQfWB0GrRX-Plx3:APA91bFYCnvE5vVlllnf7mG8fvYphn2sVjx6TOt6WOPQA5SqotAxkwGP4I6_Xk0u7DaS3NypFLgyqZLlwP6JPVWXQDXhv2ni8MO8Ea8NTHbuXfmpJNLbmls4p1It0oMWdPBKSrT63y8x',5,'Amman Governorate',31.914865,35.805024,'enabled','1.0.15','android'),(383,'vendor','$2y$10$59WLsWbMzkeHsdZ.I84KSeJ0.cnFljT2tDe5udwxe7XWbJcv3SlOK','797534269','almnasyr001@gmail.com','اياد ','المناصير ','2024-03-20 11:20:57',NULL,'inactive',NULL,NULL,'VRRX+XPV, Amman, Jordan','elOpKHFQTd2va_Wpoc-ciz:APA91bEhqd2obSvaZYhpl4qC9o8te7Bk8pn4ux3IugE9nucchEaVyOQ36pYzouXs2LnqgTkx9rmafLn0jQoV6VOgf8wA3w2xA-sbWtB24iXUEVx7KWKrziWygg0C-5nqanmj6OmsmpLR',5,'Amman Governorate',31.892632,35.849377,'enabled',NULL,NULL),(384,'vendor','$2y$10$twAom5xc9dzB6A08gJbYbek4PvNTg7UUku082ga6WLRp.ggdfA/5y','796503470','fhwr99671@gmail.com','يوسف','عبدالله','2024-03-20 11:24:26',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','cUF7CcSQSRukVAXhLiIdwm:APA91bGlih8Wm03S7nZP8dpsZyyp2Lo_3rWXnXBY9aBUZu-5WCveHjdLl8B5OyWU4HdNLgkUoBPNIfQSun7m00fF5DF9EYU0ImGHMIXP8x0JRvRJLvSU72oLal3HQQ1-KH2H34dD78tL',5,'Amman Governorate',31.904818,35.804777,'enabled','1.0.15','android'),(385,'vendor','$2y$10$JYssz0aE433NVulhG6eX6ujDgXTSwZ.f3dW4btktv3sTZvPEeEPWa','791474203','dhhidjdbh8267@gmail.com‏','bandat','sameer','2024-03-20 11:28:14',NULL,'inactive',NULL,NULL,'XR2Q+Q34, Abd Ar-Rahman Al-Husami St., Amman, Jordan','fG77UYpATTCQJcKPfgzQG3:APA91bHrRYMdVmcD0EbmOAwAZevZczqPOEA-tWoffDs6vqFc2xvokW3ALJfTloa_jIpJpEXOeqp9rA0WaaVqp51JgxgomJdiS7P4byxZzJFXz0997EAHz-9X7yEHVq-Y5d69lcxJVbCq',0,'Amman Governorate',31.951863,35.837550,'disabled',NULL,NULL),(386,'vendor','$2y$10$v4m5YUIFW32fnhyoGajnAOGxpyaUH5noCJ7StVag9PlB0SuIh.Rmi','795758316','alnjrshkry@gmail.com','رائد','جمال','2024-03-20 11:28:59',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','dsXZtMlhTc-tAHk8u4gakZ:APA91bEaG_WejdWTWfCehZfj7zPpms9rYAkLkTk8NMjHOa3t77ty6AyCfNuLGpjCtoV9MC1uY0Mqc0JuMCZRvMioGi3lfnPbUMz0_0DcEpM62ylPRQErEztS2eiTZjESfxYjOrvWaL1n',5,'Balqa Governorate',32.064940,35.839145,'enabled',NULL,NULL),(387,'vendor','$2y$10$NyFTs0Cg3/xbiboSAbBqHu9JIEwJ6odoGiByHH7QSdAK9jCK12LQK','796809521','asreewppbbvvvbv@gmail.com','عيسى','غنيمات','2024-03-20 11:33:28',NULL,'inactive',NULL,NULL,'3R7Q+RH عين الباشا،، Jordan','e7zWbeFUSyqEUF2PBA9Qnw:APA91bHmvqvH0AN5jYQMWw1JwX7ohkm7XLXj4MzuRbuSUZLJO3ARwKFz9wM8ceCfxH33R5TkPtFXpEetNVc2T5_xjtFWgDtWx4Vqno8pRH7YP4hiw2yaQlw_ElSA-DpQSkhIQs10tBpg',5,'Balqa Governorate',32.064405,35.839053,'enabled','1.0.15','android'),(388,'vendor','$2y$10$9NGwBB8q9aLL4D.w5cO.NOWjYFjms0nK63hK6ijayMn10licEomjG','779567243','alaaalmanaseer851@gmail.com','وليد','المناصير','2024-03-20 11:35:59',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','cr6M3wdFQNaI3S8PlME98J:APA91bG5_UUHIogIM0ozJkEBIOLcJEKM-WTZVqgW6Ys-jvArhoER6w76JBeda-pHxPqUmpqCx0SJHFdy3kLhYE03ahbMypS14gUiM-G-ndaMjkkupoCJN3AC9dQRXXjdwt_8dQmfDTaQ',5,'Amman Governorate',31.904872,35.804659,'enabled',NULL,NULL),(389,'vendor','$2y$10$xwO2o1pQgI3ebyGO4ZDpSeuf653/bu85NnwoMFr.Jw529P1lNkLT6','777006873','asemalmanaseer3@gmall.com','عاصم','المناصير ','2024-03-20 11:36:23',NULL,'inactive',NULL,NULL,'WR53+W8 Amman, Jordan','fPNJf7VET_20j36pNikjs9:APA91bEfKTSVnutrp8ffHcsiYLV8mkaTqJbgvyJXen922O-WRMlg9z684l-Kj0bSUU0CrtY8PSi65psROx9vte19bNKuMnfCs-ZWjnR-6gF4ujenw5AkTr6IMEnJJ5A3gnNpdakwGnEw',5,'Amman Governorate',31.909830,35.803273,'enabled',NULL,NULL),(390,'vendor','$2y$10$.ejb3AllbYM9jGK3Ods0oun0Cu2sUJi2bDCfjvWorOP4Y4340HEGW','776061149','morad009988almnaseer@gmail.com','مراد','المناصير ','2024-03-20 11:49:41',NULL,'active',NULL,NULL,'VRVQ+MHQ, Dalleh Cir, Amman, Jordan','e6QDyIbVS-i_j55YBTfjww:APA91bEc7FqGPTeL9FlX4DXDq2-VExotFtnKZatXJPMZI6zQiDtC3XEbxrguWkVi-z7aLw59cbzhViHWEGgWtjGCdIhSAfehhvUwo3e1F4cofoW7TGCnC4C1DDGOguNpUnFQLyBl4yNu',5,'Amman Governorate',31.894216,35.838980,'enabled',NULL,NULL),(391,'vendor','$2y$10$Zusk8duMTt92pmC6ZtYZJuX8aPvBFD.bK26JoBdNrwSoqnwmVYDIq','792078688','manaseeralaa82@gmail.com','علاء','المناصير','2024-03-20 11:58:15',NULL,'inactive',NULL,NULL,'VVPW+9MG, Amman, Jordan','ffoIH1DgTPaivXjdxSvr1p:APA91bFyWYXPynnb20pP93BUirp9CYRNuOw9YS0Iv6VtpaRPE186u2gFZ5coE4w2mv9AdwC1K7RrF55vvi5IMH154URNj9g6bkboqjFAVeIFuMN21BoEpNRRUUpVUzbAxMdRVRa8Dgbv',5,'Amman Governorate',31.885133,35.897885,'enabled',NULL,NULL),(392,'vendor','$2y$10$PIVVLLWKtgO/zoeCWdqbDeuzJpQDHOxHe9gn0BCLoXnOM9wgWxoL.','790859498','qsyalrqb61@gmail.com','Qosaey ','alraqab','2024-03-20 12:08:24',NULL,'inactive',NULL,NULL,'VWG8+M4G, Amman, Jordan','e3hOk7oVQNyOmPLp8FIulE:APA91bEvucKnFBKLe2N3dT4V56__xIvg6ZhUF4hd5M6xRXhRTvPAV9VhfhdK9djKwY1dTuvIPRDaxK2NjFuN0hFbhA-pOH3QbzTboilFZ24wSTQW-31IR7_d1EoAaRT_dfr9wErjl1RH',5,'Amman Governorate',31.876584,35.914873,'enabled',NULL,NULL),(393,'vendor','$2y$10$deO37.O/0uvovMwXS.e0r.eU9VPSitK4ST6qRYkaDfmh47hua/I4i','770199371','adlalhaj24@gmail.com','عادل ','الحاج محمد ','2024-03-20 18:10:18',NULL,'inactive',NULL,NULL,'Pr. Hasan St. 34, Amman, Jordan','c9O0zdFYRpiJ1lQzf-D6zj:APA91bFydJSHwOQjWPRkyoqmRh8IDroAa44Ze0nERxEHuoP590koUXkVLSLfh4_FTS6fhn7B38MeLgPmJsPbetvc3JXvsr_-J8Y8WT5sqi_mWqzSEy57n2aqRYGnZzqc9BZ9ue5x07S_',0,'Amman Governorate',31.942064,35.929126,'disabled',NULL,NULL),(394,'vendor','$2y$10$/vnvRTkYipCKFV7u65/SAO.duFr3uhPhn0l9KcRp8LQgpVPvCo9dm','778546748','vvv849231@gmail.com','سند','المناصير ','2024-03-21 07:33:52',NULL,'inactive',NULL,NULL,'منطقة مرج الحمام،، Amman, Jordan','cdEFhkNDQJuTq4VZZkjX9p:APA91bFlkWmh_-Km-DuwawSK3srurlqcTVhb_f7NfLz9JH1vrVz8D8g8-O97jFq6I8FBPIpBF7fVow6eneI59FUctilR1yWJztxWBtS3WASB2uxPYceYFXOY5wBbqzaEKuJcDN-rTZ48',5,'Amman Governorate',31.902977,35.848536,'enabled',NULL,NULL),(395,'vendor','$2y$10$7h/wD6zModhUEjUFxPfR5uUWiurvcg2dKQTT4.j6Xz4DfCXdTReTS','799464752','ma4687908@gmail.com','محمد','المناصير ','2024-03-21 07:35:27',NULL,'inactive',NULL,NULL,'منطقة مرج الحمام،، Amman, Jordan','ej1TiawtTIOKRnEbBezGW4:APA91bG_eVwpH4LBpiaLk7J2tGO_Ec6b3FVJJxmbfxa3vYRMCUl8L49-CRdzo5IQIegQcU1t6u2Wf6m6PcX6JHXRft2jmEu_ck0VEVYgqfmjINrs5FGlgl8ee8WmZxVCBr7zo3D6BQqS',5,'Amman Governorate',31.903016,35.848598,'enabled',NULL,NULL),(396,'vendor','$2y$10$W3BmSXqAcvZiDu1L9RAdgOmV9ykHvbRUWZP3NydGo0N.olIXbj8Fq','782369208','ah4322030@gmail.com','انس','ابو يحيى','2024-03-21 07:58:41',NULL,'active',62465,'2024-07-17 10:38:35','X2V3+WMX, Amman, Jordan','c_BB_CYVSAWk2LxB-T7XJy:APA91bHyl2OPusqlIBYKKHKMoD-8xvp7AThUTKVA5iIs3XftgKpF2abxCgihaHEAO0L71K3jCJ_lzsZLuqPYErn7agdvKoYdDmlhQUG_W9dMogB-q7e6QbktNDP-D8aYnCD9j3mzIsN4',5,'Amman Governorate',31.995051,36.004191,'enabled',NULL,NULL),(397,'vendor','$2y$10$LoC4Z8IwMarxoj0cs9tnFukqilK/wRkLzpl7G/WT55mOa4dokBEN6','772819008','giffjgh090@gmail.com','فارس','العبادي','2024-03-21 08:19:59',NULL,'active',NULL,NULL,'WRPQ+G89, Al-Khansaa St., Amman, Jordan','exZGxIotTrCfhN3NI4Myeq:APA91bHr7s1AN_pyDXjkXWpwjvEeeo-6xzeRR7cqlhskjFOP8ErX97CV2OX0wXMkzXbKU0CAAfaq29fSroYU42iqBKAgJe0_tjy-RoqxpwHqQEy11WZhkL77LOFw85IJdZ1bgsjejM8a',3,'Amman Governorate',31.936935,35.838060,'enabled','1.0.15','android'),(398,'vendor','$2y$10$0TMNNDzUN37dtY5FRBhBJOKJq.tZrWE22vWnDboPVyHytyYNg3oWG','776615039','gyuhbgfhjj@gmail.com','صالح','العفيشات','2024-03-21 08:34:10',NULL,'inactive',NULL,NULL,'RVMC+2PW, Amman, Jordan','dWWngT3nRZK7y5TU0bHP3O:APA91bEMVAIci_qepQPhoLekrRfAGt3HYVh-XJo5IADlSeJSTpISSyzqfO2LxRgLzmASVA-0ozBAcbVKsFh_1LEs7UEnoBpK_j2MFZaZZfpdODx7zA9-pkOIz7llZyNXy8_MNC7oP4o2',5,'Amman Governorate',31.832665,35.871737,'enabled',NULL,NULL),(399,'vendor','$2y$10$55slNhST./LxLW8keSHjk.e3/K1UTuIxfudCfa6ycJKST0LEBkFre','772081093','zayedalfalh3@gmail.com','زايد','الفالح','2024-03-21 08:45:09',NULL,'inactive',NULL,NULL,'منطقة ناعور،، Amman, Jordan','eCUzK03dRPSs5U0RbLmDgQ:APA91bEOP6U7um5MuJGXvAlyvAONYQ_ey-gq9eMgO072wQA2XJLd6vpj5ChQk1XsBwsnLxGeiU-8KbDXXwmmxWdRmwSm7Tvys9D6JZbwHOph-rWlK3Mr5x3zgwBJ04Nok3svQw4v7Hbb',5,'Amman Governorate',31.870460,35.819609,'enabled',NULL,NULL),(400,'vendor','$2y$10$PUJ7O4T06K/ys8wJmjY1Dumw4.7kI1qb/fTuB4k9qc2SjsHGWP5u.','796641600','rafatjamil1979@gmail.com','رافت','قنزوعه','2024-03-21 08:51:35',NULL,'active',95451,'2024-08-06 12:31:54','An-Nuzha St. 35, Amman, Jordan','d6qw_o-JT66ApCEG2EQbW3:APA91bGim2ly9OM_X7B6iwet_nvrZS-m_8yiuALNk86rVdmzFRM0LpZpx0q423kcUwom9LBJOGw4QOpZ88-9Z-iXdeK7K1G_lsyvDGmnPv5EuF1h6mxCK0Z8ld1XMoSpGNIIdk7A2KII',5,'Amman Governorate',31.976028,35.928949,'enabled','1.0.15','android'),(401,'vendor','$2y$10$EbtSNntHTLVRanJfYZu2SukBkZvcW3PvhgcA8Zfkck9AdEzklpQBS','796560515','hammzahammad46@gmail.com','حمزة','حماد','2024-03-21 09:22:58',NULL,'inactive',NULL,NULL,'VRJH+JFQ, Amman, Jordan','f9VfpUASRj6aqESKhw1rPr:APA91bFneO7e80u5ObSJK-bL867dQWuX0GqosE7vVH8Yjef8WIMvL0RRrTFKKtzqIOAAr14lfZtZcZkXD8Od6A3MISp-90pP4feBHp0ZlBXpUDHVbYda4H9lA90yktjnK8gSYGekFlZ-',5,'Amman Governorate',31.881521,35.828800,'enabled',NULL,NULL),(402,'vendor','$2y$10$EFmA1X1zxRs433zjwHU5l.aPQo5TI37H.jZW2vKsvBR.0lE6GwjSi','799278321','gazalwaleed96@gmail.com','وليد','العجارمة','2024-03-21 09:25:56',NULL,'active',23723,'2024-07-23 10:18:44','RVHH+MQH, Amman, Jordan','eonS9HbSRquVZw-7eX8L-Z:APA91bEwjwa_cjjNHiFk0b_Y-NZWUtJDuh3KsQo8Mm_tahC7MePfMrN974Ahm9WHtWA2PxFIKqh5E28wsg5_km-KnzOxkAlxjMC38nK6g73Va6eAHwtQ_vZda3V56lDLRpUz0qdtPj-s',5,'Amman Governorate',31.828377,35.879036,'enabled',NULL,NULL),(403,'vendor','$2y$10$Lx6OGMZVdTB8rB3obhkXeO/IoCUsCI1ebZIsvgB.YzNIbm.fhvmCu','799919906','harwnm671@gmail.com','محمد','هازرون','2024-03-21 09:31:16',NULL,'active',NULL,NULL,'Al-Shahid St. 395, Amman, Jordan','cgBzY2CNTVaEcde9kQI1d8:APA91bF-RJUpW3b7t6jm_kGGvJbiyK7m4Qv12gNIeJU0BLUG_FFkEhZncEpjGuzF3XQs0VpoDRI_IWRJ7pblo05DH-n7_zzSd1GdNIk_9F4nzrWRoV3D2hkWRD-CvptJj3CODnMd9U93',5,'Amman Governorate',31.987973,35.963655,'enabled','1.0.15','android'),(404,'vendor','$2y$10$t1DzIghFtevnEOpb3hAy7.f4qoPy.ZWIuiLkplIVnoFfuIV01Z7ly','779093465','ahamdhael@gmail.com','بكر','السواعير ','2024-03-21 09:35:03',NULL,'inactive',NULL,NULL,'RVJ6+5W Amman, Jordan','ekX9OGUORDC2bVyNMKtxg3:APA91bGf8cbJQmLo8BpVqbCqWbhEJQDejyOTcZUfkZFjqR1WYvp4eel22Q9k4GFyux157E9kcL6smC5Jk1XOx8r9tyGYg3uupNanpS8QxW7L9lIY6Ulw32CAJ56GYudIzU2K20QIl3KT',5,'Amman Governorate',31.830454,35.862285,'enabled','1.0.15','android'),(405,'vendor','$2y$10$8YATudaTUexZ9xXTn5G/quLwy4hbQwZuulKjj2OsqZ6BXJ3yfwxHu','772744679','abudakrashan@gmail.com','عبدالفتاح','الشيبي','2024-03-21 09:43:20',NULL,'active',NULL,NULL,'WV7C+J5F, Amman, Jordan','dt1WpbtYSFGDtjayqz3Ppw:APA91bEKAMCfxxzhF4sOB-JvKKlWtSJhKxHDUssBM6AWMPOEBmcPD6z_yRemAnAoACAKjamUzd6H8187Bdcd8LkM7X0swH4Pf4R7G2wKVMg3l2DeNuqqSolRo9wfO6vuU29r_KN9BPiP',5,'Amman Governorate',31.914562,35.870204,'enabled','1.0.15','android'),(406,'vendor','$2y$10$x50AWtM.jvABdzqp7OjMXOvWB9vCRf2sA4NsLWe3Wd69Wg3m07YTu','772803947','dhwgw5sgsfda@gmail.com','طارق','الشيبي','2024-03-21 09:52:07',NULL,'inactive',NULL,NULL,'RVMC+2PW, Amman, Jordan','ckyyOn69Scq3QiE3_vDgoW:APA91bHv3s_yICElj_E7c235nKU5DVYd997hVST-PeTM6n83pCPrTwj5zo-kA7KbfDZOAEizGdfLPGotZ0aw6w6c9j7hxFj-99jN1IKYGWh05FPUDmb3tZ4iJ7om1OOLBQYxA39DNLVs',5,'Amman Governorate',31.832705,35.871345,'enabled',NULL,NULL),(407,'vendor','$2y$10$/pxeIxAwT4nmdOUglK3BZednB1BSycE2mZBCDoxmkzvCiX1zcCNhO','775158966','zaidalmanasser971@yahoo.com','زيد','المناصير','2024-03-21 10:36:27',NULL,'active',NULL,NULL,'WR8J+P8X, Amman, Jordan','eHn-NldLQ1-lrDtCdOI0wp:APA91bHd7z-IUe8nhfOs4xocyKMs60LO8quTeLsfnXV4kMjP0IzK2jiAYNRYD0ZqXBsiA_PPN6pPU1CoTRy2of1vjTfIYiq4vaUMBjCN--hUI-K24xQXdnP3CsLkBKm2q8Qu3BCmmrdH',5,'Amman Governorate',31.917564,35.830751,'enabled','1.0.15','android'),(408,'vendor','$2y$10$bWlsZw5IW6MmifGqaAnBkOuHgQ.ZivF5.LKT2vBnjoGiYuQsW5aaG','795730372','almnasyrkhald959@gmail.com','خالد','الجماعين ','2024-03-21 11:00:07',NULL,'inactive',NULL,NULL,'WR4P+26X, Amman, Jordan','fB-EWJmbRQWU79-dudlFky:APA91bGpv6GwvhjZkRAJ-O3ZTMEwxWRgjw1fZBsRmppI7AVS7z9sleSkOE-j6otg1p7LxlHMKBsB4a51IvRUVHa6iAu_ZhIvalojdZz71i22POCTSfuhh0f-Kuher-e-upSJiwecdpDp',5,'Amman Governorate',31.904431,35.834932,'enabled','1.0.15','android'),(409,'vendor','$2y$10$XgW958a9jlT0x4mK3d7QDefy1Pf8K9e7BL346gNmRCOdUoye.FIha','779106188','hdhdjrjrujfjfjfjrjr@gmail.com','نادر','العبادي','2024-03-21 11:02:43',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','fjxdmy52Ql-yqFu2FmAwSN:APA91bEZG42HiRFYIdxoHBFkimdUFKGNYLmV-_TTSTq8chtz1HU6SHpeyQquCvcBUKPG0bhsT8yvYe6jbbgYDS8HAPsY3s3PHGpwUDMgKa1AbMyHlfxNoh9Dr2xCoipZ2B47nJw9IwcR',5,'Amman Governorate',31.904656,35.804331,'enabled',NULL,NULL),(410,'vendor','$2y$10$.x68QyBi0O5i3ntR73iE6eNDELrfjrWcnXyIiD75hcB.36nqBIpSa','795502714','almnasyrmajd313@gmail.com','ماجد','المناصير','2024-03-21 11:06:34',NULL,'inactive',NULL,NULL,'WR7P+J4W, Amman, Jordan','dvU7q7qNTm2YbA8Aa1pLli:APA91bElOc-CZYdgSXYVR4Z_mKJjT0YZIdil5rWgUp6qlMC8javqoAPdPA5mpbui1OeCW6MKRB1AHG9yVPyZNJ9FtcWueiiLVfJZK2aSKkcJaXxchIYrNfcQzPvYWPghWpKvNyK5iM9Y',5,'Amman Governorate',31.914036,35.835460,'enabled','1.0.15','android'),(411,'vendor','$2y$10$.o5b62kgZ1hQWzxtgowODu7IrlHqqBGWF.oEgPDf1rtNa/Ckhy2y2','796323248','saadhmood753@gmail.com','فالح','المناصير','2024-03-21 11:20:51',NULL,'inactive',NULL,NULL,'WR5Q+8F Amman, Jordan','dE2dkeLqQY6WpDugAKoqjp:APA91bEk20kDT4AFUgkNGWiVVl59rQrLAY0Jw4AzKzi8a-V9ChSBQT9N4270bOOW2tbuMi8_ByYMhnchcSz4bIL6XxhX_XD5zhHh1OFYm-ZnDfKv7_SwbjJXIPBJDiGBUX_o0LPbFurK',5,'Amman Governorate',31.908317,35.838732,'enabled','1.0.15','android'),(412,'vendor','$2y$10$hy0i86OgsCNuTsbOANbhHuNAgGWg7niU2olYjIFsu.OCc6VbqNRKe','772254154','poclm611@gmail.com','معاذ','المناصير','2024-03-21 11:27:54',NULL,'inactive',67327,'2024-03-22 20:02:47','WR8J+8XW, Amman, Jordan','cROqrswHSUOM4tA3UrsbPx:APA91bGYGghEI-h-ar_QyEtzCMyLO4VEPshJsw_7p1W9fGqv8q3N6Nto3Hxt5x-asW6uLH9IkW-5Lv__zYXith7OCBCCvWhA89yYMX53TId6L7CvxuVrBf7ntdGr2D1J0uFMUAu22t9y',5,'Amman Governorate',31.915737,35.832348,'enabled',NULL,NULL),(413,'vendor','$2y$10$dQdfEAcIQ/RGOSNrqjulrucyvCKpe039PvJZT1YtxMgJSAi/PvfZ.','776513161','almnasyrla70@gmail.com','علاء','المناصير','2024-03-21 11:39:58',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','deQx7iP0SnqqGXA04yEG2o:APA91bF70ik1YRUTEbpgT5PNu-7ls6JsiedcJkLMbc8kMiAUmzDWzr_hMJ2NqfdwXau4fUeumKLvAN2UOUkIAel_TUl56jvjM745P-0yOEJ5iNr4G2x_mn7lFhwZb6COjkZ_8yWWbUbx',5,'Amman Governorate',31.904860,35.804580,'enabled',NULL,NULL),(414,'vendor','$2y$10$U.5pN1PvACECXKGsxo9h3uPWt4wYg3BQ9HbGfXtxChXHlUZMl.o92','771044877','sahemalmanaseer85@gmail.com','سهم','المناصير','2024-03-21 11:48:11',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','cjkexEt_RJi70MHbsKCo0j:APA91bHMSepv2ln6HLkhqye371wcuZ6tzPvJj86LdsS8OvXGPlC8bqkc2yJegWY1cJtKgltvS5N-1V1qCzHyDkUCbzEw4lvdPsdrRs8RM23L3wPWZbSWvYEV4qZpUI1izQR6lhrkEeqD',5,'Amman Governorate',31.904862,35.804658,'enabled','1.0.15','android'),(415,'subAdmin','$2y$10$YeLupJprQ7810553yu/nVexZG5geolSZBgSrImgiy6HVBHYclpHye','797023732','Khaledghaith40@gmail.com','Khaled','Ghaith','2024-03-21 11:52:42',NULL,'active',92384,'2024-07-24 11:12:39',NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(416,'vendor','$2y$10$v1/XX867BQzMT3YD/fn1bO9xx8syJbPftMaDk3E0E.RuwWJZkVl2u','797355798','ahmaddryad950@gmail.com','زياض','الدراباني','2024-03-21 12:10:23',NULL,'active',64593,'2024-07-18 07:20:17','WXR3+W82, Amman, Jordan','eEpUD4_aSTaPpDTVXjkYRM:APA91bHh_zA922FOIYx4sN054Qg5W69hPnedZgAs7hVrRXpaGs-ifbsdXoGJZRBLIOBpep45pESL4809Fc0fOB5uJiBA_Dzl44c6E515im63238uuG-jfC85zwnLWqQ31T1UTXyLr9qX',5,'Amman Governorate',31.942518,35.953242,'enabled',NULL,NULL),(417,'customer','$2y$10$bcELG2eMGEQyqwcf6PkmeuS/.EDvqisFxvSDNmLhKGwhTK40xfhdK','797108850','nooralwahsh88@yahoo.com','noor','abd','2024-03-21 17:47:51',NULL,'inactive',NULL,NULL,'WV9Q+FQG, Amman, Jordan','cEhBv2-R6kCJt5Td45QCBH:APA91bGXPVmmZk5t9qYB-A64L-A3ISxTkHT1LabrorYnhePEXvDXUrHBmOXkR952DFEZbUL_slcLmkBRCJgyCNRqKnkQpnflFdpWlv2FjAxGdG1Pygvh40s0aNmi4JPeojxE7tstmL3J',NULL,'Amman Governorate',31.918850,35.889929,'enabled',NULL,NULL),(418,'customer','$2y$10$ljKZjHHXu04FKPbui21ABul7K3Z.ufW/zPpPwDUYI8Hc.W3bCJp06','781060194','mrad.mohammad@gmail.com','themd','md','2024-03-22 22:45:33',NULL,'inactive',NULL,NULL,'QVFX+387, Bar Elias, Lebanon','dJAf1uNwKUDJt-AgQYgyhF:APA91bFIIBXn7IOWq8gsESpWGBpSz2vXwCI53KrCDaxfZuPRQOgVFF75KyTw4D0UtLyF0bN5yzH0A5alLgKYIAP5nU2a9qU6CLOT6kn3PPWEGCcl7uye-n1EdNFKqj1XlzCUcwigiNkJ',NULL,'Beqaa Governorate',33.772484,35.898310,'enabled','1.0.13','android'),(419,'vendor','$2y$10$NZEYXsE3ldJFlbgeesnA9uG6nyzLZpi.xSvvEvnt0bJNmWbl6N8n6','790077712','ahmdkhyrallhabwsfyt03@gmail.com','احمد ','الشيخ ','2024-03-23 09:13:41',NULL,'inactive',NULL,NULL,'جبل الجوفة، Amman, WWVW+X28، عمّان، Jordan','f-scg2FyT4in-_SDL7Y7T_:APA91bEQzMnkXeb12FtyNBPzv3j-riYsJQfK_q0qCOkvx5K5MjR_1h0W0Efma-By45KUd36vRuWNnhY6ceBAFfw-_AhTzyFFw4A3QBf_2NXiU_J_NZhu5nw6wBLEiVdJckhOenYfS-4S',0,'محافظة العاصمة',31.944882,35.945048,'disabled',NULL,NULL),(420,'vendor','$2y$10$PmEAfVBpHvKNR/Y9HjYYfeT57Y15XGNTxN3HPkSlfw8Cj8gtanXCq','786849004','saadharoon2191990@gmail.com','Saad','Haroon','2024-03-23 15:01:57',NULL,'active',NULL,NULL,'22GG+C54, Russeifa, Jordan','dZVv7UyYS8C5wycCSbgr2e:APA91bGNb7dCpVsufGRWcHjIwFSrevOH70uxX__kk1alJDfIKEh9nA7Jt9_HgZ3WOksBn5pzvUiuV3c8xNRT1IydwBTaE-LPSmrlWInmUc1dS1YUEB53xCtp_MyYLatWACnMKjvMAOsT',5,'Zarqa Governorate',32.026520,36.025786,'enabled',NULL,NULL),(421,'vendor','$2y$10$1XWv/zJW7IEPB/IpfItXgOKcPSx0MOx/M8hCm1BkCelJYWh5q2c6C','772687255','ryhm158@gmil.com','حمزة ','العبابسه','2024-03-24 07:40:34',NULL,'inactive',NULL,NULL,'PQRX+J64, Madaba, Jordan','dV-67aVgSiuAR-qvO-C786:APA91bF8WrejII8Rw7dE2dGqqbdKfdKCfsgkxPsx7H8NcScFaLExdgoEAnd6LV7fn3k9xMuL6UMR_B8YDvHejLBH3GrxXuPURNmfsXEn8cvTi-uENX6NMJoxuLzsKbb1BgKSapDFD4CJ',0,'Madaba Governorate',31.741085,35.798260,'enabled',NULL,NULL),(422,'vendor','$2y$10$rvoUXOKoTaELHgvkLuPfne9zmzGrVCLm9vCiIXwb/rlS6sSH8D3JK','776124134','wasemalazaeda@gmail.com','WASEEM KHALDOON ABDO','ALTEEN','2024-03-24 07:43:07',NULL,'active',NULL,NULL,'Abdul Malik Ben Marwan St. 25, Madaba, Jordan','dO11kkMiTGmJHnfmb2QItK:APA91bEwgCGXMY6WwODqgYzwUnMR23pE7bApByMOCLaWFWapWcS-lEd72yunzVDIrOoxArLqXJRWcv_aBXYgF1NFRT2HVnRpJ3p6kJ7SxsTEpHAV-K28odoxTYf04OmMynqGNRXk-0Aa',0,'Madaba Governorate',31.716887,35.785336,'enabled',NULL,NULL),(423,'vendor','$2y$10$LxHIPOFEPOW04HJ./mL8DOe8BE.cGwXuLk/tzlShcDUwdF73XYUu2','790853259','tmrysalm@gmail.com','سالم','ابراهيم ','2024-03-24 08:13:42',NULL,'inactive',NULL,NULL,'Ahmad As-Sukhni St. 12, Amman, Jordan','cmALp211RoKYiKU7PQnqkZ:APA91bFqHkhsHtXP2a-e0q0m4i5wwpOb4on6As2jN3plB4fpZnJt09icGgcxU4x48Ybg-RK73ucbK8AM_q4xMIMB8LUPh4DnjryeAWtafM5AJU336eOwvh1Mv45dN2yvITDU0bXLK91A',5,'Amman Governorate',31.959226,35.870392,'enabled',NULL,NULL),(424,'vendor','$2y$10$vyiXb9IdrrsBKvvuy2OlU.x3zvFapaH5Eo8cb1K2ZfE83rc.622ba','785475929','fgvfnnnj@gmail.com','فراس','ابو زيد ','2024-03-24 09:23:43',NULL,'inactive',NULL,NULL,'3R9R+7J Ein Al-Basha, Jordan','ceRzsil4RH2f-o7rHVDwE-:APA91bEZYYVZSTg75G6qPiTg9_gNDnPpwhbx-TGSnciPMM3FfDYiWjS84FHxSiYe-orbu7V_lMfZBdkRhlf_baERIK0Bu126GkpfJw-soeQqXs_IpJ-X5Z3IPMXBJ0WtpSsZmRYo8Hcp',5,'Balqa Governorate',32.068149,35.841575,'enabled','1.0.15','android'),(425,'vendor','$2y$10$GIKWHooQLYWcN5tiVK6UHO2eVrExXW.bP0Dcts2fPTKCJ..0bHXGa','786095938','sklyb1058@gmail.com','صابر','عبدالرحيم','2024-03-24 09:37:34',NULL,'active',NULL,NULL,'2RCV+X75, Amman, Jordan','dKGeGuquQAyFTod-5cT0p3:APA91bH1bUpyOf6sNbe_ZpS9bbCxGKS_rxG9CwMRdA-i-2cvoIy89ZKRS6891gGNatmYA6W7HyOwbhXViMaRCxWcDaqTSuyCtvUqYGN5tNI7NS98zGia19JYyX4WownmPG-cTFMBFa3V',5,'Amman Governorate',32.016011,35.844084,'enabled',NULL,NULL),(426,'vendor','$2y$10$jA03vAP8XaBg/mhsiMLiVOsgxh2B4oLJXti294.Yq4hWv37oRg8b2','788894913','ffraj0587@gmail.com','احمد','فراج','2024-03-24 09:37:42',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','dj6aJxOqQZW-r_vNI2XdmV:APA91bG28AiRMH-qxaNsLImh--f7-pmSbUsLeDQknSTpNPQ4om_jkLBFISWiNKIA4VyHydCmOO5PMAhBflZcMbPkQGfBD3-OQlAlvuBlhhkKTTnSCpGM74Y80K2qSUyVqVP4Y6UQ04G4',5,'Balqa Governorate',32.064931,35.839231,'enabled',NULL,NULL),(427,'vendor','$2y$10$pwJnkPRUdy.NOGOC6V7HcOpU8n7JemxLKhz89UAkb4rtCYL5gMt2y','775354601','mrwanshawamrih9@gmail.com','مروان','السوامره','2024-03-24 09:42:08',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','dhod35QcS52LvivYQtR0qE:APA91bG5-WA6UXQjegMVOr1kNU5S0iqU-quHJC7RFAZtn7nyD8HWURBFHLwWATFxHHA4h1-El0WEkwH_9MnNeyLuSbCNeUmRNTg1yiErCq3aiAsnw6NDUgo-3nJkKQNvDNOo_UPwLrZd',5,'Balqa Governorate',32.064920,35.839219,'enabled',NULL,NULL),(428,'vendor','$2y$10$DZryv1CkI2ZHL4YpeHdMm.e/FkLIjcHgUkxkzDlgWivkeCkIiB4sa','795943022','maherhutie@hotmeil.com','ماهر','حويطي','2024-03-24 09:59:03',NULL,'active',NULL,NULL,'3329+98C، شارع علي بن أبي طالب، Az-Zarqa, Jordan','cyHatUQKTTyBuYFtPpXNEY:APA91bFSFGe9qE8KnB3qQ3fmvrW6UdiJWg87AVfanmLLVXzLapJksGVJl-t5iPnOhjbkFlMLj6_JO-p_FjsAMr2GdRfihqW6R9g8VgFblwB6tSrnARTJIV84tte0rY_z4uICGGwZwNF6',5,'Zarqa Governorate',32.050392,36.067342,'enabled','1.0.15','android'),(429,'vendor','$2y$10$3uMAslt1c2XwFI/vXnSUXOYNEoRdZeLV.YhvGH6F0334fP/r3hPVq','788279887','yhgh98@gmail.com','عمر','الحوراني','2024-03-24 10:32:12',NULL,'inactive',NULL,NULL,'3R8R+2V Ein Al-Basha, Jordan','dH-rl2v8Rj-r52xg2sNK-E:APA91bGpEJLv-y67qWwKR_uxsiBaY7SBjuYsBmN1jg0LOFLxvZzd9Uhmd6LQCinNiQAbvBu-cAt2VVojxVSYKd5m_NmXwbVdtykRwg5nS_qPmfssaEOprn6LydyY7PMmmdb6rJmCcM1i',5,'Balqa Governorate',32.065182,35.843139,'enabled','1.0.15','android'),(430,'vendor','$2y$10$1qLpgUGkfvKumePdyEjUte.GsUtiRLD9ojGM6PW7hX8qYhCZaqwNW','785161740','jfjf46970@gmail.com','محمد','سليم','2024-03-24 10:47:29',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','foNMEN55TL6LrB-L8SP_7s:APA91bGwLFjAiYHe6F7YXa6WSFDtlsMIbALVLNhUmtAnMwWq3Ij1pBQIDMkO72mNRiwI06416Ki2tJ99L8mSz8MyPYCD6JLW-MPR7xBrFr52euGEENOlvl6H5gtQKx3mImoE5FOeJrwi',5,'Balqa Governorate',32.064933,35.839249,'enabled',NULL,NULL),(431,'vendor','$2y$10$2ZV4MXoYE948jgRppUlzJerf4L4VmuRRqkVb5Ts6E6wF6MRs1iCYO','788865809','aloushi.h71@gmail.com','علي','ابو هنية','2024-03-24 11:03:31',NULL,'inactive',NULL,NULL,'3RCP+QQG, Al Hanou, Jordan','fmdwdBGcQgWaifRSs_riDr:APA91bFejFpGX4DypHL_G1CFzP07txvFmAlUG2BTMjys6xDjMrBUCViHncXfK2DJrWwhLsIw1FHSW7wGMhCuguVuSiymVR5RrJCH5LtGu6C5_gYqA_i8_lX_1sxfT_qFjC_AdzCTvK0m',5,'Balqa Governorate',32.071686,35.837313,'enabled',NULL,NULL),(432,'vendor','$2y$10$UALRRiA2JF9gEoXIUcQsU.e2noKR6RCOTWkNIMyYPRq7nHqZSxBsS','790322691','omarmram@gmail.com','عمر','خلف','2024-03-24 11:07:03',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','f-4Z6G2zTSS_uXzRtTX7f4:APA91bEX0UgKfE9h3c-Pivr_TfrWFrQAE5S6WPTp_dz46XweHxa0q2NcmKTGZzfzqx43K5kZR3BPX4Oh4FuLl5p0ZeOr2gKtHEV16XOoJe0UCBZZlwPcSzOmWV0QUGWWvbmQYUz2UqFI',5,'Balqa Governorate',32.064947,35.839216,'enabled',NULL,NULL),(433,'vendor','$2y$10$8y9iJIKUBBfAhF03NgHzGOz.XVv2HO1cHjbwbTiGif.sR3UZqcUPO','791814356','fadiwadi@Alkateb.com','فادي','الخطيب','2024-03-24 11:12:46',NULL,'inactive',58830,'2024-03-24 19:45:07','3R7Q+RH عين الباشا،، Jordan','etY0eLfoT9S4gUywAaS1E9:APA91bHEJbvZbcZ2qcwMRJIVyPoGHDMCNK1V7JYplEjpU1UQEiFiU9sZIP14jXHtXKEt0gJh5dOXssC1pqLXe6VcKxgde7Xwz-ta1eqTiuqiMEFbXcX7Bs4Uyj0OzI9oOAMoXycnw2Rq',5,'Balqa Governorate',32.064806,35.839011,'enabled',NULL,NULL),(434,'vendor','$2y$10$4WHZUW7My2/phgJquddzv.yGJ7satVdIh00CEVJDmslDUfYrbCxAq','789423888','samemamr57@gmail.com','سامر','معمر','2024-03-24 11:31:22',NULL,'inactive',NULL,NULL,'3R8R+VQ Ein Al-Basha, Jordan','ctFgNzyXQ82UnY9HHMKOCt:APA91bF5XghGJZUUbY-ghVJEXOq0cgMUrQ32sZy_cEArM-nq3eAFXtVZfbkvDTvjLCCzObr_46ruhkthtiQQqI__ez96-v8IhVbVEsEKLj00EYsGezDPnSVaOJuSV5j5Egp6JXGkid2w',5,'Balqa Governorate',32.067226,35.841900,'enabled',NULL,NULL),(435,'vendor','$2y$10$4Zg8F57b7LvG6BYke7wQWulInld6L2U6Nl1RoDGmcduvIlyCJXCoq','788055238','esammter581@gmail.com','عصام','ابو مطير','2024-03-24 11:32:00',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','cxUTfOmHQ_a24wT_MECfJY:APA91bG3PpJAunxNmy8jU78r45BarR6xOXpZPJfvC_dIUCnMpGDoeNI6BKU2CxDVG_xPmxRJlhybd3xyX4JKR587ONrhIElOBF3gN4TeJ3ZSboKKyBKr7_cy208J4cLINtuALJ7zI6Md',5,'Balqa Governorate',32.064779,35.839192,'enabled',NULL,NULL),(436,'vendor','$2y$10$xaA94aQFczK6vU656nOjMubWRRk1rtdNEvSPJU4OaLSOZlnSaDsbC','790213130','mahmmad123y@gmail.com','محمود','السيد احمد','2024-03-24 11:41:31',NULL,'inactive',NULL,NULL,'3RCV+RQ Al Hanou, Jordan','eeZ5Nd-eThahN0NwExgEik:APA91bEI9VGJ4RTYIDuqsekkaA6OiL4QZgEKbJsG6gG2ksq6UYLs9rhy8khVuwaS9s4ya48UqJKR3p7LbpeTwrJ3II6_I3K3h6YCnS1uahbS7Y_lxhO5IpfbMSSlobxgaYteNIlrxtOd',5,'Balqa Governorate',32.072083,35.844377,'enabled',NULL,NULL),(437,'vendor','$2y$10$GXLL8j2kd8Nc2a6YhZqdvOyzkdtfRXTTlypBAUQD0itwcjkJzSnoW','798100141','shadyalhwrany0@gmail.com','شادي','الحوراني','2024-03-24 11:41:58',NULL,'inactive',NULL,NULL,'3RCM+656, Ein Al-Basha, Jordan','dWVKbLacS1C3G4TWUI3194:APA91bG4G6yn1J1AC6MYTy_fO4VMD1h-a-NcqcyoNcpbzYfkyfLF1QMryCJrf_7qqBLQ27fbVwtrNGnhVlKKv00gAmFasK_2lH2Nl-qDMHF1ULUEDoviNr5So0dW5yzIJRt8uhkgrTJL',5,'Balqa Governorate',32.070801,35.833449,'enabled',NULL,NULL),(438,'vendor','$2y$10$QaZ6/KpcrQ30URtuGb3xAOwSUWISm6hBvz.d/wSCDuvsegZ8oVf4.','781175710','mohammedalazea38@gmail.com','محمد','العزه','2024-03-24 11:58:44',NULL,'active',NULL,NULL,'3R57+7C3, Ein Al-Basha, Jordan','eRySfjnfQEiL24zCeFsAZM:APA91bE45VYvj7BfXPfJi4Ap04E9q8frW-rQ8RwtDf-s1DuvT0rtQvxVheEPLIJk53FwC98Jmf0acQVQh6ciBLxy732EvtK2Cpv6UMkAqo3Ot_9vyxul_pqG9FRiM3GDEP2MWUt2r1GQ',5,'Balqa Governorate',32.063905,35.838895,'enabled',NULL,NULL),(439,'vendor','$2y$10$uN5JjhmbBWJ7gzthXySnAOErdP6a5B/BXdOxzU46X.gy46PtGkbsW','788481505','farsaljarmt28@gmail.com','فارس','العجارمة','2024-03-24 11:58:53',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','fgE5UPSmRG2LmnsWG6BsVM:APA91bG_0J-YYzxLr9iIDv17dtjcePP_RRmu8aEPKYLtuB1OsxqGuYdiYQcMDL4z8X4tcAwhv7I-tCZN0avx8HZkl70k6tpuOrYqHj20F9vOAYEk-qgmtI1qNBx5ERTDYK4ZCyDLimva',5,'Balqa Governorate',32.055252,35.834420,'enabled','1.0.15','android'),(440,'customer','$2y$10$LBT7HjR8IlFQvLzjCC.NfuHmTYSgvAgG0GMpvf4KohrL5Xi8DGLwK','795201319','wael.ghareeb@bluefig.com','wael','ghareeb','2024-03-24 12:40:32',NULL,'inactive',NULL,NULL,'Irbid St 30, Amman, Jordan','ewUUN3joC0CzqELKcV03PM:APA91bE7oSa8WLo1QyHY89s9yIMTZN501QdQTQwRcNHKBCodY80wmOicrzsTA2kJ4xt3Q1PjVZZpCSnfQuteeNxGObjhwvOHwp6h54toFiT74I8KZSvv6hkv0ufEpgslxaJlksUW9ybw',NULL,'Amman Governorate',31.941677,35.889681,'enabled','1.0.10',NULL),(441,'customer','$2y$10$LQ7C.4MFOFUwOWehi90UqObWpQpDcLvdi8UYcw6owp9wCUjax7buC','770311333','saassa60@gmail.com','alaa','harahsha','2024-03-24 12:47:02',NULL,'inactive',NULL,NULL,'2X2J+JMJ, Amman, Jordan','dbN3Svf_R7SW_sogtysxb2:APA91bHwrQ2euh52T2OdvFr0nRzOl7lsvepVf1F9yCqUHr0kRcOYRH0ZYLgsuDg7Yz579tx8Co1fqmY0ERKmqKJ4Q9OuUQlZiL9N2slOR9Pa7UbiYgeH17gy9CornUg33xQ3D9Vf560-',NULL,'Amman Governorate',32.001521,35.981655,'enabled','1.0.13','android'),(442,'customer','$2y$10$QR5oN6c2PShT0sRRbJalZe3xFfYHa.B8LjA6s/a0Q8ZQrzEYqQ6bq','796347341','lordalwain@yahoo.com','محمد','عرجاني','2024-03-24 15:08:07',NULL,'inactive',NULL,NULL,'GVMV+CQ4, GVMW+47J،, حوارة،،, Jordan','cTqRCEVoS-KOn61DthzJXX:APA91bG92I33IsToh_X2Mfd2kIyTZiqau18ILLmMcTc-my1rB0fsRAoWdvqjT8DXq0Dq3TrDzy5jzTLS-q23TI_O7jDWinCRf5RT3Fn5tUhvyeKQz9q9lnF3mk13y-TURcUqzdpeVRzD',NULL,'Irbid Governorate',32.533494,35.894262,'enabled',NULL,NULL),(443,'customer','$2y$10$BsqtjxV/9HutAHC6bRQY3.t7NpvDivQCnH7AJYKzkQ.rPOfbwibra','777628826','ljk40@yahoo.com','ابراهيم','المعايطه','2024-03-24 17:00:04',NULL,'inactive',NULL,NULL,'2X43+X67, Nuaman Al-Alousi St., Amman, Jordan','cAPDRUX4SAmfC4yiDkv0am:APA91bH35I1XRgWStATFLw-PFeHY-AQBynDoPv7_CldoFxBdYWf3czGatsCaiETBlZ1F7idSE-nQqNjdsJ9RNRpLhqVoM0k9GR7WcpgxuwscvMUbyxh-k30FSCAf6p-lL_OxnZTWjPEW',NULL,'Amman Governorate',32.007652,35.952542,'enabled',NULL,NULL),(444,'customer','$2y$10$BeUAIS7BQbQ0bdwkNF6uVeuhFu7TqBYEw7epVbY7GfSx6XyeAjJM.','799952629','rereawad1990@icloud.com','رهام','عوض','2024-03-24 18:58:19',NULL,'inactive',NULL,NULL,'Madaba Hwy 11, Amman, Jordan','fGZEbjd1QU64tz03E9rI4U:APA91bHaMT5zlQH0pjTVdy6C6tDABB-0xxg8Jq1_gfbsdtpdtETMKw_VuH3VulWTtEEpSqJrHm60dcfxEmukpfmtK85zVR0mzVD1wAc-7EvUay6SmOuBvVPgfLAGquaFwqEbEkdMk2Fc',NULL,'Amman Governorate',31.874200,35.938227,'enabled','1.0.13','ios'),(445,'customer','$2y$10$ZJYmY42.CnUWzO9VMJdefubLPbt5k7OI84DX9EpNkA6zhPT4Zjzti','797705839','albertareq@gmail.com','Tareq','alburairi','2024-03-24 19:06:34',NULL,'inactive',NULL,NULL,'WW4X+H6H, Amman, Jordan','cjW2I1heQn6S8yDsjMauqd:APA91bEG8jOK8owazjumH2sV1LxgP1OtItuwP4LA_66mewMAA2I9zUiXrWfgfclMCCEl_EdVRABsRheO4TDgIuv9zbdDHF-GXP79UQMiXjNf9NyQGIq5agfSRPBzGa2na4hAaihwlyyy',NULL,'Amman Governorate',31.906250,35.947991,'enabled','1.0.13','android'),(446,'customer','$2y$10$e7WjfDhc7gom3gq8KoHJoOhD6pTDlalWsiqEk7tKMqXwQksW/aSUm','798427486','asraaomary22@gmail.com','تامر','الفضلي ','2024-03-24 19:40:59',NULL,'inactive',NULL,NULL,'XV3R+V3V, Bou Madyan St., Amman, Jordan','f1HfPcNbR_qlt-8lICZCoL:APA91bEKoeILoYRZdGbrh6SpaGPdh2mJjknwAuEWkCxSlS71deFKWon1kPpSVc5vGxFeLUvAhxXI-XqyuK-6MFm-gZ6O0G8ygWzYOHBJq81CTYAqHwkoXFXTHyn8wXYMhzPXTX-qlYxR',NULL,'Amman Governorate',31.954887,35.890120,'enabled',NULL,NULL),(447,'vendor','$2y$10$iAi7KJzEbAVI/KLjqEYhF.zmogGoF0TiW/6THFSKEyVeVBSARF.z6','790969360','Omwe.alsarafndi@gmail.com','عمر','الصرفندي','2024-03-24 22:39:22',NULL,'inactive',17564,'2024-03-24 22:40:53','22C9+75H, Russeifa, Jordan','dTX5y11ETGOQByZZTHIevT:APA91bHR-rSjOBW9PpdpMQYM5yJ8G6c2u2AAcQLe-aXVvTpAvzu74CbJ5iEO_GbJwUQuZEItVQlFqNnERDilC4iTZAYyL8K29Nct4Wxhm3Vok_EfHjVeNYX1gTdcwv1WI4Z3d2UT9DcI',0,'Zarqa Governorate',32.020571,36.017913,'enabled',NULL,NULL),(448,'customer','$2y$10$2vSf0GWtJbEtwP4jq/6b1eavYPnRl61Pnt1vhZaTakvkkJWFNAi7q','779699002','abdff','Abd','F','2024-03-25 03:34:53',NULL,'inactive',NULL,NULL,'2PPM+59W, Q. Rania St., As-Salt, Jordan','cX9wNrdXS0suhMRqcqAnkI:APA91bHknhmqzYhxhivEL2v2MIzmFeRxhfO9C7Ey6vwVANnsteEKAednWEMO7Ajo56sjzauV4c-GXwKq29ncbJh59JNsl5CdFbiVcB6ocgpb_WQA_num86tzHavv5ZY8KAKoc6eUjv83',NULL,'Balqa Governorate',32.035208,35.733290,'disabled',NULL,NULL),(449,'vendor','$2y$10$/uaBjYsWBS2AGRjFFsvXVeKZwKqDSzjdvdd9ibIPraYXfpLZ3F8/C','780416858','0695519827aslan@gmail.com','محمد','اصلان','2024-03-25 07:48:38',NULL,'inactive',NULL,NULL,'Pr. Hussein St. 68, Amman, Jordan','cJpoUbSXR7i3x3aRmr4tOl:APA91bFRqBGkBv5Xai5U_jne8E5BaQNGtf_7uHeKM3_ozcvpfZ0Dme6Mdsdqfhn_WYvMOSw-vKkSlvqU3_ORQsdweuPFikpCyH99MPuLXmx0vsxHRRniJ4XXxdmrea9r95UVif4JT4Ni',0,'Amman Governorate',32.003470,35.934647,'enabled',NULL,NULL),(450,'vendor','$2y$10$tUB89E0upgsA5IICzsNBZueNRE5ub6maL0384kRPBGhQlDsnYiHCO','776524787','hdgyf.hfg@gmail.com','سعيد','دعيس','2024-03-25 08:00:11',NULL,'inactive',NULL,NULL,'2W2R+V25, Amman, Jordan','fpcg8HArQvOBuClilPZb7T:APA91bGQGo7EG1umdNmsEa46wL_8jsCsBGgEG2xcWjDVcXTLUfWv_ZH_hle15JqhkY4r3XX2L7YYz_SwnWVN8P8coGMNAhAaC8mwUjboUW5hFppeDc7zFVdhgJsiozl1jApPt7GZ6XV5',0,'Amman Governorate',32.002251,35.939184,'enabled',NULL,NULL),(451,'vendor','$2y$10$/Hvq57bIE4A1mcceMmo01.MFp9QjLU5rOoM4RG0EUdtRPXjc/4XZe','799809196','alaa1324hammad@gmail.com','علاء','حماد','2024-03-25 08:19:33',NULL,'active',NULL,NULL,'2X3R+CW4, An-Nahdah St., Amman, Jordan','fLJAB8gSTqe73ngHOQIiNj:APA91bEhcRgAoD1UnXkQzYtnTlgda4BlA9tRVOAB3h0_1hQbcINiMV3D0IMexbsVe1_dml0tKFpWbeEeRGdyY2aHSoPDOVAd1N2YP4A3QLZyd7xTVtTE-OV16mZO8GRAHCAwWSzf2TpY',0,'Amman Governorate',32.003630,35.992278,'enabled','1.0.15','android'),(452,'vendor','$2y$10$Frarfz8AQ5u8p1wQeLjJTOk6vFISGn89mm.5Xur0KfauTApmSA8FO','797155152','raed5local2002@gmail.com','محمد','فيصل','2024-03-25 08:45:53',NULL,'inactive',NULL,NULL,'Prs. Aishah St. 11947, Amman, Jordan','eBFxf6pzRUSbtZWQ9lvVFn:APA91bFXnRC0uGUV1xLdeQ7TjzjGfQlEur8p0DYQ-NjGNp_jdKLXD9429HZqsAXYelLDfXq0LlDPIXCARBD4Ge7RtWQ0lqPbzFAjEC6PXuHiruWM2fWZ_7gFU1DRyz7qvZZEKM6jBCiW',0,'Amman Governorate',31.990902,35.943586,'enabled',NULL,NULL),(453,'vendor','$2y$10$aKCyOL0l11ZlSvOxXx7fsevj4TpRGZ.UqQtsi/VE/mVgtL3AaVV.C','779648788','bdalghfar423@gmail.com','ابراهيم','محمود','2024-03-25 08:48:09',NULL,'inactive',NULL,NULL,'Prs. Aishah St. 11،, Amman, Jordan','dJ8bT0qwQBi6PS0PCe58Kg:APA91bFQDEzHR6e1XP__fmONZuKjT7UEYZM94s0JBEjT4Zb2Ojs5kmNpXkbvx8lST-8-WLwxRBy2nYBWGRr3y7gs0WI-G5JrJFmbefg2uxQ5nBJH3_7nAcGu_w-4TdBibL4cWqJ1ZbLY',0,'Amman Governorate',31.990901,35.943579,'enabled',NULL,NULL),(454,'vendor','$2y$10$AcAHyYMSFly5L2TrDHV49OKWoZKmt22hmMMyOmIvZr67X1FARlhFi','797604668','alabadikhalid247@gmail.com','خالد','العبادي','2024-03-25 09:14:51',NULL,'inactive',NULL,NULL,'Omar Al-Fakehani St. 6, Amman, Jordan','faoZc3LtQYK06SuE97BpH2:APA91bHoXhWaIhg-uICxcwyv-UnwRhupRhIFdDGahWQVrRCATF8MH6YmRFtNUC07O5jD15kmmF7MxmNJXpuT49VfJvkiwHKCfzcRWmTC0EAJvDz6DQyNAvAobhmHOXSW9Mx4-UfKODDG',0,'Amman Governorate',31.998196,35.943934,'enabled',NULL,NULL),(455,'vendor','$2y$10$roWnJFLcYdqm1NPCjvve.OJuY29buhTfC88Fp2yocTnbJ97cIZliG','797347133','hamoudehalsalhi@gmail.com','محمد','الصالحي ','2024-03-25 09:30:15',NULL,'active',NULL,NULL,'Al-Bathaa St. 97, Amman, Jordan','fTmRBf87TPSeWMEjzeLYrW:APA91bExmpMVq-djUv7dVNIvMrnRDG9hYN6J6W37FRFyLonezA3hqZvacd02MDj-Ft-cJEOR-CtRvyrkXbHGVF05DQpvBUHQH842ySqAfTjcxDDB361qQcPmENV6YtdaOAPJQTZZP-9I',0,'Amman Governorate',31.976241,35.951119,'enabled',NULL,NULL),(456,'vendor','$2y$10$ESw5v4qgR/vr1q/axgYWHOs5kabnjknETWjFmeIAZXE4iRGfmjh0y','781651125','dyalhsamyh@gmail.com','عدي','العبادي','2024-03-25 09:37:35',NULL,'inactive',NULL,NULL,'2W2W+XFM، ش. اليمامة،، عمّان،،، عمّان،، Amman, Jordan','fw074l8aShWhQpWjGikPec:APA91bHuIEBGzYMMCOrcqwF8xeGaKLg6kOQY9-X32N277FFIOqoIRaIh_yl2tSZelvDHiJfyhEJd44uu8Ww5qcB0ERs_Gewwy2IO9_wqbbtet1IF1Ha7TzFR1ASWNdNUPIUACXXyx2mm',0,'Amman Governorate',32.002611,35.945849,'enabled',NULL,NULL),(457,'vendor','$2y$10$5rcjqhz23IBw25bKexhAxOfJ836Q2RRiCk63ti4Ur27bzZskZNtke','795143628','alshbhwd877@gmail.com','عبدالقادر','الدريدي','2024-03-25 09:57:10',NULL,'active',NULL,NULL,'ش. نايف الفيشان، عمّان،، 2X32+MV4، عمّان،، Amman, Jordan','ez6ueLVEScaq1B3_PGjMWZ:APA91bE2fsxkQKlEy-I7bC1BActGYH6QC1Vd2rqjjiz4LfI5MmZvfG9ja8D4sNIdutyvpoHJ4WUXNElWt6lYdUER2EKIkkDNpHN8YYLeuAR9Cz6xMNNNSM8hwC8pz4leFa_kAjJ9g801',0,'Amman Governorate',32.004650,35.951492,'enabled','1.0.15','android'),(458,'vendor','$2y$10$GMC1OTFCjG.GZpVqsghQCeQXWxTLsisypngWeQ18ktdTCDTxItHVq','798630805','mousabaltaj83@gmail.com','مصعب','التاج ','2024-03-25 10:16:46',NULL,'active',NULL,NULL,'XWHV+Q38, Umm Hakim St., Amman, Jordan','eQNfaJFJTyusDf7_4tumEy:APA91bFQcFe6bVBXkUw9xbdpHVuLI8bzC7pN2kd38zVVXlq9hEkP0N9GinLVJiF2TvRiB6_W6px_pCRaegJVctg1mS534mQXXyL92KNvSaP-w0KnR-x-LZkSDeZ_j8CaLAEWoZECg2FV',0,'Amman Governorate',31.978765,35.943560,'enabled',NULL,NULL),(459,'vendor','$2y$10$WOXHKvYzmSo20KuO3ulijeZmPsGNSrYmciAYUJHebBPvef1zu7.5O','790070946','seleneom197@gmail.com','اسعد','السيناوي','2024-03-25 10:22:16',NULL,'active',NULL,NULL,'2W7R+P5F, Amman, Jordan','dIdRAvOCQXWVbjO0GsfJnn:APA91bHq_8NBArYwD2FWC2vSJ70DlB2bdnRKT5HnOIUdt2ZAeLjSlk97U557YVHC_YW-JXqqg1_vJ2S1qEq2X1oDqIbXAJA6kOSjZRzq07CMpJEctPPKySCDljTpqQLQDJkmMoDVHpWY',0,'Amman Governorate',32.015577,35.942967,'enabled','1.0.15','android'),(460,'vendor','$2y$10$wgE6saqZ9SspjV4.HACjneViZWcNE8NW/0iCCbqi3Vs5lpNAe.I4i','799294816','ahmad.aq2023@gmail.com','سيف','تلعقرباوي','2024-03-25 10:43:33',NULL,'active',NULL,NULL,'Tabarbour St. 52, Amman, Jordan','d9hS1fRkQ6-UgagkBWUirO:APA91bGbwZl-hhtK72VB-ve44aS1tDM-QoRl_b5NbEp4Te-1eIU7A3jgR5NO74ocH3CYI01CvXzpLZ_RNWztjLZIeV4zsDtCcWMpGMQ61IaKrCPGAJfq_cBtDiwCvwn90koc1imOuigp',0,'Amman Governorate',32.004379,35.950468,'enabled','1.0.15','android'),(461,'customer','$2y$10$4H.zPx8wbjOtfv.LmbE97uvLHVcJOmbTnZI1E/QXkmXZqXAjWCthm','791223201','shadarola571@gmail.com','رولا','حداد','2024-03-25 10:57:03',NULL,'inactive',NULL,NULL,'VVQ3+48V, Prs Taghreed Mohammad St, Amman, Jordan','ccFB68lBRGuJp3t7qFJXrJ:APA91bGPnyUv6s32gMAm2bJ2-aHhIB_KUdfbZnBDd2hzbdbGqMyEgopRFMdVNtSAH5z02EVqOOZaKXMe3KQlpNTg2MSn5TcJQKjl2XqRLzpekZtgxGRw1ICwnGopqISTj6p3RwcnY_5m',NULL,'Amman Governorate',31.888565,35.853453,'enabled',NULL,NULL),(462,'vendor','$2y$10$oGEXMLL5qbaC3S8O9j5KpeQcVhhVLsPEBUdLCgwvdtFKxEILIB.P2','777112984','mohammadaljarrah310@gmail.com','محمد','الجراح','2024-03-25 11:11:51',NULL,'inactive',NULL,NULL,'ش. طبربور،، عمّان،، 2W3X+FVH، عمّان،، Amman, Jordan','cZz2hINeSoq6XsGLoUWXbT:APA91bFTBybw6FZz5mcMlO6uwxlWXp_yQPkXPPeWkdvO-iyY9tG8e2uZL6t0GY27YmeekxBO807E8-9YJCQodP6Er5W-Dq5sOzYJc9LoBE6qhasUzgsY1C1uKAjs7q2XlhixILRop9MN',0,'Amman Governorate',32.003652,35.949635,'enabled',NULL,NULL),(463,'vendor','$2y$10$6n/AgVI5PXALJfFN4p20GuNkYkqWlS/miKY5PJEvE7.m5HFEOrKPu','795545937','m63877605@gmail.com','رشيد','فارس ','2024-03-25 11:18:35',NULL,'inactive',NULL,NULL,'XXF3+CM9, Ibrahim Ben Al-Mahdi St., Amman, Jordan','eZHzkonxQBCPIXPZAUNqnD:APA91bEsuR0kXrIE9o2g3IyAhFdNP_x8dvNlLWhw8wX_gD9NTVgRBOjadm4TgmEpIrnT4C2He7JyKn5d1mnMwtX0DL8x67TUTutbNUVYS3vXAC4ji4sCmgGaEKjIdYDFD0ux_KH7IPN0',0,'Amman Governorate',31.973003,35.954221,'enabled',NULL,NULL),(464,'vendor','$2y$10$ygo/jQJvHoiTMfCEiVjatejPoSWOLAtPgCbD/XzibjQ461OWOZ/3a','795000610','mohanadsodah773@gmail.com','مهند','سوداح','2024-03-25 11:29:21',NULL,'inactive',NULL,NULL,'طبربور-ابوعليا- بداية, ش. النهضة، عمّان، Jordan','f75hYmZ3RaaBqt9lJMriCc:APA91bGh60GVsrXDsUud-mgNdx2rFbn-pJlMjP0eICfw7DNb5NCPHwxDpMkf3oQVb_yjw_np95ZBQACC6NEaVLAaPvPlj9rn18PuDC-MRziEAOMmuyL4v3PdyUOg6iBJ8Z6WnPrBMY_S',0,'محافظة العاصمة',32.000264,35.953903,'enabled',NULL,NULL),(465,'customer','$2y$10$FaeFZcEp3UHhgFnggWo6oOcCF86QMPp6WK0sYz3JUj0XKhigLujN.','781125140','ramiawad626@gmail.com','rami','awad','2024-03-25 21:27:21',NULL,'inactive',NULL,NULL,'VWQ2+W7J, At-Tahrir St., Amman, Jordan','eP9UQ-o1QdSSLPw8xlPSEu:APA91bFdAr2eXHUV2QCIVHMyaFMJP9IMSvsF872UBmQxHdIaXfAtniaKhrsxaAvRLbBE2mItcQTr44CteeVWdIYg9J1vagOx3pRhiUV2LtyOVUpQGkqx6mfWcQFHE74vpjTxAhG0Iq0Z',NULL,'Amman Governorate',31.890198,35.901163,'enabled','1.0.10',NULL),(466,'customer','$2y$10$oTFAu3qh0rLGp8NZUlkSYu50oYSDTVl9HG77.B3OonUOuE9LCJNk.','797782054','Hamodehawad2006@gmail.com','محمود ','عِوَض ','2024-03-25 21:35:45',NULL,'inactive',NULL,NULL,'VWQ2+W7J, At-Tahrir St., Amman, Jordan','dfX2lGeaHUw6iPJXhgqw1W:APA91bGzPiVyTZQEyLIzCuL7zmdkGZ5pxnGuK00qxMAgKRIU6HvwediU7JA-fHN9f-vWUyiMScXTBUavtWi3AhGT04LyKjcYN7FSHDBQWzC3O-vi5stHSccKs7rIgBPtYE8AvbGzWGvQ',NULL,'Amman Governorate',31.890182,35.901355,'enabled',NULL,NULL),(467,'subAdmin','$2y$10$DrL/oy.jxsn7UpN8x0FsZuDHjQ3gX0HbSI/64vPCWX7cPMoEXz6t6','782303071','recption.pickum@outlook.com','Baraa','reception','2024-03-26 08:53:00',NULL,'active',52859,'2024-10-13 20:24:25',NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(468,'vendor','$2y$10$3HyWFlVsITz4u3yGIbz88e2aBKbMXkKZcoJ3hOccBU1HhNzl94KI2','799361455','shokatmohamd06@gmail.com','محمد','شوكت','2024-03-26 09:41:14',NULL,'inactive',NULL,NULL,'WWVX+V4X, Amman, Jordan','cpA1sMx8QzS3aRgxw4h3cE:APA91bGqEDph0QisGlZ5KRVMGEjmYflluRs6xS2nbIig_XscEMlue2LygisTjWbc76PoIn7gHbC6WCFcN-hluE3Ls4iHksirR2DFH7uqEzXQijMPb2jNmINRnLuFwCQJjTVpGJn1upcc',0,'Amman Governorate',31.944651,35.947633,'enabled',NULL,NULL),(469,'vendor','$2y$10$b1X75YQ6lexYOkkqcAjvmOZvCvmAMtI4tQI9cgKPuraKDoOhXVIpW','795387210','nm717835@gmail.com','نور الدين ','عمار','2024-03-26 09:44:26',NULL,'inactive',NULL,NULL,'Al-Imam Al-Bukhari St. 11, Amman, Jordan','c6NwGLkxT3GRn3QZ9snrdD:APA91bFTXN8RdiOznxaFJTbsqCaDq96xyjeErQXEPn_3NrtxyeK5kAvWwsEfd4fATZEjoU5mMSQLGfk6pym3Iw-5ZaLR6wEUW3V0x8I7mKgham5bYrWoscDsNeyoTZpRbwG0BNUSY2FR',0,'Amman Governorate',31.944547,35.945724,'enabled',NULL,NULL),(470,'vendor','$2y$10$MaysmWuveXUG4O4k5egbu.MUhrUotJHkyu4VlFnJNTQpirZJ0wP2W','795894295','hameh.tamer5@gmail.com','حمزه','عبدالرأوف','2024-03-26 10:00:50',NULL,'inactive',NULL,NULL,'Al-Yarmouk St. 260, Amman, Jordan','eAguRHHpT2iSEui9dDskVl:APA91bH26nWFP5_yT3guvUcXGSg_-1Ag_iK5cAAkeUR1JtiYy_N3ML1gTngegg7_yuu6_1RSGLk4UBx-ykpa1WNQ_SRv_yDCfiIZ_NPCmi-jFTr0dMiEqb2E0usfCo0lIqeV0YKsMems',0,'Amman Governorate',31.937603,35.949277,'enabled',NULL,NULL),(471,'vendor','$2y$10$lh0246lXw6JXE4ggR4xdzOwsoH79jh/MWv4CrAZO6yGdCmK7Juu4C','791150967','ralswd65@gmail.com','رائد','السعود','2024-03-26 10:08:38',NULL,'inactive',NULL,NULL,'WXX2+7VR, Ibrahim Naji St., Amman, Jordan','fpCtLD7VRGS3pK5wSDslCC:APA91bG0GeMc2thFmWQANTiokRV4jdGvK53HmwDm4116QPvj0aSpdFWhE1Cfpk47xK53NAVFVqFwYfwEveMTrqkkM2NPlxhozOqj5iGgxDAQ3iDD08JEzSCTmBUvwRzhOq2JmQdMYTzS',0,'Amman Governorate',31.948254,35.952174,'enabled',NULL,NULL),(472,'vendor','$2y$10$1Mrb0XHSbXllyVpH2UPtE.eQGnqw4L99KzOKhcrbi9Ar5YhE6cV8u','797836931','ahmed_shawket@gmail.com','احمد ','شوكت','2024-03-26 10:12:42',NULL,'active',NULL,NULL,'WWVM+CV4, Amman, Jordan','cHPDT0YUT-iZP5HXjqukN4:APA91bETbCic0FRjYoKdSha3a3lPyt-NpcVaaN7zzDPDw3_hrWgp5BR_4UO_PZlJ5sDUuGr_giuAKFIOH7ffqsEXwHWMTrTTXe59P18hwAJzd64B0ksjPmyDrYf7zPAsfCGh0niPJNnk',0,'Amman Governorate',31.943977,35.935102,'enabled','1.0.15','android'),(473,'vendor','$2y$10$hhuRbVqkoLtijh2SmOY68eGP/X1cjjC4uMnkmcvmXSOOijupRwlEG','790186675','fehdxjxj@gmail.com','خالد','الخطيب','2024-03-26 10:37:37',NULL,'inactive',NULL,NULL,'XX74+G82, Istiqlal St, Amman, Jordan','f3-GBTv_RDKT1huTBnqXqu:APA91bFH3WMtD4esEDyo5EMAeczJqjm06a5R4ffW-epQ1QLA2xooqb3BMBQbHEiBlRrcGeGIXTb3sQ-h2nLDqy8nYJgT0nGCkkQAFI77JXonwimRu_5wnARQMT2zClVDJNRRWEXMADgx',0,'Amman Governorate',31.963772,35.955816,'enabled',NULL,NULL),(474,'vendor','$2y$10$tmy0gRDe0UWDb.T2QgilPOyioJN7m/6goZVzD8smY7S4yFNGvouNS','795497569','hdhhygy@gmail.com','شريف','نصرلله','2024-03-26 10:47:50',NULL,'inactive',NULL,NULL,'WWQW+6HM, Amman, Jordan','dgERFuLMRp-q3IYNHBQzch:APA91bGGxzOWtwbA_sBEKO-AriNQGyx_Bz-Q63yrmYFU2kRp5WAmznG8b92KVn6rVzGhQsgiGFYkyHQX_VOKkoaTcDKOhwlrNreKdrH0ag9WAOyP8Pld99i3-gsZZit_Agi7tvqlfcTa',0,'Amman Governorate',31.938649,35.946262,'enabled',NULL,NULL),(475,'vendor','$2y$10$33szw0AArdUc7h.VefywveVhbPgOitFCW5s3AfKIX8OlPCBVCXfvO','796122633','ashrfalmghrbyalmghrby66@gmail.com','اشرف','مغربي','2024-03-26 10:57:28',NULL,'inactive',NULL,NULL,'ش. طارق بن زياد، عمّان،، عمّان،، WWMJ+869, Amman, Jordan','dDBuohoIQ4Cz0ifJ3CEiIY:APA91bH2czh4UE6BoIPXOa4_AHStsXFXsW4-kJwpiDg-ClSEoNA-dGci34_7oBuFDxwXVtY-8gguJrkPQ8UBeDaueh86v6PDALHelkN3PJK_GDrh2D8Bn58Vu9sdbMw_NYdEFoP224oq',0,'Amman Governorate',31.933344,35.930598,'enabled',NULL,NULL),(476,'customer','$2y$10$G2aISD1Y5w42rCquTBms.uZ0ONzyd5Oh3FJsPkGzkJMwtLLsI5SPW','796463555','hakeemabutayeh@gmail.com','Hakeem','Abutayeh','2024-03-26 15:19:10',NULL,'inactive',73887,'2024-07-11 11:28:39','2X3C+4GH, Amman, Jordan','ddXkLy8bOU6Lu3XTqsqlRr:APA91bGW3iL_M9YX4w5X5VU_eDOnByTch_syzVX5BuW7UjTdxLDVKltFEgmsS9qMPg0C2u8XvRsaXngQXYy_3lwdnwlCF4A2syqiJ0k08MlF9jSUOS5Pm1Z7ijez0tXfv9p2E66P7aeW',NULL,'Amman Governorate',32.003058,35.971655,'enabled',NULL,NULL),(477,'vendor','$2y$10$V9nAUz1YwFRTTG00J5QEAuRJRvc6.t9KeBREt0BmJrusNKZOyJ4dK','785427651','mohemedahmze@gmail.com','محمد','ابراهيم ','2024-03-27 10:51:14',NULL,'inactive',NULL,NULL,'XWQ3+78 Amman, Jordan','dtPYkcNRQKO-6ewP5ZdWdt:APA91bHlfgolCwqV2gjBUGGjcWQgJPLYAj1tj8s2m-Q_I8R9Glfdcbo3bakj4gA5uCwFmIqA0Z2HuhZdc5AVoEmta-ugm4WJHQqOGPDU1B6kh2ps3uBwfKA6UeM7fiiBUkrozLjIU8py',0,'Amman Governorate',31.988249,35.903298,'enabled','1.0.15','android'),(478,'vendor','$2y$10$2.rtnsqwitI4WgjDSOMdSeIHLzNh5sU27vkbIZqJFIewIOyTtZU9e','775725808','mnbil8969@gmail.com','محمد','ورور','2024-03-27 11:31:16',NULL,'inactive',NULL,NULL,'2V5M+H83, Amman, Jordan','f2ML4PzwTGykvABRTpIDFx:APA91bG99rCzw-okAzALoJOL1xOlcp-4vf-OkDg0A5jMs4FOqMDd2FX5iHVHTykpE4ameN-u1N7qRQe8ierJOCeCKMrdlyOtkm-6UCaHqmS0lwhcieDxaR4cViZdzGzsO3M2zb0gIyQm',0,'Amman Governorate',32.008901,35.883290,'enabled',NULL,NULL),(479,'vendor','$2y$10$n5oNA0k7PAX6hRRQ09uIuORc8h9UZ4r7hOnz/Ma2QpdWecxUqDWNG','788889095','hanizaitoun726@gmail.com','Hani','Zaitoun ','2024-03-27 12:22:59',NULL,'inactive',61121,'2024-03-27 12:29:20','Al-Urdon St. 426, Amman, Jordan','e7Vw3BRCRz6xJoXJUXL3xz:APA91bGl2HQDnXrWBqMypS2-BRwqjA3pCWTDyH_IqralEeuPFemjb8kAE9GPoQL2gVo0YMCIFjz9ISZ1EFejcii2iC69lXjxY4PpdnncA-IGPDlz_k80JvnvczTLX_2qfNMpqqpkfl4N',5,'Amman Governorate',31.999448,35.918094,'enabled','1.0.15','android'),(480,'customer','$2y$10$3DZo4DkahiZZKVJQWQyH..XNU9JtoVKvGcI.5K2ekMxJlP5aqRHMq','796093211','lujainhaboosh@gmail.com','lujain','habashnih ','2024-03-27 20:44:08',NULL,'inactive',NULL,NULL,'Al-Khawarezmi St. 89, Amman, Jordan','e45lwy-dk0KEnn7rUpKm7F:APA91bHTBWO5ByAMDORj3qucxOfIyWJjHbW3m_-CJPFTU2kigODN4m-MH0u3BajuoveLdA6gB_fSYxjGIskHfrdIGq1aI9qaGExwajzARy3mxZOvWIvaKZnjnAMqpvPrgrmmhoS_0v1N',NULL,'Amman Governorate',31.986323,35.891778,'enabled',NULL,NULL),(481,'customer','$2y$10$6W43naeGAkZRPw5nRtcmdug5PoxwS7a5MA7YzKY6gr00KBaUqLOVu','798127798','amerdweik7@gmail.com','عامر','الدويك','2024-03-28 07:28:42',NULL,'inactive',54548,'2024-05-14 09:55:46','Wasfi At-Tall St. 139،, Amman, Jordan','c86Do3P6T4G6sGZJNOQJej:APA91bH0y8w3GsjK4c32Iwvsqin2SIh8lKalRV37kf1RU1PPlzY1PM8287fQVmZwVvUjvQEWZtp4pOuBM3uAdyGvd6nd6MONyPevyiWBebz92s9370C8SmLbYPQgFtDWC4BNoWFMfr-J',NULL,'Amman Governorate',31.989856,35.871408,'enabled','1.0.09',NULL),(482,'vendor','$2y$10$C5UeTqSwj4PMOv0A7ScCnecnpfnkyRMPPe0fqvMOtWq0LmFvzpfFG','775553629','skir27892@gmail.com','عبد الفتاح ','المريدي','2024-03-28 08:12:52',NULL,'inactive',NULL,NULL,'WXWG+H6F, Hasan Adh Dhawaheri St., Amman, Jordan','cZcgb7oBR8eIfsHZ6qgRvc:APA91bFckifiWG8hrPQF0qeUPjVpJt9LMEeN3VFq2ZwnLRZHLOC4VUd6agtPMCUTRMrJ7Ja8DNW5goLkbCqlaQd8TAEt7RHi1108eiNVQDW65s0O2kOmxevrbphWgtoHVzBLHs_zdHs6',0,'Amman Governorate',31.946056,35.975260,'enabled',NULL,NULL),(483,'vendor','$2y$10$YxMa/tOft773UTy11t2W4eSG1hkRNsk7IjI49D9TlrgKVI.dA7ar2','781700123','hassanyalo2003@gmail.com','حسن','علي','2024-03-28 08:31:52',NULL,'inactive',NULL,NULL,'2259+373, Russeifa, Jordan','dOk5d9OtTr6REuSZfIT_wP:APA91bFugt2uEDMmbxVuL23ahirFcUHeinuW_d6E253R9H3V7rM-jh07E4wShXGIFc0L-0dbeLgmVlQJAxYkaautErADZsN5LS0gVzErpnRoSQe6MMv1ea3N5bFhp4949YcxikqxDjEn',0,'Zarqa Governorate',32.007805,36.018293,'enabled',NULL,NULL),(484,'vendor','$2y$10$niJ/K1AbpG0m8mSh7z9Z3OII3RUDSxaV9o5So5xbjtyTRD/hOA1Ca','781903937','osamamansour@gmail.com','اسامه','داود','2024-03-28 08:56:44',NULL,'inactive',NULL,NULL,'2259+373, Russeifa, Jordan','eEGIh9olR4OR9aIxryS5HJ:APA91bH_XDbVEl5_b798543SQMwTpYq-rehPwvOb9D6GDuRn9QTZs42o3VbyikhJ9WBhDpCTO0Dk1cCvdKOTxv7BcUwaORci94Tm_11H5lYOnzsU2NA1wmSrrG3MEajP_8W1Szv4WmhZ',0,'Zarqa Governorate',32.007280,36.018287,'enabled',NULL,NULL),(485,'vendor','$2y$10$k5WnuxNFwjZeXc5TauFVA.uwPdmOgKFjjaIkaglAnKm9fetOI9Yjm','785079377','karimelsaid335577@gmail.com','كريم','البرعي','2024-03-28 09:19:36',NULL,'inactive',NULL,NULL,'XXGG+VQP, Amman, Jordan','caHAftjwS1Gnd9Hdb7YCDO:APA91bHs3GjL4Rk2Lshy0NHkZxUGeYSoLmyqZOR5-0w5jYcVNAA_OuWRoM93ZIc_RqXz6uxXftCqmTdfkMUJJTEUIsO8XrO7OLRsamtDTNORM6BbsFB66ASL-ZTiCliIXgoOsXyGKRLV',0,'Amman Governorate',31.977621,35.977085,'enabled',NULL,NULL),(486,'vendor','$2y$10$OiIx4p1AcxozSU.NKxDiEOuA5vdNEtgA.l/QznfSNiah18S6HisDW','787874060','somiaaqazeed38@gmil.com','مروان','الرشيد','2024-03-28 09:28:50',NULL,'inactive',59865,'2024-07-06 08:42:10','XVCJ+JRG, Al-Kaswa St., Amman, Jordan','enf6xIrISOyuD1oAEHO2IQ:APA91bEi5jRh0fUDBPTtzzVzC6KSf5_DM-oMhCBn1Jqoxm5olpxtgbdn7blvlraSdbU7bkEPR7KUetuGoVjRI0S7rMzxE3d2nYgbUwwZMwLNm3DwOUfIjRDPoOlmiFNTgBIhpoPLjkxS',0,'Amman Governorate',31.971624,35.881768,'enabled',NULL,NULL),(487,'vendor','$2y$10$eAxKn51xDgVeB4Rc3Ivrce2pJKBq6JGVKoN3CWGwRV6WuUq/pFYx.','786024149','ahmadalkaabnaps4x2@gmail.com','احمد','الكعابنة','2024-03-28 09:32:58',NULL,'inactive',NULL,NULL,'XVQH+V23, Khaled Az-Zurayqat St., Amman, Jordan','c0TN9wlyR0G2NM3_T0jndf:APA91bG8jcbRHKX0yVZLVO0SHNqUiSKYkUhcA8wDjrtSmDdOmHyJ7PnXyh1uODxTsB7TnrQgDezK0kqeOcK1DGc0WR6dpaJnqpXTRuGK3lGL_DzbyZYfG_c4HXSz-a6k7tRLbQ8CAhUP',0,'Amman Governorate',31.989636,35.877555,'enabled',NULL,NULL),(488,'vendor','$2y$10$Qv.G6NAW6BPOot9gr6xEK.WtKtleyZwXUHbA/f.w6WCyD4b1Ru1VK','795969209','mobulestar4@gmail.com','رامي','ضوالحه','2024-03-28 10:47:54',NULL,'inactive',NULL,NULL,'ش. الملك عبدالله الأول، عمّان،، XXJR+RWV, Amman, Jordan','eQh2w1IkRuySordiA222Io:APA91bF4FRmQGHXaM3xujhP_cxEZYCgSes1ZuD1n5rVex1aGPaEX6_JXVLDKjv3KELvEesKfSZM5RYC3Po1NEq4dxhGn1CLjkTyGkpVxha2h1JDOQc1xLpcDKlUkKWZrlL9M6pwA8C4X',0,'Amman Governorate',31.981608,35.992362,'enabled',NULL,NULL),(489,'vendor','$2y$10$lhE60eEqE1cBmT5YFYLz6.SVVBb4V24Jz740yekbJDoDvYEyvoGDu','797253707','bxbxhdjdbd@gmail.com','وليد','يعقوب','2024-03-28 11:33:03',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 220, Amman, Jordan','dC_xEWyqTbqQYokml3MTKj:APA91bHfXfIhp5mvaD36uHADDF0PZ8aJaKN-hv2bYTptE_5XtH5UIFMT_P0Z9Ku5DI4FJljGhXhqdUqA5VOAB1gv5EqegigHnH0tyro_R6fYiQ6nt5LRchMRbHpXufE7rNHVDPru4xsn',-3,'Amman Governorate',31.995156,35.857846,'enabled',NULL,NULL),(490,'customer','$2y$10$6Vpc5g3I1EQebwT9ymUFautPi0rRNuyKKRj5mdwrwTvLh5SzOqcc6','799911739','aburashad1@windowslive.com','Mohammed','Moqbel','2024-03-28 15:45:18',NULL,'inactive',NULL,NULL,'2WVG+VWM, Khalil Hamad Al-Omari St., Amman, Jordan','fDNGHr6vXUPmhdcT2Rkx5Y:APA91bEFf7B3PX07pkQGBzyrpQ7_moa5s0LQBit9tcsNXPh9Tec0skNjKbVTULm0B4VHzZGa9vVElo-Kn39raHnAVPR6jxvx_jWX-RNq-Fm3gTt339I3KPU-8sUzuskBnBpTf8q8OrDn',NULL,'Amman Governorate',32.044051,35.928715,'enabled',NULL,NULL),(491,'customer','$2y$10$4eEtfAaW9m9rr4FTP0zRiujrmO4LSw7p1fTiHuEXULJysqPbtkzy.','796462439','rashadmeqbel2006@gmail.com','rashad ','meqbel','2024-03-28 16:49:56',NULL,'inactive',NULL,NULL,'2WVG+VWM, Khalil Hamad Al-Omari St., Amman, Jordan','ed2f-4oySUuVjLXp4I4PUL:APA91bGUnUWsPrlkV4pgJW0u5spyJzM2AwW_Mg6Nue6YjP1w16_6ddxnkNj9HQ7qk5N4slmW27ayz5mo20ZdGxrVKwCG_jPare3tSaj43iy8JNfhiBoLLPM_Wu5aaISIp5Nakxj_L2qq',NULL,'Amman Governorate',32.044004,35.928633,'enabled','1.0.13','android'),(492,'vendor','$2y$10$aL7B43fcerhHAw5KIXNOFu5E7YHZRCvA17MQwCjSUGU5NWgEutC0u','781822333','jaberalhelw4@gmail.com','JABER','mohammad','2024-03-28 22:39:33',NULL,'inactive',NULL,NULL,'3V6H+64H, Karamah St, Amman, Jordan','eVOSBvQORXK4TkvzYWcJJC:APA91bHYChTZ_bUYC0zppVEXApUzuEexE4ICNYkqjkNpq3Pwa5uO5P4Gl4xE9at0ef8sekRPfQSxzJo6PCDXK9DHNOWX_O9XsLnjcQ-w85OnABg7lQyTtLBP0l1gexDQr7pLP5LlHDua',0,'Amman Governorate',32.060602,35.878372,'disabled',NULL,NULL),(493,'vendor','$2y$10$/u2TwkOlTfJGoim3hr5hi.XV5hSvidJ0.18GpRlNFJW3W4rPhosUG','781828311','hamzaoweiwi99@gmail.com','hamza','oweiwi','2024-03-29 10:35:17',NULL,'inactive',NULL,NULL,'الحسنية،، WV3V+76M, Amman, Jordan','f2dWAp1KRT-UC47JiwNhpG:APA91bHqu1l06E7YrjVSIZCjOOzx8Ti7F3F9GHcfsnzVMPGnPeTevYjI4OSLTXv8AJ_JZSE8E_g1Ys7V4buKRDuKmTBQdYUqSnpXuDUvvC0gq94DLUFnZ4SGlkxceyA5-JpbBnpELyKV',0,'Amman Governorate',31.903112,35.893198,'disabled',NULL,NULL),(494,'vendor','$2y$10$NZDDcV/7Zl7HbKuQCuOM4e.Urc7s0k5YXlExgzvdhfn1peQ0AJXdi','785076018','honor83749@gmail.com','جهاد','ابراهيم','2024-03-30 09:47:18',NULL,'inactive',NULL,NULL,'2WW5+WPJ, Shafa Badran St, Amman, Jordan','fYtg-KQGSWKQW2T9NtqpBR:APA91bETzNLpxm28qfK7qgxoYswi_grSSjYaLtZMZR0Ch3v1pQnsKEs9HSqphSajklUNSgL3hHU_AafGZQBCbc0ywtUyxMN4VyYgNRZtzwj-qNJigL_XnUTg7YCJFKCor7qW8fxIQBho',0,'Amman Governorate',32.047393,35.909467,'enabled',NULL,NULL),(495,'vendor','$2y$10$KQFaHyaoxU2hfuIBHmui2eXKTSxjxRYWUfWkVnJsVBqcLDpbqqrHa','776687201','abbadilaith6@gmail.com','ليث','العبادي','2024-03-30 10:45:48',NULL,'active',NULL,NULL,'2VF8+R2P, Amman, Jordan','cul2mzJvRC6igshSvP9vCX:APA91bEJYVc0y_Rt-QTMzsAg7nku1ekgidn-1gA5wXho4VW_iW3Avk4p_0UXO9pEn-N0GkJbgMmkIJm0Lh01hwwqsJSITpLsAPyA4xoHkCxGE_7nLF9weSKKdIAlbstORr5Ens8kR86q',0,'Amman Governorate',32.024580,35.865024,'enabled',NULL,NULL),(496,'vendor','$2y$10$/5cWPbNUQEYYgpJChwBN3.Zbu8WtgV.r5lau7IyEAbcpHYUufXEOi','799730505','ahmadsarsour2022@gmail.com','خليل','صرصور','2024-03-30 11:07:57',NULL,'inactive',NULL,NULL,'Wasfi Al Anabtawi, Amman, Jordan','cfSGhlHfTWOVQ92hrXx--U:APA91bFHCgV4rcA-H_Le9ur2-ws3MU8OSXAJsjM1sGkS-L31gwpN4ohlc9LkTUgajG79Oh4frtN6CKlHi3CvMZItdO02xVyKVlhbNin3Fdu8qfzvgSinsC_mf8Zhru1jjzAXhhyHrDMe',0,'Amman Governorate',31.996489,35.861044,'enabled',NULL,NULL),(497,'vendor','$2y$10$i772Aij.B8DF2Vy8Yk5R5eMpRuA/JIevAFX6WkGJ1MM.aZ33V4EAi','797556804','Mohammad50medoo@gmail.com','محمد','الصرعاوي ','2024-03-30 11:27:28',NULL,'active',27365,'2024-07-06 08:40:47','2WV4+R8F, Ibn Al-Qabesi St., Amman, Jordan','dNRItP1sRFWCbu2BI2HbSM:APA91bEWApzojDb2m1BSBueBTABarjjLUw9BYPXswZ7l2JQ2YwTmU_dno1PmTkiNw3hQNRU5-KXq4DD61f5BArrW8KwB0otxj5kolF-p-6Kykn6Q1K12bmM4J_0oYGPtGr1AprZlxF2D',0,'Amman Governorate',32.042505,35.908293,'enabled',NULL,NULL),(498,'vendor','$2y$10$6/yFIz8n3O4PfQlxZe3lxu3J/fr.EkQjeSelRBRRZ9erX/PjLJYHq','791414519','Abu.molh8448@gmail.com','ملهم','ابو جيش','2024-03-30 11:28:14',NULL,'inactive',NULL,NULL,'Jarwan housing, Youssef Al-Lawzi St. 7, Amman, Jordan','dDZhcypnTlydN2dRp18gag:APA91bGBM4UCLJBdiAC6CpIqE7BaAS26VTeyUm7vD9JNEOWrXvQ-KeLeLuZR2s9KShsYM6NeNTQaHlSD_b9-y16PXC1qbtrUpa9znErGuL0ikQpbVrKAk834ulOSOz6Wza_r4K7QTzfn',0,'Amman Governorate',32.025957,35.870865,'enabled','1.0.15','android'),(499,'vendor','$2y$10$/8VrzqRkRZ6jw7LwgR205OjMDXXY.q97W5Q1yThXxqWoCp.BoPP7u','775338448','ahmdgogzh1977@gmail.com','احمد','القواقزة','2024-03-30 11:44:27',NULL,'inactive',NULL,NULL,'Yajouz Rd. 49, Amman, Jordan','ezFgoiBXSEW4nUq1LSGGWH:APA91bGJT-OMVC8IDWuXb_7YVP_P8VHV24UksTtMDdryrtaXzHZ1DfQhC2NuJGhDgJPc5VkbZr6M0B8fDfE3SS6nFcy031jNUAx-QVKjdnOZabOP_wijbzdwgd0sBdZnHdGZAnwK8-MC',5,'Amman Governorate',32.028821,35.863332,'enabled',NULL,NULL),(500,'vendor','$2y$10$HsuGE68MscflZHdciwmIHeiOUSco9RKz89gbj8pdcqaGOXF35KcSG','795690729','mohammadalli19540@gmail.com','محمد','علي','2024-03-30 11:47:16',NULL,'inactive',NULL,NULL,'3RCM+PM, Al Hanou, Jordan','eEPK-bryT6-TQaUGn8RBmZ:APA91bHx7e7R28KjiKMgUn29QItGhdnppDaSM6U__gO5yP_P3_g1n2rGn9AFmjrHicC8bGoYlsYnkdeepzNBcJJeqP8T8l1aX3GLcpgG2t565huwITbU6Hhimr_aAFPdn65zEmaF0KGg',3,'Balqa Governorate',32.070726,35.835143,'enabled',NULL,NULL),(501,'vendor','$2y$10$9fibFWHbX/tn8Mi67com9OUFd4DOQEqIllA7n/6BYvU3psxDKUsvC','795940603','tamaramobile796437@gmail.com','عبدالرحمن','يوسف','2024-03-30 12:18:47',NULL,'active',NULL,NULL,'Zeid Al-Kuroum St. 28, Amman, Jordan','cg6UopiwR8eGtUWM5QiQ17:APA91bFVEVD0oEH7h_0zxvkCBkx_v-boNAyW5AJNiwfij8ME-6y5fvRDQ1UtGvphIMmxgO2gpVpMYxuZjKUHRXJ_Oidd3XH82__SkR99rN-aQqVy1URy7btld_KM_LAXPkIaEGgM2ou7',5,'Amman Governorate',32.000633,35.916387,'enabled','1.0.15','android'),(502,'vendor','$2y$10$vPCP7nDk7ZalU50h1cxwJ.wxba/e1i1tH4ZfpzyuKI8RNHXYAXsKS','795360858','abodzeaid4@gmail.com','عبدالرحمن','حسني احمد','2024-03-30 12:37:52',NULL,'inactive',NULL,NULL,'Enad Ali Az-Zaghateet St. 19, Amman, Jordan','dOxbx4iJRziZm4jBHaKQGt:APA91bFBj5WTksjHUK2ik1iGNbM15xRamaFVZk6X8YfZWAp570vR8GGlYVcdtM3szBYEEmaBdAux_srdZJjdMhfhVezgTOlGrg_-NMQfIxAUNEpTiifYYTHW7pQjezl2TevHtfvNjiPl',0,'Amman Governorate',31.980569,35.940654,'enabled',NULL,NULL),(503,'customer','$2y$10$yDjA.8DjjEDZJ0MrUxbOSe2RecqBxhW3X8AedID8MO947R4G.LISy','791309324','husam.bassam1@icloud.com','husam','alabdallah','2024-03-30 14:08:09',NULL,'inactive',NULL,NULL,'WX78+F96, Yaaqoub Al-Qari St., Amman, Jordan','fDj-SqiTkEjBrwmgkgC6MR:APA91bEbzttfUYdJXx3xjOBabNkAWw-CRj85huvoYTuTgyxHdqLXLoMSRIc3Kjqv8D1pReT1oPCPYXt4TnpVmbMbPx2EO-r350m7CYRK4hrgGmgikIAHdoR8_tj27qc8NurUjH0PJEOs',NULL,'Amman Governorate',31.913429,35.965951,'enabled',NULL,NULL),(504,'customer','$2y$10$VhfPAEBJXciaoEc.LcG8QuoQLvL9lUTTivfoGEQ8Lh.8pHLIPZF0K','797300709','ahmadabud991@yahoo.com','Ahmad','Abud','2024-03-30 20:23:36',NULL,'inactive',NULL,NULL,'31.939511,35.929247 Amman Pr.Hasan St. 72-76، Amman, Jordan','dtmkYgHnlUKWraBeqCdZcA:APA91bEt-GMBkxD5rfZmFUP2qpJXtWi6ArSpHK4OG7WO84Glu_JsXiGf6yM4XTMdbs6rWDTpfitxbEdKeXcbaTCQNSWRUwXwaBJ8COqF8fz_w-cooXSYAn62SPhtcPmbpmoADnLB8VBc',NULL,'Amman Governorate',31.939509,35.929215,'enabled',NULL,NULL),(505,'customer','$2y$10$F1wgjVHoRhodZqTIJfYB2.wUgXxgRUDJbdcEaKUI/fl0cJLmREQw.','787416627','yazan.s.kordeh@gmail.com','yazan','kordieh','2024-03-30 22:08:07',NULL,'inactive',NULL,NULL,'2X58+Q98, Amman, Jordan','dfvMWc_XQ9WSf_Jz4BKphR:APA91bHSNqkp9zyvISNVCK34pDYSMrjWQXp7IMR1bVq1GRZ78maiqmZEGwK4ONdUyajV084Ady6Kdg3IA0yUpzYwAFaJVW4MtTy4fRCe7veRq_qJLlHnOMDUCg43S37fje6Pj6gpG_Vq',NULL,'Amman Governorate',32.009468,35.966624,'enabled',NULL,NULL),(506,'vendor','$2y$10$BoupcIGJDMAIUgW8lGNfO.eDw6rZMAQ5dZ6r0gxnT1s2k8Bad9/Qq','796026408','mhmmdbhtb@gmail.com','احمد','بني حرب','2024-03-31 08:06:56',NULL,'inactive',NULL,NULL,'3R57+X2 Ein Al-Basha, Jordan','eaL8lwexSfWGIETObKjJrU:APA91bEkOUce3IMtX6EoXntMyCyhE0kCn1waAxkEyh0WnhUmCXRRvHv-pxp8LcBe1j5sRKSUTbSd-qqtKTRr4nKSz_cWlLrzTIg7hBkCW6MGXh6iWGorNNyaeUflHGSr5_WLX6ZmuKxU',0,'Balqa Governorate',32.059877,35.812569,'enabled',NULL,NULL),(507,'vendor','$2y$10$IvnOvuSA2fQb4d7hyaUJGujX5kciqhniOMxpPF5RJKZOTmd1gmlmK','779701135','mareealfaouri@gmail.com','مرعي','الفاعوري','2024-03-31 08:22:36',NULL,'inactive',NULL,NULL,'3R5J+7HQ, Hizam Ring Rd, عمّان، Jordan','fVWulktMQGSh7sRpVDadGl:APA91bGbdTf5UwxjRM4f3sJMob1gVp22NhpNXcMa8q4_Ungx0Gp5zIKyZogs1jBfuNA4oKp_VhJOSRaVRg-TjtNu4A6_-6tY9q2JqXEmsTU5K9lVdQq7tUTX7IcPGVJXQPWnS6LCDHp1',0,'محافظة العاصمة',32.057623,35.830834,'enabled',NULL,NULL),(508,'vendor','$2y$10$GJUQjfwz4qB1nEYJkeDVJOij.O2X6MNdqOYrzm35GdXueezm.H6M.','785444147','Kenan26.adi@gmail.com','معاذ','عادي','2024-03-31 08:35:41',NULL,'inactive',NULL,NULL,'2RXF+VXH, Ein Al-Basha, Jordan','fml9EIzsRSat5yGpxsCP4W:APA91bHnjlVsU1H7osCgzPZ00m2xQp8c5yj_VMuSSGzQ9UI119MU7JGA7YMHZpEczuRxqTSQxniVWYE0OhHoRxV8sH4Tvf-MlFzXiRalluO8AJ4lxH-umGDEOADnIZiHZNx8R1320x5Q',0,'Balqa Governorate',32.059083,35.825299,'enabled','1.0.15','android'),(509,'vendor','$2y$10$o7HhmUDN9BzLIaZzmw6F6.nMbk5bVniEYsjFcale9VhLOgbq18HI2','782942027','ieadarab9@gmail.com','اياد','جمعة','2024-03-31 08:53:51',NULL,'inactive',NULL,NULL,'3R5F+HCR, Ein Al-Basha, Jordan','dbK_GOjZRGe4q54ihy2elx:APA91bF5I2tPpLv7tznhDQXkUAyGgYoEy7JhDxkBcMoYpRFwVyHm_cE10KU7ZhiECf0Q4CH5L3BjSaKwu5rBphqmORFKbfiQcwkxXOK18kVg5vEKq0jo98OT52b3bZNqUa5yeOIlGG0f',0,'Balqa Governorate',32.059161,35.822989,'enabled','1.0.15','android'),(510,'vendor','$2y$10$XG5Og7w3bS6NugQe6Z3/pOaXcDRK1M3mDX1PGgtuoRc.133uVlAEO','798048210','aalshabani373@gmail.com','علي','الشعباني','2024-03-31 09:04:17',NULL,'inactive',NULL,NULL,'3V5F+J89, Amman, Jordan','dQZFFpQiR22AWsbjHiu4X7:APA91bH8CQ9QiRoRdKepAZ-Gtzslks83xnp6mm0KhYEfH9deIsds6K5urO6L3GRqJJS0J13bgm37_uYXk6yXcH9Ubgi_UHv4yAimaM0n7O5fkezq4YGnnfYxA6Ya9HnIOuOuJXyoViQ4',0,'Amman Governorate',32.059341,35.874077,'enabled',NULL,NULL),(511,'vendor','$2y$10$QGBpxTJ5FMItOBmf8QPrPelb0tNhAPU27ITKKLlE9T2hB1KruEk/K','782121979','mhdawymhmd710@gmail.com','محمد','صبري','2024-03-31 09:08:25',NULL,'inactive',NULL,NULL,'3R4M+G4F, Ein Al-Basha, Jordan','eN7xJ8Y7Q9qUi_MSGrCegj:APA91bG4DQUfrbnROm1gFhCP577j-u5tDyNMpPRftlGwgWJjxu2_Ccitj4IFI9dK1Yg9zJjDrIHpH3XnA558nq1acOHs2YzDlJsgQsKJtyIlvI0miswNI_4-bKe-HSZZVEptXzFAuXhP',0,'Balqa Governorate',32.055650,35.833135,'enabled',NULL,NULL),(512,'vendor','$2y$10$ZcjRuUa/aSu6n3uuMiPA1e17oiz0UV33RehaFOi1/nztOiadcFicq','782630579','mf3282518@gmail.com','محمد','خليل','2024-03-31 09:11:21',NULL,'inactive',NULL,NULL,'3R4M+G4F, Ein Al-Basha, Jordan','f0KsVqwNSNyajx1dre5shT:APA91bHyUF6KocV2GF9TDhZTg8m-DWrEnMSViHEipyK6YacSkbQEBxzMYnpHurYExnAVExVISiOmNfkD1PoDLaflX1WUhOEtqzHFNR6AAlqrkkOeK3STmruih_d9ce5VXBo-zBE27AN-',0,'Balqa Governorate',32.055732,35.833113,'enabled',NULL,NULL),(513,'customer','$2y$10$eNc71bCcSeAjAhsK5EB0y.T.Xvp1NpG3UqBoUKraqhohMn905AB5u','798048210','alialshabani69@gmali.com','علي','شعباني','2024-03-31 09:19:10',NULL,'inactive',NULL,NULL,'2VR4+2G Safut, Jordan','eDjyza1pQvSJ7lEuxZqzNm:APA91bEIXBYqUYb7pGIAwPWKuvpb5SlvD0aH7aotMpVE7ZMVT9RMrcbVQ_4yGzWZ4Rf-I2zIFKdOVlkyfZBAGN26WlC_JtvWGtk6R_SVvT0tknDXZiLmIeIUAzJgwqt2R3K0qGvLL0Fx',NULL,'Al Balqa',32.056029,35.876248,'enabled',NULL,NULL),(514,'vendor','$2y$10$RtAJc75oXovNoMxdvPX3LutmOAtzbW/nxgE0yWqM94NUhsoYC8fy2','785066619','ghg00054321@gmail.com','رائد ','العزازمه','2024-03-31 09:29:39',NULL,'inactive',NULL,NULL,'Karamah St, Amman, Jordan','fgM4ZwyJR6yV5DNzgyt-gL:APA91bEOLWWkSo29X7RfKxrhHwkfiGvOQNu243yEJ64bG2wCYbJgMNNJSZ9dLzkO8WcJwH6NCFCjuW0NJqLDau1_VH3_5MqM7k-6iXLEykDlOyKG6MlWVMPkGxguKDKVnmJwTNiGWw3v',5,'Amman Governorate',32.059074,35.876592,'enabled',NULL,NULL),(515,'vendor','$2y$10$2C8SG1FsAUgLho8mI350HeQUhTxCB4vBPJPfvdXZioWkBMVWFvcku','788669778','ghgg79059@gmail.com','رعد','العرامه','2024-03-31 09:31:18',NULL,'inactive',NULL,NULL,'3V5G+MH Amman, Jordan','cn3Xt0obS4-P2qaYgM41Ih:APA91bGUwmeft0oHjfU0s4PgLOiaLRKWdQB6bvyxyU0hrudtrDrjJ7NgeIC1e__-dnXgrz17hquOqU9OLTblYZwe2s5-KBFBocZaLt08yMKjkFqzS_ypVNC-yQptbH6KIi1_QTMNzNGp',5,'Amman Governorate',32.059158,35.876390,'enabled',NULL,NULL),(516,'vendor','$2y$10$5iWA7a3RZYZkZgitTIdRaO2Fh/sI4n83CxJ20pIqhouvcaQvCXwO2','788537740','anstrky993@gmail.com','انس','التركي','2024-03-31 09:41:30',NULL,'inactive',NULL,NULL,'3R4G+7GC, Ein Al-Basha, Jordan','dC-l1j5US8GJK-2zWVgsRr:APA91bHLSp2P8McVMnC1vmdyYFjsQzPMAuOIJJ-WE52Sx3EUZ6rIDNvEK-N_5IfguEfJyrsfEekdEWDkSl3516vvWMjlphU6MW-bOeinD8mzJdHzaxYwCUFdugwKlijlxMpEi7hQUJZw',0,'Balqa Governorate',32.055692,35.825910,'enabled',NULL,NULL),(517,'vendor','$2y$10$AuvsCxxnlIA5jVw1O.l.0OksZu1PkvCh/1aeLbLqAvJZ9cIg6mZtu','776282638','omaraidma20@gmail.com','يزن','القيسيه','2024-03-31 09:56:27',NULL,'active',NULL,NULL,'3V2H+C47, Amman, Jordan','cOS9kZ6ESEGa7xlUJp-ozD:APA91bFtzqnP-Jt-6waLHrLI8SU7KXeX5GT8d2uIXLlVFc8pNT1hDof-FhDfmxd_qlvuAo4xpyD1AYsldH0FvcrICsnkCrChjiLck0tc4mMc7tlC1pjL7zOgFR7kD162NIg75hLejEDS',0,'Amman Governorate',32.051247,35.877575,'enabled',NULL,NULL),(518,'customer','$2y$10$N777uWOxch9zArbBp741cO8FO.XPNRsR3HxtILQynk3veSeWeYAfa','798257470','hamzaadnan98@yahoo.com','حمزه ','نواس ','2024-03-31 10:05:21',NULL,'inactive',NULL,NULL,'2W6W+F9V, Amman, Jordan','dIpZ5VumTvGs2G0Q-0ByCm:APA91bFAox4dHVIGQFosOj203bVrhctkygne3BkDTy_vaD8u45ymEBK-3Fub6kWVH0DwDPDFBOIJscHom3mYXdy9CwMU39X2U4qebJw7W_WT8Wb_dgeOCjw0LtpY2gWGCadFLJO-Ml-8',NULL,'Amman Governorate',32.012134,35.946301,'enabled',NULL,NULL),(519,'vendor','$2y$10$6AaDPq4HP4VuCsFvC/wo8.zLUs/vkjXBQ.okFaU2D61yuOY.o3Cae','780361661','w0780361661@gmail.com','وليد','ابو سارة ','2024-03-31 10:11:46',NULL,'inactive',NULL,NULL,'3R7P+7X Ein Al-Basha, Jordan','fQNS2yGgRHqCL9qTR_X3QP:APA91bES_4rC-m1igC_H1NYf7tAOeV_RpGmXDn6W97sKF-AW1BEMKduAlJHzBDXlVuv3O9dk77itJLDPL0WJ5LXMK_BOVwDBp_mIhyAPriN4YIdOwMJ3hS8V1kezZuwALVdcMgPJNpcC',5,'Balqa Governorate',32.063213,35.837445,'enabled',NULL,NULL),(520,'vendor','$2y$10$X6TMBUhGdi78zeqawqYPtuT5aAwqCaPM1ChfUkj7Qox5c9bapdK7i','786091733','mwmnk860@gmail.com','خلدون','خليل','2024-03-31 10:15:44',NULL,'inactive',63218,'2024-04-01 08:38:12','35، Jordan','cxxAqH28RpaCK4odAqAnBp:APA91bF4bQgRg30HZImX2SHMIjmwvqgPnkr8RxR9jl7N_xiryahyS2rySAJ50kDmxialt90rUPVe302mLD9_lVN0StJvWuDukZFtZ8Zbt99Sy5DoWLDfScVIykPh_gM_4oHl3R5qW70l',5,'Balqa Governorate',32.063946,35.838991,'enabled',NULL,NULL),(521,'vendor','$2y$10$28iLCxVtvZEoe.2BtfXFNeDNmkQQ9WG4AwEIu46bTQ1aAQIsXAuuG','786193146','alamnsyrmhmd@gmail.com','محمد','احمد','2024-03-31 10:22:12',NULL,'inactive',NULL,NULL,'35، Jordan','c2NZ91fhShWPAX1TVhVUkx:APA91bHLv_VyJ3PWu5uc5ExKviQ4aDYig0z1hzzNg02_4VgbksfpAkK_2Sxnyl2_8RSqwHNHvut37QwXj2sQ-xqYDOiZ-YqvWuGOZsNts64RIq9Jg7RH7B9zyllCIwq1TSK-NOKL9KbX',1,'Balqa Governorate',32.064136,35.839093,'enabled',NULL,NULL),(522,'vendor','$2y$10$MhJWFXK.yVlQSHfzJrcdEuaeAgfxiVDboLPuGYo8i.Tq/vrug7lMO','780068005','fwadabwhdyb7@gmail.com','فؤاد','ابو هديب','2024-03-31 10:22:36',NULL,'inactive',NULL,NULL,'3R8R+49 Ein Al-Basha, Jordan','f4Tq7XkQ01leP6EmnOpXLV:APA91bGsu59VL4aAXDAwgJtmh479TtFX0cpSxBtHYF5cD6Mghjm6OiXfmGCXiBoOJA5jKSvLAe-ZoN4QJL00y6DZr8BDq3J1ZUZhwOasfVam7Q2ADTi1de3bH_2O2SIDSDsLkhQs3oZW',5,'Balqa Governorate',32.065296,35.840985,'enabled',NULL,NULL),(523,'vendor','$2y$10$eNXbqd3uvEEXuQgcxJ.Kvecp5FiJtPjblZ5LG5ysnEfAyF/2ENJiy','780677123','salman.alqdah1981@gmail.com','سلمان','القضاه','2024-03-31 10:30:27',NULL,'active',NULL,NULL,'3V7P+C2F, Amman, Jordan','eGIF-TYaQcKJY4SqQH_HGp:APA91bHn7-cs087oPaJPYKP6GiBvF3SoFfQ8s7FOkN4QCJ4QonH1xVEP3AtQNroLeGIHcQxWyLsVWbd7JtkPH63nhYjPXLQDmBU_q7AK_lqGsfJzJna3dWJMq0NvxZVhI2bTz-JDePUc',0,'Amman Governorate',32.063385,35.884701,'enabled','1.0.15','android'),(524,'vendor','$2y$10$B8oFwVHDy9rOkPgpWFLWu.4RgrkESp.IyKrno4JrLc166ENE4InCS','786295422','hassanfoaad042@gmail.com','خليل','جادالله','2024-03-31 10:31:26',NULL,'inactive',31987,'2024-07-21 09:00:44','3RCV+Q4 Al Hanou, Jordan','fPqtuUqVSpuw8ah0iu31Xu:APA91bElEBr7vFWUQFPXsCmSnnulrgn9ik68oP3DyX68PmB_-X2806AeWUIje00RXDyMlBFGrrsEbXUvug9O-ZPWo-aHa4GWa_XBKVfUAdNsMD6RG8PzZw-wsN-3qYR-Z0yQc6fNYd7e',5,'Balqa Governorate',32.071997,35.842765,'enabled','1.0.15','android'),(525,'vendor','$2y$10$YpPxFpoN/oewRPOAEopTgOCMUOfHHCFjN6jZAvIOhszd.9TiqHEN.','797418311','alsyrawyndalalsyrawy@gmail.com','نضال ','خطاب','2024-03-31 11:05:45',NULL,'inactive',NULL,NULL,'MCP7+4F Ndonkou, Chad','eSdaOeL1RwebQV1sJ-4R2L:APA91bH56-j-sPMSoUNskd_WY9wspkZTdTnLXkLq4-rTBrdZEsSclz6CY8WPLYyQ-xBW1GVGAug1crb9j90ZhZlBQjZ0yTCcxqVXsfDLkBAMKdsfwEbU440GrWOg25SUQ-FP8YueB3G7',0,'Lac',31.912094,35.942649,'enabled',NULL,NULL),(526,'vendor','$2y$10$4OJ6.4f5EfcN4LvO38nOW.sDTTCgl/qNcM/ulYjJhyhF1eknV0zke','792307111','link979096@gmail.com','بندر','العدوان','2024-03-31 12:07:12',NULL,'inactive',NULL,NULL,'Shafa Badran St 89, Amman, Jordan','dyz_CELKT1OODGwDyNObZ7:APA91bHSpvKgN8XbyPfw7P6PDULo1MHRRGd0eQ5RgifgGfmuLIUerR4AxKWHQvxvHbHbqINHOCj5y_DC1z11eZlUZHg2zAgBciDgdVw5tR2dyeXGtkVZPM5VOeusPnjLqTdjt_vXtQ3R',0,'Amman Governorate',32.048894,35.909944,'enabled','1.0.15','android'),(527,'vendor','$2y$10$Jx1RtgiIFmN4oTRWk2V7GON/Wx0jKjZ9FU7S0moqj1P0WucsVuyBm','795009410','z0782649149@gmail.com','علاء ','المريعات','2024-03-31 13:26:04',NULL,'inactive',16590,'2024-04-14 14:14:51','2VXG+M3Q, Amman, Jordan','cxnFIXRNTSCSqBiAQTgYQ2:APA91bFozThE4cnRJte3ETGVelD-zkZLvLHscb2WY9LVS2qRLWdDTV1L34ORBGP7UpkN3ZcfqMKJApMwtzY94CYRdZaI7uY9296nriME076Sqht9NAqzpYJL2P1b3LD3iC7gWa6hO7mh',0,'Amman Governorate',32.049227,35.875028,'disabled',NULL,NULL),(528,'customer','$2y$10$RTy2lEFHBtU.Qkm3DEz4jeOHoQwctnEcYvPaRsuyYToGD.5KCk2Wu','778833433','jordans3b001@gmail.com','ali','alhamdan','2024-03-31 20:52:15',NULL,'inactive',NULL,NULL,'2X4G+H75, Tabarbour St., Amman, Jordan','fD1RuQMNRmi2PFzi84mICX:APA91bHDA21aqHfV1NTFVs7dycU03byxWHdbZyc_h2I7Me5hytBDtrRKHwUGhhI-0NE0gliCU1NcJTf0JqnbJTXBPJWP8Ss8mWo-MHNTyMs9WDHPdj_OQi7xZJNY6HPzp3QG1YcLO9CJ',NULL,'Amman Governorate',32.006577,35.975904,'enabled',NULL,NULL),(529,'vendor','$2y$10$YoOCJMfrI8mlLuZOPbLdQO5alF.DC7yIPblPafnCLBWPLsnw2WMxa','781277387','malmhsyry511@gmail.com','محمد','صالح','2024-04-01 08:37:51',NULL,'inactive',NULL,NULL,'WXP2+GHH, Amman, Jordan','fKkzgMx9SvOQpUKLDYzo1B:APA91bGx0WqlfdYpXodIxPXxb5hdRgoxdQV7UwDl6W-77neCoX2uo5eFi6LjVtx02n42t8CRbOW_NqS2PwSyWLd_eB3y-f0azvNi0vOXJz8iC2cQPOWGIGziZ0qEEXphqo53JTxxLvu8',0,'Amman Governorate',31.936648,35.951373,'enabled',NULL,NULL),(530,'vendor','$2y$10$zsymk7ZnTEGLgVUzc01hYOkUsv.YarPzgPlniqpT6c6HI.BMJYc0G','799617652','sameralqateel@gmail.com','سامر','القتيل','2024-04-01 09:24:59',NULL,'inactive',NULL,NULL,'WXXF+XGF, Wahb Ben Saed St., Amman, Jordan','cM-dqj1oSs6MN19_M9J8HD:APA91bFsaPpX7XY0BjJdgYQDrHPFhgEpJjklpr_-_WkP4I03MBsgLX9n_zKCSwhnQZHJFdiGSL9nmHbZ2_KqsJbQ6BcA8YCCcfWPGDeuT6aGUYr8P5fcdd9Rn_BgI6-EULNLEtEm9Hp4',0,'Amman Governorate',31.950021,35.973867,'enabled','1.0.15','android'),(531,'vendor','$2y$10$a9jei3Ql9Xkhn6EkrGqYQefy9RoWg0q74ttBDHjP.ThbsRW9pl57e','796421924','jwdtalwdy5@gmail.com','جودت','العوضي','2024-04-01 09:31:51',NULL,'inactive',NULL,NULL,'WXQ8+C8X, Amman, Jordan','cHl1j9XqQZygjVd8fobAGM:APA91bF02I-sw7tL6kDbP7RY_g9NSDQw-DU5X8v_ydA_x5eFGZOKb_gPSEo8uxmgiWKQLIa-On9YaEvG0bdDqzKW3RqRDOXQMdePKjxOucizn8jgYKsV0jDHY0po9vFJl9_D8HLMlFQO',0,'Amman Governorate',31.938231,35.966002,'enabled',NULL,NULL),(532,'vendor','$2y$10$ogJDqznlrZEv9dmB1CGtbOXHRKhWHRxemoKzL3GVi.C4ILb.nGwgi','787007033','majdomari853@gmail.com','مجد ','العمري ','2024-04-01 11:03:59',NULL,'active',86983,'2025-01-01 18:51:56','Pr. Hasan St. 21110, Irbid, Jordan','cqOPwdkNSqGZlATC_LptIk:APA91bHCZV_KB58M_4KVwfwkfRuYicqJ_gtWO6mAmC9WM5F3no2Aj1pmfXI3NjjFugcjXNirRpUgWVg9urilEppnTE1amxcIk39dbYEGSY5AiX-C97mRQw0',3,'Irbid Governorate',32.534989,35.870532,'enabled','1.0.15','android'),(533,'vendor','$2y$10$A7R5XYrnF6hqDJTzZIrlo.EaBi4T4QMVy2GvJ1SoojO4Y.c63iswG','781396025','faras6693@gmail.com','فراس','أسعد','2024-04-01 12:19:52',NULL,'active',NULL,NULL,'القويسمة بلقرب من حديقة الملكة رانيا، Amman, Jordan','c1TqUPDpRLKLpxGQA7O2GR:APA91bGowQOOOjpOIKC1uyM8iJh4n8yVo8Cwm4Sa0TblKEXZjZKBdMDgRPAs3VeYZveLi-AKsqJsPTjmD8sA7ZL4fMqsNIDbBoXeJNN-cU9YkrU3Sa44TWuBWKk2z-EBId-F2S36PImj',0,'Amman Governorate',31.928795,35.961604,'enabled',NULL,NULL),(534,'customer','$2y$10$KTXiUoU2T8vmIm0raVa9b.i5/sg7knZOBGw31Nm2aVQhTJAB2R/QK','786473736','bel1948h@hotmail.com','bilal','hasan','2024-04-01 18:41:09',NULL,'inactive',NULL,NULL,'XWR7+2P8, Amman, Jordan','e-z_dZGcWU9UlyXp9RB3yk:APA91bHGijcJz8q0clbi19sKzfWMVFY225YrljJetiE75VtrqhtadH_tfkLGzjIywW9cv9sijc6OjNbmjpE2oTYSWuY6LxTQQ4CdenGVjPp91UCCB9ps4QGX4keXOQuN9Vj8lRX5HevZ',NULL,'Amman Governorate',31.989938,35.914430,'enabled',NULL,NULL),(535,'customer','$2y$10$CS5MvYy3oA5Z8BH0IbMi.eq2.CMEl8UWbHat7LIQmc9Ja3xlih/su','781458406','mohamedtrabilsi43@gmail.com','محمد','الطرابلسي ','2024-04-01 18:55:00',NULL,'inactive',NULL,NULL,'التلاع الشرقي،، XVJ8+J7H, Amman, Jordan','e3KGafuD5E1Lg8SVsAlYPN:APA91bFxVq0qYx3f-bBSJMjlCsNTAIAh7HxZrpTjAyBbJovwwSG_lVVLftMxDdJVdrPwqBuwnAQhbMHKaUimtiqnKVThMBNHCjd0VzBOkG0SEoMfUMKKrypCiI9MGNvahoraEltLMd92',NULL,'Amman Governorate',31.981506,35.866040,'enabled','1.0.13','ios'),(536,'customer','$2y$10$sGWyA04lk9Kwx4RlsKKD9eHP68zlqo84.ieyGUMVO3N1deyr8603S','795476973','maysm7508@gmail.com','ميس','عبدالرحمن ','2024-04-01 18:57:38',NULL,'inactive',89493,'2024-04-11 15:23:27','10، Jordan','e7JpgFJlTCiW7O5WMHYhkO:APA91bFfc5IRZUeN8V_KmsbQ0icCXQiZ5ahleCU35_y3Z8E7V2xX4k7A6t4fd1wX9G49ZncRMCYcaoTGrlJ3UVJiGYMxYxKy4PO-QDS86CA5HOtpV9WGlUN1WhvxF86FpjlziGJGLaLX',NULL,'Irbid Governorate',32.540926,35.888816,'enabled',NULL,NULL),(537,'customer','$2y$10$aHSc5kuuRWNMWJOu2zrEzeTxP.0ha4IlIveo3YJe2wjBMwgttP1Ka','788586704','khalilnasar117@gmail.com','خليل','نصار','2024-04-01 19:41:54',NULL,'inactive',NULL,NULL,'3V5F+5X8, Amman, Jordan','fHVfroH1R9-7ZMgpf5pBSS:APA91bEuXXGGER_i6pBu6BRz6NuiPXZV7Gup7UxKc4QCOX8Zbj5ZcaRQ3oqZE7l2VU6ipa81F09g9hRvwVlv6kD2Ku-Pq-cCI8JTfNKXfYeECZ-cWqs6T6_PjNklU3QqqfPtZVtkScon',NULL,'Amman Governorate',32.057964,35.875160,'enabled',NULL,NULL),(538,'customer','$2y$10$7QG.WUndL215q.IIAztkOu.JaSR2f660YSENjeTQVb5q78aJ/GXGG','786138186','othmanalaqrabawi84@gmail.com','othman','aqrabawi','2024-04-01 21:27:25',NULL,'inactive',NULL,NULL,'WW5Q+FMP, Amman, Jordan','cLbV4GwgTySnOs4QpZg6BN:APA91bGrJAGUvc2neUDUe-UhOa20zMtWZhlTlyjWa5ikVhKZdf9ErXsMmcyqaWYcO9AqoEb-DZfksaGEK3M0a2YLg15Fxx7ifr6IYjesyUc2xqhAmqrfxz18tRktnON3oOCCYb7x_QKR',NULL,'Amman Governorate',31.908626,35.939152,'enabled',NULL,NULL),(539,'customer','$2y$10$krwiD6K5WiD3DK735F3s2eLxamvVTBoePFuUTD6O3bAT8yFdX.tvO','785690641','aymnabwtqy@gmail.com','ايمن','سليحات','2024-04-01 21:44:48',NULL,'inactive',11531,'2024-07-22 01:30:04','WRX8+9GW, Amman, Jordan','eIrFMu44QNeXBcNmhYV2Ww:APA91bHmXI17DJ3hH4BqA8VW5RYTxfN4nM1TN2RcAYBpUgANmRFBA5-wZxjRbFLHpDNEqkGycB33riIRHOOnIoB2KaZu0tGHtPdxH3QG7wwesmyex7eci-jbOwoHAELsvRSrG9ir4Ofs',NULL,'Amman Governorate',31.947953,35.815923,'enabled','1.0.10',NULL),(540,'customer','$2y$10$udPUUiZoml.QXUv.UPZY8.LZWht69aFmoBmE/MAGt.2q9aoizOnRW','795145850','me.zero@hotmail.com','naser','naser','2024-04-01 22:16:23',NULL,'inactive',NULL,NULL,'XVRM+576, Amman, Jordan','dE28TMujQXWiWEYUTVK9Ab:APA91bEN83UXaMFP_jo_9MKTOVfY4PmiO1J2vS-bDl589lE9f7TFfKiCSGI7D3-EKkJyAL7gJccWVKbrtgrrnLwlvsuEVRmN0UtqVoMCX_L1MkxVoUWgMRu9QJX649tFCB7sujiBnTpL',NULL,'Amman Governorate',31.990267,35.882602,'enabled',NULL,NULL),(541,'customer','$2y$10$NL8wSi0aCDixv3z4vnJTGOyddoq9iXtNfrJW2HRuK0laVP0Gs09SK','795439131','salmanaldajaa@gmail.com','سلمان','الدعجه','2024-04-01 22:18:32',NULL,'inactive',NULL,NULL,'Sufyan Al-Thawri Stasiun 2, Amman, Jordan','dDN9hCTnTYigv91ph9Hgv6:APA91bE1znQyEgjzEvEjWmYy9raTCUuowInukR-2Akcf-ryTYh8aeFtBJoL1b1ENDS1-sE2inxwztBDIZVsVTHLI1lUIFHBSBZN1JqOpQFv25aAkS5GVqPZ1rPbyTnptDtd5oIAzu-vc',NULL,'Amman Governorate',31.979083,35.983464,'enabled',NULL,NULL),(542,'customer','$2y$10$I.QvU45cAsL9YF73m5KgBOAPG3MxQBmGs/VhTl09wic53/FjAAMC6','798429950','bashar.melhem@gmail.com','bashar','melhm','2024-04-01 22:24:49',NULL,'inactive',NULL,NULL,'Tarek St. 25, Amman, Jordan','d-n8SQT6RLe06PR0Ep8fEj:APA91bHq_PzzmonMWfQQ_duFEk3wB8CDX5K3qcsS_AVE7UhABfbyZPAucjFxdrldjtLGGpcP1-Wk3Ox6znUak93JzoULKY1ivabKwe3h-zj3g4qVu4xuCsI-KUgDlTRDA7Eo9Fx0CaTe',NULL,'Amman Governorate',31.993424,35.945443,'enabled',NULL,NULL),(543,'customer','$2y$10$pv4CVRLbdAySxLqQ8Cy8xe4loWDrzhG2Pjae/8/bdPcK9bCNDentW','795487661','szkarnh4@gmail.com','سوسن ','حماده','2024-04-01 23:33:17',NULL,'inactive',NULL,NULL,'Istiqlal St 156, Amman, Jordan','d6d6VOZdTyqjbNrGWIay6J:APA91bHgbtLH2cENcRH7sQoRYBSnOCqq0xNF03liiCx8uvtBTwTNPwpTxLhzkDy-9r4aRsNjB8RHNua0-6SQ92g2LwWaNvgfd-sOL1qJTgEGM_DFzZl7dnN_2IEYsvS6oS8mvMMxuBha',NULL,'Amman Governorate',31.975151,35.932202,'enabled','1.0.13','android'),(544,'customer','$2y$10$jJRXFseoRBynJpd0d1X.6uck6IYIJIJu6wXYAdz3J0deYH3EULtgS','785458194','fayyad.bilal@yahoo.com','بلال','فياض','2024-04-02 02:42:39',NULL,'inactive',NULL,NULL,'3R2V+JQ5, Ein Al-Basha, Jordan','dvFIjAOZSs-LnXYIEXhKW6:APA91bHYY60VToKOAvwmdCiCGVE5-b0Tf7Gun7xSOd5msUgCE5K3rOMcQpBviH0kDlk8xdGpHDhjxjoCAXn8i-8-W6RLQI2314S6SXZsd_SCzXngiVRh1KCj5O_G2MgCSX4UeBJhvzmI',NULL,'Balqa Governorate',32.051905,35.843369,'enabled',NULL,NULL),(545,'customer','$2y$10$ihFgA6nG5Bc5sNTMZbEk7uUqtAgc3vMkNQv/FrNj9S7fbKzBT8CHC','785750986','moshtakhadi@gmail.com','مشتاق','هادي','2024-04-02 08:02:23',NULL,'inactive',NULL,NULL,'2QCF+R8 As-Salt, Jordan','cENKf9CaQjywRJPnUvH2Q1:APA91bHTpNfBSxmwSUkGsuHRMtql4oO0TEt14W3z6rdZyhScjslunRA9X_QPNiRCwwCgmZuChPxhVnQO4wo5msyeWMauTCf38JqBy7ejZj9N0VrdD8-xfsHHWGAxlL4rvsfaI5yjfX0D',NULL,'Balqa Governorate',32.022100,35.773374,'enabled',NULL,NULL),(546,'customer','$2y$10$fp8tprvyHvq7yT2ZhZf26OdedQyUfGWWKfghD1OeZzsRhjlRikWpG','797733016','phmust1984@yahoo.com','مصطفى ','دياب','2024-04-02 09:41:07',NULL,'inactive',NULL,NULL,'WV53+3GJ, Amman, Jordan','fiK7R92eS6iBHQ2l0BN-xQ:APA91bHJQ18J9OT6bekRXDjn2Xs4BxXGRY-oc6gGcOemBhVx53Y0jl0w6eNPdLQdyGAAFbZsrRGU_CkjLAd72TM9FFE9Dg8vOp1DSEPJzF3K-iUQ2phWrd5P8YTiUPj4ROyqO3vElbsq',NULL,'Amman Governorate',31.906999,35.852425,'enabled',NULL,NULL),(547,'customer','$2y$10$JogwK3LyQZA1TMmuYWCwLOQjEb6yP8pPKlz4YbBosFcgBLnhs9bgG','7810681320','pickum.jo@gmail.com','nawara','ardromly','2024-04-02 10:49:39',NULL,'inactive',85079,'2024-06-09 10:40:10','Wasfi At-Tall St. 138, Amman, Jordan','cdSNZRfoQfem05d_eYANTw:APA91bExc3J91uwFgebeFKTRYBtmFHRVXu1VdA9h7UH2uI_XHUybKuw3c-9rftv2z9g149wcvo-2Ao0mZRBv4n4EfZb5wI43r9MwqJGj1FhIjowC-g9OTiMs_MMqrTRlq90qP_iOmJxg',NULL,'Amman Governorate',31.989900,35.871450,'enabled','1.0.07',NULL),(548,'customer','$2y$10$PSDh36I0sMsUACCbja8gY.eKBMNFo9KxQEA67Wvc/XIpiaOHowZG2','781058132','noir05@gmail.com','nawara','05','2024-04-02 10:50:02',NULL,'inactive',NULL,NULL,'Rafee Othman St. 25, Amman, Jordan','dz-QAPo6RPiAojsqSQ1IV3:APA91bFyCqlZwhGPKnrhEJnwtIlOxZIhJqT4PHhcKQHcR5ywLOuLvv0qU3K5SGh1g_irN9gJYcWEUI5QkWNPUO5CDRmouo-57QabtC7B3aF9KyRiUtxnyMIOu4R1aC30V1Pw2P98Z5MD',NULL,'Amman Governorate',31.985322,35.867220,'enabled','1.0.13','android'),(549,'customer','$2y$10$LQhn1w4.FYd9PXMbT19VNuCLugGYU1g7HmFD3.HQ5tkuGem/iAqem','799637175','belalghazal900@gmail.com','بلال','القيسي','2024-04-02 17:30:38',NULL,'inactive',NULL,NULL,'WRWF+592، عمّان،، Amman, Jordan','fzWOf5ctQo6FDmvdvj4mH2:APA91bFwsrhL40uf2e0YAZyrBRQ-yjEWwiEY5qwk1geJot9AuYIXLNl3hVme5GKkIMRTklIs6LIbCoR6SYtSkrlZIaj-L4ABWyZs9EIbPpvWxyzclTe2YMZwlQUr7yAKbw8UnDXGZcRS',NULL,'Amman Governorate',31.945139,35.822685,'enabled',NULL,NULL),(550,'customer','$2y$10$kActN66iBzJTMhbYYTPqjOgmf/n/F4n8s0a61TDgOst5qLdUb6Ljq','786005434','aldwayma55@gmail.com','WALEED','HDIAB','2024-04-03 06:30:53',NULL,'inactive',NULL,NULL,'23RX+3PR، جبل طارق، Az-Zarqa, Jordan','e7FzxcotpEcwsWDAo9oBqE:APA91bGgZ8Vy6wxqP5Vz5_v46PVIfbyuz_yyx07U3NCfJMSuDSwdvNQfckBndGlcj11VbPS6gjLB085kAHwVrUV6Tx3yV2_sP0RA9PK7rotnT5gOqDKNLwUDLJWm8k80OimheRM23ZC8',NULL,'Zarqa Governorate',32.040237,36.099253,'enabled',NULL,NULL),(551,'vendor','$2y$10$OWokmo/J7JXMx40X8lT/8O1p.NOxJ3aAKzE7vohRrZc7WwVm1lQgS','795868911','meahalqadq@gmail.com','اخمد','ابو صيام','2024-04-03 08:38:08',NULL,'inactive',NULL,NULL,'التقوى،، Amman, Jordan','f_Tm3sRVSUqkdUoa72wNQ9:APA91bHPNGbaAY7xL3WJQf3nga75OLtciOyGi5hHr2RVcpuCN6_poWzTAzFlg89VszgeeupzIrdyZRIh45_jdYOihlh3_yOhCojPOfmwpCWTlytnVMdY2gWmd9KPSf1p8OLGQymWX3xE',0,'Amman Governorate',31.866462,35.958733,'enabled','1.0.15','android'),(552,'customer','$2y$10$GEUd5JvCaBQv8u.GFUegNOJY4XvaOkkV4J/fQjxtuhM9RC.QDxDSy','787977448','mohammadabosiam646@gmail.com','محمد','ابو صيام','2024-04-03 08:48:20',NULL,'inactive',NULL,NULL,'الاردن عمان خريبة السوق، Amman, VW9H+JC4، عمّان، Jordan','f8l_yAGXSA-n0slM7ObZJj:APA91bG7X9jYRH2LSaeX6wtNOiAWb8lSsFzHOk3_iA4Ufb5bNMqQnKaqbHDAooxfyME3CAs04GtgGNtyELpWXl-tQVJnCeMNn1ZxeKJOQSmZcbcUtqbVz2W4Zy6bcukPSAcXON0bwBY-',NULL,'محافظة العاصمة',31.869109,35.928758,'enabled',NULL,NULL),(553,'vendor','$2y$10$OlDFgWiV2IjhpO38LGASEeAQUmobndFXJvIejNtnGDcCL24g/KYja','795764645','shwaqftqab@gmail.com','عقاب','شواقفة','2024-04-03 08:51:32',NULL,'inactive',NULL,NULL,'Salman Ben Rabihah St. 23, Amman, Jordan','eGRbMapYSwuUceK1YaWmph:APA91bGBuk6K-l-DiDhChNhsxIIZDiTt0I5uWxfx0LiQc-muaL7op0NaNDN49nX6DkU7JLJTZ0NqYxj5Vkq2YLE6lYZcwJ94r4bfJ1uEXK76jAbtZadktyoEvQDRBvqRLBlA8kJLibm9',0,'Amman Governorate',31.986113,35.949076,'enabled',NULL,NULL),(554,'vendor','$2y$10$z.M7mVKwOD/4vZPfiz7cxusOHp.3TgQL55doCqFU1oKwZQm1ZmXbe','790364450','ammararawi20@gmail.com','عمار','عرعراوي','2024-04-03 09:11:53',NULL,'inactive',NULL,NULL,'VW7H+JVV, Jawa St., Amman, Jordan','ejgQoUB_SCGnzrv1Mm3Adc:APA91bGmrw7qdHA7_Pnoyz58Tr8T4VESXatPFIOIFULWPN_rKui9kF47PsER12qe4b4cFG3zVU6v0REIpx3dVxc6n_LiaNymxcO_byAa545uRArVwlhvJc-XcJx0d5ZoK8NG8WqBDLnP',0,'Amman Governorate',31.864085,35.929753,'enabled',NULL,NULL),(555,'vendor','$2y$10$x0h9s3lKeTYlLfgBw7ItmenFltaP8HFMI0.oiJs98d.BauvOZCFPy','795651578','imran.y1999@gmail.com','عمران','يوسف','2024-04-03 09:13:30',NULL,'active',NULL,NULL,'Al-Mudhaffar Qotoz St. 33, Amman, Jordan','eSN-a1S6TIeKCTYmv0JasJ:APA91bGf05MpkO0oPG-uRKTJe43W4maej1TQR96W3Z5rVcCo3jRHgR2JifyRJGK5525iCI1AAwdv0BlVIzq17qK2AdUZNvcRCMFHMvz3ZsNhvyuEv1oZU82qoqPHcJttmmMPih3rzntJ',0,'Amman Governorate',31.986139,35.949586,'enabled','1.0.15','android'),(556,'vendor','$2y$10$BGikcDH6RxD6fX651bKcAedm2TIHjAHmsac8/An.XLVRxlZCbzAYS','798657946','abubuhar55@gmail.com','عبيبيده','مزهر','2024-04-03 09:33:34',NULL,'inactive',NULL,NULL,'Abu Sinan Ben Sayfi St. 65, Amman, Jordan','f-7eQWpZQfmYeDcoqWQUg9:APA91bFKHcV4UxsCFNGmoMghPnETeWv40TCBEHC4QIkHYVr9j_AKWW5GG4AxdKogdi6oqPb_foHyw5imz6rW7f6HE5h40IVS_nkpL2JCwI68UOvFALwx6PCXi2iijffQWf7zTrL2VBH2',0,'Amman Governorate',31.860202,35.930919,'enabled',NULL,NULL),(557,'customer','$2y$10$E.frrAF0PsWW4dWZ.zezzOY1Zx/cLWZ7MefIqe9GkR3ru9AIZvxV2','780218274','ayoup.2009.tr@icloud.com','ايوب','الطرابلسي ','2024-04-03 11:11:43',NULL,'inactive',NULL,NULL,'التلاع الشرقي،، XVJ8+J7H, Amman, Jordan','dGxhUsZ61U_wkrFANsL6Qr:APA91bENpRuEqFb0xB5cM-HS5aTvElet9946auHmc8FQLcK_I-HzB3ycZ5B4oNA_5Po_j4gIUnQWm2GXE1ICesEyvvggwVTKmwvPp8JHJ8IU96yXtQlmDX5UigYdsaLp4dSvBS_PLM8f',NULL,'Amman Governorate',31.981591,35.866135,'enabled','1.0.13','ios'),(558,'customer','$2y$10$h0o5mqLZh7sDKK1pR7OouOGIBl7vdudPSzpCUE8zHy6iYp8Nre/B.','787887847','7amzeh.al3omari@gmail.com','Hamzeh','Al Omari','2024-04-03 22:05:44',NULL,'inactive',NULL,NULL,'WR7R+3P5 حي العويلية Owilia Area, Amman, Jordan','fc7IEfDrTEdln5c4GYhVyv:APA91bFobQp4mWvkHRGxYuScrB6Pot6VROG7ZAHyA9Br3m91VcJEO1J4jipqJWLr9IvZ8GatEwa4tPPAyYhKoHhE7KT4pxkb9nr0RVG0wcnzQoRlOqTBqQd_LUTnCBQtMXtE3P2YurPP',NULL,'Amman Governorate',31.912738,35.841539,'enabled',NULL,NULL),(559,'customer','$2y$10$lKAaAQpaVMBVjVpmTV3nz.zFbR11j294PPyI2yNr/rfWT4CPyUl4i','798719029','ahmad1989@hotmail.com','اخمد','سرور','2024-04-04 00:20:01',NULL,'inactive',NULL,NULL,'3V3M+XQF, Amman, Jordan','fy3rmKEATQaDltoi8VnqaM:APA91bGVtag3meikF7Z03vK5kC07mIJO7aRY4zfKz2ul9s_GB5WuIJfa8RX5-mB4nzEbYFCkDPsKtbmUg0p820UIKHvJBMAje5D3_MNRS_OadMwcerY3Yk0n6SWIPfsDxunWKy1LkK2b',NULL,'Amman Governorate',32.054881,35.884365,'enabled','1.0.10',NULL),(560,'customer','$2y$10$id0lt7nrr6fRrFdDLg2LY..JamEqg2kaa10Xrc3WzuzOmWt6txWz6','797090541','amukhaimer89@gmail.com','احمد ','مخامرة','2024-04-04 11:37:07',NULL,'inactive',NULL,NULL,'2VMF+222, Amman, Jordan','e4R3u7VpSEUInzWWjqjpmS:APA91bEQw_iMrk8ipHoO4HgCWb8gsKuyHb5sLrBngKB5ZUff3qQgeJQ6M5ujO9CVfRLFgqT42EgbAOa0Cbb4MBEAxU_Rb1oZ3IOiRCe2w6AKt0k6uERwIBAwW99ZGoevlxzCaKXs4ppn',NULL,'Amman Governorate',32.033138,35.872258,'enabled','1.0.10',NULL),(561,'customer','$2y$10$SqE2UFUefd5JgQZo75Wz9OzhfDk6V09PAErRKIn.XWkseovp9xSjy','777303011','nourpickum@gmail.com','pickum','jo','2024-04-04 13:26:04',NULL,'inactive',55873,'2024-05-02 15:53:15','Wasfi At-Tall St. 138, Amman, Jordan','dTt1r5KDS2eKNPTakvKejP:APA91bGICRiTMOlWuSstlDi0GPnqxkGeQF3-NXD_f1lZhl1EQyKhqogPWsaOYJBSAFdglbjstU1qVtpRO72p4eXDvIPAYUg-qAnyuxvaG-hoCWIMWaO-Myc1r_wzKihcf4xRPM_aevLs',NULL,'Amman Governorate',31.989904,35.871451,'enabled','1.0.12','android'),(562,'customer','$2y$10$XWMHTPq6K2bFXSfOSMF7zuRW.q9t7eXaIQtp8lcXxiLw9HNSaU0mK','772182254','Alzayadneh@gmail.com','محمد','الزيادنه','2024-04-05 17:18:26',NULL,'inactive',NULL,NULL,'7RMF+5RP، ريمون،، Jordan','eQHm_NynTm66wj8j6eknlB:APA91bGdAS_bo9MqxHMICor9gzmVfC8HTCBalcDQnkIjCqfz8o14Wn3dBrH1kcCPoALDFAOBedZH7z6PNoYqxe9uS4DlTi6i7XStd67xZRFMAeSINzcyhGJUyNggFpRR9nLD5l8dkgm_',NULL,'Jerash Governorate',32.282172,35.824072,'enabled',NULL,NULL),(563,'customer','$2y$10$BAT974AGnrx8zphjn/ooEufFokbGatXFtpGb8eIq1fG5XmDKX82/e','797090212','ahmad.mohanna111@gmail.com','ahmad','mohanna ','2024-04-08 00:56:05',NULL,'inactive',NULL,NULL,'WWQW+6HM, Amman, Jordan','dba_xS3aQvqFfTSe4m_yj3:APA91bEO0hs_riwq3-ZjktNNY1o8k4UVnAas_kKMb8eScSXC5ecZdAcOp_JrID_2Ro3CtD737PwfSu4f5ItMiMnWZZZw4m2Ym96QuFORGSXrqniwx-0eruFsHHscOQ3cbHf10MkqChiI',NULL,'Amman Governorate',31.938313,35.945422,'enabled','1.0.13','android'),(564,'vendor','$2y$10$0.as.mk8FP6ngWyCLuciL.M/U1W78WQJPvOBVmcA1hVfX49I6qdzu','776305411','karamgharaibeh92@gmail.com','karam ','ghariabeh ','2024-04-08 11:09:33',NULL,'inactive',NULL,NULL,'GVVM+392, Irbid, Jordan','dkKIdsnVQHic9sazrYpBd_:APA91bFVWOHs3aphOThC5LDgSineKYx1CbrEUDdQ5gZpTXAyHOMQfoz9hvhc0b135U_kWDg6vK_McNgFvMcmH8fFkE9k7C6_TYrJablg_j43dhxdQN-L6eq1q6kwDWRzxLQKybBzEYEJ',0,'Irbid Governorate',32.541998,35.882958,'disabled',NULL,NULL),(565,'customer','$2y$10$eEc9fuEFkbv96N4p97PPfetfFh.p5JpL69d.Tzuj0jJTazxl/XQ7u','796710741','ah32mad19@gmail.com','أحمد','عبدالله ','2024-04-09 06:31:00',NULL,'inactive',NULL,NULL,'XXP6+3QF, Amman, Jordan','dKA1H7TQNkVqkWU1yZzgF4:APA91bFyf_B2vAZF2Hj4nGCjyfYFUtng22-efMf343oqKLMz6KuLVF3q5Fw1lam2n60zWqEKcR0FFy_R2OjipTzZMM0FHoWFttf00pCgcVj5nIGOcF9IExGsI_Z_YtzLMnWFdJBVLsX3',NULL,'Amman Governorate',31.984758,35.961542,'enabled','1.0.13','ios'),(566,'vendor','$2y$10$NUonrFgmUMxxhnVMcGrqPO1sYXX9WelBFeMNI8bjaobXzwbb419Ty','789132718','saidaldalki0@gmail.com','سائد','الدلكي','2024-04-10 04:40:41',NULL,'inactive',NULL,NULL,'المنشيه حي ابو ايوب حي ابو ايوب، Al-Manshiya, Jordan','fK5Cyq0IQia-rfzrgw8hWa:APA91bHXZgC5iey_0_hZoDguUkX3nBq_D4wjP1nhlqzyzCu6H5DeCvqbvEh8w8Lj5DdaPju-gvoeByhUckQCqUQ3LRRHvL00O3G3LRWKro1mTuPJywNsCD0BnFzssPcNexcTFhGJkT5H',0,'Irbid Governorate',32.588672,35.608887,'disabled',NULL,NULL),(567,'vendor','$2y$10$zD2YMSBlcKKE/ngjZrGPnOIcbsv4buJOgbKHyGeD0U5f/BBY8tt4W','796031507','fassarfnbe@yahoo.com','محمد','حماد','2024-04-13 03:16:14',NULL,'inactive',NULL,NULL,'VXQ9+4G8 دوار الرجيب، Amman, Jordan','dbVY6kGaQKqXHQR01oXW8F:APA91bHJK6Z4ki68O3miOxqEYq7GVpTR4rwTBLC_fPiYNDU2_WkapEiDvptfPTGMmzVAsu-4OXlJMYyvkbZUW2FTE706ZxUEXAzM-B5q-ExfHZDhZ0yKA_ikB_3Bby_CtDH_mf9Dm_g8',0,'Amman Governorate',31.887679,35.968855,'enabled',NULL,NULL),(568,'vendor','$2y$10$qYMinw1BC47HmvckjwIjQO1FrRwUJ0WGngmYIw5mTo4rQ//G1/ciG','775930652','ahmad515@gmail.com','احمد','الخلايله','2024-04-13 04:26:08',NULL,'inactive',NULL,NULL,'22C8+J93, Russeifa, Jordan','fn2ASpynTPGBPqLaUF1KhM:APA91bGAIFJayfOU2Bqt4BRt0WSQ7q35lWtVNbi2uBpsBdNaW1sh692JA8yuHTQYzZEg_CEMvg4l20_G7ssPqfepZdE1ej1FqFtH3hf0GgB_v41OSlmdIK3UVtDieiEzsDcpyV_wrK6v',0,'Zarqa Governorate',32.021602,36.016192,'disabled',NULL,NULL),(569,'customer','$2y$10$3wQBzQfsA5vv54/ZFdQXwut5vz0WTaSIUrhCPsc6TibDvIueQXghK','790495017','khaled_gzzawi@hotmail.com','Khalid ','alghzawi','2024-04-13 17:03:04',NULL,'inactive',NULL,NULL,'XVGJ+4VM, Taher Ad-Dabbas St., Amman, Jordan','f_ERHjO6e0iKmBZsVyR6Xd:APA91bHbzUQs2Tr_GOG3znzHcHk5Sw37XHpC_opaVKtn-RmPU2ptjl2kkVDtQYyOOC3GMBQpX0brkjfAx29fW9-b7vBKBMte8LwtlzB0v0vCNEVBXgAkveXsZcHixdb03X0PQcydN-6f',NULL,'Amman Governorate',31.975031,35.882480,'enabled','1.0.10',NULL),(570,'customer','$2y$10$Pv7ubxvVSEgLlWBN8boihemTDNUIH7xS2yHQYGOAoJVTewRZW2Jiu','775389383','hmodehnidal@gmail.com','محمد','دواس','2024-04-14 15:58:05',NULL,'inactive',NULL,NULL,'Saleh Al-Majali St. 20, Amman, Jordan','cblt_OvdSn-erg_L9FBUqi:APA91bFWs-rZ_Un70P7USefTZZQ3ByDJN0RDHMlEvnzCdVmBTmH5CCz8ZXdbg0zmUUdV3rbBmsgyrU5Jh34XWjH2L8-Dw1ZivOs1MLA1dMLkVP10LirsZCeBuMbIm5d92FFaT_m9d_8h',NULL,'Amman Governorate',32.025268,35.873612,'enabled',NULL,NULL),(571,'customer','$2y$10$Ti/4qPUBRFt.wuW1hbkYvuNR9gwhQXe24gDAFk116R8l86UZjuQhq','797470436','majdomari853@gmail.com','مجد','العمري ','2024-04-15 13:26:45',NULL,'inactive',NULL,NULL,'FQJW+HMR, Dayr Yusuf, Jordan','fUEm1e0pT3SbWazNL5CjMM:APA91bGaPk4N-GAFGtre5NvtUubp_nT9TYl5nL_ykBDBfbZ6rrXnsC5U9RhaQvOmcKnNy7NEUghPJ0WXmZ3NGtK-w1MKxyoDjPk43ks-VHka4JltPQZt8icqP-nRqkQkhv75dJK6PXoI',NULL,'Irbid Governorate',32.481272,35.797164,'enabled',NULL,NULL),(572,'customer','$2y$10$g0O52yfI8kRYAmnyMG7alupj0CFtqRYzY6JJdMChAqTUFrMsv.PPy','772275622','aljarrah.mohamed2@gmail.com','Mohamed ','Aljarrah','2024-04-16 10:03:03',NULL,'inactive',47667,'2024-05-18 16:50:33','Abu Moussa Al-Ashaari St. 6, Amman, Jordan','faeFJlqnQEiF0XFBDMgAy3:APA91bHbkzqrUUGKNTsY5vjBBcZ4IFM_F-R8oywxp3pSIpifBW4qT6qJn-Z1F0aHx5R4bYxDjZGUYWTxf2RqGn0CGO1kKWYsPOaTY3qFLCBDafmJ3Jq1id696Ckjr4cT_XEVc6xJGVi8',NULL,'Amman Governorate',32.006268,35.864822,'enabled','1.0.13','android'),(573,'customer','$2y$10$ki0g1k4eAHiYBeqWWwdHpe45OAZNnbjVW3pKZeTGN0vBQQp1epxO6','792146361','daraa@mail.ru','محمد','المقدادي','2024-04-16 17:40:26',NULL,'inactive',NULL,NULL,'2RMG+8FX، شارع الكمالية، Amman, Jordan','dnng_at_TBiahRmh2bwC7O:APA91bEMq-YHe7zeh_bJT9-wvq0RNzBGmQShUwPocd6AjTs-7tnrfsowrwbFDL9YMtljy3bQtVvq96-ACrTOwEITKeOp0E1QEB5EUmvBFKd1FDI-mDVhYMv57JFPtU3s5ZzF7yrX5dr7',NULL,'Amman Governorate',32.033311,35.826403,'enabled',NULL,NULL),(574,'vendor','$2y$10$QLQEGgzUGj.wg3Xt/i3EiO4jn/eNe4V8TpHGaZXEU.vPv79V1/Tju','785964109','hmd799095@gamail.com','اسلام','حمد','2024-04-17 19:07:28',NULL,'inactive',NULL,NULL,'XWFF+548, Ein Jalout St., Amman, Jordan','dbNc6bRPS82viLNsJiFZYs:APA91bFne4s1V7xo6Q_uVrKt110Fvo7regdHI6Cu5rNINOByY6cd4Q2MxD8A_FlCaV_5FIVFjmThoPIHg1qMbdAh3nUVinX89iwDSlg1yeu0t8QHXkDqiM6idKKbGZhG8FeByZAFhXdi',0,'Amman Governorate',31.972955,35.922659,'disabled',NULL,NULL),(575,'vendor','$2y$10$k7UY5rjfZSrotq.O91joCONUSeGFlK1nsdoNIRyCgeQRX61YY4.UG','789325941','moh756397@gmil.com','محمد','ابو خطاب','2024-04-17 20:44:42',NULL,'inactive',NULL,NULL,'X2W9+FVF, Russeifa, Jordan','enT9EBl5QFeLYFfBmHSIez:APA91bEiXMXhEhcri5t7nXGNEODhpjn97dTV2xtFhzxLo7fGmpNx9trCyIRrncDEQT53QFRyR0admGs3JkEh-ATIylMpqjhlmVyKJny5UovJFKme28kB1S0AKUxHr9FKwYKj6-0I7RPL',0,'Zarqa Governorate',31.996559,36.018857,'disabled',NULL,NULL),(576,'customer','$2y$10$2rQW/hXdincab4w2O2jOy./BAussuAxaYuPVe8UGn09ErM1fAARry','787829239','mrwanklfone@gmail.com','marwan','sy','2024-04-18 15:46:56',NULL,'inactive',NULL,NULL,'WW5Q+9P9, Al-Hakam Ben Kaysan St., Amman, Jordan','cUE4AxlxQbK2D7XdENQyVV:APA91bG4O7rahbRoOAlWzdr4HP5vJGiBoO7TtpjnjphAk2CODZ3Qopl2hwokvVHfXpAyYBwga8KaXSGlFHU8UcjAypID91mUcmmZ_9Iw681lVjXJfXyoUiS8iZLf3VjCXXXlpexYmPBn',NULL,'Amman Governorate',31.908343,35.939483,'enabled',NULL,NULL),(577,'vendor','$2y$10$ip9ROh5NaLP5rVPcKEWdUOgDC7aCdm521bPPf8l9zhCZWhC9EAAnW','799951433','sakrhomsi@gmail.com','وائل','الحمصي','2024-04-18 17:01:01',NULL,'inactive',NULL,NULL,'Hussein Khawjah St. 83, Amman, Jordan','e2bXE_n-TuOS92tFmBAFQ1:APA91bHKCtxYJjbyWEnnNOjP1KFOjm2MHXXPkYYK-rQr0qetQ9zBaOHXKIt0V0cGgyyUQCXrL4VxLnVfrugVNNnmzW1eJqLMGnLaqPH3bz9eCWE3-5LwzKQGKZVOhUbqPRMxNSINfRM1',0,'Amman Governorate',31.955210,35.839845,'disabled',NULL,NULL),(578,'vendor','$2y$10$8Wfa/jgBnA0Az7afpweDsuJfjUwON4bswIeMkT/VOQp38L6C2bqMO','788431468','bselehmuhammed@gmail.com','محمد ','بصيله','2024-04-20 11:48:49',NULL,'inactive',NULL,NULL,'3339+C2F, Zarqa, Jordan','dlHdgLOWT42poZYnAJrxy9:APA91bH5Qm3Bp-fg4ujJSURVVdauO4yeJkhvcvJzRWBG_HwjzbsQBIjSD_bxmU8MxgYqlUZKRqq5IgqQxKWySPRplkqVDiFc1F9fsOC3JUA1Jc45B1TEZTiQbhuyqmOazpRMHCeCd_r6',5,'Zarqa Governorate',32.054076,36.067011,'enabled',NULL,NULL),(579,'vendor','$2y$10$eq26trlD1q0rkYYDVk6qj.VmZR5YiqNYls3mZgIAkek2FeMEb59py','776982368','mohammedalmasri463@gmail.com','محمد','المصري','2024-04-25 13:04:06',NULL,'active',NULL,NULL,'WWQJ+HVX, Abu Dhabi St., Amman, Jordan','f3nMnuAsQu-3VPmWuxct-X:APA91bF25V9bITY2tWtRFy5IuF7IQIC8nYBWq8RBYPerdj3PkDAyUk7jevg_1pYl143Ky_u-WCPptk4NkDM6bDSLD4NYPTpLCFAvBB3HkxXcFEGj9a6MdcrOu0DZ0b6_Tu1h2EtrZ3CH',0,'Amman Governorate',31.938935,35.932222,'enabled','1.0.15','android'),(580,'vendor','$2y$10$bFHCVLSeRsgUlFCidmoh.eOeEUv/8soPL/duQQ9QG1vcXRPHbslOe','796934663','m.fuqha1986@gmail.com','maysa','fuqha','2024-05-06 13:49:42',NULL,'inactive',NULL,NULL,'Al-Shuhadaa St. 24, Amman, Jordan','evPmB-2wTpu5TdOgemu72p:APA91bEwQkzC9czb8dG3aJ8xl8M4IvVgzKf2I0h8-lKjiEVsu20N73JPtkUXXxP67kqqLayiwxNnJ557tp2iccJBUQIhepLJBs5BkXAjnmTWi6e8jyTtkfJEaLmR-te59ecRefL083RH',0,'Amman Governorate',31.949626,35.953508,'disabled',NULL,NULL),(581,'customer','$2y$10$8K9zksvJihq5m9AKDbO2lOVLft2rpuHuByjEC3.Y1YULgA73fDrmu','796934663','m.fuqha1986@gmail.com','maysa','fuqha','2024-05-06 13:52:01',NULL,'inactive',NULL,NULL,'Al-Shuhadaa St. 24, Amman, Jordan','f7sT7GZHRuaj0LuFuZZDf5:APA91bGh5oCJte_VEiKpYf0V8O3p_wX9FHWefwc5a5_-fqQ0xYJvfjtXLybcJcZz0Yy1WT4q0uxuf5r-Q9Vb63JqsJuFYpYzsna2tm8OOUz4WvvQOWPVrGQ5HfQE_QtxCsQfDA3-r24b',NULL,'Amman Governorate',31.949748,35.953663,'enabled',NULL,NULL),(582,'vendor','$2y$10$QrYNhfIIV6kSl2LjqNAaOuZbUfpuEixmDBwcb3ZUza9oWJRex1OAm','791579812','abdalkaled92@gmail.com','عبد الحميد','الخالد','2024-05-08 10:57:48',NULL,'inactive',88307,'2024-05-14 13:45:08','2RGH+X7, Amman, Jordan','fJ_2dbzST6yAbnHelAqePl:APA91bGLvEANMXBdo90m6ZARv5QZR24bs-QP-qGzZiY-HSCwrgSwo4f2BafQeOpEctIeJGFl04J1pZJejb30wM6-1eniKxi1fte4TJHmqbLfi2rRUnqhbeSwN_ywVgA7r-eGbFJlW93H',0,'Amman Governorate',32.027807,35.828873,'disabled',NULL,NULL),(583,'customer','$2y$10$OkyYKF7jG5dwn3yeVP02iuMDxJv5dxMUFn3vPRPzlnqQLx/x7SNrS','782255169','jmtabwghlywn18@gmail.com','جمعة','ابو غليون ','2024-05-10 10:43:16',NULL,'inactive',NULL,NULL,'VXJG+JP, Amman, Jordan','cdnWCsZSSXGoRoC7wzPiUU:APA91bHxE_gnOquIPcDUmALjGCGcmi9Vebhq4MGls5ahebVZZlG40j7X9uItQTFhLsb7bhrXkNiUuyZwmTGx4IIgAkUu1wIWo_bAn9IPt5pcWe4pySb_w2R85abr5-TiSUM8oMr0MyLm',NULL,'Amman Governorate',31.882019,35.976704,'enabled',NULL,NULL),(584,'vendor','$2y$10$OoHV4vMLHAxX0qR.kViPf.fTkyaYnMlrWBz4fxBV4o6dpOSa2KVpS','799040529','rosses200830@yahoo.com','امل','زعتر','2024-05-17 12:17:11',NULL,'inactive',NULL,NULL,'2W5P+MQJ, Amman, Jordan','d6qytromSweQKN3jCW3cAv:APA91bH0U12d6flE1LEJJfRG91mLSh1hyAYGq2ueV3R0fUl9P5npi_c9GD8n0a_GlPodywQL4EwjtWzWJ9MNIW7iUUDxymvlL8Ze2uZsSBgdviGArKgaF7IfPrGGg656qUEGBD0rw5-e',0,'Amman Governorate',32.009368,35.936921,'disabled',NULL,NULL),(585,'vendor','$2y$10$Nc0y0YxTPTIMuSWH.HNV4.GJ7AT.ip1b69RuchN47gE0R0IYPMjOm','795834261','bostanji2018@gmail.com','حمزة','البستنجي','2024-05-20 07:35:08',NULL,'inactive',NULL,NULL,'Al Waha Circle - Ismaeel Hijazi St Al Rowad Complex - 1st Floor, عمّان، Jordan','e_nJNNg5SHieeh3PRPec_G:APA91bFq_3kLlsRuV_DfXwn_HJfuxSbRTOLrQSmVb9VUR2pZcF9xhafu3hBl3wxjqtyxNYCqOITz6ESCJgynctSYaqRFeUfSlOPd3bB96ov7Fwkn55-sMcZPXp1wGJWcklU4fXkFO4zP',0,'محافظة العاصمة',31.986544,35.868105,'disabled',NULL,NULL),(586,'vendor','$2y$10$1eqsx5uMNXHQ.dqdYiuG7O0s/2orxRGzpHzqAdXsVtb37AIbwSPyi','796429121','akkad.st123455@gmail.com','عبدالله ','الريان','2024-05-22 10:31:09',NULL,'inactive',NULL,NULL,'الزهراء،، XXHP+5MQ, Amman, Jordan','cZaGFXIHSxqrcMQSK9RRJf:APA91bEaJFMYyZ6Li5C86kAQ-PqNDDAzi09uerx-3O49L3OBrG0aSTwi_QhjsZF33E_g7tcdBzljMJpG67AdPX-MKg_SzLoI-UpTBjqsH6VPeLbOp7CDFpFJyClbSCsdCy2u_T7Pe60X',0,'Amman Governorate',31.978324,35.986825,'disabled',NULL,NULL),(587,'vendor','$2y$10$x1H.lKIkARn9ZsKMHSyoaesd/iQud75dQnBVdWKEyst9VuVUnWL5y','797007845','aldwan801@gmail.com','ali','khaled','2024-05-23 04:36:39',NULL,'inactive',NULL,NULL,'Jamil Taher St. 19, Amman, Jordan','flHJPjIsQWCtUs0nkghcGw:APA91bFN_ok9xb61Q4qKwmnMUK6o_n94Q39iTA8zI-gyQjEwucUwSzd2_KZM-8plW5pI4EWeD9aUFVk3GV_FaAGyo4V8_npaZSAI1rhjAB0zk0OLWrCRCcB_oH_jj_HWMBJUvMF3HiBb',0,'Amman Governorate',32.015499,35.915860,'disabled',NULL,NULL),(588,'vendor','$2y$10$50Qw0QFGB/4RpLqkTouaEe3S0UXfLy9BPfhvBLOWPRnJY7iGif.uK','787648464','khliefomar3@gmail.com','omar','khlief','2024-05-26 16:50:04',NULL,'inactive',NULL,NULL,'3P4G+PF7, As-Salt, Jordan','fI-MFDUMQyGrA1Br5qbY2-:APA91bHmuSbzclWash77nvLDMem_B5DsrN2Xuq6eK0OSbaHGBHdQIz_7rINu8FDeF7RNE24c8WQnoZdcEGDDp_9Luh0rarq8R8WNats6V6tg0hXBwgWLMxKz3gsi91xwXg6D5oHBO7oK',0,'Balqa Governorate',32.057339,35.726818,'disabled',NULL,NULL),(589,'vendor','$2y$10$NPBHhStaVLj7AkIrWQ7a3.kvspD2Xzok4h/6oRAhbjDIw6HALdk92','795268492','alqdodo8@gmail.com','دانيا ','القطاطشه ','2024-05-30 12:05:52',NULL,'inactive',58652,'2024-06-01 21:23:27','RJQ3+M2F, At-Tafilah, Jordan','fyZ23esySMe-1rz_E3ol-n:APA91bG3Qdf2MhLdMi6jJmVO2NZXfE5piOUGucExZFF8gnWeQap0SG25OHST8frdRRVPmw8J8gpEJ9e264wY9t0elBFfNAq7RFm4IEzC1OYR205FG5oqfBVv-4le6RXmh6Z2ltLmTPtL',0,'Tafilah Governorate',30.838513,35.601844,'disabled',NULL,NULL),(590,'customer','$2y$10$iaFtBGwfLfZetT4HaTL.s.YV2Ipqrk/6XdpRxcwH2D0dCo1YNMA2m','791586203','dawoudt@gmail.com','Tariq','salim','2024-05-30 18:27:12',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','evJX1Z6pTRKHPAkq_d6Btr:APA91bF-dgResFG4zMS9VzqTnUNDgBOL8JTYC_vlICsChJHZc9nIkG7nP9p3CeLC_53NdcH4_JwuM-FpsktkEDa_zGwJ43OCputhM5ugFaeQQvLHPD2kq1PnsgXAJXn-QPnpKwRAfa6J',NULL,'Amman Governorate',32.014048,35.865291,'disabled',NULL,NULL),(591,'customer','$2y$10$I3j72IUL1j54LvjhfOz1UuXkHagDgqES5CzogqXKgeW4AVNjux8mW','791110188','dianabitar55@gmail.com','diana','albitar','2024-06-02 00:58:58',NULL,'inactive',NULL,NULL,'Damascus St. 95, Amman, Jordan','e1bobDxSQkwkpzJmckGeWW:APA91bEaqU37_jyeqCur5P10HpACDcVhWPwhsMxLulVo7AN4MpJuG1q5K2XO-0evDVcTZDITMefZZSQDyutn4MVotSy9Yvm4iHhJznGcijPZkItcqg_VsCi0UutkVTFMAcVmd01FWzJ-',NULL,'Amman Governorate',31.940379,35.905076,'enabled',NULL,NULL),(592,'vendor','$2y$10$szuDOvclyP7Smd.e8yFZouJi4PB6oKySYowSwdwaIUtI1EFBF.Ary','780135675','mhmwd55511@gmail.com','ام ','معاذ','2024-06-02 09:27:28',NULL,'inactive',NULL,NULL,'335F+52Q, Zarqa, Jordan','dLiwbGX-RiGb-il2_j3B8f:APA91bGOl9lvWzFgBjYtxKDTQjpxKfaIY3FcKQUVkb5S3VUtQqfKcELS-M5cLDjqPjyy41UXjDxiqhBAMUiVwVgFecbfKQS1IUlXBFKG6nmtYjHPPLzdP6ZDF9u8E0Dvbj12xAHXbh2G',0,'Zarqa Governorate',0.000000,0.000000,'disabled',NULL,NULL),(593,'customer','$2y$10$A1lMTukcinmkuCzrKkoQaudx1rROTiv5BS7qALY1bIp6lQcAYxVYG','797093540','raneemhamdan244@gmail.com','raneem','fathi','2024-06-02 15:05:59',NULL,'inactive',NULL,NULL,'VVPQ+7QW, Al-Bonayat St., Amman, Jordan','fCpAjgckoEyVmfo3qr_Y1j:APA91bHSviBGyCIJ5chxZvGgNpb7kzODIE7cJgnX5wXzeU49RmRBkcMtxMdH23QN98Nk-GpeK6_5WBe4d0hT_B5bdR1GBv2jommxvNxDg3JTryK3wP3lWWhPw3xBLbWLi5yNnOjJW2UK',NULL,'Amman Governorate',31.886102,35.888911,'enabled',NULL,NULL),(594,'customer','$2y$10$NvnEnz4B2dCXqiE3N3B6vuua./Xv1GKoS2SEnL3BPLEOfh/HpE4eO','796208280','mdawoud690@gmail.com','mohammas','dawoud','2024-06-05 20:39:13',NULL,'inactive',NULL,NULL,'XRMR+CCC, Amman, Jordan','d4cwN2Pg8EDctKPX6oWZ-b:APA91bFWimC_4hgVc3E_aqKd1f0tMCaFP3dJxtm3ksLUVxUuGSixnWuE_Pz2IgN1L3YIidLPkGhzEkenxUD4_3lB5ZFMSWq6ZSgloYKiA9NmVhx_IrPN45LgGd3Jel6S7Nq2mA7GfcJb',NULL,'Amman Governorate',31.983071,35.841059,'enabled',NULL,NULL),(595,'subAdmin','$2y$10$nryqf/jG4jkiTlVeF4i6SubX1aps/BtKFlvSB1xyX5XUuVHuUayey','776424161','kazanmerched@gmail.com','merched','kazan','2024-06-07 10:01:27',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(596,'customer','$2y$10$83OvOvwaMwxQdsGValHrSe/7lqveVGnt2qzuIllT87N/p/hNRoKnq','782303051','youssef12zaineldeen@gmail.co','جهاد','زين الدين','2024-06-09 09:54:52',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','fecAHcMLTDiT1AN7zzKx3V:APA91bHo5KbfPgL39EoNyFhMsTIJcRLcrWvWboTMwRWlM_j0nlKrMWwG0KqTnu_A1B_4pQz71filfHtW9vHQoqxplVO-RiRqLCNaQ810SHj5jOsFkiONPdHFF8oxThKLMqH1Qx0-ANfQ',NULL,'Amman Governorate',32.014313,35.865381,'enabled','1.0.07',NULL),(597,'customer','$2y$10$vILkgJAMhvs88Ykoq8n7peWduXMFYT602uAMkANGVi0s4VmGn6J.m','782303077','pickum.sales76@gmail.com','sales ','pickum','2024-06-09 10:43:53',NULL,'inactive',NULL,NULL,'Dar As-Salehin St. 1, Amman, Jordan','cgObPTZMSvq8BKSFyq1RDO:APA91bEl8kzquNs4s-OOXkcGl8XGqh_LGbKAARFF8rYLcl-lu_WgOs05slgljfxcthp9o2rTjs6EBtv4KgheMQ472OYT-_1jBAlto-dnexySeBrEnxJZhbbXkX3rTjj9r4yS03xMWtUn',NULL,'Amman Governorate',31.976890,35.843678,'enabled','1.0.07',NULL),(598,'customer','$2y$10$QLH9XV8rRptuNtMlPPiGV.3Vc7PACRd.2UEMv.K9cMS65eXfFhzVe','799006608','fawzialkayally@gmail.com','fawzi','alkayall','2024-06-09 11:56:21',NULL,'inactive',NULL,NULL,'XV99+MV8, Amman, Jordan','faig3vtxokdIhTjpjYF2As:APA91bFv0zHQkZeqbW_vvMf7ICugjpOL43mRLzCkk74qs4oP5r1CGHSHscvYEsIeg23TpAMspD1KQSX4WhnSJCAex3xBlxXPprH-3KtuHqCyCj5OWMgqZ4K3M_6AWfCO_QopiVbrCwET',NULL,'Amman Governorate',31.969245,35.869822,'enabled',NULL,NULL),(599,'customer','$2y$10$OXSYHIe9CBCbSxEUDLE1Y.WS/xc.WHOl31idJPpCVpg7Tzd6U8YWu','790551555','faressamarah@icloud.com','fares','samarah','2024-06-09 17:12:01',NULL,'inactive',NULL,NULL,'VW68+79W, Amman, Jordan','f6oJ7EHwQdWQh5b15HBDLo:APA91bG9EVpJJNFtqyfoAXut0J_qECqcC9ZppHriKGsIf5qYpULtU3Tn2t3vh-qw1LQLZu_9CfbcdvXAQ_OZSRBSH7aOdIIC2iPnQvds8qe21LZRGqfyXnZ0d_r025gybz5o12fQHPFg',NULL,'Amman Governorate',31.860292,35.915421,'enabled','1.0.10',NULL),(600,'vendor','$2y$10$cK8./Z3pzOcSLhgT27vvbu8SFJrzsoyq6TmhShhS5JW/USurWLLMO','1111111111','alaa.alzaibk@gmail.com','alaa','alaa','2024-06-13 07:05:07',NULL,'active',NULL,NULL,'QW23+PG Deir Zenoun, Lebanon','dJrA4ApyQAiYhoj2erGnqR:APA91bHPh01daReijLN4JYz53GoZEnRs9ZXPs3OXcnLG2-CfAL8Tmi1WKctjmR2eR74eaVIkBKckieEFqO7mywPyXJ1Qo_n5-UnOPCbFwGuTA9Uo73E3XC5hlOjXOrQaKaGcCI-Eubqp',95.5,'Beqaa Governorate',33.751874,35.903800,'enabled','1.0.15','android'),(601,'customer','$2y$10$mGP/KNjv3xZi9O3kSepMsuv.AZZ1QYvq4EE/HaKVxjlJxf9e6xEK2','777718616','hanan7191@gmail.com','حنان','محاميد ','2024-06-13 17:44:20',NULL,'inactive',NULL,NULL,'WXFC+WCV، عمّان،، WXFC+W49, Amman, Jordan','eK-qnFSkSJi5k7Ryea33cp:APA91bFlVP0CJqWZDY2ov55KQZvn_jvLIA7cp_eCTxkbn_iXH7KgavZg9iQDh9C-lwTl7Dpg76L828bSDTIxT3YAi9Opkp_2y4DrWcFQEiNGKSRvpXNk2k1B7-B3C4Lp1kQ4jtoezreq',NULL,'Amman Governorate',31.925161,35.970061,'enabled','1.0.10',NULL),(602,'vendor','$2y$10$C.YJ5TuHZLGM4VUB7hv.Ku8CXNZPPmh7rGoAa.oKRbeZA6PY1flTC','790069579','Yaraaldwan96@gmail.com','رهف ','الهنداوي ','2024-06-14 17:57:51',NULL,'inactive',NULL,NULL,'Muhammad Al-Hussein St. 7, Amman, Jordan','f38W3HgZQHCaDetRPJMyrr:APA91bGFU5wj_XuBCJMoibc3DuFUKGrsQok8iLvmQlsW2UxJ3-7LUcttSBRT9zFGqprZdh0WXxmrbzD_pc69KjiaNjRD28poPNG-QybDFhNPTFv_r_2pVOGIUS7cGpU2P2pLdfdo5U62',0,'Amman Governorate',31.949448,35.940354,'disabled',NULL,NULL),(603,'vendor','$2y$10$cagwxg7/ek4v7jHPjmezmeqCUXWdr3ohaIBGjG9FOBF6se7jlU9Je','791148670','nasermshmsh72@gmail.com','ناصر ','مشمش ','2024-06-15 18:04:21',NULL,'inactive',NULL,NULL,'Abu Al-Hadhil Al-Allaf St. 12, Amman, Jordan','eqPjFjmwTnaUdlZC415yxw:APA91bGmyA0D8phQFLOSEmmZMk9recUxXUSiFQLnIWjKdOq92dGAfJmaB00OiJIxUXhjKaBhR7PE62OXRNc8O7N5AajFwAQE3ncmIDLASjCh5qJNbRKfxDIg43YpIx1l_kNSIPvYkhFm',0,'Amman Governorate',31.913507,35.922340,'disabled',NULL,NULL),(604,'customer','$2y$10$WkcLgxUBeZVc.fvwm6jVlunRJfoimeepdk6hQdQ8eXtIC00cxgOcK','799209821','samaadnan90@gmail.com','sama','adnan','2024-06-16 14:00:27',NULL,'inactive',NULL,NULL,'Thumamah Al-Ansari St. 11, Amman, Jordan','cUrLn-j-iE9wr8fPmjCxxB:APA91bEP8TrrQtrKdWsW--xa3MsnJ1tEfiJf8Do6NuZx32jhtPRxnQNHHsf1FcACLBySEd9mcrH_q4ItCbXz38CQQyKE_poDITN-28S79RtffktUF2M1GDS6rx0S-ixYLOFf2v1IMHCu',NULL,'Amman Governorate',31.996847,35.876714,'enabled','1.0.10',NULL),(605,'customer','$2y$10$EsE/yjiT5ryJbq3yiaXK4e.EgFLXxKwVJNhF75keVZJhOoLlrKOk.','791019548','ashubita0720@gmail.com','د. احمد','شبيطة','2024-06-17 12:06:45',NULL,'inactive',NULL,NULL,'Zeinab Al-Asadeyah St. 27, Amman, Jordan','cxYWzG5Y8kvig1qw8EAT3j:APA91bGB2pcoYBFULnOuaW769QyGJWkKo1fo0ukWXuS7JaN2ghgZlEr_hETYJ8g_Sl9s81TQb90eKBW_zK72_0Z8XtozBrEaYifLVsWnD45kV2AwA4Th_1D6QUBkvYNR-64vlmAHuSh7',NULL,'Amman Governorate',32.018394,35.881031,'enabled',NULL,NULL),(606,'customer','$2y$10$5Cum7hyouoXc7rF/JrhT5OENljXI3fLmDR94GdT8r9Y7sb6SZKAPC','788384313','muhannad_idris@yahoo.com','مهند','ادريس','2024-06-19 13:15:40',NULL,'inactive',NULL,NULL,'Shafik Irshidat St. 2, Amman, Jordan','e13pphAXT6CQ4fmtmNMrjL:APA91bEWAs6AejxwJUCzagNOPjNtwNkUiUT4dh6zLgyr6VCJmUO4WzR4gYnLwIHhFu_x-U82Vnev9K2qrxDW3oZJkpj5sV5wvzb3YUv-krnldNvwwHVdi1U_W3Ka-ls8vV5VuIGhl3WH',NULL,'Amman Governorate',31.986034,35.943074,'enabled',NULL,NULL),(607,'vendor','$2y$10$3jHCqB1Zz88Q9oXNQgB4OuYgh2rzQPCQaIe.BlKPQWyzm0hltIKLy','778905924','mmmvhvdhjk@gmail.com','Muna','Al Saud','2024-06-24 09:24:37',NULL,'inactive',NULL,NULL,'HQQW+8F Malih, Jordan','fAmcji9_Tw-8AWpbPUCBE9:APA91bFoWS0wIAxnaajFECvIwRtkHlRfbMmqkq_OD6YKbKy_9McvJ0UCnDBQc-qFpsLnsj4v8OP6-H5mZn9zfA7IK0gen7hmXb06qa29BvdtCcVWx_pDBSNUuru7swXha5QAJJ-8JEdp',0,'Madaba Governorate',31.588318,35.796190,'disabled',NULL,NULL),(608,'subAdmin','$2y$10$JH01HmpplXmBJx562dGC0O6ZCHqj1y4MO4Hm2kjC7eZzL4o/hZGia','782303077','sales@pickum.jo','ramiz','nafaa','2024-06-24 10:00:54',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(609,'customer','$2y$10$WSkz4.FWC22e7y91FPLfae0TmSnxbnn7RduOCeDw1/XZM5iVzq85m','797023732','khaledghaith40@gmail.com','خالد ','غيث','2024-06-24 12:12:09',NULL,'inactive',92384,'2024-07-24 11:12:39','Wasfi At-Tall St. 139،, Amman, Jordan','dLru6nRGT4yimm0PIPSOKv:APA91bHuJ_Un_L8BPl1gtcevqT3d3cggccGfgASkq372Z8poXexefncDJTgyE9YvRPEkdw6bXIacFeVnzs9CTqMXaoG96sXhZstjEds8U_vqq7rqwbnUqIa9XAo3ppNUhY6sAAWWPbFz',NULL,'Amman Governorate',31.989886,35.871409,'enabled','1.0.10',NULL),(610,'customer','$2y$10$iuX9NQj1BDU4YGbIDek4h.z4lguBdRvnkZLsQSTwxeTA6tumrZ/lG','799795316','Beboo1995b@gmail.com','Baraah ','Alkhatatbeh ','2024-06-25 08:17:50',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 139،, Amman, Jordan','dpy3FP82S3CVfMNHasnO3I:APA91bGTWyn68l_Di53hYnIImUA4x_kHle3iYBsEuRuJetiFiw2WZGzvzY4N1TWSlVErPkljkKZKTWkiF7vqfKbHAynUBCbyo5QpfCz3SDDHrxdkv6uwqiN-cgxjICgMY0Rvn-GY_Llu',NULL,'Amman Governorate',31.989878,35.871416,'enabled','1.0.09',NULL),(611,'customer','$2y$10$/3IaYkmcqBoCQGYg.3MuiOg50Jv/OAsYqVAhpSoic6nmR4PvXT1i.','795294254','wqasem64@gmai.com','وليد','القاسم','2024-06-26 20:40:43',NULL,'inactive',NULL,NULL,'XWJV+MPQ, As-Sidi Al-Musaed St., Amman, Jordan','c5LrKhoBSX6a8Pqs5hioKo:APA91bFux_MVN5QW8m_jvPny6j4xOFCS4v4uMuY5N6CuvllD84Ki0fjYg94lvbww--YFLY4n_4gze5evngY9bH7YMnwT3NvfIfdPeg94BdvUc7_SMycN_ZlSiGIrJmBk3ngKIAHwK8Yv',NULL,'Amman Governorate',31.981789,35.944364,'enabled','1.0.09',NULL),(612,'vendor','$2y$10$1gnU8EoXizbzlxRXKWXS5unrqMCJ6SDYg/ew81DB11dGK3Fe0DPMW','796442728','ahmadfayiz521@gmail.com','احمد ','ابوسرحان ','2024-06-29 09:58:22',NULL,'inactive',NULL,NULL,'23PQ+W82, Zarqa, Jordan','c8WIjvYETIa6Id61KINuC_:APA91bG6yQAs1srgix7YtwELw8loKS_QbEslwEsj4xTwqhxuuKwmGuesOqne56rLqBB5H1Fh8hIHL_fC0ANhgdGSngoZQK-bKyis-4ZZO5LNoihEBvY4cve11Y0CsaO4iBjYwT5oUme7',0,'Zarqa Governorate',32.037254,36.088852,'disabled',NULL,NULL),(613,'vendor','$2y$10$NhE3sVNv/hMK95O74PzDkOgINHb00WrBt5m1BWjuRrAdojyTSrsly','798042094','abdulrazzaq.wwe@gmail.com','راكان','الحمصي','2024-06-29 22:18:11',NULL,'inactive',NULL,NULL,'Hussein Khawjah St. 83, Amman, Jordan','dhFk6v3BQ3C-aFfGn0isvS:APA91bGN605fHRs6qM-8FVwhBU-ZW0AJB4WkNqIXCTUWYqmMqkOHMdRX0EvVM4Vwo88XcR8x-AoeEqjxyNe0P94pRmtt2dy2jRxEZGX3YNXtCmkGJxTreMIr2BFFWuWw0mReplufG0na',0,'Amman Governorate',31.955265,35.839818,'disabled',NULL,NULL),(614,'vendor','$2y$10$WSkz4.FWC22e7y91FPLfae0TmSnxbnn7RduOCeDw1/XZM5iVzq85m','797023732','khaledghaith40@gmail.com','خالد ','غيث','2024-06-30 12:11:18',NULL,'inactive',92384,'2024-07-24 11:12:39','R2HR+MPH, Raiit, Lebanon','cX4vDTb0RXiVR8RfpDnik8:APA91bF5HSkFQ2BBseSyZIL1utCyh8PPUkgnA5u9CtXhtcnLniYhxYcvmHjguoQOHRMjIbj1ev1qtdUNneUq3QI98xGnILrhKBd_zo50xW_Ujj3777Wl2ihNN-WlTYLnWHqpOxFf-zJa',-22,'Beqaa Governorate',33.828942,36.041705,'enabled',NULL,NULL),(615,'vendor','$2y$10$dnGQpBMgBQbwZgBXJF.DhOzo2ahxz21D/xtAji2YIZBPskm1V0jMK','781875711','wdtmqbl4@gmail.com','عودة','مقبل','2024-07-01 08:48:04',NULL,'inactive',NULL,NULL,'35، Jordan','eGGCdzCsSBO9zZu_XJHAyp:APA91bEgz5SoazMC69g_5OPrBZI-9ET82YreoAn4KMGTnh6OTNV_p0HBXDt_gl32OMPtxQ0b2eVDiIw9K8gVOUEnY3CUsVhLWpvW65Y15xRclNARMwgw1-gHZk5GgFfM0MKBXyBDuE4S',5,'Balqa Governorate',32.064067,35.838910,'enabled',NULL,NULL),(616,'vendor','$2y$10$yOvhVaTO5f4PR6WTHgi4veWW46Cpv6DODR.2ImiLPgq07N9xB1oyG','792198797','faresabufares@hotmail.com','فارس','ابو فارس','2024-07-02 07:17:11',NULL,'inactive',31248,'2024-07-04 13:50:46','VXPV+489, Amman, Jordan','d_aG-4ByT1mnKcPgSJHXVq:APA91bFbApz8GiR-rTSkvhBxIKeXxf_TD-MaX7n2PRbI5FvtzsyLltp5cvj3Xgfx5q1Cjy8BVj415DKcwNbNY5DlLb8UcNYCHdu8FSpXiRVIFpdkRMz7d4pkE9GY1rsIV5O1MhkQSytx',0,'Amman Governorate',31.884601,35.994617,'enabled',NULL,NULL),(617,'vendor','$2y$10$VdjDbHEe0buETdE9emRJZOMK1rm..s7bxwEXmwI7KIfjadld8T0ba','787397689','alaaalabed1977@gmail.com','علاء','العبد','2024-07-03 11:43:12',NULL,'inactive',NULL,NULL,'WWVH+QW4, Amman, Jordan','deUYa-J1T4KYsxdeyo2uol:APA91bGqAnABI6Fz2GXwK8BVOggP5PuIUlviuaNM6ZWAQwqHu2AukT_uQ9s2hrL40fGVU55NKV5aU5BMUwQSFBg6L0Hr5qDhdrbVCY0cAyO_k5l_lJzEjv1QL5nDx-IExEVU0O_yBlK3',-1.1,'Amman Governorate',31.946173,35.927860,'enabled','1.0.15','android'),(618,'vendor','$2y$10$5mXe7WH9LrnJHbJ.sJndI.DzAiO2BYLvBRMMesshmFPW4Po.GgL9a','790066575','zaidmansoo1234@gmail.com','زيد ','منصور ','2024-07-04 11:25:23',NULL,'active',NULL,NULL,'Al-Muradi St. 14, Amman, Jordan','c7H_4GNbRYmkJxPpS66pUM:APA91bH6cR-2UK55MVgO9zmwAvp2O_31kRPL-yISbbsTadZLO0mxt1GunpExL7YHhoNrS91h9MY0al1qPVgbF7lxcjVEhWFoeZSf_aj1Sbixjs8wG5P0FlvnmouNOV3emhGttiyCjjvj',0,'Amman Governorate',31.991493,35.883372,'enabled','1.0.15','android'),(619,'vendor','$2y$10$kEYJUQKYv677cJJPKT4s8u5hLp4zHl0yINTUUNrlK.09x0lEcEcuq','795101170','mohammd.alzube20221@gmail.com','محمد','الزعبي','2024-07-04 11:44:06',NULL,'inactive',NULL,NULL,'XVMC+383, Amman, Jordan','cIObCKs-Tv-G3hUldq-wqt:APA91bFoMwX4rhR5aXBXKFp33f660lsxsf7IpFDQLxGi6AGnqK69Ue7U1N2hIGk5fnI1rzn2RMkejbLxbgGeJkvybU-kh1w819gnrGqYYp0IZLMh0MWqBML2r0KJUGq0qiyDNROuN6_R',0,'Amman Governorate',31.982791,35.871008,'enabled',NULL,NULL),(620,'vendor','$2y$10$n.WdH9tYcFp1.wtuOh3G2uvbMi37U4Go48KxSV..P8mEiwWAsHQu.','792860028','mahmodnasrallah93@gmail.com','محمود','نصراللة','2024-07-04 11:58:23',NULL,'active',NULL,NULL,'Khalil As-Salem St. 72, Amman, Jordan','dD3Uv7ytR1q-YgW1NAVAhB:APA91bHT8uNatz2AtaWHzO1_9uIZuBmhB4sD-etoDjWTl8teDmd5e8yQ8V7BfqXyzN7gCsXbsci4huOUhMLUHwFBQxdnpMl5G7rZVrzjBlluPnNKEuUULcq3CCsd5J7B-adQzUs-b9TK',0,'Amman Governorate',31.990693,35.977019,'enabled',NULL,NULL),(621,'vendor','$2y$10$dYgkTKA8M9MoGWJxbNriQec6yNnj6VAB8zlAzWjmyoFA/XRTXpmYS','799966451','Iyadbrkt@gmail.com','اياد ','النتفي','2024-07-04 12:17:04',NULL,'active',NULL,NULL,'3V6G+X58, Amman, Jordan','eIjkeE2zQXqtHBcRPLmQZQ:APA91bGcYRe2UolHdYoLg3Oi1ZO7DlAnzd-vsEUROwuaC7i5Krko0iuA-odJrXHg4jH--gb_gWI7ZclO3Ls25vCD2p3SHsnHyuKv6XbyQBl5k8rj61vQz0PoMGRfPHtq-DGOHRb7GsE3',5,'Amman Governorate',32.061803,35.875295,'disabled',NULL,NULL),(622,'vendor','$2y$10$ZCa3f.hamGyyts1KpbKhOuousLlG1WtzbkYz2BAyVssfb9ped8kUm','798052340','mahmodnasrallah93@gmail.com','حازم','خلف','2024-07-04 14:07:51',NULL,'active',NULL,NULL,'Umm Aws St. 7, Amman, Jordan','c_YJ-qraTTS2kzudJfYgDl:APA91bHrH5uaLpygqXnIcR8et3XB8G-n3NSqpY0vNh59SRGE1W7xEal36d6hZAabdVqXIibuU_B3sjtwNdopQDxogImZle7IwevjOnrXX87L5j5PPOLB-9AN9XRC_Ay6LbYRLSY5xcu_',5,'Amman Governorate',32.003556,35.856477,'enabled',NULL,NULL),(623,'vendor','$2y$10$6kicdSVDgMlzs2FWn9NzLu5.7ikplNwxA3Qlx.LXENraFLHTme13K','782956223','hmydtmo@gmail.com','محمود','حميده','2024-07-06 02:05:34',NULL,'inactive',NULL,NULL,'3RFV+GH Al Hanou, Jordan','cldhA8-vQPSDk052NGIkcO:APA91bFpElJyBkOV1FYyTuLbfKB6sfPX1v36Xd9rT8huJrOqB8VgmzUq3mRacY-bAzbeSsY8NbbysvhbRRhKY6yZXdrH1IA4A1NMU7BPwb6TFlRUM3YMQsEFnzquJJOXdbawWvbrzluU',0,'Balqa Governorate',32.073793,35.843939,'disabled',NULL,NULL),(624,'customer','$2y$10$yA6jRR2fqC6ODEVtOJyYKOW/flJLYqDayWPvwjRlzCzNZqsPyZo96','795115155','wesamstrikers713@gmail.com','امير','عبد الباقي','2024-07-06 12:37:28',NULL,'inactive',NULL,NULL,'Prs. Rahmah St. 4, Amman, Jordan','dIcH4WHgNUgvpi2CUfIQ2g:APA91bE4OKm-dV_IpCo39YrseQdj2__W8kd50RqfjyvEc_iAsK4giTFMpNkjaMz8jjlSxRQVap0Gna4gKtAQifwNv0H7wvAMhnJ0fbKYr65iVd55ITQnfi68jK_gCngJsvsDGQaQZ5As',NULL,'Amman Governorate',31.981990,35.863048,'enabled','1.0.13',NULL),(625,'customer','$2y$10$JBlzJXLJHI7fIW3Wb9d9peD.rHF4vVCAJjNpOYLYXe/C7mybv9qdu','782197831','hamammahdi91@gmail.com','مهدي','حمام','2024-07-07 04:30:50',NULL,'inactive',NULL,NULL,'XXMJ+RHJ, Amman, Jordan','e3kuI0CCQ7iV3moTyapqjI:APA91bGUjSxKESpCNfTYoSkoNHURfS2iOhAtJaZxGL0yXb0hXH2u1BOFPxUv23XHJ7y95r9zvwhVaT3B6VSiOymBvRNUg-vjX4TRuFzMqATrlCSwJddMJGTslr-NDYonXpoF9OEAlzCp',NULL,'Amman Governorate',31.984546,35.981434,'enabled','1.0.10',NULL),(626,'subAdmin','$2y$10$2gNl0YSsj9GHseeNUt3lxucmQ3zG2yi02lO7qFt1tyghvBVmYCioe','776197081','Alaa.alzaibk@gmail.com','Mohammed Alaa','Alzaibk','2024-07-07 18:05:03',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(627,'customer','$2y$10$R/2Y1mrlSGhuQoNEYsNhR.26RYyGSOb5R95LKHKWhYl8DN9hpJp.m','797899145','mallekh.maha@outlook.fr','osama','rimawi','2024-07-08 18:03:45',NULL,'inactive',NULL,NULL,'2VH2+6CM, Qays Ben Abaya St., Amman, Jordan','fu-LfQ9e80whvg57B98cmg:APA91bGyZEVLLPuHWEcWaaD4I_hvST_Ndm_3SPGwlZ57EWq4cNjBVohIihCZQcHPArxLzgmNgVCZM4J5MPWLplABSNciO2bw7xAr76QYO3FJjEFtsj1ImbCQZ_Kpc9XoHjeRGAWZJYA7',NULL,'Amman Governorate',32.028751,35.850457,'enabled','1.0.10',NULL),(628,'vendor','$2y$10$fBOgaJeKOtbI50o/DrNjM.OPDqol8DQXV3dNJgVg3Y0Fq4dtT4jqS','703283555','pierre@lit-online.com','بيار','غنطوس','2024-07-10 12:52:54',NULL,'active',NULL,NULL,'VJX7+V45, Nabiyeh, Lebanon','eD3rX7q6RAyTy1XXgLnPYJ:APA91bH7r_ewzv8Jy80S-EF4F7K36dHL5Tg2EsEIL5gIqcU6skLpri45z796STaBs8qJajJNy8pmqUDT8tzmgJNYyhKR3YeLamnqppost0fQwSTtGg7sggGirer2ABcmOo9oGevFqOsg',10,'Mount Lebanon Governorate',33.899776,35.613474,'enabled','1.0.15','android'),(629,'customer','$2y$10$iQvT0p6qkoV23oOmDrAeVOPX8lehtt7rmdgduIjf/5mk817588lhC','796716633','zedrhman47@gmail.com','Mohammad ','albitar ','2024-07-10 22:28:21',NULL,'inactive',NULL,NULL,'Al-Muradi St. 14, Amman, Jordan','eNQqVsHvMUP6n2SUG60yBS:APA91bEDkVb0C5sleuD8dhzYltHKqHTu_1PS42U6wzVAvvRArMQO349HvGmxyuCdfORzAH4RdxMtXm5vMgowL_V01sezXqEyOU0bm4Iij9LfhqbyXp3V5QCkS_s8phtmIQUeJO8XajEH',NULL,'Amman Governorate',31.992002,35.883444,'enabled','1.0.13',NULL),(630,'customer','$2y$10$CGiHJ2oniSyQhgjEQccYJeP88Qef0RDJw6TskqMGnc53/vBU8/7Qq','782303073','ayatmusallam@hotmial.com','ميار','عوض','2024-07-11 10:58:15',NULL,'inactive',NULL,NULL,'WWRW+C5G, Salim Al-Yaaqoubi St., Amman, Jordan','eKLXA4ygIE7vsT_TBv5n2h:APA91bGG7j1Ln9ZpKZl-1b3b3_zmzAWjBg3K-H2atxWsWLcpkPnZSSQtWwkEXQR7EDstUS8hRgQBPFNl5lz1wYibINa8EUfGjLTXUixf2ikU7L0L-12h8iJgQdD6YoMLJHa4TSxullDJ',NULL,'Amman Governorate',31.941004,35.945473,'enabled','1.0.13','ios'),(631,'customer','$2y$10$9YUuguMjo0LinAMJQ6EcNO4RIkgnE8zVES1XbLIehMFyHRj2ouekm','795989975','acmazen@gmail.com','مازن','علان','2024-07-11 11:07:05',NULL,'inactive',NULL,NULL,'WWQV+QQM, Amman, Jordan','d_4_Z1ceTMO58AJyMQkJmE:APA91bGVe2M92buq6-4dNjQ2S5sUd1GlAfYUv-yN4UKbPxj1bQcgxxp9XzqSlMNSFFz1ralLaFyIsUlTcWheVRM2HF5O668TwMY9yHAViC0mRevGiWr7CQ67xotT0x3qrJCURajGv79R',NULL,'Amman Governorate',31.939791,35.944400,'enabled','1.0.13','android'),(632,'customer','$2y$10$6XmcjV4blJsqZM0I0SK.BeFZJRK.oUTKwjtDj8L498bF7GPvnRfRq','797962310','aladwan.mohammad1985@gmail.com','mohammad','aladwan','2024-07-11 11:10:10',NULL,'inactive',33957,'2025-02-04 19:39:41','3V2X+G7M, Amman, Jordan','fGRjn5rMZUA2rNcN-JZDqx:APA91bHT56MTMoCzYi3ezek9RV7R-EGUKY26Ygifm-YncnFINoEAoPV1YWX3Be4hz88Y3U198gUs6touxG6VtQtI5DKPa5UHv20XrWNAKA28Y4Frgtvu1UY',NULL,'Amman Governorate',32.050760,35.898827,'enabled','1.0.13','ios'),(633,'customer','$2y$10$uoXHC2W3wGTs3sy.SQBwtOtMk1Lgyr1F5Uudax0IW.bvZ82x0xyYG','799158001','ahmadfahmawi.af@gmail.com','احمد','فحماوي','2024-07-11 11:34:12',NULL,'inactive',NULL,NULL,'2VHR+R44, Amman, Jordan','es_MKcReFkJdpIFB_5kmij:APA91bGmQRja3arvzj6fb40UC1LUR4gk5wHOXGpBFjhePA-KwJEUICK-uiIcIfhg8--iSTLQjdhhZyk_QbNhJK4dAhPke820p3TclQW85A4ruhomIioHcMzTdjmcac9_rHh19RL5j34M',NULL,'Amman Governorate',32.029206,35.890451,'enabled','1.0.10',NULL),(634,'customer','$2y$10$V.1Ca8lehPR3KztGoQmAXOjM.H.gCINDQNRmGS.ug..ItHJOCNrAG','780882767','ahmednore.2006_tr@icloud.com','احمد طربلسي ','طربلسي ','2024-07-11 12:09:14',NULL,'inactive',NULL,NULL,'XVJ8+V96, Amman, Jordan','fUxmhpSR_EvMu04pJT6X6I:APA91bGqAZo0RBi6qNwyMmrotWx_Ty0klUGhBEcvVQ1W4fhIAGFuWYxvwDDtBPDasUshuFy-jbOVHrNcLaWQXW_P9UjSnqhL3XWBtJO65pDFL-z7Z31kMMs7qGt4CRpOiqWazisFWmyE',NULL,'Amman Governorate',31.981503,35.866158,'enabled','1.0.13','ios'),(635,'customer','$2y$10$dd9Kmf0/8lgOnPMV9eKyguQbje5mhf28eFGdH0wltdT8IBFJv0vwy','795072794','ysahar670@gmail.com','sahar','al haj yousef','2024-07-11 12:11:56',NULL,'inactive',NULL,NULL,'XW9F+X8C, Tamim Ar-Rimawi St., Amman, Jordan','eH2yIjxMykhPoUzt3nyFZ8:APA91bHS1ydJABY3ctOUnVFb8AiZ6LGAEPbrqj160nDLIH8y4dGYmtVpBg58yk4YNsXZaHUUI9zJk3MuUjKIxWgdqjX8BZvwSjjM1cvY0aTR-IcfpHzSUgQKBlP7gzki0CwTBaOG6cu4',NULL,'Amman Governorate',31.969729,35.923237,'enabled','1.0.10',NULL),(636,'customer','$2y$10$DDU0iZNppB81id3HdxVUmeoG4jI2Y0GeLi4867n4E24ORiHQcRMn.','795807011','Rakan_naffah@yahoo.com','Rakan','naffah','2024-07-11 13:22:52',NULL,'inactive',NULL,NULL,'39M2+FGG, Almazah, Heliopolis, Cairo Governorate 4461221, Egypt','c9AJhS7E7UBhl0LtChPv_g:APA91bHeSwuaDbcEHWJP5KgWpksMO55fDTVBhrFwZYVtxhHq0u_HmjpzS9X9iynZsVcgfOcKWYbi3qz5cazKO27oczneNIJwrvXRWTns08egrWWS7-MtMQAo3EwZAIS-fUstPEaQas1H',NULL,'Cairo Governorate',30.083823,31.351263,'enabled','1.0.13','ios'),(637,'customer','$2y$10$8bgqBsNG2hvBhokLqAnELO.rXcBE.cmkjFdHnItmFwDA4MH.JsLky','796151919','aliyasseen1980@gmail.com','Ali ','yaseen','2024-07-11 19:50:00',NULL,'inactive',NULL,NULL,'2W3P+7Q, Amman, Jordan','d6Ya8PVFt042iuu2fJjESf:APA91bGvpbpvnD-dSiLHXti9V7y8czBRY4dgvSev3iUr2-k2dAra3D_25e_1LfPZELFUAeEvrauDsA8Z51T0Sl6Sdmy9ZoRVKm2FHJ2RKyh7JfAUeGdCeL9K3QxbJkk2OhCD3kk3CdIA',NULL,'Amman Governorate',32.003258,35.936878,'enabled','1.0.10',NULL),(638,'customer','$2y$10$g639L/jcV4lSXtI0TuxclukaFpSJWSwY5OjodmeSnEH1neWtjP0DW','779771559','shakerabadi14@gmail.com','شاكر','العبادي','2024-07-11 20:28:26',NULL,'inactive',NULL,NULL,'XXM4+RVR, Amman, Jordan','cML6BxNFQoiEWodwOAsPG8:APA91bEHCmfUUWjZXJTcswLT1AmrSrJe_whU7uhTd7idhUF6UFISwcZFw5GLgBf5r-3uUu_iIfR9eAyOCfW3TYIFbX3RoujqSZ1Va_Y_VAY4zj4nGu5DKDH3H218df-HeXBjFSsp1KEO',NULL,'Amman Governorate',31.984772,35.956872,'enabled','1.0.10',NULL),(639,'vendor','$2y$10$rbC8Ra1n.shaGV6eh/Ma/O26A7cNnbkJMTTgEO239uAGaCN/./el2','770423097','mohammadshnawer2000@gmail.com','محمد','اشنيور','2024-07-11 23:08:12',NULL,'inactive',NULL,NULL,'2PXM+RPR, As-Salt, Jordan','eDx4b7FoSAKszGH-fOA00K:APA91bFTolvRE0HB5lHgqjJDurM0Sdbz4lT_O9729Qsy0l0LKwotXlm7YcDZ29lfeIJIL9wgv09ClueL5S97VcNzkmWfUQzAcDNbuyBY-AO-PO_UhEsR2WyPiUJvt1jT1RBN_9b5VEkv',0,'Balqa Governorate',32.049167,35.734552,'disabled',NULL,NULL),(640,'customer','$2y$10$EnHzabmEW36H2A3EOv.pGOObi4FjPZv/cBq0ut39jm.kdiLe/lJQa','796400742','said.adely19@gmail.com','saif','adely ','2024-07-12 11:41:40',NULL,'inactive',NULL,NULL,'2Q8W+P2, Fuheis, Jordan','cE2b5p-7KkWqs2cS67nKym:APA91bG3Fx1lvBIxLeASLJdNuG-YJGl-_XeDrSY-OelPn36sgwychN_19805U9oS3YzbLMNrZWtyqY9sruybWxxGkrNv7tHNBhxnqrKwInJ9dY7POTnb8vprFz8Moak_4fM8d_gLGNGI',NULL,'Balqa Governorate',32.015507,35.794422,'enabled','1.0.13',NULL),(641,'customer','$2y$10$SrUOVFdS7IQS8ow8J.Y57OeGnyA0L3FKh13ab87c2N71BBjUd4q0a','776398959','reamalraggad7@gmail.com','jalal','raggad','2024-07-12 13:49:08',NULL,'inactive',NULL,NULL,'V2P5+VVX, Amman, Jordan','ff5tILewg0q1ipz2KyUcuU:APA91bH4E4UFAIKYjBVE-HsQEjJlZKb2aHWokUfzgA1W19LSMjysZyd-2dbUtxJE4XVKrk74N9BlJ9q-kDkr25AF868d7ysmQ7gdQy_zSOCBMaZGprNGj_wzNnNOois4Dzrj_KyWB6lm',NULL,'Amman Governorate',31.886948,36.009672,'enabled','1.0.10',NULL),(642,'customer','$2y$10$0B.xrsrFHKKMZGoCxfNm8O0NuRzmle1qAL7/jpPrmDCYo9ZJdZfEa','789873351','qutada.aliftawi@gmail.com','قتادة','اللفتاوي','2024-07-12 18:06:25',NULL,'inactive',NULL,NULL,'XWG9+H59, Rateb Muhammad Al-Batayneh St., Amman, Jordan','fudf8BJmSkd7ro99P24Ue1:APA91bHMqUEGwltTgqwmTblctAVZQmu5I_mdzZ5TAubOp3MjKGOFQ2U4Y3NZk_CwwMJ9FrjagQZMDkWHHWg7Vsew51a9OCKVJumX3AJr_4DDtGb2BITTAVS3MTCpILLvtejJPx_H27w3',NULL,'Amman Governorate',31.976542,35.917862,'enabled','1.0.10',NULL),(643,'customer','$2y$10$RyP2LJSiRAv1beigiAVl4ewVw6K.tUiSOVuC5Xp7kjnF9fGo7LaCO','776949431','ibrahimabuhani4@gmail.com','ابراهيم ','ابوهاني ','2024-07-13 06:14:41',NULL,'inactive',NULL,NULL,'مادبا حي، مأدبا،، PQ4P+X8X, Madaba, Jordan','c8vY8oDDSgOQNdu0bHXzq7:APA91bFtNhzl3g6g8ZocRqC6rWwa8K-84LOtfg-pODO99BmT-bqSm38xQt12_f7oxANGwMfnFEzZ6s_x_sIx6osmqu6ue4RmeAw3WKaFB7B8Ya7nJcz8h2qjj_2conF1Avhb82QmoN-Z',NULL,'Madaba Governorate',31.707508,35.785843,'disabled','1.0.10',NULL),(644,'customer','$2y$10$sKLDKBqNP78010lrFjTPTOmMt8zw9ko1EaVBMR.vqkp49gpRESnmy','779003836','Omarayasrah25@yahoo.com','عمر','ابو سته ','2024-07-13 11:18:01',NULL,'inactive',NULL,NULL,'7RM3+WJ, Sakib, Jordan','d9nlimPIAEcwk_o-4n-nye:APA91bFr-tqEXeh1y7rXy1JXHQNAKm5ZEEpSStgevazr8wzB4t47aZW9ANQuuyZNhXpTpzbWlsB18OLFn5eMEgE6wI1wH-gcyyNSyw7lOpwyZLI3R-h-OfTy0O4whih80RyD0Z3zF77l',NULL,'Jerash Governorate',32.284032,35.802894,'disabled','1.0.10',NULL),(645,'customer','$2y$10$uaCkkEvtsnakhjt9xQqI7O/onGqGfw/ByfaaNkH4HsZ3KUd.aJe7.','782032048','laithamar08@gmail.com','Laith ','altyate','2024-07-13 11:40:44',NULL,'inactive',NULL,NULL,'XXGH+Q74, Amman, Jordan','cTjDF8MWSUoIgzibrUnIlf:APA91bHA19AtVoVgADW-Kv4mWVaPy5_TjlHx0N2-wtX_8GniUQ79MNn-rPOm2ACdt7_x2916hMeOhybuZu1zbb5UfxHw_RdW6WiKqe9Px9SlTCEBeRx_lHs-EQlQ4fxosmbiKiTFNsDQ',NULL,'Amman Governorate',31.977093,35.978567,'enabled','1.0.10',NULL),(646,'vendor','$2y$10$v.F3KdwEentb7oHkS46mdO.Hhb3DCMqvJUOYVWaiSAnGOByAfVkPS','776747183','motasmzabout01@gmail.com','معتصم','ايمن','2024-07-13 19:59:16',NULL,'inactive',NULL,NULL,'WX7H+W8Q, Amman, Jordan','cXE36r1CSwGOk9EIhCErU7:APA91bEVwxJRlKMggyGZh0PkstUPc4iWbTUM7pLr0Rrhc54aY5Pa0_0epUPB4TDzIIF6UDJrc2TOmgPqDrHDH7h8s96YhjqRWU7kWicxFZqd7YRGqfN0POThl1SZP3HZDTjuF63WAbgt',0,'Amman Governorate',31.914904,35.977993,'disabled',NULL,NULL),(647,'customer','$2y$10$GNTe5n1nlMgXtcnojAtx.uNJPl.vycUcPfE8tmCsfeWoNXeVuLEHq','795642647','naffaa.acc@gmail.com','ناصر','نفاع','2024-07-14 10:39:29',NULL,'inactive',NULL,NULL,'2Q3M+JRJ, Fuheis, Jordan','fQalIKFTQiq5mwQjCr1ijd:APA91bG7r2v8mjd1jDJtAOOrrf2Ar5NWnwtXrMX3x1oHmMDPXUczFJicCEURexxQCg5ksd-qIRynWnAgCw8Bmi_-iJ06GuebR_ZgMlel-QZFACZet2PrmZ8oBiTvaFu_deE7cIvbmr7N',NULL,'Balqa Governorate',32.004080,35.784506,'enabled','1.0.13','android'),(648,'customer','$2y$10$J8Bqo3u9W8jfDzuZ5gZXsOwbNuSmHDeO/dZEPzRz19jl4QwHPxfZ.','791459296','sbmallah95@gmail.com','صهيب ','الملاح','2024-07-15 12:17:14',NULL,'inactive',NULL,NULL,'Moussa Abdul Rahman St. 8, Amman, Jordan','dv1NFAce-kGZoikcR4_t4T:APA91bEPYFDWFBKiOzeXL08Pt-vLZNHHH297sQ8mUkBXZ_6DTLDF9r_aJuVkPLrHHbhPTkwbd2wDIIPofxUewd2dZCcu2OErPRVEojhtpnHcc5WywyYD4WkSu_9PEqLUd4-3k9GGQ8DC',NULL,'Amman Governorate',31.903244,35.890146,'enabled','1.0.13','ios'),(649,'vendor','$2y$10$uON0rxEQsHu8JNau2NRw6umNhqJY/KlODf0BI7D41vTDDKHKzdavy','796244140','majedabushkhedm941@gmail.com','محمود','ابو شخيدم ','2024-07-15 19:01:24',NULL,'active',NULL,NULL,'WXCX+9X Amman, Jordan','fNNm88zlSaOVzRxx3X1ujE:APA91bGRkP2_ISTWfK6AYTW1Vu6i_EqxrVgsIdxG8Eo73NrpP0s-Xp0FFKCgxd3GKnhSILEgtqsGQZmI1CBkvpglJ_42wceg7-Crwfn-QDUv4wq5FGv0wj6GbJKc9gm8vM4tdEYw_llG',5,'Amman Governorate',31.920918,35.999988,'enabled',NULL,NULL),(650,'customer','$2y$10$HWxY.WGpD89FXK.aQp.X2.55/8QYA.iOu31zECb4NPqqgWl8iK6ZW','782303011','12345@customer.com','customer md','','2024-07-15 19:46:48',NULL,'inactive',14136,'2024-07-15 20:05:11','marj','dTt1r5KDS2eKNPTakvKejP:APA91bHCZmu4rLy8bzc1W_znyCasVfkgQaIEI43tn8E3QTIfmgCBnLUc9wSi4pIOGIA5Byb9dnzM14niQOTyV6TPEvRXD4fiPSfHzyOnDvDvH4YPjF5fKuow04ye_L01Ww6x9PihbxKZ',NULL,'main road',33.775063,35.889796,'enabled','1.0.12','android'),(651,'vendor','$2y$10$6VNusmlaIdg6wr/h170yqe3kdmMec7TIF4Sc7WTkoRUSzJI9AEDQ2','782303081','venderr@vendor.com','vendor md','','2024-07-15 20:04:12',NULL,'inactive',54078,'2024-10-11 20:29:57','XVP7+7P Amman, Jordan','eH8cTTJwRvWNYqnpiFG6Yj:APA91bEdlTvMLAaCicU8yLtZfMnxUC4wCtmS1Lgm0wcVXfvOE6_EXap36zpj4kkUdGbV8ph0OnC2e8nYLQbDvQaJufuejdUhK5iw118XX9N22qF6KcUn4n4pdlIp08jgM83lC71cz_3D',47,'Amman Governorate',31.985694,35.864363,'enabled','1.0.15','android'),(652,'customer','$2y$10$iQY.LtFPuUkeh7dHoHT2o.3.sF30IVbi2BPsz1CGEz7sXofJr7mGq','796940556','abadypc01@gmail.com','abbadi','khatoom','2024-07-15 20:45:58',NULL,'inactive',NULL,NULL,'شارع الأمير حمزة،، As-Salt, Jordan','ea6SNNEfT0_SoU9Fk4S1Df:APA91bHZKTt6NQDsyH3Mu82tLiKQ_XgDQBpJQm8PWSomDZfzrzWkyS_MN7050bUChwYK43JdAbsMMN0fS6I0OPTmIZcdDo5QLBJ2egkKMysiPfpeefJAzApo7D0ArabMlGCJ1Fy9lFA_',NULL,'Balqa Governorate',32.064917,35.721656,'enabled','1.0.10',NULL),(653,'vendor','$2y$10$4ZC9/.PLgqn7lrzZq8mkB.wAAyLXmOek2IJJGEAM6RSrTtOdvY6LO','787648525','ismaeelalskafe19@gmail.com','Ismaeel ','Alskafe ','2024-07-17 07:46:16',NULL,'inactive',NULL,NULL,'سحاب،، V279+2GV, Amman, Jordan','fFTi1aBXS3ee9cn2Rr9NHx:APA91bFh78-JBlJ80DSp25dD3M6haK0LvOUkHnAioOKk7V-7BxJ7sz-pfpdGpC5-_Jbl3sN12c_GKegxYz43W6Sx8Ou2FPctgOGGX7UipPYIYfrDPOECJUupOUnYF4qlaBfX4pF9fl37',0,'Amman Governorate',31.862490,36.018664,'disabled',NULL,NULL),(654,'vendor','$2y$10$5s3R2zGT.pVnfo67tAC0cOu/KxDaMCewJMxEfM/ja.m4NtSUMEq7e','780693220','lokalokamoath@gmail.com','معاذ ','الشوابكه','2024-07-18 15:29:00',NULL,'inactive',62116,'2024-07-21 15:42:58','Sahab St., Amman, Jordan','fIXz4GpiRASDfzYeLYAPPQ:APA91bF6x0XOoBwnkw-Iko61oFPROi5vJK8IIJ51AMHLnbgKlIsTQygtS7f8vfb6XKsohB2iuRrQhpAybstbB8mVqAch4-xiNaGZtePMHbbyP2TOt2JSzXQ6f5HK-LIgfi4h6QkORzca',5,'Amman Governorate',31.870060,36.003658,'enabled',NULL,NULL),(655,'customer','$2y$10$XTGtENM9ClNTcj0qkFrwseP1onYtyCrwlI8SHdFhf3r9dfApYNFse','798558972','m5o@hotmail.it','monz','sawa','2024-07-19 12:57:00',NULL,'inactive',NULL,NULL,'XVXC+MWX, Amman, Jordan','fe65UKWtLEj-pCzK7Fm8jX:APA91bHJ92q6fyHFac1iaa-7SVF50G_uDHA0SW8EAQvTCLrpA4Sa11ENYC6jYlJHYsULd7JMSAnpHocDYLBg8hbEeB5QgUhvCU6R_aepXDZc-kDE1BSnD8AGU_5XnHL9GboYu8muSME8',NULL,'Amman Governorate',31.999198,35.872385,'enabled','1.0.13','ios'),(656,'customer','$2y$10$6VNusmlaIdg6wr/h170yqe3kdmMec7TIF4Sc7WTkoRUSzJI9AEDQ2','782303070','mrad.mohammad@gmail.com','محمد','مراد','2024-07-20 14:44:23',NULL,'inactive',98762,'2025-02-28 15:58:18','QVFR+W78, Bar Elias, Lebanon','dFCMtAZeSz20KVkx4Zo0ig:APA91bGwqrITOiVXDw00T7DWXOAiwQuzg2Dg3jFRQRvlIZllmAiE42VybjVwp3l42Tcz1FDqFRNibCbDIue28wNarPSZEX97GeHfUD8qj9aDEKlYdqqDO_rPLi0jnTs6jX7qW_RAwXgU',NULL,'Beqaa Governorate',33.775087,35.889675,'enabled','1.0.13','android'),(657,'sales','$2y$10$rnA/Q35BqrUIasdaQos6AeOQWkYLHuo63y.x.jYdHwFLjTb40Mi96','11111111','Alaa.alzaibk@gmail.com','alaa','Alzaibk','2024-07-20 18:35:02',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(658,'viewer','$2y$10$43xVgbRP2avvV00k2aOVcO0MIcjksQB4j1w42NF496fnWjji2Y4m6','0000000','test@test.com','viewer','viewer','2024-07-20 18:48:38',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(659,'customer','$2y$10$4nvPIC.MwUtvWm.xSHAnm.RS7dclmP4i9u83uDw/NCtkoiOMqOWg2','797016924','zedrhman@gmail.com','هديل','كلعو','2024-07-21 07:58:47',NULL,'inactive',NULL,NULL,'Al-Shebrawi St. 23, Amman, Jordan','f7jZj6nVTk2l__3ud5wlGp:APA91bHrMBhCRRTSBjzHx_CPqJ6yRpD8tS2AVNI4UzeeMBNE9yFUAhAt6p29igSviq-sXKqUgcfWKGe7Hxf0aq7F9lbu_QQiC-zidO3b_wdQGuRvPhuw33pNi7HOZI2kYikrXb3PcHGO',NULL,'Amman Governorate',31.992067,35.883357,'enabled','1.0.13','android'),(660,'vendor','$2y$10$pwYX0U1LkNl8PnSL4q3D1.jm/ximB7lvnx6ZEnXRLx81xiqgkcg7.','782250309','alskafyasmayl0@gmail.com','Ismaeel ','Alskafe ','2024-07-21 11:33:42',NULL,'inactive',NULL,NULL,'VX8X+5Q3, Amman, Jordan','fRNuK6IYRRCCFVEZBDs671:APA91bG-_qJeZfopj-sDzQZgGSdD4MPbXQH5o0nOc94ZHHUZMFJYDYBszKJF6aPeo0zZ65w6j_8B8x3GFDI0ELJP2McKLueta7ZFHyuZsLp1mq0-O0c5mb78hQGDWoBFEBETLZjdP9QU',0,'Amman Governorate',31.865754,35.999514,'disabled',NULL,NULL),(661,'customer','$2y$10$nzNnGE.6UMkgA4XY11n6uu0kzepA3/96zh5gw0fnkDbmxiEcPJyeS','782250309','alskafyasmayl0@gmail.com','Ismaeel ','Alskafe ','2024-07-21 11:46:39',NULL,'inactive',NULL,NULL,'ش. زينب الأسدية 1, Amman, Jordan','dg53-6BuRsSKa-fqIyP1R_:APA91bGNVwHoMiyB0nGBNR1Vl7nTlNEwoxsMVC7qpkXuYtaAc6dyRkNv-eLHskWE0CvQQWMIX3Ls8NATn-7eYQfDRwUkGsw7FKk8WEQ-e3r0v7dz4s9IL0bUzUws8PGXrP-re9UHGFRr',NULL,'Amman Governorate',31.886894,35.994731,'enabled','1.0.10',NULL),(662,'vendor','$2y$10$0c0pw0v3jBBB1iG/szerfOBIstoTEH7S8LGctZKW6al62S5Be4N26','790999486','ramyazdawy@gmail.com','رامي خالد محمد','ابوخالد','2024-07-21 13:13:48',NULL,'inactive',NULL,NULL,'XV4V+R6J, Zahran St, Amman, Jordan','f3seZG9cQiu-cbWWVBtn-1:APA91bFI73UQeaKXmlS_uc6cFdFxMT6P5POpNKZAgbA_MLP8BDFhcFjtIGEPNwGs3VY9jfLvVdP1hl7gNIud076gZXNHiYwKqLHxskfVl8V_X5QoGmi0EJcjeX0E3YYgzGt36BmYKy_H',5,'Amman Governorate',31.957129,35.893269,'enabled',NULL,NULL),(663,'customer','$2y$10$lg4u5xzvuuZqtK8ZZsz91ujTDXdl0heb8PK.a7Gge7VpRB5SUyDqK','795431248','almasrimahmoud587@gmail.com','محمود ','المصري ','2024-07-22 18:17:29',NULL,'inactive',NULL,NULL,'Heifa St. 40, Amman, Jordan','d2lZM5EcQbeHkyKNZ3XaP-:APA91bHfxfGPlr3A7a3af-WCP9VVbVPgc2kMy41u2Tcu8hXLYIM8F5LIaGkqzzF7o46RfW4G437bKUzFoBCENwEF3v-UWB3VFljkH9oCKGfLYY7Kv7PSdZHtprcel78_xX_4zwwHCl86',NULL,'Amman Governorate',31.972507,35.919215,'enabled','1.0.10',NULL),(664,'customer','$2y$10$YtypxuCkQ/5LLbuqq6o.iOgfrD27ckBM2ZsLa/ztfiV98DqxKFcuS','782552591','mostafa078255@gmail.com','مصطفى','الطويسي ','2024-07-23 09:43:56',NULL,'inactive',NULL,NULL,'XV33+6X7, Issa An-Nouri St., Amman, Jordan','fVNuTxNiQ8C6vzluyJHrBI:APA91bGEkADHvHmck1abRvDhqCSg6lyOvBOmU9BgVPkCmgSktMRoopMl2fAs5kdwgSd-hGkYGZPDaGiiPb3BX-zaj876tLFxTEjG3g-qE2mOKT47zr0XMGwyF5ikJ5FvJVd5z0FL2p4O',NULL,'Amman Governorate',31.952892,35.854821,'enabled','1.0.10',NULL),(665,'customer','$2y$10$/7C49SpMjqTqVxdExM3blu0iQOHnZaTNNvL6K6HUr7rsCR2kVzed2','796137404','umrashad2@hotmail.com','ربا','عوض','2024-07-23 11:30:24',NULL,'inactive',NULL,NULL,'2WVG+VWM, Khalil Hamad Al-Omari St., Amman, Jordan','cFP-wSwKV0etsgTPfceYZq:APA91bE6jAoUcaAzLGbaoG-AECmWH8w9iXOzqUGlGSx6fsdZ9t4TY6dVTPV2g7WaDJE6tID56eHb256Zc0DS0BvuvFykDhZYbxd0CjGrutck3lYfrx-cmcCbezNVyKJVm3HvGQmwYWiV',NULL,'Amman Governorate',32.044078,35.928660,'enabled','1.0.13','ios'),(666,'customer','$2y$10$jywITVk/5MvgijdEvohNseNiPxAIaJu5cc0nHzEeBL1LhqNP1NEES','770757254','jshejsjiwwii@gmail.com','اشراف','الحمامري','2024-07-24 08:37:46',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','e9qboS3OQQS4MJNG-oTTQ-:APA91bETnNCzjGY5TZG99R27hKl7uasQ_KSQ9CSgc75-Lgj2XAmhBkYSVSRyYjFvGDnW-PLOJ00-szpcwJMpgrx41BTXYrB6Yxf-8NkbipSvGbLg0reovAfSUuUJGIZ9HltcfQLAfQVs',NULL,'Amman Governorate',32.014017,35.865100,'enabled','1.0.13','android'),(668,'customer','$2y$10$dhKKdkPEAxwSZ2UuEsqmZOqq2luDqHEHFn8sj63lSrMCZ.uxtm0Bm','782303079','k@k.com','عادل','محمود','2024-07-24 12:35:55',NULL,'inactive',NULL,NULL,'Habes Al-Majali St. 44, Amman, Jordan','dLru6nRGT4yimm0PIPSOKv:APA91bEuOQktTCrxGJKCp1K895Y5AnmnLg2MKWR2PX1s7gkK25hhx538RcgYWBzsADJrqQQBISvmvDDUBFs-JdV9j6Ijsvei_YJdtNtvM1C_dfYJtED_7konduesgE-HAMBMfh_K8e8R',NULL,'Amman Governorate',31.981683,35.938368,'enabled','1.0.13',NULL),(669,'vendor','$2y$10$BjS2vpFF2fTYdt3Ch8LvvONxyWpEZNe6jyqLto8aQqbyOYyjN92fW','780879855','amjdmhmod78@gmail.com','jej','kwhw','2024-07-24 15:10:39',NULL,'inactive',NULL,NULL,'22RF+9C6، الرصيفة،،, الزرقاء، Jordan','cWrQgxb7SYS8t44SFnmX8O:APA91bF1adpzYNdoh2C2bePVoTJNKsp5Gf4Dw18v0vbhShzMlFG1WlMMRlnHcLcGMil3m0dronz_B5WD4w_VfsmTvJ3RufQLX75Wr8rCCEEfLttFBgnQsTa4uVM9aX355KHwJI3zV9pN',0,'محافظة الزرقاء',32.041668,36.024525,'disabled',NULL,NULL),(670,'customer','$2y$10$DzADWPlWzcTz1JcaCfx0MuI4fS/pr3AT5P7NlRsLhxZ17PjA/hvHu','799292416','orjanibayan@gmail.com','bayan','sso','2024-07-25 14:27:50',NULL,'inactive',NULL,NULL,'GVHW+W9Q, Huwwarah, Jordan','cLTXkZ-RTpCCJizf060NZ6:APA91bHQu9WkJqjhXNj9CyI23wl1x6K-ttIdq633IySvbO558SebG52Pysvh4wv3-P7IDuI6wM5H0DgxAGepG9bmWs32TEv5ACeRiL1HJeLD-k3KtfBEtnE66uU15F6PcWFNNDgu7Sor',NULL,'Irbid Governorate',32.529478,35.895147,'enabled','1.0.13',NULL),(671,'customer','$2y$10$jSR6DrSfsoXEnmFkN3HqcOi8I6YhjhUqN3HLqoVvPELqwPwaPyZEu','798606032','motaz1989otaibi@icloud.com','معتز','العتيبي','2024-07-26 11:23:55',NULL,'inactive',NULL,NULL,'2R7M+F7X, Yathreb St., Amman, Jordan','eS4SP5ikgEPBrcDd9FX8xT:APA91bHfQ6MU12GwFFTXYHwm-bFrRKpAkANM40BY--lymOveJSVbrubPh38nokm5uSEV5HhsZzbEXmLG-CJNiX1K4QwoNicQ-w6rJP8Kh7E64qaMZFGTuSEHeIorqyU-4yoepiy2bQKX',NULL,'Amman Governorate',32.013613,35.833247,'enabled','1.0.13',NULL),(672,'customer','$2y$10$jvaCsreSIGlIR4NGwSCb2Oyre2CdhTkGbGzFRffTtNDrdtkI43h6u','779471371','shyrsnzrygat@gmail.com','sheren','sherein','2024-07-28 12:28:44',NULL,'inactive',NULL,NULL,'7VQP+4M7, Jerash, Jordan','c26VE_0qMkULsMyCaFMdqy:APA91bFlhfKmgmYMKS5e9PuUqzBXjYpfihVfpEZ9DuvwSGYi6Fc4VaywSQ5TrIatXD98NacrQbsbeNqsXUiUCrDpTaf8xcT5hJMcOQjs0IgzHPUTqH7fnP4WITrPnQ_rIyuc7VT4vA40',NULL,'Jerash Governorate',32.287609,35.886829,'enabled','1.0.13',NULL),(673,'vendor','$2y$10$mzX.MqCNfnZcMWTywnMEn.9ju5Vd4TQEDLYOmsPQjyAo89Uk4cui6','787863610','zsss7636@gmail.com','محمد','محمد','2024-07-28 19:45:59',NULL,'inactive',NULL,NULL,'334J+QFW, Zarqa, Jordan','fjHPDfADR56r86GVFnlcW8:APA91bHA7Phe_RTZYUSUKqLu3O7pjHaboc73Wrwz4RA-M2Ef0By8ByJiu6l1gnQZuidxD6C_LzfcQbluQ-_PZE0qAkqiM6SYFPU6suCaUUIdbZ4LsKSdTbGX9z_duTubAJNe5CcQVh_1',0,'Zarqa Governorate',32.057004,36.081088,'disabled',NULL,NULL),(674,'vendor','$2y$10$iiCjBrI53rihSQk8jfOEpOMt6Iii24NsIFEG.lq0D1Ht/duGbx..O','796063235','sarh.transport@yahoo.com','محمد','ابو عوض','2024-07-31 07:53:55',NULL,'inactive',NULL,NULL,'ش. الأيوبيين، عمّان،،، Amman, Jordan','d7HhW35tQ1iKz5e6MA1bBI:APA91bFB9hEtXmIb9pRBm9Z5eStbwpODzjTrmECAbZQ-TjRWtZqi8i7zZFw6H89p7qyDWjTHO5wgDzeBkNslPIpka5yTcD-_UYqdUrJn3a8wKpRgI6Se2Uhbbw1AOi-a_517mV9OfqkC',0,'Amman Governorate',31.893347,35.973050,'disabled','1.0.15','android'),(675,'vendor','$2y$10$hivJwBeW5TGYMHbkvL5v/et.wdzP.IevuRkvyX9vyzazPXypK6LWW','791000233','alqawasmifawzi@gmail.com','fawzi','Qawasmi','2024-07-31 07:57:20',NULL,'inactive',NULL,NULL,'ش. الأيوبيين، عمّان،،، Amman, Jordan','ff69TyNWRBmF4vVpdQNKSl:APA91bF5TN88oxAkYeWi2LZwyexWsly1JrhIzMxQGA0_Zxa4Xzhw8Fn0QJC39vp_4TBS9W_llF3OVBnM-XJcIHopbrvSw8kHdtMcrRRKYGp-PXGT7u-5UeVaZQoWS-WpvXW1XxpW6dcJ',0,'Amman Governorate',31.893355,35.973136,'enabled',NULL,NULL),(676,'customer','$2y$10$fZvepqOLPLmeW.aX/ipRsukN5Z5kjt4Sd3bcEvC0ljJpCDCWrF78C','792255969','monzearalsamhore@gmail.com','منذر','السمهوري ','2024-07-31 07:57:39',NULL,'inactive',NULL,NULL,'ش. الأيوبيين، عمّان،،، Amman, Jordan','e_QnKvHiRfG93kCROrhLVT:APA91bGQUkc0FipK2aAZm1cmfejB-ynvOYG2flpsVAkgnqAezbqVokT8XFvS-Ut3AlSrI33aMt_ieVVqG_7ZB_oWzjPiaUwh0M52tpwpZU_ZOlLFKlBz4UVpxRcn1MFfY0ED2Zl-NrkS',NULL,'Amman Governorate',31.893360,35.973128,'enabled','1.0.13','android'),(677,'vendor','$2y$10$PVnXS9p/DYnIkFllua2bmeCp2YWu8JxfwoTudwRpGg5S9.s.oO6Jq','782151422','lokalokamoath@gmail.com','معاذ ','الشوابكه ','2024-07-31 12:20:46',NULL,'inactive',NULL,NULL,'V2M2+5M, Amman, Jordan','fIXz4GpiRASDfzYeLYAPPQ:APA91bEZ0Kg3gfIkQu7UCUDb2jMFSyJbqZIHUNRC0SnI1J2ksUHqWaez0FaMCQAR8HIe0Xio_H4v93syCLOo3JqlZN-8f6rWqgT7_X_MKbxWE92kAYzx2SZXd7BimOdxP1AXG_HUVZLC',0,'Amman Governorate',31.882897,36.001074,'disabled',NULL,NULL),(678,'customer','$2y$10$Us0Azdw0scoBoXNDtebcReFsJgojsCVdqIxDYJVSKApIg.Sny2iki','786995694','kafrisami737@gmail.com','sami','kafri','2024-08-01 09:35:37',NULL,'inactive',NULL,NULL,'WW2X+7Q7, Amman, Jordan','e2Pcl5nVSH6yfdDQ7BPUwR:APA91bGS8ajxNNbqfUnZ74Sv_qHZfxKlA9kdm7bEapJ2sevcAkShDTzNlYSWetK9Zd5isNMJvxLMcmlVwZFWvAYxErOoim5ycnlzJXXAw3rmTwJU6HIDJ1LmMdfZvseDgpaDjtQ3FScx',NULL,'Amman Governorate',31.900400,35.949543,'enabled','1.0.13','android'),(679,'customer','$2y$10$2/Y5uw3u0vVNjlrYvsTAceNbRpt1Ycr0mRizgCXYPiJ1Ll9/oIIkC','790127466','huda.ayman96@gmail.com','هدى','ايمن','2024-08-03 15:51:27',NULL,'inactive',NULL,NULL,'Ath Thawrah Al-Arabeya Al-Kubra St. 93, Amman, Jordan','eki8rFrgDkdok1FQ-7HGCR:APA91bHKa6EV5XLrrUHrEMs5SlcT8eZtJ2kUW-XpC8lqJpbPD-tO-lpozR6E09TLiXaLwbQWHASvvnM0B2sxUyp2ll2K0jj8AUZhvB6ADCzUJSXheQfhpr_G5JPW4M0sbGitDBKE33Se',NULL,'Amman Governorate',32.022655,35.834949,'enabled','1.0.13','ios'),(680,'vendor','$2y$10$sKMpl0.rktYpkgHeGytrKeiNyU527HnZbDllPzju4CcFmz0bZgb0y','772473699','ahmadweshah343@gmail.com','سيف','محمد','2024-08-04 15:27:08',NULL,'inactive',NULL,NULL,'2QMV+7M, As-Salt, Jordan','e-Y1d15eRSePCBjJAhuKP7:APA91bHOWDhiYsv_K47bcPIgAk-ICfikZ1OOve0tGUjcpeNf0djMdG5rY6mev4JpIOI3LqXq8vBdY6xU4ON5gDBvxFPLbo8k3DhRvJkhdlEYoFxL-bDsrDTaOgg9MUFPzJEADtwAh_7U',0,'Balqa Governorate',32.033713,35.793862,'disabled',NULL,NULL),(681,'customer','$2y$10$fD446OmNbRQEE/CEa754au45ZdP25ShboHa7vE0PL1jsgwZ3r1DaK','796220917','saifALMo5les@gmail.com','مرهان','اليامي','2024-08-06 18:56:21',NULL,'inactive',NULL,NULL,'XW25+62P, Ibn Khaldoun St., Amman, Jordan','ft4J4B7FPk2cjd4AuLkl69:APA91bE9iqiSGcl-OMvUDf9XaSuNWhrpEmWuTHd93cHAx6WA6TDOzqLp4ySL1dO9K0lnLbPFXk9U4l5TGUBo50fHc4lcDgZp4pRHi68HzJg7u1h7FIjFPev4sH94_rwSZUiMy0NlbgK1',NULL,'Amman Governorate',31.950213,35.907425,'enabled','1.0.13','ios'),(682,'customer','$2y$10$7Jwn2Dya5ZROxr6NwUgb7.tWVchyUyyjoT7G29yZq0jkahTG9GvH2','782303076','royawad622@gmail.com','roy','awad','2024-08-07 08:56:11',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','ckn2_ccZSfakiBRkocuNFx:APA91bETMFGcFe-ZOD2gsYIU6-KoXXak_XvsjnXo6qztdTdIJt5IuNdH3_XYkTz6_rGiTZZzDarkQK1jV3UC_lkp9guDqlnvhRTO7gVMjgqI3MC5eUoukiUT549zbDTVo5WfH2frQKFv',NULL,'Amman Governorate',32.013952,35.865246,'enabled','1.0.13','android'),(683,'customer','$2y$10$WPiGBbEsrQTBd0XIVI7qRu64r0cQx2jg/ugR6wpceuplfe504akj6','780000056','bashar@menaitech.com','بشار','حوامدة','2024-08-07 09:12:59',NULL,'inactive',NULL,NULL,'Dhi Al Qaada 24, Amman, Jordan','esXrwuegRzqV5kF7fQdAoQ:APA91bHY78C1lFySUygWgZQ7l6PX4qYgGMLAyULH133-sKiTwaz4IuusWc4pRASDF6WMD284x2hCT9RyC8IYBlbyXCDycGR5oyU2cgw8k9DhRG5KQ_Nq5fn7ms_Gvl0p5v64eBZeuzmy',NULL,'Amman Governorate',31.979291,35.845605,'enabled','1.0.13','android'),(684,'customer','$2y$10$nyyjhJhGEQHkOHHxF9hHWuq5rpvJqshXUI5VoyFYZPwtP0THU0fJO','791066207','jebeto3644@alientex.com','سيف الاسلام','بنوني','2024-08-07 20:04:05',NULL,'inactive',NULL,NULL,'XW73+RP9, Amman, Jordan','c6DdKBSCn0dpktm3CxsY6w:APA91bEV6XktlQVEUnRs2PxqkHsYqDc3VSdPkPU9q6qhhMuncgO8JNiQLHUYRFk9rVsJChDtkD5vg2hNiytUFMgy_t2EhjlEjth-sBHn031t9f4s_Q_XQreIBzwk9TeOvj60bIsw2ZSF',NULL,'Amman Governorate',31.964310,35.904471,'enabled','1.0.13','ios'),(685,'customer','$2y$10$zPv/UM7Qw3O/pdNvzwq/7uGRTrKqbPBBPC4CtcGc4p50TXHSy/uCm','780607588','abufararahf628@gmail.com','rahaf','abufara','2024-08-09 13:31:01',NULL,'inactive',NULL,NULL,'Salwan St. 21, Amman, Jordan','eeDidMfwKk0Pq5U84FP8J3:APA91bHO57I4MNyNHD3yyio2IpJzsqrni9uBj_xASJes-NgEugEiZsQf1T726YDdaAO-R1FfAnMXjdae8ac0W-wX2cikcMs4xpIOsSFPBCty9tI6h0Izp835lriH0dhtlqAtGBrHDQUu',NULL,'Amman Governorate',31.962121,35.920128,'enabled','1.0.13','ios'),(686,'customer','$2y$10$RUVfajSXbghpNYClCy6RN.otZFhs3YJFcqpv9Pw7N1ufPhvP4Phqu','776831011','meoh55y@gmail.com','manal','sobeh','2024-08-09 13:48:51',NULL,'inactive',NULL,NULL,'24VM+6V5, Zarqa, Jordan','fhWHk3Y_-UyOtAs6fLhxLL:APA91bEymacVTHoca8QU0XfN1lhFmrernoADdd-lkUxnCqBVmOJAqea1NVfCAVgTYNg8bgo5ev_KAZ8L2i7C6-1rbh25iU9Kd4ULUEjBXWXEyrEEuDDy2Fe6NPi51jvCBOKfofMPb5Kg',NULL,'Zarqa Governorate',32.042233,36.134497,'enabled','1.0.13','ios'),(687,'vendor','$2y$10$p42bnzH5B7rDT1QduvsZ5uR5BJM.fuVx7ARSfSLnDZ4sTGeojOUea','786242206','lobnatashatsha@gmail.com','عبود','طشاطشه','2024-08-10 09:05:27',NULL,'inactive',NULL,NULL,'GVF2+829, Irbid, Jordan','fXVuK-xDRLWs1COyucCjsx:APA91bEVcxojePs7ki07fm2yaUcQf7ZTvUogihkuLyq1a3f483VtloQ0cOf8WYzowtYbI5z5hEsyk-35ygUJ2oyOKGrJ0PHm_ZUmO5GNWZ2GDHEINLprEu4I1jeAmtYrIJh3nqXiHbeL',0,'Irbid Governorate',32.523134,35.850157,'disabled',NULL,NULL),(688,'vendor','$2y$10$U7z96wsI0H1ip5p36N7HCurZ57Cw9e7vuZVylfw1T8wa14wMxK/Li','791881394','reemnofal59@gmail.com','ريم','نوفل','2024-08-10 17:40:08',NULL,'inactive',NULL,NULL,'Ghazwat Dawmat Al-Jandal St. 82, Amman, Jordan','dW4O6DhOQsOfNVdFMmg8rv:APA91bEpO5yVCwa6vZt28LsgPh6qXTnZQKoSVkAgiChX59ara-5j38pMHbyNbi6l-3Dr7jDUp5PaKHW3tIm3gffBqNmW-FZtRWD-GsIg9OIJqEwLGrnkQp2iD-9c3YWSgJ-7G2-JjkjB',0,'Amman Governorate',31.920085,35.929695,'enabled',NULL,NULL),(689,'customer','$2y$10$fbkHkuQ/e5zqGZZNEwcibO9u5jR/pDoRGwAn.qn.k8B1LFliCeWhe','786011545','moutasem.aqel94@outlook.com','معتصم','عقل','2024-08-11 15:40:52',NULL,'inactive',NULL,NULL,'Al-Haram St. 43, Amman, Jordan','e2P8sYSVScyuGKI07Bk6bv:APA91bHv3XxB7_o2H9h-w40kkodme0EYOy2WZ1Ndhw4zcKjzRFFDS4CtSoIgM_YAIeildkoufGR7O58BsKG8lFteZUxPyT_5TN6pZVPPGpZ9mB-bwj3TB62m08_v7BN7LHTyKTHZPxxA',NULL,'Amman Governorate',31.932098,35.896695,'enabled','1.0.13','android'),(690,'customer','$2y$10$J0ISi/O5bFVUx8vElcbfIO9pMF3FHowm4.axEC/l.AhxlfxOFo0Xi','780914363','mikesnap4@gmail.com','mohammad','Haden ','2024-08-13 20:03:54',NULL,'inactive',NULL,NULL,'Abdul Monem Riad St. 59, Amman, Jordan','dKSGeJAIGkRNkroPLtYP8L:APA91bFnSODPESdgVZsLCzYF3E3Ltj5kcOMzeAz62zlecC5xj1_x84m5OvTz7E6QLHc6aBhUdDhhmTj83BvxDmoE2y3Hba0q_bPuIpdFh0t5ln9CdpH6pO7ElKpQyg1BrEius4Le9BaQ',NULL,'Amman Governorate',31.949585,35.908067,'disabled','1.0.13','ios'),(691,'vendor','$2y$10$YlZ9pNcAyc.7CFM5z7weNuaRm3QLJJYNi/rCADRsk8X5Lu78TH0sy','791622419','omrannaser321@gmial.com','عمران','دار ناصر','2024-08-16 14:38:03',NULL,'inactive',NULL,NULL,'WWHH+23, Amman, Jordan','d3ojgad6TGCwd0jIaA6CTe:APA91bFt73OZZVVZyZMMZAXybAvEv1cMOGGV2fMmKaPKKEMmhp1-W-cN5jcLULOMaqZEcnCcPb4vjWHsBtWwNleDmpjkVQgbOKcNZp5njRNn1Fb-mbTqWHrIVVqAWnmUouvXdU7lD-3F',0,'Amman Governorate',31.927796,35.927369,'disabled',NULL,NULL),(692,'customer','$2y$10$FQI4lDQZ/ZhZLgRA1RK6hOJ0ymuzkJG10E8xPKmPV9DiZegwM5sD6','781175495','adamapril91@gmail.com','F','Q','2024-08-16 21:20:03',NULL,'inactive',NULL,NULL,'شارع المزمار 9, As-Salt, Jordan','fnQpWxvTQD2E1oFd4DPvEN:APA91bEX6o51NSKfih6dkQ0U9-Mch_Ysd_nsIG22MzM-texOd45-NIojKSMmR-nLqvwNAjYpIf6DR_LYIcPm5fORkch2lXDFYbd2LMjwEXuBick8mopI6sXPrvvLC4bBKAUcFCSQWkVR',NULL,'Balqa Governorate',32.049964,35.717943,'enabled','1.0.13','android'),(693,'customer','$2y$10$e/Rn2tGFc6aEI1FEojJELOFeyPKU2Pz4hOLqbDtX5YMdwRvshcze2','797179482','aboodabood7827@gmail.com','abood','klah','2024-08-18 17:43:15',NULL,'inactive',NULL,NULL,'Muhammad Al-Jbarat St. 15, Amman, Jordan','cXqgvZopQm6MXouJa5K_wo:APA91bFpia8xC0bMwNl-Lj6OrJiQQQt2U54Wrrn9e9eUctyP0A3-ipyIHmlF58h2J1KIN7luhClJ3BiUNqE5hlb2HNYvuECQ8La0dbEbSv94EFYReSiJ6fJBwpOMoNeEgcdy6tfcN2jw',NULL,'Amman Governorate',32.019154,35.852395,'disabled','1.0.13','android'),(694,'vendor','$2y$10$TKJ6z32VetpC/EaSEG4g.OCqyIOiSutjSp9q.TZdnKqecF6XUSjji','789361334','hsenhdede@yahoo.com','حسين','حديدي','2024-08-19 08:52:07',NULL,'inactive',NULL,NULL,'Yazid Ben Hatem St. 1, Amman, Jordan','c9SV2s4zRmCO1dH0dCZYi1:APA91bF4DGFt5rVgF2Tq3rT2Qix_1mrcAbp1Y-Oown9rTVgsJeQv-62lw4JVnEa1nipTLskjuxP3MjgPovBMckoyVAqR3FOGeOkasvlZoGHFwnK3ER23HSRSSFWgGfb6ahawk8Q7cLK_',0,'Amman Governorate',32.000766,35.915892,'disabled',NULL,NULL),(695,'customer','$2y$10$5/L3UQ2hqcoN/zyU5eJrpeGifyHVvUEj9InwYBqL8S2fPtz8KqC8y','797975060','sameeraalnajjar69@gmail.com','محمد ','دحبور ','2024-08-19 22:04:49',NULL,'inactive',NULL,NULL,'22PC+RJ3, Russeifa, Jordan','fE24g8kFQZuzZFwfBSqLVp:APA91bHS5XK66l3_Dz8I8mDbTLXwBi9738mQpLgNa0zs2EYaL1xIJHo4OcvGkzWp0dkOZRXDJqsBBNKh_0QwBwaj1QbdzH8g0PZzhU8aHqoChWMlg9xfMSgynq4OENXZIo9N213RpHHI',NULL,'Zarqa Governorate',32.036941,36.021549,'enabled','1.0.13','android'),(696,'vendor','$2y$10$6PRkQj6leocUE9ZylwslxOVPmt7jha8FCdp1ULj/ZqCCjjTkj6KhC','775126391','heseinalaaaldeen@gmail.com','زكريا','علاء الدين','2024-08-22 13:13:50',NULL,'inactive',NULL,NULL,'H247+MM7, Aqaba, Jordan','cz5b-6X6SYyiF9Dapaj2-w:APA91bF1xE-LPNkvsr76Po4x4OdabPQ2nay58T7QoVLbQzY-X7f5YHUMByz7HgHdvrELwt22hJ6ehYtXzFzB9Y_0vqLwujkEetgY2-aVTja2PElfGKnoDM2igkoyocB8ut-3fas_MEsm',0,'Aqaba Governorate',29.556225,35.014375,'disabled',NULL,NULL),(697,'customer','$2y$10$UVV1hjc75NW0TyXXV7YZuutmP0wnifH8twT3IfbRRb4SjQAc7WuOq','791485911','ahmadkh_harb@yahoo.com','احمد ','حرب','2024-10-12 08:01:46',NULL,'inactive',NULL,NULL,'مدينة الشرق، الزرقاء،، 346F+8M3, Az-Zarqa, Jordan','dsi-GDgzQu-aVUYTRO0pz0:APA91bHWUN0s0odSkvB0A8v1mTF8SZZJOvXApNvjVP_Qh7j1M0GsrOAfTuGR9-MwrqU8b2MD_Qcn8T4vaQWc8IonF4R9j5rdZXNrQ-0V-6EmpI8fmz2ibQuem4py48RjII-iTd2Jh2WR',NULL,'Zarqa Governorate',32.060764,36.124240,'enabled','1.0.13','android'),(698,'customer','$2y$10$yOps51a8sMHRJYJ1B0RI8.JJsd14A9fBnUEFZSaUNy1P/3yOKbCji','792855864','lailabam77@gmail.com','abbas','abu rayya','2024-10-16 16:32:20',NULL,'inactive',23838,'2024-10-16 16:33:01','2RPP+R9 Safut, Jordan','cL4r5ERNwEOgumSXEvWp6x:APA91bEQlbt0FOZ7fjGvn6XVQT0600w4SHnveqNX9Jdw5z6_YKFQteKHA3VgBOiko9nhoTt8lDnI-u-ccy1fMHZQpIeRIEkh16kfFKENXisAnbMeR67MxIsNdb1Jf2IVdpbd33NCoVKr',NULL,'Al Balqa',32.037027,35.835994,'enabled','1.0.13','ios'),(699,'customer','$2y$10$Vvh1GgsUUjzVht4us0Xoe.D/cMBU/MZvB07HWSIOm.5mtNky9f6s6','798015369','anasflame009@gmail.com','Anas','danleh','2024-10-18 13:22:01',NULL,'inactive',46683,'2024-10-18 19:47:40','XWHF+JCH, Istiqlal St, Amman, Jordan','cQAvo4J3R7aV2TicQRvzX_:APA91bFWnVQ4oqa8mBSPsE8m2WKCbTdxFp-qNZWb1LU6aTd6lz038BTX4trAfj-T-I0mNDRwoiR2Ix0WE9Rg96XrPx6QbhKSGGWAyAhFZ3sseQtisqZtS7l0WS-yWXM2RAWEVaDMxSMW',NULL,'Amman Governorate',31.978911,35.923282,'enabled',NULL,NULL),(701,'customer','$2y$10$6iNTscjTKifE6kokSE0eseBsE72Nq.oqLJkVdMqWxhloCUR/Vycx2','778800000','user@pickum.jo','pickum','user','2024-10-18 19:43:35',NULL,'inactive',NULL,NULL,'Amman','en_BYx0hQ-KxxTOkQLclac:APA91bEGqrqP7zwmA7VETk4fnqOxXx_21itzjOhQqoI7TIgr-0Lbw9_j8gP369qH_TCOIj_jtpVUiu6iMC1fDVaO5Q0TRYnr50QZPdnh57lwdCH6HFldwG9XkJ8iiSq4k3YuF_L-HrXY',NULL,'main road',31.990704,35.868914,'enabled','1.0.13','android'),(702,'vendor','$2y$10$H7YA8adXtcMIMJcg8Ail.OUm4beMZg88ac0Kn/9DCCRIkuZtEZgvK','778899999','nashmi@pickum.jo','nashmi','user','2024-10-18 19:48:15',NULL,'active',NULL,NULL,'R2HR+MPH, Raiit, Lebanon','fvTokIhITuG_3J5LxZY-Mh:APA91bFmfBEErKmmByhiF0239zoNKpG5B0oDuzfY11QcVJhiUEw3P_aM-LfSWheH0jYmdU2eA-atDRr5rPXZ3K5D0bsi3irWxa8J5m3HPbfGPDUt5OmmrjqgBQ-i61TOK5u9D3z7I1gk',0,'Beqaa Governorate',33.828942,36.041705,'enabled','1.0.15','android'),(703,'customer','$2y$10$NdSoGY851aQvfI5FQXj1xO7IE6GcoXD2XZETXSKFkdCE8H3b.m7be','780978565','batooalaham2009@gmail.com','بتول','اللحام','2024-10-19 12:21:02',NULL,'inactive',NULL,NULL,'Kamaliyeh Cir., Amman, Jordan','d-2CTar5RbiHAdhqFLzbSs:APA91bEqO7E-RqAM1rHvjJGTZET3O9DYaugooDXTsn527-RUVgcWjHccV-6ptW1o6HZopURuGMyPQuQ99C5vqulY6hp7gFWIv77gzde7aspF7uNDKipnJEZZPUfCag3lvGVpZ232adin',NULL,'Amman Governorate',32.028744,35.825436,'enabled','1.0.13','android'),(704,'vendor','$2y$10$qJZMCO4So.s.WhMowHOSoOKkhcfqtz6R9bgtk4oohMnNsPqe/hl5C','775998391','alharam12341@gmail.com','علي','الجبالي','2024-10-20 00:22:40',NULL,'inactive',NULL,NULL,'V2J3+GM5, Amman, Jordan','cG8Hu90aSd6gQ-DO1sZbhl:APA91bEI9eVz70zXpf5XXNg4FooGDK_2jFyUCLxNEFpt1hZ9kksDIwBA0PZTjfgyJacffzRlVXHUWj2Noz_flQvPxBYpT0JTMpmZdUq7S8iSuVkQjg2fx4I',0,'Amman Governorate',31.881360,36.004107,'disabled',NULL,NULL),(705,'vendor','$2y$10$.AoMqY81AqW0RfS1UW9ZzObAlBTag6Nvp4xqm4Xx/16PaFJrhPHfW','799945522','s0785085912@gmail.com','صايل ','عبدالله ','2024-10-29 18:07:11',NULL,'inactive',NULL,NULL,'23WW+WGX, Zarqa, Jordan','cyUFBpTiTTujdbUoDF02ik:APA91bG25OAVfl_ytc2hl3jWYBPt2SMl6AVMASc1lm3TRQJ8dPyKLBm3ojlN8OcXOts38n34DmqmTFLGs42jDW2tixfm1PqjFH3EMwJb41PnyV6w4FAx2AwUu5mh37-6tqZXFbN5sg__',0,'Zarqa Governorate',32.047107,36.096305,'disabled',NULL,NULL),(706,'customer','$2y$10$wZJuy/cBE1kmUFf2Apei1.AU5PEnPS9hBX3TrjJ9uDl0ZtJxsiBOm','796972354','manalnaserallah@yahoo.com','منال','الغريب','2024-11-23 10:07:17',NULL,'inactive',NULL,NULL,'3R6G+JQR, Ein Al-Basha, Jordan','cX4ym0X6SNCVE_0UAGJ6sk:APA91bHwRqryHR7J4lMY4_Sg8Yhtqr-roeJxPiOw9wd6VZJWCVUvzJak4EC3L6FUfUXGbvNHKNadEgGr9cmL8O6XZjhrSLhwt2aVMuA1oqqTjYKCl9S6kyQ',NULL,'Balqa Governorate',32.061349,35.826584,'enabled','1.0.13','android'),(707,'customer','$2y$10$gfU3b.No46ATgx1.JJ3zo.zCvXS4G55cjzTyTKo2vNZ8vmelOo3Ci','796604646','maesara985@gmail.com','ميسرة','ابوسليم','2024-11-24 10:22:37',NULL,'inactive',NULL,NULL,'Mahmoud As-Seraj St. 19, Amman, Jordan','eoPmyZEARoOF1IPA7ElPlu:APA91bHxs_ZtvrOFuJNSEnu9jqBVfHW2j6cD_EJpWtCkmVl4P42eYF4SalTamTdDLKGRuQECX7gwwu1ldctycENz4D5FcjZClp1mOEZb6qDLp30SUWk4AxE',NULL,'Amman Governorate',32.031854,35.841952,'enabled',NULL,NULL),(708,'vendor','$2y$10$W7RZHS0JtY1A17tm1B/Bve3IsY/8z6EwRyyuVbohq2nrNyOq/9bnq','785246870','rakanshatara1@gmail.com','rakan eyad ','shatara ','2024-11-25 16:28:24',NULL,'inactive',NULL,NULL,'Haroun Ar-Rashid St. 129, Amman, Jordan','d2_mPF8RTtavHOGcBKtu6e:APA91bEEV_nflzMOG9ycp0KqrwJ6qwRDXo5ZOPGnJ1AjMdUb3BbWHgsYpEyKBWsXtm2k1ILyDK9IqhoRs0zatlVFtBC9sSoL7hwyfSyTVt47xoBSh5G_SmY',0,'Amman Governorate',31.985719,35.915485,'disabled',NULL,NULL),(709,'vendor','$2y$10$0uW8lvUzCSoElXEPoZEik.gzlHdTftZiVMxo73XhaUd77e8sTSvmq','781934165','djjddhhx9@gmail.com','ضياء ','الجهيني ','2024-11-25 19:28:42',NULL,'inactive',NULL,NULL,'328R+PW7, Zarqa, Jordan','cgsnRjRiTbGrDUGtYyzGeS:APA91bFJMl01MpIQhRxSxKM1iIfDZz70w3TXKl5_0VaGSO0j6fMkB5jWZJ-szVZIQDZBpiA1Eisgm0HPxtVcJJVlp7I82WDeRA2TOJUhD6T_Sg8yc8svMfA',0,'Zarqa Governorate',32.066410,36.041813,'disabled',NULL,NULL),(710,'vendor','$2y$10$Qqaq8kA6aZJROA9c7FPBAeMAQglTY.CuZVFt/HcnouxD/36QPqmNK','798245458','barakatyaman55@gmail.com','حسني','حسن','2024-11-28 15:25:43',NULL,'inactive',47134,'2024-12-06 04:34:51','XR2M+C8M، شارع السلمي، Amman, Jordan','dY2n2ur8QJ-xV2kUhaIEbw:APA91bEQJieuQInOx0nuE7YebNWSO3O9Z0req2Ne1tqlJuoELVsRDGfkWVkXAs9TPKcLNlbGL4Nr_fiCXH0JPSlSN0U1Fa9RFfEkGRURfcypkWztLaeTFEw',0,'Amman Governorate',31.951472,35.833343,'disabled',NULL,NULL),(711,'customer','$2y$10$ajY8it4qYYUfGR7eh6qulONptTs9FTHn7v7DbEeZaAtIpkKKDOvDy','797512806','hmaaitah@yahoo.com','هشام ','المعايطه ','2024-11-30 07:12:47',NULL,'inactive',NULL,NULL,'XV92+C3Q, Amman, Jordan','datGlyoZRs-3EeW5eWrPQf:APA91bETBGTxnnWHdgBeej-ldlt20XNazX0Mm5PXITLajnQXGZxIBZhxb_zCrFqTeNt2s4CnZP5ecWC6BJ6FMCHnCB-sncACYtJwg-HlBByw1VP4SfeC_sU',NULL,'Amman Governorate',31.968709,35.849978,'enabled',NULL,NULL),(712,'vendor','$2y$10$TisLiZdJlkH9zaW5BnVhDOG0ujpi.12oxx/ViFwgs4QpoDloL3YXu','791933637','raedaldewarie@gmail.com','raed','aldewarie','2024-11-30 18:33:32',NULL,'inactive',NULL,NULL,'2WW3+5JR, Mufleh Al-Edwan St. 54, Amman, Jordan','df6jbfLNTq6nPBOVOVAlL0:APA91bGvZ33T-CWFCov7-qzOU_1QC1-Hnnyv1yBPLzu67jKsA6xA8a1vYX0GvAJR_-ws-z2aUDT9Obv-tnt7RCEr6OrqEJQBO0Vdqf-2bnQj4VfaZNNDry8',0,'Amman Governorate',32.046211,35.904554,'disabled',NULL,NULL),(713,'customer','$2y$10$nDJoPD8Okuo6UaEJcFoOmuba9QMFIyL2O7LH7dpLTVvIOVvT3r2EG','798599471','obiedatsana@gmail.com','sana ','obiedat ','2024-12-06 07:39:11',NULL,'inactive',NULL,NULL,'3V3W+7C Amman, Jordan','c1PJfEMKqElAmeGhiNUT7h:APA91bGFRRkn4vniaFCS43llDSFqkBy6Lh55ID2VGUiyCJ53tElt-0jffS2aH7YRNRUG22LBGcXDIY2eCP6zXAn0BL4FMvRM90LCfiJGKFucegKpayp16Xc',NULL,'Amman Governorate',32.053162,35.896032,'enabled',NULL,NULL),(714,'customer','$2y$10$TFuF1qOUM2v0MvXzJ5SytuixOM2cYzfjhnmFNC6H4aJQtkcGX4YkO','789697888','nourmoslih95@gmail.com','Nour','Moslih','2024-12-20 12:01:09',NULL,'inactive',NULL,NULL,'2RVQ+V2, Safut, Jordan','eJiasoRzGU7juIZ0A2lU2e:APA91bExZNqYb0roJagtICW_bhmYrT8vyrt8T9t0Z95BGLUnhqzIQHtnDRBo6GlWfHzqLW1ucHoA44-BkqRazXsFTQj-QxFcellfmM0g81zwLb4UYynPihY',NULL,'Balqa Governorate',32.044681,35.837545,'enabled','1.0.13','ios'),(715,'customer','$2y$10$pVko2CBVykS/ycFIAQulzOw9EZCcyPZjyALuPk6MdSsKs7AkAl9TW','786935996','sara.abedrabo97@gmail.com','sara','abedrabo','2024-12-24 12:33:15',NULL,'inactive',NULL,NULL,'227G+8QG, Russeifa, Jordan','e7qgAUG2c0gsmdFK4U_g4J:APA91bHI_cwKY4FiseM6s-TYgyYTjSW2cLeCyL1dnpPTi067JQtHiodRMU9FnX1YqgpIBDMhkaZ_sfS3LrAsVhTGjmCEUKJQCFMngzEHkKdc8-oYzJEAABk',NULL,'Zarqa Governorate',32.013006,36.026704,'enabled','1.0.13','ios'),(716,'customer','$2y$10$cX5gUU9nm1Nnl6w2RuQVR.IgYiCPa7IuRwzB2cpaRi.RmkDzCDdsG','775580440','abedalsamad97@gmail.com','عبدالصمد ','الشطي','2024-12-25 10:43:32',NULL,'inactive',NULL,NULL,'Tarek St. 79, Amman, Jordan','fmkJcAzeSYuzu2VsYcLhyu:APA91bHOb496gHDFL-Rlu1Yiznob2qklZPKS_4SWqyn73WHqkzGfLEhlARHlSJBN9_kvFsESBz595JLNnfVglFDHd0-oljJu5i4o5HgiYy9PgIZl0u1nLug',NULL,'Amman Governorate',31.999107,35.944093,'enabled','1.0.13','android'),(717,'customer','$2y$10$enZQJmGvviqdnWFc1yYTMOxDKr.MJ378LTYbyeaTrmw26p.xdkUEO','792837908','noor.deb.2019@gmail.com','نور','ذيب','2024-12-27 18:43:38',NULL,'inactive',NULL,NULL,'WW2X+H2Q, Hizam Ring Rd, Amman, Jordan','e5uhqpYrjE1-vGUhsKmMmH:APA91bGUlsBEGyPEXdwyAPQGsqVYNal4DVrq835kiFoGnYESeORK18MQhPQj39IgvfRzPH0D0b4rfsr53j40YrjojF1QU1oOuXTzsSVXcxBdq4GYmx5AU1c',NULL,'Amman Governorate',31.901410,35.947364,'enabled',NULL,NULL),(718,'vendor','$2y$10$kPDSR94onieClo1QbVXzTeyToqw.RJuG8PVRO6NCsEHB0p4P6kpg.','786664052','osamaalmsabha@gmail.com','اسامة','ابو صعيليك ','2024-12-28 19:26:52',NULL,'inactive',NULL,NULL,'منطقة النصر،، Amman, Jordan','e7qzAZ5NQQGvRVShcUmNeC:APA91bHZqU2JLWFxXjFiftsrih5-CoWJO7J5oV8ed2tDsNVYffXWLa3jkT0E8a7hxehHaJiVwWEGHZrZn2XhFkIQagwTr8gTgmRGHQ-kqJhyW1zjRol-vbk',0,'Amman Governorate',31.964432,35.996407,'disabled',NULL,NULL),(719,'customer','$2y$10$gOMY424oq1p8efN4kS3a..HFRx3Sy.uKARmpUExAi6tV4urawLryq','777322332','okushb@icloud.com','بشار ','العكش ','2025-01-06 18:54:32',NULL,'inactive',NULL,NULL,'Abdul Qader Al-Jundi St. 99, Amman, Jordan','dTNvIoaKZUB7l3KrdKnCHn:APA91bEaATmEVE-Pym5BeCaPFU6FzdAGtlMCd3jabq0Lj72zRLkBp4jFDErxErev9ezR2Gjvzl2O8E_JfE7Q49gaxPUsJqK8oSOwMN8KYAqz0NVZcWuaR1U',NULL,'Amman Governorate',31.911871,35.929046,'enabled','1.0.13','ios'),(720,'customer','$2y$10$ASVKW0xupqharaHVFbVGVeL8nnuem3cEHoEFdks5um1c90CFwWPnC','795669280','yousefmh4@gmail.com','yousef','ghana','2025-01-30 13:28:28',NULL,'inactive',NULL,NULL,'WX4X+3CF, Amman, Jordan','fkVUdMnA5UmpnYjB_1mX66:APA91bFfU_xJdZsh6yg8mtrYeuKu4aH1LZfH5FnpOo_vixyGiD_b3hqQj-zhS3QgAMkOiH6dqualdeA9q4MjXgQMlevU1SNxoSNgXgTEIRAxGsGsTOsnQCE',NULL,'Amman Governorate',31.905348,35.998328,'disabled','1.0.13','ios'),(721,'customer','$2y$10$MKpwAdn7SYuh0lPjWJ.zJ.CxFzKHW.lWNrcWikxRgF/tleL1el2my','779347965','Mshlahmd569@gmail.com','مشعل','الاحمد','2025-02-02 12:56:17',NULL,'inactive',NULL,NULL,'Sami Msharbash St. 25, Amman, Jordan','dt9Q2_jGRLOoc3DaZCMkXe:APA91bHQ5JK2ko5TEeFvg81zipz9OxduQ9mxtmWkdJGAJI3IcK-KCdXlKTTyHvIPNpHK8wrM569xZjHorvkbXpEBagShbogod8BOKiVNhqnK8IVyGntgnYw',NULL,'Amman Governorate',32.048195,35.878186,'enabled','1.0.13','android'),(722,'customer','$2y$10$rfsLEMQ2QPmzvXRPq.B0qutQ2SPOEH5f8NfJVUV9cMx5xPvI0zKGu','795747032','obadajaber4@gmail.com','obada','jaber','2025-02-04 13:43:13',NULL,'inactive',NULL,NULL,'XWHJ+9CP, Ibn Saed Al-Kheir St., Amman, Jordan','eQFn4g-HM03Dttysl5CzzF:APA91bG1mwT_A3VHxVt4hSryzuLFPe1V-RStyAPNteKsNqGoOAT-XmKDDXWaFCG7mmDoQoxy31DvJ30mJaIJz2HWe4-OtiscRmjV1sevdmWlr7O37Uo_i-g',NULL,'Amman Governorate',31.978704,35.931184,'enabled',NULL,NULL),(723,'vendor','$2y$10$sqLC/IVC0IITJavR5BsMN..VLAJa1RzYgslLqFVwDYcT9a1zzBXxq','798170093','pakertpaza@gamil.com','بكر','طبازة ','2025-02-04 21:53:45',NULL,'inactive',73357,'2025-02-04 21:55:05','Qays Ilan St. 12, Amman, Jordan','cNlEfpT9Q4SkF-dO8_B8zG:APA91bEiWMerxqaQnqCC3ycd4IPtsZ3_J94S6cY3arvhF46XAICjIle5uQa4QNQT8biVAsc0rx7uBcZL8cDzqMH7UTuZXJDcSy5q4C6g2y8rdwfKza-Revs',0,'Amman Governorate',31.909054,35.971557,'disabled',NULL,NULL),(724,'vendor','$2y$10$bSc1mhTegw76OwTL9v0IEe0EXOBESRUHmnxgRlAV.DUR0tRkVXsFG','788788569','mohammadashor5@gmail.com','محمد','عاشور ','2025-02-06 16:50:54',NULL,'inactive',NULL,NULL,'RWRW+PXW, Amman, Jordan','d72uWuqCSlK_bV9Aa89myJ:APA91bHyV_gHAnmZdjWPK_d7u_pxgEQJ2wAm1BUxgI_ikhu1-eE26-YcCT2j9Yql3f4Vm6PfTB_XnHAMuxktwy2wzN01BABpxk238jETyfiTPqVlYMEnlB8',0,'Amman Governorate',31.841380,35.947694,'disabled',NULL,NULL),(725,'customer','$2y$10$/WFYApiWgqvKJ79hndg2QOKRwB1l4AstOcVavSvRsN5ewKgKWsKWG','795533155','mohmmadahmad50@yahoo.com','mohmmad','alsheikh','2025-02-08 06:44:46',NULL,'inactive',NULL,NULL,'2V82+VRW, Amman, Jordan','dTQVLHsyHU-AgLaK3Sd9So:APA91bEXY_4oRZt1sTs5o2_Qq2v1MS3zgsSt-_NGs6xPZNKk0jkhOu0CD7BqNd_M4JHjLdPnzASGuxIbx_KGYgDRW-zW8Qw2yMnpSSPxUbsta9yl3AO7Y74',NULL,'Amman Governorate',32.017328,35.852030,'enabled',NULL,NULL),(726,'customer','$2y$10$mu664nYUMZE6TMfTNRoF9eH9VjiQnYrMOGjg1GNGFfOWwmre6Bc4u','780673182','جهاد@gmail.com','جهاد','زين الدين','2025-02-28 09:57:30',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','eyagooCtR7mSVr_SVrHZgE:APA91bHtPxGV1i-9K9JuNtLJiRtovI1D7qQ5ILmypPPr0KXxh9vSTEjzN3m7QvIbJ3fHt8_TMwndndHVcC1rhd3pzWRaK0yuFTAPrRwgAPguL5pnANk6CkY',NULL,'Amman Governorate',32.014145,35.865290,'enabled','1.0.13','android'),(727,'customer','$2y$10$4tr4La9aZXomYxM.0g.m1uuF401alJ3/sntxr6Eastr301OWG0ksi','779209444','momaniabood286@gmail.com','Abdallah ','Almomani','2025-02-28 19:35:22',NULL,'inactive',NULL,NULL,'Amman nagar ganapathipalayam, XW36+Q64، عمّان، Jordan','flXbPEVpuUV2t_aooP9AUo:APA91bGoTTzXZPgQJNXZEXikCl2KQ0nrHNfBZkdrZsPXjnl-4aOXxeYgTgdaGtxiCbfnvzXD0qSC_3wFJGBadsffWC9kGvE9o1nJJRC9fh25mwSgq-n8uf0',NULL,'محافظة العاصمة',31.954379,35.910578,'enabled',NULL,NULL),(728,'customer','$2y$10$ct83/krTtpXuq/hjxjH52OMMWGELW/4ip.lzWDssEAMf5vmi7uQ2O','790165768','karamalqudah32@gmail.com','Karam','AlQudah','2025-02-28 19:35:33',NULL,'inactive',NULL,NULL,'8QR4+PCP, Ajloun, Jordan','eJoIMo3YPktNsVQ-xtQDJy:APA91bGK8fewIY3C-HqR8Dg7A9VFyX9qWtXn5WYURMfKmYGATOrWHU0gMNNDGDDah_dYDIfupoD25zfNWHn36rzgbnq4bAM-hfNcelIKo5w0xE5b5-uX4Pg',NULL,'Ajloun Governorate',32.341626,35.755894,'enabled',NULL,NULL),(729,'vendor','$2y$10$LNEJylB/55mgxYb10lr9Z.pe.EtHRJ5M1CLyoQS3AbwV5ke7zw/IW','778951202','lykhlas439@gmail.com','اخلاص','علي','2025-02-28 21:05:19',NULL,'inactive',NULL,NULL,'35 89،، Jordan','clxhdx0vTQWT5snTRY8ZTf:APA91bE4k7odmyhh8orFSOHlZpzoaqp0z2j4o_WxTOcROpuxTComDwHNBNx8TMeWaL_VuV9SS306QpFOw7BxonKswlzDRUW0krnamLFnbt704bHKBwGZ9Ms',0,'Tafilah Governorate',30.876975,35.685213,'disabled',NULL,NULL),(730,'customer','$2y$10$KZYHZx7gWcWxh66aGAoiyOi5BINskeswDxztz5PxCtP9BuP8SQSQ.','795951091','mustafahattab20@icloud.com','mustafa','hattab','2025-03-01 22:04:00',NULL,'inactive',NULL,NULL,'3V58+7HX, Amman, Jordan','eyGQV7Y6l0I9ozwHs2jHy2:APA91bEGl0O9_NXcxTK0Z-J0oVoOhhHhYnI7C6_UvpFfHCEkXCwXg6p_KwkzbhL6qAMfkqdC1KdSCV-RFQJTzqrsuPX7ZSWRJedzHwOIdfdbjgG5cUJQJ2A',NULL,'Amman Governorate',32.058015,35.866545,'enabled',NULL,NULL),(731,'customer','$2y$10$drwPbXLZvx0rFcaRPTbPyuj.QoWIxBibzuEZmlf/K74f/FTFguiWa','799249977','hosghar@gmail.com','Hosam','Ali','2025-03-03 12:42:11',NULL,'inactive',NULL,NULL,'2VG4+9Q, Amman, Jordan','fxOP5znNBERqvhIM7xghI6:APA91bGzAfd7k2RChnMecOE66ysR8iS3QdfkZcknhoVfftjrVcdhWbIEFY0vuTpR2CIsvjaEo7ALCDHI7QUiGB4tetHnDI1rg_aud5iYMXbuEe25smqwlyU',NULL,'Amman Governorate',32.025918,35.856801,'enabled',NULL,NULL),(732,'customer','$2y$10$FR.uaeI9psmvdnMZ69SPZufPoJOQQR1Z5rIrD53x02o6TIbhQQZNy','786335270','enghaniaeman@gmail.com','هاني','الجليلاتي','2025-03-19 02:27:26',NULL,'inactive',NULL,NULL,'VR9V+WF, Amman, Jordan','eTYDcU16TdOZwzYoHf-9Mo:APA91bGojbtTdmZ1nlUQBCKSHxj1ASyoRMt_6VLN0Wcj2pnZXnoOeDfPZwKbij_kTagHC9hDtXuhNulwsbLqsLjx5wcAFVLzy41N-z6sc1Fi544nebkhQJk',NULL,'Amman Governorate',31.870185,35.843719,'enabled',NULL,NULL),(733,'vendor','$2y$10$2OTBHiqCkiZYA62x/RDKpex16mDBxu049QS37AIZaB6fMD6A02GHi','790309498','sbhyabwnhlt777@gmail.com','صبحي','ابو نحله','2025-03-26 09:58:28',NULL,'inactive',NULL,NULL,'2W3P+6XF, Tarek St., Amman, Jordan','fBCjNxLMRDSEJl2mrUcWVl:APA91bFoRDR5qrYNBLxheytrcJxQQQgCvSo17F7LyNjI_NJIKpRL-o6YO3RRehmXlSGI5oOIGNkyXEepSRErrTyktRm-UiDLKx_WPPgEqC31Qw-NnSKTJ3Q',0,'Amman Governorate',32.003065,35.937411,'disabled',NULL,NULL),(734,'vendor','$2y$10$PO8du5Uc3XXftXAnr9LJJuKvsSzhSle5SWPSVZvc/vabctK2NQSMS','777335291','yazan@gmail.com','yazan','taani','2025-05-23 11:33:08',NULL,'active',NULL,'2025-05-23 11:36:40','K. Hussein St. 505, Amman, Jordan','fGAky4tpSGyQW2qOry0T6a:APA91bH-5ZmKX2HVlQSgNZPH6_Nx9am1cHr0o1cA9dAwSTLceR6E-BVfPc8BcmAJ6WsWRORSUXKooXIZVwKoHXCzdKLephCnhwFphJAz7EsEYSELQ1HJe7o',0,'Amman Governorate',31.959002,35.918004,'enabled',NULL,NULL),(735,'vendor','$2y$10$9nUd3C/RSgrgUfvL0fZheuxG/WUBZXnXBNDSxmfqL3gDJqDw5dB76','788506658','test@gmail.com','test','test','2025-05-23 12:11:51',NULL,'inactive',NULL,NULL,'K. Hussein St. 505, Amman, Jordan','fGAky4tpSGyQW2qOry0T6a:APA91bFwTQHVFgufI2zvbj83QhjEw_3UeBqtD2e8cl2iIEgx_CR-gBiujlo0DGcqnqCNkteAPh55FP9oEc96TL8eL_S2GqJ8lkP5FprTC2Ka4vr_IV9KU1w',0,'Amman Governorate',31.959034,35.918013,'disabled',NULL,NULL),(736,'vendor','$2y$10$/o5XRNSD6yn5tt0sSvimH.kr8zpMOZ8pUgtWErXgJKc.kI71jj8uG','790575286','ahmadmousa@gmail.com','ahmad','mousa','2025-05-24 18:32:52',NULL,'inactive',NULL,NULL,'Abdali Amman, Amman, Jordan','eoEGMILpSZKVUd5l81W2t1:APA91bFKaJphVZE-dKtdKn9VJA6Ro8-0j-OIwWemRimjUTLdOSmv5IxafdrKvvBaAcw7GfyrKmqGv_5CzJ9KXhKdN-3ldZOjzL56gcZvtquFg1tcJ6TXvts',0,'Amman Governorate',0.000000,0.000000,'disabled',NULL,NULL),(737,'vendor','$2y$10$5JGpOEviSvLw0aesT31qt.iyOxcLzn2tDeX6teaASz5DuU1qAKEw6','792992023','ahmad@gmail.com','ahmad','ahma','2025-05-24 19:11:34',NULL,'inactive',NULL,NULL,'XW59+J6 Amman, Jordan','fGAky4tpSGyQW2qOry0T6a:APA91bEg5te_ZoA5shQSJW3Xw_OhyTR6AHZK5mihepRH4G6BO1eyAr4IUf9tTei0vK8WNUGj-m71Ce9_McILxW20_IA9goFfXr7w3rIa4G7dYmJW3fkD4Yg',0,'Amman Governorate',31.959056,35.918016,'disabled',NULL,NULL),(738,'customer','$2y$10$0kGa5EwkNl9VFcDdoUGO6O.WuPspplgonnvfbtfqVhv7asVCiOn6e','0782605651','rafatbickum@g16101978@2025','rafat awad','rafat awad','2025-07-15 07:59:20',NULL,'inactive',NULL,NULL,'','dZ7F4_-tQveMb2Sw6QKltG:APA91bHN9K_ihXP_X7a-Op0ZT-9qlKvKZ3-eUQAtdo3MeCiH3uiOI1sUfJ3763r4ApReCGg35Wygi4lPrcNSlrD6XbXEQ8XW6jV2JFR7uvIByd3JHxDTFkk',NULL,'',0.000000,0.000000,'enabled',NULL,NULL),(739,'vendor','$2y$10$n129KWpPBhb0.JeIZxGfQumzOkIQ..8fh81QEDOwKYdK41GE4317u','790575255','ahmed@getbaraka.com','aha','ahah','2025-07-21 19:52:37',NULL,'inactive',NULL,NULL,'XW59+G6W, Amman, Jordan','dnfC1g0kTUWfmM5RVXJR3g:APA91bEfBrH_H6qAyCEPZT-w69Mxh7xB7DvbT4Url_uWopok8tx_lyea2ugaapKvkhpTr21mEZvJKDI9izGLsUlvy8oIrF2F8dEdFk9f3dSPzq_vNRg6aKI',0,'Amman Governorate',31.958873,35.918057,'disabled',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_old`
--

DROP TABLE IF EXISTS `users_old`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users_old` (
  `userId` int NOT NULL AUTO_INCREMENT,
  `userRole` enum('customer','vendor','admin','subAdmin','viewer','sales','crm') NOT NULL,
  `userPassword` varchar(255) NOT NULL,
  `userMobile` varchar(15) DEFAULT NULL,
  `userEmail` varchar(255) NOT NULL,
  `userFirstName` varchar(255) DEFAULT NULL,
  `userLastName` varchar(255) DEFAULT NULL,
  `userCreatedAt` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `userPic` varchar(255) DEFAULT NULL,
  `userStatus` enum('active','inactive') DEFAULT 'active',
  `userVerificationCode` int DEFAULT NULL,
  `otp_generation_time` timestamp NULL DEFAULT NULL,
  `userAddress` varchar(255) DEFAULT NULL,
  `userFcm` varchar(500) DEFAULT NULL,
  `userCredit` float DEFAULT NULL,
  `userState` varchar(255) DEFAULT NULL,
  `userLatitude` decimal(10,6) DEFAULT NULL,
  `userLongitude` decimal(10,6) DEFAULT NULL,
  `userVerifiedStatus` varchar(100) DEFAULT NULL,
  `userAppversionNumber` varchar(100) DEFAULT NULL,
  `platform` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=735 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_old`
--

LOCK TABLES `users_old` WRITE;
/*!40000 ALTER TABLE `users_old` DISABLE KEYS */;
INSERT INTO `users_old` VALUES (1,'admin','$2y$10$vlha0AqxyGjRS0VXTMLQCO8OeyyRVBuk8N4SFbdNAghM1Nje5amq.','3955088','admin@admin.com','mohamad','mrad','2023-11-27 12:51:24',NULL,'inactive',12031,'2023-11-27 12:58:06','jordan','uuuuu',15,'Amman',33.775063,35.889796,'enabled',NULL,NULL),(48,'customer','$2y$10$DrL/oy.jxsn7UpN8x0FsZuDHjQ3gX0HbSI/64vPCWX7cPMoEXz6t6','782303071','alaa.alzaibk@gmail.com','alaa','customer','2023-12-26 15:19:04',NULL,'inactive',52859,'2024-10-13 20:24:25','Italian Hospital St 76, Amman, Jordan','eXrHdgn4StiRonJf9ge830:APA91bFfl2vk8WMR7wYwNKVFmt4yqC5sfZVMeJlnK3pLQv8Iq-cU3XLQERUzS_nyZSpFGw1vUHBqjUzb48jx96vX3flhgNPc5XM7sK_dUVRyiIvZHvTFNwY7-xZVGfwMYhvpDa7wwH1v',NULL,'Amman Governorate',31.944366,35.929668,'enabled','1.0.13','android'),(63,'vendor','$2y$10$VFtHb5p811cH4urnMhqsNOoanZLFJIFycQfn9cN0VoKHt8Xo00BMa','781799992','mostafaspotify29@gmail.com ','Mustafa ','lgzawi','2024-01-15 10:21:45',NULL,'inactive',54152,'2024-03-26 10:46:17','PWH5+M9, Aanjar, Lebanon','feMEHEPeROeeeXFi6gQnSG:APA91bHAph8wsA5Z8DGkT4hqWGrGQzMo0Uc65tsde2ZQMOty5xkxxUemLL-Bfe-Xniy1pH3a_39zpSk4yS186he93tF4y6DQtUp_jWaAzrOnN9Btgn0jbMXOy6PNs8YbZLhEvJ5vuL6-',17,'Beqaa Governorate',33.730006,35.909597,'enabled','0.0.1','android'),(64,'vendor','$2y$10$ZKspatHDEQiFvziI/4BpSuP5VkUB4TnnvMyaAd//fWty5rib.HPzu','795119611','nasrallahahmad02@gmail.com','Ahmad','Nasrallah','2024-01-16 07:29:53',NULL,'active',NULL,NULL,'WXHP+XR2, Al-Jusoor Al-Ashra St, Amman, Jordan','eFOZFLJrT_KwubalGKwtX8:APA91bHTjNv67RvF2rOOoTKwtOCjpOdi3sOwYAMkMF1qBaVHUXmmdFi9o9V2lkpY4E2-SvGTF8sXEZ0u5r1H9_ynhAU-7llxLfqOEF54FpEhYiCkiBt4dT4V34PUvJSfWhBHXmS6AZAT',0,'Amman Governorate',31.929647,35.987135,'enabled','1.0.15','android'),(65,'vendor','$2y$10$xScP5rdlU.KnJcWDi66WYOukBLsK/k6yLCBwHLCggKK9JjWauCrC2','797715306','sharkljnk7000@gmail.com','yazan','abo sherbi','2024-01-16 08:02:52',NULL,'active',NULL,NULL,'Damya St. 35, Amman, Jordan','dInohxkaRj6kqNOpKGGzqT:APA91bHhLR3tZs9h8MMwOC1CJXgda8GXWA0nwOnIeyUH3PeJL7SpMffz8punpujKwWpO1Yzq31vq9j9uEz16nGM64RFBuhO_tn5mtPse5bqFmuSeXjtWRu_msnaj_JI7WLJZBBCm1xPG',0,'Amman Governorate',31.974950,35.929172,'enabled',NULL,NULL),(66,'vendor','$2y$10$Y4y/a8SFrhZhF/18nTZab.I5xh2vNxBPJmowzIBAiHRKGFy.zdw/i','796206575','waseewwwwoo99@gmail ','wadee','salah','2024-01-16 08:47:06',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 18, Amman, Jordan','dr3ox2NyQEe6wCTrQMScAq:APA91bEmUsq_yo4BOvZxCXVUWyVntD3qgWF82RmawvMtewQMDZ0Hy68RrsythyDNcyf1VBr5iU9bHDN-Pm44JhPckB0OJU6Moh9uGxKj61mZBoQBkC-8oA0IdO3upH7yln-GrPz28D5H',0,'Amman Governorate',31.989801,35.871353,'enabled',NULL,NULL),(67,'vendor','$2y$10$8ILnche9F9GQ6wDvQHfkI.4GRIIVZr5QpYOswVPoyjiMCmV0iN7.u','799675727','thaeraalkahatab@gmail.com','Thaer','alkhattab','2024-01-16 11:03:09',NULL,'active',NULL,NULL,'Al-Madina Al-Monawara St 49, Amman, Jordan','c9qczPBPRaWmwlwhi97tyW:APA91bEpTg-lcwykIhq6E07fogzhBR_zAfGN0PJB3R_l4V1gZg-lnenJdWQEHRazxqIBuIFV-aXdwfUhILvVdwaL7jHDQ9TE7jlbl4EtatRBPo95N_ALtRuj_d12ya2V3imoC9r9EGcg',0,'Amman Governorate',31.966258,35.863557,'enabled','1.0.15','android'),(68,'vendor','$2y$10$ebbzafh.K5P8mRUTkRIso.LDaqHkuWMRtl981MCrFeMDH2IDLLOai','777303017','rafatawad1112@gmail.com','رافت','عوض','2024-01-17 06:54:44',NULL,'active',NULL,NULL,'WWRW+C5G, Salim Al-Yaaqoubi St., Amman, Jordan','cAzXssffTs6_aJLrT0dJL-:APA91bGxXzrLlHW5wTnHDjpAswqBXo9hcMpuP5CdcExG25FNVoXhBuVvc1COMDHHdUzD3TyGNI8Z4aI3GNJYrxupDfy5OkcouNEwA6HbWEyNzDo-nxvJb06_gLA7Mqcsz0NYCC9xmeFJ',29.5,'Amman Governorate',31.940978,35.945183,'enabled','1.0.15','android'),(69,'vendor','$2y$10$9CFY/YW8zuMmpHQNzzsvI.vZVOmb87/RaVJYh8tu.T0Z7/Q54QNkq','797684286','Mohammadariqat55@icloud.com','Mohammad','ariqat','2024-01-17 08:14:08',NULL,'active',NULL,NULL,'RMW9+H2 Ar-Rawda, Jordan','cCEkM-i5S3WJWeb22df82q:APA91bFQcrMxb1x6XpNMXIW6uyUUJnRRxmnUEL-VrLt7SBfPQlrRcBLZM00fQj-yIK8yxdTtJPF0or-0RUQjCUdRgMk8COoNK_lYnqfcIWHezcUXNTK-OnAOS1nFQ2CK8Rw09EzenkkK',0,'Balqa Governorate',31.846422,35.666851,'enabled','1.0.15','android'),(70,'vendor','$2y$10$MLr1vv.mMxYKYi25KwOBOeLDBGypbptCTP4Oc3QnJLHtZq3tEc822','798029152','greenflamegas123@gmail.com','Ahmad','Abo sary','2024-01-17 09:56:11',NULL,'inactive',NULL,NULL,'WW42+5MP, Hasan Farraj St., Amman, Jordan','dXdDbOL5Qrq2vab7h2UQtS:APA91bGMb25isFBzg7MfL05tApCGkWO-w0v68XeEM08eGv9I503fpQu86jNOfM46_XVZxIXJBNo0XodWP1xgwZwm0ICR4V0rSvtoGbo403petSlDSK7Z2yFuni9Upp1YsH5myeBLlYFo',0,'Amman Governorate',31.905437,35.901907,'enabled',NULL,NULL),(71,'vendor','$2y$10$mHbzf5adtd0olFJCfkYpLOhgF2sA7EBUivv/fe8Qz1adlNvgkz.ba','798029151','tarekalshobaki@icloud.com','Tarek','alshubaki','2024-01-17 10:06:22',NULL,'active',NULL,NULL,'WV5R+WH Amman, Jordan','cAgFPq3-RJm50ZEIHrute0:APA91bFYlGmzAJ5BJJM0dsK57LfsFahlg2BNok3C8bXdvyzvxktMNQ89Catm9y8qqbcIyBC2WYFv8AD_a_DDIfie-xnKKgdd1pfacIhMaTcnZ-ZogcisiNIn647mYDAJgiiVPTalKkxj',0,'Amman Governorate',31.909813,35.891384,'enabled','1.0.15','android'),(72,'vendor','$2y$10$AkKvFqgUoc/u2HioXDe5G.g8blQD/eOKFTvZEzpOxbIdblgS8B4Ce','786165370','ggold6049@gmail.com ','khalid','najjar','2024-01-18 08:16:26',NULL,'inactive',NULL,NULL,'3RGW+WM Al Hanou, Jordan','dgUoT9ypQY2Fdp4hkzgo5k:APA91bFlAPce62UJtFOhsgqYvyncLEx9UyYuA8oYjjS1LCo_-U74yi4265-1vUih3EcIIUMQL_yLj1ScKwsan8SODfNlbb5s6KUFBdFfeYLF-ZP3lxJlcad9XQLso51f0iuWHcZxtH1z',0,'Balqa Governorate',32.077295,35.846675,'enabled',NULL,NULL),(73,'vendor','$2y$10$2A1gvz8GqBVLwUCTOieohuhrUJMxrlvGLkTEET5.eqAruSK/BE4ny','795124484','albadyt71@gmail.com','hekmat','sakarneh','2024-01-18 09:29:33',NULL,'inactive',NULL,NULL,'XQCP+98, Amman, Jordan','cdJLucrMSAKeEpLyvAPb9j:APA91bGIO5bLJwUDQOOCr4rgh7qJ0TAOq_iAVKCVBCBAwVGz8h8PS4B8tAF6_3TrYZJ4dcMWtrSwLzHUmxvwNC8w4_aIyQL0FihoLsJemG6lK94icbBkAJSFpsWTUxzhjjD60sLf4LC2',0,'Amman Governorate',31.970647,35.785986,'enabled',NULL,NULL),(74,'vendor','$2y$10$BclW7tdHFtaYlkwM5dApheF0MS4Kz5i4zctfCS1XZ.X9sNQgXsLA.','799554694','mohammadsulaym123@gmail.com','Mohamad','abdulrahman','2024-01-20 11:19:16',NULL,'inactive',NULL,NULL,'XVGM+HPF, Amman, Jordan','eo9EJn9NQeebCh7V4dyBoV:APA91bG6lQrlQUYjh9XzwMXLvMlvI86w4Fmpd5KWOC0FPto0eu8Gi5obGaKgybpUc6k-M4CCSmvmfWQi8NeNOYBUYlMCkPtjypCb7rpxyTduRrqMvFRPf3Qw8hv6iqiy4fe4WQaJn8Z9',0,'Amman Governorate',31.976424,35.884367,'enabled',NULL,NULL),(75,'vendor','$2y$10$2gbJb18UFtEK8ePp5UnCruHYwzsgm5TpxEPTar/ZMRL8XDfFFITWe','000000000','aa@aa.aa','alaa ','alaa','2024-01-20 12:30:22',NULL,'active',NULL,NULL,'Wasfi At-Tall St. 139،, Amman, Jordan','d7haFDm3RyGXd9dI5MndnS:APA91bHBGRTQ5oqcFhcBV22eAuUxIfIyTzuFW4nHU0T9S5P3L7ipYRtpr9Z7X-AQ8jEonrsQ8VNRGmT4tvVaX7enhIf_SvDLR3EsNM9BP1IN434dIBImwc-KcjBChcfrr7DibXAgv-Sc',0,'Amman Governorate',31.989899,35.871399,'enabled',NULL,NULL),(76,'vendor','$2y$10$FM4nZEsTZjROwVEIMzGH3.0fZoHyQP.ifMMRCnjtKHENCknj12h3G','780108301','s3982068@gmail.com','fayez','manaseer','2024-01-21 08:15:55',NULL,'inactive',NULL,NULL,'شارع عامر بن مالك مجمع الزيادات التجاري مبنى ٧١ مكتب رقم ١٠٢ الطابق الاول, عمّان،الاردن، Amman, Jordan','egn5aoBdRjGSrDeEbTSliu:APA91bGV1iIImAwPcOWPytuB352nFxwFq57nAXs7rRg8W8OBg6xvRkO39ySvMGQFT2g7d8axkdNwdFOiyUdb8KqbJtAEJ3IUgcV0z2Jl79Hhg5cdQCYXPOuj1aDY8cPxz-fHWxNcVsLd',0,'Amman Governorate',31.991494,35.849062,'enabled',NULL,NULL),(77,'vendor','$2y$10$dIBNw.SmHgOPpQczjzDwW.VJ03CzdSQXvbMQhqvdf7VSLBR3AQoWS','797791314','sadamsahory1jz@gmail.com','sadam','surakhy','2024-01-21 10:40:05',NULL,'active',NULL,NULL,'WWH3+34F, Salim Al-Jazaeri St., Amman, Jordan','ciWGS7MPTHeOeEWK0eK_uY:APA91bEP0gGaRBxVfEMxIzWOKZi5UfSLWnA_lxXgOY7du7qTToYe8wM_EDpyC_9klwCZZSMHrGpb1bBWin7rLnUHGvzpyayLn0wEVK53r-7umluMCS6nyQFvHV-cUHkg7-WCtFRp0OAm',0,'Amman Governorate',31.927721,35.902775,'enabled',NULL,NULL),(78,'vendor','$2y$10$0fGTwYOYcmOBVj5HEudLN.h0t1tIkFLj47eONI3MbY7XEtOP5T8Mm','797475703','hymwrly01@gmail.com','ali','hamour','2024-01-21 12:08:24',NULL,'inactive',NULL,NULL,'Nour Ad-Din Zenki St. 129،, Amman, Jordan','fxCq4RRuQ4628ANKn5YKk5:APA91bHPif8M27ORgn-pD-aWlhmpqLaCRqhFVu85253JoegOyMyc2WxtJxcWlHAAhkjYPRD9-SrKUaBRC6cY0YaIeI5DuwCIy1faj6cWT-uz3GXmOdEcASRu3n4WMXXqIaoDJqAVDHA_',0,'Amman Governorate',31.946563,35.913948,'enabled',NULL,NULL),(79,'vendor','$2y$10$iAIJjCEQThemO5PsJcfhjOhK1sSwSWKFMD6X4nJoqVNpKqJb0JORO','791441506','tamaramobile@gmail.com','عادل','علي','2024-01-21 12:34:12',NULL,'inactive',42386,'2024-05-09 05:30:36','Complex No 60 Saif Al Dawleh Al, ش. سيف الدولة الحمداني 60، عمّان، Jordan','fXb1Bz5ITM2HhJE9g_ZT7Y:APA91bHV0xshVuWzDWejyzmO2kmjsU1CpwlfpNNfGmBeDTy9klbadhh_GUpkdh3v6BZZyYBV-Q0rHcYSqHu0j8hE6oOQ-eFaTSrIwXo_1o1znKoQxg00gcSa4m92gymrCnxPn58nQYBB',0,'محافظة العاصمة',31.941692,35.919081,'enabled',NULL,NULL),(80,'vendor','$2y$10$AJH5MzWm9GtvHGYtL0mxcutnaicPe5ZzGmW0ievprh1Flnzz6SRLa','791985360','Mohammedshaher132@gmail.com ','nohammad','basher','2024-01-22 08:10:03',NULL,'active',NULL,NULL,'ش. أبو العلاء المعري، عمّان،،, XWCJ+26G، عمّان، Jordan','eStNlu3DScC-O-ZD2AMbce:APA91bFJ0KEna8YMi7INjls4XxcItIHbBdnHGkvbEVGlLpa6al_cb6rGOyxWY3Qpy611VPD24wsJKdABK0C80_PB10H6sZS8Z58fgMlAr-bd70gBR_v3OMdG1Qv2INPIc3cluuIwZyqg',0,'محافظة العاصمة',31.970100,35.930536,'enabled','1.0.15','android'),(81,'vendor','$2y$10$ov2CqfBNsuZTECSu/F8ii.izivULhiE6RNF8qGa/TZqjqkWyo8fQe','795855260','fadyalramhy806@gmail.com','fadi','alramhi','2024-01-22 09:00:26',NULL,'inactive',NULL,NULL,'WWQJ+FWH, Abu Dhabi St., Amman, Jordan','dVXJbERAS4uh2_vkOW3uc0:APA91bE6uviIKeqDO3NaHM8WeetIBkxdrvcPcYBDP-IIKH4Ftlndi9P3wxydn0sqZf3_OHXrzaB0bgBGb9a6oRO3plx9xhLgg78K-rmhad0C1uslIDTB9d3pj4Q0YZqSuOfm23W1CsnU',0,'Amman Governorate',31.938893,35.932186,'enabled','1.0.15','android'),(82,'vendor','$2y$10$puyaJl97hSRtMlEJykWHfOiUBNJFpNvELuMT1l2hnL3uZdQ8buDn6','791162126','slymalkatwat@gmail.com','معاذ','الدن','2024-01-22 12:14:12',NULL,'inactive',NULL,NULL,'النهارية،، WXF3+R2G، عمّان،، Amman, Jordan','fIqXwBM5TyybuLBeF7V6nl:APA91bGayUlLCxvAc8yJ03pVzxt4oYlK3Bas8GJBVRh3QAv-9z4VoWvQnxNdgS23d2D-vGwjHZZhOnN1K8MpJyESkkRPZgftI6NGj2JIRoNgT6Wy_LgGzMaeNepqkByG2v-9EWexZgLI',0,'Amman Governorate',31.924379,35.952998,'enabled',NULL,NULL),(83,'vendor','$2y$10$yquvcBZX4mJ5w1vag9Sx0eQj3xKrchs4AnKzlHUt4TB2d0lz9ZFry','797269187','sydaldn05@gmail.com','سعيد','الدن','2024-01-22 12:19:42',NULL,'inactive',NULL,NULL,'القويسمة، عمّان،، WXG2+24X, Amman, Jordan','clBjzX43Sn-dgIsCzqBI5z:APA91bG1QudE_ypmc1Vy7zl3J9sXOu5j9_Obrf7JfTgpwf45zQAIK3hv1DfabpUiavJ-En7rg7ucV-aPLxGJ-4i5hyaYDpDihxbdSKTH5bdueKtcdXB7FTKoY2fG2t9p2vPB5AwTHINp',0,'Amman Governorate',31.925015,35.950565,'enabled',NULL,NULL),(84,'vendor','$2y$10$i1Of8wfnDIB4jp7aUa4Hf.hDH3U6QEUpMXYg36kbs48dDi4Tjvp8i','781162124','mamwnaldn5@gmail com','مأمون','الدن','2024-01-22 13:10:29',NULL,'inactive',NULL,NULL,'WWMM+VGJ، شارع ذي المجاز، Amman, Jordan','d7haFDm3RyGXd9dI5MndnS:APA91bHBGRTQ5oqcFhcBV22eAuUxIfIyTzuFW4nHU0T9S5P3L7ipYRtpr9Z7X-AQ8jEonrsQ8VNRGmT4tvVaX7enhIf_SvDLR3EsNM9BP1IN434dIBImwc-KcjBChcfrr7DibXAgv-Sc',0,'Amman Governorate',31.934402,35.933723,'enabled',NULL,NULL),(85,'vendor','$2y$10$vi3AyTGXHmwGCZM0/plOBup4CoqUeQPrL/.HfSxivaMSEL4X8x66W','793002737','zubaidaaldouri@gmail.com','zubaida','aldour','2024-01-22 13:44:57',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 138, Amman, Jordan','eE-CkLGNTZKuz3gAkhT1jU:APA91bFfpPVkqFvJgMZLOe783VAJFTVKBEhfGyDQFBvUPniFkj_3dXLmJxF09rHMN93WTCCkG6lU9SaJlifBI65coxl0-H9Ea5Gi7x8qK8WVhkKKKkN4P-kd7mdQgzLTqzFyXVczYfjy',0,'Amman Governorate',31.989872,35.871463,'enabled',NULL,NULL),(86,'vendor','$2y$10$rVuxilVYgWcBop9Uf2SN0e.qymQMBlIPtF8YACVBB.mA7QtnTRQ5u','791305865','msbabwalyh1@gmail.com','روابي','المملكة','2024-01-22 20:44:45',NULL,'inactive',NULL,NULL,'VWQ6+MW8, Habar Ben Al-Aswad St., Amman, Jordan','fYJYf0w1TLaqpcG4gP4rg0:APA91bELeXvhgkMS04Sdft39xPAsHSFBbqM_6cxckkjrBqvNk5EQD7Mu3NgcfX7xS_zMyfoXeI9PkfUFyulcBmfEHK9V7WjXMQxEXv7VHwYcNWc-gIQRd2M-_WHUILm8RBI1xp6MgeEt',0,'Amman Governorate',31.889148,35.912334,'enabled',NULL,NULL),(87,'vendor','$2y$10$Xvjs8bpBxSqL8TLCXUgg6efSTYIbzdTlZISJbHMFOBYc8beeae672','797773294','ramiadwan03@gmail.com','رامي','العدوان','2024-01-29 10:39:46',NULL,'active',NULL,NULL,'ش. عماد أبو جاموس، عمّان،، Amman, Jordan','cZ1-8tSQQK6-7lsXnWJxsu:APA91bGtp78g7ziDVWv1eBX6NIq9aWYn0shBs6cz0S9HVxlKnDRBU-wrnicpMc91OihI-dgbMRzqX1JxUNVtR0s7Q9pzmktdzn_zyHXLRsGnPM2KJ_-wAFKahOACnP_Pd1bS77mdE2E2',0,'Amman Governorate',32.013019,35.938488,'enabled',NULL,NULL),(88,'vendor','$2y$10$f34HADHwRAHZpZrmmcUWkO7btMRG4DWhEEaYqx1gm1bMOAyYZxsvS','782303073','ali_f_jarrar@yahoo.com','علي جرار','جرار','2024-02-01 06:51:34',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 139،, Amman, Jordan','eiK6W782Tg2YHhK7HUI6f3:APA91bEINZnfNzr0Rc76MRTHXWssIQHlJ4AKSvreScL2-LkBBc0nCzZPuj9k-IEg-wkADDGjEAFJ8MltJoGEYjaK-VjOle704a7pdjUG91bESUBPPJ2-Unu0h_nCAywltWBRDDOLzm1x',-1.1,'Amman Governorate',31.989881,35.871408,'enabled',NULL,NULL),(89,'vendor','$2y$10$xTDVfa5xij.uuNsXDZIUtuR2I7ZbUUgayXjmTWuQjWMI0R49O1bte','786454708','ahmadsaed92@hotmail.com ','احمد','النشار','2024-02-03 07:18:29',NULL,'active',89003,'2024-03-27 11:51:52','VW9G+VG8 حديقةعون الشاعر، Amman, Jordan','fgbCejdJQLy2HJ3U8c1in1:APA91bFTMxepMTC0U5r4ZePUCFVh5n7t1WBCY7uBedzcMlfJLHNv38d8J_AbXYASlu8xjdsUhleJd2ceCfksrVVztfGPJszo-UwEgLfPrF0Iwq4WL3cTlf7wZECZiK6wF6n-Ty_ekk5L',0,'Amman Governorate',31.868339,35.926852,'enabled','1.0.15','android'),(90,'vendor','$2y$10$nv4g5YB/wy1uohE3s4DwYOXZAV0ZH9WyzxOW.ItS4LC7mFDuuolpC','795051561','hashemhashem2752001@gmail.com','هاشم','العيسى','2024-02-03 07:22:58',NULL,'active',93629,'2024-06-29 08:20:18','33GM+4H, Zarqa, Jordan','eblwE4InQrqXQ-xlHTsHnw:APA91bEPUBDsegSk6Tg9GieWVkDiUYxJnOeP4o9_Q74baW8ZM-0v4gj6-pVsN8I_Ry58Wa3K9SlIR7YLJuhOQnsWiRO2fcSO8Hi6QdotV4SM00osnc-FGMdKjLfywpD_jI4c-SQD_xxw',0,'Zarqa Governorate',32.075491,36.084304,'enabled','1.0.15','android'),(91,'subAdmin','$2y$10$VFtHb5p811cH4urnMhqsNOoanZLFJIFycQfn9cN0VoKHt8Xo00BMa','781799992','mostafaspotify29@gmail.com	','mostafa','lgzawi','2024-02-10 17:55:23',NULL,'active',54152,'2024-03-26 10:46:17',NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(94,'customer','$2a$12$8anHsIbAKwh4hdAD2n7kGe2EKGAPFXcCkCGnXN4HyLKkIkkWmiMPG','777303012','nour.ardomly@gmail.com','nour','ardomly','2024-02-17 20:46:37',NULL,'inactive',NULL,NULL,'XV65+8R9, At-Tabashir St., Amman, Jordan','f8uZeBb_QxuVLRufIy1tza:APA91bGV2edKzVHTOJO75IkuXtEQqgA_QdcsH2jW-CdK24SrnGZOrFls808CzK-cn5UIn7u5tVloqDwXa4t55nc4D_HtzEDWFlUMOj3eKzYnPKHh8y_cJJI',NULL,'Amman Governorate',31.960689,35.859613,'enabled',NULL,NULL),(95,'customer','$2y$10$4SIkMFVc7UgwnGhYGTWixeiizAFf25VLlMcqgR2ucv5sL2/Yp2/3S','787209154',' hamodaalsahore136@gmail.com',' محمد','الساحوري','2024-02-19 11:06:23',NULL,'inactive',NULL,NULL,'At-Taj St. 294, Amman, Jordan','f8FSsCPQRBuh9ioe2ucwB6:APA91bHA_hwbculWB9hCJSApyNH2y-sNK7XpdZ3S9dPxmDanwfsIoTG4A-J3jHmvcnYJZLAieNfERcP8SHMwebxlST5ETeagY_FGUWddZJnhzUDobWMrjZt8SdMxVDkB3i8ThyVLh6-h',NULL,'Amman Governorate',31.938806,35.938186,'enabled',NULL,NULL),(96,'customer','$2y$10$v.HRLhHpTRpVZpDkQyrpweer8y3.D.Rd2IHIXT2vU.bdA/fF1F6oG','797772576','Refatawad81@gaiml.com','رفعت','عوض','2024-02-19 14:35:29',NULL,'inactive',69533,'2024-10-15 13:57:20','Wasfi At-Tall St. 136, Amman, Jordan','fLsWtd-obELjqOb_EDHy_K:APA91bEo0a_Jsy3A39adld6l6oKQmyAYLYoN0DNyoOXgW8Hz8rqjYBkwcWQoUWqKEa4Rh3l0bwwEYyeuxbsWlu2ZggwdYZ7c7DI7jaZ9XMDkVyioT9T323_TNUofXe38qTSslmgKhSYJ',NULL,'Amman Governorate',31.990333,35.872035,'enabled','1.0.13','ios'),(97,'customer','$2y$10$zqkRSP39lSrf8wRXSOQxxOcjrZUUJ7fk5KAQoM45.LePIt91PWag2','777303016','qusaikhazaleh.qk@gmail.com','qusai','khazaleh','2024-02-19 14:37:30',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 18, Amman, Jordan','d7lPGTjvS4ezOT90Nuy90c:APA91bGD6zWEGFVetYr3y35cnyklZMq8ado-Sz5OOke9e4MqgNr2HdoBeqdwRF_Q8coeyvJCf0LeHWFgYXJ7Wv7NRbXJGBwGUHivkpCKloS3PcQsE0qXjgkqy1azt_u_FRtc7VfyRUFW',NULL,'Amman Governorate',31.989800,35.871347,'enabled',NULL,NULL),(98,'customer','$2y$10$QTEtpx5Gn/jIgAQnpbjGnOUGCUeAcnbfzhkETJ.WUMasmWnxhxO9.','795900299','bara9009@gmail.com','bara','atalah','2024-02-19 14:46:30',NULL,'inactive',NULL,NULL,'Al-Quds St. 124, Amman, Jordan','eL_hqVDhRpGf8uSh1uz4bP:APA91bENFb0K0epTG_yZqK44xmmOjVf8fpcg8mb3b4pssyx_KbUQ0OauWYRhmorjBj7HM5zl86IoN1fHPvA8joqnMkA82Ei506RLXcCk4CLuagJoJQFrm-d1g1bsI58EPZpjYA_kxzGv',NULL,'Amman Governorate',31.934558,35.922524,'enabled',NULL,NULL),(99,'customer','$2y$10$cqIH4h5204kwECMnt13r/u47i.PJ/ccxEFsVThy16vREo9HvKszwy','790450207','nagah.alyan@icloud.com','نجاح','عليان','2024-02-19 14:56:33',NULL,'inactive',NULL,NULL,'3R4P+V72, Ein Al-Basha, Jordan','fF88rrXAg0VTlaOTB-KMTQ:APA91bGphm7EzK4oXm_QItw7TLiKGHeeY3ze4pXAI3eqwgcNnXRDxuRcwEFLx3Jp4fSqmnKMHNlH2vz7GACKw-TXdLfFBiA6tR53WKqaeeAMJwloF6F6SPPE-R3tf9VikPmIiGm7RQbE',NULL,'Balqa Governorate',32.057122,35.835938,'enabled','1.0.10',NULL),(100,'customer','$2y$10$GKW18q7DKSLhir4zwG6r0.JdW/U4w5x1trOG2dkX9q8C4X0wRoYiS','791241724','rolasharar90@gmail.com','روان ','أبو شرار','2024-02-19 15:09:11',NULL,'inactive',NULL,NULL,'Al-Quds St. 124, Amman, Jordan','dcNG8l5vQg2V4tQjC8RVk1:APA91bH2zT5PttCI-vWR9xy2JhbXfpZMaXm7HGDxoNwaqzilTFmc0l_yC3yd5joWtJzjh7rbFjOEACBS7kphNDbolKCTJBo_uo3gou0kcDgJ4hRlwJVz2puy4usejErDkZ2SqmtaVu8i',NULL,'Amman Governorate',31.934560,35.922520,'enabled',NULL,NULL),(101,'customer','$2y$10$Ovx1NKu523oPUMfvsE2Nk.iXTfdca778TRwKS4joWg4bw.mey4ZWi','777303016','qusaikhazaleh@yahoo.com','qusai','khazaleh','2024-02-19 15:38:47',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 18, Amman, Jordan','fydX6GGPTNScvHF-XYWIPX:APA91bFTn_e-Pzg_BJE9Id0OhLkdU3xdUEYginOqeBAhwLnMd9y4b8mSCSyU--6jBQ78Rt_6F1D8yh3Mr_vVuHT5TGbDWfEq8oIKICFYp0ifQBzUabWOC1Muk2-P1gVexLyVgr0aDQIs',NULL,'Amman Governorate',31.989794,35.871357,'enabled',NULL,NULL),(102,'customer','$2y$10$dlZmrG2TSBjY2lRu.NkRUucR0lpPiz8ceeSU4vIs2quV3AA05./NS','792500023','rameznaffa@icloud.com','رامز ','نفاع','2024-02-19 17:50:45',NULL,'inactive',90478,'2024-03-21 09:49:57','2Q8W+P2, Fuheis, Jordan','e7Mr4YKiTRiW3ey09GBsaI:APA91bEM4EmT_TE771CQncFD69yEUNouzWmT2yA2WffDGPOK1tXkoJciQr7_M6q-TOPh218KFXL4iUfWzSWGbgjP6GYyPqVjY5ovPYk3iW4la8jV4XuLGy_jWFnlMjFGmW6cnsS5hDqr',NULL,'Balqa Governorate',32.016797,35.794339,'enabled','1.0.13',NULL),(103,'vendor','$2y$10$v78UGCW.D0zcl7Jccj6x9eEe1qVviHaLmNHeS.thsjWpql.nW45am','787470111','mohannadraetal@gmail.com','مهند','عليان','2024-02-21 07:54:39',NULL,'inactive',NULL,NULL,'XWMH+38F, Amman, Jordan','f_YhWBuyT1mVMnpc2IF6bU:APA91bFpDyel8tkmCT8YIzjPPKTbAYu0qn9jTLBzdVdP-iQcjbCTZvlMLJYXv1qp6Up8hUX0LZXhk6ZcQZaJAOD5MdW5enmnhTwE-baiJ1hsI59sHjI1pLIjNGyXyg3OFk-j3U2Khsa9',0,'Amman Governorate',31.983044,35.928279,'enabled',NULL,NULL),(104,'customer','$2y$10$fxSoqdEaWbqu34x/hCTQuelvQHmXf01mmci2eLJWcLFu/TbE8rO6i','797030464','mhmabuhamda','محمد','ابوحمدة','2024-02-21 13:39:11',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 18, Amman, Jordan','caLQImCTSMG3s85astDx3h:APA91bE5xGK7oWgqxMgvvFWXnkLlNx6j1jSXn6S3CpAaGQEV7CXCau8mLC-VU5Bj2yOTjQe8HPoCZUhzrrGHtEkgntHfxLdO0i0Gh5Pv6L7c_iarfVDovxcGh-rOQb9g7ouwMnBbVxlI',NULL,'Amman Governorate',31.989852,35.871351,'enabled',NULL,NULL),(105,'vendor','$2y$10$QsU3q37oJz52tHrMYQaAr.bZTIN07NdY9/4nWWAyHb6VnVoG1K6ZK','795169051','moshtakhadi@gmail.com','مشتاق','هادي','2024-02-26 07:51:08',NULL,'inactive',96345,'2024-03-30 11:25:50','2QCF+R9 As-Salt, Jordan','c34bwm9LS22AF6wdzlpMuv:APA91bEzovyMEtf72RefALoUnE6JyzZ43kZkFM4BRu3QXARk4YEAHdcTLakm01rEr7Uo7kKeQnYXB7-sbhvzh84EkowjPZ9Da7Jm7qT_4lvyA93whdeMCn_2f-ppfh8PJCCeI9SRZHG4',0,'Balqa Governorate',32.022100,35.773379,'enabled',NULL,NULL),(106,'vendor','$2y$10$orxjMx8QKe1sUkJzjhv3PegcEjtTSFZ31/LXHL9b6quxQeu722S/O','780712573','thaermoh954@gmail.com','ثائر محمد','فريد حسن','2024-02-26 07:58:26',NULL,'inactive',56588,'2024-03-30 11:15:55','2PWQ+QX5, As-Salt, Jordan','fJkiXnamQzCwrQUanXt0E9:APA91bFZYX7QZ2loBOidVwU11RnejY2ye32ub-ttdBqRkgGS-GqCN3yJ1UI77Vp8_hJpWm3bKopl0QXtr-X56H38ztnNMFV3Qvs87I5zkkFp-Lqp4UtMHQXzD_0TlLxsngHIgGUdDpoZ',0,'Balqa Governorate',32.047588,35.739925,'enabled',NULL,NULL),(107,'vendor','$2y$10$quRI.ICaRPWedGZBiv/CPus0XIJqfv/M/ctKpeJvb2mm.dMLXxRmu','776554841','alkhrabshhmhmd496@gmail.com','Mohammad ','Al Kharabsheh ','2024-02-26 08:13:08',NULL,'inactive',NULL,NULL,'2PVR+WHW, Q. Rania St., As-Salt, Jordan','epN-WO2UR9m0BNrydKZGH2:APA91bF2J3IkCJAMJUlvpGL4KwiWNWm0xG50bgjEHxqHFBZfs54zY4eyYL02RVqZMDKn1NuYEV8CVM5Zw8ZT-kWkjnnaqMhRgdHvTwEaURsm-_cIaroTeYcRQAnSUnMN0f2_HbNioWe5',0,'Balqa Governorate',32.044637,35.741230,'enabled',NULL,NULL),(108,'vendor','$2y$10$DknWxoFUsLvUmLkOIUqDAeWNZiEcaR/4azWnEPbaHynVDFeOpvTKK','790039376','thetower571@gmail.com','ابراهيم','خرابشه','2024-02-26 09:01:44',NULL,'inactive',NULL,NULL,'3Q3G+87F, As-Salt, Jordan','e3Dj3YlNQACXRfJCtw_Pj5:APA91bHphXqexeQwhnOcm8t7M2I9qLUNKR2JNSCaeNnuiYNXUAZDApJFkHxUmv6jwu90jSNp4iMA0ckvEhNZ6Dx1lbda0sKrmC3x5Xauoqrydc6GbEatLDJPYmiyOwlDdOGJkS3pV12k',0,'Balqa Governorate',32.053408,35.775892,'enabled',NULL,NULL),(109,'vendor','$2y$10$oa7Eh3A0uYoRGJA.anrrzOPBg580g9EByJ/WGO3urIqnRxsihuFbe','776861296','hasenbsam3@gmail.com','بسام','حسن','2024-02-26 09:02:49',NULL,'active',19166,'2024-07-04 13:22:01','PX8X+RP, Amman, Jordan','fky1qEllTeqQCOEfZ7kyhk:APA91bHxwNWDUfEQ1FkfeGluipHhHUdFYHlwohm_JPGuaVUxaqt17Zwd-yZkDAIQGtFIjbtvhLtHRAW-ZxqpV8oR4GagH2UqbkHht4D1F0-7LBC1z62NrjuDZ_39NwRfIM4gmDAPZXWX',0,'Amman Governorate',31.996656,35.668812,'enabled','1.0.15','android'),(110,'vendor','$2y$10$2cdc9zRq.6.PDT5JtiK.E.BdpVAC5dqQ8KKb7z7rACpbHuMmYFpsi','790412711','moh.mohammad212322@yahoo.com','محمد','فريد','2024-02-26 09:33:09',NULL,'inactive',NULL,NULL,'2QCF+VF As-Salt, Jordan','ckTIFMSRRaWnCNuEZlMftJ:APA91bGV5GNME3ZZWX4jxD9tS1NYkvUr2NqaAnr2VZvT6ZpVsRAkcJnBI6Rfb5KMqg-q_qVjjHchOhy-k-BtAn6ThbYqlppfFE_EXfqH1fqXTZuNqvVajgyfZq5XuxKg9f2kvNOd9kG2',0,'Balqa Governorate',32.022227,35.773689,'enabled',NULL,NULL),(111,'vendor','$2y$10$8n3LNA9etBiFqsc0EZP08uhMD8B3BaP0HpYGHlH/57Z.M6t3DtJ5u','790950724','mosayosef456@gmail.com','معتز','موسى','2024-02-26 10:37:57',NULL,'inactive',11589,'2024-08-20 06:10:38','3Q34+JX3, As-Salt, Jordan','dHLCOp9SSgusJ7jirdcPWV:APA91bGZhdihOhn_1tZCXiE9G35kBtBsWh-Kq7BoK2VpfeNOGp6eH1FfVi_onWcVIjDX3NgJReVrmY362ULklmFq3VyMt0LMhTyw4pNV08Mmcfqo1OnwM_C4MpYF1o-t3dj4hUvpPGMP',0,'Balqa Governorate',32.054054,35.757637,'enabled',NULL,NULL),(112,'vendor','$2y$10$JKBwmSuMaakSfLIuiVo7Be23BIjx8mtM.AjrLbkteATXQ646NiA7y','778677954','adammakamra63@gnail.com','ali','esmail','2024-02-26 11:03:58',NULL,'inactive',NULL,NULL,'2Q4W+9J2, Fuheis, Jordan','dqbDgGwATq-wjqXQoj9GUL:APA91bHouhxcCUpH4IOxJPi0pNn7z4BaQO7gngVDl4ddp1yC2-waXy8YMdJgCVoFlXdxR7EOfjEjIPSRHdjU0ymLdSR5OkkSNRVqc-fZhHMinjraMYfnbu_qg-meBv31Em3kdatoXAhs',0,'Balqa Governorate',32.006371,35.796115,'enabled',NULL,NULL),(114,'vendor','$2y$10$qaTRtqDh5X604uQlYK10z.hoK9VBvghdEwlMv7XPgzzFuevIq.3QK','779680805','rr9878542@gmail.com','رسلان','فريد','2024-02-26 11:09:07',NULL,'active',66391,'2024-03-30 10:50:59','3P6V+6JW, As-Salt, Jordan','cSw9-UTQQ_Ocol7tdRnlnj:APA91bHGtELubI1sj2KgsNR8ga3hPxY8fzufiE7_OK4eCD_UtQmT6aemQf8aiJT8yH4mpDBNv6aW9aE9MKGBQMDf10YSRfuYikPAWEU0aicB0YAJ1MExGaIJNyFmOtLkPZrmJn6T2LiG',0,'Balqa Governorate',32.060838,35.743204,'enabled','1.0.15','android'),(115,'vendor','$2y$10$xoKTrnhLcw9y/rElv8Nfj.80mcs9mhnIXzvz/FlcUMTgLFtpluGyi','775158195','mowhmadaboali@gmail.com','محمد','علي','2024-02-26 11:57:56',NULL,'inactive',NULL,NULL,'2PWR+W8R, As-Salt, Jordan','dsQa9_33TIOP5bZusZUKEp:APA91bHDYvopKO4zv0DOPEf0hbUA2_pOUl4sBgesSXhJ3k5mFm1A55mZaetvib0h3r2EooYHcpp-wuWmbLZhoC3Exp-iRmIoEAdtp_C5EPd3B8ZSzgOV7Kz8NnWekKfW6zlwIAJsweZ1',0,'Balqa Governorate',32.047336,35.740761,'enabled',NULL,NULL),(116,'vendor','$2y$10$57fso.k7v/nmZ.BDCXaoQ.DQhZmLkMc26fVGwNspAWQqFz5UKYy4K','790179498','moosamalek32@gmail.com','موسى','مالك','2024-02-26 12:37:43',NULL,'inactive',NULL,NULL,'3P64+RQ, As-Salt, Jordan','foSupQ3xQt-xEYHdlgGpnK:APA91bFWD7I_aTcHYw9j5jVI5g-zxMnTqVZlx42Vh5B5aGwpoTKygpa7Ft2-QnQbEiVysCl4G7WW3eYu_MGVGjWkumd_Zf7G4SGeNHzzQE2KtNZaP6bbiEmlGU9C7ivS2hXu_0-KHeAI',0,'Balqa Governorate',32.062467,35.707623,'enabled',NULL,NULL),(117,'vendor','$2y$10$fdBtwqp/DTUoBqP4/CkJR.SdW/CB/6chamfJb37V3Oi32ClQoiyae','796862701','vhffg649@gmail.com','ابراهيم','الشرايعة','2024-02-27 08:51:37',NULL,'inactive',NULL,NULL,'Abd Ar-Rahman Khalifah St. 12, Amman, Jordan','dSStJ1nOSraqkhkKbFOyGR:APA91bGt7KAhGdGOw6b-VJ5WAqpiJOoFHD4iML0t99qDOD_4BgAqze2A51FDgdbAItsF3TJgSMZeH3xO0uA4apr4W5ruxHt-j3t2zxBEJ9pWIRF6P3uZITLk-HpUHmNW8HNpPnQSGKMX',48,'Amman Governorate',31.960070,35.856903,'enabled',NULL,NULL),(118,'vendor','$2y$10$2KLDVYubXMG5/BYrzkjPKuYLTBMpHqCUzWeWkedEceQmeCVsAbVLK','795457251','moot709@gmail.com','محمود','اسماعيل','2024-02-27 09:00:13',NULL,'inactive',NULL,NULL,'XWHC+G32, Abdul Rahman Al-Ansari St., Amman, Jordan','d6lt0OQSQe-tnu9qqQ5rAj:APA91bH_mtYkLaO2VNOs-IIdMTAtvk12kTzYw7Calw47qGIjgowpmGH_0s2pOWY7cmu6ys4KzDYdYDAO4hOV5ITb7Zx3vRsHgIo8w8lTlhB_G_51V8LSAfILGNlstsAHtQQoBnXqHBw8',0,'Amman Governorate',31.978643,35.920375,'enabled',NULL,NULL),(119,'vendor','$2y$10$qAPlP1KSKt6S.0gKesfDjeMBut3ReVqA/mIHPMlgLZKF0zasN3Hiq','795824792','khderabuaresh@gmail.com','خضر','ابو عريش','2024-02-27 09:08:50',NULL,'inactive',38808,'2024-03-27 11:02:23','As-Sakhrah Al-Musharrafah St. 147،, Amman, Jordan','ezpW-3jMR6CwQRzZI__B-G:APA91bGk7a6pHGyvQce5Qpe-eFdzNNhqnaFkL96-YkjCLQXm-NDjqmqmpK8KhDbFUEaqwDY8Kw9DnMw9raw9Xqhl6GdZiEubVJNBUSRq3OjSKh6MA0PobKZ8xwif40nZ8xApT9u0n8xu',0,'Amman Governorate',31.914365,35.914946,'enabled',NULL,NULL),(120,'vendor','$2y$10$vcuUzy95.Slzp5izniseRefz2gPu3aa0BB7mvcQGp4zbwBa.A.4je','780496277','zezozezo909@gmail.com','عبدالله','يوسف','2024-02-27 09:24:43',NULL,'inactive',NULL,NULL,'2QCF+VF As-Salt, Jordan','dnYzzoY0Qt2Sj5kBrG9ISZ:APA91bF4bsFa-z-O1rvQbvY9ezPhNA9UhkJb7ZwZpRz-_ezxAW8V0_XS48SJp25qVo4E-S2BNcECnrUghrnhzNkzFbSBNfPCOHcZ64akm1Y5CLwObzesbiAPaCJYD4NnRg-84L_OdlZd',0,'Balqa Governorate',32.022232,35.773713,'enabled',NULL,NULL),(121,'vendor','$2y$10$R0x16BnO3sE87hlvZtkq3ORs22ejMUgtylkqraGBG3D7JyGSvrUTe','797110401','smy67731','طايل','المناصير','2024-02-27 09:31:34',NULL,'inactive',NULL,NULL,'XV59+3WG, Amman, Jordan','cOReEsqFQVOQi09lrMg7pc:APA91bEkW4RHPcF8oKPQNGWW8cJ7T74zuIWYBtWmVMcI5RW3JeSn5YZfd3s4tYmVafy2VHXQJb6Uhp9aQ4vBZuJgyMynZT0rDvGaLXNN0qHnEvsr7cEieUUYwWYrAIHrzpY2t6lDKFP4',50,'Amman Governorate',31.957736,35.869897,'enabled',NULL,NULL),(122,'vendor','$2y$10$w6pSMTit7miMjjnrviRyxu/Luo0mahZ9joTf1O1nobGnpKSvLZT5C','795543737','baderkhaled850@gmail.com','خالد','بدر','2024-02-27 09:40:26',NULL,'inactive',NULL,NULL,'VVM2+56Q, Amman, Jordan','chUFiTgPRQGYbmYDJgh5hq:APA91bEA0CvQszFSC95KRpapvWuWAXAWKfSzwuQAlo_MNsIJjfeXqFxY-LDxTyk5fAcWjT_oBtpHsKE-lg-YYgVQWI4CVANVVKLCHr6BhX0mDUFimBlZ7zqkKccVl7r1EO9eKK-06juI',50,'Amman Governorate',31.883377,35.850052,'enabled',NULL,NULL),(123,'vendor','$2y$10$r.TOfkCKLB/Yr3BO.6KRIeeBTytfbe1mQmc9lateejz5jlHhmFZR.','795640577','alhwramyn@gmail.com ','امين','محمد','2024-02-27 09:45:19',NULL,'inactive',NULL,NULL,'حمزة، عمّان،، XXRR+GQV, Amman, Jordan','egF7D-8nQ4iGGbQ9J7p4a8:APA91bGD3FAgB8iMJ_WSFzqS5t8iWM4jBHW8sSQMuNG9jhqPdOe7tyf7kFb_iCBTf4HNOT_liQdpi_wJL1b-MZVaEV1jIeIt280JH8iSYLoDfqgyUp-CRjpTBMEnF0RPaNcB31wJEYob',50,'Amman Governorate',31.991302,35.992062,'enabled','0.0.1','android'),(124,'vendor','$2y$10$EP.MRuMk/cdp6cvrBfOJUu7Qc6VWm8t/BrEa3BhsEJO.XNbjBGYLe','790331727','moshtakhadi2@gmail.com','معن','الخرابشة','2024-02-27 10:14:35',NULL,'inactive',NULL,NULL,'3Q2W+3MF, As-Salt, Jordan','eq1--HamSE-xEG1R_ipPW0:APA91bEAUG1Azzlq4CaPLzobNp2sBm9kMSHl-5qvwwcw-YVKTCeYaj1WhNZdX0PfYU1oZoW2UhqIyojNmIAsUN8Cfi8vTMEFxpVmAkH5b1p-cKaJlFLk3OaL84SbBeseNiW0nmFmgTwP',0,'Balqa Governorate',32.050216,35.796169,'disabled',NULL,NULL),(125,'vendor','$2y$10$gBuEoRZYK5KuQsuvvtvIoOuWuOIQhgaq4UnWf4zDk2cWaSVwukvyu','788834557','foazalmanaser@gmail.com','فواز','المناصير ','2024-02-27 10:31:35',NULL,'inactive',40117,'2024-03-05 14:16:18','Mawloud Mukhalles St. 35, Amman 11194, Jordan','fdTGKSGkT8ak-7Ws8MRCKz:APA91bF2Y5VJFDuP8o09dO874Oq8zWkB4ENAKOdx_Sd95uNUPfbDmMiK-L4MgKmeZ30s2ZkzPzZoJXtapzQV2jjfJFpKIDJ40RE2GR4nn9OcbJEZpaESZr4_CvewpDcN61Elyj_slczA',46,'Amman Governorate',31.957799,35.871200,'enabled',NULL,NULL),(126,'vendor','$2y$10$fuBgLvoMxF43UoZjrjr8ZOtOWRY6IQYqGJdOvmIsgkD.X7tbegN/y','776378990','elian23.jbor@gmail.com','عليان','الجبور','2024-02-27 10:52:24',NULL,'inactive',NULL,NULL,'XV4C+X6C, Prs. Alia St., Amman, Jordan','cidkbzwdTECuO71P8fNdT8:APA91bEA5FAXmAXLjRbphwnYGvgKfVyXLOXRMRDx89al1yAv5rXf--Or1qTcV9FoRvAZN4Cg_TKysKLgW2_L_HH4SXcVScS0NTB8w3ZrII6z58trt6l8kz_ej4_KFxVCISBADhomYn9n',50,'Amman Governorate',31.957367,35.870637,'enabled',NULL,NULL),(127,'vendor','$2y$10$pVKxYzV6dSxrOCuZkzT2ZOJ0uS7.JaBtv53C1Enoi5Tj03tzs1MNm','790832648','aseeem089@gmail.com','اسامة','عطية','2024-02-27 10:53:18',NULL,'inactive',NULL,NULL,'2WQJ+5VH, Amman, Jordan','fRlp_2SvQHWwP5UhhiQYAN:APA91bGxpowD1TL4RgG9FfteZJQSs2LaCi0uQ3lP8QHU41z46JjuqreL8e8HhwYuPPaA-H5Jv-uWLKoLHbyYZ5tRmx85GYuWhPY5RjIUeaeAZ3CnPnHtTbvjY9TXuUmSf4UdM5LVLsu6',50,'Amman Governorate',32.037166,35.931057,'enabled',NULL,NULL),(128,'vendor','$2y$10$daRpUi.LGVxzouieH4q1/.YAjNT5EDs9EWw347sSRDp8Z37SC.nRe','796608867','mwsyalshrayt@gmail.com','موسى','الشرايعة','2024-02-27 11:29:12',NULL,'inactive',NULL,NULL,'Rushdi As-Safadi St. 4, Amman, Jordan','caBtgY5FRP-5jsMpuHi8OL:APA91bEEaWLwNhClV2M5u0wfz8s06NG22XX1_s1twXbjqTP7NPhwUqaIhjf-hp83Hsa71R1zVEAH019tUsYs25ESR4E7xWsh-fvD_hjmXvZ5PePr44aHHGQ_HOEpRwbcGpqECGddgbRR',50,'Amman Governorate',31.958153,35.870175,'enabled',NULL,NULL),(129,'vendor','$2y$10$B7whD7RdHT4yhIYDHjtzO.0X0e8lK.89b.lNcZbmymdzmzyMQGtEi','797552430','dyalnyzat4@gmail.com','عدي','بركات','2024-02-27 11:54:31',NULL,'inactive',NULL,NULL,'Amman, Swefieh, Ofiice 718, 7th floor, Park Plaza, Salah Smihat ST Swefieh,الصوفية، Salah Al-Shemat St., Amman, Jordan','f3zC4PfkRVCC0I4Q7lS_gL:APA91bGzu0jGpdE3fTCcMeaooeXBdMAtySsLpS6Xi903jO1aX1yyPG3jKSOPj641j96KjktKpyJXWlWLPH6EqF12GOJDWRtFrywjVnwK4EoadAOjSW6M_FlLbcyjNi78qLnK_PAHxr1u',50,'Amman Governorate',31.958423,35.869192,'enabled',NULL,NULL),(130,'vendor','$2y$10$rAlKTPwU5vkybzWFy5qJyeGi3reuGOMMCcDRRwZQg2fmebhjFw7s2','785703901','khaldonk445@gmail.com','خلدون','المناصير','2024-02-27 12:55:45',NULL,'inactive',12133,'2024-03-31 20:28:47','WRWJ+JVM, Amman, Jordan','cpaW6pftQSKsL__xhqPKEl:APA91bE2mXjm_aCAVOkb8r06eMvb1qTjUCpZPO5uGP38Cgund9KDhJhgmJGx9-5RAoKxNEKxdDCygb2BkUQZ1jNjFX8RoxNy0dwVCxSdfvC-T8gQ-Duw5pMZ87YfYBVg8pWkDN8dCnrx',50,'Amman Governorate',31.946817,35.832022,'enabled','1.0.15','android'),(131,'vendor','$2y$10$zquVW33arHDNzRr3CRv47.kpT1yiIcB.ilg.1YXHvzzpqLrbumNa2','795002465','bkralhwr@gmail.com','بكر','محمد','2024-02-28 07:08:55',NULL,'inactive',NULL,NULL,'XXRV+G59, Amman, Jordan','enXqAw4GRf2KxyCsHGmJWl:APA91bEa6pZp_GWNGTX7JJHIVVaD80bSYqwlXSEZrJYUAXdlASPA1vEsso4ZpfDekZsa-W0D2VsUgGQiC52wOdG1KbcKeIOzAHzx5xkWOHi0iYSna0jl7O37MCFPjJsKvF12AH44hgvF',50,'Amman Governorate',31.991074,35.992938,'enabled',NULL,NULL),(132,'vendor','$2y$10$TEdQsmsN9ZxUyP9HoDbduOrwZVHMlLnW7nLFcuMctX48ZPtBe21xe','796243507','mhmdalfywmy552@gmail.com','محمد','ابراهيم','2024-02-28 07:49:09',NULL,'inactive',NULL,NULL,'Ammar St 21, Amman, Jordan','eZfwoHofRNWwt2_Jg2hlBB:APA91bEQBPsUQtn6T1qXdce7zf1eAAnDQWc5XuHMlrVw_Z03YOU078TocFOXgqTnGKr8_Cc3wpLgSycyaHek7zzYMEqEcdfplU-siubCT-ql2MXorkQvVm6xovjdH_5fF-09gW1hhLOA',50,'Amman Governorate',31.895841,35.834741,'enabled',NULL,NULL),(133,'vendor','$2y$10$2k0hGqRnWCYI50/bkqroIu7mgA7v3T0P0VxcUpZGkA0F3itkoYTnu','795926895','Salhaktot@gmail.com ','صالح','كتكوت','2024-02-28 07:57:53',NULL,'inactive',NULL,NULL,'22GG+JP3, Russeifa, Jordan','e9Lejzb2RGezgCU8C8RA9M:APA91bG2OfZW-5zyEKc1ySBMFZNiVXymQzhw9gWfXbRwHq2Pd19_C1obj4-bKiQlPQ8YhEH59QqaedIHpAUAmNPzVkCDsGbCkw-SlPJvsu6X_Y4k4dUiXkaKePxD4qrvAbXRgI5HHkTj',50,'Zarqa Governorate',32.026608,36.026771,'enabled',NULL,NULL),(134,'vendor','$2y$10$xCfypueZ80mRM9qTSizDE.EaymdmRq6Zbys4BzLuNI/KZXFstvRZ.','788543381','zakekalaede@gmail.com','زكي','العايدي','2024-02-28 08:20:51',NULL,'inactive',NULL,NULL,'34Q5+GCP, Zarqa, Jordan','f7pW1Z6sQX2DzxUw4HlX-X:APA91bEuLZjukniSNjzskKj9px0SmM1DwdhhsBlhw2DSRTD_NDT8O_ur2ZztdY3f0Mo2Dek70U8HaE4DI32BjJqkCuzPjjyf_wzhDfkrF3YkCYj5NKRbOdX0PpwMdjcSL5y_2HUKFGfH',50,'Zarqa Governorate',32.088580,36.108446,'enabled',NULL,NULL),(135,'vendor','$2y$10$WDo7oQL5nHyDjGYav33HmeC6Ip406quOrseORUq/y9VEP.ATXmWq6','790585067','abedalsalam2021@gmail.com','عبدالسلام','الكتكوت','2024-02-28 08:29:00',NULL,'inactive',NULL,NULL,'عين غزال، عمّان،، Amman, Jordan','d8ayc81wTS6aYt4ynXeojl:APA91bHWNQpOexv4ArqGeY5mT2bZG-27hBv0h5dtY5s7wkvl-cYDEauTXBDFJtFMAfLETUT66QQpMqcvaPugIAJn4vJHlU1pSIh3gMJ-hlsGxfd0h9QtIs5xgS_m3OOGbExbtDaeUi1t',50,'Amman Governorate',31.984035,35.976267,'enabled',NULL,NULL),(136,'vendor','$2y$10$aAtHufLlsh0jNNvy3853fOwhLFXmJs3DrrcTqxmrekjUNNO0Ayeuy','797090874','foadnabdsi@gmail.com','فؤاد','قنازع','2024-02-28 08:37:08',NULL,'inactive',NULL,NULL,'34Q5+C7Q اشارة الجيزاوي، Al-Mesfat St, Az-Zarqa, Jordan','fD7vKTDtRzKx-lnG2QEJzE:APA91bH9Jww3x-UgHWi1xU95Vk4VzfQvVd9w8YSeeeyoag5dfvpdh73wzmo9OXrKjWA457-hvcsrXxrp2v-1FCKc9UfaecM8sMwonj09UjFaFMV4xK7mCBF8DK3ggMT2WvbE_D3vT-2h',50,'Zarqa Governorate',32.088390,36.108179,'enabled',NULL,NULL),(137,'vendor','$2y$10$LJ6FYlDk8sJD4XNc5siZiO.gqLbUCbUz1QtUs5/SHLdRhogaWqhc6','799903522','ms1871610@gmail.com','محمد','جبر','2024-02-28 08:49:25',NULL,'inactive',NULL,NULL,'XXMG+7HW, Amman, Jordan','foEz0ZoUSyKqFbkNPvQyaq:APA91bGyJpVysDJ1iPKb3A5HloMVmAbNeJHTOntZBIBattACh8ymB-aDA6e7n6HRA9hBzPDsTinnHjl-vo7dONp4A2ZRAok76D8_KrDrAjmE25A4dRsuWY7qTCBkLYK40fDJXNCrpg6I',50,'Amman Governorate',31.983827,35.976806,'enabled',NULL,NULL),(138,'vendor','$2y$10$XuG9XkjA0RzjpGs2uNzC8.bp0G9VrxF9DtEXhBnAi2qCN3szmxwmq','788252071','nbbhh6969@gmail.com','نزار','عريقات','2024-02-28 08:51:25',NULL,'inactive',NULL,NULL,'34Q5+C7Q اشارة الجيزاوي، Al-Mesfat St, Az-Zarqa, Jordan','fKStMmxRTKyBT8JvQHZMsJ:APA91bG-Dj_R9KvrtHv_Hx1CquQlsAwuYVsHb3LEAKjT3fucmIkfxrdRIqu08-Dv3kcQOB00bcCKqulAnRIIERDDsyIkl3-yLShjmonf5PyAccVQT8VGmyNQ7to5t5TqUYhtEtNBzUwW',50,'Zarqa Governorate',32.088661,36.108227,'enabled',NULL,NULL),(139,'vendor','$2y$10$BR.R9V0YLyLAEfMURnXYQ.AO/FmmlEnMJGlfvDf7s9wh4Hd7n4Otq','795619774','ahmad.abushikekh@gmail.com','احمد','محمد','2024-02-28 09:52:19',NULL,'inactive',32830,'2024-03-27 16:38:52','VW79+CW, Amman, Jordan','fZAgoYzuQJSpn5Ey3Ebo3P:APA91bEyoAI1TnxXA5yqEupuC1qLns7T4rf48EZihN_MPZPi4vroaoZKytHLV70gm0ZCWH2YThQFrNsC8sSGDq5sOmJDdLJeRCJW2YGLfjQFaN-3mMftgWdHYM8m7uN67spEW24_hNr0',50,'Amman Governorate',31.863945,35.919125,'enabled',NULL,NULL),(140,'vendor','$2y$10$HZCKc4nkhiJg2TqGktlRHOS7kdGuyVf/BWlWC2hHuWTNpQGJ45rFa','792673111','zuainat@gmail.com','عز الدين','زعينات','2024-02-28 10:09:45',NULL,'active',NULL,NULL,'33CV+4P4, Zarqa, Jordan','dq4UiyBrS1uMxtJpVQfjA_:APA91bFLHxBU2qD1gRjNDo2cg80WnsyUBurTMI8NzS6tFkAmwzkSh7AgDVWzD_a_wn94oTrkk5uTplRMbUu4Tb2bmvaqVQW6-a20dzClFRhZVpisDTksQ-2YaKp-BWzuwt4cEhhxmYa6',0,'Zarqa Governorate',32.070015,36.094465,'enabled',NULL,NULL),(141,'vendor','$2y$10$MSyUE8BL0bMvCzyHxXR7geDQCSJ2d1/Mzadjv7QzVSW6d/UpPaxLu','797369676','marofmohamad825@gmail.com','كمال ','اسماعيل','2024-02-29 07:08:57',NULL,'inactive',NULL,NULL,'شارع الجيش، عمّان،، XXMG+5PQ, Amman, Jordan','cDGP1vvNSciYxWoVcy3Zga:APA91bG-gtXp4lTNIBVojOcFIzgQI7SWUi_lYPjjtSZOuZGgei6dAg2FLPuS8uUBcCa1D2DIyzrsl2KzrTOl7lGKbAYJG5QouIuu_jvlkTFRi4ZXAxcdY5fT0glV7s2JI5eXmIwtk7te',50,'Amman Governorate',31.983499,35.977443,'enabled',NULL,NULL),(142,'vendor','$2y$10$80en/iKwcVaI7uGtnZ5pJeTxzIecsMNTaAcPTSLDb3nEilrjfQt26','792881685','ahmadaljazawi@gmail.com','احمد','قاسم','2024-02-29 07:36:14',NULL,'inactive',NULL,NULL,'224Q+7XR, Army St, Amman, Jordan','cQimyMOUR5ifzbQ9nUo32L:APA91bEn7YwBOQMxloDlBi1tMGfVb7TNFl4uV6h1vBXzqSWTnda3OW5vUqiiLpeSKzmARxfNOGm0GhbUx5850hlktCbLb3hYF8asYNo_z23H5Dnh8atd_wcNTOxRdHun3sx9lYW0JwSm',50,'Amman Governorate',32.005382,36.040915,'enabled',NULL,NULL),(143,'vendor','$2y$10$CHY/ibGTOSmf4kEPn7Trc.iAuBqwtBy4GX1.gK15g9XzBRxPd7qTy','799736076','.@gmail.cimmhmwdjwr622','محمود','بدوي','2024-02-29 07:46:49',NULL,'active',NULL,NULL,'Al-Bayader St. 28, Amman, Jordan','co75lkYcTyq8XDaImxd0RL:APA91bHl3n8g_0AcR5uvUMIqwFY9lLD8k-8O2fWhwUZ_RfnFc84DRrzI9GSqdXYTs9dBwOJO2BSISU5PR6tw1vi5KqBxyGtdy1CT9IbLix0FByonQxX0bA06gBPjNBMDJyuWnVOa3_TS',50,'Amman Governorate',31.955028,35.842978,'enabled','1.0.15','android'),(144,'vendor','$2y$10$dpjN3gAeb8OxlPL.iF6q1eUfUfLgCUp8QOOyuhcTiF6nBQ9g6jzue','790342225','cncnjdjd86@gmail.com','محمود','شعبان','2024-02-29 07:46:55',NULL,'inactive',NULL,NULL,'XX2R+GW3, Amman, Jordan','cUaDtfAURtCEBQjxvIW9BO:APA91bGm0MP8sC3_cyowW2tbIYJzTzaeext8rsRYHD2rSsEQY9Pkvt0GGeNKD7H1pcGjo8bADj6gX9mA4fz5O3WHQb2ixAmMO-bs8cRkJ1Cb7InGNk4EG1CSuUqAbwPTyjTXIqML2LlX',50,'Amman Governorate',31.951220,35.991820,'enabled',NULL,NULL),(145,'vendor','$2y$10$JfFz5hI1I1jG3nEqU0NV1./8F53NpMrxauQ7UIlfofNXwx6qqGDYm','797688017','mhmwdr62@gmail.cim','صالح ','بدوي','2024-02-29 07:57:37',NULL,'active',NULL,NULL,'WWV9+7JP, Hashem Al-Atasi St., Amman, Jordan','eKd59nWzQTugI00dlVqqyr:APA91bF38cEoEJvbmAs7GSJBpQOIhlJXTvD-0kjW_Mb1gnV1VQpUIZkhV-Xq4B6JdCE6--hn1KOcEelRWsoGZGmWHTdXyoPXvAUU3WiJtZw_NCPQGSCVPJ6KUTmsXPwy6UACaZOK3Mjb',0,'Amman Governorate',31.943006,35.919623,'enabled','1.0.15','android'),(146,'vendor','$2y$10$23or9JxhDUAq8wFxtaDoIuKSVqK/6ZqWwwatnSNKV1L5gqe4siZVu','795155341','mohamadalzaqzouq3@gmail.com','محمد','الزقزوق','2024-02-29 08:04:48',NULL,'active',NULL,NULL,'XX7C+2VF, Al-Furouseyah St., Amman, Jordan','cB8v3uY8Su-i5H4uSZFKUg:APA91bGSm3GfpYgvaSYq1BxYLRzPkp4gc3C1gCaStthRoLFoF__QF6wJXKGryR2x_iA_UG5dVzYjHVkBUIfaWxeDf_hNv775uyEBPhdZ-uTS2NrIRLti3OHFuV5lWasskrK_s8Q0I4Qd',50,'Amman Governorate',31.962593,35.971935,'enabled','1.0.15','android'),(147,'vendor','$2y$10$pMv4ke.Z6zlvwTvLbKGOp.8JvUY.WUgDiOAT7w5dl/KX3VGs43v0u','792824253','ibrahim.98.alfayome@gmail.com','جمال','الفيومي','2024-02-29 08:12:29',NULL,'inactive',NULL,NULL,'WXHQ+6J8, Amman, Jordan','e73gACtZQ9SbY0LWGNFC30:APA91bEmIfJCtJ-8JCkQIsgk1JqpRk4BDjlpbkNGD6vvCWzgL-7HGhUR5cQF7XxmOikhkVbtZfsOcBk_OfaPJzdRueuWYwO8e0rbyL4DeXsyge-Oz1drxKk0qtxT_fI-dy3sTzEMxueC',50,'Amman Governorate',31.928388,35.989368,'enabled',NULL,NULL),(148,'vendor','$2y$10$Ko/L..He6fBnUzeIYzwt8.43bIwhNn8vPR.EbB7QcKLC.2J4H8BW6','788832921','vhhgf66ggg@gmail','ضياء','القاسم','2024-02-29 09:41:28',NULL,'inactive',NULL,NULL,'WWGQ+CHM, Amman, Jordan','f0yZgxVsSZS5gwmXgx2E7b:APA91bHEf_oRFyJ2GBCkN0R9KQPCtzw7sLEMBFYGjic1CUFeug9MPAAyvf7VOisTrHZjGrfqPQ10PiiQjpwoFPsN8qMr6eUByxg6vFD40TJMIr2oysFMOp4at-KMiGVldQzmPlgWvJct',50,'Amman Governorate',31.926118,35.938888,'enabled',NULL,NULL),(149,'vendor','$2y$10$u9TU5/ba3cXuMujLW4ZBfe69quRmvUgrm6H.ZY7otRM6tkR/wi9Ra','799919589','hamzaalnajar6@gmail.com','حمزه','النجار','2024-02-29 10:48:42',NULL,'inactive',NULL,NULL,'WW8Q+Q53, Seif Ad-Din Al-Khatib St., Amman, Jordan','e9q3Z1aWQMat7X71G-tXbF:APA91bGLDNXV3JQ_B-GKIoH1Q70W6r05f0Mecwi3v6SWtvk6Dox45O1EClLCmbMnJlORXo30647uQoB_fGvtBuD6c2Y2QPadzXyrIu1rD2HVTx2DctT3ILGiGokhd4JibIJbZx5DMOtm',50,'Amman Governorate',31.916947,35.936894,'enabled',NULL,NULL),(150,'vendor','$2y$10$h1DMXNGac2BhgpPF743XGOMza6borhADKI0.dqX27bAFkdd3/dbzG','795433737','myarmira129@gmail.com','عبد','ابو سل','2024-02-29 10:55:22',NULL,'inactive',42477,'2024-03-27 11:54:05','XWPG+HRF, Amman, Jordan','dcggKbcwSaKuiCJQmeZlPx:APA91bEfwkeUX4n5XEDds0hQspfbkfEWdnwCHwISsoZpAWj0MaGpbWjUgtto7DD0uw5VBQUIn48k-hZbI0KTcalElOmmObEglv0vHtNgGSOe_7PSU0Vit1K-eQdD-xAU9n9yPTj-h3Hi',48,'Amman Governorate',31.986386,35.926907,'enabled',NULL,NULL),(151,'vendor','$2y$10$dNMBHcWME7U5.7Ef1344O.eBsRgBhpePbUBe/epdJ9/9XTBpUtQRW','798286252','mohamad.malik@gmail.com','محمد','الملك','2024-02-29 11:07:09',NULL,'inactive',NULL,NULL,'WWFR+M9W, Amman, Jordan','fKIk0HsDQdKtjEjOk1QPLD:APA91bFa-p8jYQ4P4MHmJ_UCMpMIjEAOl0x40tJoqqs2RhPXYqe8MMUktMLiSlLizFkgUFcREElgGKyRqXG8FjrfQQ3lhuGUJFcfBp56gzZrvdJI4JwDZsROqVKY1lpti1MOS1qTqYdK',50,'Amman Governorate',31.924219,35.940954,'enabled',NULL,NULL),(152,'vendor','$2y$10$OMQX0jt0RrTPdaJS5SffcuYm7h23wBWnXKizhrXwZCaQC4itzzdLi','799896985','،accirnfrx275gmail\'com','محمود','محمد','2024-02-29 11:23:43',NULL,'inactive',NULL,NULL,'WXJ4+R97, Amman, Jordan','dR5tDGrVSyi5KYrrDXRoUG:APA91bEzulQnRM_jzm8X0BB8EdxQFE6NRvTUSGyzC4ShDNWVxi8II8fP6fsnwdZJI-Vlgss7PLqOAp_t2jdmyu_Sf9zYd6eIujpUQQ-H-_IDl892-r97h6lqSDFcF2qdEDgmAaeBRq0V',50,'Amman Governorate',31.932164,35.956214,'enabled','1.0.15','android'),(153,'vendor','$2y$10$Y2oyX4uII.fhiqwLEim3KuF5HpUJfm9cEWGqTDFL5Q/arMUMxfHQm','782303080','the.md@hotmail.com','محمد','مراد','2024-02-29 20:45:08',NULL,'inactive',87946,'2024-06-10 08:29:27','QVFR+W78, Bar Elias, Lebanon','eH8cTTJwRvWNYqnpiFG6Yj:APA91bHkPGRGQ8zkTKdRJgKh0M5mXNirvKqHogUWgwUI2V-DJKWj9IiI0G1fZgP2f6ukMPkntl5LuKkT2q29ENvVh7CJaEmTkBcoLqso5xSRXIF0FqufDnhbAD0bXVCdcW9avsQiHJ7x',974.4,'Beqaa Governorate',33.775085,35.889692,'enabled','1.0.15','android'),(154,'vendor','$2y$10$kNYhdO.CQdXU2GJrZn/tueN/Cm/S73P9eT11Ar7FBF9UvGvoUcNd6','777303013','Khaled@gamil.com','خالد','غيث','2024-02-29 21:01:25',NULL,'inactive',NULL,NULL,'Rafee Othman St. 25, Amman, Jordan','dC9jJPpcSRKrqHgxLw7c4a:APA91bEiHGOsCfiEG-Tk8fahMG1OqvqLKJ4A8OhyeCoBHSvyCz6oS_cXbmSSHzYCy97RKu1xOfSGWjBsc3Dca7znJNmAoYls0d3JFcYZw4fhwC26v_T0wruHlP5sWqdBmQcfOsrUTzoB',0,'Amman Governorate',31.985510,35.867282,'enabled',NULL,NULL),(155,'vendor','$2y$10$SqE2UFUefd5JgQZo75Wz9OzhfDk6V09PAErRKIn.XWkseovp9xSjy','777303011','Khaled@gamil.com ','خالد','غيث','2024-02-29 21:25:06',NULL,'inactive',55873,'2024-05-02 15:53:15','30M, Lebanon','cXSb6Ts2STCSQGV3QoyOkQ:APA91bHQ6aL_w5uFGKGEq6eImKAk_iSg6ZKG7CzU_o7DBOjuJ7LZhjKkV9Wy0LIrM0I-M7zcKL5o13BQCmRFM0bpHpjppOgahgJon1tv4I4u_3OPerPUtNIEqm8ZUWRV4GB4tas2rcTM',91.6,'Jabal Lubnan',33.809066,35.748150,'enabled',NULL,NULL),(156,'vendor','$2y$10$lLaty5Gg6PvqsV4LYNxd5ONjgrUCS1naGVFVKJDvCSdJaXlEpg4EO','791301030','alnimerkhalil006@gmail.com','محمد','السيد','2024-03-02 06:52:07',NULL,'active',24064,'2024-04-06 05:05:11','Khalil As-Salem St. 72, Amman, Jordan','eeIRn2yaSBmuXePh7o-b7B:APA91bFkA5Ootvgw2Yt1ub5hfMCgF4RDA7L3JmXMIfCjv6S5leuZG0ZMLyy6n2lx5KDbwb5eUJqINFkVjGspdSFp0_7xBQgkGb4BIgiOHAI_Lr00MGykcyH8Bo-Z3AHYvsCzpp9Oh7FS',0,'Amman Governorate',31.990377,35.977412,'enabled',NULL,NULL),(157,'vendor','$2y$10$WiMiDFPvQ0HueNgcd1RHpeQQ4Ple83mFI.Pb.cnXyIl3pxAL6J6Y6','791112032','alsayeshusssin@gmail.com','حسين ','السايس','2024-03-02 07:21:28',NULL,'active',72720,'2024-03-31 09:27:46','XVX9+JGF, Khalil As-Salem St., Amman, Jordan','ca4b2QfERJCxBec2xgo_P8:APA91bHhTSfkWiY3UuFPb0NO54T-iE9mfJqS5ZH-kORBIoTFm967OY-XF8jRpiSabYCOgNST_6d8ZJRdEmPPdSZR7PdEISdn_RPgS-qgYFbSip9e2c0RO4MBRR5gHY1rDM_078vm24g0',0,'Amman Governorate',31.999171,35.868226,'enabled','1.0.15','android'),(158,'vendor','$2y$10$BQDMDEfgTe.QqXx.l1XR2eMbDzQDOryS9ckXmmkErQvkPgEs5kBVC','780369899','e381644@gmail.com','عماد','عواد','2024-03-02 08:47:13',NULL,'inactive',NULL,NULL,'K. Abdullah I St. 54, Amman, Jordan','crqUn2a1RgyB4CGnz_Wh37:APA91bHf4dGWqkEdlI9bq5FSpszjAkBhjowWwwcSsI3FbvDJvp7UmrPshE5Wce4ILWkx0p7f1jmPe_ZFOadRlYe_YmVEcSkgBkfy5Lfs7ecw7HlCHTITUm_fCRGbhT-ShE37_lNRSLGO',42,'Amman Governorate',31.954531,35.953286,'enabled',NULL,NULL),(159,'vendor','$2y$10$PDt/g6tQR/bflV9etd8sL.df6Oh7aCevO1yhklUgsoy5HFFBzbIHO','791543845','saifalmanaseer28@gmail.com','سيف','احمد','2024-03-03 00:00:07',NULL,'active',NULL,NULL,'WQ3W+GVX, Amman, Jordan','fwX9Nop-Tv-xobGdJCC2zC:APA91bFa1buBRj4Ga9ubwYz5TXK3k_WdAeK7yPVnVkEnsAXFJRXboT_JyXFZTSrmXeazMiisqDQvhqOAOjLzIqD7Aa69cYJRSWWt8rqnxZoRoOgOwwiEqb0u4JdHh9a9ME3Z5gsxqlcr',50,'Amman Governorate',31.903581,35.797639,'enabled',NULL,NULL),(160,'vendor','$2y$10$4bV6MmBiipU60CY8VVPeaeYmJ7IBhCPB2nVDC8fQzs9F4Xb7TwIB.','791908849','mktabakrmabwsdhllghaz@gmil.com','محمود','ابو سعده','2024-03-03 07:08:27',NULL,'active',NULL,NULL,'RXQJ+4R2, Amman, Jordan','cv5RFni0SAGRt0bC8ccGWW:APA91bELBCr71LrIkSfy1XQNNAvVMMzk2NV0XUoxdMHfr-x4Jaxk7yObiB1ng7LOj6yQscprGeOFCsBvoRoHU-JLiIECGsh9Ax1T-crIFzFezRboywk-DHGPeDNvLRkgpb7zFuFZVHnI',0,'Amman Governorate',31.838106,35.982345,'enabled','1.0.15','android'),(161,'vendor','$2y$10$iiBld2a1h967L9LAEAC47OojSfDMhRijAb/YnvnxgmkhI/BtnAH2G','795537934','yaseenbaker234@gmail.com','بكر','ياسين','2024-03-03 08:14:12',NULL,'active',NULL,NULL,'amman quaismah, WWFV+GGC، عمّان، Jordan','d_89nQLRStOcy1d3HiztYm:APA91bG16ILqKtxf7cxiqm11ritdCLeUwurWcMG7u38Fw76XTTsuRdVJMWQ_Og-N_E8m3xF4uiRuSpDC2LMPzzOcFb7c6900rNlHbkPUB_fSAGqZTJ2RCITcsX0Z8RneD5zg0bXDaYU-',50,'محافظة العاصمة',31.923995,35.943143,'enabled',NULL,NULL),(162,'vendor','$2y$10$SBUXEvW2YjTK9NPZ6YdU1./MXIAKQmMdGDnX/a7ortAuaaU9BZP1G','796507368',' besoalksba@gmail.com','خالد','الكسبه','2024-03-03 08:30:10',NULL,'active',NULL,NULL,'Al-Quds St. 86،, Amman, Jordan','fUt7c84gTgSLggQxYGouoA:APA91bH1wFbhHYMTniSeLb_0NcOIDKKFmribmugLoDEplOq1OcpYWJWrRXM7Pp-KuHA9dW7sPFmve84FR4ZEd9XIAO86pY6amaSgDAi420yRmHD4YhP6as0ZwAfwg1DQ6m62iGJ26klM',50,'Amman Governorate',31.938481,35.922746,'enabled',NULL,NULL),(163,'vendor','$2y$10$4Jj/YqUSvMrX27.x5tstdeWci/TdzsIppRePKxLvPRCI4Tc.p4HpG','780660924','moh756397@gmail.com','محمد','ابو خطاب','2024-03-03 09:10:45',NULL,'inactive',80628,'2024-06-27 08:57:45','WWJJ+CQ4, Amman, Jordan','enT9EBl5QFeLYFfBmHSIez:APA91bEWgXr7tHZg1ecLAs7jcKdLzzTXwwzssaIs8yhSNPRuGlajyeFMDJbm4AwGuc94VQVBrCWQ2LfDiwGeRebNlDScX0rvQWt-BIPahSLX1D5bNLQjCBINJzTZw4vSlLuCLsxADokz',0,'Amman Governorate',31.931349,35.932398,'enabled',NULL,NULL),(164,'vendor','$2y$10$PofgL99jGxys0FGEvSJbXOWQBiA//al5zu8wwQUgeeTGvWHKpUSeq','796395577','iawamleh64@gmail.com','ابراهيم ','العواملة','2024-03-03 11:37:50',NULL,'active',NULL,NULL,'Hussein Khawjah St. 83, Amman, Jordan','ctZvYRbSQz6YchGEfDaWic:APA91bElEg3RdF6HZBhMRNiwZQ8xoT2TbdAtA_O2___HeWjGk9KBw6YRC4oiwySwbFgXSXXgIChssWna_puc3bgFmiNczUTjnmaJIEy0dh97IHGRS9GlUnTE7kpwHFtmFbkmtBkyvJ_x',0,'Amman Governorate',31.955132,35.839923,'enabled','1.0.15','android'),(165,'vendor','$2y$10$RWmx99/nhbGtF81eh51/rO//RLCQpatQVXcgI6zizLe0tcGLZ/r9u','797065140','ahmed.khader219@gmail.com','احمد','ابو خضر','2024-03-03 12:09:18',NULL,'inactive',NULL,NULL,'As-Sanhouri St. 11, Amman, Jordan','c7GaJw8TRCKrQReHrky__x:APA91bG0cPb-_w5NjXp_aPsQxbbkW4EzK1wn_mZcFZ2DJhvnw_1nDbXmQazhAD6Y7V3Fa1K5NTmQT2HnrgIwStWNMg415CbMZRZSw7zqJkBID_wg0aD5ax80B4UDgAQ-sTYMewKsRZQC',0,'Amman Governorate',31.971231,35.928482,'disabled',NULL,NULL),(166,'vendor','$2y$10$wR5vfJ.Gr/sVxKFwKFtKNOI.DcG9e1owwK2Mu7Vy1G5W/nxdB0UK.','792228040',' mr.omaralaasaf@gmail.com','عمر','عساف','2024-03-04 06:34:46',NULL,'inactive',NULL,NULL,'XVV8+45X, Amman, Jordan','ci_b4-9fQw2fSE13XSMOly:APA91bHdIqo_FVMu66Hlfbjg2G-hWXgvLNfkwAfuFIk9gXqFEfXNBRlKvvXWNoffVs7iDE76fqVcBY6Tc6EqDTBXXd9nceM9RtNb5bjpkkfwMdLVLiDWro7j9cJAG20h1ms76IHfFJFR',50,'Amman Governorate',31.992822,35.865882,'enabled',NULL,NULL),(167,'vendor','$2y$10$tjYDTK8ZGcoUi/BK6L9DUOi4ShTlGD6b7sNhLsrCEb5XV52iTqHG2','788161045','alsyrawyndalasyrawy@gmail.com','نضال','السيراوي','2024-03-04 06:40:43',NULL,'inactive',NULL,NULL,'WXF3+CJX, Amman, Jordan','cvaRiiOBTQyOUmtZ69afh4:APA91bFwmCsTb72Gv0yIe5ujIe-agRL5Klal-_Y4sqXcYMlOW1Kmh5FUpI52sZA_LuuKh-jykVx_XzQqmPS7Sqml-mFYIOdnwQbQ48YGofBKBeUVaf1fxt1AUrJEQofyrLMn9vseeMgc',0,'Amman Governorate',31.923920,35.954005,'enabled',NULL,NULL),(168,'vendor','$2y$10$1w2kjcBqtORJ1hglhaoazeQpiGa9p91pp3NPy081NK4hvy1iAUTN2','796960389','anoahmed696@gmail.com ','احمد','مصطفى','2024-03-04 07:23:30',NULL,'active',95436,'2024-04-15 11:06:27','Prs. Tasnim St., Amman, Jordan','cGryySO6RcC_e9gxfI7SQT:APA91bE4NLHP37tqewNqIxcclMZWlEKhtReHmr1Ja1W4CEENSWFxxlWPFgF-xmnBroOokKPEHJULTgCRK_vi_u9u_58iBaa8yAG5ocJvp75cm-24OcNUuSGvEHILHLK6ki-EbVcZrCZH',50,'Amman Governorate',32.020157,35.815440,'enabled',NULL,NULL),(169,'vendor','$2y$10$zbP5nYdh1vlQX5LGE3p5M.apLUigKPc1Cxm24bSHHZhcs35LQ3Rxa','799318940','shadimosleh95@gmail.com','شادي','درويش','2024-03-04 07:31:20',NULL,'inactive',NULL,NULL,'WV4M+J32، الاردن ، عمان ، حي الصحابه، Jordan','dqOhrDuuQi-gPKtuw7-BQ3:APA91bGXMRCL-6PKWRCwkYo-6kH1d_jkFOOxYpIPU4E-H9M1BNhtaNBBrkjRJkOVDWAxZs8u-6gA76Pfy3fWDOsAuvgcVFAOCn2c7fUnZhP0w7SIhDvpRArI-uXi3UD-QJn9HlHhSUYV',50,'Amman Governorate',31.906577,35.883169,'enabled',NULL,NULL),(170,'vendor','$2y$10$FvxV6TF4hcSGBAmaym.p3O1TIZqRiZ6oS0q89KTOcdO2hsxQdE9Sa','790114043','altaweelyazan811@gmail.com','يزن','الطويل','2024-03-04 07:44:52',NULL,'inactive',NULL,NULL,'2QW8+5Q As-Salt, Jordan','cVMv5LvFR3ydFzlvCbM1qS:APA91bHkLmAFvBOFAXY50MtjFGWNi2DRFRABanJwViZld0ASCSxodKsORF7vdpqO2Ud_SIK5D25czQ1YN3dyv-KaGLluvvyv2ao3kvWBChfhe9q_zTj-CMroHgjAKvUKdl5eDmiE7r4n',48,'Balqa Governorate',32.045382,35.766931,'enabled',NULL,NULL),(171,'vendor','$2y$10$IWEu2Q5vWzQ8TSZ/sHswvuDyEqvtyD26jUEhP6idGRI3/4De4f6Mq','798257470','hamzaadnan98@yahoo.com','حمزه ','ابو نواس ','2024-03-04 08:31:42',NULL,'inactive',NULL,NULL,'2259+RP Russeifa, Jordan','cINaNuvRR6Wk9U24hrFZut:APA91bGVwGn66YXA8huxQSP95gdJPDvFvd1RIV4qh_7kqhIQS73-s5I9QAgyf_UKqWWAh7w-AKeFcmfjWy61UhUEhf4H2Gt8Y-_xgZBIzKyAdF_TYcaUDeVhOxdLNDTNOzEC7NDKkqz3',0,'Zarqa Governorate',32.009512,36.019343,'enabled',NULL,NULL),(172,'vendor','$2y$10$88jptdNNkhZ1b1dojcq3NOI2Chju4rEQ3Ygu3KwTfEYu2bj6cxTya','785983085','ramyalswdb@gmail.com ','رامي ','السعودي ','2024-03-04 08:59:42',NULL,'inactive',NULL,NULL,'2W6W+F9V, Amman, Jordan','f11r7bp5SHSnJID3DZYAxx:APA91bGvHrr3i-pqs5xUoudTeU8J-uOrGwBpGtQ4H-G5lUWmGkEG_bpCgGiw-NFLalehPAr50r4dswvp1g4CShpSqS98O1q4AnAJboL8psh7nHsLqbXHkYinCnxtaan7NYDHvOPWnq2v',0,'Amman Governorate',32.012167,35.946236,'enabled',NULL,NULL),(173,'vendor','$2y$10$bbXqLY5wny7psGT3dLC3VOtZtX3/sPrBn3yQSJFKmyYroALsCU.d2','790488325','hdhjj1981@gmail.com','خليل','خواجا','2024-03-04 09:09:35',NULL,'inactive',NULL,NULL,'XX96+FHJ, Amman, Jordan','eArkn9lpSCORrSRasvwXI6:APA91bGOh9O3V4ynuis_Qz0Qf4W5NFYwyKe7bkzc8CHHKrrZU7PMUO2E2W9Y2Za2tnqfgof-O_IRxNEOfQshHIxwIB3uGPQgDfe1klY53d-f9x1Ir0rBoVTurxmGJ2A46fxFV5l7mmde',50,'Amman Governorate',31.968524,35.961421,'enabled',NULL,NULL),(174,'vendor','$2y$10$rYEp49ZE6YK1GT3kReSOf.2WrIAjm1UHApLqLSKO7ANYWGD6asg1O','799275175','emranzaqzoq75@gmail.com','عمران','الزقزوق','2024-03-04 09:25:31',NULL,'active',NULL,NULL,'As-Sayedah Zeinab St. 21, Amman, Jordan','dUbFAjLaQoqd8qvB1HF3Vd:APA91bEFIsj8iDkaUoexACUFn8kDZ2cLObjyJiun1nGRgUInUga4XdlDG5HT5JMSBdOiK4GbIK-dPvJZW3TpkuvaVlbv-IhYFuJX7bwFGtBI234B7Sf-jIrNvE-UM1P4m3EEtga9s_Pq',48,'Amman Governorate',31.963816,35.963935,'enabled',NULL,NULL),(175,'vendor','$2y$10$WeRzvJ8g72Zja7IsCrS.gec4gP9Ww/QLc54U6H3BIUV7nFCK/3Ca2','795927665','hly935041@gmail.com','حسن ','علي','2024-03-04 10:35:45',NULL,'inactive',NULL,NULL,'Ahmad As-Sukhni St. 12, Amman, Jordan','dXy0Q2tTR9evfXQLhBFK2e:APA91bHN-ECt79QpZ6ZuLM7ZisiIRtFd-Biauxvx7GqoYLZCaEaK3IV51CBx19PF59PutiUYi7BQttr6hJG7VfpqlwGjzJFiukvZUX4n7MrcSUguCx0lmxT4uKGS13I0vy98qy2dPLJV',50,'Amman Governorate',31.959108,35.870200,'enabled',NULL,NULL),(176,'vendor','$2y$10$2Ro54AzPnyzNTr21QOlQQeSVyYo0c9mDOqVIyYBl2LUVq4u2pnKam','790622929','habashsamer1@gmail.com','سامر','حبش','2024-03-04 10:49:20',NULL,'active',NULL,NULL,'Ibrahim Al-Habashenah St. 106, Amman, Jordan','ecH-RgIpR9ajRvxRHw5HCB:APA91bGRPYtTSHp-B8kJ8MmoUeMDLnfwsgqltdl9MwInHdWfQ4wgsVnY3IRsrADuvG1vtxBrLSHgGmeX4AWJByoalTkJIILoDSZcE_LlytYS2Z9IxHDWns8TZK3Cafl4K9VDTlESWpVF',50,'Amman Governorate',31.991933,35.984004,'enabled',NULL,NULL),(177,'vendor','$2y$10$sldmPl3lnGvnUKK4xXWZnOEi0RAAyEc0Kj08UhFjNmFx1Nq/UgYni','798710388','mahr56745fa@gmail.com','ماهر','فايز','2024-03-04 11:06:22',NULL,'active',NULL,NULL,'Ahmad As-Sukhni St. 12, Amman, Jordan','fftuydNSSVG8JcNj5yMb-v:APA91bHmZIEE_z6dK7cxbRS7bTyWdvYg3qD3B-qonosjp6ivKZjeGVwSq3qjO3KPqDqq50RQRvpiHGzIeePwukVHj4h536a_iNJRF6aXQEkG-zR2xoT_GMz9t3dJ1nBkOU4s26gWMiUv',50,'Amman Governorate',31.959063,35.870305,'enabled',NULL,NULL),(178,'vendor','$2y$10$VuNhhiuCsj6eH8ahjGsNg.AprSukdmVHMvqPRseFekejqvrINTehm','797403057',' abd.karmoh@gmail.com ','عبدالكريم','محمد','2024-03-04 11:41:59',NULL,'inactive',NULL,NULL,'XXMG+7HW, Amman, Jordan','cuN04HmlQJOlEs-3uaP74v:APA91bF9YtTrsdBb3Tj7SQJbRrqYMz-HjN34o82P5QRz2jz3sVuxyIXfLdsvCxD_keunNKoMZhrT52NZf3kIi4SnU_pKqYdXXMzo6wtZBwwcUsbgc76Cd4nt2rfh78ktcNBOiwOIlT01',50,'Amman Governorate',31.983927,35.976812,'enabled',NULL,NULL),(179,'vendor','$2y$10$LVcXLnNBdiVHWkwnMB8cS.1GHYGabYLJohaTvdM4YB0uuQyatopt.','788297967','uduufu657@gmail.com','محمد ','الزغموري ','2024-03-04 12:25:41',NULL,'inactive',NULL,NULL,'2W2Q+6RJ, Salem Al-Habarneh St., Amman, Jordan','d7s5LuKgRRiV8jH1qk7JsT:APA91bHE2Bw-kM5hp5I04hxnjTZE0_fHzRiiGa_T_KxfiVpC381WIzLY-L6NQj3BYWqlZZfUWR0ZpRu-BXgnPcR-zrV0xe_aXn2E9iPRW_QvsSOxVwNed5V2aVIE2QpGNIMX5Q2VSpYS',50,'Amman Governorate',32.000939,35.940192,'enabled',NULL,NULL),(180,'vendor','$2y$10$DANXPDA5od0wQlcAWSoac.U5A8/HYp7b9vmUd5jvHKvwkUG2dKPCy','789067391','bda154350@gmail.com','عبد','البزلميط','2024-03-04 13:13:19',NULL,'active',NULL,NULL,'WXW4+9GW, Ibn Mosque St., Amman, Jordan','fItmdDVfRWm38uGvjqxZQY:APA91bEMixxQ8WIW3jYl_JF1GCnfBs_QN9aulROxlEkg7EGTdgdAZBy58OpfgNa0de5ZwSR1EkdXkzJBFGV4DQI_D7w_YUC8BsOfH8wslHllgUvgX5siE0bgR93ZWmtsTX1FZRByYL4u',0,'Amman Governorate',31.946147,35.956388,'enabled','1.0.15','android'),(181,'customer','$2y$10$aRIlG0Q.LQBR5p2DXWxl6eFVeCsfx4EZt95Tl9OMfzjDaa2zp8MVi','782303075','rafatawad1114@gmail.com','rafat','awad','2024-03-05 09:46:03',NULL,'inactive',62658,'2024-06-24 11:45:40','WWRW+C5G, Salim Al-Yaaqoubi St., Amman, Jordan','dPLflG4xSCmDkUKi_avBbY:APA91bED5V_Y4YKnj3Dk-VOMek1Z8gv_j9amXD3n7TJC7sdVIGUphdOjf9MzSPBuFPiCdEuOaOp9S6PDqlEDyOjGO4FCKzKTPJ3Dxh-fLnlaxnR0F310LgVmNu5CHLd13AdxhgwyvTd3',NULL,'Amman Governorate',31.940883,35.945639,'enabled','1.0.13',NULL),(182,'customer','$2y$10$QNZ/Vmru1UvmIdjqZjx/o.vTR4bXicNDxPoIf7tKXKhH8hrwSOV8W','782303099','khaled@gmail.com','خالد','غيث','2024-03-05 10:01:57',NULL,'inactive',33209,'2024-03-06 10:21:40','QVFR+W78, Bar Elias, Lebanon','eBCMRJyARVCiwZYBgHgb3T:APA91bEp6o8AtFsxbCi-5Svi4iUkeZI4dxzRSsCw0djndmJhLJLtKEHrM_HeZ6J4Jed4aWMdNYbYjpST1wVAYed5tHZz9oTg6AChDoixI1Rs3glwbvHo54nuxEyhyShaOQSax_WaRKyg',NULL,'Beqaa Governorate',33.775111,35.889848,'enabled',NULL,NULL),(183,'vendor','$2y$10$YcMFodbLheHxmp5HlIpwL.4zn6c3di8G1ihMjw14tOTHybctlAXAK','786237667','moong4030@gmail.com','محمد','ماهر','2024-03-05 10:27:21',NULL,'active',NULL,NULL,'WW5Q+CX4, Amman, Jordan','foxsw0ttSMaZU1-iNxpOVP:APA91bE-XJG6022HHVEzFCJb6ATfPjG5BrimOXtXOwjmZ1H5FRnDFg1_gJNU0eiX5GsNRBiYQd-4gVnmCqUjIyqB1pJ2tXNfqZMHITrbjnl3psxFKwPzFXBl-Iu82V7VkSDFbv6vWGD7',0,'Amman Governorate',31.908225,35.940505,'enabled','1.0.15','android'),(184,'vendor','$2y$10$XnsLEXPU29jFbhxnBvDPb.ZrVy8OvscdkMbPsFRh87Oap4x5QN3Fa','798032123','abrahymrba779@gmail.com','ابراهيم','رباع','2024-03-05 10:53:33',NULL,'inactive',NULL,NULL,'WX26+JPC, ZaAl-At-Tarawenah St., Amman, Jordan','f2k_5r8aSzKlSKDCDM7Yft:APA91bHcZfBB2eb7fYBvu6iUKOltOFX630gO9ksafAfgWfia0bbyaFB4b9BSzXV1l-J17B5D-W72vVzSLXDdP8EmxJ5o-FmaAdKELhN71ZPm-ksLExDGOOxbdVwjEPB5D1OI-P3fp0yk',0,'Amman Governorate',31.901153,35.960761,'enabled',NULL,NULL),(185,'vendor','$2y$10$USA..pvp.d1NEKtUqiVrfu.HUdgceYexVCyHZGK0JwetQPJ39GJWy','796292331','alharas 123@gmail.com','عقيل','الحراسيس','2024-03-05 11:32:44',NULL,'inactive',24979,'2024-06-29 11:28:36','WXG5+MGJ, Amman, Jordan','fD0sqIrQQZGcvqoXT9kIpt:APA91bHWfTzG8mO1Ba_uVvbwviOtgmdD68w5wk0tjaq_drawH5L-Zuci31pXGjOpUpBQhgErP5KefeKKR-w6jhiSWsJfhweSscS8WMweIN7fDhIpK3x1o_qTXxX7JIgGG1zNlV9fxgJ7',0,'Amman Governorate',31.926822,35.958798,'enabled','1.0.15','android'),(188,'customer','$2y$10$IjsqN61RboWpGdTVXbHobez3zQuBlkCdX2dpCyqP9IBaVXbw5YjlS','782303078','mostafalgzawi7@gmail.com ','Mustafa','Lgzawi','2024-03-05 21:35:36',NULL,'inactive',57265,'2024-03-06 10:48:33','Wasfi At-Tall St. 18, Amman, Jordan','f6TtWr_QRaKumZe58W7BqA:APA91bF9skVsPVvo7nfYffgltg3uVm8upA0xyM6mwEE0JvqkO2lo6zqS44q1ONsbbdIVqVHZkVM0D2aoDVz3x5Z28LqVTdD5CthFhveWI7dMQFZyshvzhfvc_xUKSjpg2S3oluFqOjZw',NULL,'Amman Governorate',31.989842,35.871389,'enabled','1.0.10',NULL),(189,'vendor','$2y$10$EWYppAaX1NW3qg3/AQ2eQOBeBH4YIOjhPvM1h28VVbrvj.HSIeAbu','799749920','thqaqq@gmail.com','امجد','الكسجي','2024-03-06 08:27:32',NULL,'inactive',NULL,NULL,'Pr. Nayef St. 12, Amman, Jordan','d2aJA2_QSc2uiu3ovmXgT1:APA91bHIdUecT3-v-dz0REJK8BL-NktjWVkvzhJWnjADQfqVW-IlMY41rcKPUsgfJ8_XzVK4ukbGiZ0YU9j3cdwd2C4FA6JB-m7tKsKzsLKJdncIK0SMes99iNUOqjTLIfEH2ujqVXof',5,'Amman Governorate',31.929906,35.951712,'enabled',NULL,NULL),(190,'vendor','$2y$10$QLFktbYa3mrCZde2S1iOOeFkorhrYlb6uLZk5B43SAVigRs1NNe/u','785486802','wahedmoamd62@gmail.com','وحيد','محمد','2024-03-06 08:32:36',NULL,'inactive',NULL,NULL,'XRRX+32W, Amman, Jordan','c28nH5TTRaCpUngp6SGy5n:APA91bEOje0ulS2eNv3sfB6RrLqyDN-ioxHWWB1tQd5EI7QyJEEAi0KHMC6fbPNjqCa7f2NcJbJK2bdgePJ6DbAZko3CkW_1xT3cnzlHRqHne4kbb88ja2RIv5UZlq0xvR7KcbWJngS4',0,'Amman Governorate',31.990319,35.847589,'enabled',NULL,NULL),(191,'vendor','$2y$10$/XoRmJRXcsN2DDKQlwQbm.IlBkje7Rk1GXlOp8xTipKI8SvyuJfA6','788583943','dbhmstfy73@gmail.com','مصطفى','محمود','2024-03-06 09:07:45',NULL,'inactive',NULL,NULL,'ش.سليمان طوقان , بناية رقم 13, عمّان، Jordan','f1vwdCKMRV-e0aJQA-f71D:APA91bFrKq5MqkAY8HB0eu3jNsHxi2avaE8laxMmB7fIbbm3Va8T8zO7YyQiJFkJMuKpu5UBT4VIiwAAPJcAFoRRRyw3gUllb6Pyzb8AqefNobgtf5aoMWYDQVX8fFtTQhXjzjgLj_Gm',0,'محافظة العاصمة',31.980774,35.856400,'enabled',NULL,NULL),(192,'vendor','$2y$10$FLq5KDmOvSWDby5LjPRpEuQh7W1EAgGCnbdkaPO0KftYUwdC6LG7.','788117015','tahseentubakhi@gmail.com ','تحسين','الطباخي','2024-03-06 09:36:17',NULL,'inactive',NULL,NULL,'PWRR+4JV, Amman, Jordan','dPWW3kdcSnatRfr7OCy_XE:APA91bFeGOacNl2a1hZbY1tYPenjJzvO6eCNHp392-wIA-kS0Po5Cb0DOc_r5ZxDBuqbDrFx-S0fVqmov-MAde3405t29dqWX5Ro7eblB2erx3ja6W6Eqw_bWjbV7Z91EchlJpsLpNJ_',50,'Amman Governorate',31.739789,35.942353,'enabled',NULL,NULL),(193,'vendor','$2y$10$.2bRzikSXGXN/bidSQKS.Oo1bKNOK7VZO6qEW.IhBl2xBeCEiRaFq','791751850','asamhabwslym3@gmail ','رعد ','ابو سليم','2024-03-06 09:53:06',NULL,'inactive',NULL,NULL,'الصالحين،، XRPX+9G2, Amman, Jordan','cpEAND_kRtm-bYeSv4_5Bd:APA91bGkHLIkAF8YOjzPyBl7Da82HrHmrHaJd7X1j2jimta9m0B7DYDuPxHVm5hiaaF7y14UjM_C0L0vQ4YN9kwrB8avk4UgpsrfDukzyYxUh-NTcD_HJ2H3fktalIk82YZ1-r1R-oF_',0,'Amman Governorate',31.986317,35.848837,'enabled',NULL,NULL),(194,'vendor','$2y$10$TnIdvGSjQXZUQirOILJNMeucw7ssN7x.E1ToZqQWZPT8AOzS9gs2i','799789127','esamghunaim86@gmail.com','عصام','غنيم','2024-03-06 11:30:57',NULL,'inactive',NULL,NULL,'Musaab Ben Omeir St. 28, Amman, Jordan','dqn4rOJRQg-iU7_q35-Lyk:APA91bH2IJ1d7RSS2V9HcxT7RxmY5_yn3k9JAysA53MLVBXgJYizEbQ939iCt9uDow9TpudaDem1wTW5PdMXsuG9D2nER8QQpSdKZPhoNQmNNvCO7rLgk1vMS3ivY86obAVIs1cYAAYU',50,'Amman Governorate',31.920585,35.933745,'enabled',NULL,NULL),(195,'vendor','$2y$10$dLl6xGDrMOzoCgDS5Na7LuR3KTt2D4OhGHvmtI/bErGQoCWVlKue2','796519950','ahmdtym985@gmail.com','احمد','تيم','2024-03-06 12:41:22',NULL,'inactive',NULL,NULL,'Kasseb Al-Jazi St. 57, Amman, Jordan','cbyQPb9rSA-tdVpwN9wBr6:APA91bETjzo9kav4dyYkwqGyRHwUutkJAmzRODzNvWSvIf5nQa6J-87M1zZaTYOOxW8Cms2KfGZcpnq0u9tjM5-66p10-tOT_5K7YrxmZTnsYiHm4mbAjCv1LAOB5g_zwYuxo8cm_bvd',0,'Amman Governorate',31.868951,35.902945,'enabled','1.0.15','android'),(196,'vendor','$2y$10$Mu07syyR9TL3UQZ9RaJG8OVUV1qPLxCVTov5SMqB436F28Rbrpndi','790835628','adayekh999@gmail.com','علي','الكردي ','2024-03-06 13:08:57',NULL,'inactive',NULL,NULL,'XX5G+PFQ, Muhammad Az-Zoobi St., Amman, Jordan','dyfW-X-VRW2RwrAwrOrX-3:APA91bGW2KY4Qq93rJvzohi-eISXZXjwBz2WsB3j32vUgXHHX1dr8iaAb_12Tlg7JLo1FWTchSLLteiQ1rVqPQSIJibhAQWfPxkV_Y6sVMCKoTrWyS4y9RhyjLtVr40evzieK253AVK9',0,'Amman Governorate',31.959019,35.975974,'enabled',NULL,NULL),(197,'vendor','$2y$10$n4c/exxQxup8wejLftn5s.rTf8nR/7HQNbtmICfqShUf26F.E5I4.','791919707','aa53aaaai@gmail.com','نزار','رفاعي','2024-03-07 07:24:35',NULL,'inactive',NULL,NULL,'XRWX+F9R, Amman, Jordan','d86k0g2kTSOXISzVPFYgWE:APA91bF9Jn8YDQ5Taelnwm3YLqLZwGTSeva4kx1qVrJuFmCxy07GrGDEoVQKlJLTm04LwI12mQEmr39kfi1GpkuNug30s9ZTEs4Km7AJr7KE_3Pr82YSjKhl75eqV17_vIG8ZSSD-P7V',0,'Amman Governorate',31.996212,35.848333,'enabled',NULL,NULL),(198,'vendor','$2y$10$FyGs4.MDkmhMvtJvKPwIv.oyxQ88e9E18/3XCTd0FLhW74NmVIrsO','778482873','jedadalm55@gmail.com','جهاد','المحاميد','2024-03-07 08:30:22',NULL,'inactive',NULL,NULL,'البيادر - شارع الصناعة الرئيسي مباشرة بعد الاشارة الثانية من دوار النهضة, عمّان، Jordan','fIhq59xCQTyUpjBoENFvOP:APA91bEuLau8fBhypgCCg_yOxxNRsqL5ub2X5G5xVQDH8kl-SI_PmFvdP1npEKyY3E4iXvJKEAKzjGuBEEvgN4kLe5xkHhxyLfgvCjF3U91k0wbnkyur2iShQxKNbBP32sNRE5RA_7TE',44.242,'محافظة العاصمة',31.946287,35.839401,'enabled',NULL,NULL),(199,'vendor','$2y$10$9Bp8LL5zd9LYvqjAhkbPd.XyjBsjGTBrk4CGKgCDakmWdvfhU8zJ6','775803531','h71823703@gmail.com','حازم','عيسى','2024-03-07 08:32:07',NULL,'active',NULL,NULL,'WRWQ+8PR, Amman, Jordan','eBodd00ITnmtOdcaF_NBr-:APA91bEn7D1FZujeXrVGi7SgSvsDeG-gc5GDRIMsm2aKfnu4ZEuOZ-Zqj2LBCrDTeuNvVE11hYMNyqcCZkvBbP6p17Jts7g1Pa99nTopi8vGJjbYvl3r0MrZ0ZcwpeVO1fpP0lGRciN8',50,'Amman Governorate',31.945957,35.839215,'enabled',NULL,NULL),(200,'vendor','$2y$10$tIMdFQn2ZreIxBnPDsrWEeWLNpm1u.74aPzroUmdx9O2N/r6f7opK','795730888','nailalherbawe@gmail.com','نائل ','الحرباوي','2024-03-07 09:28:36',NULL,'active',NULL,NULL,'2X4C+Q5R, Amman, Jordan','estjsa9ITBOSqq9IQL4rWy:APA91bHQ3jSybRbIqsZfnMnVKSzc1DqNUX2eAxRbr20uy42zmVzKHp52SCzEB2NkUYLNMhSJKnNHtHfkKTYAb8YLmH308-RWf6lwZxHiggtpL8WcSLQ53_HZ3uxyb9jnzJAXo4E26xdM',0,'Amman Governorate',32.006742,35.969951,'enabled',NULL,NULL),(201,'vendor','$2y$10$3NnCIFryhu7HsnnY6kkISeiEgtN53RbHYmsm8s3V3KVfzpyDjpIYO','776058115','alrafr93@gmail.com','عايد','محمد','2024-03-07 11:12:15',NULL,'inactive',NULL,NULL,'الدمينة،، WRFQ+MWJ, Amman, Jordan','eGG5H6xaTd6mFcQ1sh8SVz:APA91bFxeaWEZwdz6oCHfsY6eogWiSEWDTC6f_GrgdEAXM16KYb1gzELsYcb0-DgYCd3B4EKEo97g7v_hFYpv13vAG-oG33kOJnMboUxS2zJs-xnTw0lOwcDlal6V296Ozt7ZFGm0a6S',0,'Amman Governorate',31.923787,35.840223,'enabled',NULL,NULL),(202,'vendor','$2y$10$Iy7O8RUBiknS.ryPP6hsfuoyll.3SJfkNn/jFcNyM.jf3whzju8xi','791070955','cjjdcdijff@gmail.com','زياد','العبيات','2024-03-09 07:47:29',NULL,'inactive',NULL,NULL,'Musaab Ben Omeir St. 28, Amman, Jordan','d4EYeNaHS5GlE9_u00FzE0:APA91bHuHdtt3xBLpEfH_r_uw1WNASlIMaC1kehR-F_rnrPjQev1j7RrUAUH79DT-OhBqKRPej6JIOYxmg8OsjqkGkiff1wBuX6bKaNqH6BkoboEdLLW6P9Plhg1tM_b9MFQUlvweRN1',50,'Amman Governorate',31.920300,35.933580,'enabled',NULL,NULL),(203,'vendor','$2y$10$PtEh7DJV6pbiyvuV4KF4nOuFfIY/OGR.bTeb0AfdlzrmJu/uKVDiK','795001887','alselawiimustafa@gmail.com','مصطفى','السيلاوي','2024-03-09 08:14:39',NULL,'active',NULL,NULL,'الاندلس،، VWP8+8HX, Amman, Jordan','cdJ8FyLsSRmKqBNlHa5o20:APA91bGU5Yobl9HiaPK4C74E_1qS1Lfyjtgz16Dggg2YKb6_wRPThY2SMcftHgk8k3vBy-7akohsbEsht8J0hnUBGi_bW7jPLNlAIEtJVEKD5apKU7yfx3F4VPj1xjadIY85DlFFwT3_',48,'Amman Governorate',31.886333,35.916915,'enabled','1.0.15','android'),(204,'vendor','$2y$10$e2KlVkNg8qP9VHWA4F9P5uk.zH4KfqQKcV.GCbzhKjIgcYDYXaDPa','793030993','bandarsameer578@gmail.com','بندر','سمير','2024-03-09 08:46:25',NULL,'active',23036,'2024-06-27 15:19:38','XR2Q+J5Q, Abd Ar-Rahman Al-Husami St., Amman, Jordan','fG77UYpATTCQJcKPfgzQG3:APA91bHrRYMdVmcD0EbmOAwAZevZczqPOEA-tWoffDs6vqFc2xvokW3ALJfTloa_jIpJpEXOeqp9rA0WaaVqp51JgxgomJdiS7P4byxZzJFXz0997EAHz-9X7yEHVq-Y5d69lcxJVbCq',50,'Amman Governorate',31.951158,35.837764,'enabled','1.0.15','android'),(205,'vendor','$2y$10$IEhp22zZET3UyEYwseTmk.1HeZ/sUtyz9npz5squxxQ.QOfGgblk6','797229393','aa8931121@gmail.com','عبدالله','التعامرة','2024-03-09 08:47:37',NULL,'active',NULL,NULL,'العاصمة عمان، Amman, Jordan','d0_euICsR6m3aeXhkWz04q:APA91bGQEY3z9Br7ufKYd02sHl82f7FwJ_OHr6kAypDahUWr8C6gQcJpR04zs2q32xd1PVRGrWuzpHPD2wSnZre1krbRKQdZXxUbIXoj5yxmUDZXCiOpxve_XlbsgAyjczxG9VRQqg95',50,'Amman Governorate',31.958860,35.870587,'enabled',NULL,NULL),(206,'vendor','$2y$10$WGPeygIOgZXaavmLQiwp9eqbKjHLmkiiiZaiKcwl/z1i4EHDH79J2','777764443','rami.jreisattt@gmail.com','رامي','جريسات','2024-03-09 09:40:37',NULL,'inactive',42697,'2024-06-29 08:17:13','2QCV+F8, As-Salt, Jordan','c7bB_HiySvCklXoxQwW7ux:APA91bGwMMPRobg4-1gUsn82aZdW9dVQsy1a7O7GqC50ZAXDetTdQk6b6mZ2O4dbVR6QOC8irJercXk_SSLFV2YacUwE71-prklrZ8aamZzEFuh4MliOP3TCrGx0L328UAU4B-AEBOJa',0,'Balqa Governorate',32.021783,35.792096,'enabled',NULL,NULL),(207,'vendor','$2y$10$nAGw.uGazcMs/zhYLFdgUukHxTZrctJeZmBq2HriO7YMHMhIrMy26','796847561','gg619695@gmail.com','خالد','السوالمة','2024-03-09 09:42:00',NULL,'inactive',70135,'2024-06-29 10:26:18','2R8V+V5G, Amman, Jordan','cA0u5zb1QciQarxYfX7aX8:APA91bETEfZ3Z7OqOjH-jx-ak1IDYrbbD4iVsF5_MyKDBx828LPj4kWVyh2QyH6A6B22Env7pgaqpusbcGrAqiVHdItSQ4kN3RkZppZnCizkZvEj3eO8JyRamPCA487XGLY0vRnTQEaY',0,'Amman Governorate',32.017128,35.843056,'enabled',NULL,NULL),(208,'vendor','$2y$10$J6jPNmhodgPYyDwi4R8V0eXc/wWyKxzfgIiMHG.wsLuTQrjQZ7ZT6','795408702','Adsm63169@gmail.co ','ادم','حاج علي','2024-03-09 10:02:32',NULL,'active',NULL,NULL,'Pre.tasniem Street Fuhies -balqa, Jordan','cx2U7QCkREO0K-40t0KOss:APA91bGewj0EcNwUr79BU-b3-qg5paxDrMJSy4mUC69bkBlsgyG2zDSRX68Re_T6urew4lgmnhSr-12qCCD4I0rZlqsCrps4AfM-KdpJitCwLLKkTrYzM6jHIA5iXvO8r6Hh6s6W7yPG',0,'Balqa Governorate',32.006163,35.787721,'enabled',NULL,NULL),(209,'vendor','$2y$10$yxQVvD5X7vRkWpEhkkQJXuMxG/Gm1YJ6c9Aqko3xluf1o.S/ZMQ8e','785230001','mahmoodsokar9@gmail.com','محمود','سكر','2024-03-09 10:30:30',NULL,'active',60750,'2024-07-04 12:53:03','شارع جرش 35، Jordan','dXYPDLseSJq7hhIYBV7P5M:APA91bG-r6yYfNhF6NiEWHj-m0PCkSFbKjw1sj7t6-1kymkb_paSxSuU7ZfASNnS3-iRaOtPH2AjMbNcTeWd7WMTywt88cS7GFQt5cQfgbGPpnUVnPXyAD3t20hKTouwMELDBJJJEJBG',0,'Balqa Governorate',32.062447,35.841182,'enabled','1.0.15','android'),(210,'vendor','$2y$10$hKlCxEtzrjhLRAtgfVMbBuRN6zv.m98QZwX/MnjjmjIF90K0X2QPa','786533333','ibshalan19988@gmail.com','ابراهيم','الشعلان','2024-03-09 10:34:44',NULL,'active',47799,'2024-06-23 11:00:52','2RCP+42P, Amman, Jordan','e79t_MY5SqeHbZhjpW1Jag:APA91bFinpNzDR8Hmq_hROzpk4myQ-Fy5qooESaHXCpEmJCrHt9Cui1Ls05UYbhDaQQvKTXJWi8mk9I_1WuUI0N11tZUs2J0ys-x5Vhz0ABclWnKSO0183qyVxRxGjylKD1BAL67RtkR',0,'Amman Governorate',32.020473,35.835233,'enabled',NULL,NULL),(211,'vendor','$2y$10$EdnCOXmOjbhYdgqVO6OqtuvAoL.6M/iaWdlBBHkn45E4yC0N3kKc6','785201619','o.alashqar79@gmail.com','اسامه','الاشقر','2024-03-09 11:57:47',NULL,'active',NULL,NULL,'X2MV+43X, Amman, Jordan','ewbPfjlKR5CnaqlEZaCGoX:APA91bHWGaKgAvPKAWS2Fc50A9FO0EMOOZ1rLzSoo_RZEgvuJcuwAaXODGx5SemcMuKwGGNbqsQycDxJMh4uqM3v9WOUM79lWmHlQ4-J66LHfj7kdnv-tbj7Ta5-TGEdwTfIEQBuUQ4W',5,'Amman Governorate',31.983340,36.042367,'enabled',NULL,NULL),(212,'vendor','$2y$10$hhfdxU4xc9udgFRNCywZ1.0h/9A7CiEBT.yl8mjar7HEADoDpRCee','790301314','arjanwhater@gmail.com','علاء ','ملحم','2024-03-09 12:11:35',NULL,'active',NULL,NULL,'XWPJ+V5C, Amman, Jordan','f8gNPnz8RBm3YWWKqNcDYn:APA91bGMinezPwF6hoRRvh2pFFxxYU4Z4fBhXmWkk_Ew30moy1ooM7BluyNr6GicaT2JVUfi2zFaFq4QTvUfOHKQj3Ip8HTCugX-uJVJkL7z82oU-PfranFmIt7XDJqhjmSBFCoNkTwv',0,'Amman Governorate',31.986993,35.930213,'enabled',NULL,NULL),(213,'vendor','$2y$10$Iy3xDPTxt4BFrpMz8SWHzusM6oMphmT9TxQIItPc9eecpjhyw3rSe','798732062','ans964967@gmail.com ','انس','ابو كف','2024-03-09 13:10:59',NULL,'active',NULL,NULL,'WWG3+V2 Amman, Jordan','dmRIgex4SkW1ZqYjQkZllC:APA91bHaJGo_WlwEsKPefhv_ix7EoBJHg9jV_Kzu9atJ4xcRW537QZwzITbrfNEaLQgf0lhsp5H6cO7FmNctQ_-A6syv6j-rq_xRpnfVUtRz24XoyZ7K0vZRrxR2tDndm4rwBAtODfs8',0,'Amman Governorate',31.927190,35.902582,'enabled','1.0.15','android'),(214,'vendor','$2y$10$BhkqVt1D432y8.3EV2rQteMRQhO9N/PdG09cHzn6WIL2qYijN3X4C','782121455','eman. negem344@gmail.com','انس','قبلان','2024-03-09 13:55:50',NULL,'inactive',NULL,NULL,'Khadija Bent Khuwayled St. 21, Amman, Jordan','eQB3jvuUQZKnX0fJfJ5RQ5:APA91bEOjTO_Z0IppnxdzdB0l6l_Z8-IHuna6b7p2bXbFRQRyxK6guEDHt-1StdbBmMHZhhrDLgp6gLWFtbit_9JOUjXbmgKjZrylZne3zS6nMUvctPRMn-gX4k0h9CzhMY42hnsn5nA',0,'Amman Governorate',31.918076,35.936406,'enabled',NULL,NULL),(215,'vendor','$2y$10$a.MGzW5pQWgNdkC/GqffjuTRanPnkMK/ez9MyUI.BBBF/ghzbrvYa','796060889','mhmdadbwwdhoi4@gmail.com','محمد','خليل','2024-03-10 07:15:20',NULL,'inactive',NULL,NULL,'WW7W+MP3, Amman, Jordan','cer6PjRFSKuoSDPHEF2qxq:APA91bE-C-im3BIa0sz8meBdtY0-tydXvqVgUtpQjRaJxDuIqsSnOkf7wsh04fFQcGYo-xZDCAyyRKS_yGnD5wsObwAQxVFSnnlr6HUMYx0uikqNfKI82ixs7IXwMuhhzevmKAQdAB81',50,'Amman Governorate',31.913767,35.946981,'enabled',NULL,NULL),(216,'vendor','$2y$10$NJ3tqbpxgrKPwCG3n/6JG.nx7bp.YZkpxcknEFkcYjvYDRVNvrTMS','798690445','mmmabwmhmd89@gmail.com','خالد','حمدان','2024-03-10 07:17:16',NULL,'inactive',NULL,NULL,'3R5J+PXG, Ein Al-Basha, Jordan','c6D-De3gSFKtEd-WpQeEB8:APA91bGfb-p541-2me8S7g_uFFo5ejxDpBaUpw42ifw6JwlwKgEbocdoZQuKOpgfoeYoa4vBeqIC1gmyxYpF9RYUx0LjveJKhfo1CbxUoNnD_XA0u_w6msu8zol9hbG5EbM88A97XLtc',48,'Balqa Governorate',32.059312,35.832893,'enabled',NULL,NULL),(217,'vendor','$2y$10$AyL16.STz8gxg7bD4frCTOEXUsMIGmYdWWX8.wJHh/InMmRqzWwZy','777804500','almanaseerkhaled21@gmail.com','خالد','المناصير ','2024-03-10 07:41:30',NULL,'inactive',NULL,NULL,'WRWG+VH3, Amman, Jordan','e1CHvxTRRM6veToCF7Mu0z:APA91bHxeIevoqrcwiRC_tHMuD0tDHoJH_Ggx_dV7p1cz47sWROBezBzsfWGjVj0nwiCl5IaqLvavVkP51wtYdBGu_QvEdLZE9cN7ZDWYFMLrCAVBj_QVr4Wy1nHlsvoIPi1NKdADq4W',46,'Amman Governorate',31.946963,35.827248,'enabled',NULL,NULL),(218,'vendor','$2y$10$dICneXje5x6EbpwqpJlHo.ghm4HlEFiXHGo2eqGNZ/k6VgR5g6IX.','795788216','huufvvco@gmail.com','حبر','الناطور','2024-03-10 08:27:34',NULL,'inactive',NULL,NULL,'WWCJ+6XC، عمّان،، Amman, Jordan','c6XCpmdPTs6FQ2Hy3FNB56:APA91bFcz0GmzFCY7l06Yfl5DFnid-HczYnUyb0ig6ZISYYIcpWB9bB37BZaYEDVo8QYe1obA6InqlQUsjFxMNwnW1Xw7CwgplRgakXWm0zqKlAmCdWklolrqUJWJA2PfydkIKyV4NzH',50,'Amman Governorate',31.920351,35.931895,'enabled',NULL,NULL),(219,'vendor','$2y$10$pqhfM.hNdQwW/QkYs1W4s.waOc2QGKNNyfLi5A1JhVoDTj4eYM8Zi','790365610','aboodwahdan78@gmail.com','عبدالله','محمد','2024-03-10 08:56:26',NULL,'inactive',NULL,NULL,'2VH6+CR4, Yajouz Rd., Amman, Jordan','cDWuJkAsRDaVqZ-Q35pc-f:APA91bFxsCPDuqQ3G1UF_qOXkcAzsUgpIdfJekhbBXbbJZrmm7FIotD8BQSkhm0DZdofmDwX4544fko8r5X2hBLn2LMpjjVbvVdO5t1aFY8ixVQ27vwQzKlUu1cGDi4TRMBJBSiiT9N6',45.9,'Amman Governorate',32.028581,35.861980,'enabled',NULL,NULL),(220,'vendor','$2y$10$rlKK2bq.3t7BZdGuRra/POM2wDplSLMVMHvXHm3H8tPpEwz0MOZcq','788461610','kamal28556@gmail.com','كمال','الزعاتره','2024-03-10 08:59:46',NULL,'inactive',NULL,NULL,'WWGH+X24, Amman, Jordan','e44n8DRjQUWBeL9pwn-sHE:APA91bH6gkHm_MyIxJAIHcxb4AfyeQ4THVaFpYq89sxanUq42ChE7L-xyPbxCrgz50plbrJL_yYNNkUpTY5CoXYb4PYeOytb9f_mG1FBfS94pSBEpZE5PljabdNNDEjQtRuvQA2P9Xxf',50,'Amman Governorate',31.926741,35.927437,'enabled',NULL,NULL),(221,'vendor','$2y$10$nKkrHVKRbUdessbq3SNs6.HfOCqwucMGzYQXTITQo6u4jkmmnEfm6','777200609','feras_znemah@yahoo.com ','فرلس','البلوي','2024-03-10 09:18:58',NULL,'active',18666,'2024-07-09 20:21:45','البسالة،، Amman, Jordan','c72VWQ4sT0mZEoRrfLDd7p:APA91bHeyCTLZD56IGK612AqgrSaGb8uLZEYtw0HEt_TvbVsf4CaqFTRr0blmmJN5p1jN3Tc0ao9XgBHDCSePY9BfkAMlTEeVbxrA5Ryvr2cYqkILqMkicXtQ85laHlX-y8OaHKfNDW7',47.5,'Amman Governorate',32.052395,35.878405,'enabled',NULL,NULL),(222,'vendor','$2y$10$PcjZx.4Ke5vyeqRcHcynpuZsmjBm2AEqQ0aLhSppfcyeAmp/quVSm','795277021','fares.mahmob2002@gmail.com','فارس','الكوز','2024-03-10 09:19:19',NULL,'active',NULL,NULL,'WWFR+P75, Al-Mukhtar Ath Thaqafi St., Amman, Jordan','fPIBie6SQs2NYXXSZGl1Rl:APA91bGEU6HnHWkokfOeq_uN3O5kITSO25b-x2FXPjMpiV1qQ2L7lMCviX4XftsxCZHzU1DgO5GuEviuJEvbPmc69FHLcnQPiEawrmZ90bBHXvSoN60d7tikSvDiZPTymcWu4yIGDuVL',50,'Amman Governorate',31.924328,35.940878,'enabled',NULL,NULL),(223,'vendor','$2y$10$ZnKbraVTOL5YlvdZsrKm1.pSNm98VwaosfPBqjO.RuW//I1xgm0VK','795371477','ayaamahmoud1982,gmail.com','محمود','العيه','2024-03-10 09:41:40',NULL,'inactive',NULL,NULL,'WXQ9+3FF, Amman, Jordan','d-ADlc8SQoqUlTdjJ7tEHw:APA91bE_914osBIO1ut08ffj47qhEsQHvH8XXNSB6h1TmbKv_d2H9b5LvcUOOzQeOK5OCE3tELaMrGHhjmFNXzMsUQ7p2VoPukxBLcsMvr7CtM-51vmayPrZ1mW-ik1BWiZlJOzMlypO',10,'Amman Governorate',31.937385,35.968299,'enabled',NULL,NULL),(224,'vendor','$2y$10$EU4TucltIr/BLbLG3sZSKexVQNBt8Bu8g3808mTwNE4GH1PrG5W1u','790275710','abobodshanab68@gmail.com','عبدالحميد','ابو شنب','2024-03-10 10:09:53',NULL,'inactive',NULL,NULL,'King Abdullah II St 393, Amman, Jordan','dThXwbdZRuaWfWRACBAXWZ:APA91bG2kfvJBQETal1sc_i-hIT6spie9OQQjEhA22Xh8MqA86n6NvVMPqTNpNoHMKOrZdraYlTgPnUzQZWrSYhLabuNrxVcubp59xTnEMFYoP-GFcwX6dSIogVE0StG0AqrRbxvXWR-',50,'Amman Governorate',31.967118,35.842347,'enabled',NULL,NULL),(225,'vendor','$2y$10$SjOWForPjgRH6We9OahKEOha3dzgG/fuU3geHWdbrLONtVvxT9c/6','791259495','fadealabade120@gmail.com','فادي','سليمان','2024-03-10 10:51:05',NULL,'inactive',NULL,NULL,'WRQF+HR Amman, Jordan','d3KXhp88QX-bhL24rrcaVJ:APA91bF11IU-phCWFkQupSxhmOKub2BU32NNXYYODnfKbje0yOV2vs3_4OWVrPEZYKQyhPyrDQNuV0dboTBCfhX-zYbxdRv7jBjQKEHjGj2THNHyp2MOaxYnTUw7zGTA2gTOyaV4nvHG',10,'Amman Governorate',31.938880,35.824550,'enabled',NULL,NULL),(226,'vendor','$2y$10$eVfmzgTuEuQBpwau0EiWMufDeTrJI1RdV.OsxaNSx4nClyLYS8MEW','776587967','ghha97449@gmail.com','محمد','المغاربة','2024-03-10 11:04:07',NULL,'inactive',NULL,NULL,'WRWJ+JMP, Amman, Jordan','eLrkBnetS3OdQ6kUl7uNKO:APA91bFXg2y6BFJG2nR6FD1cK6KKIza3CYAJ77Ze8lYvYSIKph_87DQclAepoRwDwiEkcL9zCIuK_sJMuBlbJyens2fOsEJa8r6RnWtldcGlPjLzWi6NqGqGHlLf9esBEqefyqiczu6Z',10,'Amman Governorate',31.946534,35.831716,'enabled',NULL,NULL),(227,'vendor','$2y$10$tFpA28OYxHSWeWHQNVq9tedgfJtMAflvFSCKsRSaqxSoAykJ3XWla','797655987','hhhyyyyfc@gmail.com','احمد','العبادي','2024-03-10 11:11:47',NULL,'active',NULL,NULL,'منطقة مرج الحمام،، WR42+4F8, Amman, Jordan','fy__2nmxQ6uvj8fvSG1Jum:APA91bE-COpcwgUW_LHd_-gHsfiMfE6IPYPX-MaTdUhLqSw8g7V74G6TUsFPIKoaUzosx1ePkfbD8z-Up7_p9YFDcUF2yY6U2D0Ak7GBxl4Jf70NBjqWjBO2pmuZ3XHTMbB_sRoGPTYO',10,'Amman Governorate',31.905514,35.800552,'enabled',NULL,NULL),(228,'vendor','$2y$10$oa69hh8mXTorMGXk2A6PQupKUNAieiYGERSlKnss5cApANRZT0OBe','790383955','mhmadajam62@gmail.com','محمد','عجمي','2024-03-10 11:12:44',NULL,'inactive',NULL,NULL,'Amir Ben Malek St. 114, Amman, Jordan','f-G5STIYQpqOZCIg9r7NOf:APA91bEbKE7H150OTWzMsEEZWBy_JfmKqW_YLhOg6yjjFSsCs_LhkkZg0nv_ptlcGUI54RN9Ula0G2tWHndvBvf_511hNeiB9VHRoxbMK3vc772oHgqu8ZgY9zXkepHrIX9qmrq0mfT-',3,'Amman Governorate',31.995907,35.849020,'enabled',NULL,NULL),(229,'vendor','$2y$10$fH/GWaWO7N5.mUKbKDZoAOQBilycS06thl3ypssQonh8yV8KaLjLa','780240380','grgsh7@gmail.com','حسام','قرقش','2024-03-10 11:23:55',NULL,'active',NULL,NULL,'XWHM+JQ5, Al-Quradhi St., Amman, Jordan','cryMMiI2TTiDR9rwmVxKfK:APA91bEOtY-KeSRY-9pujaxKCch54FJPfLtbUzdWElPXr3TWaiUBc1qTqFRhCRzym3hblnW5Hw4_frGAK4kVoaFztjbS8R9gOs3ReA93vaqrvuWQMWM9MREJvv7VmQBYUoPE_LHVbQb1',50,'Amman Governorate',31.978508,35.934383,'enabled',NULL,NULL),(230,'vendor','$2y$10$Q0jveOqeMWKqznLkAQXgMOb1QD0suIRaISxf.PLXv07muO920Twn.','778571287','ahmadalslehat1998@gmail.com','احمد','سليحات','2024-03-10 11:33:17',NULL,'inactive',NULL,NULL,'XVWF+H6W, Amman, Jordan','c4LQ-ENWQZyXHaII-XGew6:APA91bGczt9S3fhNY02nsOPT-ItHDtHryincSoSjbS7RDYnmiQ-vmpPXYNl58RyiHjgl8cXesZU5UDhe9KOjbUsHXoaEJ60yW5mHu8-1Jn0ZAD83DI2uSzbugdJcrc2jK-miJSGiePNL',8,'Amman Governorate',31.996670,35.873011,'enabled',NULL,NULL),(231,'vendor','$2y$10$4n77Gyb0U8uHR6/lIl75n.7qe8wyq6stNY5PQVjndaLJTnnmguVpO','799501852','saadalsalhi43@gmail.com','سعد','الصالحي','2024-03-10 12:35:56',NULL,'active',25699,'2024-07-28 07:58:01','XRJX+83P, Amman, Jordan','cbMOk1sTRueuteSWGHFNfK:APA91bE58ipRuTUZryUelRWbfei2xUlz43FzRYxuK9X5bWuexj1PWNxjo7480plaHo6RovjWKkl3p_ipOj-Fxd0BO4I2Wip3nZaa_nq13OFHV17cUoRswQfIdkaBEyIpqJNGUADVJgbg',46,'Amman Governorate',31.981006,35.847539,'enabled','1.0.15','android'),(232,'vendor','$2y$10$zMnGIrx9P4JJ5oMUZtyBM.PoLDzB6QcAF.6s5hrBqHwdizZyXaP/i','788364791','Ayman1ahmad2.b@gmail.com ','ايمن','برغش','2024-03-10 13:33:15',NULL,'inactive',NULL,NULL,'XX2H+FVC, Amman, Jordan','fGy7SpwVSVCxnmUsrw-tzN:APA91bGgOdB8pPS1yTgIXH_K04XS7mDZNi5ZZ6u9tG6H_vdJ7K-3IKNVweQOFY0pYgQwB6sWasvgT1k70-8fvqDqYaFMQbgF1ufVbWEbcX_xibOdfbiVAmJtBXq6ljMW_rUCjcgMiyNo',5,'Amman Governorate',31.951043,35.980195,'enabled',NULL,NULL),(233,'vendor','$2y$10$eR9uXB8y6bypG//fV8nUg.6uuFCq9CjgjPfTyRcMX8t.SPJwql6Ea','785634382','ayadabwslb45@gmail.com','اياد','أبو صلب','2024-03-11 07:40:43',NULL,'inactive',NULL,NULL,'Queen Rania St 376, Amman, Jordan','cyQgDKn8Qw6Jb4iRLZTZK7:APA91bH7hewG9mvDWGI5AjeA2GJMBGwzWDa896xR8NWmwDLBqi2-W8m_swvkWh9Twmgu2RyLK6yrU3uwaHsdw0XXPdwLqGa2e8iHdt0QkgvouCLWFw0rU0NJ6qZAol4yj8MnmWAQfWOH',10,'Amman Governorate',32.024753,35.852997,'disabled',NULL,NULL),(234,'vendor','$2y$10$szGeDfS8hgpw2ReMCaDJJeqW8.w.dFs1xcHx63EjnoBP6BLu3WxY.','795996882','laithhussie@gmail.com','ليث','حسين','2024-03-11 09:32:29',NULL,'inactive',NULL,NULL,'Al-Madina Al-Monawara St 210, Amman, Jordan','fbUamaGtR5y-OhRHuAUCwC:APA91bFJiPEW48ZiFXsMj5-5JyCM-FrptHX2dVditQNpCfbHHsV0q01ARiYOzuWlIGVayL9LDoXIgEcMNulMQt5oB5jv4zZAgayezzuGPCJGQO9Y-5n3UEiIL8trwFp7biKgg8iv7XfG',0,'Amman Governorate',31.989748,35.868037,'enabled','1.0.15','android'),(235,'vendor','$2y$10$gBt4W8UV2HITZXq.xt4Xt.GYsGhGatiGCo3ZY0jIvjBqZpGyHP96m','780151617','jarrahmoath6@gmail.com','moath','jarrah','2024-03-11 10:01:30',NULL,'inactive',NULL,NULL,'2RXH+4H, Safut, Jordan','cs_0Nie-SNuaPS5qUFInRy:APA91bGJB9nrudOcC52yGv1ci1x56TbdyB-IniFZ63w8OJHJSBKJV5rgXQEa-eYKFKx6kKk0c6__55ZSVBYlJW6CX-KKrNaqXAOt9fLtnsRHVHwCIK3oc-nJmdIJKCN8SJXq8YP3FVaB',0,'Balqa Governorate',32.048131,35.828685,'enabled',NULL,NULL),(236,'vendor','$2y$10$.ZftzyvH/ItgouDTUT1rP.wGfqB9UKaDQ2BdbeDQKkcPH6cwn95mm','799414150','alblbieseo@gmail.com','عمر','البلبيسي','2024-03-11 10:08:07',NULL,'active',NULL,NULL,'XWXX+JM2, An-Nahdah St., Amman, Jordan','d2eDLrVmRs6inih12gIDqz:APA91bGnpVdS3n-1kf0r1DjYIjCdy0LNjtwz3RjyKDDKVXpL0xkqeUFJg0fZ5Dt2guiQFZ-Xger9TnAVG2CVBUBhp7b0keZjz5VnfACc_MLnKcn0Uq0yUimpeMOGjb-6Pba6hcaixbUx',5,'Amman Governorate',31.998837,35.949172,'enabled',NULL,NULL),(237,'vendor','$2y$10$wKsNZealfNbco1vs/VTRY.CFqz..5kQWMo090plKwOyTW6ckly5hO','780907191','mohammadalaa.2.m@gmail.com ','محمد','البحيصي','2024-03-11 10:20:29',NULL,'inactive',NULL,NULL,'Damascus St. 64, Amman, Jordan','d2Vj0Se9Rnyarf4ZS0e9RV:APA91bGS_XSme0FaazieBS7gXZLryEpEUg4WV4VsTTQrfi0E0CHOlvtONr1F9-V_nL_lGf8YTDQNxuUc29xh-g2OFvjVF38IB4JPIBQI4vIDhSW5KrvJ9eqEl6QgGe0LGR8D9d0EMx5m',0,'Amman Governorate',31.943241,35.901452,'enabled',NULL,NULL),(238,'vendor','$2y$10$Et.9wX6MgvB0cExkfeAkMuQnhA5po/ugzRk8QwxEu1rmOwDd9NSPC','795221398','alqtawiahmd95@gmail.com ','احمد','القطاوي','2024-03-11 10:34:07',NULL,'inactive',NULL,NULL,'Damascus St. 64, Amman, Jordan','dSFqAlTmS7KNWGe2G-ekQE:APA91bEEQvkzB-kjdsEPwc9Ptwq6j4ZzJmwpZ8K316iK_TKveezdvQsQc_eV8kxMO08R2dyZqSP8bMgMOa9fD0cctLgOF7MsubcLah33Qdm97cYXBa8Ik-pc731yhtZ5KiZrH7wcvcoR',0,'Amman Governorate',31.943255,35.901455,'enabled',NULL,NULL),(239,'vendor','$2y$10$fjAb7ImRhYD2rdScxuk6X.7rNZXblqUAvIjAR/gJAgQjXFrKXXTp6','799531138','alslyhatmnswr@gmail.com ','منصور','صليحات','2024-03-11 10:42:13',NULL,'active',NULL,NULL,'العاصمة عمان، Amman, Jordan','e3SBlr_uTIKhJPjKHJP7NG:APA91bGte3xwNKU3NTlNpZ3ymVzbu5mWwGGVKWr-0hMCLsNwUqtOpMobNnpcDpyjgEa54YhxjXzijWjVfeorJGcSq36n3JuSh5cnXtQFNzJarAmRVy050_KT9W0f0NMGHffoP9jmYAz_',50,'Amman Governorate',31.958455,35.870326,'enabled',NULL,NULL),(240,'vendor','$2y$10$0jxfD5jG3WygPm9NAAby3ezfFcv6t5tP.ZE9qIKtv1NhL.8GV5fuq','795034237','morad.alabady@yahoo.com ','مراد ','الرحامنة','2024-03-12 08:34:01',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 166, Amman, Jordan','cgutgJAhSZSfMpKfVKbk6O:APA91bGukXy2uvEdvh4TzCMdBlOTk0HbW5_1OTWDm-WwFlnP0Q3gkBmQHjuBDelGRe-4_wbL-Slt9NrPxONzjFXozAT1adbubTQ1PZx9b9V_0Tt4Q2cw0lzw_ocdhiGOt7zi_5YJ76jI',3,'Amman Governorate',31.991788,35.867010,'enabled',NULL,NULL),(241,'vendor','$2y$10$l0quCg1CXR04mZ26IrGN0uOoXa7GSXvBN7kmkl1mBrKXjBcg1KS8W','796303002','aboodawrtane115@gmail.com','عبدالله','سعيد','2024-03-12 09:10:00',NULL,'active',NULL,NULL,'البيادر،، XR2F+VV5, Amman, Jordan','en5BIYQDQPmSWdM-kmWnT-:APA91bFiglmJSG4133pk83n2IpK9gLYg6eId5fJLfKFoOw76vjoYwLdLIJULENAaqCKHpYkkwF7WayGujvwfAzKKAtx6qDKrYcdj17L265wIpvTNKK-NGs5TjWeqFza618_S0BokSVBt',5,'Amman Governorate',-25.877451,25.652932,'enabled','1.0.15','android'),(242,'vendor','$2y$10$TJ4Lk.8Tf9jbexlMKHy9euvCGhIvN0kvSaZhW.USJ8Z1VxhDorjbq','787711494','Ahmed.cat23@yahoo.com ','احمد','البس','2024-03-12 09:37:53',NULL,'active',NULL,NULL,'As-Senaah St. 2, Amman, Jordan','d1mv6qmLT_ifzeBP5GNLXS:APA91bEWpyjp6M0Vegreem6Lkwb8-Ssk5Ai5j9g9Fi3KaRdFX1M3lX_2NF5hw2d5sGGHiL0xjc1HmIVCzP-U93mnZ1JAlDrJL1becgA5cNgFQNuqIk_zhi0Sfb0NXBjQTj92vKX2bLsO',5,'Amman Governorate',31.935398,35.817327,'enabled',NULL,NULL),(243,'vendor','$2y$10$rYv9wNRrNLAGBSQUM3PnXu8Tx4.e2en8xqXCRM9PdNevQrL0JMmNi','777576785','druhs568tr3@gmail.com ','علي','حمودة','2024-03-12 10:24:56',NULL,'inactive',NULL,NULL,'WRWJ+QMF, Youssef Tawghaj St., Amman, Jordan','fFcdNuv6T7egi8JyqmiGgD:APA91bEtMl5aUfbnjzUT14GisQbJHt6tttQ1ZS0DmWmNlDEedtmIeDe7-CpbfvBiNRI_lmMIEnfufJHju3_q8uYRDuJRLUCkyzB4yc3AgKHiYDnEYZXnGoZp-dKTGJuUagCRyjfqV-e7',0,'Amman Governorate',31.947009,35.831650,'disabled',NULL,NULL),(244,'vendor','$2y$10$5BTkVzhGNBZxcQdoB1KGW.fYvKezxGc1nDVTmU8FRH9ftUqSh5Nvi','796244374','ddaalk52@gmail.com','مصطفى','خاطر','2024-03-12 10:34:57',NULL,'active',NULL,NULL,'XW5Q+89J, Dulaywan Al-Majali St., Amman, Jordan','dQwp97rVTiajwuqlaGZ9DK:APA91bEY0Uub3d8_557vFZO_UfV4MIdn674-Lt3xjAm-UmYGlx0xYdi3cOyczIaG2jEMcCbASMiKRcYeRfWa8PrssNSKctOWOP4NyBjzGqFL8fiH72Re4ktnz6UGALdjFUzlrpAgsoUv',50,'Amman Governorate',31.958285,35.937764,'enabled',NULL,NULL),(245,'vendor','$2y$10$AUwsCNnTV0HCc4Pf478zUu8vOXll9bQ9nAkjOJRsgaQBB776eLpJy','797379366','mwbaylalashbal190@gmail.com','محمود','الميمي','2024-03-12 11:28:08',NULL,'inactive',NULL,NULL,'WX89+C8G, Amman, Jordan','dGME5DkcSHek2Ej6iy8uuG:APA91bGHQIQtOnuIG0DQrYxO4FmrlioZLsMZ8xPtSSygSpiwz92YDY5zR2CXzlRA8_ttvlCp6JacS5YRo3-PYmYeaSE2lUReITgRbtgFFX_pIJY1646AhG5Y0DYXEREkTu5NEvRr__lX',50,'Amman Governorate',31.917199,35.968475,'enabled',NULL,NULL),(246,'vendor','$2y$10$NwlXqePWKUr4xJtPR/YU..Nro99np3EDeaLanpBKbA2WlluEMBYS6','796091356',' ywsfalflwjy29#hmsil.com','عرفات','القنيني','2024-03-12 12:06:30',NULL,'inactive',NULL,NULL,'ش. أبو الحسن السلمي، عمّان،، VW7H+FM9, Amman, Jordan','dutebYsHTL-FCMj-Xyhgk_:APA91bFgcl_Ve8QM74K6OBb3ktg5C6CUdD5peup7-kUKibIWKpmXHNcrcDU8HlB-TJSUEcQi4Fxm2aOb_A8S6mkbkquq6ga5HTz6Q9jDOfEugeXL57bOXeSOi3KowBpmrEeLprhKzhF0',50,'Amman Governorate',31.863492,35.928393,'enabled',NULL,NULL),(247,'customer','$2y$10$1memU5YmT2nNCjy8DHxhl.Ofj08VodmlfheJzeh8VJzUN5hn9Co4q','796045904','kordehmohammed@gmail.com','Mohammad','Kurdieh','2024-03-12 13:11:33',NULL,'inactive',NULL,NULL,'Tabarbour amman, عمّان، Jordan','cFiYtcLwdUmli09wrmP4HT:APA91bG0wCFMQ6XVgY71HrVU9PyPP8hi7BNIqS3X48FO-E-Go7uo4b7o0IaJcNZ2c2PK8TmjI35OaDnQdAfpNbjM5ySJrLi66WtbuS2Zg332ewH6G_W-3X3MVUAmNmC0nPXapNCEFmSW',NULL,'محافظة العاصمة',32.009159,35.952156,'enabled',NULL,NULL),(248,'customer','$2y$10$guDz8iUeZHG0XlD504eG4OIOiSAtiAtUy7PWHqjg0maTDhTqn/oPi','796885362','raghad.daher.33@gmail.com','raghad','daher','2024-03-13 07:29:51',NULL,'inactive',NULL,NULL,'XVQC+XH4, Amman, Jordan','eokvoGmQ409IjJB6ZjLQ1U:APA91bECBmhspHlSLLIXZZz9Ou5Cmwgj8vKzA5GSxeS3Z7zG3SHpus0c8Dx47qXMyeFpcKsLlgex26Uob7zLJNNWfA6SJG1oXxr6Vf8VRWa89Kt-TL3-4F-zFav34cj_qTA0--0_005e',NULL,'Amman Governorate',31.989939,35.871478,'enabled',NULL,NULL),(249,'customer','$2y$10$HI6mHJUtfzlfdkLqjk8wb.PCj6MvMk4czEWFrwPBdmKFUHyUmC2nq','799795313','amerayyad00@yahoo.com','Amer','Ayyad','2024-03-13 08:14:08',NULL,'inactive',NULL,NULL,'WR6H+5WJ, Amman, Jordan','e0gc8ch5OkK8pPLDX4njWR:APA91bHoc017ABfEbTjRtLUYct_mPFonMdDgL_AhDe2xj15V1deUSza-eFRaksCoBcvhMoEbF4c3pRkTHiQ9EJElQ0lDFZOdowJzUnA97sqVJp8TgwGrR_OrZjzldkROn-74wnLGRjFO',NULL,'Amman Governorate',31.911250,35.828505,'enabled',NULL,NULL),(250,'vendor','$2y$10$6W43naeGAkZRPw5nRtcmdug5PoxwS7a5MA7YzKY6gr00KBaUqLOVu','798127798','amerdweik7@gmail.com ','عامر','دويك','2024-03-13 08:21:27',NULL,'inactive',54548,'2024-05-14 09:55:46','XVQC+PXF, Amman, Jordan','eN90OTnXRYiSbE5j00udIo:APA91bGnCWf_wPeVxNDuZKDP_IGV5Z6PRvtvEZNZfvTYM1pr6BTF6c1p4YEgIRxhfwM1xptq3G628uYaO_6Nku_XVUOKAMBg7z2e_Xg9Kf0LBT4OQ676yB0Ub6h8tJYsi90Co9bCixgm',35,'Amman Governorate',31.986307,35.867613,'enabled',NULL,NULL),(251,'vendor','$2y$10$7nXQbJs39ShwIfJrZrDbQOuEfnLuQFgebowuqSYpdBAuQWSF/YFaW','782303077','pickum.sales76@gmail.com','sales','PICKUM ','2024-03-13 09:34:01',NULL,'inactive',NULL,NULL,'2Q8W+P2, Fuheis, Jordan','cAzXssffTs6_aJLrT0dJL-:APA91bEnRqfhfip4LzcOSIxT1VVsH2gIHv4J7D06wMHQaGtOzqNHOsjq5JcMEzkopjt3zLye5tkDQSEtSNexTBFWZkefXzBDEhMuh61xbnEJLhiEeJe3IwpiyC6-vxfGp-8eV0fqc0k8',-2.5,'Balqa Governorate',32.016621,35.794461,'enabled','1.0.15','android'),(252,'customer','$2y$10$M.bXYjO0B2QUtT3et3yJxOUjq8fgaocfEx.Mpz.R1EZRJFVqYS02i','782303072','lyannjah502@gmail.com','نانا','عوض','2024-03-13 09:45:45',NULL,'inactive',NULL,NULL,'XRMQ+875, Al-Aayan St., Amman, Jordan','fF88rrXAg0VTlaOTB-KMTQ:APA91bGQXxwwU5D3hIY_JpyBIyu-BH8u6JgcIwVCpmGu7wABvuVSLJ73FUv5C0RRFTgpU1grPGQ7pMFeEuyF_53eQKmyqXWKO9aOvlfzx-Dlwb5RTLxFaxP1q_zKL2SB9tgyZEUA7eao',NULL,'Amman Governorate',31.983463,35.838252,'enabled','1.0.13','ios'),(253,'customer','$2y$10$SxAWOvMl/NqdXwQ0Z4vdT.WSG36DC5daAvtDqswZ0idtLoVp4b5Qa','782303074','alijar112@gmail.com','علي','جرار','2024-03-13 10:03:20',NULL,'inactive',55128,'2024-06-09 11:03:48','Wasfi At-Tall St. 18, Amman, Jordan','dFuM_MRVRWCnUksg_qft9n:APA91bFoP1sqCMcZCAYIayGyVeZyTQg71ZR3AE2EYQJlGo5JPmnm8kvxv2gmAKWGvkxnzHVPQFsgfAnmbsHwF8dVsILYtU_xMv1nOevEVxudypL6Zv3j0YCctXuuaZ1UG5VoRS1AfQIR',NULL,'Amman Governorate',31.989841,35.871400,'enabled','1.0.10',NULL),(254,'vendor','$2y$10$cbSIvgwfTN.5ywsEz9MrNejZSE.XO6.5BoauOdg7Fp4UsvVp8uv.W','788856179','ahmedatteat257@gmail.com','احمد','عطيات','2024-03-13 10:36:36',NULL,'active',NULL,NULL,'VVQV+94Q, Amman, Jordan','e3DmsX2TQOyyu-3lB4mYx8:APA91bG0sVPoqz3Gdx3mqUh8RxieqJmIt5Rt-ttY-v4BuTasCH-e5bITLSk6xmMeEJa4L8Dpg-VerO3doKiZUit1dl7NxFqbSzdC7gnMxPY49gFlGlpWpvoMukn66iNwX9yssunBDJ-j',5,'Amman Governorate',31.887879,35.892767,'enabled',NULL,NULL),(255,'vendor','$2y$10$VoD3VT3XKe8xItsc9BclZedZc/tjtlXr4ZOOxYlztkkUc2bOkN2iK','796523738','ramyabwsnwbr@gmail.com','رامي','جميل','2024-03-13 10:53:25',NULL,'active',60244,'2024-06-07 17:44:04','Al-Arab St. 1, Amman, Jordan','f_zf2AxYStebMkb2PvqlkH:APA91bH0w1MDqa6mO6LcPosKGeIk_R3Bk1PhpAQdgqgx_KrBLZ4j7DMSuVjj8DsuQ9ZXuyx9XnUZijs41kBKbsGbVSG7WDv4-gpb7NkKWeVORlIssQ2isvXcteVY7E4sBf1Dn7ftEdZ2',15,'Amman Governorate',32.050142,35.885473,'enabled','1.0.15','android'),(256,'vendor','$2y$10$qYzjLK7D3E1s19kJGSA4reXM2BJDVBfcjSaJ91u9JZoLE/AVPriHa','796507993','alishanab95@gmail.com','علي','ابو شنب','2024-03-13 11:32:12',NULL,'inactive',NULL,NULL,'WW8V+9GP, Haram Ben Malhan St., Amman, Jordan','eLHX317aRjyHO2MKfzPZ1P:APA91bHHW_4MMKvvULN4SlpIcWaaA5HbqHz0jUsPNlqLPpVr1bFJ1ZAnWUVLTdWLCYEZ6PPIoTafG_kyGP5HoO8AKHEgM49nVvyvWXUX18UQ9IKtcMH4XGCsn0MGLk6UskJI6c7rB4zu',50,'Amman Governorate',31.915969,35.943506,'enabled','1.0.15','android'),(257,'vendor','$2y$10$CeaDFmHXlStqlksDvdiRU.pjnuYiW5ChaihrV1E6WFb69MmPi1S.a','791159646','hmdyabwshqra@gmail.com',' حمدي','قرقش','2024-03-13 12:03:21',NULL,'inactive',NULL,NULL,'WWGW+WXJ, Amman, Jordan','d3bTZOboSxmI5irIoVuLsl:APA91bG1lMsQYGtLBveQbKCkjKDiJ6FFiXG-5MGttdAFf1u-r9S80eJughkeFRobGfnbH8mqklJRDZ4PpYjQ3RfZjM4dTg2URJcRzynBz7SAdwilW6-ffmb5eH2M5jsQ1Tneg2HXs-IH',50,'Amman Governorate',31.927435,35.947234,'enabled',NULL,NULL),(258,'vendor','$2y$10$IZ2y0xOa8cEfobIAEnW07.xorOsYZiKnR2GzK31/2l6HZ1cuJSMK2','786994929','alkheebabdullah@gmail.com','عبدالله','الخطيب','2024-03-13 12:14:32',NULL,'inactive',NULL,NULL,'شارع الرئيسي الدولي الشارع الرئيسي صافوط صويلح, Jordan','d9_NFm-OTZOrx-1tkv6rX3:APA91bFFxFFuxcm5x56RtwIw1RhytYT9-t2nQhUjpBq7ELTHatws5NOW_tTdlCpG2vqDb7cH2Dp0isBSPtBMbqMVGerudwyyKJStyFo1-yAycPX3h9vfnvORG9fSYHmlW-aC6nNPg9iV',5,'Balqa Governorate',32.042004,35.836834,'disabled','1.0.15','android'),(259,'vendor','$2y$10$oZ75MCYAb9XzxA5ZFIkPc.k6yJJPUoaul29SGn27B1v5122z5rz8W','781736994','mmdoaa2005@gmail.com','دعاء','الصنابره','2024-03-13 16:22:16',NULL,'inactive',NULL,NULL,'2RGW+M25, Amman, Jordan','fAsB3GmRS5GiMjfPHaibNm:APA91bHTeX3KdtMhgKs0TizhPCft2USThym3T97BRY_rNNjTXqzdS1wEkw1bDq0n_9OuBvcgxYJYV7f4FOkMGP1EwohzRdzHjyurQ5N7dIfO2TQ0d6R-UR68jInS4Sp5i24T_Q3mj9aQ',0,'Amman Governorate',32.026400,35.844149,'disabled',NULL,NULL),(260,'customer','$2y$10$xaz6r3f.2lt2imsXJEuTWuSVv/oXtJnF9agUudySNY4m1GSfyHFgG','795252579','Raad.naffaa@gmail.com','raad','naffaa','2024-03-13 16:38:45',NULL,'inactive',NULL,NULL,'2Q8W+P2, Fuheis, Jordan','cc9SN97kS_e4vWZyDSh0iG:APA91bFehBcNAsrcnPPSBNWmS2d8Bquc73nHuPKnidZFRiWvS9evkDDDrgamsnityOMRkJB6sPIGhegToTHqM0GCC8z-sFrT4E-7H2QwARITf6FfRByh9Ll7qOICynmwfMfdrkEZicus',NULL,'Balqa Governorate',32.016672,35.794398,'enabled',NULL,NULL),(261,'customer','$2y$10$Jk/r.lKVe86f1RrZFKz25enrk1W9yHxWqX8qHXOSj3wL1iGspb5Am','796688999','Osama-abuhamda@hotmail.com','osama','Abo hamdeh','2024-03-13 18:46:21',NULL,'inactive',NULL,NULL,'2W3P+9JC, Tarek St., Amman, Jordan','ctFbz7R7ZEc4mTrKhBQbUN:APA91bGXdMm7mZLtzJO0x-XQIF7BNQeR6p4TClTwCWwmQ9KFeVOiCpoYeBbHqTUVXk2Hmmo0G6zoE1yKt8SheLprg-k0CTX3uxRXNTUO5kao7BM9zmNI0CTz85PnbhG2u3AaI_dtihj1',NULL,'Amman Governorate',32.003377,35.936495,'enabled','1.0.13','ios'),(262,'vendor','$2y$10$wWuIoxQPIaqPqcUOxRu4q.EJ3stOH8GrJOqEBCdXfm81cQK1XuhN6','780847880','aliaboadam49@gmail.com','علي','الحاج','2024-03-14 07:57:24',NULL,'inactive',NULL,NULL,'Al-Imam Al-Bukhari St. 4, Amman, Jordan','fXB0DBUjSxCO8hDxlt2g8L:APA91bEn_zfn7br13rDFGfWuCT8-qG5cPOZEeOb--U5EsePN2rIaZJh5sZKo98SktAZehJiBv6WYMlLvtfIEe2doTyR9MEMhRnoFNZj6QSDceIlrkpZv-5i4FOmEi9rVxwaM9U9U0ecI',0,'Amman Governorate',31.940824,35.947172,'enabled',NULL,NULL),(263,'vendor','$2y$10$7Z8tGrCZ1uK.dQggoSvNVu.8ZzZGOLwvYPvM/ycWONxlay7S4HOTu','790676433','omar.88.ahmad@gmail.com','عمر','علي','2024-03-14 08:39:21',NULL,'inactive',NULL,NULL,'X2R5+H3 Amman, Jordan','e6Dxm5EAQryo-wlRc7bnoV:APA91bHx33P0vlA3oAOifKySxwMIBtRN20U1J6bzxLETq51GuvFupK-_vGN_0BLv9pS0S_c6G6hZ9BHgRJ4BOixIhXdExa4BFaVv2BSq8ySCEitSe6GGr1kzEbGZ3ldamlMRTE58CSTP',5,'Amman Governorate',31.991439,36.007729,'enabled','1.0.15','android'),(264,'vendor','$2y$10$fhKwBu3ZSlAN1XH9NQd2gugx/vY8GSxbC4pWCys/3vBaO69MTSFJm','797037162','raed.alakdt@gmail.com','رعد','رائد','2024-03-14 08:41:37',NULL,'inactive',NULL,NULL,'QXVG+WR Amman, Jordan','egWOuCnFRNiuQxVnMEKLGY:APA91bFjDKckqOOhuCgkpk_jSut-CmcQGuaxL7e1S6uMPNaw1j4WmlKgISa3cTJifJL0l6uaGLth9bfQC95cOkla92rQtOQObK3POkxqVjPmdaf0HiDhPW8x-qdXhs1gZa_GTY7a7ZKQ',5,'Amman Governorate',31.794825,35.977073,'enabled',NULL,NULL),(265,'vendor','$2y$10$pmGU3EbP6a042LYKfUN78uFIGzUmjAsl3eahL5DOmuS24LTpovUVO','781503088','alhymwnyalhymwny@gmail.com','زياد','الهيموني','2024-03-14 08:54:35',NULL,'inactive',59816,'2024-07-17 12:45:59','VXRF+X6M, Amman, Jordan','dXkbVh-dQiSXS1FGLNNruC:APA91bFhRPstEYIVwl6ZrDcQSLW2s-oD5bV9mJ1KYLayUVdijeqdyYB57HlB8s_LJe5qCO_Hr1lcFxczEVhK4oNQB1n2O4bCP94zyVkvfvOkvGGX-0Oqp8lhnc_MMGiM9Dn5ovyy96O_',50,'Amman Governorate',31.892527,35.973082,'enabled',NULL,NULL),(266,'vendor','$2y$10$TwOg.Ctg2nWXb3bu68anM.2bUJ07XCTbFsTWa9R/PJLZaTe/h4iVm','799695920','shhdbdbdvdvdv@gmail.com','محمد','صبري','2024-03-14 08:57:25',NULL,'inactive',NULL,NULL,'XX6M+V56, Amman, Jordan','eU8OZQPfS8iW2RvAlsDiTZ:APA91bGY4Uu7CH_xil9jDFAzS22essUW_Sd1GqpbZsThthXIpkfpyf7JWYqkoFzhRemqGvvPuNJUk97wuoGlJz4cK7kcw-xA-AQkzLQb-cQgbBoXMuB_Mmftrco6uVe935M-31jx6IHw',5,'Amman Governorate',31.962297,35.982764,'enabled',NULL,NULL),(267,'vendor','$2y$10$TV2CuRy0GL3ribIOAU3OPO6SetyIYXrtF3JiXdOXTypzh7AR1UCYy','790481971','huseinyousef1234@yahoo.com','حسين','يوسف','2024-03-14 09:27:27',NULL,'inactive',NULL,NULL,'Prince Faisal street Amman, Amman, Jordan','cBI1qjsZQr-7WRhCxoYH5U:APA91bFR0DRy5D1yqsgQqzNUymg6Y19kd4V1E4p1_fCCSoa9RqMBnkZXJo02JplEs8NaRJldQPnIPKtjQJ8T_dmrT69Q6sBwl0jtmz2KU7qIZ7uifnZwl_5vGqQ23x3_17c44idMVlYR',5,'Amman Governorate',31.990312,35.976680,'enabled','1.0.15','android'),(268,'vendor','$2y$10$vnu.Y7wN0vVDBVTfCw24guzXqWHPIRq7FZRcOIpVgyFjrfH7aJ4hu','798720093','osama.mesleh56@gmail.com','اسامة','مصلح','2024-03-14 09:32:15',NULL,'active',NULL,NULL,'VV56+F54, Amman, Jordan','dvZXoZTuSeGfZE_Z3eaozm:APA91bGnMK9elGT2GQda8DApKtsoo2V94qBeWU4d0r-jLY1z5ZzMk5J81fl7HjasMCB0Eq3V0LVF5sA5XfAeYtDVb7gY_GavjoEG5ipvW23WRorHFESYYxl6LEKZB3Ab7TLSqO-MTLYj',5,'Amman Governorate',31.858745,35.860855,'enabled','1.0.15','android'),(269,'vendor','$2y$10$3zHL5cKCGLvoWQLJwKixueT4JLdtrpx3eQ54njSPxKwEW9s4Gs3jC','796033158','wesamallala70@gmail.com','وسام','بدر','2024-03-14 10:32:01',NULL,'inactive',NULL,NULL,'XXHG+997, Mahmoud Al-Ghezawi St., Amman, Jordan','cgxidVCtQyibX-vq29dLcZ:APA91bH6l1_VNZhcLOAt-YQPYooUy7dr-E6h_o0AtMdTrLiDd-RVXpOKqgSlU8qXYxXketIo4cx2Sv9sCFC92Ck_-a25wDwObfrQ7d103Yntf_6XKKbwjxrxy1pO69_6Qh1XCnULNoyz',5,'Amman Governorate',31.978663,35.976207,'enabled',NULL,NULL),(270,'vendor','$2y$10$7JeS8OgPgTkzewouHzjCy.MFcmTYwoXk74p0o6JSZ1ven.QL1LN6y','790184733','shgd6269@gmail.com','منذر','محمود','2024-03-14 10:40:37',NULL,'inactive',NULL,NULL,'Prince Faisal street Amman, Amman, Jordan','esmPEFTZTp6cJAThBPe6wB:APA91bEPiz7TUdZJejK0YIQeV1t7IP7KJ4LsD9NoI5_Whl-4wfBnOljBcFVaXqAGoptHj1B5JWYyyoECWORoijiZqRrYbuKclb7N0WamBNv9EIB49g7VnZEkrlM94xP_55MAYIivVNwT',5,'Amman Governorate',31.990289,35.976671,'enabled',NULL,NULL),(271,'vendor','$2y$10$OfO84RPkH6XzxnBCnKptNOps.16S/hrUngBrg3ZrYzDDjk.Yu18gK','785839524','alobadeieyousseif@gmal.com','يوسف','الخطيب','2024-03-14 10:45:12',NULL,'inactive',NULL,NULL,'2X27+V77, Amman, Jordan','fVGsJdxmTWK_93jnSEoQD9:APA91bGYxXAXREvMct-YaCQAiit8b3XSBehVdl_ZMYlpK9Rtmkf93ss4g5mcEOFkgo-3BocD2f_oijxdxFoYQLeNjl0otA1M_04wjQA-cUjHNa47RRX8X2US8qEz9i6jhFZDBsAGAObm',5,'Amman Governorate',32.002209,35.963193,'enabled',NULL,NULL),(272,'customer','$2y$10$NUn7nkMRbTSGGsXyXLcdFeewaTWL0IDNqMHhS/JJWLajcXCLaSFPq','798400581','mhmdlyna005@gmail.com','  محمد','عليان','2024-03-14 16:39:47',NULL,'inactive',73016,'2024-07-05 18:03:28','3R6M+937, Ein Al-Basha, Jordan','e1gnkTs9Ra-BAhGZLbVCvp:APA91bHiiktquLzpTKA4ksSCNEuf3cuosS5Ot73vAYALxvmwvCJCcgGYTbhFrniTAHQOnRbnTSdDk6KdJwBmAKHo2r8Th1pflpCcKA2GACsN1dWzwFy2jHuJg1jKy-a4NZpyk0xXt7QS',NULL,'Balqa Governorate',32.061022,35.831740,'enabled','1.0.10',NULL),(273,'customer','$2y$10$Hl3EihvH5/DcVwj/.3NjA.KLL.Fx0ZxqFnQuILy.1b1mPzldvdXfu','772341139','jafal8888@gmail.com','محمد ','ابو تايه ','2024-03-15 11:01:27',NULL,'inactive',78041,'2024-06-03 17:44:51','Bayaat Ar-Radwan St. 88, Amman, Jordan','dMgpSxURQ3iyAVq5VJzCvj:APA91bFSQhJT8n7ykS7JAjaxlNQmscNNBDaE8Ucf9-BQkQRVuVFu97CViH8vOAV-X4I-FxOeOkt78pLmR-K2ropMqB0Jd2Zg_e6osuH7PqPIG4EGNvvezATa-3CYgNd1Ek33uZQmJGp5',NULL,'Amman Governorate',32.000003,35.969872,'enabled','1.0.13','android'),(274,'customer','$2y$10$ZAE340vW3w9Ub27867fjvegMfwiUmZJHOjyBrnbQEI.q6xjdQE50y','782720639','sulimanmohammad1996@gmail.com','سليمان ','عرجاني','2024-03-15 19:45:27',NULL,'inactive',NULL,NULL,'GVMV+CQ4, GVMW+47J،, حوارة،،, Jordan','cU1c6VQ9QKeZ8n0I5m7DPu:APA91bFkNIDgYZ5V8DybKY-ZhsEuE2XrgQv9qouSAodnWbvsDrBhOGHSplmHZvx-lsoQZ_fFspF_AsIgHrXvQwUpEcJjKJ2JLGum0UK9WXBbupf4HVq57OlMpSbd7HqBv7diov2lzhVJ',NULL,'Irbid Governorate',32.533507,35.894308,'enabled',NULL,NULL),(275,'vendor','$2y$10$5n98a6fQQb4SUHAcHvnbDeKxDplm4lLO5NwKW/SJsPvo/pxifUpNK','776224040','abdallahahmad889000@gmail.com','عبدالله ','حياري','2024-03-16 08:46:25',NULL,'inactive',NULL,NULL,'Salah Al-Shemat St. 24, Amman, Jordan','e6DtrTZFQJSH3-YJn52oNr:APA91bEOq6mWOSxy4A_KiUFralZvDczzTw63KBHI0xMVyWoimyxxU7i0lAKkSoQtaKetAZqhFWnF-Ip0oegKZdO-WO2F5vVtXGYzjsivrahQN12OST3ClyKxqTO6FfxfgC_jLQf9tbn8',5,'Amman Governorate',31.958441,35.869590,'enabled',NULL,NULL),(276,'vendor','$2y$10$vVjJ0.RMjh4kAVN5tw33e.KVOew/z61j4vh7F7IsharRVgeZmlFtK','799403943','jdgd1880@gmail.com','انور','صالح','2024-03-16 08:49:29',NULL,'inactive',NULL,NULL,'XV4C+X6C, Prs. Alia St., Amman, Jordan','ePVmS4KlQR2rtfIj55jVIx:APA91bECFlqnp8nhmFKhzYw35uFE1T0OwxuKkVJW7-G5q30PLa8s7xhKHqBEWIShBu8k-xze_irWF5BxgM9E60OePHCBFI2Qf8jg5gei5yXB5lZFX4YXMZr3U3nuHrwEV9H2OR4YXu6R',3,'Amman Governorate',31.957734,35.870523,'enabled',NULL,NULL),(277,'vendor','$2y$10$arTRLbnCY0OM4w0LnayQ4.BNcgxUpfqZyFjR9gVsbmZbuvQEoq05C','798597576','tameerial4@gmail.com','ابراهيم','مصطفى','2024-03-16 08:55:25',NULL,'inactive',NULL,NULL,'Thabet Ben Jith St. 2, Amman, Jordan','dM0-3qxiScWJ7KtlHz5d3G:APA91bGaBK1uXYqMIbe76e32S-tn9MPkOkr5sv7r_ZT7PmUSR1fP2f_f9fqS34dCtcJsiuQefBtWq2t0pO6-fuOWXZe2-tMQGqhj0A2bkk9zZXi8_UIkczaYaIFb0e4yAyxW0yjeMxrb',5,'Amman Governorate',31.896928,35.905316,'enabled',NULL,NULL),(278,'vendor','$2y$10$S3sedSgokn0MQhJWgeyp0egKw0gn9ejcTHmUKpceE3lgNa4jLjTc6','795770292','dugxhg07@gmail.com','خالد','سلامة','2024-03-16 09:09:40',NULL,'inactive',NULL,NULL,'Q. Zein Al-Sharaf St. 138-144, Amman, Jordan','c-elVFFgSPuncHKQLC_aNd:APA91bE07tCHWSQmEhycoK3yxboYwJYEVCujHf3HwEuOxTi_lvkybdXx_kjnMG2cRJ30KQOd-szCt2JjTwbe49SctsPjgBRx2kKMtxyZ7OXFUu1vpVMFiRDFDVe_hQXqsepZycW0oWzh',5,'Amman Governorate',31.945448,35.857847,'enabled',NULL,NULL),(279,'vendor','$2y$10$Z.T61aKk/WV3SQ4ihUOJ.uK9Hy/lj73E5wwuGBmek.FFhyF5bpKSm','790085014','souhaibatar78@gmail.com','صهيب','العطار','2024-03-16 09:24:55',NULL,'inactive',NULL,NULL,'Muhammad Ad-Daajah St. 71, Amman, Jordan','cZcsCvC1S_GHIHWocnnvDs:APA91bECwPz7XQHikWufsDwmoOVgbuXhn8qs2kPxpbTARo0xm8GaftMLFeH1ViYjH0QhWHcnTh9HEc_GoiETIg65-1Ibb_G2zUN1wbxZi7Z44Rp7fyrZUbrXXHsPvXEbOekQgtAoJtfE',5,'Amman Governorate',31.970070,35.839585,'enabled',NULL,NULL),(280,'vendor','$2y$10$CBHE/qfI7s5ovvtER6f.eu1LSES1PJDX9j7ZfhlEGRFs7hQyxEzai','776168635','hvvcbbhv@gmail.com','معن','العبادي','2024-03-16 09:27:46',NULL,'inactive',NULL,NULL,'WRWQ+7Q, Amman, Jordan','cDAcg2QXT9GhA0zxlq22YA:APA91bEuqw0WqFhf2JlLFejTtbgeAAa80nSZdnJkap70hT-DCNmD3tVQvxuHbZY7WplVFIjpKPKyBQc1Ee-1dgpAWsRNn3bJuJMSEnQ6IwmYvYMCx0oMHOoDKVNyA3-_K502LTvsVAGo',5,'Amman Governorate',31.945816,35.839399,'enabled','1.0.15','android'),(281,'vendor','$2y$10$PnDdvb5ba1HO60mLlqge9e6Ik4E1P6KE.Q5VACpSE..ewXYJRAxbW','798691161','mohammadalabadii40@gmail.com','علي','المغاربة','2024-03-16 09:34:26',NULL,'active',57476,'2024-06-20 20:41:53','WRWQ+FF3, As-Senaah St., Amman, Jordan','cV2VRNDpStqf2hC8E7MWfk:APA91bGnAbfOm8yWF88tIKdL1zc8WqudPXCb-Owbx20nHFB_Ayg3gJBqNwz-727_uz5Hht4IBZIxnDUOkyBugSn5e7y6LytdF_qbDnpncMKWq43Z5RgnJxrPc4wzwIanyYLKsp6_ITKU',3,'Amman Governorate',31.946071,35.838983,'enabled',NULL,NULL),(282,'vendor','$2y$10$b58vpPdvcxlEFBNclj.Wg.n4xXxONR5BV.2y0H1sJvKijDBW3quKq','795743501','omohsen094@gmail.com','عمر','الديسي','2024-03-16 09:39:19',NULL,'inactive',NULL,NULL,'البيادر - شارع الصناعة الرئيسي مباشرة بعد الاشارة الثانية من دوار النهضة, عمّان، Jordan','eB2h2_QBTHWFZmK3tqtqGX:APA91bGzICXZRZCt9bXUn3kIo4m1kZF2I62cEwoNSNxqYzwUbyKdnofXJmqhjzqv4qCXOVQ6eZHUuLbbUfm2jXm7FP4590BqkioI-aPyE_cWLUDFlQd8P1_ad53P3D47MOAPvpjwdPi2',5,'محافظة العاصمة',31.945985,35.839455,'enabled',NULL,NULL),(283,'vendor','$2y$10$wsYdY3ZA2DwIHCZVSPENBe01rgKSKEYgd0aVBszLyhVqUgwgxw9Sa','772506413','jvkfkgbk@gmail.com','صهيب ','السليحات ','2024-03-16 09:41:03',NULL,'inactive',NULL,NULL,'WRWQ+HX3, Amman, Jordan','dMJe6M9jR-OTPEhpIIrXAU:APA91bGqu_okG6FI9lgcmJq8d8-LzChQWNlJbdHYE_2bdQpF7-YFYFDZxU1qG-Zud9ui8dPT21cleKETHErimO01ZW-v8bsck3-IPs3kWRgx8HenTAO1wSFI5kVo9Qrfbg1pJiDrXPR4',5,'Amman Governorate',31.946297,35.839774,'enabled',NULL,NULL),(284,'vendor','$2y$10$9.aCggazLcrMKdvqgL..RODKMmR4PsJlirE/u8ePqBGTnG135cIZW','791822043','amhdhyfhalbady07@gmail.com','خالد','المغاربة','2024-03-16 09:41:35',NULL,'inactive',NULL,NULL,'الصناعة،، WRVQ+XM3, Amman, Jordan','eKSktawKS0KkXaH9O-ZLso:APA91bEQ5XyoP60yYKc4Zl5UWE8ZrBeAO5spCPqhBy4RQyqBD7o_s9ER7hcxxjCQmJnQM3kIQwGyrBCcAc7i14dPDevZ0YQEYBdFH83EJaSg1MCR-DA9lXIuS6EqHOvbMSsc2Bpl6zRL',5,'Amman Governorate',31.944871,35.838949,'enabled',NULL,NULL),(285,'vendor','$2y$10$d7JwSwVWnwgUuzlu5TRia.nZ9g5AxXde3JzDogUMG4TgdsxYk2s76','799672490','ibraheeemabade39@gmail.com','عماد','موسى','2024-03-16 09:50:55',NULL,'active',NULL,NULL,'XQ3W+JH6, Amman, Jordan','fmdSqXCySye3H57s1yaoZs:APA91bEOly6yHt5OZgAryCD5uU8tpZtYWy7XsAglFlkHucQM9I4Xy_Am5NQXchrbW2wHbQrrdQWbmn6C-ZabblG4v43yrTI4Z7YPvcK-rfVWQQLZrls03SVsYTTrb9yaEwDILVQs5oFV',5,'Amman Governorate',31.954190,35.796364,'enabled',NULL,NULL),(286,'vendor','$2y$10$RSF0cAaQ8Qk2HBpUz1nUce2VkbFgLaIIj3/ICPcvNDVL2gsC5w1vy','776349010','dhehehhdheh44@gmail.com','عناد','العبادي','2024-03-16 09:58:15',NULL,'active',NULL,NULL,'As-Senaah St. 11814, Amman, Jordan','fm6nvpU8T3KEb3BpBzyJxW:APA91bFvLDHQUgiiMSxCB0hGv29pVkB2wwsVx-KEAIgoxXn4FOlcYRbC497c-bxD_hxmIMmuXlOzxmUP4zscDDrMqhKelAQkVaVErNsuPawh6kCUQUP3ZeSmSDf_4NR1wJZ5A-WkFJE5',5,'Amman Governorate',31.938221,35.819979,'enabled',NULL,NULL),(287,'vendor','$2y$10$O9yZ1XzAQ0c/OlnFUVSFYeTm.pPHqE3cnrOQPbQgCbSPJlvHypwcS','781766662','mahran600600@gmail.com','مهران','الاغا','2024-03-16 10:09:41',NULL,'inactive',NULL,NULL,'WWQQ+MQH, Amman, Jordan','f1DQ4XG3SIysdv2jhtmpzt:APA91bGqdVyAd1b_liMB4RO4ISma2JK2fc9N72US1iJD76d3WSA75-gNEG1nbDTECyD5YemxBJt-rh2Wx-Co9SM8jU_kcJUFBKkhPu7_QIsN2T2rUPZyuVNHQ4UYsh_f26B7ZjSxx3F1',3,'Amman Governorate',31.939313,35.939517,'enabled',NULL,NULL),(288,'vendor','$2y$10$VUCse/1aMboyjQ/1QPDl5uUDtLyCKZYDZvritQ7gfpqiCv7sHgsRq','778168467','aaaeee0778168467@gmail.com','محمد','علي','2024-03-16 10:27:43',NULL,'active',35072,'2024-07-11 23:58:42','XV53+9JG, Amman, Jordan','cKnsp94NTcyPeFM8EeCQHV:APA91bGUSBc8_Des7dfgVgyZVNdDucNHoIGJFsWuJgmp72GwCXjBP5D-fJ_vUn-B01HxDjfC6B2qu98ws6KIE4sOleHctFmihbBTDJgrnX5dM8qk546ZpxRqV1uwBf2khtbxz_sG-C60',5,'Amman Governorate',31.958553,35.854026,'enabled','1.0.15','android'),(289,'vendor','$2y$10$luMOY984eDaOMOA9YRiVp.pS8K9SQPbQlZgDS3nEhaVVYa204cm3y','799429743','jhfriifcfh@gmail.com','سعد','الزيود','2024-03-16 10:41:34',NULL,'inactive',63911,'2024-04-09 15:47:55','XQ7Q+7W9, Amman, Jordan','cNoSBNh1T4WUrn1OOqysfd:APA91bE5mo8cFlGMbhGNLHQiKo0BTFQV3d8EJ5yNSiH6CvJop_00SuPWl62VZ_jtJQl29PkU741M1CEZr57Jgbytjws59fiW0Idr8wX8pCTNDnDRFcB_lDFrB4VC0zwwB8mDxvTXCA-i',5,'Amman Governorate',31.962883,35.789640,'enabled',NULL,NULL),(290,'vendor','$2y$10$oVFSQxwm.DzouoKM7ZAix.BZ1rokUIyTCj912J5pyY0B8wIlEx.ia','776705662','almgharbtysy4@gmail.com','سليمان ','المغاربة','2024-03-16 10:54:26',NULL,'active',NULL,NULL,'WRPH+X64, Amman, Jordan','dqDm7py9S5OYS7B_KcIbHh:APA91bFH9-GEaV6OPDibuB9NYr1TyP-wAqOBaKAD8Jn_xVQZVGnithbkZz_0fc8CbEBAFIe9vvdzqJ3Qh692x2yN8G79xv9rNTT35QhCCeA7Hisneu4N84mRjmkU0ZdoUh8S8IpJ0UCp',10,'Amman Governorate',31.937909,35.827606,'enabled','1.0.15','android'),(291,'vendor','$2y$10$hJqNs4iTK5KI16LpRYTFyeZhys5qyWH5FTwhGbSQ6jkRxaQiCKque','775661318','nsemsaeed@gmail.com','سعيد','حسين','2024-03-16 11:10:41',NULL,'inactive',18004,'2024-07-17 12:26:36','Iraq Al-Amir St. 1, Amman, Jordan','dldi3aNQQe-Hu2GxahvR-7:APA91bFpLH4MMK466x7x7SiJJHiWzqp_0E9k3aLf7jz9qAjkx3e2c9JbbirijLvwMnDtn0QtmK_B7VWEBiYwyomblP849vXQ3YPchararyoFJhFBjpfYgkRwvvNTcrC0V-NmqICKC2-r',5,'Amman Governorate',31.952744,35.820096,'enabled',NULL,NULL),(292,'vendor','$2y$10$oksutb9Tm6z0cINB4/ZEPO69bADqxZqO7KRJRs3oQl.tpSbLL1KJi','795073163','lftawesaif@gmail.com','عثمان','اللفتاوي','2024-03-16 11:19:27',NULL,'inactive',68769,'2024-07-17 12:11:47','Ishak Hujeirat St. 28, Amman 11814, Jordan','dz_5p-S8Ro-6ve2t9ONx3J:APA91bE6GlX3LrR36LRLiVbftYgN41tvMXJWvncGRiTGGHXTqFLfwSv-DyBfE_nw7ZOlvEK58Wl3cNDSWm-IQGPTw7W0-T0Zu-A2oPZ2cLmiOuAt2Ekh0c23lKP6tXBzAXx82uObfhpV',5,'Amman Governorate',31.953544,35.834048,'enabled','1.0.15','android'),(293,'vendor','$2y$10$Vz/42uvQuZDxY1MRx1JQH.doX7NDh2lgtkoxhkuOMjeen/euMOVFi','798678172','albhlwza@gmail.com','ابراهيم ','البحلوز ','2024-03-16 11:37:00',NULL,'inactive',NULL,NULL,'Al Wehdat Medical Complex, ش. الأمير راشد 224، عمّان، Jordan','fv4uRyJ_Sd-BO6_Mt9mMJX:APA91bGAC5eDWKHTQzyu1EXXsL5bbiZph3vm5e0yDnhCh7c1JNJ2CjUcrnDxLRCYLsu7CpUqoum2l07K1gskYmSB0m8EBVnCotl7DKpCjrV2kAQc4GUm-EFl9ngq689KueIxJwefxxtc',5,'محافظة العاصمة',31.971467,35.949666,'enabled',NULL,NULL),(294,'vendor','$2y$10$oaeOdlqWnXzol5visYHPLeD..92s0ienKYNyuvCs9hTg.7Uz3qsU2','795622552','ahmadalattar905@gmail.com','احمد','العطار','2024-03-16 11:38:23',NULL,'active',NULL,NULL,'الاندلس،، VWP8+8HX, Amman, Jordan','chrTi_VgQlaYR7kOmQHo1g:APA91bFNIRZbz3CzOFbJMzQJfSXPXzJvOKdGGXxgV4-jA_hN0O_2SZ_WLz4kud-l8DGzkVvGCDK9mz6SSOB7KU9YxLN-HTw-083h1S5_DatZar8IacN0lRHBCfQyO6NoIZcnsBGIlKHs',5,'Amman Governorate',31.886360,35.916887,'enabled',NULL,NULL),(295,'customer','$2y$10$83Q1a5C.zl5pJJiT8W8mreHBFjxWGke.4CmA9Qcp5/l14.YqtK4d6','795212341','aboud_sisan@yahoo.com','abed elkareem','al sisan','2024-03-16 12:10:38',NULL,'inactive',NULL,NULL,'VVWM+PF2, Adnan Al-Junaydi St., Amman, Jordan','fT_FrudiQ36Dd16dvt07GX:APA91bEPP8Kr5yhjQAp8qWvE5S5bsEDPXH-QgEB-b_O6PQnMQXVWcsCA9MRdReG4WJxgqZqKK3i7FKB2ILZuDGZOZuhINXY179hb_j-vyCrJFNmUfMehJopzBJktRz72gkBHFabgwP6c',NULL,'Amman Governorate',31.896540,35.883581,'enabled','1.0.10',NULL),(296,'vendor','$2y$10$SsHVbW0QL5qv7OtUrQq46eOxvoFrML8lUBqUmECgu5gqGATipMjsW','795253251','atfalhtamlh7@gmail.com','عاطف','قاسم','2024-03-17 07:20:20',NULL,'inactive',NULL,NULL,'WWGQ+CHM, Amman, Jordan','dP2VZ1HvRVqfLkzXkSUOcT:APA91bH6CyykywSAEj0LDQgDvIUdh1g3hFQhXvSInA1WmAr1WoJDsipr450d5n33Cav2FZWsCKqKxKG1QwzKZD2eZ_BXrQxM_d_lAOFnx1WjART6EfUTXAW0pMS59esdQg8rn5zkPEe9',5,'Amman Governorate',31.926249,35.938868,'enabled',NULL,NULL),(297,'vendor','$2y$10$fvHUtTRoAa.Bo2DsNDyGuu084J5qz3UyAuAp0yIE0pNdBfSKpmpBy','790055789','morad.hayyeh2014@gmail.com','مراد','ابوحيه','2024-03-17 07:33:34',NULL,'inactive',NULL,NULL,'Al-Mukhtar Ath Thaqafi St. 51, Amman, Jordan','dNEGPXlmSXKjzv9lMnLy_g:APA91bHj1eKZdCv5T9Ln_urbXfvq39eIBLPQOlRQL86CcWoPFsaTtFmHHa3ICAeiFAAvbFshNVKfm8IzrfCOb1rS4pm9mFivHuQ-NnfQhIr3p9CfEUAGvp7H2LxuI8w0Q2RLR40g33fK',5,'Amman Governorate',31.925309,35.938841,'enabled',NULL,NULL),(298,'vendor','$2y$10$Tag3pMN0Ibx8uXwJh9aqRucelP8BGyzO8b/Il0weCK2/xjUpYkSB2','796451523','thtylkh@gmail.com','باسل','جميل','2024-03-17 07:37:26',NULL,'inactive',NULL,NULL,'WWGQ+GR5, Al-Aayedin St., Amman, Jordan','c0ryVc97QEiKgLMoXPlmB6:APA91bGkMdVcHP2NxJTqWKPB932rqzqenn5psHTy1-l4tCxC5kDBYCCe6_II1FvH7yIer47NQN-fdcdXjpsCcFpyOoNp2PzEWmVpRCPHPKiXvA9OcD_RJSV4YuBAWf2nIskJzPgTkpsG',5,'Amman Governorate',31.926303,35.939523,'enabled',NULL,NULL),(299,'vendor','$2y$10$ZwaKVHWrXJLIWZZcb7EEGOEhCPCAG5KPs69aco8Y/nhYWFutH1vfS','798833971','Ahmad.88.awad90@gmail.com','احمد','عوض','2024-03-17 07:41:09',NULL,'inactive',NULL,NULL,'WWGQ+GM5, Al-Aayedin St., Amman, Jordan','eGTsnjDLTfyUjU4lMHvygm:APA91bFwxBFSkwZ8rjXHirR4ejbNeZiFbRzHgZj0TfQUpNyVfcBfiiGRU0u0V1QmkYyGYLdQ-AVk4Tb9j03Wqh06YBipUQVnynl9i-fet03DPIqfDDvBIdBtpSYUn7o891sYIXjICUGQ',5,'Amman Governorate',31.926258,35.939207,'enabled',NULL,NULL),(300,'vendor','$2y$10$qOsHAh8OlfCXpYhBzuZdDuAUPNiNk4uzL7Fe/vRnFRnTZYbC8lzcC','782593339','abusharkhahmad65@gmail.com','بهاء الدين','ابو شرخه','2024-03-17 07:49:47',NULL,'inactive',NULL,NULL,'XV48+Q56, Al-Qimma St., Amman, Jordan','dWT5hAJCRv6b7d28sKo_fI:APA91bHFzWKF4Fm4ulBfq2Bg6gadpZWEJ3vFRHk1JqU2YkOwZTwihr3ZDvSaF5K8aY5-jfzGA5dnEn5GnYFhWWPsw8CUij4rHDAahDxIUdgFFhxXBkwoLuSq5deEurv5dX_fFhDbli9l',5,'Amman Governorate',31.956807,35.865423,'enabled',NULL,NULL),(301,'vendor','$2y$10$jWEmZJ9GQRLxJrC1sfUWTuFSidjZEer44Yn5KM/gauGmYpuFVcgvy','795040877','lwshshms81@gmail.com','انس','طبازة','2024-03-17 07:57:53',NULL,'inactive',63709,'2024-03-18 19:50:07','WW5Q+25Q, Pr. Hasan St., Amman, Jordan','exocCa37SpauxsGepKSUEo:APA91bFPRP1eToDzXXNTAPAubH94JpJjeipfx5gk32hehhZxVw9hA8Sa-0TLxX3JFIyjbFvX0qTh8jXk1os9OLfuMtayDWx18VWOKp0sTwIsz4WdiJdXUqCOcJB5uAG5XudBOC6Biy7k',5,'Amman Governorate',31.907625,35.938040,'enabled',NULL,NULL),(302,'vendor','$2y$10$Fc/SiisuPo7trRsVFSSr0.m5RqgGDga/oUzA4uvd2Qhyaa0bdSVSC','787780831','ashrfnadi0788@hotmail.com','اشرف','ناجح','2024-03-17 07:59:03',NULL,'inactive',24510,'2024-03-18 09:32:25','WW9R+CXF, Amman, Jordan','eD7YoBnHSR29LDB8vc9_Z5:APA91bGNR0oU-PeSvzC8MOFgqV_J4HVOJA9MHoJG_lbKipyq4KT5qcwOEqwArPRo4AYbTdwMLenS0hWV1r5srGcXwOH2Fcrqb3IEY7svo-gpqaDzld2948Bg_27nF5AEmCMIL6BkOvsV',5,'Amman Governorate',31.918667,35.942160,'enabled',NULL,NULL),(303,'vendor','$2y$10$ngeatYZERvNI/j.QYT9i1eBoUqd4vFWepkh8epnmmbj4XrQqeqiZK','799489006','shahaherm136@gmail.com','شاعر','عيسى','2024-03-17 08:02:45',NULL,'inactive',NULL,NULL,'PRVP+4W Amman, Jordan','ebR5QyabQWKggMEIHSASuH:APA91bFQWK5S6M3JQBDg0EM42FmIwjqiOVNreiiSbDd3Xyl9nuDmoKamtKt3JJMWiW0j0SeETFTsMDISu97py0UY5hjUKzqir3nbsuLUzpXz4dvJzFhvto5enxjoGVbYC_DKSsC5vvTq',5,'Amman Governorate',31.742774,35.837369,'enabled','1.0.15','android'),(304,'vendor','$2y$10$f.DOc3iTJkQT0Zl8Cv2pNe6xBRQuayhfDY6hO6l0bW8jscnIcL72C','795043818','odayhamdan437@gmail.com','عدي','حمدان','2024-03-17 08:03:12',NULL,'inactive',NULL,NULL,'Khalaf Al Fayez Complex Ali Sedu Al Kurdi St 46 Abdoun Al Shamali Amman, عمّان، Jordan','epaxMQmOQAKJok7qkUEQ45:APA91bHs_Itr2rI31_g9Wp8WYh-uENF_HrfkBcAsMx3DSnIYH3018yTJlSTGYXuJ08X9sgpAy2_Sb8nPb2Eo9M32XoyFebc-ykieLeP3AwILkcz2n6OQdV18TC-GtALA5mNh3TP8KUdQ',5,'محافظة العاصمة',31.947355,35.874610,'enabled',NULL,NULL),(305,'vendor','$2y$10$Q/0hSff2cIIiy8J9DxJlQOsfdcf4F9eTfOxaBsFCZd8Bas3t7JBgW','795248614','amrtabazh@gmail.com','عامر','طبازة','2024-03-17 08:13:51',NULL,'inactive',NULL,NULL,'WWGR+98R, Amman, Jordan','cflyS-OIQPKZj6mriSG1Mk:APA91bEuKgeRO_588mQv5iIjl00ow9J1uRvAaSk9s4Hktz6fBmr5NhIk_KF88fOrc7U_y0u75Xe8iOGw78Hh9BR-swj4zqU8vdB3Lmhj_WLIa_15HjxzUTBFXWIO8SORdioufggtNLjq',5,'Amman Governorate',31.926168,35.940505,'enabled',NULL,NULL),(306,'vendor','$2y$10$wTWjKCR5fHF1fBxj72Zu0.XJ8p1SzzgXw4M67IXpOi0qI/YBBDKIy','795775846','azmishaher.alkouz@gmail.com','عزني','شاهر','2024-03-17 08:28:16',NULL,'inactive',NULL,NULL,'WWFR+X34, Sumayah St., Amman, Jordan','fYpj84KhQzWgmFD9ANT8By:APA91bHzQYpTSBCU5Wd1aHg0z9OWxEvlgagBT_0FKMl109PIU0iMf8SfdBS1aAcz5h8EDP9gGDmc4VmjC3yllFFBD3Rvm9iYCcf-lw0JzLDPdUBFHfWtCt2GKjzGzehkb3yOnZCdWxfN',5,'Amman Governorate',31.924878,35.940184,'enabled',NULL,NULL),(307,'vendor','$2y$10$v8pKZXL38YSZIhmNyd5jZOf09ctw.g7ZY.SbtB0Vp6BQnNhj5/dkK','796148248','Mustafahmh88@gmail.com','Mustafa','Hassoneh','2024-03-17 08:31:19',NULL,'inactive',13400,'2024-04-15 00:30:57','Al-Mukhtar Ath Thaqafi St. 51, Amman, Jordan','d2n1yoK2QuCF6dCcev8Bl8:APA91bFGAIqb6qmwCmVP4ZCCG1ys7OWd477mLMTLW7OpSL27CWZo_kI1eZt_AmrHzzJ5HnuV8jmEbhaBlkfb8ZHF9IqQ1wHjLi-Pt214VoKJ6o1afSqpo53TsFKgTvAJ-Y00fTFZuRYN',0,'Amman Governorate',31.925401,35.938802,'enabled',NULL,NULL),(308,'vendor','$2y$10$F2qiXrS.aeLiPGURNUXYYO6ALvekI/Ah3tSk00/fhmDTh3xc6GESy','797911262','ramzihasan62@gmail.com','رمزي','الهيموني','2024-03-17 08:58:07',NULL,'inactive',NULL,NULL,'Pr. Hasan St. 317, Amman, Jordan','f7yIiaO1Sym3j6YgogO7C2:APA91bFGDJN_bH9nGKLtXB_ccdbTO4Bw64bUIZd8C-uVvyjAEuCRztvcxnjh3tvMp_jVjFbyhwEY2JyaSjWer2mxGkBOSZvl1wU-mi5g1el5HqJnb3z_tYrV0vhPPfvC_0gJEoiPT-Ef',5,'Amman Governorate',31.921670,35.938388,'enabled',NULL,NULL),(309,'vendor','$2y$10$hi.dekTamV8XMEKmDfPmQOV0QcOstwoGG4yMHy8MxWuzKvs57DDpC','798006461','sakherbaker1122334455@gmail.com','صخر','العودات','2024-03-17 08:59:17',NULL,'inactive',NULL,NULL,'العوده،، Amman, Jordan','f66Bsd-3R5mPGyDVJXWGB4:APA91bFmYhKZBFq4rI-tPTGrO8LB_RdeqiI8U0WxeVja4EoliUTrXBAZZAOw7lcY4ZRxw6TWy20IwqBPsR9CQXv2X7wKQHjeN7_P2YeWka4Z0lXkjpsl-Bgv50a2-nZVcUFSAJTUrlOX',1,'Amman Governorate',31.926251,35.938963,'enabled','1.0.15','android'),(310,'vendor','$2y$10$ZlbEQeIoMla33o8LlMwiLODbVjtCvmN7L3KxYJU2p/eBfjU6nSHWC','796553332','mshwqhmhmd2@gmail.com','ابراهيم','ابو عطيه','2024-03-17 09:06:24',NULL,'inactive',NULL,NULL,'240، Pr. Hasan St. 252, Amman, Jordan','eL8YURdXRiSdyVm1-_ILWP:APA91bEDQr-HetJPXPTfPuSAojpZEBKdmp-Fpf-Kk12Jo_RI4Q_je8GdHV_NVn0nyejL3TOBIR5PO2l_KCq7aPHnbHAm94n8NoMPx9uILLbemmyQzX7Bser_4V1RoNXyt65j6_hm3tJK',3,'Amman Governorate',31.926034,35.938724,'enabled',NULL,NULL),(311,'vendor','$2y$10$hvn3.lBWrChpn1Lbg3NPiO7UwFirYsitcStZEKDCP4jqjMMEEIle2','796552170','alihsuoneh@gmail.com','علي','حسونة','2024-03-17 09:10:22',NULL,'active',NULL,NULL,'WX94+6XF, Amman, Jordan','e6bFNjeOQh2M6xa2jLkMHm:APA91bGN8a95xKK67IGFEv4Mx5CwHP30ox5GfnQRciBWDcnx47qehl7kzN1Ez2IrJ22506TSkvpfyfQTWLyTgNvMtypaVWKOUCtQ7DRiuAwb2Er_XlDxddHSgLNVcxsD1cR5OfNm_mxb',5,'Amman Governorate',31.918107,35.957353,'enabled','1.0.15','android'),(312,'vendor','$2y$10$aqqpn6oDVpVH93SjtVPL/OeJB6poUHw3PyEoUe5DJpV7Z1M/.CaOW','798943592','aqelmaher5@gmail.com','ماهر','عقل','2024-03-17 09:11:11',NULL,'active',NULL,NULL,'WWPV+2RQ, Amman, Jordan','f7hRnm5ESZicv9DMyVogkz:APA91bEVR4AKIl2fJEtPixf8MeU48B9JD9OAyXYGiS5C4VHUCf7-zYfMs-2CY-ASd8Zu8MalejXnhmFQVAMnJ6x4tr9AXvOsigpsjC7nCEiBUFEzjg0qg3Dmm7UkAGqlVeMnpx2rlbYz',3,'Amman Governorate',31.935117,35.945807,'enabled','1.0.15','android'),(313,'vendor','$2y$10$qinYrCawzDVRD6JQQA0xbuFu543gAyC4SIXAX5x2m3mrMEx.zrPAC','797515282','aaaaiutr4321@gmail.com','منصور','ابو رجب','2024-03-17 09:12:45',NULL,'inactive',NULL,NULL,'WV3V+78V, Amman, Jordan','fM_TITx3Qna333_qM_nFuV:APA91bGH0UYDuJewyXxdZeVaEW-9dZMgMGEIUuS55KWfQSHGH2b_7C6XDOBtV7dWOL-dFRq638CYzAPPg0oPVGmxdnRn7XFb_cUDOGxhtMlBVuRuOTeomK3FwBKZX3OX66JO551_YKRu',5,'Amman Governorate',31.903155,35.893377,'enabled',NULL,NULL),(314,'vendor','$2y$10$xC4.S5XK63kU0yScz0tY8eMklynOzbtE8gD1i/NuRC6r1SOtGYjde','795173358','nedalaltamari9@gmail.com','نضال','عبيات','2024-03-17 09:16:08',NULL,'inactive',67763,'2024-08-21 21:16:59','240، Pr. Hasan St. 252, Amman, Jordan','cx5gaLBMSd2dinGTzcyY4S:APA91bF9J574F5klkHuzFID95uSGymnqfB7s2d4Vy2VJmdR1kZVGOxEJ7VAb7I8KaZMVf6cKUW1dBK64RLQ8x2xEx3aHm31XTet7ivHrNZTDm4II_Bw1zRwrATbOn9mlotk3qLGWLnD8',5,'Amman Governorate',31.926129,35.938768,'enabled','1.0.15','android'),(315,'vendor','$2y$10$RBmA5GxpDTMeyV6isKkIx.k5TVj5jHQ.4Ex7.36wueGzoG9VUVbIu','795778718','ja758261@gmail.com','جهاد','محفوظ','2024-03-17 09:17:15',NULL,'inactive',NULL,NULL,'Al-Khemar St. 11, Amman, Jordan','cJVH45VMQvu7FbyaiGLpZv:APA91bG7qnAm6mSyIGhxepzUFosIAuNZ3ylq5Etzb3dY4Pq4FRq6vdlRdjNZ-oh5RSPS70_9MU8mO4IhBjYAZc67J6rQ9m4Eiy3X-nF9X69jP340MBKYkJy07jmUpEsfPXwJEJTvyqCn',3,'Amman Governorate',31.904310,35.977914,'enabled','1.0.15','android'),(316,'vendor','$2y$10$vhF0dHJ3SA2uxH91INK9lexJF59/2fjh3Fpj5iD8Abr0Opm7wwAOG','797318487','hanyabwalynyn1@gmail.com','هاني','ابو العينين','2024-03-17 09:28:31',NULL,'active',NULL,NULL,'2X38+WCH, Amman, Jordan','f-F_ediCSc6N-Cn35sLTdz:APA91bHStWdDQYaAUzxBEHde8zGyMcIf54TkhRyCUClzP4ZQc51l4aRKtVWNomdbAENwc2tDP4uMvdj7x7oRsSJOOf6ktWRgnCAJaIpbHmHJB3GiNDM2JbsErBZHqWRaMoSboqKCE2AX',5,'Amman Governorate',32.004795,35.966028,'enabled',NULL,NULL),(317,'vendor','$2y$10$2loGYEDzdqZwdRfoKkH3EOSlR0aYTNX8egbK/xOa9UBapNfez6jKy','797163461','amqsyalsrfndy@gmail.com','مروان','نضال','2024-03-17 09:44:39',NULL,'inactive',NULL,NULL,'X229+V7 Amman, Jordan','feEhq8J_T2CMR16mWP5kti:APA91bHRy4GtGFREQFqFfxsCtD3R1OFD3zsIiX0Xar4XT6juMO2CmAvnsDmvqnW2EdHFFz7lQbmR-Jue-Iedn3nTUw4TFatNWhxlb-sYIZZie8MKoYc3GsfAkdbbC0uv0vUTFUpuGny8',5,'Amman Governorate',31.952135,36.018133,'enabled',NULL,NULL),(318,'vendor','$2y$10$HtECCO7fm0HdVNeSdKgTtOtxkmSmWIW8f8N4trg.8jqmJK87SedTe','785536393','barhmmohmmad407@gmail.com','محمد','ربيع','2024-03-17 09:48:49',NULL,'inactive',NULL,NULL,'العوده،، Amman, Jordan','cFXl1GZyR4GgEzTbdxMx6k:APA91bFv0I7gitb-b7sDeHuHSZrO9Xk0yCyBRZrAhPWVKcPkZMn77GTBi57_mtZFvm9TqZPkO6qzZe1R4hTDHJjxRP9-nnjOYeuCqEvwCR1rVzS4nTNEgTTlcYgdUlvbbErOamnRtwO1',5,'Amman Governorate',31.926233,35.938968,'enabled',NULL,NULL),(319,'vendor','$2y$10$pXxZt.fSUAyVqbgm3rUdMuKAiOy8YzsW5CdRBNi8Tp1esWE1CUDKK','785917064','apdaaa622727@gmail.com','عبدالله','محمد علي','2024-03-17 09:52:16',NULL,'active',NULL,NULL,'X3R2+WW5, Amman, Jordan','fpmohBm3RY-KV9Ym9rJ75s:APA91bEzFJXSCVpMI0pBQISa87K7-8BwzHmoIZDL9M3j_JOaS4HpOhiKmyFBk_I6Du4G4LpVF2yL4G7nrxQle9XafyP0W4rAd3g-ftAG980-MUL9iqjycgle3T-hwbd736MPIsYpHrWK',5,'Amman Governorate',31.991479,36.052863,'enabled','1.0.15','android'),(320,'vendor','$2y$10$si0HZ1DBNioF2cQJnlO8D.EaMy9STw.yGm1AEmloupxxFU4cUrQY.','795966149','qwwweeedddd55@gmail.com','قصي','قدومي','2024-03-17 09:54:15',NULL,'inactive',NULL,NULL,'WXXQ+83M, Yaaqoub Al-Khawaldeh St., Amman, Jordan','ebRBxYXzTXy7eU6qWO1m0L:APA91bHHLyU-7Gy2qLDsLpoUOPr3poF3qWm2M_q0FX59irW0mPu2eA-NO1TKJHJSB_YkZEchowuQMmAeT29mr1YrHOX5oCM6IVLFI6vYw0otBBxpysS-tGXeKip1bd9PvhzkQL7kHPe4',5,'Amman Governorate',31.948017,35.987881,'enabled',NULL,NULL),(321,'vendor','$2y$10$4ODr4vqTa5DaxRO.caslne9y3/7chgZI47QL7Om9O6ZglIyC6HyRy','797492058','khattabalkhattab8@gmail.com','خطاب','سعدو','2024-03-17 10:24:22',NULL,'inactive',NULL,NULL,'Al-Mukhtar Ath Thaqafi St. 142, Amman, Jordan','eiLcQ61vQeCsVs1i_Y-Cs5:APA91bEfVVNl6589JQ-QH1-Hf5CnCBg6v_mqqdc6oyKL5tsxGd8sFIN6slct99LjexTNLRxDq4lbb6fvTj9Vxn8Ex1gFVRjkCorRf2IzKg3SHrCO0GT1p_CL5I4cGxfeyG0mUV4fqAq5',5,'Amman Governorate',31.925590,35.939047,'enabled',NULL,NULL),(322,'vendor','$2y$10$xbmxYZVxqCyTDv9f2HqxTuOx4iMn2cO/1LKbLSAsythrj5ouHjRru','798015215','0798015215aa@gmail.com','احمد','حمدان','2024-03-17 10:37:17',NULL,'inactive',NULL,NULL,'VXQ9+4M9, Al-Oumaraa St., Amman, Jordan','cc8rUdZ6T6S06E0SpiBr3h:APA91bFI1-BErNG2UK42vgMvv10WJQk7sKtZz_hmNeYSPAK1E_9ZKgJ0DyHwC7BY4Wxm1k4UtmyrTpD9A6f8GwcYGv20xjzEedSOcvpKjoHmuWAMKJtfhdgnK4fq_JZT93wwc3AGTmpP',5,'Amman Governorate',31.887688,35.969294,'enabled',NULL,NULL),(323,'vendor','$2y$10$HFtqyGTNUiCmB3fmwEQ7f.Nb/0tmKZLK.vfUW93K0wI5HmTfpXK1W','798706896','sameerabuokal@gmail.com','سمير','يونس','2024-03-17 10:40:37',NULL,'inactive',NULL,NULL,'العوده،، Amman, Jordan','citMUk08QSqkXxZEXUbUoI:APA91bGUIVO3SEqmkzQs_nWB3LnOmL8pSR9lVQzIJNvnj-g-1UbbKdl4fpQYahIdjDm7-50VbuhcHb7Oe9pKy9yvd-QMF6Izo-LRs7C8JF_JkC0CsyQeUXgIiNKnkumQxE-lZ6AIAWFA',5,'Amman Governorate',31.926240,35.938982,'enabled',NULL,NULL),(324,'vendor','$2y$10$xnacg9DmDPu.WxZ0PFhvFOAGbCEaQtF9kkL9IbuTiRgVf/5DUGSjy','799258787','ahmadwreikat56@gmail.com','احمد','الوريكات','2024-03-17 10:45:16',NULL,'inactive',NULL,NULL,'Abu Nseir Commercial Complex Abu Nuseir St 181، Amman, Jordan','dVnM_93wQ8WLirDKHfzF8C:APA91bF6F8VCcpOsRdECMdJgKpErKy7f0hQHDIiHc0poqhG1TqPPgJ1HZT4VGK-g--fyqYHat79o7IYB2g_sayoyZw7QWQszZcLThN2meAqRDh6Vaw-Yjg0WA3F76CgMPkKQ8CJ-2ZA1',5,'Amman Governorate',32.052224,35.878202,'enabled',NULL,NULL),(325,'vendor','$2y$10$u5WnBs9/mZ977zJbEt6yWeziC56YR/MyuKLhxyGDI.ODcOVZfyDWK','798959340','ehudaib@miyahuna.com.jo','عماد','هديب','2024-03-17 10:51:55',NULL,'inactive',NULL,NULL,'3RFR+M5 Al Hanou, Jordan','faae9ZEzRPeUFca1JWn6Pg:APA91bFEzE-HW8KIIiD5xOSIMH7IwRtJzPZ4fLkBAUrh288AAX9qhBgPXDn8MrP7wkQ3fD9DrAi8yH6ShdvaNJKISujZAVpt3S0dhKE0rqZqTu8ZarhB8vPlsLqfDRcL1kaGi3Zu-AkW',5,'Balqa Governorate',32.074206,35.840482,'enabled',NULL,NULL),(326,'vendor','$2y$10$sy5/T53i78zR4oEyWYHN7uy5vLT7D.HANK9XeSGfHmpH1pJpXFla6','795264561','mhmwdmhmwdabdalhmyd501@gmail.com','محمود','عبدالحميد ','2024-03-17 10:59:30',NULL,'inactive',NULL,NULL,'Jawa St. 8, Amman, Jordan','eLk7O6wOSPqpih-kNgHoHK:APA91bFJt4ind0S5ni1n92RKo5xUaayA9KWfcjZ9ZRXESWRJdynzKFeZR9C0WTYRcadEUN789GpvUxq0xjpl3t29JTAIutb0Ic9dahvtAS3lwiOqFgB4kfHMdhjwSr1NP_AEzV3tpaFa',5,'Amman Governorate',31.853269,35.939441,'enabled','1.0.15','android'),(327,'vendor','$2y$10$vZxJgo7nRsbDGMR3AYByWuLGef4l8bT1ofD.mj.RBbQkCNhzyr3XW','790494922','mohammed89159@gmail.com','محمد','حمد','2024-03-17 11:04:55',NULL,'inactive',NULL,NULL,'WWGQ+CHM, Amman, Jordan','e5W05PniReuk_tFFh5cH0i:APA91bF0oVqulcknJsfzOut9jPPPjriqV-76nU8RFrXMr_cBilj0k7luvyaVyY4o469OqNKJYcCTNIPQwOkFeSWtK_e2bd9JSVkyrbzzn5OLcFVufutmNm5xbrm0wHTQZUFdkOZrdt-i',5,'Amman Governorate',31.929262,35.959053,'enabled',NULL,NULL),(328,'customer','$2y$10$Qw3W9KTbvVnjbCbsBgblg.Ct7WoYCD0qEJNRVEV6z6NoVtFxmQgXu','797980605','abanisalameh@miyahuna.com','amer ','bani salameh ','2024-03-17 18:42:07',NULL,'inactive',NULL,NULL,'الرواق،، XWGM+MHQ, Amman, Jordan','d5idWyPjTyevXVa4bvS-0Y:APA91bHW-klcGqOLfjRfOLcjNn4oVIYwHf5xE9riQz5UCo4NPN35FzDmczk61OGIxEAbPGSXrUTFBa3EeXN9klbMDf0k2QyM82QFC0l9qTJw4hC1FLvjuPEuQF92Mgz9lOjaenOt2IAl',NULL,'Amman Governorate',31.977116,35.933826,'enabled',NULL,NULL),(329,'customer','$2y$10$uTIEnjmMVZXqggaZzJuJMOp.aqh78qTt39VbkZnXeDIa0slAN8RQ6','797325444','jooryjameel@gmail.com','Reham','orjani','2024-03-17 18:55:55',NULL,'inactive',76802,'2024-07-18 17:28:26','XWJV+6X3, Adh Dhaher Al-Ayoubi St., Amman, Jordan','fJ-jMPq-RkGVIYAxS0MAgS:APA91bFM8W0njNy6H9_E74w7FcV8DXbmVQxKNzSgFGpA4HXwMrjiDvfogmmbB5CGgUnSvAkL5udQ80WMTXMU6Cout8aP9Zox1lYsNt6E4e-OZspslEU0-FYB_Z_zgqPl2kOOv_kTrcoE',NULL,'Amman Governorate',31.980721,35.944464,'enabled','1.0.13',NULL),(330,'vendor','$2y$10$B9c.6GdFkHV4Ws4mNWup5eXEWSON40sfc/0SyqA2hZEiEa99nrNu6','780990187','shalanfatimah@gmail.com','عماد','التعمري','2024-03-18 07:11:18',NULL,'inactive',NULL,NULL,'WWM7+8C7، عمّان، Jordan','f97Ira8RQo6eF6nQl8G2df:APA91bGW_IKftywWyezathbC7logUnkoke5HLF6kCxLw5iTdsqcTN9RM8LEWWuXf7eLC0BGwxkCDaEjwhNIrWSQ70gGDYYot790AiUCyE8bV9xA8RaQ9HyTN377rTbGtI2l4HSSU5ko7',5,'محافظة العاصمة',31.933287,35.913515,'enabled',NULL,NULL),(331,'vendor','$2y$10$ty/ujn49TzDjyK6CvECV8.2mO97ZnAxJ.ejk3ZG2oxoQEtoqLwrbm','799438911','mhmdaltmry076@gmail.com','محمد','التعمري','2024-03-18 07:12:12',NULL,'inactive',NULL,NULL,'Ad-Dustour St 98, Amman, Jordan','f7-9KVDYQcCcFXZjy_aVtR:APA91bG66d2DO2oCImpDF8YuCvpQlcpjvJanuUZZfKp3WkBsNu72fRNIJASc6q7cf0lPLYCieWRFQYSH81uOuKaJOT7J-0jY1owsYp3m4N-w1cwG-WyruS4vULG8scasx9wc9uV5PveJ',5,'Amman Governorate',31.933125,35.913360,'enabled',NULL,NULL),(332,'vendor','$2y$10$qn2aPqenlqCvYFIJ3BbH/u385w.Zp6DqQ4DZ6xxeLUH/UtQMa.zLa','795125980','dserf133@gmail.com','عيسى','محمد','2024-03-18 07:18:02',NULL,'inactive',NULL,NULL,'Ad-Dustour St 123, Amman, Jordan','d10HsyrZTbe8PLfWGbfjfr:APA91bGr5XwEaLnphwCFceS2wsGCSkh_FRv9CbCxPP4KYMTqRDUYbc6DhgFbX3wGEdLdxjAqpVeFIhUek3RigzHmshNEenNfGoWggQfAczOUTLnVPpUBSji4bFwhmp7S_3mxQzPX1o6G',5,'Amman Governorate',31.932633,35.912878,'enabled',NULL,NULL),(333,'vendor','$2y$10$OUs7SjnyZcZSdvTJrkZ2heUtboIkMLsEUbkQcJSMgWhIcQiTA6urO','786986169','altmryahmd801@gmail.com','محمد','ابراهيم','2024-03-18 07:28:11',NULL,'inactive',NULL,NULL,'الاخضر،، WWM7+559, Amman, Jordan','cVGbwpfsRfmdfkk7z0rYgA:APA91bHaUACpVjgow43CdQpyBhVVqGGHR1VxGEIn4pg0tZE7ZELqxThxO3WCwuN0WUQkECVbyqnMbFsREYhgI4b-iFz1JJ5Eqp99bwqaHDcAdmgfaqMZ1pLznFqVgRcbxducCKfi59ND',5,'Amman Governorate',31.932882,35.913035,'enabled',NULL,NULL),(334,'vendor','$2y$10$vCkgUNrIMG/yT2LuKks6F.OjAXD/BfyQcGPLYHeyXO.GEL8sCYeHq','799695132','tamaramobile5@gmail.com','جهاد','محمود','2024-03-18 07:30:44',NULL,'inactive',NULL,NULL,'حي نزال،، WWM7+34W, Amman, Jordan','e_L-kPz-Sg2C4soCBntlM6:APA91bF0FHWqkeVIL8rXo2LFUW4WmK92eLJ9HnRLs6QVqhzXxIb_5f7x3swWw9RZdtvzbbRpYaYat5KTrV_DKbqrf_r6xw9hvN-3lQDuAffmyMwyFBObKQOXrQBYNppas_1ivPJ8fCp8',5,'Amman Governorate',31.932792,35.912829,'enabled',NULL,NULL),(335,'vendor','$2y$10$1Z7FPbxRSvwfYZljpdQ/A.ye81yOVLSNNcVDqbqZ3iFWZAOZAuVPi','799698975','innnaoo90@gmail.com','حسن','صالح','2024-03-18 07:40:09',NULL,'inactive',NULL,NULL,'Issa Al Qaysi, Amman, Jordan','eQ21oaEzSRy7X0sAAfShuX:APA91bGkZA1ZvCgAvxq494WODiZ1ehG2tNpmRWhwezXL3x_xSy4oZGVxSPtun5KG1IHSURYX8LKLSZ2H_XSYX6kcrP6MlKmnDfpZ6uwIr_MsFsNYjdZbVSpyVre60ZxXWt66tb5mrkB7',5,'Amman Governorate',31.935525,35.918486,'enabled',NULL,NULL),(336,'vendor','$2y$10$cYmp2v2Y8hdFIKSODSQ.3unDU74fi8kymxNr3q3MZsB4pn4Oj6e5K','795801587','jcufkvhgh@gmail.com','درويش ','موسى','2024-03-18 07:47:27',NULL,'inactive',NULL,NULL,'الذراع،, عمّان، Jordan','c1_njKxiQSih6pjAI-u5NY:APA91bHCkky1my71p-zXmU71cfXeWo5VBNKkF-RRAUVUf8F5CASj9AB1qVQ_0srR6kC3Qt0gX1xheeGcugQS0rTG_Le6-FiPNVqxPjD5EYlPJnC7GrmQSEfE7DLOVUUV5MfhYpCZi5x5',5,'محافظة العاصمة',31.932891,35.913968,'enabled',NULL,NULL),(337,'vendor','$2y$10$F4r6oxkw7iRlf/EfgGQncucTmOqAuLjv7XO/uC.Ocj/OyKtJ7kuBm','789607730','ayoubabormas@gmail.com','ايوب','التعمري','2024-03-18 07:50:13',NULL,'inactive',NULL,NULL,'WWM7+7GF, Muhammad Al-Ayasreh St., Amman, Jordan','dMeOlKU6SBydUwySW1KfG0:APA91bEisOb_WhHJWM8v-Tuscenc9gC5O5R2RitIxJ8vbeQNeXtn3A1w11mwPZYP3AxMJX93j2uj_SJ-uD34cSjoJTAZfZOZc98Oz9jcBSEjQykOFGNziktBD2fPmclgD7CiyNz5GKrS',5,'Amman Governorate',31.932983,35.913865,'enabled',NULL,NULL),(338,'vendor','$2y$10$KN1KlFWZfQPXUo23WW/OSOaRlNT665KgRrYNf.SexUG6XvZ5uICQ2','796271127','ahm170747@gmail.com','احمد','الزواهرة','2024-03-18 07:55:37',NULL,'active',NULL,NULL,'31.939374,35.915767 amman، Amman, Jordan','dyracTnVT-uheO02DYZzyJ:APA91bGzfBtHTs-3q1r-JxTu4gloMIOwZ-lCHoFXDiy3Vi8mOWciWGmj0Re_zTnj0zfbAAdM2pB-eqq5weM4tUTOCx7U4jBi2hwEj8nya0qMA7s7M4xtQDf_z0KoaCVnvy7Kxxi-Qfgc',5,'Amman Governorate',31.939982,35.915313,'enabled','1.0.15','android'),(339,'vendor','$2y$10$pB.Tlpw1/Pkf1ifzSmn75uqTgRWgrNwXZUfLcBceTGiiw/tZnPb96','798226383','wdalbywy9@gmail.com','عوض','ابراهيم ','2024-03-18 08:02:45',NULL,'inactive',NULL,NULL,'الاخضر،، WWM7+559, Amman, Jordan','fTJtCyxFRGa30UA1ezNbte:APA91bF7mUs0SfGwjL0k0ELY0tlEtuWC9HOSnG2Fg1Yju8pNDcpkjRIau2bKlJizyKOg525yl6y4D5FNiAI3fvgE7Jy_bS08cKcLVtwpyeKhBHvjzhe8KllvlWd_l1RI_zrUYgp4mNlz',5,'Amman Governorate',31.932899,35.912953,'enabled','1.0.15','android'),(340,'vendor','$2y$10$c8XcfzdCq0BKX5pK8kX2NOB5NbuKa3/.HnWhTi8doXOU8H6H47eIe','796904659','jasrbrham@gmail.com','جاسر','احمد','2024-03-18 08:32:07',NULL,'inactive',NULL,NULL,'الزهور،، WWCH+9Q9, Amman, Jordan','fiYeWfsTQ5Cbl8f20Lg83t:APA91bH-rQcsqWDIjxUmdr_Qw5AmuoNdeceNeIXMJpiHtOVT-CiIesSli_DUncU2rgEiTJ_WlFmsFMXTP-iK8IJrMEvDaL7fmMyHDPdx76Vabx9VzK1D9Darse0SpIMMoHQv1KGwc-Da',5,'Amman Governorate',0.000000,0.000000,'enabled',NULL,NULL),(341,'vendor','$2y$10$Oz4QlS1WAroAhHNAYIP9nO896Z.5idvYgZHQ/niOQ3AF7HH0Zpzj2','799923077','naserabumosa@gmail.com','ناصر','آبو موسى','2024-03-18 08:36:11',NULL,'inactive',NULL,NULL,'WW9M+JFG, Amman, Jordan','eMBPRfWnSE-GcFqTg0fX8f:APA91bGSmkIlj64HQKfjH6spgqU4HlwV8C6qn7yqIGv0ZUw6xqEel-egNo73_25bqt7Tx9dz6lqi8kO-eEl8cmkdIEtl6CB5iT7Ym6WeKE0JJ6BOeMg-qnXGQN1S4oUK0ZvqZIKpO02Y',5,'Amman Governorate',31.919643,35.931018,'enabled',NULL,NULL),(342,'vendor','$2y$10$yYNU5kzO28yXy9qZ5GHgkOIEFSg7CwZvBQMYRv0OTU86rh1j5I6MO','796844561','lwjynalswyr@gmail.com','خليل','غازي','2024-03-18 08:37:53',NULL,'inactive',NULL,NULL,'WW3V+VH6, Saed Al-Qarea St., Amman, Jordan','d280osbPTUutC39SrH6jFn:APA91bFchZ8YEFO5G2NLb8bj4lfErjYWWPJTe2-JZsV35Bd5qm7-BxhI5B2vE2OW0prHH19_TkvHEeN3Eq64akAW6f6ltDJCjonrizwBUEoBqXJBzzWvk_h70tStP7D1WQYndd00dZ3N',5,'Amman Governorate',31.904426,35.944744,'enabled','1.0.15','android'),(343,'vendor','$2y$10$P6G50OJ.utUBAr3h2/Anuu4OzJn9zngxcBrypEp/PkdJ7m3xGhmCG','796044732','amenaldardese@gmail.com','امين','الغزاوي','2024-03-18 08:48:45',NULL,'inactive',NULL,NULL,'WWGP+22W, Al-Maghazi St., Amman, Jordan','dKDvsKpUSxe6csoZ0yqQ5X:APA91bHJy-Hra0h4Y0xvaAtP45wbi4iaNtLsJxPjqo6HtJ0fNQzMoMhhUJWZHx0gQscKoZjmZw17kuyJDBOKSXxxABzca2Eo9n5Yp8Nb5LMB799qf9bmhJ7tZh7fuff8FR1EDQmxEFao',5,'Amman Governorate',31.925393,35.935128,'enabled','1.0.15','android'),(344,'vendor','$2y$10$Oqu98XJsdkVe4qizKTY87.WJQfzX3612QvBLcsK4TMbGk.cUhgPd.','795412485','jh7697755@gmail.com','جميل','حسني','2024-03-18 08:54:36',NULL,'inactive',NULL,NULL,'WW3P+VWJ, Pr. Hasan St., Amman, Jordan','cJKy0JssTqSsMslAV5zSBa:APA91bFHPI6ho5BfcQj9pveLKhwuq6dXDoHIyqk1yJXPJuowa0EFBqvS-beRBODJwWlrq9bl6rGGl-0x06SMdTePlnCjRae4XxZ-wddIa_oFhJXBcpCMGSXTtzTb_2NHzoGq4KOAMHhP',5,'Amman Governorate',31.904536,35.936889,'enabled',NULL,NULL),(345,'vendor','$2y$10$l3s4k7nTUN5llmz53kbTXOSkMRDP8fC6KhvE4KQc8e1ZctiDp.Imu','796414427','munerabuawwad@gmail.com','منير','ابو عواد','2024-03-18 09:06:55',NULL,'inactive',NULL,NULL,'WW99+6M2, Amman, Jordan','cFM6ICzHRpipnKdCga5Tus:APA91bET9QpTXHKJPoP5EXETaWN14fipwxe_Rb2SYVQOHw0hrtr64gBSQsVswlhcj5hOZ8TyGVu1t_tSk5ZYalMUQSy_RM9kKzHX13Jorw8iivj2Y94XBWzAtwYhAanKKwgEC7GNpDzl',5,'Amman Governorate',31.917757,35.919689,'enabled',NULL,NULL),(346,'vendor','$2y$10$wEpiIpxGkM0BdxZ3bl1LKOGpkjoseCiSyqsB488X7baKR93CUQJvW','798525914','ahmedalzaatreh466@gmail.com','احمد ','الزاعترة','2024-03-18 09:14:35',NULL,'inactive',NULL,NULL,'WW9M+JFG, Amman, Jordan','cZCLnjeQSCGjLtlnAJXtiI:APA91bG_BMdFpt4-c9I4qYHyBtjUdXYTXx-8IXF19PmAepDpjv9xR0Dbi8YVizNBNvAPSlya136Tj7MlFYD_SS1byPHIrMV9MxCyD1Docfy8108FUygY1dt-5-kENRegy34TarBXs5RY',5,'Amman Governorate',31.919837,35.931498,'enabled','1.0.15','android'),(347,'vendor','$2y$10$3M3S8.A90CeP264RVF2jxOUICK8D4wYlspwLQHE9ANFMWPTKplzeS','785319582','mohammadabogharbie@gmail.com','محمد','ابراهيم','2024-03-18 09:20:31',NULL,'active',NULL,NULL,'X2RF+5C9, Amman, Jordan','ffR_37iLTBiRoF9sjojtww:APA91bGP-LnSsk_oNdpgesgfIGjsrCYELgGHt0oqoIpbyoE9xo_h5_aUDMqdFVlyO7w4LkKgzq-90FkaKNIng-i4EtUaFucCqlSS5vXFHAvC_CBFKGQaHZIpPHLVkZ_VfQrUTDNyJto7',5,'Amman Governorate',31.990443,36.023669,'enabled','1.0.15','android'),(348,'vendor','$2y$10$RRw8n87zxIreTj48VYOeW.7MOuNr1LdXedQSUxHQ30x4BrlbHmHVC','795589405','headm9598@gmail.com','عبدالكريم','جابر','2024-03-18 09:58:17',NULL,'inactive',NULL,NULL,'Ghazwat Dawmat Al-Jandal St. 1, Amman, Jordan','ckBhKPO9Qwa7CI_lpRWyqD:APA91bFulLQx10RtgC2zB4fTh7Ghjd1HYDzmtGti-9LSjtqTJQS9i-vwXxCkVGx0tj5A7veondwciPFA7SmxkhXbKbaU3imOZvysX9_tuI8bdAym_RwRS_aa1uFu4k_Bdo80uP54HHEV',5,'Amman Governorate',31.921792,35.933692,'enabled',NULL,NULL),(349,'vendor','$2y$10$24/Cb5gFYk2q4Rcz/SRrMektVHLJYdhlP6pkTP6gG.2EsAU3Nh2ru','790956193','asmaylabwrjb570@gmail.com','اسماعيل','ابو رجب','2024-03-18 10:02:41',NULL,'inactive',82041,'2024-07-06 09:18:08','Khawlah Bent Al-Azwar St. 78, Amman, Jordan','caFqIhr5QLi0dWAfevEX4E:APA91bGgzJxOdB4AqtGfmIdkYyccWRGTM6RhnuhXMuaNVBIljcgeC9O8QcC94NbJaFCJ-eBRFdTQHO6SPn9f-0Ycj9fV5vAP9zaYafCV_BTMAzg2PxofVFG-nNcB1qtrw8o_CmBkIxyl',5,'Amman Governorate',31.922317,35.934111,'enabled',NULL,NULL),(350,'vendor','$2y$10$50Pnc7ZQdfoM3HmDn4DI1Or6HTt16UTptIdDy2y/hkq4ciGAKysAC','795812684','wdhfras@gmail.com','فراس','عودة','2024-03-18 10:47:25',NULL,'active',NULL,NULL,'WWCR+CHV, Amman, Jordan','dH9Y4ApiR2y7xzvqdDTg9e:APA91bHHzAfYLx66Xp-MO_3zjHrCelmhFPkHbGyNXYC2cR6fwjvUnkuu0KnLATtp1DW7WVnqYoUqvmtZ0KiutlsA-KRbt1045PZYvAql2FacfEdnk2IV-Y8HaAwQ4i3cjFHGIGpqmcrn',5,'Amman Governorate',31.921536,35.941813,'enabled','1.0.15','android'),(351,'vendor','$2y$10$q0x39/jyGiOfMSscA0VWY.mZahV/gTbQ7xOMhK8KOgKgXpDW8FY0W','796141900','zaaainnnnn1234455@gmail.com','ماهر','العجوري','2024-03-18 10:49:19',NULL,'inactive',NULL,NULL,'WWCR+CHV, Amman, Jordan','fpLtXu_kSlGzpTUE5GbAk0:APA91bEQ6G4sf7vlyXQyibiI4JURu7levjJYrQ5Xb6vSZ7kh-URL-TDo_CHMpYwPekWERbxFzAsDdOytOakqioEDbTcu9NrYuWcc2G1iiB01v_5MWTPRtJxU1p35VdS5QJiYa9qUV_tj',5,'Amman Governorate',31.921732,35.941138,'enabled','1.0.15','android'),(352,'vendor','$2y$10$SsNxbEoAEs5DWY4aN8niEuae9oU/2fEoZpsCJdDApqFhEuAyg.6eu','791565209','ayadm1772@gmail.com','اياد','محمد','2024-03-18 11:09:55',NULL,'inactive',NULL,NULL,'القويسمة، عمّان،، WW8X+V68, Amman, Jordan','fuQjZgjZTyKOQDEFObrccq:APA91bEns14b-gvwV7PA--0hhw5m2SKiXosdkxtzvT49Cv8jcykYd96vje-cfVe2DQJJIIdfNfqO9TAdYusf_yONPjzLdMu64tJifswDR4z_ItiZLrgwpc8HaGA9CEAvYy5bVhTT9YhW',5,'Amman Governorate',31.917223,35.948074,'enabled',NULL,NULL),(353,'vendor','$2y$10$nEPPnc5HEDHKH5yPa3tDiehB11Eq68eTQ7iTJfCpOBqv.s96pbXBS','790646026','helme07906460@gmail.com','حلمي','الحسنات','2024-03-18 11:35:10',NULL,'inactive',NULL,NULL,'W357+XG Amman, Jordan','ePJCqUTUS2i0Xe7xgI1Wba:APA91bHKO8Y6LR6OsAc8y07XEbcTTV-Opdvzw0IlQnpP1dTtLv8YUylttA7GHq26SDmQ63_EOoLjMD0ja20bhszHeoZNyDjYz4yHtvfPB9iocbGLSUIkiW3sqlFAtFRu5xMAVGvV-C5g',5,'Amman Governorate',31.909970,36.063832,'enabled',NULL,NULL),(354,'vendor','$2y$10$5gTstuR5aNpEx5zVSLE1He5xGntm7lzSPWWBeqHj/zlMIguP68Lzy','795632883','mahmoudalqadi9@gmail.com','محمود ','حسين','2024-03-18 11:35:48',NULL,'inactive',NULL,NULL,'WWJ7+J25, Amman, Jordan','ckJFY-DSSKOt_Z0U9CNBmS:APA91bErpY9rV8tzgYlbDEUgKQV0rnexgAwf4p1yWX0s7cqTY5CbCn8JOqVn62lnAJ6CXwhrD42xvw9aD0tMvB0pICvytdx_abq6OIG8N6RsKheLymQ0HVp2z5Pk7QVQTpymBXybP98k',5,'Amman Governorate',31.931385,35.912620,'enabled','1.0.15','android'),(355,'vendor','$2y$10$yoa/i1KMKxq.h70XHdoWKOf7MmAktrHpwbJKXugbe8yJQvrLiNp8K','786366231','mohammadqutmosh0@gmail.com','محمد','عيسى','2024-03-18 11:36:49',NULL,'inactive',NULL,NULL,'amman quaismah, WWFV+GGC، عمّان، Jordan','ck2FdBJXSFWTag1BuCPEbN:APA91bFkS4J-xTbMkGBYbuFpavU7H1bDpStQMI9G8FcQwra0UX3FdhBl0WQj7_JH273P0N6uScswMZ0bjEGYSMje15Ph3aeWPC7LimIPQwVBtFMfg8_d95yd2zOnuUt_K0CTI1QnlrUs',5,'محافظة العاصمة',31.924041,35.943653,'enabled',NULL,NULL),(356,'vendor','$2y$10$baGDhoYadDmD1KOA77slOeqA3mGPRF7FjlZ6Sr4XHDN2Z8xlpVlye','796310419','mom139951@gmail.com','محمد ','أحمد ','2024-03-18 11:38:35',NULL,'inactive',NULL,NULL,'amman quaismah, WWFV+GGC، عمّان، Jordan','fz-ML9UaSKaoKoxHyx354N:APA91bFaDwss2UjpN66PunnwDCYpM5YqIdSP3Yasjlnlm04TL_fferr1rGRk-HRtoAhnyTv_Tv07nxOKUhiNi4Ict2-Zvjf5VOdYenyYYmjE5HN1Rsk6xwxGEhXsdsMo9Utw4jY8kAkl',5,'محافظة العاصمة',31.924088,35.943430,'enabled',NULL,NULL),(357,'vendor','$2y$10$PoFUz.Acffj3z3yirOFCNu3AzLrc1orLwHPkq3N26o6kYsLKeKh.e','798502935','ahmadyassin77ahmad@gmail.com','احمد','الياسن','2024-03-18 11:44:43',NULL,'active',NULL,NULL,'amman quaismah, WWFV+GGC، عمّان، Jordan','fUJ7sebIR4aqM26ZOTzAj3:APA91bG8iCgSLVZTL2fAaAaO15h6ImxWhDhOWws14liFWcAwKklMp4pNue5pE0paoevCHIRAjkwSO4F4Sc4xtCayzZjVJuVtO49WPV3CorWhcecMzWjIntZr1YIKcXqboSTe8BhF6Him',5,'محافظة العاصمة',31.921426,35.939058,'enabled',NULL,NULL),(358,'vendor','$2y$10$.hIzrlyHuGmKh3jZPIkpQOmnrwvT0oYQ5fPpl5ECDnlafGpmYA5hS','789795524','a7medosh2@gmail.com','ahmed','thlejan','2024-03-18 12:11:16',NULL,'inactive',NULL,NULL,'البيادر،، Amman, Jordan','cKj2oSCETry4REJ6kCeiKU:APA91bFf8N5Jh9-AmHqq_lWL_TMdYLJ36yUc7fU_c1BK1KBepOjLabI7D22AVPU0vMItclkSRH3v0Y5nbcISNsFvecUzRKa0ZSAKFcx_6RohlS_ZLFibv_EKSZqyAKrw-WCivwZc0g_9',0,'Amman Governorate',31.952482,35.822471,'disabled',NULL,NULL),(359,'customer','$2y$10$/LnS5wD4quGYSVrvoOREm.lo06NMX80bGlIevrWC1kBrGMA2M8b7O','781102072','daldebsi@gmail.com','Diya','Aldebsi','2024-03-18 21:11:06',NULL,'inactive',NULL,NULL,'Al-Haram Al-Ibrahimi St. 18, Amman, Jordan','cZyv6K6OIEvzogVtr6pqOR:APA91bFy-vh8ePrLVIPWlhgIa9XwwL1RWCkGTwrCzq5_MF5h-n1GH6OudS-jqYmgtLlB8ZTFuQ_ZOLyXIm1VZZeZo74WcudCrvxdSZuF6l7vbICll9FsiaY85wmPW9oCW4bKghasbh1o',NULL,'Amman Governorate',31.915761,35.931193,'enabled',NULL,NULL),(360,'vendor','$2y$10$rFl9PEJMeodTnA6Xp85D9.AmP1SaWcn6AhGoGYDsAQp4R1N17Da2K','796040303','0796040303sa@gmail.com','سليمان','ابو شنب','2024-03-19 08:15:39',NULL,'active',74703,'2024-07-17 12:00:07','Al-Urdon St. 363, Amman, Jordan','dYekAg8vSF-kot-usb21vZ:APA91bGTdrpELZZkR1n5DSCFphBxBERZ__5vgXhpnBEjt8rE7FLKlu831wAgMCpzMrgDynqgkW7aTqtJYe1FtQV9kZFkzo3EJ0Erz4CceUAUj_LWhcn2S2jSw4HMz85GFqAtViCBoyBC',5,'Amman Governorate',31.968903,35.926839,'enabled','1.0.15','android'),(361,'vendor','$2y$10$A/5HDbPXUgSuAw/Ch05yEOoU5hqnat37llePA3RyXHXuzRVyP9Ida','787528042','saed45258@gmail.com','محمد','غوشة','2024-03-19 08:58:07',NULL,'inactive',NULL,NULL,'Complex No 6 Sufian Al Thawri St 6، Amman, Jordan','d-PvbWymQgaTtHpmpeeTnX:APA91bFwGvqeWjM9FMZBoWPnULg1esAaFytcZf9RiwCZ9LtDfsgQpNiXjGkSS-eVrT8Eax757-Y0KKKjfY3owPo00IBFJQN3VSizdP7A5qWNc_G8lsE89-uazKeZ0IN508jgS3KfW81_',5,'Amman Governorate',31.979839,35.983346,'enabled',NULL,NULL),(362,'vendor','$2y$10$Pdm6kqt6dluT27G1s7y9PO.XK7.28URLR2NhAaPykHSwGSQVvxzB2','799314170','alialqarioty123@gmail.com','علي','عوضالله','2024-03-19 09:11:51',NULL,'active',NULL,NULL,'VXXG+MM9, Suleiman Az-Zaghloul St., Amman, Jordan','cxqS516yQa2yEh7whPsQ79:APA91bHiz1SJ8aR9l2l8zwoLJrc-9hRcG8WlVjNOvKYWvWl-z-7vcMbfk2Utx5ptv7Bj3BJwm_D-6U6lyk_8vez0HVUY55whhQUp5hrnbGwdpJMLm7ItHEk-c_oheTs09fHxNfftJsju',5,'Amman Governorate',31.898728,35.975506,'enabled','1.0.15','android'),(363,'vendor','$2y$10$9N4V6tgNGULFekzGNlozQ.8o9yM4YAsAQex5wQR6AGdCqTuEERRJa','795158671','eahabhassan96@gmail.com','ايهاب ','يوسف','2024-03-20 07:40:50',NULL,'active',NULL,NULL,'2VCW+GM5, Amman, Jordan','fiPEr59uTEyJMMlLkX5Axu:APA91bHInhJRyu9Opijs-z8E_ugIAmFStiwQ-2k_oe_zXEazng5T0joUCfRot7Fadc_HVp4n9uOlk0p059d-PpUiSl994onn-cjRRbBr-j4uElz2_-er_W9zhPlLt33KdRInYR-BlT5j',5,'Amman Governorate',32.020848,35.897141,'enabled','1.0.15','android'),(364,'vendor','$2y$10$MqZZwReWVRQgmlU7woWEXe2dOXRdTbj.V3k3Q7.yGzSISdttc4qu.','787120652','thaerabuyehya@gamail.com','صهيب','عماد','2024-03-20 07:48:08',NULL,'inactive',NULL,NULL,'XXQP+625, Amman, Jordan','fhqehE5JTJey0LMsm9fy1U:APA91bEyrHBzKENy7o1WLhFuXhlI5smGFG_FMTIdbJqMAlapM82NioYzoZ93QmK_S1WznGJGK-fSZ7ix6xQXLztpq9KspaM3xJeIef5vWNFNy-7DqH_KNq-CygwA68E6ZZmiwHWQ0MwN',5,'Amman Governorate',31.988622,35.985476,'enabled',NULL,NULL),(365,'vendor','$2y$10$L8fZi/bZRzZHqq8sE.sc8.1Hj1lJqdr/MEALEaCnCraSAvw.yRXVm','789465193','alsbawa984@gmail.com','محمد ','ياسر ابو يحيى ','2024-03-20 07:49:38',NULL,'inactive',NULL,NULL,'Prince Faisal street Amman, Amman, Jordan','fuD-djDKQm-454HcWwUJ_8:APA91bFKDUopybg0hwOmhGsEJlTNJNxETgHUPcexOXc7LslbBAxHzCZ8Oe2CYANrTTUGmciF-olDcqbiqMlly9JaLapR7d8dH7yamjadcRq4IxlWpGNzno76LfcIPLGa7C0CiCt4an6e',5,'Amman Governorate',31.990285,35.976834,'enabled',NULL,NULL),(366,'vendor','$2y$10$Pe.aVTU9rWQ55aDLrWmeC.pWPCuKSypkNvaD8M5dg9ng67x3dhJkW','791428552','jwadabw29@gmail.com','خالد','حسن','2024-03-20 08:34:13',NULL,'active',NULL,NULL,'Kaeb Ben Malek St. ٢, Amman, Jordan','cILG64ZCSiCc8IfdUBBIgu:APA91bGQbEvez68NFPYwd9xucHg2uXwM_yVmPTdadT14g9L15TMumUf8bT5mH4nuj1O-btbE_M2e6N7KBXVtLBkB6X60xmIJFd1kmReVFO5UzfsdxOd4q1uvBIH8hOS6g-07e5jVpkSf',5,'Amman Governorate',31.987889,35.923875,'enabled',NULL,NULL),(367,'vendor','$2y$10$.wgmZPB51ZzxchemJGG4LuzAXUIqVIFXloAg7yCqjcH1ywsZJs2VG','790366892','khaldalmdahnh7@gmail.com','خالد','المداهنه','2024-03-20 08:35:39',NULL,'inactive',NULL,NULL,'Ali Othman Commercial Complex Khalid Bin Al Walid St, عمّان، Jordan','dXrjorwISfWbQt2PvEvaE3:APA91bEpTl8YpMErOOvbeiYbB8nMLGJiIX8F9J_M5whqxClmsdyA4Un0n88gSwnsHrwjcMEecDmVQXnOQORYKhzJveEDywSrL5_JVcZeJez_7oyCbIZbsXeVmnSTv7jzb06oonaSBBJ_',5,'محافظة العاصمة',31.967463,35.916658,'enabled',NULL,NULL),(368,'vendor','$2y$10$F2oT..JWeqzbQaaKiMBW9ucDFLGiDDNs4X6jx9gZPHOgs/olmyABG','777846977','malkalgtawe475@gmail.com','مالك','القطاوي','2024-03-20 08:39:20',NULL,'inactive',NULL,NULL,'XWPF+XFR, Amman, Jordan','fe-U8OiHT3qI0ZJo6PR-wx:APA91bE2uiP6_UPKbWWXUpidlii0Pm4TNfKpo9QVIeV4wh7MrIcYX4c_8ndqfguKZeAAnKz-r5dRNEDUIPr6QxOjAg-LE33Id36Ry1nC5mPzmHdJHMJJ7kr4dUgppZZksheMu-C_xF2d',0.5,'Amman Governorate',31.987510,35.923563,'enabled',NULL,NULL),(369,'vendor','$2y$10$N8HguSPp.NWQJd8qwBrgNeuXc.PhJ/ZeyTosCza4rKRKXHb60amPa','795426103','zalabadi929@gmail.com','زيد','الشرايعة ','2024-03-20 10:04:30',NULL,'inactive',NULL,NULL,'WQ3W+GVX, Amman, Jordan','eyMt8HkBRHiLnptopbpUTi:APA91bF6MDx9YCILkTDsnqPCRl_V6P6hGaYzzvw4PpKmK-E68kZehnSYA-_CYUHqG9aPS9qOJNNs6KbkkhtchFOCB_W1pnb8FYNAF_4o9-oy1lBpc-fmpZC9Ia7nkJNdZK_fCuJjTTqO',5,'Amman Governorate',31.903086,35.797923,'enabled',NULL,NULL),(370,'vendor','$2y$10$EEfSWrVNWwCdQRGW5zIroOzjno80Gs6uaWfryTPxK9JB0efPFTmAO','797355813','rademoham03@gmail.com','غيث','المناصير','2024-03-20 10:21:54',NULL,'inactive',NULL,NULL,'Q. Zein Al-Sharaf St. 23, Amman, Jordan','eSTbXa_7R5GZXATj7N_Vcz:APA91bFXJkiqheZfMuulOC51Yw--lwuhyORcefuc-US-6sQ8t8KWBn9QatHRkV1pwrcd9GFYwbYdXUqDBb3swDSFt4cgIeXSgf6H0IXXnxqfyXU0lQsYPeGjNijiTY863e7Wh21-Kk84',5,'Amman Governorate',31.946859,35.877860,'enabled',NULL,NULL),(371,'vendor','$2y$10$o3pRa4hv8uHNKNCdGNURg.O6TY5s75U6.wW6Xpm12DIEP22F/S5hW','779808019','ahmadmanaseer902@gmail.com','احمد','المناصير','2024-03-20 10:27:10',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','cgH4CRuNSUmhcvCLFjUEPb:APA91bH-qPJmTISaITKLuMaxurjIDMtdLvcrJPXQJ3LvXuU-5Ci1kb7kV0nUX22xXpoP8IMYuizD-rSmayCgfsQ46FchGcJdCJfS2Z5xz22acJwfv_MKk_Gc1lpcQjy0DKK1lPGi_k7Y',5,'Amman Governorate',31.904752,35.804000,'enabled',NULL,NULL),(372,'vendor','$2y$10$kfns944N90KvPUzJS4aK8.0sGtLkvpLKhoqWEFfWIQ/nLHdTtaVDi','780541388','hvv255235@gmail.com','احمد','العراكزة','2024-03-20 10:33:51',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','etEq79hxTKW79eTzc4Bk86:APA91bEZlzcvEneqPjaiCHpkhSI1PLSc4T_qi-Hl-ROG2Scq7mWPuNakZshVXLwEzvfLPJ_7eXOl67VLA01kUXZPUY7Sr_Zwg9FKnHepuGk9zTiunNNoo_0mcvU9dz-lSVvbzcfyduiR',5,'Amman Governorate',31.903431,35.803996,'enabled','1.0.15','android'),(373,'vendor','$2y$10$j8ay8z4DVvlEwW9xJ1GddO2BYUNFpnYQcqAPN22uiNLteJVdtIwyy','795275033','gghfc111@gmail.com','صالح','عبدالحميد','2024-03-20 10:44:03',NULL,'inactive',NULL,NULL,'Othman Naseef St 47, Amman, Jordan','do0_XxnJR6mQZOwIB-Ph7i:APA91bGFo18rv4VsEx3Wt8zbD0bHLIwc2l-6XHDsWSHIxz2aG5ixdkS166_CHlBm5YcS48gEdCXdPn_lRyjBFOtBjQfL_pmfeihaKeOGPYJ33q5l61PZscz7cNAqCSkzkrxPJdSSLQKJ',5,'Amman Governorate',31.889119,35.869642,'enabled','1.0.15','android'),(374,'vendor','$2y$10$VJNObTn8iBo40..20Aa8WOhsAFhI.Q.XDJNumkR/4Y2zU38xIfTMK','789356699','54543hyhy@gmail.com','عبدلله ','احمد','2024-03-20 10:44:14',NULL,'inactive',NULL,NULL,'3RCQ+XH الحنو،، Jordan','cR2zYlz8TQyMUBYv1tf9UR:APA91bHCv_OS_ISJG4ZyQ24FnBDV-P_LMaYMTlWcbT9aASQlfT1LkpqkMFkrUFxFvpPlkM24vmtyXOXUlOs9XFvZ1XRfr9QrUakerlNyH7RLKV2MCiwUZqhsFKIKNnS8EAB7yNZGYEEz',2.469,'Balqa Governorate',32.072327,35.838922,'enabled','1.0.15','android'),(375,'vendor','$2y$10$O9l6j17hh1W0CSAA/dQCCe7FNbCOTlO/Ac22HXtJIueeUYwnH7vE6','777968391','byanbyrawy4@gmail.com','فراس','المناصير','2024-03-20 10:49:31',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','dqbQgMz6Rze5zbV78E3p4K:APA91bGbPYnZ0NKcjCQAIU-lGVcA-saUpiLZkYNfiDLCRHxuGV1e1_mCN1qPZra0_K1MCzZO9znzMXoBbW97c7ZniZYM9Qw-QgMLO1FrpPF6VY3De6Jm2ScDxeig-HofuGNd0HCAT1qS',5,'Amman Governorate',31.904800,35.804738,'enabled',NULL,NULL),(376,'vendor','$2y$10$9/bzzNL9WjCwmOJrA8iMrOF0lEU6hwG2tioLnM1JyUI0i62A.F2au','787446403','raedghanem@gmail.com','رائد','غانم','2024-03-20 10:49:33',NULL,'inactive',NULL,NULL,'35، Jordan','c4p7wRumQjud487LtOQOYp:APA91bGSOImTdA0fgvbqBtFHP6FR9U6kRYWgSvLzz-ZcxoaGCaSMk-l8PtqpZkl-9W7TxaqtMBRUsqwB5Om0Yr3y5qdPemzLWckp8wh3qrFx-lz8-DPj1_hD9Zc0IptKS9cbCEcvcMFe',5,'Balqa Governorate',32.064100,35.839033,'enabled',NULL,NULL),(377,'vendor','$2y$10$QshjoJBpYuSyviMz.20pLuU9HRTSX0PvPYFgQ6cUwypDszei2i1jW','789206383','osamaabujoumaa@gmail.com','اسامة','جمعة','2024-03-20 10:50:18',NULL,'active',NULL,NULL,'3RGW+J8 Al Hanou, Jordan','cTAUq-UTQ4ayDrc5nW_Url:APA91bHWi4RCUtIV0cQIrUGUuImj2oz3VJA2u1hxPJMk3ysA_8WgYZhVayZF6CGkhTPGgDTKNSuAuEmN-sRfJgrRId8G5wJDAKZRpObCx5lPLSyahO4itAgLB-czg3M_v0TAPMduIhpe',5,'Balqa Governorate',32.076612,35.845852,'enabled',NULL,NULL),(378,'vendor','$2y$10$NSdERBlg0Rm8zlEO.xCAlOtnMYS7LQpqJsbXiZVk.0pbTh1ndVtQC','785540191','smsm23133@gmail.com','احمد','ابو حلوه','2024-03-20 10:50:24',NULL,'inactive',NULL,NULL,'35، Jordan','cxevDSTdRrq8thUX-9UQjZ:APA91bGoJWgl7jYH-13sUgglfBpU292B-ZHyjsER_02tSAoKGneL_BVO9JmMbs9VxR2sYp3lNWsSqVne5PuaCOcl5crZY8pixfCxK1sVnrqzR0895UhGC1af9Mrr8zYjV0SuFbFs3Z_t',5,'Balqa Governorate',NULL,NULL,'enabled',NULL,NULL),(379,'vendor','$2y$10$eWbnKKjmXa0K76XW2MjN8evhv0V/ERVFPcw1h26FmW2O1JRSn.kZe','787535095','mwydashqyrat838@gmail.com','مؤيد ','شقيرات','2024-03-20 10:56:18',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','fRIAh39SS9yP5mpn9AqM59:APA91bHis9UepRdQ0jnBLLUWisLFvnA0K50zf4Lh5a0LbT8Uu6vgZ1GED3oVnhLNiJtzwsf2e645BQ2IjB4vSpYe0oY0l2p1rnTQl_FsKHhybs0XK3mFOVv5muzIb2VHYTqYRjSKVzxt',0,'Balqa Governorate',32.065013,35.839267,'disabled',NULL,NULL),(380,'vendor','$2y$10$vvKHAIxP9UT2Q5mo7phwCOS1AOb68mPqCZfxGvl7j4dJzbZLfLjem','795705220','jhahmad366@gmail.com','احمد','الجهلاني','2024-03-20 11:05:59',NULL,'inactive',NULL,NULL,'شارع ابو حلاوة 2, البقعة, Jordan','e1Kmbr7RQiSbc1kvjUkys-:APA91bFbGm9IMjDP5MTUYtZQ-BvZk2K_TORwU1fLXeHeYlo95jh85ixZxOAlVx9UNC4xY43FTlmWXW-YH0n6TMQ-5EOCYWNWR_e0frHRq9_FcKxeEX5hrFR74VRVYUUbmAdg4WYO14HS',5,'Balqa Governorate',32.071508,35.840048,'enabled',NULL,NULL),(381,'vendor','$2y$10$Wl5Ns/l2IjYdBY2cmdpTbOiUiNNGPkqUqwCZE2Brr2MFKW.A5gpRu','795916736','yazanclip663@gmail.com','يزن','كليب','2024-03-20 11:07:00',NULL,'inactive',NULL,NULL,'3R7P+3X عين الباشا،، Jordan','fDlhIfkwQS-xiL9HoTyvv7:APA91bEgp1uNKydjnCSQT2snKZZw9blhI43krOVWdj8cSwCU1qTLQekngKzJixm5Dm9N7AhTYQTg636JCFFSHtvRuixfPeWeb2AB0Edm_jsibfFxQihJiDjKknQ_SONHPx_6kFXEyVw-',5,'Balqa Governorate',32.063048,35.837837,'enabled',NULL,NULL),(382,'vendor','$2y$10$mk7x4zmk9.TZUpfrqffaC.lquZW7tiy1FTWSLWCUYlLFpZkGkyase','776115789','alrakztb@gmail.com','عبدالرحمن ','العراكزة','2024-03-20 11:12:43',NULL,'active',NULL,NULL,'WR74+W2 Amman, Jordan','fgn-I3HBQfWB0GrRX-Plx3:APA91bFYCnvE5vVlllnf7mG8fvYphn2sVjx6TOt6WOPQA5SqotAxkwGP4I6_Xk0u7DaS3NypFLgyqZLlwP6JPVWXQDXhv2ni8MO8Ea8NTHbuXfmpJNLbmls4p1It0oMWdPBKSrT63y8x',5,'Amman Governorate',31.914865,35.805024,'enabled','1.0.15','android'),(383,'vendor','$2y$10$59WLsWbMzkeHsdZ.I84KSeJ0.cnFljT2tDe5udwxe7XWbJcv3SlOK','797534269','almnasyr001@gmail.com','اياد ','المناصير ','2024-03-20 11:20:57',NULL,'inactive',NULL,NULL,'VRRX+XPV, Amman, Jordan','elOpKHFQTd2va_Wpoc-ciz:APA91bEhqd2obSvaZYhpl4qC9o8te7Bk8pn4ux3IugE9nucchEaVyOQ36pYzouXs2LnqgTkx9rmafLn0jQoV6VOgf8wA3w2xA-sbWtB24iXUEVx7KWKrziWygg0C-5nqanmj6OmsmpLR',5,'Amman Governorate',31.892632,35.849377,'enabled',NULL,NULL),(384,'vendor','$2y$10$twAom5xc9dzB6A08gJbYbek4PvNTg7UUku082ga6WLRp.ggdfA/5y','796503470','fhwr99671@gmail.com','يوسف','عبدالله','2024-03-20 11:24:26',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','cUF7CcSQSRukVAXhLiIdwm:APA91bGlih8Wm03S7nZP8dpsZyyp2Lo_3rWXnXBY9aBUZu-5WCveHjdLl8B5OyWU4HdNLgkUoBPNIfQSun7m00fF5DF9EYU0ImGHMIXP8x0JRvRJLvSU72oLal3HQQ1-KH2H34dD78tL',5,'Amman Governorate',31.904818,35.804777,'enabled','1.0.15','android'),(385,'vendor','$2y$10$JYssz0aE433NVulhG6eX6ujDgXTSwZ.f3dW4btktv3sTZvPEeEPWa','791474203','dhhidjdbh8267@gmail.com‏','bandat','sameer','2024-03-20 11:28:14',NULL,'inactive',NULL,NULL,'XR2Q+Q34, Abd Ar-Rahman Al-Husami St., Amman, Jordan','fG77UYpATTCQJcKPfgzQG3:APA91bHrRYMdVmcD0EbmOAwAZevZczqPOEA-tWoffDs6vqFc2xvokW3ALJfTloa_jIpJpEXOeqp9rA0WaaVqp51JgxgomJdiS7P4byxZzJFXz0997EAHz-9X7yEHVq-Y5d69lcxJVbCq',0,'Amman Governorate',31.951863,35.837550,'disabled',NULL,NULL),(386,'vendor','$2y$10$v4m5YUIFW32fnhyoGajnAOGxpyaUH5noCJ7StVag9PlB0SuIh.Rmi','795758316','alnjrshkry@gmail.com','رائد','جمال','2024-03-20 11:28:59',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','dsXZtMlhTc-tAHk8u4gakZ:APA91bEaG_WejdWTWfCehZfj7zPpms9rYAkLkTk8NMjHOa3t77ty6AyCfNuLGpjCtoV9MC1uY0Mqc0JuMCZRvMioGi3lfnPbUMz0_0DcEpM62ylPRQErEztS2eiTZjESfxYjOrvWaL1n',5,'Balqa Governorate',32.064940,35.839145,'enabled',NULL,NULL),(387,'vendor','$2y$10$NyFTs0Cg3/xbiboSAbBqHu9JIEwJ6odoGiByHH7QSdAK9jCK12LQK','796809521','asreewppbbvvvbv@gmail.com','عيسى','غنيمات','2024-03-20 11:33:28',NULL,'inactive',NULL,NULL,'3R7Q+RH عين الباشا،، Jordan','e7zWbeFUSyqEUF2PBA9Qnw:APA91bHmvqvH0AN5jYQMWw1JwX7ohkm7XLXj4MzuRbuSUZLJO3ARwKFz9wM8ceCfxH33R5TkPtFXpEetNVc2T5_xjtFWgDtWx4Vqno8pRH7YP4hiw2yaQlw_ElSA-DpQSkhIQs10tBpg',5,'Balqa Governorate',32.064405,35.839053,'enabled','1.0.15','android'),(388,'vendor','$2y$10$9NGwBB8q9aLL4D.w5cO.NOWjYFjms0nK63hK6ijayMn10licEomjG','779567243','alaaalmanaseer851@gmail.com','وليد','المناصير','2024-03-20 11:35:59',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','cr6M3wdFQNaI3S8PlME98J:APA91bG5_UUHIogIM0ozJkEBIOLcJEKM-WTZVqgW6Ys-jvArhoER6w76JBeda-pHxPqUmpqCx0SJHFdy3kLhYE03ahbMypS14gUiM-G-ndaMjkkupoCJN3AC9dQRXXjdwt_8dQmfDTaQ',5,'Amman Governorate',31.904872,35.804659,'enabled',NULL,NULL),(389,'vendor','$2y$10$xwO2o1pQgI3ebyGO4ZDpSeuf653/bu85NnwoMFr.Jw529P1lNkLT6','777006873','asemalmanaseer3@gmall.com','عاصم','المناصير ','2024-03-20 11:36:23',NULL,'inactive',NULL,NULL,'WR53+W8 Amman, Jordan','fPNJf7VET_20j36pNikjs9:APA91bEfKTSVnutrp8ffHcsiYLV8mkaTqJbgvyJXen922O-WRMlg9z684l-Kj0bSUU0CrtY8PSi65psROx9vte19bNKuMnfCs-ZWjnR-6gF4ujenw5AkTr6IMEnJJ5A3gnNpdakwGnEw',5,'Amman Governorate',31.909830,35.803273,'enabled',NULL,NULL),(390,'vendor','$2y$10$.ejb3AllbYM9jGK3Ods0oun0Cu2sUJi2bDCfjvWorOP4Y4340HEGW','776061149','morad009988almnaseer@gmail.com','مراد','المناصير ','2024-03-20 11:49:41',NULL,'active',NULL,NULL,'VRVQ+MHQ, Dalleh Cir, Amman, Jordan','e6QDyIbVS-i_j55YBTfjww:APA91bEc7FqGPTeL9FlX4DXDq2-VExotFtnKZatXJPMZI6zQiDtC3XEbxrguWkVi-z7aLw59cbzhViHWEGgWtjGCdIhSAfehhvUwo3e1F4cofoW7TGCnC4C1DDGOguNpUnFQLyBl4yNu',5,'Amman Governorate',31.894216,35.838980,'enabled',NULL,NULL),(391,'vendor','$2y$10$Zusk8duMTt92pmC6ZtYZJuX8aPvBFD.bK26JoBdNrwSoqnwmVYDIq','792078688','manaseeralaa82@gmail.com','علاء','المناصير','2024-03-20 11:58:15',NULL,'inactive',NULL,NULL,'VVPW+9MG, Amman, Jordan','ffoIH1DgTPaivXjdxSvr1p:APA91bFyWYXPynnb20pP93BUirp9CYRNuOw9YS0Iv6VtpaRPE186u2gFZ5coE4w2mv9AdwC1K7RrF55vvi5IMH154URNj9g6bkboqjFAVeIFuMN21BoEpNRRUUpVUzbAxMdRVRa8Dgbv',5,'Amman Governorate',31.885133,35.897885,'enabled',NULL,NULL),(392,'vendor','$2y$10$PIVVLLWKtgO/zoeCWdqbDeuzJpQDHOxHe9gn0BCLoXnOM9wgWxoL.','790859498','qsyalrqb61@gmail.com','Qosaey ','alraqab','2024-03-20 12:08:24',NULL,'inactive',NULL,NULL,'VWG8+M4G, Amman, Jordan','e3hOk7oVQNyOmPLp8FIulE:APA91bEvucKnFBKLe2N3dT4V56__xIvg6ZhUF4hd5M6xRXhRTvPAV9VhfhdK9djKwY1dTuvIPRDaxK2NjFuN0hFbhA-pOH3QbzTboilFZ24wSTQW-31IR7_d1EoAaRT_dfr9wErjl1RH',5,'Amman Governorate',31.876584,35.914873,'enabled',NULL,NULL),(393,'vendor','$2y$10$deO37.O/0uvovMwXS.e0r.eU9VPSitK4ST6qRYkaDfmh47hua/I4i','770199371','adlalhaj24@gmail.com','عادل ','الحاج محمد ','2024-03-20 18:10:18',NULL,'inactive',NULL,NULL,'Pr. Hasan St. 34, Amman, Jordan','c9O0zdFYRpiJ1lQzf-D6zj:APA91bFydJSHwOQjWPRkyoqmRh8IDroAa44Ze0nERxEHuoP590koUXkVLSLfh4_FTS6fhn7B38MeLgPmJsPbetvc3JXvsr_-J8Y8WT5sqi_mWqzSEy57n2aqRYGnZzqc9BZ9ue5x07S_',0,'Amman Governorate',31.942064,35.929126,'disabled',NULL,NULL),(394,'vendor','$2y$10$/vnvRTkYipCKFV7u65/SAO.duFr3uhPhn0l9KcRp8LQgpVPvCo9dm','778546748','vvv849231@gmail.com','سند','المناصير ','2024-03-21 07:33:52',NULL,'inactive',NULL,NULL,'منطقة مرج الحمام،، Amman, Jordan','cdEFhkNDQJuTq4VZZkjX9p:APA91bFlkWmh_-Km-DuwawSK3srurlqcTVhb_f7NfLz9JH1vrVz8D8g8-O97jFq6I8FBPIpBF7fVow6eneI59FUctilR1yWJztxWBtS3WASB2uxPYceYFXOY5wBbqzaEKuJcDN-rTZ48',5,'Amman Governorate',31.902977,35.848536,'enabled',NULL,NULL),(395,'vendor','$2y$10$7h/wD6zModhUEjUFxPfR5uUWiurvcg2dKQTT4.j6Xz4DfCXdTReTS','799464752','ma4687908@gmail.com','محمد','المناصير ','2024-03-21 07:35:27',NULL,'inactive',NULL,NULL,'منطقة مرج الحمام،، Amman, Jordan','ej1TiawtTIOKRnEbBezGW4:APA91bG_eVwpH4LBpiaLk7J2tGO_Ec6b3FVJJxmbfxa3vYRMCUl8L49-CRdzo5IQIegQcU1t6u2Wf6m6PcX6JHXRft2jmEu_ck0VEVYgqfmjINrs5FGlgl8ee8WmZxVCBr7zo3D6BQqS',5,'Amman Governorate',31.903016,35.848598,'enabled',NULL,NULL),(396,'vendor','$2y$10$W3BmSXqAcvZiDu1L9RAdgOmV9ykHvbRUWZP3NydGo0N.olIXbj8Fq','782369208','ah4322030@gmail.com','انس','ابو يحيى','2024-03-21 07:58:41',NULL,'active',62465,'2024-07-17 10:38:35','X2V3+WMX, Amman, Jordan','c_BB_CYVSAWk2LxB-T7XJy:APA91bHyl2OPusqlIBYKKHKMoD-8xvp7AThUTKVA5iIs3XftgKpF2abxCgihaHEAO0L71K3jCJ_lzsZLuqPYErn7agdvKoYdDmlhQUG_W9dMogB-q7e6QbktNDP-D8aYnCD9j3mzIsN4',5,'Amman Governorate',31.995051,36.004191,'enabled',NULL,NULL),(397,'vendor','$2y$10$LoC4Z8IwMarxoj0cs9tnFukqilK/wRkLzpl7G/WT55mOa4dokBEN6','772819008','giffjgh090@gmail.com','فارس','العبادي','2024-03-21 08:19:59',NULL,'active',NULL,NULL,'WRPQ+G89, Al-Khansaa St., Amman, Jordan','exZGxIotTrCfhN3NI4Myeq:APA91bHr7s1AN_pyDXjkXWpwjvEeeo-6xzeRR7cqlhskjFOP8ErX97CV2OX0wXMkzXbKU0CAAfaq29fSroYU42iqBKAgJe0_tjy-RoqxpwHqQEy11WZhkL77LOFw85IJdZ1bgsjejM8a',3,'Amman Governorate',31.936935,35.838060,'enabled','1.0.15','android'),(398,'vendor','$2y$10$0TMNNDzUN37dtY5FRBhBJOKJq.tZrWE22vWnDboPVyHytyYNg3oWG','776615039','gyuhbgfhjj@gmail.com','صالح','العفيشات','2024-03-21 08:34:10',NULL,'inactive',NULL,NULL,'RVMC+2PW, Amman, Jordan','dWWngT3nRZK7y5TU0bHP3O:APA91bEMVAIci_qepQPhoLekrRfAGt3HYVh-XJo5IADlSeJSTpISSyzqfO2LxRgLzmASVA-0ozBAcbVKsFh_1LEs7UEnoBpK_j2MFZaZZfpdODx7zA9-pkOIz7llZyNXy8_MNC7oP4o2',5,'Amman Governorate',31.832665,35.871737,'enabled',NULL,NULL),(399,'vendor','$2y$10$55slNhST./LxLW8keSHjk.e3/K1UTuIxfudCfa6ycJKST0LEBkFre','772081093','zayedalfalh3@gmail.com','زايد','الفالح','2024-03-21 08:45:09',NULL,'inactive',NULL,NULL,'منطقة ناعور،، Amman, Jordan','eCUzK03dRPSs5U0RbLmDgQ:APA91bEOP6U7um5MuJGXvAlyvAONYQ_ey-gq9eMgO072wQA2XJLd6vpj5ChQk1XsBwsnLxGeiU-8KbDXXwmmxWdRmwSm7Tvys9D6JZbwHOph-rWlK3Mr5x3zgwBJ04Nok3svQw4v7Hbb',5,'Amman Governorate',31.870460,35.819609,'enabled',NULL,NULL),(400,'vendor','$2y$10$PUJ7O4T06K/ys8wJmjY1Dumw4.7kI1qb/fTuB4k9qc2SjsHGWP5u.','796641600','rafatjamil1979@gmail.com','رافت','قنزوعه','2024-03-21 08:51:35',NULL,'active',95451,'2024-08-06 12:31:54','An-Nuzha St. 35, Amman, Jordan','d6qw_o-JT66ApCEG2EQbW3:APA91bGim2ly9OM_X7B6iwet_nvrZS-m_8yiuALNk86rVdmzFRM0LpZpx0q423kcUwom9LBJOGw4QOpZ88-9Z-iXdeK7K1G_lsyvDGmnPv5EuF1h6mxCK0Z8ld1XMoSpGNIIdk7A2KII',5,'Amman Governorate',31.976028,35.928949,'enabled','1.0.15','android'),(401,'vendor','$2y$10$EbtSNntHTLVRanJfYZu2SukBkZvcW3PvhgcA8Zfkck9AdEzklpQBS','796560515','hammzahammad46@gmail.com','حمزة','حماد','2024-03-21 09:22:58',NULL,'inactive',NULL,NULL,'VRJH+JFQ, Amman, Jordan','f9VfpUASRj6aqESKhw1rPr:APA91bFneO7e80u5ObSJK-bL867dQWuX0GqosE7vVH8Yjef8WIMvL0RRrTFKKtzqIOAAr14lfZtZcZkXD8Od6A3MISp-90pP4feBHp0ZlBXpUDHVbYda4H9lA90yktjnK8gSYGekFlZ-',5,'Amman Governorate',31.881521,35.828800,'enabled',NULL,NULL),(402,'vendor','$2y$10$EFmA1X1zxRs433zjwHU5l.aPQo5TI37H.jZW2vKsvBR.0lE6GwjSi','799278321','gazalwaleed96@gmail.com','وليد','العجارمة','2024-03-21 09:25:56',NULL,'active',23723,'2024-07-23 10:18:44','RVHH+MQH, Amman, Jordan','eonS9HbSRquVZw-7eX8L-Z:APA91bEwjwa_cjjNHiFk0b_Y-NZWUtJDuh3KsQo8Mm_tahC7MePfMrN974Ahm9WHtWA2PxFIKqh5E28wsg5_km-KnzOxkAlxjMC38nK6g73Va6eAHwtQ_vZda3V56lDLRpUz0qdtPj-s',5,'Amman Governorate',31.828377,35.879036,'enabled',NULL,NULL),(403,'vendor','$2y$10$Lx6OGMZVdTB8rB3obhkXeO/IoCUsCI1ebZIsvgB.YzNIbm.fhvmCu','799919906','harwnm671@gmail.com','محمد','هازرون','2024-03-21 09:31:16',NULL,'active',NULL,NULL,'Al-Shahid St. 395, Amman, Jordan','cgBzY2CNTVaEcde9kQI1d8:APA91bF-RJUpW3b7t6jm_kGGvJbiyK7m4Qv12gNIeJU0BLUG_FFkEhZncEpjGuzF3XQs0VpoDRI_IWRJ7pblo05DH-n7_zzSd1GdNIk_9F4nzrWRoV3D2hkWRD-CvptJj3CODnMd9U93',5,'Amman Governorate',31.987973,35.963655,'enabled','1.0.15','android'),(404,'vendor','$2y$10$t1DzIghFtevnEOpb3hAy7.f4qoPy.ZWIuiLkplIVnoFfuIV01Z7ly','779093465','ahamdhael@gmail.com','بكر','السواعير ','2024-03-21 09:35:03',NULL,'inactive',NULL,NULL,'RVJ6+5W Amman, Jordan','ekX9OGUORDC2bVyNMKtxg3:APA91bGf8cbJQmLo8BpVqbCqWbhEJQDejyOTcZUfkZFjqR1WYvp4eel22Q9k4GFyux157E9kcL6smC5Jk1XOx8r9tyGYg3uupNanpS8QxW7L9lIY6Ulw32CAJ56GYudIzU2K20QIl3KT',5,'Amman Governorate',31.830454,35.862285,'enabled','1.0.15','android'),(405,'vendor','$2y$10$8YATudaTUexZ9xXTn5G/quLwy4hbQwZuulKjj2OsqZ6BXJ3yfwxHu','772744679','abudakrashan@gmail.com','عبدالفتاح','الشيبي','2024-03-21 09:43:20',NULL,'active',NULL,NULL,'WV7C+J5F, Amman, Jordan','dt1WpbtYSFGDtjayqz3Ppw:APA91bEKAMCfxxzhF4sOB-JvKKlWtSJhKxHDUssBM6AWMPOEBmcPD6z_yRemAnAoACAKjamUzd6H8187Bdcd8LkM7X0swH4Pf4R7G2wKVMg3l2DeNuqqSolRo9wfO6vuU29r_KN9BPiP',5,'Amman Governorate',31.914562,35.870204,'enabled','1.0.15','android'),(406,'vendor','$2y$10$x50AWtM.jvABdzqp7OjMXOvWB9vCRf2sA4NsLWe3Wd69Wg3m07YTu','772803947','dhwgw5sgsfda@gmail.com','طارق','الشيبي','2024-03-21 09:52:07',NULL,'inactive',NULL,NULL,'RVMC+2PW, Amman, Jordan','ckyyOn69Scq3QiE3_vDgoW:APA91bHv3s_yICElj_E7c235nKU5DVYd997hVST-PeTM6n83pCPrTwj5zo-kA7KbfDZOAEizGdfLPGotZ0aw6w6c9j7hxFj-99jN1IKYGWh05FPUDmb3tZ4iJ7om1OOLBQYxA39DNLVs',5,'Amman Governorate',31.832705,35.871345,'enabled',NULL,NULL),(407,'vendor','$2y$10$/pxeIxAwT4nmdOUglK3BZednB1BSycE2mZBCDoxmkzvCiX1zcCNhO','775158966','zaidalmanasser971@yahoo.com','زيد','المناصير','2024-03-21 10:36:27',NULL,'active',NULL,NULL,'WR8J+P8X, Amman, Jordan','eHn-NldLQ1-lrDtCdOI0wp:APA91bHd7z-IUe8nhfOs4xocyKMs60LO8quTeLsfnXV4kMjP0IzK2jiAYNRYD0ZqXBsiA_PPN6pPU1CoTRy2of1vjTfIYiq4vaUMBjCN--hUI-K24xQXdnP3CsLkBKm2q8Qu3BCmmrdH',5,'Amman Governorate',31.917564,35.830751,'enabled','1.0.15','android'),(408,'vendor','$2y$10$bWlsZw5IW6MmifGqaAnBkOuHgQ.ZivF5.LKT2vBnjoGiYuQsW5aaG','795730372','almnasyrkhald959@gmail.com','خالد','الجماعين ','2024-03-21 11:00:07',NULL,'inactive',NULL,NULL,'WR4P+26X, Amman, Jordan','fB-EWJmbRQWU79-dudlFky:APA91bGpv6GwvhjZkRAJ-O3ZTMEwxWRgjw1fZBsRmppI7AVS7z9sleSkOE-j6otg1p7LxlHMKBsB4a51IvRUVHa6iAu_ZhIvalojdZz71i22POCTSfuhh0f-Kuher-e-upSJiwecdpDp',5,'Amman Governorate',31.904431,35.834932,'enabled','1.0.15','android'),(409,'vendor','$2y$10$XgW958a9jlT0x4mK3d7QDefy1Pf8K9e7BL346gNmRCOdUoye.FIha','779106188','hdhdjrjrujfjfjfjrjr@gmail.com','نادر','العبادي','2024-03-21 11:02:43',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','fjxdmy52Ql-yqFu2FmAwSN:APA91bEZG42HiRFYIdxoHBFkimdUFKGNYLmV-_TTSTq8chtz1HU6SHpeyQquCvcBUKPG0bhsT8yvYe6jbbgYDS8HAPsY3s3PHGpwUDMgKa1AbMyHlfxNoh9Dr2xCoipZ2B47nJw9IwcR',5,'Amman Governorate',31.904656,35.804331,'enabled',NULL,NULL),(410,'vendor','$2y$10$.x68QyBi0O5i3ntR73iE6eNDELrfjrWcnXyIiD75hcB.36nqBIpSa','795502714','almnasyrmajd313@gmail.com','ماجد','المناصير','2024-03-21 11:06:34',NULL,'inactive',NULL,NULL,'WR7P+J4W, Amman, Jordan','dvU7q7qNTm2YbA8Aa1pLli:APA91bElOc-CZYdgSXYVR4Z_mKJjT0YZIdil5rWgUp6qlMC8javqoAPdPA5mpbui1OeCW6MKRB1AHG9yVPyZNJ9FtcWueiiLVfJZK2aSKkcJaXxchIYrNfcQzPvYWPghWpKvNyK5iM9Y',5,'Amman Governorate',31.914036,35.835460,'enabled','1.0.15','android'),(411,'vendor','$2y$10$.o5b62kgZ1hQWzxtgowODu7IrlHqqBGWF.oEgPDf1rtNa/Ckhy2y2','796323248','saadhmood753@gmail.com','فالح','المناصير','2024-03-21 11:20:51',NULL,'inactive',NULL,NULL,'WR5Q+8F Amman, Jordan','dE2dkeLqQY6WpDugAKoqjp:APA91bEk20kDT4AFUgkNGWiVVl59rQrLAY0Jw4AzKzi8a-V9ChSBQT9N4270bOOW2tbuMi8_ByYMhnchcSz4bIL6XxhX_XD5zhHh1OFYm-ZnDfKv7_SwbjJXIPBJDiGBUX_o0LPbFurK',5,'Amman Governorate',31.908317,35.838732,'enabled','1.0.15','android'),(412,'vendor','$2y$10$hy0i86OgsCNuTsbOANbhHuNAgGWg7niU2olYjIFsu.OCc6VbqNRKe','772254154','poclm611@gmail.com','معاذ','المناصير','2024-03-21 11:27:54',NULL,'inactive',67327,'2024-03-22 20:02:47','WR8J+8XW, Amman, Jordan','cROqrswHSUOM4tA3UrsbPx:APA91bGYGghEI-h-ar_QyEtzCMyLO4VEPshJsw_7p1W9fGqv8q3N6Nto3Hxt5x-asW6uLH9IkW-5Lv__zYXith7OCBCCvWhA89yYMX53TId6L7CvxuVrBf7ntdGr2D1J0uFMUAu22t9y',5,'Amman Governorate',31.915737,35.832348,'enabled',NULL,NULL),(413,'vendor','$2y$10$dQdfEAcIQ/RGOSNrqjulrucyvCKpe039PvJZT1YtxMgJSAi/PvfZ.','776513161','almnasyrla70@gmail.com','علاء','المناصير','2024-03-21 11:39:58',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','deQx7iP0SnqqGXA04yEG2o:APA91bF70ik1YRUTEbpgT5PNu-7ls6JsiedcJkLMbc8kMiAUmzDWzr_hMJ2NqfdwXau4fUeumKLvAN2UOUkIAel_TUl56jvjM745P-0yOEJ5iNr4G2x_mn7lFhwZb6COjkZ_8yWWbUbx',5,'Amman Governorate',31.904860,35.804580,'enabled',NULL,NULL),(414,'vendor','$2y$10$U.5pN1PvACECXKGsxo9h3uPWt4wYg3BQ9HbGfXtxChXHlUZMl.o92','771044877','sahemalmanaseer85@gmail.com','سهم','المناصير','2024-03-21 11:48:11',NULL,'inactive',NULL,NULL,'Bahath Park and Restaurant, قرية البحاث، Amman, Jordan','cjkexEt_RJi70MHbsKCo0j:APA91bHMSepv2ln6HLkhqye371wcuZ6tzPvJj86LdsS8OvXGPlC8bqkc2yJegWY1cJtKgltvS5N-1V1qCzHyDkUCbzEw4lvdPsdrRs8RM23L3wPWZbSWvYEV4qZpUI1izQR6lhrkEeqD',5,'Amman Governorate',31.904862,35.804658,'enabled','1.0.15','android'),(415,'subAdmin','$2y$10$YeLupJprQ7810553yu/nVexZG5geolSZBgSrImgiy6HVBHYclpHye','797023732','Khaledghaith40@gmail.com','Khaled','Ghaith','2024-03-21 11:52:42',NULL,'active',92384,'2024-07-24 11:12:39',NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(416,'vendor','$2y$10$v1/XX867BQzMT3YD/fn1bO9xx8syJbPftMaDk3E0E.RuwWJZkVl2u','797355798','ahmaddryad950@gmail.com','زياض','الدراباني','2024-03-21 12:10:23',NULL,'active',64593,'2024-07-18 07:20:17','WXR3+W82, Amman, Jordan','eEpUD4_aSTaPpDTVXjkYRM:APA91bHh_zA922FOIYx4sN054Qg5W69hPnedZgAs7hVrRXpaGs-ifbsdXoGJZRBLIOBpep45pESL4809Fc0fOB5uJiBA_Dzl44c6E515im63238uuG-jfC85zwnLWqQ31T1UTXyLr9qX',5,'Amman Governorate',31.942518,35.953242,'enabled',NULL,NULL),(417,'customer','$2y$10$bcELG2eMGEQyqwcf6PkmeuS/.EDvqisFxvSDNmLhKGwhTK40xfhdK','797108850','nooralwahsh88@yahoo.com','noor','abd','2024-03-21 17:47:51',NULL,'inactive',NULL,NULL,'WV9Q+FQG, Amman, Jordan','cEhBv2-R6kCJt5Td45QCBH:APA91bGXPVmmZk5t9qYB-A64L-A3ISxTkHT1LabrorYnhePEXvDXUrHBmOXkR952DFEZbUL_slcLmkBRCJgyCNRqKnkQpnflFdpWlv2FjAxGdG1Pygvh40s0aNmi4JPeojxE7tstmL3J',NULL,'Amman Governorate',31.918850,35.889929,'enabled',NULL,NULL),(418,'customer','$2y$10$ljKZjHHXu04FKPbui21ABul7K3Z.ufW/zPpPwDUYI8Hc.W3bCJp06','781060194','mrad.mohammad@gmail.com','themd','md','2024-03-22 22:45:33',NULL,'inactive',NULL,NULL,'QVFX+387, Bar Elias, Lebanon','dJAf1uNwKUDJt-AgQYgyhF:APA91bFIIBXn7IOWq8gsESpWGBpSz2vXwCI53KrCDaxfZuPRQOgVFF75KyTw4D0UtLyF0bN5yzH0A5alLgKYIAP5nU2a9qU6CLOT6kn3PPWEGCcl7uye-n1EdNFKqj1XlzCUcwigiNkJ',NULL,'Beqaa Governorate',33.772484,35.898310,'enabled','1.0.13','android'),(419,'vendor','$2y$10$NZEYXsE3ldJFlbgeesnA9uG6nyzLZpi.xSvvEvnt0bJNmWbl6N8n6','790077712','ahmdkhyrallhabwsfyt03@gmail.com','احمد ','الشيخ ','2024-03-23 09:13:41',NULL,'inactive',NULL,NULL,'جبل الجوفة، Amman, WWVW+X28، عمّان، Jordan','f-scg2FyT4in-_SDL7Y7T_:APA91bEQzMnkXeb12FtyNBPzv3j-riYsJQfK_q0qCOkvx5K5MjR_1h0W0Efma-By45KUd36vRuWNnhY6ceBAFfw-_AhTzyFFw4A3QBf_2NXiU_J_NZhu5nw6wBLEiVdJckhOenYfS-4S',0,'محافظة العاصمة',31.944882,35.945048,'disabled',NULL,NULL),(420,'vendor','$2y$10$PmEAfVBpHvKNR/Y9HjYYfeT57Y15XGNTxN3HPkSlfw8Cj8gtanXCq','786849004','saadharoon2191990@gmail.com','Saad','Haroon','2024-03-23 15:01:57',NULL,'active',NULL,NULL,'22GG+C54, Russeifa, Jordan','dZVv7UyYS8C5wycCSbgr2e:APA91bGNb7dCpVsufGRWcHjIwFSrevOH70uxX__kk1alJDfIKEh9nA7Jt9_HgZ3WOksBn5pzvUiuV3c8xNRT1IydwBTaE-LPSmrlWInmUc1dS1YUEB53xCtp_MyYLatWACnMKjvMAOsT',5,'Zarqa Governorate',32.026520,36.025786,'enabled',NULL,NULL),(421,'vendor','$2y$10$1XWv/zJW7IEPB/IpfItXgOKcPSx0MOx/M8hCm1BkCelJYWh5q2c6C','772687255','ryhm158@gmil.com','حمزة ','العبابسه','2024-03-24 07:40:34',NULL,'inactive',NULL,NULL,'PQRX+J64, Madaba, Jordan','dV-67aVgSiuAR-qvO-C786:APA91bF8WrejII8Rw7dE2dGqqbdKfdKCfsgkxPsx7H8NcScFaLExdgoEAnd6LV7fn3k9xMuL6UMR_B8YDvHejLBH3GrxXuPURNmfsXEn8cvTi-uENX6NMJoxuLzsKbb1BgKSapDFD4CJ',0,'Madaba Governorate',31.741085,35.798260,'enabled',NULL,NULL),(422,'vendor','$2y$10$rvoUXOKoTaELHgvkLuPfne9zmzGrVCLm9vCiIXwb/rlS6sSH8D3JK','776124134','wasemalazaeda@gmail.com','WASEEM KHALDOON ABDO','ALTEEN','2024-03-24 07:43:07',NULL,'active',NULL,NULL,'Abdul Malik Ben Marwan St. 25, Madaba, Jordan','dO11kkMiTGmJHnfmb2QItK:APA91bEwgCGXMY6WwODqgYzwUnMR23pE7bApByMOCLaWFWapWcS-lEd72yunzVDIrOoxArLqXJRWcv_aBXYgF1NFRT2HVnRpJ3p6kJ7SxsTEpHAV-K28odoxTYf04OmMynqGNRXk-0Aa',0,'Madaba Governorate',31.716887,35.785336,'enabled',NULL,NULL),(423,'vendor','$2y$10$LxHIPOFEPOW04HJ./mL8DOe8BE.cGwXuLk/tzlShcDUwdF73XYUu2','790853259','tmrysalm@gmail.com','سالم','ابراهيم ','2024-03-24 08:13:42',NULL,'inactive',NULL,NULL,'Ahmad As-Sukhni St. 12, Amman, Jordan','cmALp211RoKYiKU7PQnqkZ:APA91bFqHkhsHtXP2a-e0q0m4i5wwpOb4on6As2jN3plB4fpZnJt09icGgcxU4x48Ybg-RK73ucbK8AM_q4xMIMB8LUPh4DnjryeAWtafM5AJU336eOwvh1Mv45dN2yvITDU0bXLK91A',5,'Amman Governorate',31.959226,35.870392,'enabled',NULL,NULL),(424,'vendor','$2y$10$vyiXb9IdrrsBKvvuy2OlU.x3zvFapaH5Eo8cb1K2ZfE83rc.622ba','785475929','fgvfnnnj@gmail.com','فراس','ابو زيد ','2024-03-24 09:23:43',NULL,'inactive',NULL,NULL,'3R9R+7J Ein Al-Basha, Jordan','ceRzsil4RH2f-o7rHVDwE-:APA91bEZYYVZSTg75G6qPiTg9_gNDnPpwhbx-TGSnciPMM3FfDYiWjS84FHxSiYe-orbu7V_lMfZBdkRhlf_baERIK0Bu126GkpfJw-soeQqXs_IpJ-X5Z3IPMXBJ0WtpSsZmRYo8Hcp',5,'Balqa Governorate',32.068149,35.841575,'enabled','1.0.15','android'),(425,'vendor','$2y$10$GIKWHooQLYWcN5tiVK6UHO2eVrExXW.bP0Dcts2fPTKCJ..0bHXGa','786095938','sklyb1058@gmail.com','صابر','عبدالرحيم','2024-03-24 09:37:34',NULL,'active',NULL,NULL,'2RCV+X75, Amman, Jordan','dKGeGuquQAyFTod-5cT0p3:APA91bH1bUpyOf6sNbe_ZpS9bbCxGKS_rxG9CwMRdA-i-2cvoIy89ZKRS6891gGNatmYA6W7HyOwbhXViMaRCxWcDaqTSuyCtvUqYGN5tNI7NS98zGia19JYyX4WownmPG-cTFMBFa3V',5,'Amman Governorate',32.016011,35.844084,'enabled',NULL,NULL),(426,'vendor','$2y$10$jA03vAP8XaBg/mhsiMLiVOsgxh2B4oLJXti294.Yq4hWv37oRg8b2','788894913','ffraj0587@gmail.com','احمد','فراج','2024-03-24 09:37:42',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','dj6aJxOqQZW-r_vNI2XdmV:APA91bG28AiRMH-qxaNsLImh--f7-pmSbUsLeDQknSTpNPQ4om_jkLBFISWiNKIA4VyHydCmOO5PMAhBflZcMbPkQGfBD3-OQlAlvuBlhhkKTTnSCpGM74Y80K2qSUyVqVP4Y6UQ04G4',5,'Balqa Governorate',32.064931,35.839231,'enabled',NULL,NULL),(427,'vendor','$2y$10$pwJnkPRUdy.NOGOC6V7HcOpU8n7JemxLKhz89UAkb4rtCYL5gMt2y','775354601','mrwanshawamrih9@gmail.com','مروان','السوامره','2024-03-24 09:42:08',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','dhod35QcS52LvivYQtR0qE:APA91bG5-WA6UXQjegMVOr1kNU5S0iqU-quHJC7RFAZtn7nyD8HWURBFHLwWATFxHHA4h1-El0WEkwH_9MnNeyLuSbCNeUmRNTg1yiErCq3aiAsnw6NDUgo-3nJkKQNvDNOo_UPwLrZd',5,'Balqa Governorate',32.064920,35.839219,'enabled',NULL,NULL),(428,'vendor','$2y$10$DZryv1CkI2ZHL4YpeHdMm.e/FkLIjcHgUkxkzDlgWivkeCkIiB4sa','795943022','maherhutie@hotmeil.com','ماهر','حويطي','2024-03-24 09:59:03',NULL,'active',NULL,NULL,'3329+98C، شارع علي بن أبي طالب، Az-Zarqa, Jordan','cyHatUQKTTyBuYFtPpXNEY:APA91bFSFGe9qE8KnB3qQ3fmvrW6UdiJWg87AVfanmLLVXzLapJksGVJl-t5iPnOhjbkFlMLj6_JO-p_FjsAMr2GdRfihqW6R9g8VgFblwB6tSrnARTJIV84tte0rY_z4uICGGwZwNF6',5,'Zarqa Governorate',32.050392,36.067342,'enabled','1.0.15','android'),(429,'vendor','$2y$10$3uMAslt1c2XwFI/vXnSUXOYNEoRdZeLV.YhvGH6F0334fP/r3hPVq','788279887','yhgh98@gmail.com','عمر','الحوراني','2024-03-24 10:32:12',NULL,'inactive',NULL,NULL,'3R8R+2V Ein Al-Basha, Jordan','dH-rl2v8Rj-r52xg2sNK-E:APA91bGpEJLv-y67qWwKR_uxsiBaY7SBjuYsBmN1jg0LOFLxvZzd9Uhmd6LQCinNiQAbvBu-cAt2VVojxVSYKd5m_NmXwbVdtykRwg5nS_qPmfssaEOprn6LydyY7PMmmdb6rJmCcM1i',5,'Balqa Governorate',32.065182,35.843139,'enabled','1.0.15','android'),(430,'vendor','$2y$10$1qLpgUGkfvKumePdyEjUte.GsUtiRLD9ojGM6PW7hX8qYhCZaqwNW','785161740','jfjf46970@gmail.com','محمد','سليم','2024-03-24 10:47:29',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','foNMEN55TL6LrB-L8SP_7s:APA91bGwLFjAiYHe6F7YXa6WSFDtlsMIbALVLNhUmtAnMwWq3Ij1pBQIDMkO72mNRiwI06416Ki2tJ99L8mSz8MyPYCD6JLW-MPR7xBrFr52euGEENOlvl6H5gtQKx3mImoE5FOeJrwi',5,'Balqa Governorate',32.064933,35.839249,'enabled',NULL,NULL),(431,'vendor','$2y$10$2ZV4MXoYE948jgRppUlzJerf4L4VmuRRqkVb5Ts6E6wF6MRs1iCYO','788865809','aloushi.h71@gmail.com','علي','ابو هنية','2024-03-24 11:03:31',NULL,'inactive',NULL,NULL,'3RCP+QQG, Al Hanou, Jordan','fmdwdBGcQgWaifRSs_riDr:APA91bFejFpGX4DypHL_G1CFzP07txvFmAlUG2BTMjys6xDjMrBUCViHncXfK2DJrWwhLsIw1FHSW7wGMhCuguVuSiymVR5RrJCH5LtGu6C5_gYqA_i8_lX_1sxfT_qFjC_AdzCTvK0m',5,'Balqa Governorate',32.071686,35.837313,'enabled',NULL,NULL),(432,'vendor','$2y$10$UALRRiA2JF9gEoXIUcQsU.e2noKR6RCOTWkNIMyYPRq7nHqZSxBsS','790322691','omarmram@gmail.com','عمر','خلف','2024-03-24 11:07:03',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','f-4Z6G2zTSS_uXzRtTX7f4:APA91bEX0UgKfE9h3c-Pivr_TfrWFrQAE5S6WPTp_dz46XweHxa0q2NcmKTGZzfzqx43K5kZR3BPX4Oh4FuLl5p0ZeOr2gKtHEV16XOoJe0UCBZZlwPcSzOmWV0QUGWWvbmQYUz2UqFI',5,'Balqa Governorate',32.064947,35.839216,'enabled',NULL,NULL),(433,'vendor','$2y$10$8y9iJIKUBBfAhF03NgHzGOz.XVv2HO1cHjbwbTiGif.sR3UZqcUPO','791814356','fadiwadi@Alkateb.com','فادي','الخطيب','2024-03-24 11:12:46',NULL,'inactive',58830,'2024-03-24 19:45:07','3R7Q+RH عين الباشا،، Jordan','etY0eLfoT9S4gUywAaS1E9:APA91bHEJbvZbcZ2qcwMRJIVyPoGHDMCNK1V7JYplEjpU1UQEiFiU9sZIP14jXHtXKEt0gJh5dOXssC1pqLXe6VcKxgde7Xwz-ta1eqTiuqiMEFbXcX7Bs4Uyj0OzI9oOAMoXycnw2Rq',5,'Balqa Governorate',32.064806,35.839011,'enabled',NULL,NULL),(434,'vendor','$2y$10$4WHZUW7My2/phgJquddzv.yGJ7satVdIh00CEVJDmslDUfYrbCxAq','789423888','samemamr57@gmail.com','سامر','معمر','2024-03-24 11:31:22',NULL,'inactive',NULL,NULL,'3R8R+VQ Ein Al-Basha, Jordan','ctFgNzyXQ82UnY9HHMKOCt:APA91bF5XghGJZUUbY-ghVJEXOq0cgMUrQ32sZy_cEArM-nq3eAFXtVZfbkvDTvjLCCzObr_46ruhkthtiQQqI__ez96-v8IhVbVEsEKLj00EYsGezDPnSVaOJuSV5j5Egp6JXGkid2w',5,'Balqa Governorate',32.067226,35.841900,'enabled',NULL,NULL),(435,'vendor','$2y$10$4Zg8F57b7LvG6BYke7wQWulInld6L2U6Nl1RoDGmcduvIlyCJXCoq','788055238','esammter581@gmail.com','عصام','ابو مطير','2024-03-24 11:32:00',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','cxUTfOmHQ_a24wT_MECfJY:APA91bG3PpJAunxNmy8jU78r45BarR6xOXpZPJfvC_dIUCnMpGDoeNI6BKU2CxDVG_xPmxRJlhybd3xyX4JKR587ONrhIElOBF3gN4TeJ3ZSboKKyBKr7_cy208J4cLINtuALJ7zI6Md',5,'Balqa Governorate',32.064779,35.839192,'enabled',NULL,NULL),(436,'vendor','$2y$10$xaA94aQFczK6vU656nOjMubWRRk1rtdNEvSPJU4OaLSOZlnSaDsbC','790213130','mahmmad123y@gmail.com','محمود','السيد احمد','2024-03-24 11:41:31',NULL,'inactive',NULL,NULL,'3RCV+RQ Al Hanou, Jordan','eeZ5Nd-eThahN0NwExgEik:APA91bEI9VGJ4RTYIDuqsekkaA6OiL4QZgEKbJsG6gG2ksq6UYLs9rhy8khVuwaS9s4ya48UqJKR3p7LbpeTwrJ3II6_I3K3h6YCnS1uahbS7Y_lxhO5IpfbMSSlobxgaYteNIlrxtOd',5,'Balqa Governorate',32.072083,35.844377,'enabled',NULL,NULL),(437,'vendor','$2y$10$GXLL8j2kd8Nc2a6YhZqdvOyzkdtfRXTTlypBAUQD0itwcjkJzSnoW','798100141','shadyalhwrany0@gmail.com','شادي','الحوراني','2024-03-24 11:41:58',NULL,'inactive',NULL,NULL,'3RCM+656, Ein Al-Basha, Jordan','dWVKbLacS1C3G4TWUI3194:APA91bG4G6yn1J1AC6MYTy_fO4VMD1h-a-NcqcyoNcpbzYfkyfLF1QMryCJrf_7qqBLQ27fbVwtrNGnhVlKKv00gAmFasK_2lH2Nl-qDMHF1ULUEDoviNr5So0dW5yzIJRt8uhkgrTJL',5,'Balqa Governorate',32.070801,35.833449,'enabled',NULL,NULL),(438,'vendor','$2y$10$QaZ6/KpcrQ30URtuGb3xAOwSUWISm6hBvz.d/wSCDuvsegZ8oVf4.','781175710','mohammedalazea38@gmail.com','محمد','العزه','2024-03-24 11:58:44',NULL,'active',NULL,NULL,'3R57+7C3, Ein Al-Basha, Jordan','eRySfjnfQEiL24zCeFsAZM:APA91bE45VYvj7BfXPfJi4Ap04E9q8frW-rQ8RwtDf-s1DuvT0rtQvxVheEPLIJk53FwC98Jmf0acQVQh6ciBLxy732EvtK2Cpv6UMkAqo3Ot_9vyxul_pqG9FRiM3GDEP2MWUt2r1GQ',5,'Balqa Governorate',32.063905,35.838895,'enabled',NULL,NULL),(439,'vendor','$2y$10$uN5JjhmbBWJ7gzthXySnAOErdP6a5B/BXdOxzU46X.gy46PtGkbsW','788481505','farsaljarmt28@gmail.com','فارس','العجارمة','2024-03-24 11:58:53',NULL,'inactive',NULL,NULL,'3R7Q+XQR, Ein Al-Basha, Jordan','fgE5UPSmRG2LmnsWG6BsVM:APA91bG_0J-YYzxLr9iIDv17dtjcePP_RRmu8aEPKYLtuB1OsxqGuYdiYQcMDL4z8X4tcAwhv7I-tCZN0avx8HZkl70k6tpuOrYqHj20F9vOAYEk-qgmtI1qNBx5ERTDYK4ZCyDLimva',5,'Balqa Governorate',32.055252,35.834420,'enabled','1.0.15','android'),(440,'customer','$2y$10$LBT7HjR8IlFQvLzjCC.NfuHmTYSgvAgG0GMpvf4KohrL5Xi8DGLwK','795201319','wael.ghareeb@bluefig.com','wael','ghareeb','2024-03-24 12:40:32',NULL,'inactive',NULL,NULL,'Irbid St 30, Amman, Jordan','ewUUN3joC0CzqELKcV03PM:APA91bE7oSa8WLo1QyHY89s9yIMTZN501QdQTQwRcNHKBCodY80wmOicrzsTA2kJ4xt3Q1PjVZZpCSnfQuteeNxGObjhwvOHwp6h54toFiT74I8KZSvv6hkv0ufEpgslxaJlksUW9ybw',NULL,'Amman Governorate',31.941677,35.889681,'enabled','1.0.10',NULL),(441,'customer','$2y$10$LQ7C.4MFOFUwOWehi90UqObWpQpDcLvdi8UYcw6owp9wCUjax7buC','770311333','saassa60@gmail.com','alaa','harahsha','2024-03-24 12:47:02',NULL,'inactive',NULL,NULL,'2X2J+JMJ, Amman, Jordan','dbN3Svf_R7SW_sogtysxb2:APA91bHwrQ2euh52T2OdvFr0nRzOl7lsvepVf1F9yCqUHr0kRcOYRH0ZYLgsuDg7Yz579tx8Co1fqmY0ERKmqKJ4Q9OuUQlZiL9N2slOR9Pa7UbiYgeH17gy9CornUg33xQ3D9Vf560-',NULL,'Amman Governorate',32.001521,35.981655,'enabled','1.0.13','android'),(442,'customer','$2y$10$QR5oN6c2PShT0sRRbJalZe3xFfYHa.B8LjA6s/a0Q8ZQrzEYqQ6bq','796347341','lordalwain@yahoo.com','محمد','عرجاني','2024-03-24 15:08:07',NULL,'inactive',NULL,NULL,'GVMV+CQ4, GVMW+47J،, حوارة،،, Jordan','cTqRCEVoS-KOn61DthzJXX:APA91bG92I33IsToh_X2Mfd2kIyTZiqau18ILLmMcTc-my1rB0fsRAoWdvqjT8DXq0Dq3TrDzy5jzTLS-q23TI_O7jDWinCRf5RT3Fn5tUhvyeKQz9q9lnF3mk13y-TURcUqzdpeVRzD',NULL,'Irbid Governorate',32.533494,35.894262,'enabled',NULL,NULL),(443,'customer','$2y$10$BsqtjxV/9HutAHC6bRQY3.t7NpvDivQCnH7AJYKzkQ.rPOfbwibra','777628826','ljk40@yahoo.com','ابراهيم','المعايطه','2024-03-24 17:00:04',NULL,'inactive',NULL,NULL,'2X43+X67, Nuaman Al-Alousi St., Amman, Jordan','cAPDRUX4SAmfC4yiDkv0am:APA91bH35I1XRgWStATFLw-PFeHY-AQBynDoPv7_CldoFxBdYWf3czGatsCaiETBlZ1F7idSE-nQqNjdsJ9RNRpLhqVoM0k9GR7WcpgxuwscvMUbyxh-k30FSCAf6p-lL_OxnZTWjPEW',NULL,'Amman Governorate',32.007652,35.952542,'enabled',NULL,NULL),(444,'customer','$2y$10$BeUAIS7BQbQ0bdwkNF6uVeuhFu7TqBYEw7epVbY7GfSx6XyeAjJM.','799952629','rereawad1990@icloud.com','رهام','عوض','2024-03-24 18:58:19',NULL,'inactive',NULL,NULL,'Madaba Hwy 11, Amman, Jordan','fGZEbjd1QU64tz03E9rI4U:APA91bHaMT5zlQH0pjTVdy6C6tDABB-0xxg8Jq1_gfbsdtpdtETMKw_VuH3VulWTtEEpSqJrHm60dcfxEmukpfmtK85zVR0mzVD1wAc-7EvUay6SmOuBvVPgfLAGquaFwqEbEkdMk2Fc',NULL,'Amman Governorate',31.874200,35.938227,'enabled','1.0.13','ios'),(445,'customer','$2y$10$ZJYmY42.CnUWzO9VMJdefubLPbt5k7OI84DX9EpNkA6zhPT4Zjzti','797705839','albertareq@gmail.com','Tareq','alburairi','2024-03-24 19:06:34',NULL,'inactive',NULL,NULL,'WW4X+H6H, Amman, Jordan','cjW2I1heQn6S8yDsjMauqd:APA91bEG8jOK8owazjumH2sV1LxgP1OtItuwP4LA_66mewMAA2I9zUiXrWfgfclMCCEl_EdVRABsRheO4TDgIuv9zbdDHF-GXP79UQMiXjNf9NyQGIq5agfSRPBzGa2na4hAaihwlyyy',NULL,'Amman Governorate',31.906250,35.947991,'enabled','1.0.13','android'),(446,'customer','$2y$10$e7WjfDhc7gom3gq8KoHJoOhD6pTDlalWsiqEk7tKMqXwQksW/aSUm','798427486','asraaomary22@gmail.com','تامر','الفضلي ','2024-03-24 19:40:59',NULL,'inactive',NULL,NULL,'XV3R+V3V, Bou Madyan St., Amman, Jordan','f1HfPcNbR_qlt-8lICZCoL:APA91bEKoeILoYRZdGbrh6SpaGPdh2mJjknwAuEWkCxSlS71deFKWon1kPpSVc5vGxFeLUvAhxXI-XqyuK-6MFm-gZ6O0G8ygWzYOHBJq81CTYAqHwkoXFXTHyn8wXYMhzPXTX-qlYxR',NULL,'Amman Governorate',31.954887,35.890120,'enabled',NULL,NULL),(447,'vendor','$2y$10$iAi7KJzEbAVI/KLjqEYhF.zmogGoF0TiW/6THFSKEyVeVBSARF.z6','790969360','Omwe.alsarafndi@gmail.com','عمر','الصرفندي','2024-03-24 22:39:22',NULL,'inactive',17564,'2024-03-24 22:40:53','22C9+75H, Russeifa, Jordan','dTX5y11ETGOQByZZTHIevT:APA91bHR-rSjOBW9PpdpMQYM5yJ8G6c2u2AAcQLe-aXVvTpAvzu74CbJ5iEO_GbJwUQuZEItVQlFqNnERDilC4iTZAYyL8K29Nct4Wxhm3Vok_EfHjVeNYX1gTdcwv1WI4Z3d2UT9DcI',0,'Zarqa Governorate',32.020571,36.017913,'enabled',NULL,NULL),(448,'customer','$2y$10$2vSf0GWtJbEtwP4jq/6b1eavYPnRl61Pnt1vhZaTakvkkJWFNAi7q','779699002','abdff','Abd','F','2024-03-25 03:34:53',NULL,'inactive',NULL,NULL,'2PPM+59W, Q. Rania St., As-Salt, Jordan','cX9wNrdXS0suhMRqcqAnkI:APA91bHknhmqzYhxhivEL2v2MIzmFeRxhfO9C7Ey6vwVANnsteEKAednWEMO7Ajo56sjzauV4c-GXwKq29ncbJh59JNsl5CdFbiVcB6ocgpb_WQA_num86tzHavv5ZY8KAKoc6eUjv83',NULL,'Balqa Governorate',32.035208,35.733290,'disabled',NULL,NULL),(449,'vendor','$2y$10$/uaBjYsWBS2AGRjFFsvXVeKZwKqDSzjdvdd9ibIPraYXfpLZ3F8/C','780416858','0695519827aslan@gmail.com','محمد','اصلان','2024-03-25 07:48:38',NULL,'inactive',NULL,NULL,'Pr. Hussein St. 68, Amman, Jordan','cJpoUbSXR7i3x3aRmr4tOl:APA91bFRqBGkBv5Xai5U_jne8E5BaQNGtf_7uHeKM3_ozcvpfZ0Dme6Mdsdqfhn_WYvMOSw-vKkSlvqU3_ORQsdweuPFikpCyH99MPuLXmx0vsxHRRniJ4XXxdmrea9r95UVif4JT4Ni',0,'Amman Governorate',32.003470,35.934647,'enabled',NULL,NULL),(450,'vendor','$2y$10$tUB89E0upgsA5IICzsNBZueNRE5ub6maL0384kRPBGhQlDsnYiHCO','776524787','hdgyf.hfg@gmail.com','سعيد','دعيس','2024-03-25 08:00:11',NULL,'inactive',NULL,NULL,'2W2R+V25, Amman, Jordan','fpcg8HArQvOBuClilPZb7T:APA91bGQGo7EG1umdNmsEa46wL_8jsCsBGgEG2xcWjDVcXTLUfWv_ZH_hle15JqhkY4r3XX2L7YYz_SwnWVN8P8coGMNAhAaC8mwUjboUW5hFppeDc7zFVdhgJsiozl1jApPt7GZ6XV5',0,'Amman Governorate',32.002251,35.939184,'enabled',NULL,NULL),(451,'vendor','$2y$10$/Hvq57bIE4A1mcceMmo01.MFp9QjLU5rOoM4RG0EUdtRPXjc/4XZe','799809196','alaa1324hammad@gmail.com','علاء','حماد','2024-03-25 08:19:33',NULL,'active',NULL,NULL,'2X3R+CW4, An-Nahdah St., Amman, Jordan','fLJAB8gSTqe73ngHOQIiNj:APA91bEhcRgAoD1UnXkQzYtnTlgda4BlA9tRVOAB3h0_1hQbcINiMV3D0IMexbsVe1_dml0tKFpWbeEeRGdyY2aHSoPDOVAd1N2YP4A3QLZyd7xTVtTE-OV16mZO8GRAHCAwWSzf2TpY',0,'Amman Governorate',32.003630,35.992278,'enabled','1.0.15','android'),(452,'vendor','$2y$10$Frarfz8AQ5u8p1wQeLjJTOk6vFISGn89mm.5Xur0KfauTApmSA8FO','797155152','raed5local2002@gmail.com','محمد','فيصل','2024-03-25 08:45:53',NULL,'inactive',NULL,NULL,'Prs. Aishah St. 11947, Amman, Jordan','eBFxf6pzRUSbtZWQ9lvVFn:APA91bFXnRC0uGUV1xLdeQ7TjzjGfQlEur8p0DYQ-NjGNp_jdKLXD9429HZqsAXYelLDfXq0LlDPIXCARBD4Ge7RtWQ0lqPbzFAjEC6PXuHiruWM2fWZ_7gFU1DRyz7qvZZEKM6jBCiW',0,'Amman Governorate',31.990902,35.943586,'enabled',NULL,NULL),(453,'vendor','$2y$10$aKCyOL0l11ZlSvOxXx7fsevj4TpRGZ.UqQtsi/VE/mVgtL3AaVV.C','779648788','bdalghfar423@gmail.com','ابراهيم','محمود','2024-03-25 08:48:09',NULL,'inactive',NULL,NULL,'Prs. Aishah St. 11،, Amman, Jordan','dJ8bT0qwQBi6PS0PCe58Kg:APA91bFQDEzHR6e1XP__fmONZuKjT7UEYZM94s0JBEjT4Zb2Ojs5kmNpXkbvx8lST-8-WLwxRBy2nYBWGRr3y7gs0WI-G5JrJFmbefg2uxQ5nBJH3_7nAcGu_w-4TdBibL4cWqJ1ZbLY',0,'Amman Governorate',31.990901,35.943579,'enabled',NULL,NULL),(454,'vendor','$2y$10$AcAHyYMSFly5L2TrDHV49OKWoZKmt22hmMMyOmIvZr67X1FARlhFi','797604668','alabadikhalid247@gmail.com','خالد','العبادي','2024-03-25 09:14:51',NULL,'inactive',NULL,NULL,'Omar Al-Fakehani St. 6, Amman, Jordan','faoZc3LtQYK06SuE97BpH2:APA91bHoXhWaIhg-uICxcwyv-UnwRhupRhIFdDGahWQVrRCATF8MH6YmRFtNUC07O5jD15kmmF7MxmNJXpuT49VfJvkiwHKCfzcRWmTC0EAJvDz6DQyNAvAobhmHOXSW9Mx4-UfKODDG',0,'Amman Governorate',31.998196,35.943934,'enabled',NULL,NULL),(455,'vendor','$2y$10$roWnJFLcYdqm1NPCjvve.OJuY29buhTfC88Fp2yocTnbJ97cIZliG','797347133','hamoudehalsalhi@gmail.com','محمد','الصالحي ','2024-03-25 09:30:15',NULL,'active',NULL,NULL,'Al-Bathaa St. 97, Amman, Jordan','fTmRBf87TPSeWMEjzeLYrW:APA91bExmpMVq-djUv7dVNIvMrnRDG9hYN6J6W37FRFyLonezA3hqZvacd02MDj-Ft-cJEOR-CtRvyrkXbHGVF05DQpvBUHQH842ySqAfTjcxDDB361qQcPmENV6YtdaOAPJQTZZP-9I',0,'Amman Governorate',31.976241,35.951119,'enabled',NULL,NULL),(456,'vendor','$2y$10$ESw5v4qgR/vr1q/axgYWHOs5kabnjknETWjFmeIAZXE4iRGfmjh0y','781651125','dyalhsamyh@gmail.com','عدي','العبادي','2024-03-25 09:37:35',NULL,'inactive',NULL,NULL,'2W2W+XFM، ش. اليمامة،، عمّان،،، عمّان،، Amman, Jordan','fw074l8aShWhQpWjGikPec:APA91bHuIEBGzYMMCOrcqwF8xeGaKLg6kOQY9-X32N277FFIOqoIRaIh_yl2tSZelvDHiJfyhEJd44uu8Ww5qcB0ERs_Gewwy2IO9_wqbbtet1IF1Ha7TzFR1ASWNdNUPIUACXXyx2mm',0,'Amman Governorate',32.002611,35.945849,'enabled',NULL,NULL),(457,'vendor','$2y$10$5rcjqhz23IBw25bKexhAxOfJ836Q2RRiCk63ti4Ur27bzZskZNtke','795143628','alshbhwd877@gmail.com','عبدالقادر','الدريدي','2024-03-25 09:57:10',NULL,'active',NULL,NULL,'ش. نايف الفيشان، عمّان،، 2X32+MV4، عمّان،، Amman, Jordan','ez6ueLVEScaq1B3_PGjMWZ:APA91bE2fsxkQKlEy-I7bC1BActGYH6QC1Vd2rqjjiz4LfI5MmZvfG9ja8D4sNIdutyvpoHJ4WUXNElWt6lYdUER2EKIkkDNpHN8YYLeuAR9Cz6xMNNNSM8hwC8pz4leFa_kAjJ9g801',0,'Amman Governorate',32.004650,35.951492,'enabled','1.0.15','android'),(458,'vendor','$2y$10$GMC1OTFCjG.GZpVqsghQCeQXWxTLsisypngWeQ18ktdTCDTxItHVq','798630805','mousabaltaj83@gmail.com','مصعب','التاج ','2024-03-25 10:16:46',NULL,'active',NULL,NULL,'XWHV+Q38, Umm Hakim St., Amman, Jordan','eQNfaJFJTyusDf7_4tumEy:APA91bFQcFe6bVBXkUw9xbdpHVuLI8bzC7pN2kd38zVVXlq9hEkP0N9GinLVJiF2TvRiB6_W6px_pCRaegJVctg1mS534mQXXyL92KNvSaP-w0KnR-x-LZkSDeZ_j8CaLAEWoZECg2FV',0,'Amman Governorate',31.978765,35.943560,'enabled',NULL,NULL),(459,'vendor','$2y$10$WOXHKvYzmSo20KuO3ulijeZmPsGNSrYmciAYUJHebBPvef1zu7.5O','790070946','seleneom197@gmail.com','اسعد','السيناوي','2024-03-25 10:22:16',NULL,'active',NULL,NULL,'2W7R+P5F, Amman, Jordan','dIdRAvOCQXWVbjO0GsfJnn:APA91bHq_8NBArYwD2FWC2vSJ70DlB2bdnRKT5HnOIUdt2ZAeLjSlk97U557YVHC_YW-JXqqg1_vJ2S1qEq2X1oDqIbXAJA6kOSjZRzq07CMpJEctPPKySCDljTpqQLQDJkmMoDVHpWY',0,'Amman Governorate',32.015577,35.942967,'enabled','1.0.15','android'),(460,'vendor','$2y$10$wgE6saqZ9SspjV4.HACjneViZWcNE8NW/0iCCbqi3Vs5lpNAe.I4i','799294816','ahmad.aq2023@gmail.com','سيف','تلعقرباوي','2024-03-25 10:43:33',NULL,'active',NULL,NULL,'Tabarbour St. 52, Amman, Jordan','d9hS1fRkQ6-UgagkBWUirO:APA91bGbwZl-hhtK72VB-ve44aS1tDM-QoRl_b5NbEp4Te-1eIU7A3jgR5NO74ocH3CYI01CvXzpLZ_RNWztjLZIeV4zsDtCcWMpGMQ61IaKrCPGAJfq_cBtDiwCvwn90koc1imOuigp',0,'Amman Governorate',32.004379,35.950468,'enabled','1.0.15','android'),(461,'customer','$2y$10$4H.zPx8wbjOtfv.LmbE97uvLHVcJOmbTnZI1E/QXkmXZqXAjWCthm','791223201','shadarola571@gmail.com','رولا','حداد','2024-03-25 10:57:03',NULL,'inactive',NULL,NULL,'VVQ3+48V, Prs Taghreed Mohammad St, Amman, Jordan','ccFB68lBRGuJp3t7qFJXrJ:APA91bGPnyUv6s32gMAm2bJ2-aHhIB_KUdfbZnBDd2hzbdbGqMyEgopRFMdVNtSAH5z02EVqOOZaKXMe3KQlpNTg2MSn5TcJQKjl2XqRLzpekZtgxGRw1ICwnGopqISTj6p3RwcnY_5m',NULL,'Amman Governorate',31.888565,35.853453,'enabled',NULL,NULL),(462,'vendor','$2y$10$oGEXMLL5qbaC3S8O9j5KpeQcVhhVLsPEBUdLCgwvdtFKxEILIB.P2','777112984','mohammadaljarrah310@gmail.com','محمد','الجراح','2024-03-25 11:11:51',NULL,'inactive',NULL,NULL,'ش. طبربور،، عمّان،، 2W3X+FVH، عمّان،، Amman, Jordan','cZz2hINeSoq6XsGLoUWXbT:APA91bFTBybw6FZz5mcMlO6uwxlWXp_yQPkXPPeWkdvO-iyY9tG8e2uZL6t0GY27YmeekxBO807E8-9YJCQodP6Er5W-Dq5sOzYJc9LoBE6qhasUzgsY1C1uKAjs7q2XlhixILRop9MN',0,'Amman Governorate',32.003652,35.949635,'enabled',NULL,NULL),(463,'vendor','$2y$10$6n/AgVI5PXALJfFN4p20GuNkYkqWlS/miKY5PJEvE7.m5HFEOrKPu','795545937','m63877605@gmail.com','رشيد','فارس ','2024-03-25 11:18:35',NULL,'inactive',NULL,NULL,'XXF3+CM9, Ibrahim Ben Al-Mahdi St., Amman, Jordan','eZHzkonxQBCPIXPZAUNqnD:APA91bEsuR0kXrIE9o2g3IyAhFdNP_x8dvNlLWhw8wX_gD9NTVgRBOjadm4TgmEpIrnT4C2He7JyKn5d1mnMwtX0DL8x67TUTutbNUVYS3vXAC4ji4sCmgGaEKjIdYDFD0ux_KH7IPN0',0,'Amman Governorate',31.973003,35.954221,'enabled',NULL,NULL),(464,'vendor','$2y$10$ygo/jQJvHoiTMfCEiVjatejPoSWOLAtPgCbD/XzibjQ461OWOZ/3a','795000610','mohanadsodah773@gmail.com','مهند','سوداح','2024-03-25 11:29:21',NULL,'inactive',NULL,NULL,'طبربور-ابوعليا- بداية, ش. النهضة، عمّان، Jordan','f75hYmZ3RaaBqt9lJMriCc:APA91bGh60GVsrXDsUud-mgNdx2rFbn-pJlMjP0eICfw7DNb5NCPHwxDpMkf3oQVb_yjw_np95ZBQACC6NEaVLAaPvPlj9rn18PuDC-MRziEAOMmuyL4v3PdyUOg6iBJ8Z6WnPrBMY_S',0,'محافظة العاصمة',32.000264,35.953903,'enabled',NULL,NULL),(465,'customer','$2y$10$FaeFZcEp3UHhgFnggWo6oOcCF86QMPp6WK0sYz3JUj0XKhigLujN.','781125140','ramiawad626@gmail.com','rami','awad','2024-03-25 21:27:21',NULL,'inactive',NULL,NULL,'VWQ2+W7J, At-Tahrir St., Amman, Jordan','eP9UQ-o1QdSSLPw8xlPSEu:APA91bFdAr2eXHUV2QCIVHMyaFMJP9IMSvsF872UBmQxHdIaXfAtniaKhrsxaAvRLbBE2mItcQTr44CteeVWdIYg9J1vagOx3pRhiUV2LtyOVUpQGkqx6mfWcQFHE74vpjTxAhG0Iq0Z',NULL,'Amman Governorate',31.890198,35.901163,'enabled','1.0.10',NULL),(466,'customer','$2y$10$oTFAu3qh0rLGp8NZUlkSYu50oYSDTVl9HG77.B3OonUOuE9LCJNk.','797782054','Hamodehawad2006@gmail.com','محمود ','عِوَض ','2024-03-25 21:35:45',NULL,'inactive',NULL,NULL,'VWQ2+W7J, At-Tahrir St., Amman, Jordan','dfX2lGeaHUw6iPJXhgqw1W:APA91bGzPiVyTZQEyLIzCuL7zmdkGZ5pxnGuK00qxMAgKRIU6HvwediU7JA-fHN9f-vWUyiMScXTBUavtWi3AhGT04LyKjcYN7FSHDBQWzC3O-vi5stHSccKs7rIgBPtYE8AvbGzWGvQ',NULL,'Amman Governorate',31.890182,35.901355,'enabled',NULL,NULL),(467,'subAdmin','$2y$10$DrL/oy.jxsn7UpN8x0FsZuDHjQ3gX0HbSI/64vPCWX7cPMoEXz6t6','782303071','recption.pickum@outlook.com','Baraa','reception','2024-03-26 08:53:00',NULL,'active',52859,'2024-10-13 20:24:25',NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(468,'vendor','$2y$10$3HyWFlVsITz4u3yGIbz88e2aBKbMXkKZcoJ3hOccBU1HhNzl94KI2','799361455','shokatmohamd06@gmail.com','محمد','شوكت','2024-03-26 09:41:14',NULL,'inactive',NULL,NULL,'WWVX+V4X, Amman, Jordan','cpA1sMx8QzS3aRgxw4h3cE:APA91bGqEDph0QisGlZ5KRVMGEjmYflluRs6xS2nbIig_XscEMlue2LygisTjWbc76PoIn7gHbC6WCFcN-hluE3Ls4iHksirR2DFH7uqEzXQijMPb2jNmINRnLuFwCQJjTVpGJn1upcc',0,'Amman Governorate',31.944651,35.947633,'enabled',NULL,NULL),(469,'vendor','$2y$10$b1X75YQ6lexYOkkqcAjvmOZvCvmAMtI4tQI9cgKPuraKDoOhXVIpW','795387210','nm717835@gmail.com','نور الدين ','عمار','2024-03-26 09:44:26',NULL,'inactive',NULL,NULL,'Al-Imam Al-Bukhari St. 11, Amman, Jordan','c6NwGLkxT3GRn3QZ9snrdD:APA91bFTXN8RdiOznxaFJTbsqCaDq96xyjeErQXEPn_3NrtxyeK5kAvWwsEfd4fATZEjoU5mMSQLGfk6pym3Iw-5ZaLR6wEUW3V0x8I7mKgham5bYrWoscDsNeyoTZpRbwG0BNUSY2FR',0,'Amman Governorate',31.944547,35.945724,'enabled',NULL,NULL),(470,'vendor','$2y$10$MaysmWuveXUG4O4k5egbu.MUhrUotJHkyu4VlFnJNTQpirZJ0wP2W','795894295','hameh.tamer5@gmail.com','حمزه','عبدالرأوف','2024-03-26 10:00:50',NULL,'inactive',NULL,NULL,'Al-Yarmouk St. 260, Amman, Jordan','eAguRHHpT2iSEui9dDskVl:APA91bH26nWFP5_yT3guvUcXGSg_-1Ag_iK5cAAkeUR1JtiYy_N3ML1gTngegg7_yuu6_1RSGLk4UBx-ykpa1WNQ_SRv_yDCfiIZ_NPCmi-jFTr0dMiEqb2E0usfCo0lIqeV0YKsMems',0,'Amman Governorate',31.937603,35.949277,'enabled',NULL,NULL),(471,'vendor','$2y$10$lh0246lXw6JXE4ggR4xdzOwsoH79jh/MWv4CrAZO6yGdCmK7Juu4C','791150967','ralswd65@gmail.com','رائد','السعود','2024-03-26 10:08:38',NULL,'inactive',NULL,NULL,'WXX2+7VR, Ibrahim Naji St., Amman, Jordan','fpCtLD7VRGS3pK5wSDslCC:APA91bG0GeMc2thFmWQANTiokRV4jdGvK53HmwDm4116QPvj0aSpdFWhE1Cfpk47xK53NAVFVqFwYfwEveMTrqkkM2NPlxhozOqj5iGgxDAQ3iDD08JEzSCTmBUvwRzhOq2JmQdMYTzS',0,'Amman Governorate',31.948254,35.952174,'enabled',NULL,NULL),(472,'vendor','$2y$10$1Mrb0XHSbXllyVpH2UPtE.eQGnqw4L99KzOKhcrbi9Ar5YhE6cV8u','797836931','ahmed_shawket@gmail.com','احمد ','شوكت','2024-03-26 10:12:42',NULL,'active',NULL,NULL,'WWVM+CV4, Amman, Jordan','cHPDT0YUT-iZP5HXjqukN4:APA91bETbCic0FRjYoKdSha3a3lPyt-NpcVaaN7zzDPDw3_hrWgp5BR_4UO_PZlJ5sDUuGr_giuAKFIOH7ffqsEXwHWMTrTTXe59P18hwAJzd64B0ksjPmyDrYf7zPAsfCGh0niPJNnk',0,'Amman Governorate',31.943977,35.935102,'enabled','1.0.15','android'),(473,'vendor','$2y$10$hhuRbVqkoLtijh2SmOY68eGP/X1cjjC4uMnkmcvmXSOOijupRwlEG','790186675','fehdxjxj@gmail.com','خالد','الخطيب','2024-03-26 10:37:37',NULL,'inactive',NULL,NULL,'XX74+G82, Istiqlal St, Amman, Jordan','f3-GBTv_RDKT1huTBnqXqu:APA91bFH3WMtD4esEDyo5EMAeczJqjm06a5R4ffW-epQ1QLA2xooqb3BMBQbHEiBlRrcGeGIXTb3sQ-h2nLDqy8nYJgT0nGCkkQAFI77JXonwimRu_5wnARQMT2zClVDJNRRWEXMADgx',0,'Amman Governorate',31.963772,35.955816,'enabled',NULL,NULL),(474,'vendor','$2y$10$tmy0gRDe0UWDb.T2QgilPOyioJN7m/6goZVzD8smY7S4yFNGvouNS','795497569','hdhhygy@gmail.com','شريف','نصرلله','2024-03-26 10:47:50',NULL,'inactive',NULL,NULL,'WWQW+6HM, Amman, Jordan','dgERFuLMRp-q3IYNHBQzch:APA91bGGxzOWtwbA_sBEKO-AriNQGyx_Bz-Q63yrmYFU2kRp5WAmznG8b92KVn6rVzGhQsgiGFYkyHQX_VOKkoaTcDKOhwlrNreKdrH0ag9WAOyP8Pld99i3-gsZZit_Agi7tvqlfcTa',0,'Amman Governorate',31.938649,35.946262,'enabled',NULL,NULL),(475,'vendor','$2y$10$33szw0AArdUc7h.VefywveVhbPgOitFCW5s3AfKIX8OlPCBVCXfvO','796122633','ashrfalmghrbyalmghrby66@gmail.com','اشرف','مغربي','2024-03-26 10:57:28',NULL,'inactive',NULL,NULL,'ش. طارق بن زياد، عمّان،، عمّان،، WWMJ+869, Amman, Jordan','dDBuohoIQ4Cz0ifJ3CEiIY:APA91bH2czh4UE6BoIPXOa4_AHStsXFXsW4-kJwpiDg-ClSEoNA-dGci34_7oBuFDxwXVtY-8gguJrkPQ8UBeDaueh86v6PDALHelkN3PJK_GDrh2D8Bn58Vu9sdbMw_NYdEFoP224oq',0,'Amman Governorate',31.933344,35.930598,'enabled',NULL,NULL),(476,'customer','$2y$10$G2aISD1Y5w42rCquTBms.uZ0ONzyd5Oh3FJsPkGzkJMwtLLsI5SPW','796463555','hakeemabutayeh@gmail.com','Hakeem','Abutayeh','2024-03-26 15:19:10',NULL,'inactive',73887,'2024-07-11 11:28:39','2X3C+4GH, Amman, Jordan','ddXkLy8bOU6Lu3XTqsqlRr:APA91bGW3iL_M9YX4w5X5VU_eDOnByTch_syzVX5BuW7UjTdxLDVKltFEgmsS9qMPg0C2u8XvRsaXngQXYy_3lwdnwlCF4A2syqiJ0k08MlF9jSUOS5Pm1Z7ijez0tXfv9p2E66P7aeW',NULL,'Amman Governorate',32.003058,35.971655,'enabled',NULL,NULL),(477,'vendor','$2y$10$V9nAUz1YwFRTTG00J5QEAuRJRvc6.t9KeBREt0BmJrusNKZOyJ4dK','785427651','mohemedahmze@gmail.com','محمد','ابراهيم ','2024-03-27 10:51:14',NULL,'inactive',NULL,NULL,'XWQ3+78 Amman, Jordan','dtPYkcNRQKO-6ewP5ZdWdt:APA91bHlfgolCwqV2gjBUGGjcWQgJPLYAj1tj8s2m-Q_I8R9Glfdcbo3bakj4gA5uCwFmIqA0Z2HuhZdc5AVoEmta-ugm4WJHQqOGPDU1B6kh2ps3uBwfKA6UeM7fiiBUkrozLjIU8py',0,'Amman Governorate',31.988249,35.903298,'enabled','1.0.15','android'),(478,'vendor','$2y$10$2.rtnsqwitI4WgjDSOMdSeIHLzNh5sU27vkbIZqJFIewIOyTtZU9e','775725808','mnbil8969@gmail.com','محمد','ورور','2024-03-27 11:31:16',NULL,'inactive',NULL,NULL,'2V5M+H83, Amman, Jordan','f2ML4PzwTGykvABRTpIDFx:APA91bG99rCzw-okAzALoJOL1xOlcp-4vf-OkDg0A5jMs4FOqMDd2FX5iHVHTykpE4ameN-u1N7qRQe8ierJOCeCKMrdlyOtkm-6UCaHqmS0lwhcieDxaR4cViZdzGzsO3M2zb0gIyQm',0,'Amman Governorate',32.008901,35.883290,'enabled',NULL,NULL),(479,'vendor','$2y$10$n5oNA0k7PAX6hRRQ09uIuORc8h9UZ4r7hOnz/Ma2QpdWecxUqDWNG','788889095','hanizaitoun726@gmail.com','Hani','Zaitoun ','2024-03-27 12:22:59',NULL,'inactive',61121,'2024-03-27 12:29:20','Al-Urdon St. 426, Amman, Jordan','e7Vw3BRCRz6xJoXJUXL3xz:APA91bGl2HQDnXrWBqMypS2-BRwqjA3pCWTDyH_IqralEeuPFemjb8kAE9GPoQL2gVo0YMCIFjz9ISZ1EFejcii2iC69lXjxY4PpdnncA-IGPDlz_k80JvnvczTLX_2qfNMpqqpkfl4N',5,'Amman Governorate',31.999448,35.918094,'enabled','1.0.15','android'),(480,'customer','$2y$10$3DZo4DkahiZZKVJQWQyH..XNU9JtoVKvGcI.5K2ekMxJlP5aqRHMq','796093211','lujainhaboosh@gmail.com','lujain','habashnih ','2024-03-27 20:44:08',NULL,'inactive',NULL,NULL,'Al-Khawarezmi St. 89, Amman, Jordan','e45lwy-dk0KEnn7rUpKm7F:APA91bHTBWO5ByAMDORj3qucxOfIyWJjHbW3m_-CJPFTU2kigODN4m-MH0u3BajuoveLdA6gB_fSYxjGIskHfrdIGq1aI9qaGExwajzARy3mxZOvWIvaKZnjnAMqpvPrgrmmhoS_0v1N',NULL,'Amman Governorate',31.986323,35.891778,'enabled',NULL,NULL),(481,'customer','$2y$10$6W43naeGAkZRPw5nRtcmdug5PoxwS7a5MA7YzKY6gr00KBaUqLOVu','798127798','amerdweik7@gmail.com','عامر','الدويك','2024-03-28 07:28:42',NULL,'inactive',54548,'2024-05-14 09:55:46','Wasfi At-Tall St. 139،, Amman, Jordan','c86Do3P6T4G6sGZJNOQJej:APA91bH0y8w3GsjK4c32Iwvsqin2SIh8lKalRV37kf1RU1PPlzY1PM8287fQVmZwVvUjvQEWZtp4pOuBM3uAdyGvd6nd6MONyPevyiWBebz92s9370C8SmLbYPQgFtDWC4BNoWFMfr-J',NULL,'Amman Governorate',31.989856,35.871408,'enabled','1.0.09',NULL),(482,'vendor','$2y$10$C5UeTqSwj4PMOv0A7ScCnecnpfnkyRMPPe0fqvMOtWq0LmFvzpfFG','775553629','skir27892@gmail.com','عبد الفتاح ','المريدي','2024-03-28 08:12:52',NULL,'inactive',NULL,NULL,'WXWG+H6F, Hasan Adh Dhawaheri St., Amman, Jordan','cZcgb7oBR8eIfsHZ6qgRvc:APA91bFckifiWG8hrPQF0qeUPjVpJt9LMEeN3VFq2ZwnLRZHLOC4VUd6agtPMCUTRMrJ7Ja8DNW5goLkbCqlaQd8TAEt7RHi1108eiNVQDW65s0O2kOmxevrbphWgtoHVzBLHs_zdHs6',0,'Amman Governorate',31.946056,35.975260,'enabled',NULL,NULL),(483,'vendor','$2y$10$YxMa/tOft773UTy11t2W4eSG1hkRNsk7IjI49D9TlrgKVI.dA7ar2','781700123','hassanyalo2003@gmail.com','حسن','علي','2024-03-28 08:31:52',NULL,'inactive',NULL,NULL,'2259+373, Russeifa, Jordan','dOk5d9OtTr6REuSZfIT_wP:APA91bFugt2uEDMmbxVuL23ahirFcUHeinuW_d6E253R9H3V7rM-jh07E4wShXGIFc0L-0dbeLgmVlQJAxYkaautErADZsN5LS0gVzErpnRoSQe6MMv1ea3N5bFhp4949YcxikqxDjEn',0,'Zarqa Governorate',32.007805,36.018293,'enabled',NULL,NULL),(484,'vendor','$2y$10$niJ/K1AbpG0m8mSh7z9Z3OII3RUDSxaV9o5So5xbjtyTRD/hOA1Ca','781903937','osamamansour@gmail.com','اسامه','داود','2024-03-28 08:56:44',NULL,'inactive',NULL,NULL,'2259+373, Russeifa, Jordan','eEGIh9olR4OR9aIxryS5HJ:APA91bH_XDbVEl5_b798543SQMwTpYq-rehPwvOb9D6GDuRn9QTZs42o3VbyikhJ9WBhDpCTO0Dk1cCvdKOTxv7BcUwaORci94Tm_11H5lYOnzsU2NA1wmSrrG3MEajP_8W1Szv4WmhZ',0,'Zarqa Governorate',32.007280,36.018287,'enabled',NULL,NULL),(485,'vendor','$2y$10$k5WnuxNFwjZeXc5TauFVA.uwPdmOgKFjjaIkaglAnKm9fetOI9Yjm','785079377','karimelsaid335577@gmail.com','كريم','البرعي','2024-03-28 09:19:36',NULL,'inactive',NULL,NULL,'XXGG+VQP, Amman, Jordan','caHAftjwS1Gnd9Hdb7YCDO:APA91bHs3GjL4Rk2Lshy0NHkZxUGeYSoLmyqZOR5-0w5jYcVNAA_OuWRoM93ZIc_RqXz6uxXftCqmTdfkMUJJTEUIsO8XrO7OLRsamtDTNORM6BbsFB66ASL-ZTiCliIXgoOsXyGKRLV',0,'Amman Governorate',31.977621,35.977085,'enabled',NULL,NULL),(486,'vendor','$2y$10$OiIx4p1AcxozSU.NKxDiEOuA5vdNEtgA.l/QznfSNiah18S6HisDW','787874060','somiaaqazeed38@gmil.com','مروان','الرشيد','2024-03-28 09:28:50',NULL,'inactive',59865,'2024-07-06 08:42:10','XVCJ+JRG, Al-Kaswa St., Amman, Jordan','enf6xIrISOyuD1oAEHO2IQ:APA91bEi5jRh0fUDBPTtzzVzC6KSf5_DM-oMhCBn1Jqoxm5olpxtgbdn7blvlraSdbU7bkEPR7KUetuGoVjRI0S7rMzxE3d2nYgbUwwZMwLNm3DwOUfIjRDPoOlmiFNTgBIhpoPLjkxS',0,'Amman Governorate',31.971624,35.881768,'enabled',NULL,NULL),(487,'vendor','$2y$10$eAxKn51xDgVeB4Rc3Ivrce2pJKBq6JGVKoN3CWGwRV6WuUq/pFYx.','786024149','ahmadalkaabnaps4x2@gmail.com','احمد','الكعابنة','2024-03-28 09:32:58',NULL,'inactive',NULL,NULL,'XVQH+V23, Khaled Az-Zurayqat St., Amman, Jordan','c0TN9wlyR0G2NM3_T0jndf:APA91bG8jcbRHKX0yVZLVO0SHNqUiSKYkUhcA8wDjrtSmDdOmHyJ7PnXyh1uODxTsB7TnrQgDezK0kqeOcK1DGc0WR6dpaJnqpXTRuGK3lGL_DzbyZYfG_c4HXSz-a6k7tRLbQ8CAhUP',0,'Amman Governorate',31.989636,35.877555,'enabled',NULL,NULL),(488,'vendor','$2y$10$Qv.G6NAW6BPOot9gr6xEK.WtKtleyZwXUHbA/f.w6WCyD4b1Ru1VK','795969209','mobulestar4@gmail.com','رامي','ضوالحه','2024-03-28 10:47:54',NULL,'inactive',NULL,NULL,'ش. الملك عبدالله الأول، عمّان،، XXJR+RWV, Amman, Jordan','eQh2w1IkRuySordiA222Io:APA91bF4FRmQGHXaM3xujhP_cxEZYCgSes1ZuD1n5rVex1aGPaEX6_JXVLDKjv3KELvEesKfSZM5RYC3Po1NEq4dxhGn1CLjkTyGkpVxha2h1JDOQc1xLpcDKlUkKWZrlL9M6pwA8C4X',0,'Amman Governorate',31.981608,35.992362,'enabled',NULL,NULL),(489,'vendor','$2y$10$lhE60eEqE1cBmT5YFYLz6.SVVBb4V24Jz740yekbJDoDvYEyvoGDu','797253707','bxbxhdjdbd@gmail.com','وليد','يعقوب','2024-03-28 11:33:03',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 220, Amman, Jordan','dC_xEWyqTbqQYokml3MTKj:APA91bHfXfIhp5mvaD36uHADDF0PZ8aJaKN-hv2bYTptE_5XtH5UIFMT_P0Z9Ku5DI4FJljGhXhqdUqA5VOAB1gv5EqegigHnH0tyro_R6fYiQ6nt5LRchMRbHpXufE7rNHVDPru4xsn',-3,'Amman Governorate',31.995156,35.857846,'enabled',NULL,NULL),(490,'customer','$2y$10$6Vpc5g3I1EQebwT9ymUFautPi0rRNuyKKRj5mdwrwTvLh5SzOqcc6','799911739','aburashad1@windowslive.com','Mohammed','Moqbel','2024-03-28 15:45:18',NULL,'inactive',NULL,NULL,'2WVG+VWM, Khalil Hamad Al-Omari St., Amman, Jordan','fDNGHr6vXUPmhdcT2Rkx5Y:APA91bEFf7B3PX07pkQGBzyrpQ7_moa5s0LQBit9tcsNXPh9Tec0skNjKbVTULm0B4VHzZGa9vVElo-Kn39raHnAVPR6jxvx_jWX-RNq-Fm3gTt339I3KPU-8sUzuskBnBpTf8q8OrDn',NULL,'Amman Governorate',32.044051,35.928715,'enabled',NULL,NULL),(491,'customer','$2y$10$4eEtfAaW9m9rr4FTP0zRiujrmO4LSw7p1fTiHuEXULJysqPbtkzy.','796462439','rashadmeqbel2006@gmail.com','rashad ','meqbel','2024-03-28 16:49:56',NULL,'inactive',NULL,NULL,'2WVG+VWM, Khalil Hamad Al-Omari St., Amman, Jordan','ed2f-4oySUuVjLXp4I4PUL:APA91bGUnUWsPrlkV4pgJW0u5spyJzM2AwW_Mg6Nue6YjP1w16_6ddxnkNj9HQ7qk5N4slmW27ayz5mo20ZdGxrVKwCG_jPare3tSaj43iy8JNfhiBoLLPM_Wu5aaISIp5Nakxj_L2qq',NULL,'Amman Governorate',32.044004,35.928633,'enabled','1.0.13','android'),(492,'vendor','$2y$10$aL7B43fcerhHAw5KIXNOFu5E7YHZRCvA17MQwCjSUGU5NWgEutC0u','781822333','jaberalhelw4@gmail.com','JABER','mohammad','2024-03-28 22:39:33',NULL,'inactive',NULL,NULL,'3V6H+64H, Karamah St, Amman, Jordan','eVOSBvQORXK4TkvzYWcJJC:APA91bHYChTZ_bUYC0zppVEXApUzuEexE4ICNYkqjkNpq3Pwa5uO5P4Gl4xE9at0ef8sekRPfQSxzJo6PCDXK9DHNOWX_O9XsLnjcQ-w85OnABg7lQyTtLBP0l1gexDQr7pLP5LlHDua',0,'Amman Governorate',32.060602,35.878372,'disabled',NULL,NULL),(493,'vendor','$2y$10$/u2TwkOlTfJGoim3hr5hi.XV5hSvidJ0.18GpRlNFJW3W4rPhosUG','781828311','hamzaoweiwi99@gmail.com','hamza','oweiwi','2024-03-29 10:35:17',NULL,'inactive',NULL,NULL,'الحسنية،، WV3V+76M, Amman, Jordan','f2dWAp1KRT-UC47JiwNhpG:APA91bHqu1l06E7YrjVSIZCjOOzx8Ti7F3F9GHcfsnzVMPGnPeTevYjI4OSLTXv8AJ_JZSE8E_g1Ys7V4buKRDuKmTBQdYUqSnpXuDUvvC0gq94DLUFnZ4SGlkxceyA5-JpbBnpELyKV',0,'Amman Governorate',31.903112,35.893198,'disabled',NULL,NULL),(494,'vendor','$2y$10$NZDDcV/7Zl7HbKuQCuOM4e.Urc7s0k5YXlExgzvdhfn1peQ0AJXdi','785076018','honor83749@gmail.com','جهاد','ابراهيم','2024-03-30 09:47:18',NULL,'inactive',NULL,NULL,'2WW5+WPJ, Shafa Badran St, Amman, Jordan','fYtg-KQGSWKQW2T9NtqpBR:APA91bETzNLpxm28qfK7qgxoYswi_grSSjYaLtZMZR0Ch3v1pQnsKEs9HSqphSajklUNSgL3hHU_AafGZQBCbc0ywtUyxMN4VyYgNRZtzwj-qNJigL_XnUTg7YCJFKCor7qW8fxIQBho',0,'Amman Governorate',32.047393,35.909467,'enabled',NULL,NULL),(495,'vendor','$2y$10$KQFaHyaoxU2hfuIBHmui2eXKTSxjxRYWUfWkVnJsVBqcLDpbqqrHa','776687201','abbadilaith6@gmail.com','ليث','العبادي','2024-03-30 10:45:48',NULL,'active',NULL,NULL,'2VF8+R2P, Amman, Jordan','cul2mzJvRC6igshSvP9vCX:APA91bEJYVc0y_Rt-QTMzsAg7nku1ekgidn-1gA5wXho4VW_iW3Avk4p_0UXO9pEn-N0GkJbgMmkIJm0Lh01hwwqsJSITpLsAPyA4xoHkCxGE_7nLF9weSKKdIAlbstORr5Ens8kR86q',0,'Amman Governorate',32.024580,35.865024,'enabled',NULL,NULL),(496,'vendor','$2y$10$/5cWPbNUQEYYgpJChwBN3.Zbu8WtgV.r5lau7IyEAbcpHYUufXEOi','799730505','ahmadsarsour2022@gmail.com','خليل','صرصور','2024-03-30 11:07:57',NULL,'inactive',NULL,NULL,'Wasfi Al Anabtawi, Amman, Jordan','cfSGhlHfTWOVQ92hrXx--U:APA91bFHCgV4rcA-H_Le9ur2-ws3MU8OSXAJsjM1sGkS-L31gwpN4ohlc9LkTUgajG79Oh4frtN6CKlHi3CvMZItdO02xVyKVlhbNin3Fdu8qfzvgSinsC_mf8Zhru1jjzAXhhyHrDMe',0,'Amman Governorate',31.996489,35.861044,'enabled',NULL,NULL),(497,'vendor','$2y$10$i772Aij.B8DF2Vy8Yk5R5eMpRuA/JIevAFX6WkGJ1MM.aZ33V4EAi','797556804','Mohammad50medoo@gmail.com','محمد','الصرعاوي ','2024-03-30 11:27:28',NULL,'active',27365,'2024-07-06 08:40:47','2WV4+R8F, Ibn Al-Qabesi St., Amman, Jordan','dNRItP1sRFWCbu2BI2HbSM:APA91bEWApzojDb2m1BSBueBTABarjjLUw9BYPXswZ7l2JQ2YwTmU_dno1PmTkiNw3hQNRU5-KXq4DD61f5BArrW8KwB0otxj5kolF-p-6Kykn6Q1K12bmM4J_0oYGPtGr1AprZlxF2D',0,'Amman Governorate',32.042505,35.908293,'enabled',NULL,NULL),(498,'vendor','$2y$10$6/yFIz8n3O4PfQlxZe3lxu3J/fr.EkQjeSelRBRRZ9erX/PjLJYHq','791414519','Abu.molh8448@gmail.com','ملهم','ابو جيش','2024-03-30 11:28:14',NULL,'inactive',NULL,NULL,'Jarwan housing, Youssef Al-Lawzi St. 7, Amman, Jordan','dDZhcypnTlydN2dRp18gag:APA91bGBM4UCLJBdiAC6CpIqE7BaAS26VTeyUm7vD9JNEOWrXvQ-KeLeLuZR2s9KShsYM6NeNTQaHlSD_b9-y16PXC1qbtrUpa9znErGuL0ikQpbVrKAk834ulOSOz6Wza_r4K7QTzfn',0,'Amman Governorate',32.025957,35.870865,'enabled','1.0.15','android'),(499,'vendor','$2y$10$/8VrzqRkRZ6jw7LwgR205OjMDXXY.q97W5Q1yThXxqWoCp.BoPP7u','775338448','ahmdgogzh1977@gmail.com','احمد','القواقزة','2024-03-30 11:44:27',NULL,'inactive',NULL,NULL,'Yajouz Rd. 49, Amman, Jordan','ezFgoiBXSEW4nUq1LSGGWH:APA91bGJT-OMVC8IDWuXb_7YVP_P8VHV24UksTtMDdryrtaXzHZ1DfQhC2NuJGhDgJPc5VkbZr6M0B8fDfE3SS6nFcy031jNUAx-QVKjdnOZabOP_wijbzdwgd0sBdZnHdGZAnwK8-MC',5,'Amman Governorate',32.028821,35.863332,'enabled',NULL,NULL),(500,'vendor','$2y$10$HsuGE68MscflZHdciwmIHeiOUSco9RKz89gbj8pdcqaGOXF35KcSG','795690729','mohammadalli19540@gmail.com','محمد','علي','2024-03-30 11:47:16',NULL,'inactive',NULL,NULL,'3RCM+PM, Al Hanou, Jordan','eEPK-bryT6-TQaUGn8RBmZ:APA91bHx7e7R28KjiKMgUn29QItGhdnppDaSM6U__gO5yP_P3_g1n2rGn9AFmjrHicC8bGoYlsYnkdeepzNBcJJeqP8T8l1aX3GLcpgG2t565huwITbU6Hhimr_aAFPdn65zEmaF0KGg',3,'Balqa Governorate',32.070726,35.835143,'enabled',NULL,NULL),(501,'vendor','$2y$10$9fibFWHbX/tn8Mi67com9OUFd4DOQEqIllA7n/6BYvU3psxDKUsvC','795940603','tamaramobile796437@gmail.com','عبدالرحمن','يوسف','2024-03-30 12:18:47',NULL,'active',NULL,NULL,'Zeid Al-Kuroum St. 28, Amman, Jordan','cg6UopiwR8eGtUWM5QiQ17:APA91bFVEVD0oEH7h_0zxvkCBkx_v-boNAyW5AJNiwfij8ME-6y5fvRDQ1UtGvphIMmxgO2gpVpMYxuZjKUHRXJ_Oidd3XH82__SkR99rN-aQqVy1URy7btld_KM_LAXPkIaEGgM2ou7',5,'Amman Governorate',32.000633,35.916387,'enabled','1.0.15','android'),(502,'vendor','$2y$10$vPCP7nDk7ZalU50h1cxwJ.wxba/e1i1tH4ZfpzyuKI8RNHXYAXsKS','795360858','abodzeaid4@gmail.com','عبدالرحمن','حسني احمد','2024-03-30 12:37:52',NULL,'inactive',NULL,NULL,'Enad Ali Az-Zaghateet St. 19, Amman, Jordan','dOxbx4iJRziZm4jBHaKQGt:APA91bFBj5WTksjHUK2ik1iGNbM15xRamaFVZk6X8YfZWAp570vR8GGlYVcdtM3szBYEEmaBdAux_srdZJjdMhfhVezgTOlGrg_-NMQfIxAUNEpTiifYYTHW7pQjezl2TevHtfvNjiPl',0,'Amman Governorate',31.980569,35.940654,'enabled',NULL,NULL),(503,'customer','$2y$10$yDjA.8DjjEDZJ0MrUxbOSe2RecqBxhW3X8AedID8MO947R4G.LISy','791309324','husam.bassam1@icloud.com','husam','alabdallah','2024-03-30 14:08:09',NULL,'inactive',NULL,NULL,'WX78+F96, Yaaqoub Al-Qari St., Amman, Jordan','fDj-SqiTkEjBrwmgkgC6MR:APA91bEbzttfUYdJXx3xjOBabNkAWw-CRj85huvoYTuTgyxHdqLXLoMSRIc3Kjqv8D1pReT1oPCPYXt4TnpVmbMbPx2EO-r350m7CYRK4hrgGmgikIAHdoR8_tj27qc8NurUjH0PJEOs',NULL,'Amman Governorate',31.913429,35.965951,'enabled',NULL,NULL),(504,'customer','$2y$10$VhfPAEBJXciaoEc.LcG8QuoQLvL9lUTTivfoGEQ8Lh.8pHLIPZF0K','797300709','ahmadabud991@yahoo.com','Ahmad','Abud','2024-03-30 20:23:36',NULL,'inactive',NULL,NULL,'31.939511,35.929247 Amman Pr.Hasan St. 72-76، Amman, Jordan','dtmkYgHnlUKWraBeqCdZcA:APA91bEt-GMBkxD5rfZmFUP2qpJXtWi6ArSpHK4OG7WO84Glu_JsXiGf6yM4XTMdbs6rWDTpfitxbEdKeXcbaTCQNSWRUwXwaBJ8COqF8fz_w-cooXSYAn62SPhtcPmbpmoADnLB8VBc',NULL,'Amman Governorate',31.939509,35.929215,'enabled',NULL,NULL),(505,'customer','$2y$10$F1wgjVHoRhodZqTIJfYB2.wUgXxgRUDJbdcEaKUI/fl0cJLmREQw.','787416627','yazan.s.kordeh@gmail.com','yazan','kordieh','2024-03-30 22:08:07',NULL,'inactive',NULL,NULL,'2X58+Q98, Amman, Jordan','dfvMWc_XQ9WSf_Jz4BKphR:APA91bHSNqkp9zyvISNVCK34pDYSMrjWQXp7IMR1bVq1GRZ78maiqmZEGwK4ONdUyajV084Ady6Kdg3IA0yUpzYwAFaJVW4MtTy4fRCe7veRq_qJLlHnOMDUCg43S37fje6Pj6gpG_Vq',NULL,'Amman Governorate',32.009468,35.966624,'enabled',NULL,NULL),(506,'vendor','$2y$10$BoupcIGJDMAIUgW8lGNfO.eDw6rZMAQ5dZ6r0gxnT1s2k8Bad9/Qq','796026408','mhmmdbhtb@gmail.com','احمد','بني حرب','2024-03-31 08:06:56',NULL,'inactive',NULL,NULL,'3R57+X2 Ein Al-Basha, Jordan','eaL8lwexSfWGIETObKjJrU:APA91bEkOUce3IMtX6EoXntMyCyhE0kCn1waAxkEyh0WnhUmCXRRvHv-pxp8LcBe1j5sRKSUTbSd-qqtKTRr4nKSz_cWlLrzTIg7hBkCW6MGXh6iWGorNNyaeUflHGSr5_WLX6ZmuKxU',0,'Balqa Governorate',32.059877,35.812569,'enabled',NULL,NULL),(507,'vendor','$2y$10$IvnOvuSA2fQb4d7hyaUJGujX5kciqhniOMxpPF5RJKZOTmd1gmlmK','779701135','mareealfaouri@gmail.com','مرعي','الفاعوري','2024-03-31 08:22:36',NULL,'inactive',NULL,NULL,'3R5J+7HQ, Hizam Ring Rd, عمّان، Jordan','fVWulktMQGSh7sRpVDadGl:APA91bGbdTf5UwxjRM4f3sJMob1gVp22NhpNXcMa8q4_Ungx0Gp5zIKyZogs1jBfuNA4oKp_VhJOSRaVRg-TjtNu4A6_-6tY9q2JqXEmsTU5K9lVdQq7tUTX7IcPGVJXQPWnS6LCDHp1',0,'محافظة العاصمة',32.057623,35.830834,'enabled',NULL,NULL),(508,'vendor','$2y$10$GJUQjfwz4qB1nEYJkeDVJOij.O2X6MNdqOYrzm35GdXueezm.H6M.','785444147','Kenan26.adi@gmail.com','معاذ','عادي','2024-03-31 08:35:41',NULL,'inactive',NULL,NULL,'2RXF+VXH, Ein Al-Basha, Jordan','fml9EIzsRSat5yGpxsCP4W:APA91bHnjlVsU1H7osCgzPZ00m2xQp8c5yj_VMuSSGzQ9UI119MU7JGA7YMHZpEczuRxqTSQxniVWYE0OhHoRxV8sH4Tvf-MlFzXiRalluO8AJ4lxH-umGDEOADnIZiHZNx8R1320x5Q',0,'Balqa Governorate',32.059083,35.825299,'enabled','1.0.15','android'),(509,'vendor','$2y$10$o7HhmUDN9BzLIaZzmw6F6.nMbk5bVniEYsjFcale9VhLOgbq18HI2','782942027','ieadarab9@gmail.com','اياد','جمعة','2024-03-31 08:53:51',NULL,'inactive',NULL,NULL,'3R5F+HCR, Ein Al-Basha, Jordan','dbK_GOjZRGe4q54ihy2elx:APA91bF5I2tPpLv7tznhDQXkUAyGgYoEy7JhDxkBcMoYpRFwVyHm_cE10KU7ZhiECf0Q4CH5L3BjSaKwu5rBphqmORFKbfiQcwkxXOK18kVg5vEKq0jo98OT52b3bZNqUa5yeOIlGG0f',0,'Balqa Governorate',32.059161,35.822989,'enabled','1.0.15','android'),(510,'vendor','$2y$10$XG5Og7w3bS6NugQe6Z3/pOaXcDRK1M3mDX1PGgtuoRc.133uVlAEO','798048210','aalshabani373@gmail.com','علي','الشعباني','2024-03-31 09:04:17',NULL,'inactive',NULL,NULL,'3V5F+J89, Amman, Jordan','dQZFFpQiR22AWsbjHiu4X7:APA91bH8CQ9QiRoRdKepAZ-Gtzslks83xnp6mm0KhYEfH9deIsds6K5urO6L3GRqJJS0J13bgm37_uYXk6yXcH9Ubgi_UHv4yAimaM0n7O5fkezq4YGnnfYxA6Ya9HnIOuOuJXyoViQ4',0,'Amman Governorate',32.059341,35.874077,'enabled',NULL,NULL),(511,'vendor','$2y$10$QGBpxTJ5FMItOBmf8QPrPelb0tNhAPU27ITKKLlE9T2hB1KruEk/K','782121979','mhdawymhmd710@gmail.com','محمد','صبري','2024-03-31 09:08:25',NULL,'inactive',NULL,NULL,'3R4M+G4F, Ein Al-Basha, Jordan','eN7xJ8Y7Q9qUi_MSGrCegj:APA91bG4DQUfrbnROm1gFhCP577j-u5tDyNMpPRftlGwgWJjxu2_Ccitj4IFI9dK1Yg9zJjDrIHpH3XnA558nq1acOHs2YzDlJsgQsKJtyIlvI0miswNI_4-bKe-HSZZVEptXzFAuXhP',0,'Balqa Governorate',32.055650,35.833135,'enabled',NULL,NULL),(512,'vendor','$2y$10$ZcjRuUa/aSu6n3uuMiPA1e17oiz0UV33RehaFOi1/nztOiadcFicq','782630579','mf3282518@gmail.com','محمد','خليل','2024-03-31 09:11:21',NULL,'inactive',NULL,NULL,'3R4M+G4F, Ein Al-Basha, Jordan','f0KsVqwNSNyajx1dre5shT:APA91bHyUF6KocV2GF9TDhZTg8m-DWrEnMSViHEipyK6YacSkbQEBxzMYnpHurYExnAVExVISiOmNfkD1PoDLaflX1WUhOEtqzHFNR6AAlqrkkOeK3STmruih_d9ce5VXBo-zBE27AN-',0,'Balqa Governorate',32.055732,35.833113,'enabled',NULL,NULL),(513,'customer','$2y$10$eNc71bCcSeAjAhsK5EB0y.T.Xvp1NpG3UqBoUKraqhohMn905AB5u','798048210','alialshabani69@gmali.com','علي','شعباني','2024-03-31 09:19:10',NULL,'inactive',NULL,NULL,'2VR4+2G Safut, Jordan','eDjyza1pQvSJ7lEuxZqzNm:APA91bEIXBYqUYb7pGIAwPWKuvpb5SlvD0aH7aotMpVE7ZMVT9RMrcbVQ_4yGzWZ4Rf-I2zIFKdOVlkyfZBAGN26WlC_JtvWGtk6R_SVvT0tknDXZiLmIeIUAzJgwqt2R3K0qGvLL0Fx',NULL,'Al Balqa',32.056029,35.876248,'enabled',NULL,NULL),(514,'vendor','$2y$10$RtAJc75oXovNoMxdvPX3LutmOAtzbW/nxgE0yWqM94NUhsoYC8fy2','785066619','ghg00054321@gmail.com','رائد ','العزازمه','2024-03-31 09:29:39',NULL,'inactive',NULL,NULL,'Karamah St, Amman, Jordan','fgM4ZwyJR6yV5DNzgyt-gL:APA91bEOLWWkSo29X7RfKxrhHwkfiGvOQNu243yEJ64bG2wCYbJgMNNJSZ9dLzkO8WcJwH6NCFCjuW0NJqLDau1_VH3_5MqM7k-6iXLEykDlOyKG6MlWVMPkGxguKDKVnmJwTNiGWw3v',5,'Amman Governorate',32.059074,35.876592,'enabled',NULL,NULL),(515,'vendor','$2y$10$2C8SG1FsAUgLho8mI350HeQUhTxCB4vBPJPfvdXZioWkBMVWFvcku','788669778','ghgg79059@gmail.com','رعد','العرامه','2024-03-31 09:31:18',NULL,'inactive',NULL,NULL,'3V5G+MH Amman, Jordan','cn3Xt0obS4-P2qaYgM41Ih:APA91bGUwmeft0oHjfU0s4PgLOiaLRKWdQB6bvyxyU0hrudtrDrjJ7NgeIC1e__-dnXgrz17hquOqU9OLTblYZwe2s5-KBFBocZaLt08yMKjkFqzS_ypVNC-yQptbH6KIi1_QTMNzNGp',5,'Amman Governorate',32.059158,35.876390,'enabled',NULL,NULL),(516,'vendor','$2y$10$5iWA7a3RZYZkZgitTIdRaO2Fh/sI4n83CxJ20pIqhouvcaQvCXwO2','788537740','anstrky993@gmail.com','انس','التركي','2024-03-31 09:41:30',NULL,'inactive',NULL,NULL,'3R4G+7GC, Ein Al-Basha, Jordan','dC-l1j5US8GJK-2zWVgsRr:APA91bHLSp2P8McVMnC1vmdyYFjsQzPMAuOIJJ-WE52Sx3EUZ6rIDNvEK-N_5IfguEfJyrsfEekdEWDkSl3516vvWMjlphU6MW-bOeinD8mzJdHzaxYwCUFdugwKlijlxMpEi7hQUJZw',0,'Balqa Governorate',32.055692,35.825910,'enabled',NULL,NULL),(517,'vendor','$2y$10$AuvsCxxnlIA5jVw1O.l.0OksZu1PkvCh/1aeLbLqAvJZ9cIg6mZtu','776282638','omaraidma20@gmail.com','يزن','القيسيه','2024-03-31 09:56:27',NULL,'active',NULL,NULL,'3V2H+C47, Amman, Jordan','cOS9kZ6ESEGa7xlUJp-ozD:APA91bFtzqnP-Jt-6waLHrLI8SU7KXeX5GT8d2uIXLlVFc8pNT1hDof-FhDfmxd_qlvuAo4xpyD1AYsldH0FvcrICsnkCrChjiLck0tc4mMc7tlC1pjL7zOgFR7kD162NIg75hLejEDS',0,'Amman Governorate',32.051247,35.877575,'enabled',NULL,NULL),(518,'customer','$2y$10$N777uWOxch9zArbBp741cO8FO.XPNRsR3HxtILQynk3veSeWeYAfa','798257470','hamzaadnan98@yahoo.com','حمزه ','نواس ','2024-03-31 10:05:21',NULL,'inactive',NULL,NULL,'2W6W+F9V, Amman, Jordan','dIpZ5VumTvGs2G0Q-0ByCm:APA91bFAox4dHVIGQFosOj203bVrhctkygne3BkDTy_vaD8u45ymEBK-3Fub6kWVH0DwDPDFBOIJscHom3mYXdy9CwMU39X2U4qebJw7W_WT8Wb_dgeOCjw0LtpY2gWGCadFLJO-Ml-8',NULL,'Amman Governorate',32.012134,35.946301,'enabled',NULL,NULL),(519,'vendor','$2y$10$6AaDPq4HP4VuCsFvC/wo8.zLUs/vkjXBQ.okFaU2D61yuOY.o3Cae','780361661','w0780361661@gmail.com','وليد','ابو سارة ','2024-03-31 10:11:46',NULL,'inactive',NULL,NULL,'3R7P+7X Ein Al-Basha, Jordan','fQNS2yGgRHqCL9qTR_X3QP:APA91bES_4rC-m1igC_H1NYf7tAOeV_RpGmXDn6W97sKF-AW1BEMKduAlJHzBDXlVuv3O9dk77itJLDPL0WJ5LXMK_BOVwDBp_mIhyAPriN4YIdOwMJ3hS8V1kezZuwALVdcMgPJNpcC',5,'Balqa Governorate',32.063213,35.837445,'enabled',NULL,NULL),(520,'vendor','$2y$10$X6TMBUhGdi78zeqawqYPtuT5aAwqCaPM1ChfUkj7Qox5c9bapdK7i','786091733','mwmnk860@gmail.com','خلدون','خليل','2024-03-31 10:15:44',NULL,'inactive',63218,'2024-04-01 08:38:12','35، Jordan','cxxAqH28RpaCK4odAqAnBp:APA91bF4bQgRg30HZImX2SHMIjmwvqgPnkr8RxR9jl7N_xiryahyS2rySAJ50kDmxialt90rUPVe302mLD9_lVN0StJvWuDukZFtZ8Zbt99Sy5DoWLDfScVIykPh_gM_4oHl3R5qW70l',5,'Balqa Governorate',32.063946,35.838991,'enabled',NULL,NULL),(521,'vendor','$2y$10$28iLCxVtvZEoe.2BtfXFNeDNmkQQ9WG4AwEIu46bTQ1aAQIsXAuuG','786193146','alamnsyrmhmd@gmail.com','محمد','احمد','2024-03-31 10:22:12',NULL,'inactive',NULL,NULL,'35، Jordan','c2NZ91fhShWPAX1TVhVUkx:APA91bHLv_VyJ3PWu5uc5ExKviQ4aDYig0z1hzzNg02_4VgbksfpAkK_2Sxnyl2_8RSqwHNHvut37QwXj2sQ-xqYDOiZ-YqvWuGOZsNts64RIq9Jg7RH7B9zyllCIwq1TSK-NOKL9KbX',1,'Balqa Governorate',32.064136,35.839093,'enabled',NULL,NULL),(522,'vendor','$2y$10$MhJWFXK.yVlQSHfzJrcdEuaeAgfxiVDboLPuGYo8i.Tq/vrug7lMO','780068005','fwadabwhdyb7@gmail.com','فؤاد','ابو هديب','2024-03-31 10:22:36',NULL,'inactive',NULL,NULL,'3R8R+49 Ein Al-Basha, Jordan','f4Tq7XkQ01leP6EmnOpXLV:APA91bGsu59VL4aAXDAwgJtmh479TtFX0cpSxBtHYF5cD6Mghjm6OiXfmGCXiBoOJA5jKSvLAe-ZoN4QJL00y6DZr8BDq3J1ZUZhwOasfVam7Q2ADTi1de3bH_2O2SIDSDsLkhQs3oZW',5,'Balqa Governorate',32.065296,35.840985,'enabled',NULL,NULL),(523,'vendor','$2y$10$eNXbqd3uvEEXuQgcxJ.Kvecp5FiJtPjblZ5LG5ysnEfAyF/2ENJiy','780677123','salman.alqdah1981@gmail.com','سلمان','القضاه','2024-03-31 10:30:27',NULL,'active',NULL,NULL,'3V7P+C2F, Amman, Jordan','eGIF-TYaQcKJY4SqQH_HGp:APA91bHn7-cs087oPaJPYKP6GiBvF3SoFfQ8s7FOkN4QCJ4QonH1xVEP3AtQNroLeGIHcQxWyLsVWbd7JtkPH63nhYjPXLQDmBU_q7AK_lqGsfJzJna3dWJMq0NvxZVhI2bTz-JDePUc',0,'Amman Governorate',32.063385,35.884701,'enabled','1.0.15','android'),(524,'vendor','$2y$10$B8oFwVHDy9rOkPgpWFLWu.4RgrkESp.IyKrno4JrLc166ENE4InCS','786295422','hassanfoaad042@gmail.com','خليل','جادالله','2024-03-31 10:31:26',NULL,'inactive',31987,'2024-07-21 09:00:44','3RCV+Q4 Al Hanou, Jordan','fPqtuUqVSpuw8ah0iu31Xu:APA91bElEBr7vFWUQFPXsCmSnnulrgn9ik68oP3DyX68PmB_-X2806AeWUIje00RXDyMlBFGrrsEbXUvug9O-ZPWo-aHa4GWa_XBKVfUAdNsMD6RG8PzZw-wsN-3qYR-Z0yQc6fNYd7e',5,'Balqa Governorate',32.071997,35.842765,'enabled','1.0.15','android'),(525,'vendor','$2y$10$YpPxFpoN/oewRPOAEopTgOCMUOfHHCFjN6jZAvIOhszd.9TiqHEN.','797418311','alsyrawyndalalsyrawy@gmail.com','نضال ','خطاب','2024-03-31 11:05:45',NULL,'inactive',NULL,NULL,'MCP7+4F Ndonkou, Chad','eSdaOeL1RwebQV1sJ-4R2L:APA91bH56-j-sPMSoUNskd_WY9wspkZTdTnLXkLq4-rTBrdZEsSclz6CY8WPLYyQ-xBW1GVGAug1crb9j90ZhZlBQjZ0yTCcxqVXsfDLkBAMKdsfwEbU440GrWOg25SUQ-FP8YueB3G7',0,'Lac',31.912094,35.942649,'enabled',NULL,NULL),(526,'vendor','$2y$10$4OJ6.4f5EfcN4LvO38nOW.sDTTCgl/qNcM/ulYjJhyhF1eknV0zke','792307111','link979096@gmail.com','بندر','العدوان','2024-03-31 12:07:12',NULL,'inactive',NULL,NULL,'Shafa Badran St 89, Amman, Jordan','dyz_CELKT1OODGwDyNObZ7:APA91bHSpvKgN8XbyPfw7P6PDULo1MHRRGd0eQ5RgifgGfmuLIUerR4AxKWHQvxvHbHbqINHOCj5y_DC1z11eZlUZHg2zAgBciDgdVw5tR2dyeXGtkVZPM5VOeusPnjLqTdjt_vXtQ3R',0,'Amman Governorate',32.048894,35.909944,'enabled','1.0.15','android'),(527,'vendor','$2y$10$Jx1RtgiIFmN4oTRWk2V7GON/Wx0jKjZ9FU7S0moqj1P0WucsVuyBm','795009410','z0782649149@gmail.com','علاء ','المريعات','2024-03-31 13:26:04',NULL,'inactive',16590,'2024-04-14 14:14:51','2VXG+M3Q, Amman, Jordan','cxnFIXRNTSCSqBiAQTgYQ2:APA91bFozThE4cnRJte3ETGVelD-zkZLvLHscb2WY9LVS2qRLWdDTV1L34ORBGP7UpkN3ZcfqMKJApMwtzY94CYRdZaI7uY9296nriME076Sqht9NAqzpYJL2P1b3LD3iC7gWa6hO7mh',0,'Amman Governorate',32.049227,35.875028,'disabled',NULL,NULL),(528,'customer','$2y$10$RTy2lEFHBtU.Qkm3DEz4jeOHoQwctnEcYvPaRsuyYToGD.5KCk2Wu','778833433','jordans3b001@gmail.com','ali','alhamdan','2024-03-31 20:52:15',NULL,'inactive',NULL,NULL,'2X4G+H75, Tabarbour St., Amman, Jordan','fD1RuQMNRmi2PFzi84mICX:APA91bHDA21aqHfV1NTFVs7dycU03byxWHdbZyc_h2I7Me5hytBDtrRKHwUGhhI-0NE0gliCU1NcJTf0JqnbJTXBPJWP8Ss8mWo-MHNTyMs9WDHPdj_OQi7xZJNY6HPzp3QG1YcLO9CJ',NULL,'Amman Governorate',32.006577,35.975904,'enabled',NULL,NULL),(529,'vendor','$2y$10$YoOCJMfrI8mlLuZOPbLdQO5alF.DC7yIPblPafnCLBWPLsnw2WMxa','781277387','malmhsyry511@gmail.com','محمد','صالح','2024-04-01 08:37:51',NULL,'inactive',NULL,NULL,'WXP2+GHH, Amman, Jordan','fKkzgMx9SvOQpUKLDYzo1B:APA91bGx0WqlfdYpXodIxPXxb5hdRgoxdQV7UwDl6W-77neCoX2uo5eFi6LjVtx02n42t8CRbOW_NqS2PwSyWLd_eB3y-f0azvNi0vOXJz8iC2cQPOWGIGziZ0qEEXphqo53JTxxLvu8',0,'Amman Governorate',31.936648,35.951373,'enabled',NULL,NULL),(530,'vendor','$2y$10$zsymk7ZnTEGLgVUzc01hYOkUsv.YarPzgPlniqpT6c6HI.BMJYc0G','799617652','sameralqateel@gmail.com','سامر','القتيل','2024-04-01 09:24:59',NULL,'inactive',NULL,NULL,'WXXF+XGF, Wahb Ben Saed St., Amman, Jordan','cM-dqj1oSs6MN19_M9J8HD:APA91bFsaPpX7XY0BjJdgYQDrHPFhgEpJjklpr_-_WkP4I03MBsgLX9n_zKCSwhnQZHJFdiGSL9nmHbZ2_KqsJbQ6BcA8YCCcfWPGDeuT6aGUYr8P5fcdd9Rn_BgI6-EULNLEtEm9Hp4',0,'Amman Governorate',31.950021,35.973867,'enabled','1.0.15','android'),(531,'vendor','$2y$10$a9jei3Ql9Xkhn6EkrGqYQefy9RoWg0q74ttBDHjP.ThbsRW9pl57e','796421924','jwdtalwdy5@gmail.com','جودت','العوضي','2024-04-01 09:31:51',NULL,'inactive',NULL,NULL,'WXQ8+C8X, Amman, Jordan','cHl1j9XqQZygjVd8fobAGM:APA91bF02I-sw7tL6kDbP7RY_g9NSDQw-DU5X8v_ydA_x5eFGZOKb_gPSEo8uxmgiWKQLIa-On9YaEvG0bdDqzKW3RqRDOXQMdePKjxOucizn8jgYKsV0jDHY0po9vFJl9_D8HLMlFQO',0,'Amman Governorate',31.938231,35.966002,'enabled',NULL,NULL),(532,'vendor','$2y$10$ogJDqznlrZEv9dmB1CGtbOXHRKhWHRxemoKzL3GVi.C4ILb.nGwgi','787007033','majdomari853@gmail.com','مجد ','العمري ','2024-04-01 11:03:59',NULL,'active',86983,'2025-01-01 18:51:56','Pr. Hasan St. 21110, Irbid, Jordan','cqOPwdkNSqGZlATC_LptIk:APA91bHCZV_KB58M_4KVwfwkfRuYicqJ_gtWO6mAmC9WM5F3no2Aj1pmfXI3NjjFugcjXNirRpUgWVg9urilEppnTE1amxcIk39dbYEGSY5AiX-C97mRQw0',3,'Irbid Governorate',32.534989,35.870532,'enabled','1.0.15','android'),(533,'vendor','$2y$10$A7R5XYrnF6hqDJTzZIrlo.EaBi4T4QMVy2GvJ1SoojO4Y.c63iswG','781396025','faras6693@gmail.com','فراس','أسعد','2024-04-01 12:19:52',NULL,'active',NULL,NULL,'القويسمة بلقرب من حديقة الملكة رانيا، Amman, Jordan','c1TqUPDpRLKLpxGQA7O2GR:APA91bGowQOOOjpOIKC1uyM8iJh4n8yVo8Cwm4Sa0TblKEXZjZKBdMDgRPAs3VeYZveLi-AKsqJsPTjmD8sA7ZL4fMqsNIDbBoXeJNN-cU9YkrU3Sa44TWuBWKk2z-EBId-F2S36PImj',0,'Amman Governorate',31.928795,35.961604,'enabled',NULL,NULL),(534,'customer','$2y$10$KTXiUoU2T8vmIm0raVa9b.i5/sg7knZOBGw31Nm2aVQhTJAB2R/QK','786473736','bel1948h@hotmail.com','bilal','hasan','2024-04-01 18:41:09',NULL,'inactive',NULL,NULL,'XWR7+2P8, Amman, Jordan','e-z_dZGcWU9UlyXp9RB3yk:APA91bHGijcJz8q0clbi19sKzfWMVFY225YrljJetiE75VtrqhtadH_tfkLGzjIywW9cv9sijc6OjNbmjpE2oTYSWuY6LxTQQ4CdenGVjPp91UCCB9ps4QGX4keXOQuN9Vj8lRX5HevZ',NULL,'Amman Governorate',31.989938,35.914430,'enabled',NULL,NULL),(535,'customer','$2y$10$CS5MvYy3oA5Z8BH0IbMi.eq2.CMEl8UWbHat7LIQmc9Ja3xlih/su','781458406','mohamedtrabilsi43@gmail.com','محمد','الطرابلسي ','2024-04-01 18:55:00',NULL,'inactive',NULL,NULL,'التلاع الشرقي،، XVJ8+J7H, Amman, Jordan','e3KGafuD5E1Lg8SVsAlYPN:APA91bFxVq0qYx3f-bBSJMjlCsNTAIAh7HxZrpTjAyBbJovwwSG_lVVLftMxDdJVdrPwqBuwnAQhbMHKaUimtiqnKVThMBNHCjd0VzBOkG0SEoMfUMKKrypCiI9MGNvahoraEltLMd92',NULL,'Amman Governorate',31.981506,35.866040,'enabled','1.0.13','ios'),(536,'customer','$2y$10$sGWyA04lk9Kwx4RlsKKD9eHP68zlqo84.ieyGUMVO3N1deyr8603S','795476973','maysm7508@gmail.com','ميس','عبدالرحمن ','2024-04-01 18:57:38',NULL,'inactive',89493,'2024-04-11 15:23:27','10، Jordan','e7JpgFJlTCiW7O5WMHYhkO:APA91bFfc5IRZUeN8V_KmsbQ0icCXQiZ5ahleCU35_y3Z8E7V2xX4k7A6t4fd1wX9G49ZncRMCYcaoTGrlJ3UVJiGYMxYxKy4PO-QDS86CA5HOtpV9WGlUN1WhvxF86FpjlziGJGLaLX',NULL,'Irbid Governorate',32.540926,35.888816,'enabled',NULL,NULL),(537,'customer','$2y$10$aHSc5kuuRWNMWJOu2zrEzeTxP.0ha4IlIveo3YJe2wjBMwgttP1Ka','788586704','khalilnasar117@gmail.com','خليل','نصار','2024-04-01 19:41:54',NULL,'inactive',NULL,NULL,'3V5F+5X8, Amman, Jordan','fHVfroH1R9-7ZMgpf5pBSS:APA91bEuXXGGER_i6pBu6BRz6NuiPXZV7Gup7UxKc4QCOX8Zbj5ZcaRQ3oqZE7l2VU6ipa81F09g9hRvwVlv6kD2Ku-Pq-cCI8JTfNKXfYeECZ-cWqs6T6_PjNklU3QqqfPtZVtkScon',NULL,'Amman Governorate',32.057964,35.875160,'enabled',NULL,NULL),(538,'customer','$2y$10$7QG.WUndL215q.IIAztkOu.JaSR2f660YSENjeTQVb5q78aJ/GXGG','786138186','othmanalaqrabawi84@gmail.com','othman','aqrabawi','2024-04-01 21:27:25',NULL,'inactive',NULL,NULL,'WW5Q+FMP, Amman, Jordan','cLbV4GwgTySnOs4QpZg6BN:APA91bGrJAGUvc2neUDUe-UhOa20zMtWZhlTlyjWa5ikVhKZdf9ErXsMmcyqaWYcO9AqoEb-DZfksaGEK3M0a2YLg15Fxx7ifr6IYjesyUc2xqhAmqrfxz18tRktnON3oOCCYb7x_QKR',NULL,'Amman Governorate',31.908626,35.939152,'enabled',NULL,NULL),(539,'customer','$2y$10$krwiD6K5WiD3DK735F3s2eLxamvVTBoePFuUTD6O3bAT8yFdX.tvO','785690641','aymnabwtqy@gmail.com','ايمن','سليحات','2024-04-01 21:44:48',NULL,'inactive',11531,'2024-07-22 01:30:04','WRX8+9GW, Amman, Jordan','eIrFMu44QNeXBcNmhYV2Ww:APA91bHmXI17DJ3hH4BqA8VW5RYTxfN4nM1TN2RcAYBpUgANmRFBA5-wZxjRbFLHpDNEqkGycB33riIRHOOnIoB2KaZu0tGHtPdxH3QG7wwesmyex7eci-jbOwoHAELsvRSrG9ir4Ofs',NULL,'Amman Governorate',31.947953,35.815923,'enabled','1.0.10',NULL),(540,'customer','$2y$10$udPUUiZoml.QXUv.UPZY8.LZWht69aFmoBmE/MAGt.2q9aoizOnRW','795145850','me.zero@hotmail.com','naser','naser','2024-04-01 22:16:23',NULL,'inactive',NULL,NULL,'XVRM+576, Amman, Jordan','dE28TMujQXWiWEYUTVK9Ab:APA91bEN83UXaMFP_jo_9MKTOVfY4PmiO1J2vS-bDl589lE9f7TFfKiCSGI7D3-EKkJyAL7gJccWVKbrtgrrnLwlvsuEVRmN0UtqVoMCX_L1MkxVoUWgMRu9QJX649tFCB7sujiBnTpL',NULL,'Amman Governorate',31.990267,35.882602,'enabled',NULL,NULL),(541,'customer','$2y$10$NL8wSi0aCDixv3z4vnJTGOyddoq9iXtNfrJW2HRuK0laVP0Gs09SK','795439131','salmanaldajaa@gmail.com','سلمان','الدعجه','2024-04-01 22:18:32',NULL,'inactive',NULL,NULL,'Sufyan Al-Thawri Stasiun 2, Amman, Jordan','dDN9hCTnTYigv91ph9Hgv6:APA91bE1znQyEgjzEvEjWmYy9raTCUuowInukR-2Akcf-ryTYh8aeFtBJoL1b1ENDS1-sE2inxwztBDIZVsVTHLI1lUIFHBSBZN1JqOpQFv25aAkS5GVqPZ1rPbyTnptDtd5oIAzu-vc',NULL,'Amman Governorate',31.979083,35.983464,'enabled',NULL,NULL),(542,'customer','$2y$10$I.QvU45cAsL9YF73m5KgBOAPG3MxQBmGs/VhTl09wic53/FjAAMC6','798429950','bashar.melhem@gmail.com','bashar','melhm','2024-04-01 22:24:49',NULL,'inactive',NULL,NULL,'Tarek St. 25, Amman, Jordan','d-n8SQT6RLe06PR0Ep8fEj:APA91bHq_PzzmonMWfQQ_duFEk3wB8CDX5K3qcsS_AVE7UhABfbyZPAucjFxdrldjtLGGpcP1-Wk3Ox6znUak93JzoULKY1ivabKwe3h-zj3g4qVu4xuCsI-KUgDlTRDA7Eo9Fx0CaTe',NULL,'Amman Governorate',31.993424,35.945443,'enabled',NULL,NULL),(543,'customer','$2y$10$pv4CVRLbdAySxLqQ8Cy8xe4loWDrzhG2Pjae/8/bdPcK9bCNDentW','795487661','szkarnh4@gmail.com','سوسن ','حماده','2024-04-01 23:33:17',NULL,'inactive',NULL,NULL,'Istiqlal St 156, Amman, Jordan','d6d6VOZdTyqjbNrGWIay6J:APA91bHgbtLH2cENcRH7sQoRYBSnOCqq0xNF03liiCx8uvtBTwTNPwpTxLhzkDy-9r4aRsNjB8RHNua0-6SQ92g2LwWaNvgfd-sOL1qJTgEGM_DFzZl7dnN_2IEYsvS6oS8mvMMxuBha',NULL,'Amman Governorate',31.975151,35.932202,'enabled','1.0.13','android'),(544,'customer','$2y$10$jJRXFseoRBynJpd0d1X.6uck6IYIJIJu6wXYAdz3J0deYH3EULtgS','785458194','fayyad.bilal@yahoo.com','بلال','فياض','2024-04-02 02:42:39',NULL,'inactive',NULL,NULL,'3R2V+JQ5, Ein Al-Basha, Jordan','dvFIjAOZSs-LnXYIEXhKW6:APA91bHYY60VToKOAvwmdCiCGVE5-b0Tf7Gun7xSOd5msUgCE5K3rOMcQpBviH0kDlk8xdGpHDhjxjoCAXn8i-8-W6RLQI2314S6SXZsd_SCzXngiVRh1KCj5O_G2MgCSX4UeBJhvzmI',NULL,'Balqa Governorate',32.051905,35.843369,'enabled',NULL,NULL),(545,'customer','$2y$10$ihFgA6nG5Bc5sNTMZbEk7uUqtAgc3vMkNQv/FrNj9S7fbKzBT8CHC','785750986','moshtakhadi@gmail.com','مشتاق','هادي','2024-04-02 08:02:23',NULL,'inactive',NULL,NULL,'2QCF+R8 As-Salt, Jordan','cENKf9CaQjywRJPnUvH2Q1:APA91bHTpNfBSxmwSUkGsuHRMtql4oO0TEt14W3z6rdZyhScjslunRA9X_QPNiRCwwCgmZuChPxhVnQO4wo5msyeWMauTCf38JqBy7ejZj9N0VrdD8-xfsHHWGAxlL4rvsfaI5yjfX0D',NULL,'Balqa Governorate',32.022100,35.773374,'enabled',NULL,NULL),(546,'customer','$2y$10$fp8tprvyHvq7yT2ZhZf26OdedQyUfGWWKfghD1OeZzsRhjlRikWpG','797733016','phmust1984@yahoo.com','مصطفى ','دياب','2024-04-02 09:41:07',NULL,'inactive',NULL,NULL,'WV53+3GJ, Amman, Jordan','fiK7R92eS6iBHQ2l0BN-xQ:APA91bHJQ18J9OT6bekRXDjn2Xs4BxXGRY-oc6gGcOemBhVx53Y0jl0w6eNPdLQdyGAAFbZsrRGU_CkjLAd72TM9FFE9Dg8vOp1DSEPJzF3K-iUQ2phWrd5P8YTiUPj4ROyqO3vElbsq',NULL,'Amman Governorate',31.906999,35.852425,'enabled',NULL,NULL),(547,'customer','$2y$10$JogwK3LyQZA1TMmuYWCwLOQjEb6yP8pPKlz4YbBosFcgBLnhs9bgG','7810681320','pickum.jo@gmail.com','nawara','ardromly','2024-04-02 10:49:39',NULL,'inactive',85079,'2024-06-09 10:40:10','Wasfi At-Tall St. 138, Amman, Jordan','cdSNZRfoQfem05d_eYANTw:APA91bExc3J91uwFgebeFKTRYBtmFHRVXu1VdA9h7UH2uI_XHUybKuw3c-9rftv2z9g149wcvo-2Ao0mZRBv4n4EfZb5wI43r9MwqJGj1FhIjowC-g9OTiMs_MMqrTRlq90qP_iOmJxg',NULL,'Amman Governorate',31.989900,35.871450,'enabled','1.0.07',NULL),(548,'customer','$2y$10$PSDh36I0sMsUACCbja8gY.eKBMNFo9KxQEA67Wvc/XIpiaOHowZG2','781058132','noir05@gmail.com','nawara','05','2024-04-02 10:50:02',NULL,'inactive',NULL,NULL,'Rafee Othman St. 25, Amman, Jordan','dz-QAPo6RPiAojsqSQ1IV3:APA91bFyCqlZwhGPKnrhEJnwtIlOxZIhJqT4PHhcKQHcR5ywLOuLvv0qU3K5SGh1g_irN9gJYcWEUI5QkWNPUO5CDRmouo-57QabtC7B3aF9KyRiUtxnyMIOu4R1aC30V1Pw2P98Z5MD',NULL,'Amman Governorate',31.985322,35.867220,'enabled','1.0.13','android'),(549,'customer','$2y$10$LQhn1w4.FYd9PXMbT19VNuCLugGYU1g7HmFD3.HQ5tkuGem/iAqem','799637175','belalghazal900@gmail.com','بلال','القيسي','2024-04-02 17:30:38',NULL,'inactive',NULL,NULL,'WRWF+592، عمّان،، Amman, Jordan','fzWOf5ctQo6FDmvdvj4mH2:APA91bFwsrhL40uf2e0YAZyrBRQ-yjEWwiEY5qwk1geJot9AuYIXLNl3hVme5GKkIMRTklIs6LIbCoR6SYtSkrlZIaj-L4ABWyZs9EIbPpvWxyzclTe2YMZwlQUr7yAKbw8UnDXGZcRS',NULL,'Amman Governorate',31.945139,35.822685,'enabled',NULL,NULL),(550,'customer','$2y$10$kActN66iBzJTMhbYYTPqjOgmf/n/F4n8s0a61TDgOst5qLdUb6Ljq','786005434','aldwayma55@gmail.com','WALEED','HDIAB','2024-04-03 06:30:53',NULL,'inactive',NULL,NULL,'23RX+3PR، جبل طارق، Az-Zarqa, Jordan','e7FzxcotpEcwsWDAo9oBqE:APA91bGgZ8Vy6wxqP5Vz5_v46PVIfbyuz_yyx07U3NCfJMSuDSwdvNQfckBndGlcj11VbPS6gjLB085kAHwVrUV6Tx3yV2_sP0RA9PK7rotnT5gOqDKNLwUDLJWm8k80OimheRM23ZC8',NULL,'Zarqa Governorate',32.040237,36.099253,'enabled',NULL,NULL),(551,'vendor','$2y$10$OWokmo/J7JXMx40X8lT/8O1p.NOxJ3aAKzE7vohRrZc7WwVm1lQgS','795868911','meahalqadq@gmail.com','اخمد','ابو صيام','2024-04-03 08:38:08',NULL,'inactive',NULL,NULL,'التقوى،، Amman, Jordan','f_Tm3sRVSUqkdUoa72wNQ9:APA91bHPNGbaAY7xL3WJQf3nga75OLtciOyGi5hHr2RVcpuCN6_poWzTAzFlg89VszgeeupzIrdyZRIh45_jdYOihlh3_yOhCojPOfmwpCWTlytnVMdY2gWmd9KPSf1p8OLGQymWX3xE',0,'Amman Governorate',31.866462,35.958733,'enabled','1.0.15','android'),(552,'customer','$2y$10$GEUd5JvCaBQv8u.GFUegNOJY4XvaOkkV4J/fQjxtuhM9RC.QDxDSy','787977448','mohammadabosiam646@gmail.com','محمد','ابو صيام','2024-04-03 08:48:20',NULL,'inactive',NULL,NULL,'الاردن عمان خريبة السوق، Amman, VW9H+JC4، عمّان، Jordan','f8l_yAGXSA-n0slM7ObZJj:APA91bG7X9jYRH2LSaeX6wtNOiAWb8lSsFzHOk3_iA4Ufb5bNMqQnKaqbHDAooxfyME3CAs04GtgGNtyELpWXl-tQVJnCeMNn1ZxeKJOQSmZcbcUtqbVz2W4Zy6bcukPSAcXON0bwBY-',NULL,'محافظة العاصمة',31.869109,35.928758,'enabled',NULL,NULL),(553,'vendor','$2y$10$OlDFgWiV2IjhpO38LGASEeAQUmobndFXJvIejNtnGDcCL24g/KYja','795764645','shwaqftqab@gmail.com','عقاب','شواقفة','2024-04-03 08:51:32',NULL,'inactive',NULL,NULL,'Salman Ben Rabihah St. 23, Amman, Jordan','eGRbMapYSwuUceK1YaWmph:APA91bGBuk6K-l-DiDhChNhsxIIZDiTt0I5uWxfx0LiQc-muaL7op0NaNDN49nX6DkU7JLJTZ0NqYxj5Vkq2YLE6lYZcwJ94r4bfJ1uEXK76jAbtZadktyoEvQDRBvqRLBlA8kJLibm9',0,'Amman Governorate',31.986113,35.949076,'enabled',NULL,NULL),(554,'vendor','$2y$10$z.M7mVKwOD/4vZPfiz7cxusOHp.3TgQL55doCqFU1oKwZQm1ZmXbe','790364450','ammararawi20@gmail.com','عمار','عرعراوي','2024-04-03 09:11:53',NULL,'inactive',NULL,NULL,'VW7H+JVV, Jawa St., Amman, Jordan','ejgQoUB_SCGnzrv1Mm3Adc:APA91bGmrw7qdHA7_Pnoyz58Tr8T4VESXatPFIOIFULWPN_rKui9kF47PsER12qe4b4cFG3zVU6v0REIpx3dVxc6n_LiaNymxcO_byAa545uRArVwlhvJc-XcJx0d5ZoK8NG8WqBDLnP',0,'Amman Governorate',31.864085,35.929753,'enabled',NULL,NULL),(555,'vendor','$2y$10$x0h9s3lKeTYlLfgBw7ItmenFltaP8HFMI0.oiJs98d.BauvOZCFPy','795651578','imran.y1999@gmail.com','عمران','يوسف','2024-04-03 09:13:30',NULL,'active',NULL,NULL,'Al-Mudhaffar Qotoz St. 33, Amman, Jordan','eSN-a1S6TIeKCTYmv0JasJ:APA91bGf05MpkO0oPG-uRKTJe43W4maej1TQR96W3Z5rVcCo3jRHgR2JifyRJGK5525iCI1AAwdv0BlVIzq17qK2AdUZNvcRCMFHMvz3ZsNhvyuEv1oZU82qoqPHcJttmmMPih3rzntJ',0,'Amman Governorate',31.986139,35.949586,'enabled','1.0.15','android'),(556,'vendor','$2y$10$BGikcDH6RxD6fX651bKcAedm2TIHjAHmsac8/An.XLVRxlZCbzAYS','798657946','abubuhar55@gmail.com','عبيبيده','مزهر','2024-04-03 09:33:34',NULL,'inactive',NULL,NULL,'Abu Sinan Ben Sayfi St. 65, Amman, Jordan','f-7eQWpZQfmYeDcoqWQUg9:APA91bFKHcV4UxsCFNGmoMghPnETeWv40TCBEHC4QIkHYVr9j_AKWW5GG4AxdKogdi6oqPb_foHyw5imz6rW7f6HE5h40IVS_nkpL2JCwI68UOvFALwx6PCXi2iijffQWf7zTrL2VBH2',0,'Amman Governorate',31.860202,35.930919,'enabled',NULL,NULL),(557,'customer','$2y$10$E.frrAF0PsWW4dWZ.zezzOY1Zx/cLWZ7MefIqe9GkR3ru9AIZvxV2','780218274','ayoup.2009.tr@icloud.com','ايوب','الطرابلسي ','2024-04-03 11:11:43',NULL,'inactive',NULL,NULL,'التلاع الشرقي،، XVJ8+J7H, Amman, Jordan','dGxhUsZ61U_wkrFANsL6Qr:APA91bENpRuEqFb0xB5cM-HS5aTvElet9946auHmc8FQLcK_I-HzB3ycZ5B4oNA_5Po_j4gIUnQWm2GXE1ICesEyvvggwVTKmwvPp8JHJ8IU96yXtQlmDX5UigYdsaLp4dSvBS_PLM8f',NULL,'Amman Governorate',31.981591,35.866135,'enabled','1.0.13','ios'),(558,'customer','$2y$10$h0o5mqLZh7sDKK1pR7OouOGIBl7vdudPSzpCUE8zHy6iYp8Nre/B.','787887847','7amzeh.al3omari@gmail.com','Hamzeh','Al Omari','2024-04-03 22:05:44',NULL,'inactive',NULL,NULL,'WR7R+3P5 حي العويلية Owilia Area, Amman, Jordan','fc7IEfDrTEdln5c4GYhVyv:APA91bFobQp4mWvkHRGxYuScrB6Pot6VROG7ZAHyA9Br3m91VcJEO1J4jipqJWLr9IvZ8GatEwa4tPPAyYhKoHhE7KT4pxkb9nr0RVG0wcnzQoRlOqTBqQd_LUTnCBQtMXtE3P2YurPP',NULL,'Amman Governorate',31.912738,35.841539,'enabled',NULL,NULL),(559,'customer','$2y$10$lKAaAQpaVMBVjVpmTV3nz.zFbR11j294PPyI2yNr/rfWT4CPyUl4i','798719029','ahmad1989@hotmail.com','اخمد','سرور','2024-04-04 00:20:01',NULL,'inactive',NULL,NULL,'3V3M+XQF, Amman, Jordan','fy3rmKEATQaDltoi8VnqaM:APA91bGVtag3meikF7Z03vK5kC07mIJO7aRY4zfKz2ul9s_GB5WuIJfa8RX5-mB4nzEbYFCkDPsKtbmUg0p820UIKHvJBMAje5D3_MNRS_OadMwcerY3Yk0n6SWIPfsDxunWKy1LkK2b',NULL,'Amman Governorate',32.054881,35.884365,'enabled','1.0.10',NULL),(560,'customer','$2y$10$id0lt7nrr6fRrFdDLg2LY..JamEqg2kaa10Xrc3WzuzOmWt6txWz6','797090541','amukhaimer89@gmail.com','احمد ','مخامرة','2024-04-04 11:37:07',NULL,'inactive',NULL,NULL,'2VMF+222, Amman, Jordan','e4R3u7VpSEUInzWWjqjpmS:APA91bEQw_iMrk8ipHoO4HgCWb8gsKuyHb5sLrBngKB5ZUff3qQgeJQ6M5ujO9CVfRLFgqT42EgbAOa0Cbb4MBEAxU_Rb1oZ3IOiRCe2w6AKt0k6uERwIBAwW99ZGoevlxzCaKXs4ppn',NULL,'Amman Governorate',32.033138,35.872258,'enabled','1.0.10',NULL),(561,'customer','$2y$10$SqE2UFUefd5JgQZo75Wz9OzhfDk6V09PAErRKIn.XWkseovp9xSjy','777303011','nourpickum@gmail.com','pickum','jo','2024-04-04 13:26:04',NULL,'inactive',55873,'2024-05-02 15:53:15','Wasfi At-Tall St. 138, Amman, Jordan','dTt1r5KDS2eKNPTakvKejP:APA91bGICRiTMOlWuSstlDi0GPnqxkGeQF3-NXD_f1lZhl1EQyKhqogPWsaOYJBSAFdglbjstU1qVtpRO72p4eXDvIPAYUg-qAnyuxvaG-hoCWIMWaO-Myc1r_wzKihcf4xRPM_aevLs',NULL,'Amman Governorate',31.989904,35.871451,'enabled','1.0.12','android'),(562,'customer','$2y$10$XWMHTPq6K2bFXSfOSMF7zuRW.q9t7eXaIQtp8lcXxiLw9HNSaU0mK','772182254','Alzayadneh@gmail.com','محمد','الزيادنه','2024-04-05 17:18:26',NULL,'inactive',NULL,NULL,'7RMF+5RP، ريمون،، Jordan','eQHm_NynTm66wj8j6eknlB:APA91bGdAS_bo9MqxHMICor9gzmVfC8HTCBalcDQnkIjCqfz8o14Wn3dBrH1kcCPoALDFAOBedZH7z6PNoYqxe9uS4DlTi6i7XStd67xZRFMAeSINzcyhGJUyNggFpRR9nLD5l8dkgm_',NULL,'Jerash Governorate',32.282172,35.824072,'enabled',NULL,NULL),(563,'customer','$2y$10$BAT974AGnrx8zphjn/ooEufFokbGatXFtpGb8eIq1fG5XmDKX82/e','797090212','ahmad.mohanna111@gmail.com','ahmad','mohanna ','2024-04-08 00:56:05',NULL,'inactive',NULL,NULL,'WWQW+6HM, Amman, Jordan','dba_xS3aQvqFfTSe4m_yj3:APA91bEO0hs_riwq3-ZjktNNY1o8k4UVnAas_kKMb8eScSXC5ecZdAcOp_JrID_2Ro3CtD737PwfSu4f5ItMiMnWZZZw4m2Ym96QuFORGSXrqniwx-0eruFsHHscOQ3cbHf10MkqChiI',NULL,'Amman Governorate',31.938313,35.945422,'enabled','1.0.13','android'),(564,'vendor','$2y$10$0.as.mk8FP6ngWyCLuciL.M/U1W78WQJPvOBVmcA1hVfX49I6qdzu','776305411','karamgharaibeh92@gmail.com','karam ','ghariabeh ','2024-04-08 11:09:33',NULL,'inactive',NULL,NULL,'GVVM+392, Irbid, Jordan','dkKIdsnVQHic9sazrYpBd_:APA91bFVWOHs3aphOThC5LDgSineKYx1CbrEUDdQ5gZpTXAyHOMQfoz9hvhc0b135U_kWDg6vK_McNgFvMcmH8fFkE9k7C6_TYrJablg_j43dhxdQN-L6eq1q6kwDWRzxLQKybBzEYEJ',0,'Irbid Governorate',32.541998,35.882958,'disabled',NULL,NULL),(565,'customer','$2y$10$eEc9fuEFkbv96N4p97PPfetfFh.p5JpL69d.Tzuj0jJTazxl/XQ7u','796710741','ah32mad19@gmail.com','أحمد','عبدالله ','2024-04-09 06:31:00',NULL,'inactive',NULL,NULL,'XXP6+3QF, Amman, Jordan','dKA1H7TQNkVqkWU1yZzgF4:APA91bFyf_B2vAZF2Hj4nGCjyfYFUtng22-efMf343oqKLMz6KuLVF3q5Fw1lam2n60zWqEKcR0FFy_R2OjipTzZMM0FHoWFttf00pCgcVj5nIGOcF9IExGsI_Z_YtzLMnWFdJBVLsX3',NULL,'Amman Governorate',31.984758,35.961542,'enabled','1.0.13','ios'),(566,'vendor','$2y$10$NUonrFgmUMxxhnVMcGrqPO1sYXX9WelBFeMNI8bjaobXzwbb419Ty','789132718','saidaldalki0@gmail.com','سائد','الدلكي','2024-04-10 04:40:41',NULL,'inactive',NULL,NULL,'المنشيه حي ابو ايوب حي ابو ايوب، Al-Manshiya, Jordan','fK5Cyq0IQia-rfzrgw8hWa:APA91bHXZgC5iey_0_hZoDguUkX3nBq_D4wjP1nhlqzyzCu6H5DeCvqbvEh8w8Lj5DdaPju-gvoeByhUckQCqUQ3LRRHvL00O3G3LRWKro1mTuPJywNsCD0BnFzssPcNexcTFhGJkT5H',0,'Irbid Governorate',32.588672,35.608887,'disabled',NULL,NULL),(567,'vendor','$2y$10$zD2YMSBlcKKE/ngjZrGPnOIcbsv4buJOgbKHyGeD0U5f/BBY8tt4W','796031507','fassarfnbe@yahoo.com','محمد','حماد','2024-04-13 03:16:14',NULL,'inactive',NULL,NULL,'VXQ9+4G8 دوار الرجيب، Amman, Jordan','dbVY6kGaQKqXHQR01oXW8F:APA91bHJK6Z4ki68O3miOxqEYq7GVpTR4rwTBLC_fPiYNDU2_WkapEiDvptfPTGMmzVAsu-4OXlJMYyvkbZUW2FTE706ZxUEXAzM-B5q-ExfHZDhZ0yKA_ikB_3Bby_CtDH_mf9Dm_g8',0,'Amman Governorate',31.887679,35.968855,'enabled',NULL,NULL),(568,'vendor','$2y$10$qYMinw1BC47HmvckjwIjQO1FrRwUJ0WGngmYIw5mTo4rQ//G1/ciG','775930652','ahmad515@gmail.com','احمد','الخلايله','2024-04-13 04:26:08',NULL,'inactive',NULL,NULL,'22C8+J93, Russeifa, Jordan','fn2ASpynTPGBPqLaUF1KhM:APA91bGAIFJayfOU2Bqt4BRt0WSQ7q35lWtVNbi2uBpsBdNaW1sh692JA8yuHTQYzZEg_CEMvg4l20_G7ssPqfepZdE1ej1FqFtH3hf0GgB_v41OSlmdIK3UVtDieiEzsDcpyV_wrK6v',0,'Zarqa Governorate',32.021602,36.016192,'disabled',NULL,NULL),(569,'customer','$2y$10$3wQBzQfsA5vv54/ZFdQXwut5vz0WTaSIUrhCPsc6TibDvIueQXghK','790495017','khaled_gzzawi@hotmail.com','Khalid ','alghzawi','2024-04-13 17:03:04',NULL,'inactive',NULL,NULL,'XVGJ+4VM, Taher Ad-Dabbas St., Amman, Jordan','f_ERHjO6e0iKmBZsVyR6Xd:APA91bHbzUQs2Tr_GOG3znzHcHk5Sw37XHpC_opaVKtn-RmPU2ptjl2kkVDtQYyOOC3GMBQpX0brkjfAx29fW9-b7vBKBMte8LwtlzB0v0vCNEVBXgAkveXsZcHixdb03X0PQcydN-6f',NULL,'Amman Governorate',31.975031,35.882480,'enabled','1.0.10',NULL),(570,'customer','$2y$10$Pv7ubxvVSEgLlWBN8boihemTDNUIH7xS2yHQYGOAoJVTewRZW2Jiu','775389383','hmodehnidal@gmail.com','محمد','دواس','2024-04-14 15:58:05',NULL,'inactive',NULL,NULL,'Saleh Al-Majali St. 20, Amman, Jordan','cblt_OvdSn-erg_L9FBUqi:APA91bFWs-rZ_Un70P7USefTZZQ3ByDJN0RDHMlEvnzCdVmBTmH5CCz8ZXdbg0zmUUdV3rbBmsgyrU5Jh34XWjH2L8-Dw1ZivOs1MLA1dMLkVP10LirsZCeBuMbIm5d92FFaT_m9d_8h',NULL,'Amman Governorate',32.025268,35.873612,'enabled',NULL,NULL),(571,'customer','$2y$10$Ti/4qPUBRFt.wuW1hbkYvuNR9gwhQXe24gDAFk116R8l86UZjuQhq','797470436','majdomari853@gmail.com','مجد','العمري ','2024-04-15 13:26:45',NULL,'inactive',NULL,NULL,'FQJW+HMR, Dayr Yusuf, Jordan','fUEm1e0pT3SbWazNL5CjMM:APA91bGaPk4N-GAFGtre5NvtUubp_nT9TYl5nL_ykBDBfbZ6rrXnsC5U9RhaQvOmcKnNy7NEUghPJ0WXmZ3NGtK-w1MKxyoDjPk43ks-VHka4JltPQZt8icqP-nRqkQkhv75dJK6PXoI',NULL,'Irbid Governorate',32.481272,35.797164,'enabled',NULL,NULL),(572,'customer','$2y$10$g0O52yfI8kRYAmnyMG7alupj0CFtqRYzY6JJdMChAqTUFrMsv.PPy','772275622','aljarrah.mohamed2@gmail.com','Mohamed ','Aljarrah','2024-04-16 10:03:03',NULL,'inactive',47667,'2024-05-18 16:50:33','Abu Moussa Al-Ashaari St. 6, Amman, Jordan','faeFJlqnQEiF0XFBDMgAy3:APA91bHbkzqrUUGKNTsY5vjBBcZ4IFM_F-R8oywxp3pSIpifBW4qT6qJn-Z1F0aHx5R4bYxDjZGUYWTxf2RqGn0CGO1kKWYsPOaTY3qFLCBDafmJ3Jq1id696Ckjr4cT_XEVc6xJGVi8',NULL,'Amman Governorate',32.006268,35.864822,'enabled','1.0.13','android'),(573,'customer','$2y$10$ki0g1k4eAHiYBeqWWwdHpe45OAZNnbjVW3pKZeTGN0vBQQp1epxO6','792146361','daraa@mail.ru','محمد','المقدادي','2024-04-16 17:40:26',NULL,'inactive',NULL,NULL,'2RMG+8FX، شارع الكمالية، Amman, Jordan','dnng_at_TBiahRmh2bwC7O:APA91bEMq-YHe7zeh_bJT9-wvq0RNzBGmQShUwPocd6AjTs-7tnrfsowrwbFDL9YMtljy3bQtVvq96-ACrTOwEITKeOp0E1QEB5EUmvBFKd1FDI-mDVhYMv57JFPtU3s5ZzF7yrX5dr7',NULL,'Amman Governorate',32.033311,35.826403,'enabled',NULL,NULL),(574,'vendor','$2y$10$QLQEGgzUGj.wg3Xt/i3EiO4jn/eNe4V8TpHGaZXEU.vPv79V1/Tju','785964109','hmd799095@gamail.com','اسلام','حمد','2024-04-17 19:07:28',NULL,'inactive',NULL,NULL,'XWFF+548, Ein Jalout St., Amman, Jordan','dbNc6bRPS82viLNsJiFZYs:APA91bFne4s1V7xo6Q_uVrKt110Fvo7regdHI6Cu5rNINOByY6cd4Q2MxD8A_FlCaV_5FIVFjmThoPIHg1qMbdAh3nUVinX89iwDSlg1yeu0t8QHXkDqiM6idKKbGZhG8FeByZAFhXdi',0,'Amman Governorate',31.972955,35.922659,'disabled',NULL,NULL),(575,'vendor','$2y$10$k7UY5rjfZSrotq.O91joCONUSeGFlK1nsdoNIRyCgeQRX61YY4.UG','789325941','moh756397@gmil.com','محمد','ابو خطاب','2024-04-17 20:44:42',NULL,'inactive',NULL,NULL,'X2W9+FVF, Russeifa, Jordan','enT9EBl5QFeLYFfBmHSIez:APA91bEiXMXhEhcri5t7nXGNEODhpjn97dTV2xtFhzxLo7fGmpNx9trCyIRrncDEQT53QFRyR0admGs3JkEh-ATIylMpqjhlmVyKJny5UovJFKme28kB1S0AKUxHr9FKwYKj6-0I7RPL',0,'Zarqa Governorate',31.996559,36.018857,'disabled',NULL,NULL),(576,'customer','$2y$10$2rQW/hXdincab4w2O2jOy./BAussuAxaYuPVe8UGn09ErM1fAARry','787829239','mrwanklfone@gmail.com','marwan','sy','2024-04-18 15:46:56',NULL,'inactive',NULL,NULL,'WW5Q+9P9, Al-Hakam Ben Kaysan St., Amman, Jordan','cUE4AxlxQbK2D7XdENQyVV:APA91bG4O7rahbRoOAlWzdr4HP5vJGiBoO7TtpjnjphAk2CODZ3Qopl2hwokvVHfXpAyYBwga8KaXSGlFHU8UcjAypID91mUcmmZ_9Iw681lVjXJfXyoUiS8iZLf3VjCXXXlpexYmPBn',NULL,'Amman Governorate',31.908343,35.939483,'enabled',NULL,NULL),(577,'vendor','$2y$10$ip9ROh5NaLP5rVPcKEWdUOgDC7aCdm521bPPf8l9zhCZWhC9EAAnW','799951433','sakrhomsi@gmail.com','وائل','الحمصي','2024-04-18 17:01:01',NULL,'inactive',NULL,NULL,'Hussein Khawjah St. 83, Amman, Jordan','e2bXE_n-TuOS92tFmBAFQ1:APA91bHKCtxYJjbyWEnnNOjP1KFOjm2MHXXPkYYK-rQr0qetQ9zBaOHXKIt0V0cGgyyUQCXrL4VxLnVfrugVNNnmzW1eJqLMGnLaqPH3bz9eCWE3-5LwzKQGKZVOhUbqPRMxNSINfRM1',0,'Amman Governorate',31.955210,35.839845,'disabled',NULL,NULL),(578,'vendor','$2y$10$8Wfa/jgBnA0Az7afpweDsuJfjUwON4bswIeMkT/VOQp38L6C2bqMO','788431468','bselehmuhammed@gmail.com','محمد ','بصيله','2024-04-20 11:48:49',NULL,'inactive',NULL,NULL,'3339+C2F, Zarqa, Jordan','dlHdgLOWT42poZYnAJrxy9:APA91bH5Qm3Bp-fg4ujJSURVVdauO4yeJkhvcvJzRWBG_HwjzbsQBIjSD_bxmU8MxgYqlUZKRqq5IgqQxKWySPRplkqVDiFc1F9fsOC3JUA1Jc45B1TEZTiQbhuyqmOazpRMHCeCd_r6',5,'Zarqa Governorate',32.054076,36.067011,'enabled',NULL,NULL),(579,'vendor','$2y$10$eq26trlD1q0rkYYDVk6qj.VmZR5YiqNYls3mZgIAkek2FeMEb59py','776982368','mohammedalmasri463@gmail.com','محمد','المصري','2024-04-25 13:04:06',NULL,'active',NULL,NULL,'WWQJ+HVX, Abu Dhabi St., Amman, Jordan','f3nMnuAsQu-3VPmWuxct-X:APA91bF25V9bITY2tWtRFy5IuF7IQIC8nYBWq8RBYPerdj3PkDAyUk7jevg_1pYl143Ky_u-WCPptk4NkDM6bDSLD4NYPTpLCFAvBB3HkxXcFEGj9a6MdcrOu0DZ0b6_Tu1h2EtrZ3CH',0,'Amman Governorate',31.938935,35.932222,'enabled','1.0.15','android'),(580,'vendor','$2y$10$bFHCVLSeRsgUlFCidmoh.eOeEUv/8soPL/duQQ9QG1vcXRPHbslOe','796934663','m.fuqha1986@gmail.com','maysa','fuqha','2024-05-06 13:49:42',NULL,'inactive',NULL,NULL,'Al-Shuhadaa St. 24, Amman, Jordan','evPmB-2wTpu5TdOgemu72p:APA91bEwQkzC9czb8dG3aJ8xl8M4IvVgzKf2I0h8-lKjiEVsu20N73JPtkUXXxP67kqqLayiwxNnJ557tp2iccJBUQIhepLJBs5BkXAjnmTWi6e8jyTtkfJEaLmR-te59ecRefL083RH',0,'Amman Governorate',31.949626,35.953508,'disabled',NULL,NULL),(581,'customer','$2y$10$8K9zksvJihq5m9AKDbO2lOVLft2rpuHuByjEC3.Y1YULgA73fDrmu','796934663','m.fuqha1986@gmail.com','maysa','fuqha','2024-05-06 13:52:01',NULL,'inactive',NULL,NULL,'Al-Shuhadaa St. 24, Amman, Jordan','f7sT7GZHRuaj0LuFuZZDf5:APA91bGh5oCJte_VEiKpYf0V8O3p_wX9FHWefwc5a5_-fqQ0xYJvfjtXLybcJcZz0Yy1WT4q0uxuf5r-Q9Vb63JqsJuFYpYzsna2tm8OOUz4WvvQOWPVrGQ5HfQE_QtxCsQfDA3-r24b',NULL,'Amman Governorate',31.949748,35.953663,'enabled',NULL,NULL),(582,'vendor','$2y$10$QrYNhfIIV6kSl2LjqNAaOuZbUfpuEixmDBwcb3ZUza9oWJRex1OAm','791579812','abdalkaled92@gmail.com','عبد الحميد','الخالد','2024-05-08 10:57:48',NULL,'inactive',88307,'2024-05-14 13:45:08','2RGH+X7, Amman, Jordan','fJ_2dbzST6yAbnHelAqePl:APA91bGLvEANMXBdo90m6ZARv5QZR24bs-QP-qGzZiY-HSCwrgSwo4f2BafQeOpEctIeJGFl04J1pZJejb30wM6-1eniKxi1fte4TJHmqbLfi2rRUnqhbeSwN_ywVgA7r-eGbFJlW93H',0,'Amman Governorate',32.027807,35.828873,'disabled',NULL,NULL),(583,'customer','$2y$10$OkyYKF7jG5dwn3yeVP02iuMDxJv5dxMUFn3vPRPzlnqQLx/x7SNrS','782255169','jmtabwghlywn18@gmail.com','جمعة','ابو غليون ','2024-05-10 10:43:16',NULL,'inactive',NULL,NULL,'VXJG+JP, Amman, Jordan','cdnWCsZSSXGoRoC7wzPiUU:APA91bHxE_gnOquIPcDUmALjGCGcmi9Vebhq4MGls5ahebVZZlG40j7X9uItQTFhLsb7bhrXkNiUuyZwmTGx4IIgAkUu1wIWo_bAn9IPt5pcWe4pySb_w2R85abr5-TiSUM8oMr0MyLm',NULL,'Amman Governorate',31.882019,35.976704,'enabled',NULL,NULL),(584,'vendor','$2y$10$OoHV4vMLHAxX0qR.kViPf.fTkyaYnMlrWBz4fxBV4o6dpOSa2KVpS','799040529','rosses200830@yahoo.com','امل','زعتر','2024-05-17 12:17:11',NULL,'inactive',NULL,NULL,'2W5P+MQJ, Amman, Jordan','d6qytromSweQKN3jCW3cAv:APA91bH0U12d6flE1LEJJfRG91mLSh1hyAYGq2ueV3R0fUl9P5npi_c9GD8n0a_GlPodywQL4EwjtWzWJ9MNIW7iUUDxymvlL8Ze2uZsSBgdviGArKgaF7IfPrGGg656qUEGBD0rw5-e',0,'Amman Governorate',32.009368,35.936921,'disabled',NULL,NULL),(585,'vendor','$2y$10$Nc0y0YxTPTIMuSWH.HNV4.GJ7AT.ip1b69RuchN47gE0R0IYPMjOm','795834261','bostanji2018@gmail.com','حمزة','البستنجي','2024-05-20 07:35:08',NULL,'inactive',NULL,NULL,'Al Waha Circle - Ismaeel Hijazi St Al Rowad Complex - 1st Floor, عمّان، Jordan','e_nJNNg5SHieeh3PRPec_G:APA91bFq_3kLlsRuV_DfXwn_HJfuxSbRTOLrQSmVb9VUR2pZcF9xhafu3hBl3wxjqtyxNYCqOITz6ESCJgynctSYaqRFeUfSlOPd3bB96ov7Fwkn55-sMcZPXp1wGJWcklU4fXkFO4zP',0,'محافظة العاصمة',31.986544,35.868105,'disabled',NULL,NULL),(586,'vendor','$2y$10$1eqsx5uMNXHQ.dqdYiuG7O0s/2orxRGzpHzqAdXsVtb37AIbwSPyi','796429121','akkad.st123455@gmail.com','عبدالله ','الريان','2024-05-22 10:31:09',NULL,'inactive',NULL,NULL,'الزهراء،، XXHP+5MQ, Amman, Jordan','cZaGFXIHSxqrcMQSK9RRJf:APA91bEaJFMYyZ6Li5C86kAQ-PqNDDAzi09uerx-3O49L3OBrG0aSTwi_QhjsZF33E_g7tcdBzljMJpG67AdPX-MKg_SzLoI-UpTBjqsH6VPeLbOp7CDFpFJyClbSCsdCy2u_T7Pe60X',0,'Amman Governorate',31.978324,35.986825,'disabled',NULL,NULL),(587,'vendor','$2y$10$x1H.lKIkARn9ZsKMHSyoaesd/iQud75dQnBVdWKEyst9VuVUnWL5y','797007845','aldwan801@gmail.com','ali','khaled','2024-05-23 04:36:39',NULL,'inactive',NULL,NULL,'Jamil Taher St. 19, Amman, Jordan','flHJPjIsQWCtUs0nkghcGw:APA91bFN_ok9xb61Q4qKwmnMUK6o_n94Q39iTA8zI-gyQjEwucUwSzd2_KZM-8plW5pI4EWeD9aUFVk3GV_FaAGyo4V8_npaZSAI1rhjAB0zk0OLWrCRCcB_oH_jj_HWMBJUvMF3HiBb',0,'Amman Governorate',32.015499,35.915860,'disabled',NULL,NULL),(588,'vendor','$2y$10$50Qw0QFGB/4RpLqkTouaEe3S0UXfLy9BPfhvBLOWPRnJY7iGif.uK','787648464','khliefomar3@gmail.com','omar','khlief','2024-05-26 16:50:04',NULL,'inactive',NULL,NULL,'3P4G+PF7, As-Salt, Jordan','fI-MFDUMQyGrA1Br5qbY2-:APA91bHmuSbzclWash77nvLDMem_B5DsrN2Xuq6eK0OSbaHGBHdQIz_7rINu8FDeF7RNE24c8WQnoZdcEGDDp_9Luh0rarq8R8WNats6V6tg0hXBwgWLMxKz3gsi91xwXg6D5oHBO7oK',0,'Balqa Governorate',32.057339,35.726818,'disabled',NULL,NULL),(589,'vendor','$2y$10$NPBHhStaVLj7AkIrWQ7a3.kvspD2Xzok4h/6oRAhbjDIw6HALdk92','795268492','alqdodo8@gmail.com','دانيا ','القطاطشه ','2024-05-30 12:05:52',NULL,'inactive',58652,'2024-06-01 21:23:27','RJQ3+M2F, At-Tafilah, Jordan','fyZ23esySMe-1rz_E3ol-n:APA91bG3Qdf2MhLdMi6jJmVO2NZXfE5piOUGucExZFF8gnWeQap0SG25OHST8frdRRVPmw8J8gpEJ9e264wY9t0elBFfNAq7RFm4IEzC1OYR205FG5oqfBVv-4le6RXmh6Z2ltLmTPtL',0,'Tafilah Governorate',30.838513,35.601844,'disabled',NULL,NULL),(590,'customer','$2y$10$iaFtBGwfLfZetT4HaTL.s.YV2Ipqrk/6XdpRxcwH2D0dCo1YNMA2m','791586203','dawoudt@gmail.com','Tariq','salim','2024-05-30 18:27:12',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','evJX1Z6pTRKHPAkq_d6Btr:APA91bF-dgResFG4zMS9VzqTnUNDgBOL8JTYC_vlICsChJHZc9nIkG7nP9p3CeLC_53NdcH4_JwuM-FpsktkEDa_zGwJ43OCputhM5ugFaeQQvLHPD2kq1PnsgXAJXn-QPnpKwRAfa6J',NULL,'Amman Governorate',32.014048,35.865291,'disabled',NULL,NULL),(591,'customer','$2y$10$I3j72IUL1j54LvjhfOz1UuXkHagDgqES5CzogqXKgeW4AVNjux8mW','791110188','dianabitar55@gmail.com','diana','albitar','2024-06-02 00:58:58',NULL,'inactive',NULL,NULL,'Damascus St. 95, Amman, Jordan','e1bobDxSQkwkpzJmckGeWW:APA91bEaqU37_jyeqCur5P10HpACDcVhWPwhsMxLulVo7AN4MpJuG1q5K2XO-0evDVcTZDITMefZZSQDyutn4MVotSy9Yvm4iHhJznGcijPZkItcqg_VsCi0UutkVTFMAcVmd01FWzJ-',NULL,'Amman Governorate',31.940379,35.905076,'enabled',NULL,NULL),(592,'vendor','$2y$10$szuDOvclyP7Smd.e8yFZouJi4PB6oKySYowSwdwaIUtI1EFBF.Ary','780135675','mhmwd55511@gmail.com','ام ','معاذ','2024-06-02 09:27:28',NULL,'inactive',NULL,NULL,'335F+52Q, Zarqa, Jordan','dLiwbGX-RiGb-il2_j3B8f:APA91bGOl9lvWzFgBjYtxKDTQjpxKfaIY3FcKQUVkb5S3VUtQqfKcELS-M5cLDjqPjyy41UXjDxiqhBAMUiVwVgFecbfKQS1IUlXBFKG6nmtYjHPPLzdP6ZDF9u8E0Dvbj12xAHXbh2G',0,'Zarqa Governorate',0.000000,0.000000,'disabled',NULL,NULL),(593,'customer','$2y$10$A1lMTukcinmkuCzrKkoQaudx1rROTiv5BS7qALY1bIp6lQcAYxVYG','797093540','raneemhamdan244@gmail.com','raneem','fathi','2024-06-02 15:05:59',NULL,'inactive',NULL,NULL,'VVPQ+7QW, Al-Bonayat St., Amman, Jordan','fCpAjgckoEyVmfo3qr_Y1j:APA91bHSviBGyCIJ5chxZvGgNpb7kzODIE7cJgnX5wXzeU49RmRBkcMtxMdH23QN98Nk-GpeK6_5WBe4d0hT_B5bdR1GBv2jommxvNxDg3JTryK3wP3lWWhPw3xBLbWLi5yNnOjJW2UK',NULL,'Amman Governorate',31.886102,35.888911,'enabled',NULL,NULL),(594,'customer','$2y$10$NvnEnz4B2dCXqiE3N3B6vuua./Xv1GKoS2SEnL3BPLEOfh/HpE4eO','796208280','mdawoud690@gmail.com','mohammas','dawoud','2024-06-05 20:39:13',NULL,'inactive',NULL,NULL,'XRMR+CCC, Amman, Jordan','d4cwN2Pg8EDctKPX6oWZ-b:APA91bFWimC_4hgVc3E_aqKd1f0tMCaFP3dJxtm3ksLUVxUuGSixnWuE_Pz2IgN1L3YIidLPkGhzEkenxUD4_3lB5ZFMSWq6ZSgloYKiA9NmVhx_IrPN45LgGd3Jel6S7Nq2mA7GfcJb',NULL,'Amman Governorate',31.983071,35.841059,'enabled',NULL,NULL),(595,'subAdmin','$2y$10$nryqf/jG4jkiTlVeF4i6SubX1aps/BtKFlvSB1xyX5XUuVHuUayey','776424161','kazanmerched@gmail.com','merched','kazan','2024-06-07 10:01:27',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(596,'customer','$2y$10$83OvOvwaMwxQdsGValHrSe/7lqveVGnt2qzuIllT87N/p/hNRoKnq','782303051','youssef12zaineldeen@gmail.co','جهاد','زين الدين','2024-06-09 09:54:52',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','fecAHcMLTDiT1AN7zzKx3V:APA91bHo5KbfPgL39EoNyFhMsTIJcRLcrWvWboTMwRWlM_j0nlKrMWwG0KqTnu_A1B_4pQz71filfHtW9vHQoqxplVO-RiRqLCNaQ810SHj5jOsFkiONPdHFF8oxThKLMqH1Qx0-ANfQ',NULL,'Amman Governorate',32.014313,35.865381,'enabled','1.0.07',NULL),(597,'customer','$2y$10$vILkgJAMhvs88Ykoq8n7peWduXMFYT602uAMkANGVi0s4VmGn6J.m','782303077','pickum.sales76@gmail.com','sales ','pickum','2024-06-09 10:43:53',NULL,'inactive',NULL,NULL,'Dar As-Salehin St. 1, Amman, Jordan','cgObPTZMSvq8BKSFyq1RDO:APA91bEl8kzquNs4s-OOXkcGl8XGqh_LGbKAARFF8rYLcl-lu_WgOs05slgljfxcthp9o2rTjs6EBtv4KgheMQ472OYT-_1jBAlto-dnexySeBrEnxJZhbbXkX3rTjj9r4yS03xMWtUn',NULL,'Amman Governorate',31.976890,35.843678,'enabled','1.0.07',NULL),(598,'customer','$2y$10$QLH9XV8rRptuNtMlPPiGV.3Vc7PACRd.2UEMv.K9cMS65eXfFhzVe','799006608','fawzialkayally@gmail.com','fawzi','alkayall','2024-06-09 11:56:21',NULL,'inactive',NULL,NULL,'XV99+MV8, Amman, Jordan','faig3vtxokdIhTjpjYF2As:APA91bFv0zHQkZeqbW_vvMf7ICugjpOL43mRLzCkk74qs4oP5r1CGHSHscvYEsIeg23TpAMspD1KQSX4WhnSJCAex3xBlxXPprH-3KtuHqCyCj5OWMgqZ4K3M_6AWfCO_QopiVbrCwET',NULL,'Amman Governorate',31.969245,35.869822,'enabled',NULL,NULL),(599,'customer','$2y$10$OXSYHIe9CBCbSxEUDLE1Y.WS/xc.WHOl31idJPpCVpg7Tzd6U8YWu','790551555','faressamarah@icloud.com','fares','samarah','2024-06-09 17:12:01',NULL,'inactive',NULL,NULL,'VW68+79W, Amman, Jordan','f6oJ7EHwQdWQh5b15HBDLo:APA91bG9EVpJJNFtqyfoAXut0J_qECqcC9ZppHriKGsIf5qYpULtU3Tn2t3vh-qw1LQLZu_9CfbcdvXAQ_OZSRBSH7aOdIIC2iPnQvds8qe21LZRGqfyXnZ0d_r025gybz5o12fQHPFg',NULL,'Amman Governorate',31.860292,35.915421,'enabled','1.0.10',NULL),(600,'vendor','$2y$10$cK8./Z3pzOcSLhgT27vvbu8SFJrzsoyq6TmhShhS5JW/USurWLLMO','1111111111','alaa.alzaibk@gmail.com','alaa','alaa','2024-06-13 07:05:07',NULL,'active',NULL,NULL,'QW23+PG Deir Zenoun, Lebanon','dJrA4ApyQAiYhoj2erGnqR:APA91bHPh01daReijLN4JYz53GoZEnRs9ZXPs3OXcnLG2-CfAL8Tmi1WKctjmR2eR74eaVIkBKckieEFqO7mywPyXJ1Qo_n5-UnOPCbFwGuTA9Uo73E3XC5hlOjXOrQaKaGcCI-Eubqp',95.5,'Beqaa Governorate',33.751874,35.903800,'enabled','1.0.15','android'),(601,'customer','$2y$10$mGP/KNjv3xZi9O3kSepMsuv.AZZ1QYvq4EE/HaKVxjlJxf9e6xEK2','777718616','hanan7191@gmail.com','حنان','محاميد ','2024-06-13 17:44:20',NULL,'inactive',NULL,NULL,'WXFC+WCV، عمّان،، WXFC+W49, Amman, Jordan','eK-qnFSkSJi5k7Ryea33cp:APA91bFlVP0CJqWZDY2ov55KQZvn_jvLIA7cp_eCTxkbn_iXH7KgavZg9iQDh9C-lwTl7Dpg76L828bSDTIxT3YAi9Opkp_2y4DrWcFQEiNGKSRvpXNk2k1B7-B3C4Lp1kQ4jtoezreq',NULL,'Amman Governorate',31.925161,35.970061,'enabled','1.0.10',NULL),(602,'vendor','$2y$10$C.YJ5TuHZLGM4VUB7hv.Ku8CXNZPPmh7rGoAa.oKRbeZA6PY1flTC','790069579','Yaraaldwan96@gmail.com','رهف ','الهنداوي ','2024-06-14 17:57:51',NULL,'inactive',NULL,NULL,'Muhammad Al-Hussein St. 7, Amman, Jordan','f38W3HgZQHCaDetRPJMyrr:APA91bGFU5wj_XuBCJMoibc3DuFUKGrsQok8iLvmQlsW2UxJ3-7LUcttSBRT9zFGqprZdh0WXxmrbzD_pc69KjiaNjRD28poPNG-QybDFhNPTFv_r_2pVOGIUS7cGpU2P2pLdfdo5U62',0,'Amman Governorate',31.949448,35.940354,'disabled',NULL,NULL),(603,'vendor','$2y$10$cagwxg7/ek4v7jHPjmezmeqCUXWdr3ohaIBGjG9FOBF6se7jlU9Je','791148670','nasermshmsh72@gmail.com','ناصر ','مشمش ','2024-06-15 18:04:21',NULL,'inactive',NULL,NULL,'Abu Al-Hadhil Al-Allaf St. 12, Amman, Jordan','eqPjFjmwTnaUdlZC415yxw:APA91bGmyA0D8phQFLOSEmmZMk9recUxXUSiFQLnIWjKdOq92dGAfJmaB00OiJIxUXhjKaBhR7PE62OXRNc8O7N5AajFwAQE3ncmIDLASjCh5qJNbRKfxDIg43YpIx1l_kNSIPvYkhFm',0,'Amman Governorate',31.913507,35.922340,'disabled',NULL,NULL),(604,'customer','$2y$10$WkcLgxUBeZVc.fvwm6jVlunRJfoimeepdk6hQdQ8eXtIC00cxgOcK','799209821','samaadnan90@gmail.com','sama','adnan','2024-06-16 14:00:27',NULL,'inactive',NULL,NULL,'Thumamah Al-Ansari St. 11, Amman, Jordan','cUrLn-j-iE9wr8fPmjCxxB:APA91bEP8TrrQtrKdWsW--xa3MsnJ1tEfiJf8Do6NuZx32jhtPRxnQNHHsf1FcACLBySEd9mcrH_q4ItCbXz38CQQyKE_poDITN-28S79RtffktUF2M1GDS6rx0S-ixYLOFf2v1IMHCu',NULL,'Amman Governorate',31.996847,35.876714,'enabled','1.0.10',NULL),(605,'customer','$2y$10$EsE/yjiT5ryJbq3yiaXK4e.EgFLXxKwVJNhF75keVZJhOoLlrKOk.','791019548','ashubita0720@gmail.com','د. احمد','شبيطة','2024-06-17 12:06:45',NULL,'inactive',NULL,NULL,'Zeinab Al-Asadeyah St. 27, Amman, Jordan','cxYWzG5Y8kvig1qw8EAT3j:APA91bGB2pcoYBFULnOuaW769QyGJWkKo1fo0ukWXuS7JaN2ghgZlEr_hETYJ8g_Sl9s81TQb90eKBW_zK72_0Z8XtozBrEaYifLVsWnD45kV2AwA4Th_1D6QUBkvYNR-64vlmAHuSh7',NULL,'Amman Governorate',32.018394,35.881031,'enabled',NULL,NULL),(606,'customer','$2y$10$5Cum7hyouoXc7rF/JrhT5OENljXI3fLmDR94GdT8r9Y7sb6SZKAPC','788384313','muhannad_idris@yahoo.com','مهند','ادريس','2024-06-19 13:15:40',NULL,'inactive',NULL,NULL,'Shafik Irshidat St. 2, Amman, Jordan','e13pphAXT6CQ4fmtmNMrjL:APA91bEWAs6AejxwJUCzagNOPjNtwNkUiUT4dh6zLgyr6VCJmUO4WzR4gYnLwIHhFu_x-U82Vnev9K2qrxDW3oZJkpj5sV5wvzb3YUv-krnldNvwwHVdi1U_W3Ka-ls8vV5VuIGhl3WH',NULL,'Amman Governorate',31.986034,35.943074,'enabled',NULL,NULL),(607,'vendor','$2y$10$3jHCqB1Zz88Q9oXNQgB4OuYgh2rzQPCQaIe.BlKPQWyzm0hltIKLy','778905924','mmmvhvdhjk@gmail.com','Muna','Al Saud','2024-06-24 09:24:37',NULL,'inactive',NULL,NULL,'HQQW+8F Malih, Jordan','fAmcji9_Tw-8AWpbPUCBE9:APA91bFoWS0wIAxnaajFECvIwRtkHlRfbMmqkq_OD6YKbKy_9McvJ0UCnDBQc-qFpsLnsj4v8OP6-H5mZn9zfA7IK0gen7hmXb06qa29BvdtCcVWx_pDBSNUuru7swXha5QAJJ-8JEdp',0,'Madaba Governorate',31.588318,35.796190,'disabled',NULL,NULL),(608,'subAdmin','$2y$10$JH01HmpplXmBJx562dGC0O6ZCHqj1y4MO4Hm2kjC7eZzL4o/hZGia','782303077','sales@pickum.jo','ramiz','nafaa','2024-06-24 10:00:54',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(609,'customer','$2y$10$WSkz4.FWC22e7y91FPLfae0TmSnxbnn7RduOCeDw1/XZM5iVzq85m','797023732','khaledghaith40@gmail.com','خالد ','غيث','2024-06-24 12:12:09',NULL,'inactive',92384,'2024-07-24 11:12:39','Wasfi At-Tall St. 139،, Amman, Jordan','dLru6nRGT4yimm0PIPSOKv:APA91bHuJ_Un_L8BPl1gtcevqT3d3cggccGfgASkq372Z8poXexefncDJTgyE9YvRPEkdw6bXIacFeVnzs9CTqMXaoG96sXhZstjEds8U_vqq7rqwbnUqIa9XAo3ppNUhY6sAAWWPbFz',NULL,'Amman Governorate',31.989886,35.871409,'enabled','1.0.10',NULL),(610,'customer','$2y$10$iuX9NQj1BDU4YGbIDek4h.z4lguBdRvnkZLsQSTwxeTA6tumrZ/lG','799795316','Beboo1995b@gmail.com','Baraah ','Alkhatatbeh ','2024-06-25 08:17:50',NULL,'inactive',NULL,NULL,'Wasfi At-Tall St. 139،, Amman, Jordan','dpy3FP82S3CVfMNHasnO3I:APA91bGTWyn68l_Di53hYnIImUA4x_kHle3iYBsEuRuJetiFiw2WZGzvzY4N1TWSlVErPkljkKZKTWkiF7vqfKbHAynUBCbyo5QpfCz3SDDHrxdkv6uwqiN-cgxjICgMY0Rvn-GY_Llu',NULL,'Amman Governorate',31.989878,35.871416,'enabled','1.0.09',NULL),(611,'customer','$2y$10$/3IaYkmcqBoCQGYg.3MuiOg50Jv/OAsYqVAhpSoic6nmR4PvXT1i.','795294254','wqasem64@gmai.com','وليد','القاسم','2024-06-26 20:40:43',NULL,'inactive',NULL,NULL,'XWJV+MPQ, As-Sidi Al-Musaed St., Amman, Jordan','c5LrKhoBSX6a8Pqs5hioKo:APA91bFux_MVN5QW8m_jvPny6j4xOFCS4v4uMuY5N6CuvllD84Ki0fjYg94lvbww--YFLY4n_4gze5evngY9bH7YMnwT3NvfIfdPeg94BdvUc7_SMycN_ZlSiGIrJmBk3ngKIAHwK8Yv',NULL,'Amman Governorate',31.981789,35.944364,'enabled','1.0.09',NULL),(612,'vendor','$2y$10$1gnU8EoXizbzlxRXKWXS5unrqMCJ6SDYg/ew81DB11dGK3Fe0DPMW','796442728','ahmadfayiz521@gmail.com','احمد ','ابوسرحان ','2024-06-29 09:58:22',NULL,'inactive',NULL,NULL,'23PQ+W82, Zarqa, Jordan','c8WIjvYETIa6Id61KINuC_:APA91bG6yQAs1srgix7YtwELw8loKS_QbEslwEsj4xTwqhxuuKwmGuesOqne56rLqBB5H1Fh8hIHL_fC0ANhgdGSngoZQK-bKyis-4ZZO5LNoihEBvY4cve11Y0CsaO4iBjYwT5oUme7',0,'Zarqa Governorate',32.037254,36.088852,'disabled',NULL,NULL),(613,'vendor','$2y$10$NhE3sVNv/hMK95O74PzDkOgINHb00WrBt5m1BWjuRrAdojyTSrsly','798042094','abdulrazzaq.wwe@gmail.com','راكان','الحمصي','2024-06-29 22:18:11',NULL,'inactive',NULL,NULL,'Hussein Khawjah St. 83, Amman, Jordan','dhFk6v3BQ3C-aFfGn0isvS:APA91bGN605fHRs6qM-8FVwhBU-ZW0AJB4WkNqIXCTUWYqmMqkOHMdRX0EvVM4Vwo88XcR8x-AoeEqjxyNe0P94pRmtt2dy2jRxEZGX3YNXtCmkGJxTreMIr2BFFWuWw0mReplufG0na',0,'Amman Governorate',31.955265,35.839818,'disabled',NULL,NULL),(614,'vendor','$2y$10$WSkz4.FWC22e7y91FPLfae0TmSnxbnn7RduOCeDw1/XZM5iVzq85m','797023732','khaledghaith40@gmail.com','خالد ','غيث','2024-06-30 12:11:18',NULL,'inactive',92384,'2024-07-24 11:12:39','R2HR+MPH, Raiit, Lebanon','cX4vDTb0RXiVR8RfpDnik8:APA91bF5HSkFQ2BBseSyZIL1utCyh8PPUkgnA5u9CtXhtcnLniYhxYcvmHjguoQOHRMjIbj1ev1qtdUNneUq3QI98xGnILrhKBd_zo50xW_Ujj3777Wl2ihNN-WlTYLnWHqpOxFf-zJa',-22,'Beqaa Governorate',33.828942,36.041705,'enabled',NULL,NULL),(615,'vendor','$2y$10$dnGQpBMgBQbwZgBXJF.DhOzo2ahxz21D/xtAji2YIZBPskm1V0jMK','781875711','wdtmqbl4@gmail.com','عودة','مقبل','2024-07-01 08:48:04',NULL,'inactive',NULL,NULL,'35، Jordan','eGGCdzCsSBO9zZu_XJHAyp:APA91bEgz5SoazMC69g_5OPrBZI-9ET82YreoAn4KMGTnh6OTNV_p0HBXDt_gl32OMPtxQ0b2eVDiIw9K8gVOUEnY3CUsVhLWpvW65Y15xRclNARMwgw1-gHZk5GgFfM0MKBXyBDuE4S',5,'Balqa Governorate',32.064067,35.838910,'enabled',NULL,NULL),(616,'vendor','$2y$10$yOvhVaTO5f4PR6WTHgi4veWW46Cpv6DODR.2ImiLPgq07N9xB1oyG','792198797','faresabufares@hotmail.com','فارس','ابو فارس','2024-07-02 07:17:11',NULL,'inactive',31248,'2024-07-04 13:50:46','VXPV+489, Amman, Jordan','d_aG-4ByT1mnKcPgSJHXVq:APA91bFbApz8GiR-rTSkvhBxIKeXxf_TD-MaX7n2PRbI5FvtzsyLltp5cvj3Xgfx5q1Cjy8BVj415DKcwNbNY5DlLb8UcNYCHdu8FSpXiRVIFpdkRMz7d4pkE9GY1rsIV5O1MhkQSytx',0,'Amman Governorate',31.884601,35.994617,'enabled',NULL,NULL),(617,'vendor','$2y$10$VdjDbHEe0buETdE9emRJZOMK1rm..s7bxwEXmwI7KIfjadld8T0ba','787397689','alaaalabed1977@gmail.com','علاء','العبد','2024-07-03 11:43:12',NULL,'inactive',NULL,NULL,'WWVH+QW4, Amman, Jordan','deUYa-J1T4KYsxdeyo2uol:APA91bGqAnABI6Fz2GXwK8BVOggP5PuIUlviuaNM6ZWAQwqHu2AukT_uQ9s2hrL40fGVU55NKV5aU5BMUwQSFBg6L0Hr5qDhdrbVCY0cAyO_k5l_lJzEjv1QL5nDx-IExEVU0O_yBlK3',-1.1,'Amman Governorate',31.946173,35.927860,'enabled','1.0.15','android'),(618,'vendor','$2y$10$5mXe7WH9LrnJHbJ.sJndI.DzAiO2BYLvBRMMesshmFPW4Po.GgL9a','790066575','zaidmansoo1234@gmail.com','زيد ','منصور ','2024-07-04 11:25:23',NULL,'active',NULL,NULL,'Al-Muradi St. 14, Amman, Jordan','c7H_4GNbRYmkJxPpS66pUM:APA91bH6cR-2UK55MVgO9zmwAvp2O_31kRPL-yISbbsTadZLO0mxt1GunpExL7YHhoNrS91h9MY0al1qPVgbF7lxcjVEhWFoeZSf_aj1Sbixjs8wG5P0FlvnmouNOV3emhGttiyCjjvj',0,'Amman Governorate',31.991493,35.883372,'enabled','1.0.15','android'),(619,'vendor','$2y$10$kEYJUQKYv677cJJPKT4s8u5hLp4zHl0yINTUUNrlK.09x0lEcEcuq','795101170','mohammd.alzube20221@gmail.com','محمد','الزعبي','2024-07-04 11:44:06',NULL,'inactive',NULL,NULL,'XVMC+383, Amman, Jordan','cIObCKs-Tv-G3hUldq-wqt:APA91bFoMwX4rhR5aXBXKFp33f660lsxsf7IpFDQLxGi6AGnqK69Ue7U1N2hIGk5fnI1rzn2RMkejbLxbgGeJkvybU-kh1w819gnrGqYYp0IZLMh0MWqBML2r0KJUGq0qiyDNROuN6_R',0,'Amman Governorate',31.982791,35.871008,'enabled',NULL,NULL),(620,'vendor','$2y$10$n.WdH9tYcFp1.wtuOh3G2uvbMi37U4Go48KxSV..P8mEiwWAsHQu.','792860028','mahmodnasrallah93@gmail.com','محمود','نصراللة','2024-07-04 11:58:23',NULL,'active',NULL,NULL,'Khalil As-Salem St. 72, Amman, Jordan','dD3Uv7ytR1q-YgW1NAVAhB:APA91bHT8uNatz2AtaWHzO1_9uIZuBmhB4sD-etoDjWTl8teDmd5e8yQ8V7BfqXyzN7gCsXbsci4huOUhMLUHwFBQxdnpMl5G7rZVrzjBlluPnNKEuUULcq3CCsd5J7B-adQzUs-b9TK',0,'Amman Governorate',31.990693,35.977019,'enabled',NULL,NULL),(621,'vendor','$2y$10$dYgkTKA8M9MoGWJxbNriQec6yNnj6VAB8zlAzWjmyoFA/XRTXpmYS','799966451','Iyadbrkt@gmail.com','اياد ','النتفي','2024-07-04 12:17:04',NULL,'active',NULL,NULL,'3V6G+X58, Amman, Jordan','eIjkeE2zQXqtHBcRPLmQZQ:APA91bGcYRe2UolHdYoLg3Oi1ZO7DlAnzd-vsEUROwuaC7i5Krko0iuA-odJrXHg4jH--gb_gWI7ZclO3Ls25vCD2p3SHsnHyuKv6XbyQBl5k8rj61vQz0PoMGRfPHtq-DGOHRb7GsE3',5,'Amman Governorate',32.061803,35.875295,'disabled',NULL,NULL),(622,'vendor','$2y$10$ZCa3f.hamGyyts1KpbKhOuousLlG1WtzbkYz2BAyVssfb9ped8kUm','798052340','mahmodnasrallah93@gmail.com','حازم','خلف','2024-07-04 14:07:51',NULL,'active',NULL,NULL,'Umm Aws St. 7, Amman, Jordan','c_YJ-qraTTS2kzudJfYgDl:APA91bHrH5uaLpygqXnIcR8et3XB8G-n3NSqpY0vNh59SRGE1W7xEal36d6hZAabdVqXIibuU_B3sjtwNdopQDxogImZle7IwevjOnrXX87L5j5PPOLB-9AN9XRC_Ay6LbYRLSY5xcu_',5,'Amman Governorate',32.003556,35.856477,'enabled',NULL,NULL),(623,'vendor','$2y$10$6kicdSVDgMlzs2FWn9NzLu5.7ikplNwxA3Qlx.LXENraFLHTme13K','782956223','hmydtmo@gmail.com','محمود','حميده','2024-07-06 02:05:34',NULL,'inactive',NULL,NULL,'3RFV+GH Al Hanou, Jordan','cldhA8-vQPSDk052NGIkcO:APA91bFpElJyBkOV1FYyTuLbfKB6sfPX1v36Xd9rT8huJrOqB8VgmzUq3mRacY-bAzbeSsY8NbbysvhbRRhKY6yZXdrH1IA4A1NMU7BPwb6TFlRUM3YMQsEFnzquJJOXdbawWvbrzluU',0,'Balqa Governorate',32.073793,35.843939,'disabled',NULL,NULL),(624,'customer','$2y$10$yA6jRR2fqC6ODEVtOJyYKOW/flJLYqDayWPvwjRlzCzNZqsPyZo96','795115155','wesamstrikers713@gmail.com','امير','عبد الباقي','2024-07-06 12:37:28',NULL,'inactive',NULL,NULL,'Prs. Rahmah St. 4, Amman, Jordan','dIcH4WHgNUgvpi2CUfIQ2g:APA91bE4OKm-dV_IpCo39YrseQdj2__W8kd50RqfjyvEc_iAsK4giTFMpNkjaMz8jjlSxRQVap0Gna4gKtAQifwNv0H7wvAMhnJ0fbKYr65iVd55ITQnfi68jK_gCngJsvsDGQaQZ5As',NULL,'Amman Governorate',31.981990,35.863048,'enabled','1.0.13',NULL),(625,'customer','$2y$10$JBlzJXLJHI7fIW3Wb9d9peD.rHF4vVCAJjNpOYLYXe/C7mybv9qdu','782197831','hamammahdi91@gmail.com','مهدي','حمام','2024-07-07 04:30:50',NULL,'inactive',NULL,NULL,'XXMJ+RHJ, Amman, Jordan','e3kuI0CCQ7iV3moTyapqjI:APA91bGUjSxKESpCNfTYoSkoNHURfS2iOhAtJaZxGL0yXb0hXH2u1BOFPxUv23XHJ7y95r9zvwhVaT3B6VSiOymBvRNUg-vjX4TRuFzMqATrlCSwJddMJGTslr-NDYonXpoF9OEAlzCp',NULL,'Amman Governorate',31.984546,35.981434,'enabled','1.0.10',NULL),(626,'subAdmin','$2y$10$2gNl0YSsj9GHseeNUt3lxucmQ3zG2yi02lO7qFt1tyghvBVmYCioe','776197081','Alaa.alzaibk@gmail.com','Mohammed Alaa','Alzaibk','2024-07-07 18:05:03',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(627,'customer','$2y$10$R/2Y1mrlSGhuQoNEYsNhR.26RYyGSOb5R95LKHKWhYl8DN9hpJp.m','797899145','mallekh.maha@outlook.fr','osama','rimawi','2024-07-08 18:03:45',NULL,'inactive',NULL,NULL,'2VH2+6CM, Qays Ben Abaya St., Amman, Jordan','fu-LfQ9e80whvg57B98cmg:APA91bGyZEVLLPuHWEcWaaD4I_hvST_Ndm_3SPGwlZ57EWq4cNjBVohIihCZQcHPArxLzgmNgVCZM4J5MPWLplABSNciO2bw7xAr76QYO3FJjEFtsj1ImbCQZ_Kpc9XoHjeRGAWZJYA7',NULL,'Amman Governorate',32.028751,35.850457,'enabled','1.0.10',NULL),(628,'vendor','$2y$10$fBOgaJeKOtbI50o/DrNjM.OPDqol8DQXV3dNJgVg3Y0Fq4dtT4jqS','703283555','pierre@lit-online.com','بيار','غنطوس','2024-07-10 12:52:54',NULL,'active',NULL,NULL,'VJX7+V45, Nabiyeh, Lebanon','eD3rX7q6RAyTy1XXgLnPYJ:APA91bH7r_ewzv8Jy80S-EF4F7K36dHL5Tg2EsEIL5gIqcU6skLpri45z796STaBs8qJajJNy8pmqUDT8tzmgJNYyhKR3YeLamnqppost0fQwSTtGg7sggGirer2ABcmOo9oGevFqOsg',10,'Mount Lebanon Governorate',33.899776,35.613474,'enabled','1.0.15','android'),(629,'customer','$2y$10$iQvT0p6qkoV23oOmDrAeVOPX8lehtt7rmdgduIjf/5mk817588lhC','796716633','zedrhman47@gmail.com','Mohammad ','albitar ','2024-07-10 22:28:21',NULL,'inactive',NULL,NULL,'Al-Muradi St. 14, Amman, Jordan','eNQqVsHvMUP6n2SUG60yBS:APA91bEDkVb0C5sleuD8dhzYltHKqHTu_1PS42U6wzVAvvRArMQO349HvGmxyuCdfORzAH4RdxMtXm5vMgowL_V01sezXqEyOU0bm4Iij9LfhqbyXp3V5QCkS_s8phtmIQUeJO8XajEH',NULL,'Amman Governorate',31.992002,35.883444,'enabled','1.0.13',NULL),(630,'customer','$2y$10$CGiHJ2oniSyQhgjEQccYJeP88Qef0RDJw6TskqMGnc53/vBU8/7Qq','782303073','ayatmusallam@hotmial.com','ميار','عوض','2024-07-11 10:58:15',NULL,'inactive',NULL,NULL,'WWRW+C5G, Salim Al-Yaaqoubi St., Amman, Jordan','eKLXA4ygIE7vsT_TBv5n2h:APA91bGG7j1Ln9ZpKZl-1b3b3_zmzAWjBg3K-H2atxWsWLcpkPnZSSQtWwkEXQR7EDstUS8hRgQBPFNl5lz1wYibINa8EUfGjLTXUixf2ikU7L0L-12h8iJgQdD6YoMLJHa4TSxullDJ',NULL,'Amman Governorate',31.941004,35.945473,'enabled','1.0.13','ios'),(631,'customer','$2y$10$9YUuguMjo0LinAMJQ6EcNO4RIkgnE8zVES1XbLIehMFyHRj2ouekm','795989975','acmazen@gmail.com','مازن','علان','2024-07-11 11:07:05',NULL,'inactive',NULL,NULL,'WWQV+QQM, Amman, Jordan','d_4_Z1ceTMO58AJyMQkJmE:APA91bGVe2M92buq6-4dNjQ2S5sUd1GlAfYUv-yN4UKbPxj1bQcgxxp9XzqSlMNSFFz1ralLaFyIsUlTcWheVRM2HF5O668TwMY9yHAViC0mRevGiWr7CQ67xotT0x3qrJCURajGv79R',NULL,'Amman Governorate',31.939791,35.944400,'enabled','1.0.13','android'),(632,'customer','$2y$10$6XmcjV4blJsqZM0I0SK.BeFZJRK.oUTKwjtDj8L498bF7GPvnRfRq','797962310','aladwan.mohammad1985@gmail.com','mohammad','aladwan','2024-07-11 11:10:10',NULL,'inactive',33957,'2025-02-04 19:39:41','3V2X+G7M, Amman, Jordan','fGRjn5rMZUA2rNcN-JZDqx:APA91bHT56MTMoCzYi3ezek9RV7R-EGUKY26Ygifm-YncnFINoEAoPV1YWX3Be4hz88Y3U198gUs6touxG6VtQtI5DKPa5UHv20XrWNAKA28Y4Frgtvu1UY',NULL,'Amman Governorate',32.050760,35.898827,'enabled','1.0.13','ios'),(633,'customer','$2y$10$uoXHC2W3wGTs3sy.SQBwtOtMk1Lgyr1F5Uudax0IW.bvZ82x0xyYG','799158001','ahmadfahmawi.af@gmail.com','احمد','فحماوي','2024-07-11 11:34:12',NULL,'inactive',NULL,NULL,'2VHR+R44, Amman, Jordan','es_MKcReFkJdpIFB_5kmij:APA91bGmQRja3arvzj6fb40UC1LUR4gk5wHOXGpBFjhePA-KwJEUICK-uiIcIfhg8--iSTLQjdhhZyk_QbNhJK4dAhPke820p3TclQW85A4ruhomIioHcMzTdjmcac9_rHh19RL5j34M',NULL,'Amman Governorate',32.029206,35.890451,'enabled','1.0.10',NULL),(634,'customer','$2y$10$V.1Ca8lehPR3KztGoQmAXOjM.H.gCINDQNRmGS.ug..ItHJOCNrAG','780882767','ahmednore.2006_tr@icloud.com','احمد طربلسي ','طربلسي ','2024-07-11 12:09:14',NULL,'inactive',NULL,NULL,'XVJ8+V96, Amman, Jordan','fUxmhpSR_EvMu04pJT6X6I:APA91bGqAZo0RBi6qNwyMmrotWx_Ty0klUGhBEcvVQ1W4fhIAGFuWYxvwDDtBPDasUshuFy-jbOVHrNcLaWQXW_P9UjSnqhL3XWBtJO65pDFL-z7Z31kMMs7qGt4CRpOiqWazisFWmyE',NULL,'Amman Governorate',31.981503,35.866158,'enabled','1.0.13','ios'),(635,'customer','$2y$10$dd9Kmf0/8lgOnPMV9eKyguQbje5mhf28eFGdH0wltdT8IBFJv0vwy','795072794','ysahar670@gmail.com','sahar','al haj yousef','2024-07-11 12:11:56',NULL,'inactive',NULL,NULL,'XW9F+X8C, Tamim Ar-Rimawi St., Amman, Jordan','eH2yIjxMykhPoUzt3nyFZ8:APA91bHS1ydJABY3ctOUnVFb8AiZ6LGAEPbrqj160nDLIH8y4dGYmtVpBg58yk4YNsXZaHUUI9zJk3MuUjKIxWgdqjX8BZvwSjjM1cvY0aTR-IcfpHzSUgQKBlP7gzki0CwTBaOG6cu4',NULL,'Amman Governorate',31.969729,35.923237,'enabled','1.0.10',NULL),(636,'customer','$2y$10$DDU0iZNppB81id3HdxVUmeoG4jI2Y0GeLi4867n4E24ORiHQcRMn.','795807011','Rakan_naffah@yahoo.com','Rakan','naffah','2024-07-11 13:22:52',NULL,'inactive',NULL,NULL,'39M2+FGG, Almazah, Heliopolis, Cairo Governorate 4461221, Egypt','c9AJhS7E7UBhl0LtChPv_g:APA91bHeSwuaDbcEHWJP5KgWpksMO55fDTVBhrFwZYVtxhHq0u_HmjpzS9X9iynZsVcgfOcKWYbi3qz5cazKO27oczneNIJwrvXRWTns08egrWWS7-MtMQAo3EwZAIS-fUstPEaQas1H',NULL,'Cairo Governorate',30.083823,31.351263,'enabled','1.0.13','ios'),(637,'customer','$2y$10$8bgqBsNG2hvBhokLqAnELO.rXcBE.cmkjFdHnItmFwDA4MH.JsLky','796151919','aliyasseen1980@gmail.com','Ali ','yaseen','2024-07-11 19:50:00',NULL,'inactive',NULL,NULL,'2W3P+7Q, Amman, Jordan','d6Ya8PVFt042iuu2fJjESf:APA91bGvpbpvnD-dSiLHXti9V7y8czBRY4dgvSev3iUr2-k2dAra3D_25e_1LfPZELFUAeEvrauDsA8Z51T0Sl6Sdmy9ZoRVKm2FHJ2RKyh7JfAUeGdCeL9K3QxbJkk2OhCD3kk3CdIA',NULL,'Amman Governorate',32.003258,35.936878,'enabled','1.0.10',NULL),(638,'customer','$2y$10$g639L/jcV4lSXtI0TuxclukaFpSJWSwY5OjodmeSnEH1neWtjP0DW','779771559','shakerabadi14@gmail.com','شاكر','العبادي','2024-07-11 20:28:26',NULL,'inactive',NULL,NULL,'XXM4+RVR, Amman, Jordan','cML6BxNFQoiEWodwOAsPG8:APA91bEHCmfUUWjZXJTcswLT1AmrSrJe_whU7uhTd7idhUF6UFISwcZFw5GLgBf5r-3uUu_iIfR9eAyOCfW3TYIFbX3RoujqSZ1Va_Y_VAY4zj4nGu5DKDH3H218df-HeXBjFSsp1KEO',NULL,'Amman Governorate',31.984772,35.956872,'enabled','1.0.10',NULL),(639,'vendor','$2y$10$rbC8Ra1n.shaGV6eh/Ma/O26A7cNnbkJMTTgEO239uAGaCN/./el2','770423097','mohammadshnawer2000@gmail.com','محمد','اشنيور','2024-07-11 23:08:12',NULL,'inactive',NULL,NULL,'2PXM+RPR, As-Salt, Jordan','eDx4b7FoSAKszGH-fOA00K:APA91bFTolvRE0HB5lHgqjJDurM0Sdbz4lT_O9729Qsy0l0LKwotXlm7YcDZ29lfeIJIL9wgv09ClueL5S97VcNzkmWfUQzAcDNbuyBY-AO-PO_UhEsR2WyPiUJvt1jT1RBN_9b5VEkv',0,'Balqa Governorate',32.049167,35.734552,'disabled',NULL,NULL),(640,'customer','$2y$10$EnHzabmEW36H2A3EOv.pGOObi4FjPZv/cBq0ut39jm.kdiLe/lJQa','796400742','said.adely19@gmail.com','saif','adely ','2024-07-12 11:41:40',NULL,'inactive',NULL,NULL,'2Q8W+P2, Fuheis, Jordan','cE2b5p-7KkWqs2cS67nKym:APA91bG3Fx1lvBIxLeASLJdNuG-YJGl-_XeDrSY-OelPn36sgwychN_19805U9oS3YzbLMNrZWtyqY9sruybWxxGkrNv7tHNBhxnqrKwInJ9dY7POTnb8vprFz8Moak_4fM8d_gLGNGI',NULL,'Balqa Governorate',32.015507,35.794422,'enabled','1.0.13',NULL),(641,'customer','$2y$10$SrUOVFdS7IQS8ow8J.Y57OeGnyA0L3FKh13ab87c2N71BBjUd4q0a','776398959','reamalraggad7@gmail.com','jalal','raggad','2024-07-12 13:49:08',NULL,'inactive',NULL,NULL,'V2P5+VVX, Amman, Jordan','ff5tILewg0q1ipz2KyUcuU:APA91bH4E4UFAIKYjBVE-HsQEjJlZKb2aHWokUfzgA1W19LSMjysZyd-2dbUtxJE4XVKrk74N9BlJ9q-kDkr25AF868d7ysmQ7gdQy_zSOCBMaZGprNGj_wzNnNOois4Dzrj_KyWB6lm',NULL,'Amman Governorate',31.886948,36.009672,'enabled','1.0.10',NULL),(642,'customer','$2y$10$0B.xrsrFHKKMZGoCxfNm8O0NuRzmle1qAL7/jpPrmDCYo9ZJdZfEa','789873351','qutada.aliftawi@gmail.com','قتادة','اللفتاوي','2024-07-12 18:06:25',NULL,'inactive',NULL,NULL,'XWG9+H59, Rateb Muhammad Al-Batayneh St., Amman, Jordan','fudf8BJmSkd7ro99P24Ue1:APA91bHMqUEGwltTgqwmTblctAVZQmu5I_mdzZ5TAubOp3MjKGOFQ2U4Y3NZk_CwwMJ9FrjagQZMDkWHHWg7Vsew51a9OCKVJumX3AJr_4DDtGb2BITTAVS3MTCpILLvtejJPx_H27w3',NULL,'Amman Governorate',31.976542,35.917862,'enabled','1.0.10',NULL),(643,'customer','$2y$10$RyP2LJSiRAv1beigiAVl4ewVw6K.tUiSOVuC5Xp7kjnF9fGo7LaCO','776949431','ibrahimabuhani4@gmail.com','ابراهيم ','ابوهاني ','2024-07-13 06:14:41',NULL,'inactive',NULL,NULL,'مادبا حي، مأدبا،، PQ4P+X8X, Madaba, Jordan','c8vY8oDDSgOQNdu0bHXzq7:APA91bFtNhzl3g6g8ZocRqC6rWwa8K-84LOtfg-pODO99BmT-bqSm38xQt12_f7oxANGwMfnFEzZ6s_x_sIx6osmqu6ue4RmeAw3WKaFB7B8Ya7nJcz8h2qjj_2conF1Avhb82QmoN-Z',NULL,'Madaba Governorate',31.707508,35.785843,'disabled','1.0.10',NULL),(644,'customer','$2y$10$sKLDKBqNP78010lrFjTPTOmMt8zw9ko1EaVBMR.vqkp49gpRESnmy','779003836','Omarayasrah25@yahoo.com','عمر','ابو سته ','2024-07-13 11:18:01',NULL,'inactive',NULL,NULL,'7RM3+WJ, Sakib, Jordan','d9nlimPIAEcwk_o-4n-nye:APA91bFr-tqEXeh1y7rXy1JXHQNAKm5ZEEpSStgevazr8wzB4t47aZW9ANQuuyZNhXpTpzbWlsB18OLFn5eMEgE6wI1wH-gcyyNSyw7lOpwyZLI3R-h-OfTy0O4whih80RyD0Z3zF77l',NULL,'Jerash Governorate',32.284032,35.802894,'disabled','1.0.10',NULL),(645,'customer','$2y$10$uaCkkEvtsnakhjt9xQqI7O/onGqGfw/ByfaaNkH4HsZ3KUd.aJe7.','782032048','laithamar08@gmail.com','Laith ','altyate','2024-07-13 11:40:44',NULL,'inactive',NULL,NULL,'XXGH+Q74, Amman, Jordan','cTjDF8MWSUoIgzibrUnIlf:APA91bHA19AtVoVgADW-Kv4mWVaPy5_TjlHx0N2-wtX_8GniUQ79MNn-rPOm2ACdt7_x2916hMeOhybuZu1zbb5UfxHw_RdW6WiKqe9Px9SlTCEBeRx_lHs-EQlQ4fxosmbiKiTFNsDQ',NULL,'Amman Governorate',31.977093,35.978567,'enabled','1.0.10',NULL),(646,'vendor','$2y$10$v.F3KdwEentb7oHkS46mdO.Hhb3DCMqvJUOYVWaiSAnGOByAfVkPS','776747183','motasmzabout01@gmail.com','معتصم','ايمن','2024-07-13 19:59:16',NULL,'inactive',NULL,NULL,'WX7H+W8Q, Amman, Jordan','cXE36r1CSwGOk9EIhCErU7:APA91bEVwxJRlKMggyGZh0PkstUPc4iWbTUM7pLr0Rrhc54aY5Pa0_0epUPB4TDzIIF6UDJrc2TOmgPqDrHDH7h8s96YhjqRWU7kWicxFZqd7YRGqfN0POThl1SZP3HZDTjuF63WAbgt',0,'Amman Governorate',31.914904,35.977993,'disabled',NULL,NULL),(647,'customer','$2y$10$GNTe5n1nlMgXtcnojAtx.uNJPl.vycUcPfE8tmCsfeWoNXeVuLEHq','795642647','naffaa.acc@gmail.com','ناصر','نفاع','2024-07-14 10:39:29',NULL,'inactive',NULL,NULL,'2Q3M+JRJ, Fuheis, Jordan','fQalIKFTQiq5mwQjCr1ijd:APA91bG7r2v8mjd1jDJtAOOrrf2Ar5NWnwtXrMX3x1oHmMDPXUczFJicCEURexxQCg5ksd-qIRynWnAgCw8Bmi_-iJ06GuebR_ZgMlel-QZFACZet2PrmZ8oBiTvaFu_deE7cIvbmr7N',NULL,'Balqa Governorate',32.004080,35.784506,'enabled','1.0.13','android'),(648,'customer','$2y$10$J8Bqo3u9W8jfDzuZ5gZXsOwbNuSmHDeO/dZEPzRz19jl4QwHPxfZ.','791459296','sbmallah95@gmail.com','صهيب ','الملاح','2024-07-15 12:17:14',NULL,'inactive',NULL,NULL,'Moussa Abdul Rahman St. 8, Amman, Jordan','dv1NFAce-kGZoikcR4_t4T:APA91bEPYFDWFBKiOzeXL08Pt-vLZNHHH297sQ8mUkBXZ_6DTLDF9r_aJuVkPLrHHbhPTkwbd2wDIIPofxUewd2dZCcu2OErPRVEojhtpnHcc5WywyYD4WkSu_9PEqLUd4-3k9GGQ8DC',NULL,'Amman Governorate',31.903244,35.890146,'enabled','1.0.13','ios'),(649,'vendor','$2y$10$uON0rxEQsHu8JNau2NRw6umNhqJY/KlODf0BI7D41vTDDKHKzdavy','796244140','majedabushkhedm941@gmail.com','محمود','ابو شخيدم ','2024-07-15 19:01:24',NULL,'active',NULL,NULL,'WXCX+9X Amman, Jordan','fNNm88zlSaOVzRxx3X1ujE:APA91bGRkP2_ISTWfK6AYTW1Vu6i_EqxrVgsIdxG8Eo73NrpP0s-Xp0FFKCgxd3GKnhSILEgtqsGQZmI1CBkvpglJ_42wceg7-Crwfn-QDUv4wq5FGv0wj6GbJKc9gm8vM4tdEYw_llG',5,'Amman Governorate',31.920918,35.999988,'enabled',NULL,NULL),(650,'customer','$2y$10$HWxY.WGpD89FXK.aQp.X2.55/8QYA.iOu31zECb4NPqqgWl8iK6ZW','782303011','12345@customer.com','customer md','','2024-07-15 19:46:48',NULL,'inactive',14136,'2024-07-15 20:05:11','marj','dTt1r5KDS2eKNPTakvKejP:APA91bHCZmu4rLy8bzc1W_znyCasVfkgQaIEI43tn8E3QTIfmgCBnLUc9wSi4pIOGIA5Byb9dnzM14niQOTyV6TPEvRXD4fiPSfHzyOnDvDvH4YPjF5fKuow04ye_L01Ww6x9PihbxKZ',NULL,'main road',33.775063,35.889796,'enabled','1.0.12','android'),(651,'vendor','$2y$10$6VNusmlaIdg6wr/h170yqe3kdmMec7TIF4Sc7WTkoRUSzJI9AEDQ2','782303081','venderr@vendor.com','vendor md','','2024-07-15 20:04:12',NULL,'inactive',54078,'2024-10-11 20:29:57','XVP7+7P Amman, Jordan','eH8cTTJwRvWNYqnpiFG6Yj:APA91bEdlTvMLAaCicU8yLtZfMnxUC4wCtmS1Lgm0wcVXfvOE6_EXap36zpj4kkUdGbV8ph0OnC2e8nYLQbDvQaJufuejdUhK5iw118XX9N22qF6KcUn4n4pdlIp08jgM83lC71cz_3D',47,'Amman Governorate',31.985694,35.864363,'enabled','1.0.15','android'),(652,'customer','$2y$10$iQY.LtFPuUkeh7dHoHT2o.3.sF30IVbi2BPsz1CGEz7sXofJr7mGq','796940556','abadypc01@gmail.com','abbadi','khatoom','2024-07-15 20:45:58',NULL,'inactive',NULL,NULL,'شارع الأمير حمزة،، As-Salt, Jordan','ea6SNNEfT0_SoU9Fk4S1Df:APA91bHZKTt6NQDsyH3Mu82tLiKQ_XgDQBpJQm8PWSomDZfzrzWkyS_MN7050bUChwYK43JdAbsMMN0fS6I0OPTmIZcdDo5QLBJ2egkKMysiPfpeefJAzApo7D0ArabMlGCJ1Fy9lFA_',NULL,'Balqa Governorate',32.064917,35.721656,'enabled','1.0.10',NULL),(653,'vendor','$2y$10$4ZC9/.PLgqn7lrzZq8mkB.wAAyLXmOek2IJJGEAM6RSrTtOdvY6LO','787648525','ismaeelalskafe19@gmail.com','Ismaeel ','Alskafe ','2024-07-17 07:46:16',NULL,'inactive',NULL,NULL,'سحاب،، V279+2GV, Amman, Jordan','fFTi1aBXS3ee9cn2Rr9NHx:APA91bFh78-JBlJ80DSp25dD3M6haK0LvOUkHnAioOKk7V-7BxJ7sz-pfpdGpC5-_Jbl3sN12c_GKegxYz43W6Sx8Ou2FPctgOGGX7UipPYIYfrDPOECJUupOUnYF4qlaBfX4pF9fl37',0,'Amman Governorate',31.862490,36.018664,'disabled',NULL,NULL),(654,'vendor','$2y$10$5s3R2zGT.pVnfo67tAC0cOu/KxDaMCewJMxEfM/ja.m4NtSUMEq7e','780693220','lokalokamoath@gmail.com','معاذ ','الشوابكه','2024-07-18 15:29:00',NULL,'inactive',62116,'2024-07-21 15:42:58','Sahab St., Amman, Jordan','fIXz4GpiRASDfzYeLYAPPQ:APA91bF6x0XOoBwnkw-Iko61oFPROi5vJK8IIJ51AMHLnbgKlIsTQygtS7f8vfb6XKsohB2iuRrQhpAybstbB8mVqAch4-xiNaGZtePMHbbyP2TOt2JSzXQ6f5HK-LIgfi4h6QkORzca',5,'Amman Governorate',31.870060,36.003658,'enabled',NULL,NULL),(655,'customer','$2y$10$XTGtENM9ClNTcj0qkFrwseP1onYtyCrwlI8SHdFhf3r9dfApYNFse','798558972','m5o@hotmail.it','monz','sawa','2024-07-19 12:57:00',NULL,'inactive',NULL,NULL,'XVXC+MWX, Amman, Jordan','fe65UKWtLEj-pCzK7Fm8jX:APA91bHJ92q6fyHFac1iaa-7SVF50G_uDHA0SW8EAQvTCLrpA4Sa11ENYC6jYlJHYsULd7JMSAnpHocDYLBg8hbEeB5QgUhvCU6R_aepXDZc-kDE1BSnD8AGU_5XnHL9GboYu8muSME8',NULL,'Amman Governorate',31.999198,35.872385,'enabled','1.0.13','ios'),(656,'customer','$2y$10$6VNusmlaIdg6wr/h170yqe3kdmMec7TIF4Sc7WTkoRUSzJI9AEDQ2','782303070','mrad.mohammad@gmail.com','محمد','مراد','2024-07-20 14:44:23',NULL,'inactive',98762,'2025-02-28 15:58:18','QVFR+W78, Bar Elias, Lebanon','dFCMtAZeSz20KVkx4Zo0ig:APA91bGwqrITOiVXDw00T7DWXOAiwQuzg2Dg3jFRQRvlIZllmAiE42VybjVwp3l42Tcz1FDqFRNibCbDIue28wNarPSZEX97GeHfUD8qj9aDEKlYdqqDO_rPLi0jnTs6jX7qW_RAwXgU',NULL,'Beqaa Governorate',33.775087,35.889675,'enabled','1.0.13','android'),(657,'sales','$2y$10$rnA/Q35BqrUIasdaQos6AeOQWkYLHuo63y.x.jYdHwFLjTb40Mi96','11111111','Alaa.alzaibk@gmail.com','alaa','Alzaibk','2024-07-20 18:35:02',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(658,'viewer','$2y$10$43xVgbRP2avvV00k2aOVcO0MIcjksQB4j1w42NF496fnWjji2Y4m6','0000000','test@test.com','viewer','viewer','2024-07-20 18:48:38',NULL,'active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'enabled',NULL,NULL),(659,'customer','$2y$10$4nvPIC.MwUtvWm.xSHAnm.RS7dclmP4i9u83uDw/NCtkoiOMqOWg2','797016924','zedrhman@gmail.com','هديل','كلعو','2024-07-21 07:58:47',NULL,'inactive',NULL,NULL,'Al-Shebrawi St. 23, Amman, Jordan','f7jZj6nVTk2l__3ud5wlGp:APA91bHrMBhCRRTSBjzHx_CPqJ6yRpD8tS2AVNI4UzeeMBNE9yFUAhAt6p29igSviq-sXKqUgcfWKGe7Hxf0aq7F9lbu_QQiC-zidO3b_wdQGuRvPhuw33pNi7HOZI2kYikrXb3PcHGO',NULL,'Amman Governorate',31.992067,35.883357,'enabled','1.0.13','android'),(660,'vendor','$2y$10$pwYX0U1LkNl8PnSL4q3D1.jm/ximB7lvnx6ZEnXRLx81xiqgkcg7.','782250309','alskafyasmayl0@gmail.com','Ismaeel ','Alskafe ','2024-07-21 11:33:42',NULL,'inactive',NULL,NULL,'VX8X+5Q3, Amman, Jordan','fRNuK6IYRRCCFVEZBDs671:APA91bG-_qJeZfopj-sDzQZgGSdD4MPbXQH5o0nOc94ZHHUZMFJYDYBszKJF6aPeo0zZ65w6j_8B8x3GFDI0ELJP2McKLueta7ZFHyuZsLp1mq0-O0c5mb78hQGDWoBFEBETLZjdP9QU',0,'Amman Governorate',31.865754,35.999514,'disabled',NULL,NULL),(661,'customer','$2y$10$nzNnGE.6UMkgA4XY11n6uu0kzepA3/96zh5gw0fnkDbmxiEcPJyeS','782250309','alskafyasmayl0@gmail.com','Ismaeel ','Alskafe ','2024-07-21 11:46:39',NULL,'inactive',NULL,NULL,'ش. زينب الأسدية 1, Amman, Jordan','dg53-6BuRsSKa-fqIyP1R_:APA91bGNVwHoMiyB0nGBNR1Vl7nTlNEwoxsMVC7qpkXuYtaAc6dyRkNv-eLHskWE0CvQQWMIX3Ls8NATn-7eYQfDRwUkGsw7FKk8WEQ-e3r0v7dz4s9IL0bUzUws8PGXrP-re9UHGFRr',NULL,'Amman Governorate',31.886894,35.994731,'enabled','1.0.10',NULL),(662,'vendor','$2y$10$0c0pw0v3jBBB1iG/szerfOBIstoTEH7S8LGctZKW6al62S5Be4N26','790999486','ramyazdawy@gmail.com','رامي خالد محمد','ابوخالد','2024-07-21 13:13:48',NULL,'inactive',NULL,NULL,'XV4V+R6J, Zahran St, Amman, Jordan','f3seZG9cQiu-cbWWVBtn-1:APA91bFI73UQeaKXmlS_uc6cFdFxMT6P5POpNKZAgbA_MLP8BDFhcFjtIGEPNwGs3VY9jfLvVdP1hl7gNIud076gZXNHiYwKqLHxskfVl8V_X5QoGmi0EJcjeX0E3YYgzGt36BmYKy_H',5,'Amman Governorate',31.957129,35.893269,'enabled',NULL,NULL),(663,'customer','$2y$10$lg4u5xzvuuZqtK8ZZsz91ujTDXdl0heb8PK.a7Gge7VpRB5SUyDqK','795431248','almasrimahmoud587@gmail.com','محمود ','المصري ','2024-07-22 18:17:29',NULL,'inactive',NULL,NULL,'Heifa St. 40, Amman, Jordan','d2lZM5EcQbeHkyKNZ3XaP-:APA91bHfxfGPlr3A7a3af-WCP9VVbVPgc2kMy41u2Tcu8hXLYIM8F5LIaGkqzzF7o46RfW4G437bKUzFoBCENwEF3v-UWB3VFljkH9oCKGfLYY7Kv7PSdZHtprcel78_xX_4zwwHCl86',NULL,'Amman Governorate',31.972507,35.919215,'enabled','1.0.10',NULL),(664,'customer','$2y$10$YtypxuCkQ/5LLbuqq6o.iOgfrD27ckBM2ZsLa/ztfiV98DqxKFcuS','782552591','mostafa078255@gmail.com','مصطفى','الطويسي ','2024-07-23 09:43:56',NULL,'inactive',NULL,NULL,'XV33+6X7, Issa An-Nouri St., Amman, Jordan','fVNuTxNiQ8C6vzluyJHrBI:APA91bGEkADHvHmck1abRvDhqCSg6lyOvBOmU9BgVPkCmgSktMRoopMl2fAs5kdwgSd-hGkYGZPDaGiiPb3BX-zaj876tLFxTEjG3g-qE2mOKT47zr0XMGwyF5ikJ5FvJVd5z0FL2p4O',NULL,'Amman Governorate',31.952892,35.854821,'enabled','1.0.10',NULL),(665,'customer','$2y$10$/7C49SpMjqTqVxdExM3blu0iQOHnZaTNNvL6K6HUr7rsCR2kVzed2','796137404','umrashad2@hotmail.com','ربا','عوض','2024-07-23 11:30:24',NULL,'inactive',NULL,NULL,'2WVG+VWM, Khalil Hamad Al-Omari St., Amman, Jordan','cFP-wSwKV0etsgTPfceYZq:APA91bE6jAoUcaAzLGbaoG-AECmWH8w9iXOzqUGlGSx6fsdZ9t4TY6dVTPV2g7WaDJE6tID56eHb256Zc0DS0BvuvFykDhZYbxd0CjGrutck3lYfrx-cmcCbezNVyKJVm3HvGQmwYWiV',NULL,'Amman Governorate',32.044078,35.928660,'enabled','1.0.13','ios'),(666,'customer','$2y$10$jywITVk/5MvgijdEvohNseNiPxAIaJu5cc0nHzEeBL1LhqNP1NEES','770757254','jshejsjiwwii@gmail.com','اشراف','الحمامري','2024-07-24 08:37:46',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','e9qboS3OQQS4MJNG-oTTQ-:APA91bETnNCzjGY5TZG99R27hKl7uasQ_KSQ9CSgc75-Lgj2XAmhBkYSVSRyYjFvGDnW-PLOJ00-szpcwJMpgrx41BTXYrB6Yxf-8NkbipSvGbLg0reovAfSUuUJGIZ9HltcfQLAfQVs',NULL,'Amman Governorate',32.014017,35.865100,'enabled','1.0.13','android'),(668,'customer','$2y$10$dhKKdkPEAxwSZ2UuEsqmZOqq2luDqHEHFn8sj63lSrMCZ.uxtm0Bm','782303079','k@k.com','عادل','محمود','2024-07-24 12:35:55',NULL,'inactive',NULL,NULL,'Habes Al-Majali St. 44, Amman, Jordan','dLru6nRGT4yimm0PIPSOKv:APA91bEuOQktTCrxGJKCp1K895Y5AnmnLg2MKWR2PX1s7gkK25hhx538RcgYWBzsADJrqQQBISvmvDDUBFs-JdV9j6Ijsvei_YJdtNtvM1C_dfYJtED_7konduesgE-HAMBMfh_K8e8R',NULL,'Amman Governorate',31.981683,35.938368,'enabled','1.0.13',NULL),(669,'vendor','$2y$10$BjS2vpFF2fTYdt3Ch8LvvONxyWpEZNe6jyqLto8aQqbyOYyjN92fW','780879855','amjdmhmod78@gmail.com','jej','kwhw','2024-07-24 15:10:39',NULL,'inactive',NULL,NULL,'22RF+9C6، الرصيفة،،, الزرقاء، Jordan','cWrQgxb7SYS8t44SFnmX8O:APA91bF1adpzYNdoh2C2bePVoTJNKsp5Gf4Dw18v0vbhShzMlFG1WlMMRlnHcLcGMil3m0dronz_B5WD4w_VfsmTvJ3RufQLX75Wr8rCCEEfLttFBgnQsTa4uVM9aX355KHwJI3zV9pN',0,'محافظة الزرقاء',32.041668,36.024525,'disabled',NULL,NULL),(670,'customer','$2y$10$DzADWPlWzcTz1JcaCfx0MuI4fS/pr3AT5P7NlRsLhxZ17PjA/hvHu','799292416','orjanibayan@gmail.com','bayan','sso','2024-07-25 14:27:50',NULL,'inactive',NULL,NULL,'GVHW+W9Q, Huwwarah, Jordan','cLTXkZ-RTpCCJizf060NZ6:APA91bHQu9WkJqjhXNj9CyI23wl1x6K-ttIdq633IySvbO558SebG52Pysvh4wv3-P7IDuI6wM5H0DgxAGepG9bmWs32TEv5ACeRiL1HJeLD-k3KtfBEtnE66uU15F6PcWFNNDgu7Sor',NULL,'Irbid Governorate',32.529478,35.895147,'enabled','1.0.13',NULL),(671,'customer','$2y$10$jSR6DrSfsoXEnmFkN3HqcOi8I6YhjhUqN3HLqoVvPELqwPwaPyZEu','798606032','motaz1989otaibi@icloud.com','معتز','العتيبي','2024-07-26 11:23:55',NULL,'inactive',NULL,NULL,'2R7M+F7X, Yathreb St., Amman, Jordan','eS4SP5ikgEPBrcDd9FX8xT:APA91bHfQ6MU12GwFFTXYHwm-bFrRKpAkANM40BY--lymOveJSVbrubPh38nokm5uSEV5HhsZzbEXmLG-CJNiX1K4QwoNicQ-w6rJP8Kh7E64qaMZFGTuSEHeIorqyU-4yoepiy2bQKX',NULL,'Amman Governorate',32.013613,35.833247,'enabled','1.0.13',NULL),(672,'customer','$2y$10$jvaCsreSIGlIR4NGwSCb2Oyre2CdhTkGbGzFRffTtNDrdtkI43h6u','779471371','shyrsnzrygat@gmail.com','sheren','sherein','2024-07-28 12:28:44',NULL,'inactive',NULL,NULL,'7VQP+4M7, Jerash, Jordan','c26VE_0qMkULsMyCaFMdqy:APA91bFlhfKmgmYMKS5e9PuUqzBXjYpfihVfpEZ9DuvwSGYi6Fc4VaywSQ5TrIatXD98NacrQbsbeNqsXUiUCrDpTaf8xcT5hJMcOQjs0IgzHPUTqH7fnP4WITrPnQ_rIyuc7VT4vA40',NULL,'Jerash Governorate',32.287609,35.886829,'enabled','1.0.13',NULL),(673,'vendor','$2y$10$mzX.MqCNfnZcMWTywnMEn.9ju5Vd4TQEDLYOmsPQjyAo89Uk4cui6','787863610','zsss7636@gmail.com','محمد','محمد','2024-07-28 19:45:59',NULL,'inactive',NULL,NULL,'334J+QFW, Zarqa, Jordan','fjHPDfADR56r86GVFnlcW8:APA91bHA7Phe_RTZYUSUKqLu3O7pjHaboc73Wrwz4RA-M2Ef0By8ByJiu6l1gnQZuidxD6C_LzfcQbluQ-_PZE0qAkqiM6SYFPU6suCaUUIdbZ4LsKSdTbGX9z_duTubAJNe5CcQVh_1',0,'Zarqa Governorate',32.057004,36.081088,'disabled',NULL,NULL),(674,'vendor','$2y$10$iiCjBrI53rihSQk8jfOEpOMt6Iii24NsIFEG.lq0D1Ht/duGbx..O','796063235','sarh.transport@yahoo.com','محمد','ابو عوض','2024-07-31 07:53:55',NULL,'inactive',NULL,NULL,'ش. الأيوبيين، عمّان،،، Amman, Jordan','d7HhW35tQ1iKz5e6MA1bBI:APA91bFB9hEtXmIb9pRBm9Z5eStbwpODzjTrmECAbZQ-TjRWtZqi8i7zZFw6H89p7qyDWjTHO5wgDzeBkNslPIpka5yTcD-_UYqdUrJn3a8wKpRgI6Se2Uhbbw1AOi-a_517mV9OfqkC',0,'Amman Governorate',31.893347,35.973050,'disabled','1.0.15','android'),(675,'vendor','$2y$10$hivJwBeW5TGYMHbkvL5v/et.wdzP.IevuRkvyX9vyzazPXypK6LWW','791000233','alqawasmifawzi@gmail.com','fawzi','Qawasmi','2024-07-31 07:57:20',NULL,'inactive',NULL,NULL,'ش. الأيوبيين، عمّان،،، Amman, Jordan','ff69TyNWRBmF4vVpdQNKSl:APA91bF5TN88oxAkYeWi2LZwyexWsly1JrhIzMxQGA0_Zxa4Xzhw8Fn0QJC39vp_4TBS9W_llF3OVBnM-XJcIHopbrvSw8kHdtMcrRRKYGp-PXGT7u-5UeVaZQoWS-WpvXW1XxpW6dcJ',0,'Amman Governorate',31.893355,35.973136,'enabled',NULL,NULL),(676,'customer','$2y$10$fZvepqOLPLmeW.aX/ipRsukN5Z5kjt4Sd3bcEvC0ljJpCDCWrF78C','792255969','monzearalsamhore@gmail.com','منذر','السمهوري ','2024-07-31 07:57:39',NULL,'inactive',NULL,NULL,'ش. الأيوبيين، عمّان،،، Amman, Jordan','e_QnKvHiRfG93kCROrhLVT:APA91bGQUkc0FipK2aAZm1cmfejB-ynvOYG2flpsVAkgnqAezbqVokT8XFvS-Ut3AlSrI33aMt_ieVVqG_7ZB_oWzjPiaUwh0M52tpwpZU_ZOlLFKlBz4UVpxRcn1MFfY0ED2Zl-NrkS',NULL,'Amman Governorate',31.893360,35.973128,'enabled','1.0.13','android'),(677,'vendor','$2y$10$PVnXS9p/DYnIkFllua2bmeCp2YWu8JxfwoTudwRpGg5S9.s.oO6Jq','782151422','lokalokamoath@gmail.com','معاذ ','الشوابكه ','2024-07-31 12:20:46',NULL,'inactive',NULL,NULL,'V2M2+5M, Amman, Jordan','fIXz4GpiRASDfzYeLYAPPQ:APA91bEZ0Kg3gfIkQu7UCUDb2jMFSyJbqZIHUNRC0SnI1J2ksUHqWaez0FaMCQAR8HIe0Xio_H4v93syCLOo3JqlZN-8f6rWqgT7_X_MKbxWE92kAYzx2SZXd7BimOdxP1AXG_HUVZLC',0,'Amman Governorate',31.882897,36.001074,'disabled',NULL,NULL),(678,'customer','$2y$10$Us0Azdw0scoBoXNDtebcReFsJgojsCVdqIxDYJVSKApIg.Sny2iki','786995694','kafrisami737@gmail.com','sami','kafri','2024-08-01 09:35:37',NULL,'inactive',NULL,NULL,'WW2X+7Q7, Amman, Jordan','e2Pcl5nVSH6yfdDQ7BPUwR:APA91bGS8ajxNNbqfUnZ74Sv_qHZfxKlA9kdm7bEapJ2sevcAkShDTzNlYSWetK9Zd5isNMJvxLMcmlVwZFWvAYxErOoim5ycnlzJXXAw3rmTwJU6HIDJ1LmMdfZvseDgpaDjtQ3FScx',NULL,'Amman Governorate',31.900400,35.949543,'enabled','1.0.13','android'),(679,'customer','$2y$10$2/Y5uw3u0vVNjlrYvsTAceNbRpt1Ycr0mRizgCXYPiJ1Ll9/oIIkC','790127466','huda.ayman96@gmail.com','هدى','ايمن','2024-08-03 15:51:27',NULL,'inactive',NULL,NULL,'Ath Thawrah Al-Arabeya Al-Kubra St. 93, Amman, Jordan','eki8rFrgDkdok1FQ-7HGCR:APA91bHKa6EV5XLrrUHrEMs5SlcT8eZtJ2kUW-XpC8lqJpbPD-tO-lpozR6E09TLiXaLwbQWHASvvnM0B2sxUyp2ll2K0jj8AUZhvB6ADCzUJSXheQfhpr_G5JPW4M0sbGitDBKE33Se',NULL,'Amman Governorate',32.022655,35.834949,'enabled','1.0.13','ios'),(680,'vendor','$2y$10$sKMpl0.rktYpkgHeGytrKeiNyU527HnZbDllPzju4CcFmz0bZgb0y','772473699','ahmadweshah343@gmail.com','سيف','محمد','2024-08-04 15:27:08',NULL,'inactive',NULL,NULL,'2QMV+7M, As-Salt, Jordan','e-Y1d15eRSePCBjJAhuKP7:APA91bHOWDhiYsv_K47bcPIgAk-ICfikZ1OOve0tGUjcpeNf0djMdG5rY6mev4JpIOI3LqXq8vBdY6xU4ON5gDBvxFPLbo8k3DhRvJkhdlEYoFxL-bDsrDTaOgg9MUFPzJEADtwAh_7U',0,'Balqa Governorate',32.033713,35.793862,'disabled',NULL,NULL),(681,'customer','$2y$10$fD446OmNbRQEE/CEa754au45ZdP25ShboHa7vE0PL1jsgwZ3r1DaK','796220917','saifALMo5les@gmail.com','مرهان','اليامي','2024-08-06 18:56:21',NULL,'inactive',NULL,NULL,'XW25+62P, Ibn Khaldoun St., Amman, Jordan','ft4J4B7FPk2cjd4AuLkl69:APA91bE9iqiSGcl-OMvUDf9XaSuNWhrpEmWuTHd93cHAx6WA6TDOzqLp4ySL1dO9K0lnLbPFXk9U4l5TGUBo50fHc4lcDgZp4pRHi68HzJg7u1h7FIjFPev4sH94_rwSZUiMy0NlbgK1',NULL,'Amman Governorate',31.950213,35.907425,'enabled','1.0.13','ios'),(682,'customer','$2y$10$7Jwn2Dya5ZROxr6NwUgb7.tWVchyUyyjoT7G29yZq0jkahTG9GvH2','782303076','royawad622@gmail.com','roy','awad','2024-08-07 08:56:11',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','ckn2_ccZSfakiBRkocuNFx:APA91bETMFGcFe-ZOD2gsYIU6-KoXXak_XvsjnXo6qztdTdIJt5IuNdH3_XYkTz6_rGiTZZzDarkQK1jV3UC_lkp9guDqlnvhRTO7gVMjgqI3MC5eUoukiUT549zbDTVo5WfH2frQKFv',NULL,'Amman Governorate',32.013952,35.865246,'enabled','1.0.13','android'),(683,'customer','$2y$10$WPiGBbEsrQTBd0XIVI7qRu64r0cQx2jg/ugR6wpceuplfe504akj6','780000056','bashar@menaitech.com','بشار','حوامدة','2024-08-07 09:12:59',NULL,'inactive',NULL,NULL,'Dhi Al Qaada 24, Amman, Jordan','esXrwuegRzqV5kF7fQdAoQ:APA91bHY78C1lFySUygWgZQ7l6PX4qYgGMLAyULH133-sKiTwaz4IuusWc4pRASDF6WMD284x2hCT9RyC8IYBlbyXCDycGR5oyU2cgw8k9DhRG5KQ_Nq5fn7ms_Gvl0p5v64eBZeuzmy',NULL,'Amman Governorate',31.979291,35.845605,'enabled','1.0.13','android'),(684,'customer','$2y$10$nyyjhJhGEQHkOHHxF9hHWuq5rpvJqshXUI5VoyFYZPwtP0THU0fJO','791066207','jebeto3644@alientex.com','سيف الاسلام','بنوني','2024-08-07 20:04:05',NULL,'inactive',NULL,NULL,'XW73+RP9, Amman, Jordan','c6DdKBSCn0dpktm3CxsY6w:APA91bEV6XktlQVEUnRs2PxqkHsYqDc3VSdPkPU9q6qhhMuncgO8JNiQLHUYRFk9rVsJChDtkD5vg2hNiytUFMgy_t2EhjlEjth-sBHn031t9f4s_Q_XQreIBzwk9TeOvj60bIsw2ZSF',NULL,'Amman Governorate',31.964310,35.904471,'enabled','1.0.13','ios'),(685,'customer','$2y$10$zPv/UM7Qw3O/pdNvzwq/7uGRTrKqbPBBPC4CtcGc4p50TXHSy/uCm','780607588','abufararahf628@gmail.com','rahaf','abufara','2024-08-09 13:31:01',NULL,'inactive',NULL,NULL,'Salwan St. 21, Amman, Jordan','eeDidMfwKk0Pq5U84FP8J3:APA91bHO57I4MNyNHD3yyio2IpJzsqrni9uBj_xASJes-NgEugEiZsQf1T726YDdaAO-R1FfAnMXjdae8ac0W-wX2cikcMs4xpIOsSFPBCty9tI6h0Izp835lriH0dhtlqAtGBrHDQUu',NULL,'Amman Governorate',31.962121,35.920128,'enabled','1.0.13','ios'),(686,'customer','$2y$10$RUVfajSXbghpNYClCy6RN.otZFhs3YJFcqpv9Pw7N1ufPhvP4Phqu','776831011','meoh55y@gmail.com','manal','sobeh','2024-08-09 13:48:51',NULL,'inactive',NULL,NULL,'24VM+6V5, Zarqa, Jordan','fhWHk3Y_-UyOtAs6fLhxLL:APA91bEymacVTHoca8QU0XfN1lhFmrernoADdd-lkUxnCqBVmOJAqea1NVfCAVgTYNg8bgo5ev_KAZ8L2i7C6-1rbh25iU9Kd4ULUEjBXWXEyrEEuDDy2Fe6NPi51jvCBOKfofMPb5Kg',NULL,'Zarqa Governorate',32.042233,36.134497,'enabled','1.0.13','ios'),(687,'vendor','$2y$10$p42bnzH5B7rDT1QduvsZ5uR5BJM.fuVx7ARSfSLnDZ4sTGeojOUea','786242206','lobnatashatsha@gmail.com','عبود','طشاطشه','2024-08-10 09:05:27',NULL,'inactive',NULL,NULL,'GVF2+829, Irbid, Jordan','fXVuK-xDRLWs1COyucCjsx:APA91bEVcxojePs7ki07fm2yaUcQf7ZTvUogihkuLyq1a3f483VtloQ0cOf8WYzowtYbI5z5hEsyk-35ygUJ2oyOKGrJ0PHm_ZUmO5GNWZ2GDHEINLprEu4I1jeAmtYrIJh3nqXiHbeL',0,'Irbid Governorate',32.523134,35.850157,'disabled',NULL,NULL),(688,'vendor','$2y$10$U7z96wsI0H1ip5p36N7HCurZ57Cw9e7vuZVylfw1T8wa14wMxK/Li','791881394','reemnofal59@gmail.com','ريم','نوفل','2024-08-10 17:40:08',NULL,'inactive',NULL,NULL,'Ghazwat Dawmat Al-Jandal St. 82, Amman, Jordan','dW4O6DhOQsOfNVdFMmg8rv:APA91bEpO5yVCwa6vZt28LsgPh6qXTnZQKoSVkAgiChX59ara-5j38pMHbyNbi6l-3Dr7jDUp5PaKHW3tIm3gffBqNmW-FZtRWD-GsIg9OIJqEwLGrnkQp2iD-9c3YWSgJ-7G2-JjkjB',0,'Amman Governorate',31.920085,35.929695,'enabled',NULL,NULL),(689,'customer','$2y$10$fbkHkuQ/e5zqGZZNEwcibO9u5jR/pDoRGwAn.qn.k8B1LFliCeWhe','786011545','moutasem.aqel94@outlook.com','معتصم','عقل','2024-08-11 15:40:52',NULL,'inactive',NULL,NULL,'Al-Haram St. 43, Amman, Jordan','e2P8sYSVScyuGKI07Bk6bv:APA91bHv3XxB7_o2H9h-w40kkodme0EYOy2WZ1Ndhw4zcKjzRFFDS4CtSoIgM_YAIeildkoufGR7O58BsKG8lFteZUxPyT_5TN6pZVPPGpZ9mB-bwj3TB62m08_v7BN7LHTyKTHZPxxA',NULL,'Amman Governorate',31.932098,35.896695,'enabled','1.0.13','android'),(690,'customer','$2y$10$J0ISi/O5bFVUx8vElcbfIO9pMF3FHowm4.axEC/l.AhxlfxOFo0Xi','780914363','mikesnap4@gmail.com','mohammad','Haden ','2024-08-13 20:03:54',NULL,'inactive',NULL,NULL,'Abdul Monem Riad St. 59, Amman, Jordan','dKSGeJAIGkRNkroPLtYP8L:APA91bFnSODPESdgVZsLCzYF3E3Ltj5kcOMzeAz62zlecC5xj1_x84m5OvTz7E6QLHc6aBhUdDhhmTj83BvxDmoE2y3Hba0q_bPuIpdFh0t5ln9CdpH6pO7ElKpQyg1BrEius4Le9BaQ',NULL,'Amman Governorate',31.949585,35.908067,'disabled','1.0.13','ios'),(691,'vendor','$2y$10$YlZ9pNcAyc.7CFM5z7weNuaRm3QLJJYNi/rCADRsk8X5Lu78TH0sy','791622419','omrannaser321@gmial.com','عمران','دار ناصر','2024-08-16 14:38:03',NULL,'inactive',NULL,NULL,'WWHH+23, Amman, Jordan','d3ojgad6TGCwd0jIaA6CTe:APA91bFt73OZZVVZyZMMZAXybAvEv1cMOGGV2fMmKaPKKEMmhp1-W-cN5jcLULOMaqZEcnCcPb4vjWHsBtWwNleDmpjkVQgbOKcNZp5njRNn1Fb-mbTqWHrIVVqAWnmUouvXdU7lD-3F',0,'Amman Governorate',31.927796,35.927369,'disabled',NULL,NULL),(692,'customer','$2y$10$FQI4lDQZ/ZhZLgRA1RK6hOJ0ymuzkJG10E8xPKmPV9DiZegwM5sD6','781175495','adamapril91@gmail.com','F','Q','2024-08-16 21:20:03',NULL,'inactive',NULL,NULL,'شارع المزمار 9, As-Salt, Jordan','fnQpWxvTQD2E1oFd4DPvEN:APA91bEX6o51NSKfih6dkQ0U9-Mch_Ysd_nsIG22MzM-texOd45-NIojKSMmR-nLqvwNAjYpIf6DR_LYIcPm5fORkch2lXDFYbd2LMjwEXuBick8mopI6sXPrvvLC4bBKAUcFCSQWkVR',NULL,'Balqa Governorate',32.049964,35.717943,'enabled','1.0.13','android'),(693,'customer','$2y$10$e/Rn2tGFc6aEI1FEojJELOFeyPKU2Pz4hOLqbDtX5YMdwRvshcze2','797179482','aboodabood7827@gmail.com','abood','klah','2024-08-18 17:43:15',NULL,'inactive',NULL,NULL,'Muhammad Al-Jbarat St. 15, Amman, Jordan','cXqgvZopQm6MXouJa5K_wo:APA91bFpia8xC0bMwNl-Lj6OrJiQQQt2U54Wrrn9e9eUctyP0A3-ipyIHmlF58h2J1KIN7luhClJ3BiUNqE5hlb2HNYvuECQ8La0dbEbSv94EFYReSiJ6fJBwpOMoNeEgcdy6tfcN2jw',NULL,'Amman Governorate',32.019154,35.852395,'disabled','1.0.13','android'),(694,'vendor','$2y$10$TKJ6z32VetpC/EaSEG4g.OCqyIOiSutjSp9q.TZdnKqecF6XUSjji','789361334','hsenhdede@yahoo.com','حسين','حديدي','2024-08-19 08:52:07',NULL,'inactive',NULL,NULL,'Yazid Ben Hatem St. 1, Amman, Jordan','c9SV2s4zRmCO1dH0dCZYi1:APA91bF4DGFt5rVgF2Tq3rT2Qix_1mrcAbp1Y-Oown9rTVgsJeQv-62lw4JVnEa1nipTLskjuxP3MjgPovBMckoyVAqR3FOGeOkasvlZoGHFwnK3ER23HSRSSFWgGfb6ahawk8Q7cLK_',0,'Amman Governorate',32.000766,35.915892,'disabled',NULL,NULL),(695,'customer','$2y$10$5/L3UQ2hqcoN/zyU5eJrpeGifyHVvUEj9InwYBqL8S2fPtz8KqC8y','797975060','sameeraalnajjar69@gmail.com','محمد ','دحبور ','2024-08-19 22:04:49',NULL,'inactive',NULL,NULL,'22PC+RJ3, Russeifa, Jordan','fE24g8kFQZuzZFwfBSqLVp:APA91bHS5XK66l3_Dz8I8mDbTLXwBi9738mQpLgNa0zs2EYaL1xIJHo4OcvGkzWp0dkOZRXDJqsBBNKh_0QwBwaj1QbdzH8g0PZzhU8aHqoChWMlg9xfMSgynq4OENXZIo9N213RpHHI',NULL,'Zarqa Governorate',32.036941,36.021549,'enabled','1.0.13','android'),(696,'vendor','$2y$10$6PRkQj6leocUE9ZylwslxOVPmt7jha8FCdp1ULj/ZqCCjjTkj6KhC','775126391','heseinalaaaldeen@gmail.com','زكريا','علاء الدين','2024-08-22 13:13:50',NULL,'inactive',NULL,NULL,'H247+MM7, Aqaba, Jordan','cz5b-6X6SYyiF9Dapaj2-w:APA91bF1xE-LPNkvsr76Po4x4OdabPQ2nay58T7QoVLbQzY-X7f5YHUMByz7HgHdvrELwt22hJ6ehYtXzFzB9Y_0vqLwujkEetgY2-aVTja2PElfGKnoDM2igkoyocB8ut-3fas_MEsm',0,'Aqaba Governorate',29.556225,35.014375,'disabled',NULL,NULL),(697,'customer','$2y$10$UVV1hjc75NW0TyXXV7YZuutmP0wnifH8twT3IfbRRb4SjQAc7WuOq','791485911','ahmadkh_harb@yahoo.com','احمد ','حرب','2024-10-12 08:01:46',NULL,'inactive',NULL,NULL,'مدينة الشرق، الزرقاء،، 346F+8M3, Az-Zarqa, Jordan','dsi-GDgzQu-aVUYTRO0pz0:APA91bHWUN0s0odSkvB0A8v1mTF8SZZJOvXApNvjVP_Qh7j1M0GsrOAfTuGR9-MwrqU8b2MD_Qcn8T4vaQWc8IonF4R9j5rdZXNrQ-0V-6EmpI8fmz2ibQuem4py48RjII-iTd2Jh2WR',NULL,'Zarqa Governorate',32.060764,36.124240,'enabled','1.0.13','android'),(698,'customer','$2y$10$yOps51a8sMHRJYJ1B0RI8.JJsd14A9fBnUEFZSaUNy1P/3yOKbCji','792855864','lailabam77@gmail.com','abbas','abu rayya','2024-10-16 16:32:20',NULL,'inactive',23838,'2024-10-16 16:33:01','2RPP+R9 Safut, Jordan','cL4r5ERNwEOgumSXEvWp6x:APA91bEQlbt0FOZ7fjGvn6XVQT0600w4SHnveqNX9Jdw5z6_YKFQteKHA3VgBOiko9nhoTt8lDnI-u-ccy1fMHZQpIeRIEkh16kfFKENXisAnbMeR67MxIsNdb1Jf2IVdpbd33NCoVKr',NULL,'Al Balqa',32.037027,35.835994,'enabled','1.0.13','ios'),(699,'customer','$2y$10$Vvh1GgsUUjzVht4us0Xoe.D/cMBU/MZvB07HWSIOm.5mtNky9f6s6','798015369','anasflame009@gmail.com','Anas','danleh','2024-10-18 13:22:01',NULL,'inactive',46683,'2024-10-18 19:47:40','XWHF+JCH, Istiqlal St, Amman, Jordan','cQAvo4J3R7aV2TicQRvzX_:APA91bFWnVQ4oqa8mBSPsE8m2WKCbTdxFp-qNZWb1LU6aTd6lz038BTX4trAfj-T-I0mNDRwoiR2Ix0WE9Rg96XrPx6QbhKSGGWAyAhFZ3sseQtisqZtS7l0WS-yWXM2RAWEVaDMxSMW',NULL,'Amman Governorate',31.978911,35.923282,'enabled',NULL,NULL),(701,'customer','$2y$10$6iNTscjTKifE6kokSE0eseBsE72Nq.oqLJkVdMqWxhloCUR/Vycx2','778800000','user@pickum.jo','pickum','user','2024-10-18 19:43:35',NULL,'inactive',NULL,NULL,'Amman','en_BYx0hQ-KxxTOkQLclac:APA91bEGqrqP7zwmA7VETk4fnqOxXx_21itzjOhQqoI7TIgr-0Lbw9_j8gP369qH_TCOIj_jtpVUiu6iMC1fDVaO5Q0TRYnr50QZPdnh57lwdCH6HFldwG9XkJ8iiSq4k3YuF_L-HrXY',NULL,'main road',31.990704,35.868914,'enabled','1.0.13','android'),(702,'vendor','$2y$10$H7YA8adXtcMIMJcg8Ail.OUm4beMZg88ac0Kn/9DCCRIkuZtEZgvK','778899999','nashmi@pickum.jo','nashmi','user','2024-10-18 19:48:15',NULL,'active',NULL,NULL,'R2HR+MPH, Raiit, Lebanon','fvTokIhITuG_3J5LxZY-Mh:APA91bFmfBEErKmmByhiF0239zoNKpG5B0oDuzfY11QcVJhiUEw3P_aM-LfSWheH0jYmdU2eA-atDRr5rPXZ3K5D0bsi3irWxa8J5m3HPbfGPDUt5OmmrjqgBQ-i61TOK5u9D3z7I1gk',0,'Beqaa Governorate',33.828942,36.041705,'enabled','1.0.15','android'),(703,'customer','$2y$10$NdSoGY851aQvfI5FQXj1xO7IE6GcoXD2XZETXSKFkdCE8H3b.m7be','780978565','batooalaham2009@gmail.com','بتول','اللحام','2024-10-19 12:21:02',NULL,'inactive',NULL,NULL,'Kamaliyeh Cir., Amman, Jordan','d-2CTar5RbiHAdhqFLzbSs:APA91bEqO7E-RqAM1rHvjJGTZET3O9DYaugooDXTsn527-RUVgcWjHccV-6ptW1o6HZopURuGMyPQuQ99C5vqulY6hp7gFWIv77gzde7aspF7uNDKipnJEZZPUfCag3lvGVpZ232adin',NULL,'Amman Governorate',32.028744,35.825436,'enabled','1.0.13','android'),(704,'vendor','$2y$10$qJZMCO4So.s.WhMowHOSoOKkhcfqtz6R9bgtk4oohMnNsPqe/hl5C','775998391','alharam12341@gmail.com','علي','الجبالي','2024-10-20 00:22:40',NULL,'inactive',NULL,NULL,'V2J3+GM5, Amman, Jordan','cG8Hu90aSd6gQ-DO1sZbhl:APA91bEI9eVz70zXpf5XXNg4FooGDK_2jFyUCLxNEFpt1hZ9kksDIwBA0PZTjfgyJacffzRlVXHUWj2Noz_flQvPxBYpT0JTMpmZdUq7S8iSuVkQjg2fx4I',0,'Amman Governorate',31.881360,36.004107,'disabled',NULL,NULL),(705,'vendor','$2y$10$.AoMqY81AqW0RfS1UW9ZzObAlBTag6Nvp4xqm4Xx/16PaFJrhPHfW','799945522','s0785085912@gmail.com','صايل ','عبدالله ','2024-10-29 18:07:11',NULL,'inactive',NULL,NULL,'23WW+WGX, Zarqa, Jordan','cyUFBpTiTTujdbUoDF02ik:APA91bG25OAVfl_ytc2hl3jWYBPt2SMl6AVMASc1lm3TRQJ8dPyKLBm3ojlN8OcXOts38n34DmqmTFLGs42jDW2tixfm1PqjFH3EMwJb41PnyV6w4FAx2AwUu5mh37-6tqZXFbN5sg__',0,'Zarqa Governorate',32.047107,36.096305,'disabled',NULL,NULL),(706,'customer','$2y$10$wZJuy/cBE1kmUFf2Apei1.AU5PEnPS9hBX3TrjJ9uDl0ZtJxsiBOm','796972354','manalnaserallah@yahoo.com','منال','الغريب','2024-11-23 10:07:17',NULL,'inactive',NULL,NULL,'3R6G+JQR, Ein Al-Basha, Jordan','cX4ym0X6SNCVE_0UAGJ6sk:APA91bHwRqryHR7J4lMY4_Sg8Yhtqr-roeJxPiOw9wd6VZJWCVUvzJak4EC3L6FUfUXGbvNHKNadEgGr9cmL8O6XZjhrSLhwt2aVMuA1oqqTjYKCl9S6kyQ',NULL,'Balqa Governorate',32.061349,35.826584,'enabled','1.0.13','android'),(707,'customer','$2y$10$gfU3b.No46ATgx1.JJ3zo.zCvXS4G55cjzTyTKo2vNZ8vmelOo3Ci','796604646','maesara985@gmail.com','ميسرة','ابوسليم','2024-11-24 10:22:37',NULL,'inactive',NULL,NULL,'Mahmoud As-Seraj St. 19, Amman, Jordan','eoPmyZEARoOF1IPA7ElPlu:APA91bHxs_ZtvrOFuJNSEnu9jqBVfHW2j6cD_EJpWtCkmVl4P42eYF4SalTamTdDLKGRuQECX7gwwu1ldctycENz4D5FcjZClp1mOEZb6qDLp30SUWk4AxE',NULL,'Amman Governorate',32.031854,35.841952,'enabled',NULL,NULL),(708,'vendor','$2y$10$W7RZHS0JtY1A17tm1B/Bve3IsY/8z6EwRyyuVbohq2nrNyOq/9bnq','785246870','rakanshatara1@gmail.com','rakan eyad ','shatara ','2024-11-25 16:28:24',NULL,'inactive',NULL,NULL,'Haroun Ar-Rashid St. 129, Amman, Jordan','d2_mPF8RTtavHOGcBKtu6e:APA91bEEV_nflzMOG9ycp0KqrwJ6qwRDXo5ZOPGnJ1AjMdUb3BbWHgsYpEyKBWsXtm2k1ILyDK9IqhoRs0zatlVFtBC9sSoL7hwyfSyTVt47xoBSh5G_SmY',0,'Amman Governorate',31.985719,35.915485,'disabled',NULL,NULL),(709,'vendor','$2y$10$0uW8lvUzCSoElXEPoZEik.gzlHdTftZiVMxo73XhaUd77e8sTSvmq','781934165','djjddhhx9@gmail.com','ضياء ','الجهيني ','2024-11-25 19:28:42',NULL,'inactive',NULL,NULL,'328R+PW7, Zarqa, Jordan','cgsnRjRiTbGrDUGtYyzGeS:APA91bFJMl01MpIQhRxSxKM1iIfDZz70w3TXKl5_0VaGSO0j6fMkB5jWZJ-szVZIQDZBpiA1Eisgm0HPxtVcJJVlp7I82WDeRA2TOJUhD6T_Sg8yc8svMfA',0,'Zarqa Governorate',32.066410,36.041813,'disabled',NULL,NULL),(710,'vendor','$2y$10$Qqaq8kA6aZJROA9c7FPBAeMAQglTY.CuZVFt/HcnouxD/36QPqmNK','798245458','barakatyaman55@gmail.com','حسني','حسن','2024-11-28 15:25:43',NULL,'inactive',47134,'2024-12-06 04:34:51','XR2M+C8M، شارع السلمي، Amman, Jordan','dY2n2ur8QJ-xV2kUhaIEbw:APA91bEQJieuQInOx0nuE7YebNWSO3O9Z0req2Ne1tqlJuoELVsRDGfkWVkXAs9TPKcLNlbGL4Nr_fiCXH0JPSlSN0U1Fa9RFfEkGRURfcypkWztLaeTFEw',0,'Amman Governorate',31.951472,35.833343,'disabled',NULL,NULL),(711,'customer','$2y$10$ajY8it4qYYUfGR7eh6qulONptTs9FTHn7v7DbEeZaAtIpkKKDOvDy','797512806','hmaaitah@yahoo.com','هشام ','المعايطه ','2024-11-30 07:12:47',NULL,'inactive',NULL,NULL,'XV92+C3Q, Amman, Jordan','datGlyoZRs-3EeW5eWrPQf:APA91bETBGTxnnWHdgBeej-ldlt20XNazX0Mm5PXITLajnQXGZxIBZhxb_zCrFqTeNt2s4CnZP5ecWC6BJ6FMCHnCB-sncACYtJwg-HlBByw1VP4SfeC_sU',NULL,'Amman Governorate',31.968709,35.849978,'enabled',NULL,NULL),(712,'vendor','$2y$10$TisLiZdJlkH9zaW5BnVhDOG0ujpi.12oxx/ViFwgs4QpoDloL3YXu','791933637','raedaldewarie@gmail.com','raed','aldewarie','2024-11-30 18:33:32',NULL,'inactive',NULL,NULL,'2WW3+5JR, Mufleh Al-Edwan St. 54, Amman, Jordan','df6jbfLNTq6nPBOVOVAlL0:APA91bGvZ33T-CWFCov7-qzOU_1QC1-Hnnyv1yBPLzu67jKsA6xA8a1vYX0GvAJR_-ws-z2aUDT9Obv-tnt7RCEr6OrqEJQBO0Vdqf-2bnQj4VfaZNNDry8',0,'Amman Governorate',32.046211,35.904554,'disabled',NULL,NULL),(713,'customer','$2y$10$nDJoPD8Okuo6UaEJcFoOmuba9QMFIyL2O7LH7dpLTVvIOVvT3r2EG','798599471','obiedatsana@gmail.com','sana ','obiedat ','2024-12-06 07:39:11',NULL,'inactive',NULL,NULL,'3V3W+7C Amman, Jordan','c1PJfEMKqElAmeGhiNUT7h:APA91bGFRRkn4vniaFCS43llDSFqkBy6Lh55ID2VGUiyCJ53tElt-0jffS2aH7YRNRUG22LBGcXDIY2eCP6zXAn0BL4FMvRM90LCfiJGKFucegKpayp16Xc',NULL,'Amman Governorate',32.053162,35.896032,'enabled',NULL,NULL),(714,'customer','$2y$10$TFuF1qOUM2v0MvXzJ5SytuixOM2cYzfjhnmFNC6H4aJQtkcGX4YkO','789697888','nourmoslih95@gmail.com','Nour','Moslih','2024-12-20 12:01:09',NULL,'inactive',NULL,NULL,'2RVQ+V2, Safut, Jordan','eJiasoRzGU7juIZ0A2lU2e:APA91bExZNqYb0roJagtICW_bhmYrT8vyrt8T9t0Z95BGLUnhqzIQHtnDRBo6GlWfHzqLW1ucHoA44-BkqRazXsFTQj-QxFcellfmM0g81zwLb4UYynPihY',NULL,'Balqa Governorate',32.044681,35.837545,'enabled','1.0.13','ios'),(715,'customer','$2y$10$pVko2CBVykS/ycFIAQulzOw9EZCcyPZjyALuPk6MdSsKs7AkAl9TW','786935996','sara.abedrabo97@gmail.com','sara','abedrabo','2024-12-24 12:33:15',NULL,'inactive',NULL,NULL,'227G+8QG, Russeifa, Jordan','e7qgAUG2c0gsmdFK4U_g4J:APA91bHI_cwKY4FiseM6s-TYgyYTjSW2cLeCyL1dnpPTi067JQtHiodRMU9FnX1YqgpIBDMhkaZ_sfS3LrAsVhTGjmCEUKJQCFMngzEHkKdc8-oYzJEAABk',NULL,'Zarqa Governorate',32.013006,36.026704,'enabled','1.0.13','ios'),(716,'customer','$2y$10$cX5gUU9nm1Nnl6w2RuQVR.IgYiCPa7IuRwzB2cpaRi.RmkDzCDdsG','775580440','abedalsamad97@gmail.com','عبدالصمد ','الشطي','2024-12-25 10:43:32',NULL,'inactive',NULL,NULL,'Tarek St. 79, Amman, Jordan','fmkJcAzeSYuzu2VsYcLhyu:APA91bHOb496gHDFL-Rlu1Yiznob2qklZPKS_4SWqyn73WHqkzGfLEhlARHlSJBN9_kvFsESBz595JLNnfVglFDHd0-oljJu5i4o5HgiYy9PgIZl0u1nLug',NULL,'Amman Governorate',31.999107,35.944093,'enabled','1.0.13','android'),(717,'customer','$2y$10$enZQJmGvviqdnWFc1yYTMOxDKr.MJ378LTYbyeaTrmw26p.xdkUEO','792837908','noor.deb.2019@gmail.com','نور','ذيب','2024-12-27 18:43:38',NULL,'inactive',NULL,NULL,'WW2X+H2Q, Hizam Ring Rd, Amman, Jordan','e5uhqpYrjE1-vGUhsKmMmH:APA91bGUlsBEGyPEXdwyAPQGsqVYNal4DVrq835kiFoGnYESeORK18MQhPQj39IgvfRzPH0D0b4rfsr53j40YrjojF1QU1oOuXTzsSVXcxBdq4GYmx5AU1c',NULL,'Amman Governorate',31.901410,35.947364,'enabled',NULL,NULL),(718,'vendor','$2y$10$kPDSR94onieClo1QbVXzTeyToqw.RJuG8PVRO6NCsEHB0p4P6kpg.','786664052','osamaalmsabha@gmail.com','اسامة','ابو صعيليك ','2024-12-28 19:26:52',NULL,'inactive',NULL,NULL,'منطقة النصر،، Amman, Jordan','e7qzAZ5NQQGvRVShcUmNeC:APA91bHZqU2JLWFxXjFiftsrih5-CoWJO7J5oV8ed2tDsNVYffXWLa3jkT0E8a7hxehHaJiVwWEGHZrZn2XhFkIQagwTr8gTgmRGHQ-kqJhyW1zjRol-vbk',0,'Amman Governorate',31.964432,35.996407,'disabled',NULL,NULL),(719,'customer','$2y$10$gOMY424oq1p8efN4kS3a..HFRx3Sy.uKARmpUExAi6tV4urawLryq','777322332','okushb@icloud.com','بشار ','العكش ','2025-01-06 18:54:32',NULL,'inactive',NULL,NULL,'Abdul Qader Al-Jundi St. 99, Amman, Jordan','dTNvIoaKZUB7l3KrdKnCHn:APA91bEaATmEVE-Pym5BeCaPFU6FzdAGtlMCd3jabq0Lj72zRLkBp4jFDErxErev9ezR2Gjvzl2O8E_JfE7Q49gaxPUsJqK8oSOwMN8KYAqz0NVZcWuaR1U',NULL,'Amman Governorate',31.911871,35.929046,'enabled','1.0.13','ios'),(720,'customer','$2y$10$ASVKW0xupqharaHVFbVGVeL8nnuem3cEHoEFdks5um1c90CFwWPnC','795669280','yousefmh4@gmail.com','yousef','ghana','2025-01-30 13:28:28',NULL,'inactive',NULL,NULL,'WX4X+3CF, Amman, Jordan','fkVUdMnA5UmpnYjB_1mX66:APA91bFfU_xJdZsh6yg8mtrYeuKu4aH1LZfH5FnpOo_vixyGiD_b3hqQj-zhS3QgAMkOiH6dqualdeA9q4MjXgQMlevU1SNxoSNgXgTEIRAxGsGsTOsnQCE',NULL,'Amman Governorate',31.905348,35.998328,'disabled','1.0.13','ios'),(721,'customer','$2y$10$MKpwAdn7SYuh0lPjWJ.zJ.CxFzKHW.lWNrcWikxRgF/tleL1el2my','779347965','Mshlahmd569@gmail.com','مشعل','الاحمد','2025-02-02 12:56:17',NULL,'inactive',NULL,NULL,'Sami Msharbash St. 25, Amman, Jordan','dt9Q2_jGRLOoc3DaZCMkXe:APA91bHQ5JK2ko5TEeFvg81zipz9OxduQ9mxtmWkdJGAJI3IcK-KCdXlKTTyHvIPNpHK8wrM569xZjHorvkbXpEBagShbogod8BOKiVNhqnK8IVyGntgnYw',NULL,'Amman Governorate',32.048195,35.878186,'enabled','1.0.13','android'),(722,'customer','$2y$10$rfsLEMQ2QPmzvXRPq.B0qutQ2SPOEH5f8NfJVUV9cMx5xPvI0zKGu','795747032','obadajaber4@gmail.com','obada','jaber','2025-02-04 13:43:13',NULL,'inactive',NULL,NULL,'XWHJ+9CP, Ibn Saed Al-Kheir St., Amman, Jordan','eQFn4g-HM03Dttysl5CzzF:APA91bG1mwT_A3VHxVt4hSryzuLFPe1V-RStyAPNteKsNqGoOAT-XmKDDXWaFCG7mmDoQoxy31DvJ30mJaIJz2HWe4-OtiscRmjV1sevdmWlr7O37Uo_i-g',NULL,'Amman Governorate',31.978704,35.931184,'enabled',NULL,NULL),(723,'vendor','$2y$10$sqLC/IVC0IITJavR5BsMN..VLAJa1RzYgslLqFVwDYcT9a1zzBXxq','798170093','pakertpaza@gamil.com','بكر','طبازة ','2025-02-04 21:53:45',NULL,'inactive',73357,'2025-02-04 21:55:05','Qays Ilan St. 12, Amman, Jordan','cNlEfpT9Q4SkF-dO8_B8zG:APA91bEiWMerxqaQnqCC3ycd4IPtsZ3_J94S6cY3arvhF46XAICjIle5uQa4QNQT8biVAsc0rx7uBcZL8cDzqMH7UTuZXJDcSy5q4C6g2y8rdwfKza-Revs',0,'Amman Governorate',31.909054,35.971557,'disabled',NULL,NULL),(724,'vendor','$2y$10$bSc1mhTegw76OwTL9v0IEe0EXOBESRUHmnxgRlAV.DUR0tRkVXsFG','788788569','mohammadashor5@gmail.com','محمد','عاشور ','2025-02-06 16:50:54',NULL,'inactive',NULL,NULL,'RWRW+PXW, Amman, Jordan','d72uWuqCSlK_bV9Aa89myJ:APA91bHyV_gHAnmZdjWPK_d7u_pxgEQJ2wAm1BUxgI_ikhu1-eE26-YcCT2j9Yql3f4Vm6PfTB_XnHAMuxktwy2wzN01BABpxk238jETyfiTPqVlYMEnlB8',0,'Amman Governorate',31.841380,35.947694,'disabled',NULL,NULL),(725,'customer','$2y$10$/WFYApiWgqvKJ79hndg2QOKRwB1l4AstOcVavSvRsN5ewKgKWsKWG','795533155','mohmmadahmad50@yahoo.com','mohmmad','alsheikh','2025-02-08 06:44:46',NULL,'inactive',NULL,NULL,'2V82+VRW, Amman, Jordan','dTQVLHsyHU-AgLaK3Sd9So:APA91bEXY_4oRZt1sTs5o2_Qq2v1MS3zgsSt-_NGs6xPZNKk0jkhOu0CD7BqNd_M4JHjLdPnzASGuxIbx_KGYgDRW-zW8Qw2yMnpSSPxUbsta9yl3AO7Y74',NULL,'Amman Governorate',32.017328,35.852030,'enabled',NULL,NULL),(726,'customer','$2y$10$mu664nYUMZE6TMfTNRoF9eH9VjiQnYrMOGjg1GNGFfOWwmre6Bc4u','780673182','جهاد@gmail.com','جهاد','زين الدين','2025-02-28 09:57:30',NULL,'inactive',NULL,NULL,'2V78+R4H, Amman, Jordan','eyagooCtR7mSVr_SVrHZgE:APA91bHtPxGV1i-9K9JuNtLJiRtovI1D7qQ5ILmypPPr0KXxh9vSTEjzN3m7QvIbJ3fHt8_TMwndndHVcC1rhd3pzWRaK0yuFTAPrRwgAPguL5pnANk6CkY',NULL,'Amman Governorate',32.014145,35.865290,'enabled','1.0.13','android'),(727,'customer','$2y$10$4tr4La9aZXomYxM.0g.m1uuF401alJ3/sntxr6Eastr301OWG0ksi','779209444','momaniabood286@gmail.com','Abdallah ','Almomani','2025-02-28 19:35:22',NULL,'inactive',NULL,NULL,'Amman nagar ganapathipalayam, XW36+Q64، عمّان، Jordan','flXbPEVpuUV2t_aooP9AUo:APA91bGoTTzXZPgQJNXZEXikCl2KQ0nrHNfBZkdrZsPXjnl-4aOXxeYgTgdaGtxiCbfnvzXD0qSC_3wFJGBadsffWC9kGvE9o1nJJRC9fh25mwSgq-n8uf0',NULL,'محافظة العاصمة',31.954379,35.910578,'enabled',NULL,NULL),(728,'customer','$2y$10$ct83/krTtpXuq/hjxjH52OMMWGELW/4ip.lzWDssEAMf5vmi7uQ2O','790165768','karamalqudah32@gmail.com','Karam','AlQudah','2025-02-28 19:35:33',NULL,'inactive',NULL,NULL,'8QR4+PCP, Ajloun, Jordan','eJoIMo3YPktNsVQ-xtQDJy:APA91bGK8fewIY3C-HqR8Dg7A9VFyX9qWtXn5WYURMfKmYGATOrWHU0gMNNDGDDah_dYDIfupoD25zfNWHn36rzgbnq4bAM-hfNcelIKo5w0xE5b5-uX4Pg',NULL,'Ajloun Governorate',32.341626,35.755894,'enabled',NULL,NULL),(729,'vendor','$2y$10$LNEJylB/55mgxYb10lr9Z.pe.EtHRJ5M1CLyoQS3AbwV5ke7zw/IW','778951202','lykhlas439@gmail.com','اخلاص','علي','2025-02-28 21:05:19',NULL,'inactive',NULL,NULL,'35 89،، Jordan','clxhdx0vTQWT5snTRY8ZTf:APA91bE4k7odmyhh8orFSOHlZpzoaqp0z2j4o_WxTOcROpuxTComDwHNBNx8TMeWaL_VuV9SS306QpFOw7BxonKswlzDRUW0krnamLFnbt704bHKBwGZ9Ms',0,'Tafilah Governorate',30.876975,35.685213,'disabled',NULL,NULL),(730,'customer','$2y$10$KZYHZx7gWcWxh66aGAoiyOi5BINskeswDxztz5PxCtP9BuP8SQSQ.','795951091','mustafahattab20@icloud.com','mustafa','hattab','2025-03-01 22:04:00',NULL,'inactive',NULL,NULL,'3V58+7HX, Amman, Jordan','eyGQV7Y6l0I9ozwHs2jHy2:APA91bEGl0O9_NXcxTK0Z-J0oVoOhhHhYnI7C6_UvpFfHCEkXCwXg6p_KwkzbhL6qAMfkqdC1KdSCV-RFQJTzqrsuPX7ZSWRJedzHwOIdfdbjgG5cUJQJ2A',NULL,'Amman Governorate',32.058015,35.866545,'enabled',NULL,NULL),(731,'customer','$2y$10$drwPbXLZvx0rFcaRPTbPyuj.QoWIxBibzuEZmlf/K74f/FTFguiWa','799249977','hosghar@gmail.com','Hosam','Ali','2025-03-03 12:42:11',NULL,'inactive',NULL,NULL,'2VG4+9Q, Amman, Jordan','fxOP5znNBERqvhIM7xghI6:APA91bGzAfd7k2RChnMecOE66ysR8iS3QdfkZcknhoVfftjrVcdhWbIEFY0vuTpR2CIsvjaEo7ALCDHI7QUiGB4tetHnDI1rg_aud5iYMXbuEe25smqwlyU',NULL,'Amman Governorate',32.025918,35.856801,'enabled',NULL,NULL),(732,'customer','$2y$10$FR.uaeI9psmvdnMZ69SPZufPoJOQQR1Z5rIrD53x02o6TIbhQQZNy','786335270','enghaniaeman@gmail.com','هاني','الجليلاتي','2025-03-19 02:27:26',NULL,'inactive',NULL,NULL,'VR9V+WF, Amman, Jordan','eTYDcU16TdOZwzYoHf-9Mo:APA91bGojbtTdmZ1nlUQBCKSHxj1ASyoRMt_6VLN0Wcj2pnZXnoOeDfPZwKbij_kTagHC9hDtXuhNulwsbLqsLjx5wcAFVLzy41N-z6sc1Fi544nebkhQJk',NULL,'Amman Governorate',31.870185,35.843719,'enabled',NULL,NULL),(733,'vendor','$2y$10$2OTBHiqCkiZYA62x/RDKpex16mDBxu049QS37AIZaB6fMD6A02GHi','790309498','sbhyabwnhlt777@gmail.com','صبحي','ابو نحله','2025-03-26 09:58:28',NULL,'inactive',NULL,NULL,'2W3P+6XF, Tarek St., Amman, Jordan','fBCjNxLMRDSEJl2mrUcWVl:APA91bFoRDR5qrYNBLxheytrcJxQQQgCvSo17F7LyNjI_NJIKpRL-o6YO3RRehmXlSGI5oOIGNkyXEepSRErrTyktRm-UiDLKx_WPPgEqC31Qw-NnSKTJ3Q',0,'Amman Governorate',32.003065,35.937411,'disabled',NULL,NULL);
/*!40000 ALTER TABLE `users_old` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendorActivityLog`
--

DROP TABLE IF EXISTS `vendorActivityLog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `vendorActivityLog` (
  `activityId` int NOT NULL AUTO_INCREMENT,
  `activityUserId` int DEFAULT NULL,
  `activityStatus` varchar(10) NOT NULL,
  `activityStartTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `activityEndTime` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`activityId`),
  KEY `activityUserId` (`activityUserId`),
  CONSTRAINT `vendorActivityLog_ibfk_1` FOREIGN KEY (`activityUserId`) REFERENCES `users` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=45286 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendorActivityLog`
--

LOCK TABLES `vendorActivityLog` WRITE;
/*!40000 ALTER TABLE `vendorActivityLog` DISABLE KEYS */;
INSERT INTO `vendorActivityLog` VALUES (42950,651,'active','2024-10-13 20:22:02',NULL),(42951,651,'active','2024-10-13 20:27:03',NULL),(42952,651,'active','2024-10-13 20:32:56',NULL),(42953,651,'active','2024-10-13 20:33:39',NULL),(42954,651,'active','2024-10-13 20:35:38',NULL),(42955,651,'active','2024-10-13 20:36:57',NULL),(42956,651,'active','2024-10-13 20:41:35',NULL),(42957,651,'active','2024-10-13 20:43:21','2024-10-13 20:43:24'),(42958,651,'active','2024-10-13 20:43:28','2024-10-13 20:43:43'),(42959,651,'active','2024-10-13 20:43:49','2024-10-13 20:44:36'),(42960,651,'active','2024-10-13 20:45:34',NULL),(42961,651,'active','2024-10-13 20:48:36',NULL),(42962,651,'active','2024-10-13 20:49:32',NULL),(42963,651,'active','2024-10-13 20:55:51',NULL),(42964,651,'active','2024-10-13 21:20:01',NULL),(42965,651,'active','2024-10-14 20:22:28',NULL),(42966,651,'active','2024-10-14 20:40:33',NULL),(42967,651,'active','2024-10-14 20:50:22',NULL),(42968,651,'active','2024-10-14 20:56:09',NULL),(42969,651,'active','2024-10-15 18:47:27',NULL),(42970,600,'active','2024-10-15 19:16:15','2024-10-15 20:41:56'),(42971,651,'active','2024-10-15 20:13:08',NULL),(42972,651,'active','2024-10-15 22:03:25',NULL),(42973,89,'active','2024-10-16 03:40:52','2024-10-16 05:24:04'),(42974,157,'active','2024-10-16 08:42:19',NULL),(42975,157,'active','2024-10-16 08:42:53',NULL),(42976,157,'active','2024-10-16 08:46:30',NULL),(42977,157,'active','2024-10-16 09:54:00',NULL),(42978,157,'active','2024-10-16 10:24:10',NULL),(42979,89,'active','2024-10-16 11:16:58',NULL),(42980,157,'active','2024-10-16 12:40:23',NULL),(42981,460,'active','2024-10-16 13:59:32','2024-10-16 14:30:19'),(42982,290,'active','2024-10-16 14:00:28',NULL),(42983,89,'active','2024-10-16 14:09:00',NULL),(42984,89,'active','2024-10-16 14:31:01','2024-10-16 14:31:03'),(42985,651,'active','2024-10-16 20:14:04','2024-10-16 20:14:14'),(42986,651,'active','2024-10-16 20:14:28',NULL),(42987,651,'active','2024-10-16 20:55:48',NULL),(42988,651,'active','2024-10-16 21:00:10',NULL),(42989,651,'active','2024-10-16 21:00:24',NULL),(42990,651,'active','2024-10-16 22:46:53',NULL),(42991,157,'active','2024-10-17 07:05:58',NULL),(42992,231,'active','2024-10-17 09:05:34',NULL),(42993,157,'active','2024-10-17 11:27:11',NULL),(42994,600,'active','2024-10-17 15:17:33',NULL),(42995,600,'active','2024-10-17 15:33:35','2024-10-17 15:34:17'),(42996,600,'active','2024-10-17 15:34:39','2024-10-17 15:54:38'),(42997,600,'active','2024-10-17 15:55:49',NULL),(42998,651,'active','2024-10-17 16:15:38',NULL),(42999,651,'active','2024-10-17 16:15:44',NULL),(43000,651,'active','2024-10-17 16:19:41',NULL),(43001,651,'active','2024-10-17 16:19:48',NULL),(43002,651,'active','2024-10-17 16:20:17',NULL),(43003,651,'active','2024-10-17 16:20:18',NULL),(43004,651,'active','2024-10-17 16:22:11',NULL),(43005,651,'active','2024-10-17 16:22:14',NULL),(43006,651,'active','2024-10-17 16:23:47',NULL),(43007,651,'active','2024-10-17 16:25:12',NULL),(43008,651,'active','2024-10-17 16:25:15',NULL),(43009,651,'active','2024-10-17 16:28:02',NULL),(43010,651,'active','2024-10-17 16:28:06',NULL),(43011,651,'active','2024-10-17 16:30:16',NULL),(43012,651,'active','2024-10-17 16:30:17',NULL),(43013,651,'active','2024-10-17 16:32:28',NULL),(43014,651,'active','2024-10-17 16:32:30',NULL),(43015,651,'active','2024-10-17 16:32:40',NULL),(43016,651,'active','2024-10-17 16:32:45',NULL),(43017,600,'active','2024-10-17 17:50:54',NULL),(43018,600,'active','2024-10-17 17:50:57','2024-10-17 19:59:15'),(43019,651,'active','2024-10-17 19:52:32',NULL),(43020,651,'active','2024-10-17 19:52:34',NULL),(43021,651,'active','2024-10-17 19:54:14',NULL),(43022,651,'active','2024-10-17 19:54:25',NULL),(43023,651,'active','2024-10-17 19:54:30','2024-10-17 19:55:18'),(43024,651,'active','2024-10-17 19:55:20',NULL),(43025,651,'active','2024-10-17 19:55:21','2024-10-17 19:55:26'),(43026,651,'active','2024-10-17 19:55:28',NULL),(43027,651,'active','2024-10-17 19:55:29',NULL),(43028,651,'active','2024-10-17 19:55:35',NULL),(43029,651,'active','2024-10-17 19:58:01','2024-10-17 19:58:02'),(43030,651,'active','2024-10-17 19:58:41',NULL),(43031,651,'active','2024-10-17 19:58:45','2024-10-17 19:58:46'),(43032,651,'active','2024-10-17 19:59:16',NULL),(43033,651,'active','2024-10-17 19:59:19','2024-10-17 19:59:30'),(43034,651,'active','2024-10-17 19:59:32',NULL),(43035,651,'active','2024-10-17 19:59:34','2024-10-17 20:00:32'),(43036,600,'active','2024-10-17 19:59:54',NULL),(43037,651,'active','2024-10-17 20:00:37','2024-10-17 20:00:38'),(43038,651,'active','2024-10-17 20:00:40',NULL),(43039,651,'active','2024-10-17 20:00:41','2024-10-17 20:00:43'),(43040,651,'active','2024-10-17 20:00:45',NULL),(43041,651,'active','2024-10-17 20:00:46','2024-10-17 20:00:48'),(43042,651,'active','2024-10-17 20:00:50',NULL),(43043,651,'active','2024-10-17 20:00:51','2024-10-17 20:00:51'),(43044,651,'active','2024-10-17 20:01:11',NULL),(43045,651,'active','2024-10-17 20:01:16',NULL),(43046,651,'active','2024-10-17 21:07:06',NULL),(43047,157,'active','2024-10-18 11:08:24',NULL),(43048,157,'active','2024-10-18 11:08:30',NULL),(43049,651,'active','2024-10-18 21:12:16',NULL),(43050,651,'active','2024-10-18 21:12:22',NULL),(43051,702,'active','2024-10-19 11:21:51','2024-10-19 11:23:01'),(43052,702,'active','2024-10-19 11:24:50',NULL),(43053,702,'active','2024-10-19 11:26:34',NULL),(43054,702,'active','2024-10-19 11:26:38',NULL),(43055,600,'active','2024-10-19 12:03:05',NULL),(43056,651,'active','2024-10-19 13:57:03','2024-10-19 13:57:07'),(43057,651,'active','2024-10-19 13:57:09','2024-10-19 13:57:13'),(43058,651,'active','2024-10-19 13:57:15',NULL),(43059,651,'active','2024-10-19 13:57:17','2024-10-19 13:57:28'),(43060,651,'active','2024-10-19 13:57:40',NULL),(43061,651,'active','2024-10-19 13:57:41','2024-10-19 13:57:45'),(43062,651,'active','2024-10-19 13:57:47',NULL),(43063,651,'active','2024-10-19 13:57:49','2024-10-19 13:57:52'),(43064,651,'active','2024-10-19 13:58:05',NULL),(43065,651,'active','2024-10-19 13:58:08','2024-10-19 13:58:27'),(43066,651,'active','2024-10-19 14:01:26',NULL),(43067,651,'active','2024-10-19 14:01:27',NULL),(43068,651,'active','2024-10-19 14:01:54',NULL),(43069,651,'active','2024-10-19 14:01:54',NULL),(43070,651,'active','2024-10-19 14:02:07',NULL),(43071,651,'active','2024-10-19 14:02:08',NULL),(43072,651,'active','2024-10-19 14:02:18',NULL),(43073,651,'active','2024-10-19 14:11:23','2024-12-05 15:06:30'),(43074,157,'active','2024-10-20 06:12:55',NULL),(43075,362,'active','2024-10-20 13:58:13',NULL),(43076,362,'active','2024-10-20 13:58:15',NULL),(43077,362,'active','2024-10-20 16:23:03',NULL),(43078,89,'active','2024-10-21 07:44:44',NULL),(43079,89,'active','2024-10-21 07:44:46',NULL),(43080,89,'active','2024-10-21 07:45:01',NULL),(43081,89,'active','2024-10-21 07:45:15',NULL),(43082,89,'active','2024-10-21 07:45:30',NULL),(43083,89,'active','2024-10-21 07:45:47',NULL),(43084,89,'active','2024-10-21 07:46:10',NULL),(43085,89,'active','2024-10-21 07:46:34',NULL),(43086,89,'active','2024-10-21 07:46:54',NULL),(43087,89,'active','2024-10-21 08:12:30',NULL),(43088,89,'active','2024-10-21 08:12:31',NULL),(43089,89,'active','2024-10-21 08:12:45',NULL),(43090,89,'active','2024-10-21 08:12:58',NULL),(43091,89,'active','2024-10-21 08:13:14',NULL),(43092,89,'active','2024-10-21 08:13:30',NULL),(43093,89,'active','2024-10-21 08:13:46',NULL),(43094,89,'active','2024-10-21 08:14:02',NULL),(43095,89,'active','2024-10-21 08:14:20',NULL),(43096,89,'active','2024-10-21 08:14:35',NULL),(43097,89,'active','2024-10-21 08:14:50',NULL),(43098,89,'active','2024-10-21 08:15:03',NULL),(43099,89,'active','2024-10-21 08:15:16',NULL),(43100,89,'active','2024-10-21 08:15:31',NULL),(43101,89,'active','2024-10-21 11:21:42',NULL),(43102,89,'active','2024-10-21 11:21:49',NULL),(43103,89,'active','2024-10-21 11:22:12',NULL),(43104,89,'active','2024-10-21 11:22:25',NULL),(43105,89,'active','2024-10-21 11:22:38',NULL),(43106,89,'active','2024-10-21 11:22:52',NULL),(43107,89,'active','2024-10-21 11:23:01',NULL),(43108,89,'active','2024-10-21 12:04:59',NULL),(43109,89,'active','2024-10-21 12:05:06',NULL),(43110,89,'active','2024-10-21 12:06:17',NULL),(43111,89,'active','2024-10-21 12:06:23',NULL),(43112,203,'active','2024-10-23 08:29:26',NULL),(43113,203,'active','2024-10-23 08:29:27',NULL),(43114,203,'active','2024-10-23 08:29:33',NULL),(43115,203,'active','2024-10-23 08:29:39',NULL),(43116,203,'active','2024-10-23 08:30:14',NULL),(43117,203,'active','2024-10-23 10:22:13',NULL),(43118,203,'active','2024-10-23 10:22:22',NULL),(43119,203,'active','2024-10-23 10:22:27',NULL),(43120,203,'active','2024-10-23 10:22:32',NULL),(43121,203,'active','2024-10-23 10:22:37',NULL),(43122,203,'active','2024-10-23 10:22:43',NULL),(43123,203,'active','2024-10-23 10:22:47',NULL),(43124,203,'active','2024-10-23 10:22:52',NULL),(43125,203,'active','2024-10-23 10:22:58',NULL),(43126,203,'active','2024-10-23 10:23:02',NULL),(43127,203,'active','2024-10-23 10:23:07',NULL),(43128,203,'active','2024-10-23 10:23:13',NULL),(43129,203,'active','2024-10-23 10:23:17',NULL),(43130,203,'active','2024-10-23 10:23:22',NULL),(43131,203,'active','2024-10-23 10:23:32',NULL),(43132,203,'active','2024-10-23 10:24:03',NULL),(43133,203,'active','2024-10-23 10:25:11',NULL),(43134,203,'active','2024-10-23 10:25:17',NULL),(43135,203,'active','2024-10-23 10:25:27',NULL),(43136,203,'active','2024-10-23 10:25:37',NULL),(43137,203,'active','2024-10-23 10:25:47',NULL),(43138,203,'active','2024-10-23 10:25:57',NULL),(43139,203,'active','2024-10-23 10:26:07',NULL),(43140,203,'active','2024-10-23 10:26:58',NULL),(43141,203,'active','2024-10-23 10:27:07',NULL),(43142,203,'active','2024-10-23 10:27:17',NULL),(43143,203,'active','2024-10-23 10:27:27',NULL),(43144,203,'active','2024-10-23 10:27:52',NULL),(43145,203,'active','2024-10-23 10:28:02',NULL),(43146,203,'active','2024-10-23 10:28:12',NULL),(43147,203,'active','2024-10-23 10:31:32',NULL),(43148,203,'active','2024-10-23 10:31:42',NULL),(43149,203,'active','2024-10-23 10:31:57',NULL),(43150,203,'active','2024-10-23 10:32:12',NULL),(43151,203,'active','2024-10-23 10:32:37',NULL),(43152,203,'active','2024-10-23 10:32:51',NULL),(43153,203,'active','2024-10-23 10:33:02',NULL),(43154,203,'active','2024-10-23 10:33:12',NULL),(43155,203,'active','2024-10-23 10:33:22',NULL),(43156,203,'active','2024-10-23 10:34:17',NULL),(43157,203,'active','2024-10-23 10:34:37',NULL),(43158,203,'active','2024-10-23 10:34:53',NULL),(43159,203,'active','2024-10-23 10:36:12',NULL),(43160,203,'active','2024-10-23 10:38:02',NULL),(43161,203,'active','2024-10-23 10:38:17',NULL),(43162,203,'active','2024-10-23 10:38:37',NULL),(43163,203,'active','2024-10-23 10:38:53',NULL),(43164,203,'active','2024-10-23 10:39:17',NULL),(43165,203,'active','2024-10-23 10:39:39',NULL),(43166,203,'active','2024-10-23 10:39:53',NULL),(43167,203,'active','2024-10-23 10:40:03',NULL),(43168,203,'active','2024-10-23 10:40:12',NULL),(43169,203,'active','2024-10-23 10:40:22',NULL),(43170,203,'active','2024-10-23 10:40:32',NULL),(43171,203,'active','2024-10-23 10:40:48',NULL),(43172,203,'active','2024-10-23 10:40:57',NULL),(43173,203,'active','2024-10-23 10:41:07',NULL),(43174,203,'active','2024-10-23 10:41:12',NULL),(43175,203,'active','2024-10-23 10:41:22',NULL),(43176,203,'active','2024-10-23 10:41:32',NULL),(43177,203,'active','2024-10-23 10:41:37',NULL),(43178,203,'active','2024-10-23 10:41:47',NULL),(43179,203,'active','2024-10-23 10:41:57',NULL),(43180,203,'active','2024-10-23 10:42:07',NULL),(43181,203,'active','2024-10-23 10:42:17',NULL),(43182,203,'active','2024-10-23 10:42:27',NULL),(43183,203,'active','2024-10-23 10:42:38',NULL),(43184,203,'active','2024-10-23 10:42:48',NULL),(43185,203,'active','2024-10-23 10:42:58',NULL),(43186,203,'active','2024-10-23 10:45:21',NULL),(43187,203,'active','2024-10-23 12:00:31',NULL),(43188,203,'active','2024-10-23 12:02:28',NULL),(43189,203,'active','2024-10-23 12:04:13',NULL),(43190,203,'active','2024-10-23 12:04:48',NULL),(43191,203,'active','2024-10-23 12:04:58',NULL),(43192,203,'active','2024-10-23 12:05:12',NULL),(43193,203,'active','2024-10-23 12:05:18',NULL),(43194,203,'active','2024-10-23 12:05:28',NULL),(43195,203,'active','2024-10-23 12:05:38',NULL),(43196,203,'active','2024-10-23 12:05:48',NULL),(43197,203,'active','2024-10-23 12:05:53',NULL),(43198,203,'active','2024-10-23 12:06:03',NULL),(43199,203,'active','2024-10-23 12:06:13',NULL),(43200,203,'active','2024-10-23 12:06:23',NULL),(43201,203,'active','2024-10-23 12:06:33',NULL),(43202,203,'active','2024-10-23 12:06:53',NULL),(43203,203,'active','2024-10-23 12:06:58',NULL),(43204,203,'active','2024-10-23 12:07:08',NULL),(43205,203,'active','2024-10-23 12:07:18',NULL),(43206,203,'active','2024-10-23 12:07:23',NULL),(43207,203,'active','2024-10-23 12:07:28',NULL),(43208,203,'active','2024-10-23 12:07:33',NULL),(43209,203,'active','2024-10-23 12:07:43',NULL),(43210,203,'active','2024-10-23 12:07:58',NULL),(43211,203,'active','2024-10-23 12:08:08',NULL),(43212,203,'active','2024-10-23 12:08:23',NULL),(43213,203,'active','2024-10-23 12:08:33',NULL),(43214,203,'active','2024-10-23 12:08:43',NULL),(43215,203,'active','2024-10-23 12:08:53',NULL),(43216,203,'active','2024-10-23 12:10:08',NULL),(43217,203,'active','2024-10-23 12:10:18',NULL),(43218,203,'active','2024-10-23 12:10:33',NULL),(43219,203,'active','2024-10-23 12:10:53',NULL),(43220,203,'active','2024-10-23 12:11:17',NULL),(43221,203,'active','2024-10-23 12:11:48',NULL),(43222,203,'active','2024-10-23 12:12:03',NULL),(43223,203,'active','2024-10-23 12:12:18',NULL),(43224,203,'active','2024-10-23 12:12:42',NULL),(43225,203,'active','2024-10-23 12:22:48',NULL),(43226,203,'active','2024-10-23 12:22:57',NULL),(43227,203,'active','2024-10-23 12:23:48',NULL),(43228,203,'active','2024-10-23 12:24:18',NULL),(43229,203,'active','2024-10-23 12:24:23',NULL),(43230,203,'active','2024-10-23 12:24:28',NULL),(43231,203,'active','2024-10-23 12:24:38',NULL),(43232,203,'active','2024-10-23 12:25:53',NULL),(43233,203,'active','2024-10-23 12:26:08',NULL),(43234,203,'active','2024-10-23 12:27:47',NULL),(43235,203,'active','2024-10-23 12:28:03',NULL),(43236,203,'active','2024-10-23 12:28:08',NULL),(43237,203,'active','2024-10-23 12:28:18',NULL),(43238,203,'active','2024-10-23 12:28:48',NULL),(43239,203,'active','2024-10-23 12:29:03',NULL),(43240,203,'active','2024-10-23 12:29:13',NULL),(43241,203,'active','2024-10-23 12:29:18',NULL),(43242,203,'active','2024-10-23 12:29:33',NULL),(43243,203,'active','2024-10-23 12:29:43',NULL),(43244,203,'active','2024-10-23 12:29:48',NULL),(43245,203,'active','2024-10-23 12:29:53',NULL),(43246,203,'active','2024-10-23 12:30:03',NULL),(43247,203,'active','2024-10-23 12:30:13',NULL),(43248,203,'active','2024-10-23 12:30:23',NULL),(43249,203,'active','2024-10-23 12:30:48',NULL),(43250,203,'active','2024-10-23 12:31:08',NULL),(43251,203,'active','2024-10-23 12:31:18',NULL),(43252,203,'active','2024-10-23 12:31:23',NULL),(43253,203,'active','2024-10-23 12:31:28',NULL),(43254,203,'active','2024-10-23 12:31:33',NULL),(43255,203,'active','2024-10-23 12:31:43',NULL),(43256,203,'active','2024-10-23 12:31:53',NULL),(43257,203,'active','2024-10-23 12:32:03',NULL),(43258,203,'active','2024-10-23 12:32:13',NULL),(43259,203,'active','2024-10-23 12:32:23',NULL),(43260,203,'active','2024-10-23 12:32:38',NULL),(43261,203,'active','2024-10-23 12:33:12',NULL),(43262,203,'active','2024-10-23 12:36:32',NULL),(43263,203,'active','2024-10-23 13:20:17',NULL),(43264,203,'active','2024-10-23 13:24:43',NULL),(43265,203,'active','2024-10-23 13:45:37',NULL),(43266,89,'active','2024-10-24 08:27:32',NULL),(43267,89,'active','2024-10-24 08:27:34',NULL),(43268,89,'active','2024-10-24 08:27:52',NULL),(43269,89,'active','2024-10-24 08:28:03',NULL),(43270,89,'active','2024-10-24 08:28:14',NULL),(43271,89,'active','2024-10-24 08:28:31',NULL),(43272,89,'active','2024-10-24 08:29:00',NULL),(43273,89,'active','2024-10-24 08:29:11',NULL),(43274,89,'active','2024-10-24 09:17:25',NULL),(43275,89,'active','2024-10-24 09:17:27',NULL),(43276,89,'active','2024-10-24 09:17:40',NULL),(43277,89,'active','2024-10-24 09:17:54',NULL),(43278,89,'active','2024-10-24 09:18:01',NULL),(43279,89,'active','2024-10-24 09:18:08',NULL),(43280,89,'active','2024-10-24 09:18:15',NULL),(43281,89,'active','2024-10-24 09:18:22',NULL),(43282,89,'active','2024-10-24 09:18:51',NULL),(43283,157,'active','2024-10-24 09:45:40',NULL),(43284,157,'active','2024-10-24 09:45:45',NULL),(43285,241,'active','2024-10-24 12:12:18',NULL),(43286,241,'active','2024-10-24 12:12:19',NULL),(43287,241,'active','2024-10-24 12:13:53',NULL),(43288,241,'active','2024-10-24 12:14:23',NULL),(43289,241,'active','2024-10-24 12:15:13',NULL),(43290,241,'active','2024-10-24 12:15:49',NULL),(43291,241,'active','2024-10-24 12:16:23',NULL),(43292,241,'active','2024-10-24 12:17:09',NULL),(43293,241,'active','2024-10-24 12:17:24',NULL),(43294,241,'active','2024-10-24 15:27:40',NULL),(43295,241,'active','2024-10-24 15:27:42',NULL),(43296,241,'active','2024-10-25 09:21:46',NULL),(43297,241,'active','2024-10-25 09:21:49','2024-10-25 09:22:08'),(43298,241,'active','2024-10-25 09:22:15',NULL),(43299,241,'active','2024-10-25 09:22:19',NULL),(43300,241,'active','2024-10-25 09:23:00',NULL),(43301,241,'active','2024-10-25 09:23:05',NULL),(43302,89,'active','2024-10-27 07:15:56',NULL),(43303,89,'active','2024-10-27 07:15:57',NULL),(43304,89,'active','2024-10-27 07:16:12',NULL),(43305,241,'active','2024-10-27 15:49:22',NULL),(43306,241,'active','2024-10-27 15:49:27',NULL),(43307,241,'active','2024-10-27 15:49:33',NULL),(43308,241,'active','2024-10-27 15:49:42',NULL),(43309,241,'active','2024-10-27 15:49:48',NULL),(43310,241,'active','2024-10-27 15:49:53',NULL),(43311,241,'active','2024-10-27 15:49:57',NULL),(43312,89,'active','2024-10-28 13:32:05',NULL),(43313,89,'active','2024-10-28 13:32:16',NULL),(43314,89,'active','2024-10-28 13:32:26',NULL),(43315,89,'active','2024-10-28 13:32:44',NULL),(43316,617,'active','2024-10-30 07:31:06',NULL),(43317,617,'active','2024-10-30 07:31:10',NULL),(43318,617,'active','2024-10-30 07:31:20',NULL),(43319,617,'active','2024-10-30 07:31:41',NULL),(43320,617,'active','2024-10-30 07:31:46','2024-10-30 07:31:46'),(43321,89,'active','2024-10-30 07:48:04',NULL),(43322,89,'active','2024-10-30 07:48:05',NULL),(43323,89,'active','2024-10-30 07:48:11',NULL),(43324,89,'active','2024-10-30 07:48:25',NULL),(43325,89,'active','2024-10-30 07:48:39',NULL),(43326,89,'active','2024-10-30 07:48:54',NULL),(43327,89,'active','2024-10-30 07:49:09',NULL),(43328,89,'active','2024-10-30 07:49:28',NULL),(43329,89,'active','2024-10-30 07:49:45',NULL),(43330,89,'active','2024-10-30 07:50:01',NULL),(43331,89,'active','2024-10-30 07:50:17',NULL),(43332,89,'active','2024-10-30 07:50:35',NULL),(43333,89,'active','2024-10-30 07:50:52',NULL),(43334,89,'active','2024-10-30 07:51:11',NULL),(43335,89,'active','2024-10-30 07:51:27',NULL),(43336,89,'active','2024-10-30 07:51:42',NULL),(43337,89,'active','2024-10-30 07:52:00',NULL),(43338,89,'active','2024-10-30 07:52:18',NULL),(43339,89,'active','2024-10-30 07:52:38',NULL),(43340,89,'active','2024-10-30 07:52:54',NULL),(43341,89,'active','2024-10-30 07:53:09',NULL),(43342,89,'active','2024-10-30 07:53:26',NULL),(43343,89,'active','2024-10-30 07:53:48',NULL),(43344,89,'active','2024-10-30 07:54:13',NULL),(43345,89,'active','2024-10-30 07:54:33',NULL),(43346,89,'active','2024-10-30 07:54:48',NULL),(43347,89,'active','2024-10-30 07:55:01',NULL),(43348,89,'active','2024-10-30 07:55:23',NULL),(43349,89,'active','2024-10-30 07:55:41',NULL),(43350,89,'active','2024-10-30 07:55:58',NULL),(43351,89,'active','2024-10-30 07:56:14',NULL),(43352,89,'active','2024-10-30 07:56:31',NULL),(43353,89,'active','2024-10-30 07:56:46',NULL),(43354,89,'active','2024-10-30 07:57:02',NULL),(43355,89,'active','2024-10-30 07:57:16',NULL),(43356,89,'active','2024-10-30 07:57:25',NULL),(43357,89,'active','2024-10-30 07:57:37',NULL),(43358,89,'active','2024-10-30 07:57:48',NULL),(43359,89,'active','2024-10-30 07:58:07',NULL),(43360,89,'active','2024-10-30 07:58:20',NULL),(43361,89,'active','2024-10-30 07:58:36',NULL),(43362,231,'active','2024-10-31 06:16:57','2024-10-31 06:18:18'),(43363,231,'active','2024-10-31 06:18:21',NULL),(43364,231,'active','2024-10-31 06:18:23',NULL),(43365,157,'active','2024-10-31 07:56:34',NULL),(43366,157,'active','2024-10-31 07:56:38',NULL),(43367,157,'active','2024-10-31 08:01:19',NULL),(43368,157,'active','2024-10-31 08:01:34',NULL),(43369,157,'active','2024-10-31 08:01:46',NULL),(43370,157,'active','2024-10-31 08:01:57',NULL),(43371,157,'active','2024-10-31 08:02:09',NULL),(43372,157,'active','2024-10-31 08:02:32',NULL),(43373,157,'active','2024-10-31 08:02:40',NULL),(43374,157,'active','2024-10-31 08:02:51',NULL),(43375,157,'active','2024-10-31 08:03:01',NULL),(43376,157,'active','2024-10-31 08:03:13',NULL),(43377,157,'active','2024-10-31 08:03:29',NULL),(43378,157,'active','2024-10-31 08:03:38',NULL),(43379,157,'active','2024-10-31 08:03:46',NULL),(43380,157,'active','2024-10-31 08:06:18',NULL),(43381,204,'active','2024-10-31 08:40:43',NULL),(43382,204,'active','2024-10-31 08:40:47',NULL),(43383,204,'active','2024-10-31 08:40:58',NULL),(43384,204,'active','2024-10-31 08:41:00','2024-10-31 08:51:37'),(43385,231,'active','2024-11-16 07:32:57',NULL),(43386,362,'active','2024-11-16 17:04:29',NULL),(43387,338,'active','2024-11-16 23:38:47',NULL),(43388,338,'active','2024-11-16 23:38:57',NULL),(43389,338,'active','2024-11-16 23:39:04',NULL),(43390,338,'active','2024-11-16 23:39:05','2024-11-16 23:39:21'),(43391,157,'active','2024-11-17 04:00:15',NULL),(43392,157,'active','2024-11-17 04:00:20',NULL),(43393,68,'active','2024-11-18 11:36:34',NULL),(43394,338,'active','2024-11-19 12:12:24',NULL),(43395,338,'active','2024-11-19 12:12:28',NULL),(43396,338,'active','2024-11-19 12:12:35',NULL),(43397,338,'active','2024-11-19 12:12:46',NULL),(43398,338,'active','2024-11-19 12:12:56',NULL),(43399,338,'active','2024-11-19 12:13:05',NULL),(43400,338,'active','2024-11-19 12:13:11',NULL),(43401,338,'active','2024-11-19 12:13:18',NULL),(43402,338,'active','2024-11-19 12:13:29',NULL),(43403,338,'active','2024-11-19 12:13:45',NULL),(43404,338,'active','2024-11-19 12:13:51',NULL),(43405,338,'active','2024-11-19 12:13:56',NULL),(43406,338,'active','2024-11-19 12:14:02',NULL),(43407,338,'active','2024-11-19 12:14:15',NULL),(43408,338,'active','2024-11-19 12:14:16',NULL),(43409,338,'active','2024-11-19 12:14:26',NULL),(43410,338,'active','2024-11-19 12:14:33',NULL),(43411,338,'active','2024-11-19 12:14:42',NULL),(43412,338,'active','2024-11-19 12:14:51',NULL),(43413,338,'active','2024-11-19 12:15:06',NULL),(43414,338,'active','2024-11-19 12:15:15',NULL),(43415,338,'active','2024-11-19 12:15:23',NULL),(43416,338,'active','2024-11-19 12:15:30',NULL),(43417,338,'active','2024-11-19 12:15:38',NULL),(43418,338,'active','2024-11-19 12:15:47',NULL),(43419,338,'active','2024-11-19 12:15:53',NULL),(43420,338,'active','2024-11-19 12:15:58',NULL),(43421,338,'active','2024-11-19 12:16:05',NULL),(43422,338,'active','2024-11-19 12:16:16',NULL),(43423,338,'active','2024-11-19 12:16:22',NULL),(43424,338,'active','2024-11-19 12:16:28',NULL),(43425,338,'active','2024-11-19 12:16:34',NULL),(43426,338,'active','2024-11-19 12:16:40',NULL),(43427,338,'active','2024-11-19 12:16:51',NULL),(43428,338,'active','2024-11-19 12:16:59',NULL),(43429,338,'active','2024-11-19 12:17:07',NULL),(43430,338,'active','2024-11-19 12:17:16',NULL),(43431,338,'active','2024-11-19 12:17:26',NULL),(43432,338,'active','2024-11-19 17:56:40',NULL),(43433,338,'active','2024-11-19 17:56:42','2024-11-19 17:56:46'),(43434,400,'active','2024-11-20 11:29:55',NULL),(43435,89,'active','2024-11-20 12:47:19',NULL),(43436,89,'active','2024-11-20 12:47:20',NULL),(43437,89,'active','2024-11-20 12:47:47',NULL),(43438,89,'active','2024-11-20 12:48:01',NULL),(43439,89,'active','2024-11-20 12:48:15',NULL),(43440,89,'active','2024-11-20 12:48:32',NULL),(43441,89,'active','2024-11-20 12:48:43',NULL),(43442,338,'active','2024-11-20 13:59:59',NULL),(43443,338,'active','2024-11-20 14:00:00',NULL),(43444,338,'active','2024-11-20 14:00:38',NULL),(43445,338,'active','2024-11-20 14:00:40',NULL),(43446,338,'active','2024-11-20 14:02:31',NULL),(43447,338,'active','2024-11-20 14:02:32','2024-11-20 14:02:33'),(43448,338,'active','2024-11-20 14:02:36',NULL),(43449,338,'active','2024-11-20 14:02:39',NULL),(43450,241,'active','2024-11-20 14:19:46',NULL),(43451,241,'active','2024-11-20 14:19:51',NULL),(43452,241,'active','2024-11-20 14:19:57',NULL),(43453,241,'active','2024-11-20 14:20:17',NULL),(43454,241,'active','2024-11-20 14:20:32',NULL),(43455,241,'active','2024-11-20 14:20:42',NULL),(43456,241,'active','2024-11-20 14:20:52',NULL),(43457,241,'active','2024-11-20 14:21:02',NULL),(43458,241,'active','2024-11-20 14:21:22',NULL),(43459,241,'active','2024-11-20 14:21:32',NULL),(43460,241,'active','2024-11-20 14:21:42',NULL),(43461,241,'active','2024-11-20 14:21:53',NULL),(43462,241,'active','2024-11-20 14:22:02',NULL),(43463,241,'active','2024-11-20 14:22:22',NULL),(43464,241,'active','2024-11-20 14:24:03',NULL),(43465,241,'active','2024-11-20 14:24:09',NULL),(43466,241,'active','2024-11-20 14:24:16',NULL),(43467,241,'active','2024-11-20 14:24:23',NULL),(43468,241,'active','2024-11-20 14:24:41',NULL),(43469,241,'active','2024-11-20 14:27:13',NULL),(43470,241,'active','2024-11-20 14:27:28',NULL),(43471,241,'active','2024-11-20 14:27:37',NULL),(43472,241,'active','2024-11-20 14:27:45',NULL),(43473,241,'active','2024-11-20 14:27:52',NULL),(43474,241,'active','2024-11-20 14:27:59',NULL),(43475,241,'active','2024-11-20 14:28:09',NULL),(43476,241,'active','2024-11-20 14:28:17',NULL),(43477,241,'active','2024-11-20 14:28:30',NULL),(43478,241,'active','2024-11-20 14:28:44',NULL),(43479,241,'active','2024-11-20 14:28:54',NULL),(43480,241,'active','2024-11-20 14:29:20',NULL),(43481,241,'active','2024-11-20 14:29:33',NULL),(43482,241,'active','2024-11-20 14:29:41',NULL),(43483,241,'active','2024-11-20 14:29:50',NULL),(43484,241,'active','2024-11-20 14:29:59',NULL),(43485,241,'active','2024-11-20 14:30:12',NULL),(43486,241,'active','2024-11-20 14:30:26',NULL),(43487,241,'active','2024-11-20 14:30:58',NULL),(43488,241,'active','2024-11-20 14:31:38',NULL),(43489,89,'active','2024-11-20 15:30:45','2024-11-20 15:30:47'),(43490,241,'active','2024-11-20 18:03:18',NULL),(43491,241,'active','2024-11-20 18:03:19',NULL),(43492,241,'active','2024-11-20 18:03:25',NULL),(43493,241,'active','2024-11-20 18:03:35',NULL),(43494,241,'active','2024-11-20 18:03:46',NULL),(43495,241,'active','2024-11-20 18:04:30',NULL),(43496,241,'active','2024-11-20 18:04:38',NULL),(43497,241,'active','2024-11-20 18:04:52',NULL),(43498,241,'active','2024-11-20 18:05:06',NULL),(43499,157,'active','2024-11-21 05:16:52',NULL),(43500,157,'active','2024-11-21 05:16:57',NULL),(43501,362,'active','2024-11-23 05:34:11',NULL),(43502,362,'active','2024-11-23 05:34:56',NULL),(43503,362,'active','2024-11-23 05:35:03',NULL),(43504,362,'active','2024-11-23 05:35:08',NULL),(43505,157,'active','2024-11-23 07:55:15',NULL),(43506,157,'active','2024-11-23 07:55:20',NULL),(43507,157,'active','2024-11-23 07:55:27',NULL),(43508,157,'active','2024-11-23 07:55:33',NULL),(43509,157,'active','2024-11-23 07:55:49',NULL),(43510,157,'active','2024-11-23 07:55:51',NULL),(43511,157,'active','2024-11-23 07:56:47',NULL),(43512,157,'active','2024-11-23 07:56:48',NULL),(43513,157,'active','2024-11-23 07:56:53',NULL),(43514,109,'active','2024-11-23 08:29:20',NULL),(43515,109,'active','2024-11-23 08:29:22',NULL),(43516,109,'active','2024-11-23 16:57:13',NULL),(43517,109,'active','2024-11-23 16:57:14','2024-11-23 16:57:15'),(43518,109,'active','2024-11-23 16:57:31',NULL),(43519,109,'active','2024-11-23 16:57:33','2024-11-23 16:57:34'),(43520,109,'active','2024-11-23 19:51:00',NULL),(43521,109,'active','2024-11-23 19:51:00',NULL),(43522,109,'active','2024-11-23 19:51:02',NULL),(43523,109,'active','2024-11-23 20:13:25',NULL),(43524,109,'active','2024-11-24 04:15:44',NULL),(43525,109,'active','2024-11-24 04:18:14',NULL),(43526,109,'active','2024-11-24 04:18:24',NULL),(43527,109,'active','2024-11-24 04:18:35',NULL),(43528,109,'active','2024-11-24 04:18:56',NULL),(43529,109,'active','2024-11-24 04:18:56',NULL),(43530,109,'active','2024-11-24 04:19:09',NULL),(43531,109,'active','2024-11-24 04:19:27',NULL),(43532,109,'active','2024-11-24 04:19:30',NULL),(43533,109,'active','2024-11-24 04:19:36',NULL),(43534,109,'active','2024-11-24 04:19:40',NULL),(43535,109,'active','2024-11-24 04:19:50',NULL),(43536,109,'active','2024-11-24 04:19:56',NULL),(43537,109,'active','2024-11-24 04:20:01',NULL),(43538,109,'active','2024-11-24 04:20:06',NULL),(43539,109,'active','2024-11-24 04:20:11',NULL),(43540,109,'active','2024-11-24 04:20:16',NULL),(43541,109,'active','2024-11-24 04:20:21',NULL),(43542,109,'active','2024-11-24 04:20:26',NULL),(43543,109,'active','2024-11-24 04:20:32',NULL),(43544,109,'active','2024-11-24 04:20:38',NULL),(43545,109,'active','2024-11-24 04:20:43',NULL),(43546,109,'active','2024-11-24 04:20:48',NULL),(43547,109,'active','2024-11-24 04:21:04',NULL),(43548,109,'active','2024-11-24 04:21:09',NULL),(43549,109,'active','2024-11-24 04:21:14',NULL),(43550,109,'active','2024-11-24 04:21:19',NULL),(43551,109,'active','2024-11-24 04:21:24',NULL),(43552,109,'active','2024-11-24 04:21:29',NULL),(43553,109,'active','2024-11-24 04:21:34',NULL),(43554,109,'active','2024-11-24 04:21:39',NULL),(43555,109,'active','2024-11-24 04:21:44',NULL),(43556,109,'active','2024-11-24 04:21:49',NULL),(43557,109,'active','2024-11-24 04:21:54',NULL),(43558,109,'active','2024-11-24 04:21:59',NULL),(43559,109,'active','2024-11-24 04:22:04',NULL),(43560,109,'active','2024-11-24 04:22:09',NULL),(43561,109,'active','2024-11-24 04:22:17',NULL),(43562,109,'active','2024-11-24 04:22:22',NULL),(43563,109,'active','2024-11-24 04:22:27',NULL),(43564,109,'active','2024-11-24 04:22:32',NULL),(43565,109,'active','2024-11-24 04:22:37',NULL),(43566,109,'active','2024-11-24 04:22:42',NULL),(43567,109,'active','2024-11-24 04:22:47',NULL),(43568,109,'active','2024-11-24 04:22:52',NULL),(43569,109,'active','2024-11-24 04:22:57',NULL),(43570,109,'active','2024-11-24 04:23:02',NULL),(43571,109,'active','2024-11-24 04:23:07',NULL),(43572,109,'active','2024-11-24 04:23:12',NULL),(43573,109,'active','2024-11-24 04:23:17',NULL),(43574,109,'active','2024-11-24 04:23:22',NULL),(43575,109,'active','2024-11-24 04:23:27',NULL),(43576,109,'active','2024-11-24 04:23:32',NULL),(43577,109,'active','2024-11-24 04:23:37',NULL),(43578,109,'active','2024-11-24 04:23:42',NULL),(43579,109,'active','2024-11-24 04:23:47',NULL),(43580,109,'active','2024-11-24 04:23:52',NULL),(43581,109,'active','2024-11-24 04:23:57',NULL),(43582,109,'active','2024-11-24 04:24:02',NULL),(43583,109,'active','2024-11-24 04:24:07',NULL),(43584,109,'active','2024-11-24 04:24:12',NULL),(43585,109,'active','2024-11-24 04:24:17',NULL),(43586,109,'active','2024-11-24 04:24:22',NULL),(43587,109,'active','2024-11-24 04:24:27',NULL),(43588,109,'active','2024-11-24 04:24:42',NULL),(43589,109,'active','2024-11-24 04:24:53',NULL),(43590,109,'active','2024-11-24 04:24:58',NULL),(43591,109,'active','2024-11-24 04:25:03',NULL),(43592,109,'active','2024-11-24 04:25:08',NULL),(43593,109,'active','2024-11-24 04:25:15',NULL),(43594,109,'active','2024-11-24 04:27:04',NULL),(43595,109,'active','2024-11-24 04:33:34',NULL),(43596,109,'active','2024-11-24 04:33:59',NULL),(43597,109,'active','2024-11-24 04:34:11',NULL),(43598,109,'active','2024-11-24 04:34:17',NULL),(43599,109,'active','2024-11-24 04:34:24',NULL),(43600,109,'active','2024-11-24 04:34:29',NULL),(43601,109,'active','2024-11-24 04:34:34',NULL),(43602,109,'active','2024-11-24 04:34:39',NULL),(43603,109,'active','2024-11-24 04:34:44',NULL),(43604,109,'active','2024-11-24 04:34:49',NULL),(43605,109,'active','2024-11-24 04:34:54',NULL),(43606,109,'active','2024-11-24 04:34:59',NULL),(43607,109,'active','2024-11-24 04:35:04',NULL),(43608,109,'active','2024-11-24 04:35:09',NULL),(43609,109,'active','2024-11-24 04:35:14',NULL),(43610,109,'active','2024-11-24 04:35:19',NULL),(43611,109,'active','2024-11-24 04:35:24',NULL),(43612,109,'active','2024-11-24 04:35:29',NULL),(43613,109,'active','2024-11-24 04:35:34',NULL),(43614,109,'active','2024-11-24 04:35:39',NULL),(43615,109,'active','2024-11-24 04:35:44',NULL),(43616,109,'active','2024-11-24 04:36:48',NULL),(43617,109,'active','2024-11-24 04:36:53',NULL),(43618,109,'active','2024-11-24 04:36:58',NULL),(43619,109,'active','2024-11-24 04:37:03',NULL),(43620,109,'active','2024-11-24 04:37:08',NULL),(43621,109,'active','2024-11-24 04:37:13',NULL),(43622,109,'active','2024-11-24 04:37:18',NULL),(43623,109,'active','2024-11-24 04:37:23',NULL),(43624,109,'active','2024-11-24 04:37:28',NULL),(43625,109,'active','2024-11-24 04:37:33',NULL),(43626,109,'active','2024-11-24 04:37:38',NULL),(43627,109,'active','2024-11-24 04:37:43',NULL),(43628,109,'active','2024-11-24 04:37:48',NULL),(43629,109,'active','2024-11-24 04:37:53',NULL),(43630,109,'active','2024-11-24 04:37:58',NULL),(43631,109,'active','2024-11-24 04:38:03',NULL),(43632,109,'active','2024-11-24 04:38:08',NULL),(43633,109,'active','2024-11-24 04:38:13',NULL),(43634,109,'active','2024-11-24 04:38:19',NULL),(43635,109,'active','2024-11-24 04:38:26',NULL),(43636,109,'active','2024-11-24 04:38:33',NULL),(43637,109,'active','2024-11-24 04:38:43',NULL),(43638,109,'active','2024-11-24 04:38:49',NULL),(43639,109,'active','2024-11-24 04:38:59',NULL),(43640,109,'active','2024-11-24 04:39:13',NULL),(43641,109,'active','2024-11-24 04:39:21',NULL),(43642,109,'active','2024-11-24 04:39:31',NULL),(43643,109,'active','2024-11-24 04:39:41',NULL),(43644,109,'active','2024-11-24 04:39:47',NULL),(43645,109,'active','2024-11-24 04:39:53',NULL),(43646,109,'active','2024-11-24 04:39:58',NULL),(43647,109,'active','2024-11-24 04:40:03',NULL),(43648,109,'active','2024-11-24 04:40:08',NULL),(43649,109,'active','2024-11-24 04:40:13',NULL),(43650,109,'active','2024-11-24 04:40:18',NULL),(43651,109,'active','2024-11-24 04:40:24',NULL),(43652,109,'active','2024-11-24 04:40:29',NULL),(43653,109,'active','2024-11-24 04:40:34',NULL),(43654,109,'active','2024-11-24 04:40:39',NULL),(43655,109,'active','2024-11-24 04:40:44',NULL),(43656,109,'active','2024-11-24 04:40:49',NULL),(43657,109,'active','2024-11-24 04:40:54',NULL),(43658,109,'active','2024-11-24 04:40:59',NULL),(43659,109,'active','2024-11-24 04:41:04',NULL),(43660,109,'active','2024-11-24 04:41:09',NULL),(43661,109,'active','2024-11-24 04:41:16',NULL),(43662,109,'active','2024-11-24 04:41:21',NULL),(43663,109,'active','2024-11-24 04:41:29',NULL),(43664,109,'active','2024-11-24 04:41:39',NULL),(43665,109,'active','2024-11-24 04:41:49',NULL),(43666,109,'active','2024-11-24 04:41:58',NULL),(43667,109,'active','2024-11-24 04:42:04',NULL),(43668,109,'active','2024-11-24 04:42:10',NULL),(43669,109,'active','2024-11-24 04:42:21',NULL),(43670,109,'active','2024-11-24 04:42:26',NULL),(43671,109,'active','2024-11-24 04:42:31',NULL),(43672,109,'active','2024-11-24 04:42:36',NULL),(43673,109,'active','2024-11-24 04:42:41',NULL),(43674,109,'active','2024-11-24 04:42:46',NULL),(43675,109,'active','2024-11-24 04:42:53',NULL),(43676,109,'active','2024-11-24 04:42:58',NULL),(43677,109,'active','2024-11-24 04:43:03',NULL),(43678,109,'active','2024-11-24 04:43:08',NULL),(43679,109,'active','2024-11-24 04:43:13',NULL),(43680,109,'active','2024-11-24 04:43:18',NULL),(43681,109,'active','2024-11-24 04:43:23',NULL),(43682,109,'active','2024-11-24 04:43:28',NULL),(43683,109,'active','2024-11-24 04:43:33',NULL),(43684,109,'active','2024-11-24 04:43:38',NULL),(43685,109,'active','2024-11-24 04:43:43',NULL),(43686,109,'active','2024-11-24 04:43:48',NULL),(43687,109,'active','2024-11-24 04:43:53',NULL),(43688,109,'active','2024-11-24 04:44:00',NULL),(43689,109,'active','2024-11-24 04:44:58',NULL),(43690,109,'active','2024-11-24 04:45:03',NULL),(43691,109,'active','2024-11-24 04:45:08',NULL),(43692,109,'active','2024-11-24 04:45:14',NULL),(43693,109,'active','2024-11-24 04:45:19',NULL),(43694,109,'active','2024-11-24 04:45:24',NULL),(43695,109,'active','2024-11-24 04:45:30',NULL),(43696,109,'active','2024-11-24 04:45:36',NULL),(43697,109,'active','2024-11-24 04:45:43',NULL),(43698,109,'active','2024-11-24 04:45:50',NULL),(43699,109,'active','2024-11-24 04:45:56',NULL),(43700,109,'active','2024-11-24 04:46:03',NULL),(43701,109,'active','2024-11-24 04:46:13',NULL),(43702,109,'active','2024-11-24 04:46:22',NULL),(43703,109,'active','2024-11-24 04:46:31',NULL),(43704,109,'active','2024-11-24 04:46:39',NULL),(43705,109,'active','2024-11-24 04:46:47',NULL),(43706,109,'active','2024-11-24 04:46:56',NULL),(43707,109,'active','2024-11-24 04:47:01',NULL),(43708,109,'active','2024-11-24 04:47:07',NULL),(43709,109,'active','2024-11-24 04:47:17',NULL),(43710,109,'active','2024-11-24 04:47:45',NULL),(43711,109,'active','2024-11-24 04:47:52',NULL),(43712,109,'active','2024-11-24 04:48:00',NULL),(43713,109,'active','2024-11-24 04:48:11',NULL),(43714,109,'active','2024-11-24 04:48:16',NULL),(43715,109,'active','2024-11-24 04:48:25',NULL),(43716,109,'active','2024-11-24 04:48:33',NULL),(43717,109,'active','2024-11-24 04:48:40',NULL),(43718,109,'active','2024-11-24 04:48:46',NULL),(43719,109,'active','2024-11-24 04:48:52',NULL),(43720,109,'active','2024-11-24 04:49:03',NULL),(43721,109,'active','2024-11-24 04:49:15',NULL),(43722,109,'active','2024-11-24 04:49:23',NULL),(43723,109,'active','2024-11-24 04:49:30',NULL),(43724,109,'active','2024-11-24 04:49:37',NULL),(43725,109,'active','2024-11-24 04:49:49',NULL),(43726,109,'active','2024-11-24 04:49:58',NULL),(43727,109,'active','2024-11-24 04:50:04',NULL),(43728,109,'active','2024-11-24 04:50:09',NULL),(43729,109,'active','2024-11-24 04:50:14',NULL),(43730,109,'active','2024-11-24 04:50:19',NULL),(43731,109,'active','2024-11-24 04:50:24',NULL),(43732,109,'active','2024-11-24 04:50:29',NULL),(43733,109,'active','2024-11-24 04:50:34',NULL),(43734,109,'active','2024-11-24 04:50:39',NULL),(43735,109,'active','2024-11-24 04:50:44',NULL),(43736,109,'active','2024-11-24 04:50:49',NULL),(43737,109,'active','2024-11-24 04:50:54',NULL),(43738,109,'active','2024-11-24 04:51:01',NULL),(43739,109,'active','2024-11-24 04:51:06',NULL),(43740,109,'active','2024-11-24 04:51:11',NULL),(43741,109,'active','2024-11-24 04:51:16',NULL),(43742,109,'active','2024-11-24 04:51:21',NULL),(43743,109,'active','2024-11-24 04:51:26',NULL),(43744,109,'active','2024-11-24 04:51:31',NULL),(43745,109,'active','2024-11-24 04:51:36',NULL),(43746,109,'active','2024-11-24 04:51:41',NULL),(43747,109,'active','2024-11-24 04:51:46',NULL),(43748,109,'active','2024-11-24 04:51:51',NULL),(43749,109,'active','2024-11-24 04:51:56',NULL),(43750,109,'active','2024-11-24 04:52:01',NULL),(43751,109,'active','2024-11-24 04:52:08',NULL),(43752,109,'active','2024-11-24 04:52:11',NULL),(43753,109,'active','2024-11-24 04:52:16',NULL),(43754,109,'active','2024-11-24 04:52:21',NULL),(43755,109,'active','2024-11-24 04:52:28',NULL),(43756,109,'active','2024-11-24 04:52:35',NULL),(43757,109,'active','2024-11-24 04:52:46',NULL),(43758,109,'active','2024-11-24 04:53:00',NULL),(43759,109,'active','2024-11-24 04:53:12',NULL),(43760,109,'active','2024-11-24 04:53:24',NULL),(43761,109,'active','2024-11-24 04:53:36',NULL),(43762,109,'active','2024-11-24 04:53:46',NULL),(43763,109,'active','2024-11-24 04:54:01',NULL),(43764,109,'active','2024-11-24 05:11:17',NULL),(43765,109,'active','2024-11-24 05:11:30',NULL),(43766,109,'active','2024-11-24 05:11:43',NULL),(43767,109,'active','2024-11-24 05:11:55',NULL),(43768,109,'active','2024-11-24 05:12:08',NULL),(43769,109,'active','2024-11-24 05:12:25',NULL),(43770,109,'active','2024-11-24 05:12:40',NULL),(43771,109,'active','2024-11-24 05:12:53',NULL),(43772,109,'active','2024-11-24 05:12:58',NULL),(43773,109,'active','2024-11-24 05:13:03',NULL),(43774,109,'active','2024-11-24 05:13:08',NULL),(43775,109,'active','2024-11-24 05:13:20',NULL),(43776,109,'active','2024-11-24 05:13:26',NULL),(43777,109,'active','2024-11-24 05:13:31',NULL),(43778,109,'active','2024-11-24 05:13:36',NULL),(43779,109,'active','2024-11-24 05:13:41',NULL),(43780,109,'active','2024-11-24 05:13:46',NULL),(43781,109,'active','2024-11-24 05:13:51',NULL),(43782,109,'active','2024-11-24 05:13:56',NULL),(43783,109,'active','2024-11-24 05:14:03',NULL),(43784,109,'active','2024-11-24 05:14:09',NULL),(43785,109,'active','2024-11-24 05:14:15',NULL),(43786,109,'active','2024-11-24 05:14:21',NULL),(43787,109,'active','2024-11-24 05:14:35',NULL),(43788,109,'active','2024-11-24 05:14:40',NULL),(43789,109,'active','2024-11-24 05:14:45',NULL),(43790,109,'active','2024-11-24 05:14:50',NULL),(43791,109,'active','2024-11-24 05:14:55',NULL),(43792,109,'active','2024-11-24 05:15:01',NULL),(43793,109,'active','2024-11-24 05:15:07',NULL),(43794,109,'active','2024-11-24 05:15:12',NULL),(43795,109,'active','2024-11-24 05:15:17',NULL),(43796,109,'active','2024-11-24 05:15:22',NULL),(43797,109,'active','2024-11-24 05:15:27',NULL),(43798,109,'active','2024-11-24 05:15:32',NULL),(43799,109,'active','2024-11-24 05:15:37',NULL),(43800,109,'active','2024-11-24 05:15:44',NULL),(43801,109,'active','2024-11-24 05:15:51',NULL),(43802,109,'active','2024-11-24 05:15:56',NULL),(43803,109,'active','2024-11-24 05:16:01',NULL),(43804,109,'active','2024-11-24 05:16:06',NULL),(43805,109,'active','2024-11-24 05:16:11',NULL),(43806,109,'active','2024-11-24 05:16:16',NULL),(43807,109,'active','2024-11-24 05:16:21',NULL),(43808,109,'active','2024-11-24 05:16:27',NULL),(43809,109,'active','2024-11-24 05:16:34',NULL),(43810,109,'active','2024-11-24 05:17:09',NULL),(43811,109,'active','2024-11-24 05:18:58',NULL),(43812,109,'active','2024-11-24 05:19:22',NULL),(43813,109,'active','2024-11-24 05:19:38',NULL),(43814,109,'active','2024-11-24 05:19:46',NULL),(43815,109,'active','2024-11-24 05:19:58',NULL),(43816,109,'active','2024-11-24 05:20:19',NULL),(43817,109,'active','2024-11-24 05:20:26',NULL),(43818,109,'active','2024-11-24 05:20:31',NULL),(43819,109,'active','2024-11-24 05:20:36',NULL),(43820,109,'active','2024-11-24 05:20:41',NULL),(43821,109,'active','2024-11-24 05:20:46',NULL),(43822,109,'active','2024-11-24 05:20:51',NULL),(43823,109,'active','2024-11-24 05:20:56',NULL),(43824,109,'active','2024-11-24 05:21:02',NULL),(43825,109,'active','2024-11-24 05:21:13',NULL),(43826,109,'active','2024-11-24 05:21:21',NULL),(43827,109,'active','2024-11-24 05:21:34',NULL),(43828,109,'active','2024-11-24 05:21:40',NULL),(43829,109,'active','2024-11-24 05:21:47',NULL),(43830,109,'active','2024-11-24 05:23:48',NULL),(43831,109,'active','2024-11-24 05:23:55',NULL),(43832,109,'active','2024-11-24 05:24:00',NULL),(43833,109,'active','2024-11-24 05:24:05',NULL),(43834,109,'active','2024-11-24 05:24:10',NULL),(43835,109,'active','2024-11-24 05:24:22',NULL),(43836,109,'active','2024-11-24 05:24:27',NULL),(43837,109,'active','2024-11-24 05:24:33',NULL),(43838,109,'active','2024-11-24 05:24:39',NULL),(43839,109,'active','2024-11-24 05:24:48',NULL),(43840,109,'active','2024-11-24 05:25:01',NULL),(43841,109,'active','2024-11-24 05:25:11',NULL),(43842,109,'active','2024-11-24 05:25:27',NULL),(43843,109,'active','2024-11-24 05:25:36',NULL),(43844,109,'active','2024-11-24 05:25:41',NULL),(43845,109,'active','2024-11-24 05:25:46',NULL),(43846,109,'active','2024-11-24 05:25:51',NULL),(43847,109,'active','2024-11-24 05:25:56',NULL),(43848,109,'active','2024-11-24 05:26:01',NULL),(43849,109,'active','2024-11-24 05:26:06',NULL),(43850,109,'active','2024-11-24 05:26:11',NULL),(43851,109,'active','2024-11-24 05:26:16',NULL),(43852,109,'active','2024-11-24 05:26:21',NULL),(43853,109,'active','2024-11-24 05:26:26',NULL),(43854,109,'active','2024-11-24 05:26:33',NULL),(43855,109,'active','2024-11-24 05:26:38',NULL),(43856,109,'active','2024-11-24 05:26:43',NULL),(43857,109,'active','2024-11-24 05:26:48',NULL),(43858,109,'active','2024-11-24 05:26:56',NULL),(43859,109,'active','2024-11-24 05:27:06',NULL),(43860,109,'active','2024-11-24 05:27:11',NULL),(43861,109,'active','2024-11-24 05:27:16',NULL),(43862,109,'active','2024-11-24 05:27:21',NULL),(43863,109,'active','2024-11-24 05:27:26',NULL),(43864,109,'active','2024-11-24 05:27:33',NULL),(43865,109,'active','2024-11-24 05:27:39',NULL),(43866,109,'active','2024-11-24 05:27:44',NULL),(43867,109,'active','2024-11-24 05:27:49',NULL),(43868,109,'active','2024-11-24 05:27:54',NULL),(43869,109,'active','2024-11-24 05:27:59',NULL),(43870,109,'active','2024-11-24 05:28:04',NULL),(43871,109,'active','2024-11-24 05:28:11',NULL),(43872,109,'active','2024-11-24 05:28:19',NULL),(43873,109,'active','2024-11-24 05:28:24',NULL),(43874,109,'active','2024-11-24 05:28:29',NULL),(43875,109,'active','2024-11-24 05:28:36',NULL),(43876,109,'active','2024-11-24 05:28:41',NULL),(43877,109,'active','2024-11-24 05:28:46',NULL),(43878,109,'active','2024-11-24 05:28:51',NULL),(43879,109,'active','2024-11-24 05:28:56',NULL),(43880,109,'active','2024-11-24 05:29:01',NULL),(43881,109,'active','2024-11-24 05:29:06',NULL),(43882,109,'active','2024-11-24 05:29:11',NULL),(43883,109,'active','2024-11-24 05:29:19',NULL),(43884,109,'active','2024-11-24 05:29:24',NULL),(43885,109,'active','2024-11-24 05:29:29',NULL),(43886,109,'active','2024-11-24 05:29:34',NULL),(43887,109,'active','2024-11-24 05:29:39',NULL),(43888,109,'active','2024-11-24 05:29:44',NULL),(43889,109,'active','2024-11-24 05:29:49',NULL),(43890,109,'active','2024-11-24 05:29:54',NULL),(43891,109,'active','2024-11-24 05:29:59',NULL),(43892,109,'active','2024-11-24 05:30:04',NULL),(43893,109,'active','2024-11-24 05:30:09',NULL),(43894,109,'active','2024-11-24 05:30:14',NULL),(43895,109,'active','2024-11-24 05:30:21',NULL),(43896,109,'active','2024-11-24 05:34:15',NULL),(43897,109,'active','2024-11-24 05:34:23',NULL),(43898,109,'active','2024-11-24 05:34:31',NULL),(43899,109,'active','2024-11-24 05:36:49',NULL),(43900,109,'active','2024-11-24 05:36:55',NULL),(43901,109,'active','2024-11-24 05:37:00',NULL),(43902,109,'active','2024-11-24 05:37:08',NULL),(43903,109,'active','2024-11-24 05:37:15',NULL),(43904,109,'active','2024-11-24 05:37:20',NULL),(43905,109,'active','2024-11-24 05:37:25',NULL),(43906,109,'active','2024-11-24 05:37:30',NULL),(43907,109,'active','2024-11-24 05:37:35',NULL),(43908,109,'active','2024-11-24 05:37:41',NULL),(43909,109,'active','2024-11-24 05:37:45',NULL),(43910,109,'active','2024-11-24 05:37:50',NULL),(43911,109,'active','2024-11-24 05:37:55',NULL),(43912,109,'active','2024-11-24 05:38:00',NULL),(43913,109,'active','2024-11-24 05:38:05',NULL),(43914,109,'active','2024-11-24 05:38:13',NULL),(43915,109,'active','2024-11-24 05:38:18',NULL),(43916,109,'active','2024-11-24 05:38:23',NULL),(43917,109,'active','2024-11-24 05:38:28',NULL),(43918,109,'active','2024-11-24 05:38:33',NULL),(43919,109,'active','2024-11-24 05:38:38',NULL),(43920,109,'active','2024-11-24 05:38:43',NULL),(43921,109,'active','2024-11-24 05:38:49',NULL),(43922,109,'active','2024-11-24 05:39:07',NULL),(43923,109,'active','2024-11-24 05:39:29',NULL),(43924,109,'active','2024-11-24 05:39:49',NULL),(43925,109,'active','2024-11-24 05:39:58',NULL),(43926,109,'active','2024-11-24 05:40:06',NULL),(43927,109,'active','2024-11-24 05:40:14',NULL),(43928,109,'active','2024-11-24 05:40:22',NULL),(43929,109,'active','2024-11-24 05:40:31',NULL),(43930,109,'active','2024-11-24 05:40:58',NULL),(43931,109,'active','2024-11-24 05:41:13',NULL),(43932,109,'active','2024-11-24 05:41:25',NULL),(43933,109,'active','2024-11-24 05:41:51',NULL),(43934,109,'active','2024-11-24 05:42:32',NULL),(43935,109,'active','2024-11-24 05:42:44',NULL),(43936,109,'active','2024-11-24 05:43:17',NULL),(43937,109,'active','2024-11-24 05:47:08',NULL),(43938,109,'active','2024-11-24 05:47:20',NULL),(43939,109,'active','2024-11-24 05:47:40',NULL),(43940,109,'active','2024-11-24 05:48:09',NULL),(43941,109,'active','2024-11-24 05:48:47',NULL),(43942,109,'active','2024-11-24 05:49:00',NULL),(43943,109,'active','2024-11-24 05:49:12',NULL),(43944,109,'active','2024-11-24 05:49:23',NULL),(43945,109,'active','2024-11-24 05:49:35',NULL),(43946,109,'active','2024-11-24 05:49:45',NULL),(43947,109,'active','2024-11-24 05:49:55',NULL),(43948,109,'active','2024-11-24 05:50:06',NULL),(43949,109,'active','2024-11-24 05:50:33',NULL),(43950,109,'active','2024-11-24 05:50:48',NULL),(43951,109,'active','2024-11-24 05:51:05',NULL),(43952,109,'active','2024-11-24 05:52:40',NULL),(43953,109,'active','2024-11-24 05:52:57',NULL),(43954,109,'active','2024-11-24 05:53:07',NULL),(43955,109,'active','2024-11-24 05:53:24',NULL),(43956,109,'active','2024-11-24 05:53:44',NULL),(43957,109,'active','2024-11-24 05:54:02',NULL),(43958,109,'active','2024-11-24 05:54:15',NULL),(43959,109,'active','2024-11-24 05:54:30',NULL),(43960,109,'active','2024-11-24 05:54:43',NULL),(43961,109,'active','2024-11-24 05:55:10',NULL),(43962,109,'active','2024-11-24 05:55:26',NULL),(43963,109,'active','2024-11-24 05:55:43',NULL),(43964,109,'active','2024-11-24 05:55:57',NULL),(43965,109,'active','2024-11-24 05:56:16',NULL),(43966,109,'active','2024-11-24 05:56:27',NULL),(43967,109,'active','2024-11-24 05:56:41',NULL),(43968,109,'active','2024-11-24 05:56:54',NULL),(43969,109,'active','2024-11-24 05:57:09',NULL),(43970,109,'active','2024-11-24 05:57:22',NULL),(43971,109,'active','2024-11-24 05:57:43',NULL),(43972,109,'active','2024-11-24 05:57:58',NULL),(43973,109,'active','2024-11-24 05:58:18',NULL),(43974,109,'active','2024-11-24 05:58:35',NULL),(43975,109,'active','2024-11-24 05:58:58',NULL),(43976,109,'active','2024-11-24 05:59:56',NULL),(43977,109,'active','2024-11-24 05:59:56',NULL),(43978,109,'active','2024-11-24 05:59:56',NULL),(43979,109,'active','2024-11-24 05:59:57',NULL),(43980,109,'active','2024-11-24 06:00:01',NULL),(43981,109,'active','2024-11-24 06:00:06',NULL),(43982,109,'active','2024-11-24 06:00:11',NULL),(43983,109,'active','2024-11-24 06:00:16',NULL),(43984,109,'active','2024-11-24 06:00:21',NULL),(43985,109,'active','2024-11-24 06:00:26',NULL),(43986,109,'active','2024-11-24 06:00:31',NULL),(43987,109,'active','2024-11-24 06:00:36',NULL),(43988,109,'active','2024-11-24 06:00:42',NULL),(43989,109,'active','2024-11-24 06:00:49',NULL),(43990,109,'active','2024-11-24 06:00:57',NULL),(43991,109,'active','2024-11-24 06:01:03',NULL),(43992,109,'active','2024-11-24 06:01:09',NULL),(43993,109,'active','2024-11-24 06:01:15',NULL),(43994,109,'active','2024-11-24 06:01:21',NULL),(43995,109,'active','2024-11-24 06:01:26',NULL),(43996,109,'active','2024-11-24 06:01:31',NULL),(43997,109,'active','2024-11-24 06:01:38',NULL),(43998,109,'active','2024-11-24 06:01:46',NULL),(43999,109,'active','2024-11-24 06:01:52',NULL),(44000,109,'active','2024-11-24 06:01:57',NULL),(44001,109,'active','2024-11-24 06:02:02',NULL),(44002,109,'active','2024-11-24 06:02:07',NULL),(44003,109,'active','2024-11-24 06:02:12',NULL),(44004,109,'active','2024-11-24 06:02:17',NULL),(44005,109,'active','2024-11-24 06:02:22',NULL),(44006,109,'active','2024-11-24 06:02:27',NULL),(44007,109,'active','2024-11-24 06:02:32',NULL),(44008,109,'active','2024-11-24 06:02:37',NULL),(44009,109,'active','2024-11-24 06:02:42',NULL),(44010,109,'active','2024-11-24 06:02:47',NULL),(44011,109,'active','2024-11-24 06:02:52',NULL),(44012,109,'active','2024-11-24 06:02:58',NULL),(44013,109,'active','2024-11-24 06:03:05',NULL),(44014,109,'active','2024-11-24 06:03:10',NULL),(44015,109,'active','2024-11-24 06:03:15',NULL),(44016,109,'active','2024-11-24 06:03:20',NULL),(44017,109,'active','2024-11-24 06:03:25',NULL),(44018,109,'active','2024-11-24 06:03:32',NULL),(44019,109,'active','2024-11-24 06:03:47',NULL),(44020,109,'active','2024-11-24 06:03:53',NULL),(44021,109,'active','2024-11-24 06:03:58',NULL),(44022,109,'active','2024-11-24 06:04:03',NULL),(44023,109,'active','2024-11-24 06:04:08',NULL),(44024,109,'active','2024-11-24 06:04:13',NULL),(44025,109,'active','2024-11-24 06:04:18',NULL),(44026,109,'active','2024-11-24 06:04:23',NULL),(44027,109,'active','2024-11-24 06:04:28',NULL),(44028,109,'active','2024-11-24 06:04:33',NULL),(44029,109,'active','2024-11-24 06:04:38',NULL),(44030,109,'active','2024-11-24 06:04:43',NULL),(44031,109,'active','2024-11-24 06:04:48',NULL),(44032,109,'active','2024-11-24 06:04:53',NULL),(44033,109,'active','2024-11-24 06:04:58',NULL),(44034,109,'active','2024-11-24 06:05:03',NULL),(44035,109,'active','2024-11-24 06:05:08',NULL),(44036,109,'active','2024-11-24 06:05:13',NULL),(44037,109,'active','2024-11-24 06:05:19',NULL),(44038,109,'active','2024-11-24 06:05:25',NULL),(44039,109,'active','2024-11-24 06:05:30',NULL),(44040,109,'active','2024-11-24 06:05:35',NULL),(44041,109,'active','2024-11-24 06:05:40',NULL),(44042,109,'active','2024-11-24 06:05:45',NULL),(44043,109,'active','2024-11-24 06:05:50',NULL),(44044,109,'active','2024-11-24 06:05:55',NULL),(44045,109,'active','2024-11-24 06:06:00',NULL),(44046,109,'active','2024-11-24 06:06:05',NULL),(44047,109,'active','2024-11-24 06:06:10',NULL),(44048,109,'active','2024-11-24 06:06:15',NULL),(44049,109,'active','2024-11-24 06:06:20',NULL),(44050,109,'active','2024-11-24 06:06:27',NULL),(44051,109,'active','2024-11-24 06:06:30',NULL),(44052,109,'active','2024-11-24 06:06:35',NULL),(44053,109,'active','2024-11-24 06:06:40',NULL),(44054,109,'active','2024-11-24 06:06:45',NULL),(44055,109,'active','2024-11-24 06:06:50',NULL),(44056,109,'active','2024-11-24 06:06:55',NULL),(44057,109,'active','2024-11-24 06:07:00',NULL),(44058,109,'active','2024-11-24 06:07:05',NULL),(44059,109,'active','2024-11-24 06:07:10',NULL),(44060,109,'active','2024-11-24 06:07:15',NULL),(44061,109,'active','2024-11-24 06:07:20',NULL),(44062,109,'active','2024-11-24 06:07:25',NULL),(44063,109,'active','2024-11-24 06:07:30',NULL),(44064,109,'active','2024-11-24 06:07:35',NULL),(44065,109,'active','2024-11-24 06:07:40',NULL),(44066,109,'active','2024-11-24 06:07:45',NULL),(44067,109,'active','2024-11-24 06:07:50',NULL),(44068,109,'active','2024-11-24 06:07:58',NULL),(44069,109,'active','2024-11-24 06:08:07',NULL),(44070,109,'active','2024-11-24 06:11:30',NULL),(44071,109,'active','2024-11-24 06:11:49',NULL),(44072,109,'active','2024-11-24 06:12:07',NULL),(44073,109,'active','2024-11-24 06:12:24',NULL),(44074,109,'active','2024-11-24 06:12:41',NULL),(44075,109,'active','2024-11-24 06:12:58',NULL),(44076,109,'active','2024-11-24 06:13:15',NULL),(44077,109,'active','2024-11-24 06:13:32',NULL),(44078,338,'active','2024-11-24 07:58:46',NULL),(44079,338,'active','2024-11-24 07:59:00',NULL),(44080,338,'active','2024-11-24 07:59:01',NULL),(44081,338,'active','2024-11-24 07:59:24',NULL),(44082,338,'active','2024-11-24 07:59:26','2024-11-24 07:59:26'),(44083,338,'active','2024-11-24 07:59:30',NULL),(44084,338,'active','2024-11-24 07:59:31',NULL),(44085,338,'active','2024-11-24 07:59:40',NULL),(44086,338,'active','2024-11-24 07:59:41',NULL),(44087,338,'active','2024-11-24 08:19:47',NULL),(44088,338,'active','2024-11-24 08:20:05',NULL),(44089,338,'active','2024-11-24 08:20:37',NULL),(44090,338,'active','2024-11-24 13:50:36',NULL),(44091,338,'active','2024-11-24 13:50:49',NULL),(44092,338,'active','2024-11-24 13:50:59',NULL),(44093,338,'active','2024-11-24 13:51:10',NULL),(44094,338,'active','2024-11-24 13:51:21',NULL),(44095,338,'active','2024-11-24 13:51:29',NULL),(44096,338,'active','2024-11-24 13:51:39',NULL),(44097,338,'active','2024-11-24 13:52:14',NULL),(44098,338,'active','2024-11-24 13:52:25',NULL),(44099,338,'active','2024-11-24 13:52:35',NULL),(44100,338,'active','2024-11-24 13:52:42',NULL),(44101,338,'active','2024-11-24 13:52:50',NULL),(44102,338,'active','2024-11-24 13:52:59',NULL),(44103,338,'active','2024-11-24 13:53:16',NULL),(44104,338,'active','2024-11-24 13:53:31',NULL),(44105,338,'active','2024-11-24 13:53:47',NULL),(44106,338,'active','2024-11-24 13:53:59',NULL),(44107,338,'active','2024-11-24 13:54:16',NULL),(44108,338,'active','2024-11-24 13:54:26',NULL),(44109,338,'active','2024-11-24 13:54:46',NULL),(44110,338,'active','2024-11-24 13:55:11',NULL),(44111,338,'active','2024-11-24 13:55:41',NULL),(44112,338,'active','2024-11-24 13:55:55',NULL),(44113,338,'active','2024-11-24 13:56:02',NULL),(44114,338,'active','2024-11-24 13:56:08',NULL),(44115,338,'active','2024-11-24 13:56:14',NULL),(44116,338,'active','2024-11-24 13:56:21',NULL),(44117,338,'active','2024-11-24 13:56:27',NULL),(44118,338,'active','2024-11-24 13:56:34',NULL),(44119,338,'active','2024-11-24 13:56:45',NULL),(44120,338,'active','2024-11-24 13:56:57',NULL),(44121,338,'active','2024-11-24 13:57:07',NULL),(44122,338,'active','2024-11-24 13:57:29',NULL),(44123,338,'active','2024-11-24 13:57:44',NULL),(44124,338,'active','2024-11-24 14:37:12',NULL),(44125,338,'active','2024-11-24 14:37:23',NULL),(44126,338,'active','2024-11-24 14:37:32',NULL),(44127,338,'active','2024-11-24 14:37:40',NULL),(44128,338,'active','2024-11-24 14:37:48',NULL),(44129,338,'active','2024-11-24 14:37:57',NULL),(44130,338,'active','2024-11-24 14:38:05',NULL),(44131,338,'active','2024-11-24 14:38:14',NULL),(44132,338,'active','2024-11-24 14:38:27',NULL),(44133,338,'active','2024-11-24 14:38:38',NULL),(44134,338,'active','2024-11-24 14:38:47',NULL),(44135,338,'active','2024-11-24 14:38:55',NULL),(44136,338,'active','2024-11-24 14:39:04',NULL),(44137,338,'active','2024-11-24 14:39:12',NULL),(44138,338,'active','2024-11-24 14:39:19',NULL),(44139,338,'active','2024-11-24 14:39:26',NULL),(44140,338,'active','2024-11-24 14:39:33',NULL),(44141,338,'active','2024-11-24 14:39:41',NULL),(44142,338,'active','2024-11-24 14:39:58',NULL),(44143,338,'active','2024-11-24 14:40:16',NULL),(44144,338,'active','2024-11-24 14:43:07',NULL),(44145,338,'active','2024-11-24 14:43:19',NULL),(44146,338,'active','2024-11-24 14:43:29',NULL),(44147,338,'active','2024-11-24 14:43:39',NULL),(44148,338,'active','2024-11-24 14:43:52',NULL),(44149,338,'active','2024-11-24 14:44:04',NULL),(44150,338,'active','2024-11-24 14:44:14',NULL),(44151,338,'active','2024-11-24 14:44:41',NULL),(44152,338,'active','2024-11-24 14:45:04',NULL),(44153,338,'active','2024-11-24 14:45:46',NULL),(44154,338,'active','2024-11-24 14:45:55',NULL),(44155,338,'active','2024-11-24 14:46:07',NULL),(44156,338,'active','2024-11-24 14:46:16',NULL),(44157,338,'active','2024-11-24 14:46:26',NULL),(44158,338,'active','2024-11-24 14:46:36',NULL),(44159,338,'active','2024-11-24 14:46:46',NULL),(44160,338,'active','2024-11-24 14:46:56',NULL),(44161,338,'active','2024-11-24 14:47:14',NULL),(44162,338,'active','2024-11-24 14:47:24',NULL),(44163,338,'active','2024-11-24 14:47:34',NULL),(44164,338,'active','2024-11-24 14:47:46',NULL),(44165,338,'active','2024-11-24 14:47:59',NULL),(44166,338,'active','2024-11-24 14:48:12',NULL),(44167,338,'active','2024-11-24 14:48:22',NULL),(44168,338,'active','2024-11-24 14:48:39',NULL),(44169,338,'active','2024-11-24 14:48:51',NULL),(44170,338,'active','2024-11-24 14:48:59',NULL),(44171,338,'active','2024-11-24 14:50:18',NULL),(44172,338,'active','2024-11-24 14:50:26',NULL),(44173,338,'active','2024-11-24 14:50:34',NULL),(44174,338,'active','2024-11-24 14:50:43',NULL),(44175,338,'active','2024-11-24 14:51:19',NULL),(44176,338,'active','2024-11-24 14:51:28',NULL),(44177,338,'active','2024-11-24 14:51:38',NULL),(44178,338,'active','2024-11-24 14:51:49',NULL),(44179,338,'active','2024-11-24 14:51:59',NULL),(44180,338,'active','2024-11-24 14:52:08',NULL),(44181,338,'active','2024-11-24 14:52:15',NULL),(44182,338,'active','2024-11-24 14:52:22',NULL),(44183,338,'active','2024-11-24 14:52:29',NULL),(44184,338,'active','2024-11-24 14:52:40',NULL),(44185,338,'active','2024-11-24 14:52:51',NULL),(44186,338,'active','2024-11-24 14:53:02',NULL),(44187,338,'active','2024-11-24 14:53:11',NULL),(44188,338,'active','2024-11-24 14:53:20',NULL),(44189,338,'active','2024-11-24 14:53:39',NULL),(44190,338,'active','2024-11-24 14:55:06',NULL),(44191,338,'active','2024-11-24 14:55:28',NULL),(44192,338,'active','2024-11-24 14:55:43',NULL),(44193,338,'active','2024-11-24 14:55:54',NULL),(44194,338,'active','2024-11-24 14:56:05',NULL),(44195,338,'active','2024-11-24 14:56:17',NULL),(44196,338,'active','2024-11-24 14:56:26',NULL),(44197,338,'active','2024-11-24 14:56:35',NULL),(44198,338,'active','2024-11-24 14:56:44',NULL),(44199,338,'active','2024-11-24 15:20:09',NULL),(44200,288,'active','2024-11-25 19:03:20','2024-11-25 19:03:24'),(44201,288,'active','2024-11-25 19:03:50',NULL),(44202,288,'active','2024-11-25 19:03:54',NULL),(44203,288,'active','2024-11-25 19:08:56',NULL),(44204,288,'active','2024-11-25 19:13:56',NULL),(44205,288,'active','2024-11-25 19:14:17',NULL),(44206,360,'active','2024-11-27 06:16:13',NULL),(44207,231,'active','2024-11-28 09:14:56',NULL),(44208,89,'active','2024-11-28 09:26:37',NULL),(44209,89,'active','2024-11-28 09:26:46',NULL),(44210,89,'active','2024-11-30 07:16:49',NULL),(44211,89,'active','2024-11-30 07:16:54',NULL),(44212,89,'active','2024-11-30 07:17:07',NULL),(44213,89,'active','2024-11-30 07:17:29',NULL),(44214,89,'active','2024-11-30 07:17:46',NULL),(44215,89,'active','2024-11-30 07:17:59',NULL),(44216,400,'active','2024-12-02 04:10:59',NULL),(44217,460,'active','2024-12-02 08:54:00',NULL),(44218,460,'active','2024-12-02 08:54:01',NULL),(44219,460,'active','2024-12-02 08:54:13',NULL),(44220,460,'active','2024-12-02 08:54:15',NULL),(44221,288,'active','2024-12-02 17:17:38',NULL),(44222,68,'active','2024-12-03 19:52:57',NULL),(44223,290,'active','2024-12-04 09:08:37',NULL),(44224,290,'active','2024-12-04 09:08:42',NULL),(44225,290,'active','2024-12-04 09:08:45',NULL),(44226,290,'active','2024-12-04 10:34:23',NULL),(44227,290,'active','2024-12-04 10:36:03',NULL),(44228,651,'active','2024-12-05 15:07:23',NULL),(44229,651,'active','2024-12-05 15:07:28',NULL),(44230,231,'active','2024-12-06 07:38:23','2024-12-06 07:38:35'),(44231,231,'active','2024-12-06 07:38:37',NULL),(44232,231,'active','2024-12-06 07:38:39',NULL),(44233,183,'active','2024-12-07 05:43:12',NULL),(44234,157,'active','2024-12-07 06:37:27',NULL),(44235,157,'active','2024-12-07 06:37:29',NULL),(44236,157,'active','2024-12-07 14:12:06',NULL),(44237,157,'active','2024-12-07 14:12:07',NULL),(44238,231,'active','2024-12-08 07:48:12','2024-12-08 07:48:16'),(44239,231,'active','2024-12-08 07:48:18',NULL),(44240,231,'active','2024-12-08 07:48:24',NULL),(44241,183,'active','2024-12-10 07:59:51',NULL),(44242,183,'active','2024-12-10 07:59:53',NULL),(44243,479,'active','2024-12-10 20:11:50',NULL),(44244,479,'active','2024-12-10 20:11:54',NULL),(44245,479,'active','2024-12-10 20:12:07',NULL),(44246,479,'active','2024-12-10 20:12:10','2024-12-10 20:12:16'),(44247,231,'active','2024-12-11 09:10:29','2024-12-11 09:10:33'),(44248,231,'active','2024-12-11 09:10:37',NULL),(44249,231,'active','2024-12-11 09:10:40',NULL),(44250,157,'active','2024-12-12 05:17:57',NULL),(44251,157,'active','2024-12-12 05:18:02',NULL),(44252,71,'active','2024-12-12 16:24:06',NULL),(44253,174,'active','2024-12-13 14:52:33',NULL),(44254,231,'active','2024-12-14 12:13:48',NULL),(44255,157,'active','2024-12-15 05:17:55',NULL),(44256,157,'active','2024-12-15 05:18:00',NULL),(44257,231,'active','2024-12-15 07:45:35',NULL),(44258,157,'active','2024-12-15 09:01:22',NULL),(44259,157,'active','2024-12-15 09:01:23',NULL),(44260,157,'active','2024-12-15 09:22:20',NULL),(44261,157,'active','2024-12-15 09:22:21',NULL),(44262,459,'active','2024-12-15 14:04:55',NULL),(44263,459,'active','2024-12-15 14:05:00',NULL),(44264,459,'active','2024-12-15 14:05:33',NULL),(44265,459,'active','2024-12-15 14:05:35',NULL),(44266,241,'active','2024-12-16 10:44:24',NULL),(44267,241,'active','2024-12-16 13:43:39',NULL),(44268,241,'active','2024-12-16 13:43:40',NULL),(44269,241,'active','2024-12-16 13:44:36',NULL),(44270,241,'active','2024-12-16 13:44:48',NULL),(44271,241,'active','2024-12-16 13:44:57',NULL),(44272,241,'active','2024-12-16 13:45:03',NULL),(44273,241,'active','2024-12-16 13:45:09',NULL),(44274,241,'active','2024-12-16 13:45:15',NULL),(44275,241,'active','2024-12-16 13:45:25',NULL),(44276,241,'active','2024-12-16 13:45:41',NULL),(44277,241,'active','2024-12-16 13:46:08',NULL),(44278,241,'active','2024-12-16 13:46:20',NULL),(44279,241,'active','2024-12-16 13:47:00',NULL),(44280,241,'active','2024-12-16 13:47:45',NULL),(44281,241,'active','2024-12-16 13:48:13',NULL),(44282,241,'active','2024-12-16 13:48:30',NULL),(44283,241,'active','2024-12-16 13:48:42',NULL),(44284,241,'active','2024-12-16 13:48:54',NULL),(44285,241,'active','2024-12-16 13:49:06',NULL),(44286,241,'active','2024-12-16 13:49:20',NULL),(44287,241,'active','2024-12-16 13:49:27',NULL),(44288,241,'active','2024-12-16 13:49:33',NULL),(44289,241,'active','2024-12-16 13:49:38',NULL),(44290,241,'active','2024-12-16 13:49:43',NULL),(44291,241,'active','2024-12-16 13:49:48',NULL),(44292,241,'active','2024-12-16 13:49:53',NULL),(44293,241,'active','2024-12-16 13:49:58',NULL),(44294,241,'active','2024-12-16 13:50:03',NULL),(44295,241,'active','2024-12-16 13:50:08',NULL),(44296,241,'active','2024-12-16 13:50:13',NULL),(44297,241,'active','2024-12-16 13:50:18',NULL),(44298,241,'active','2024-12-16 13:50:24',NULL),(44299,241,'active','2024-12-16 13:50:30',NULL),(44300,241,'active','2024-12-16 13:50:36',NULL),(44301,241,'active','2024-12-16 13:50:42',NULL),(44302,241,'active','2024-12-16 13:50:48',NULL),(44303,241,'active','2024-12-16 13:50:55',NULL),(44304,241,'active','2024-12-16 13:51:02',NULL),(44305,241,'active','2024-12-16 13:51:09',NULL),(44306,241,'active','2024-12-16 13:51:18',NULL),(44307,241,'active','2024-12-16 13:51:27',NULL),(44308,241,'active','2024-12-16 13:51:31',NULL),(44309,241,'active','2024-12-16 13:51:36',NULL),(44310,241,'active','2024-12-16 13:51:41',NULL),(44311,241,'active','2024-12-16 13:51:48',NULL),(44312,241,'active','2024-12-16 13:52:13',NULL),(44313,241,'active','2024-12-16 13:52:21',NULL),(44314,241,'active','2024-12-16 13:52:28',NULL),(44315,241,'active','2024-12-16 13:52:34',NULL),(44316,241,'active','2024-12-16 13:52:40',NULL),(44317,241,'active','2024-12-16 13:52:48',NULL),(44318,241,'active','2024-12-16 13:53:13',NULL),(44319,241,'active','2024-12-16 13:53:20',NULL),(44320,241,'active','2024-12-16 13:53:27',NULL),(44321,241,'active','2024-12-16 13:53:38',NULL),(44322,241,'active','2024-12-16 13:54:11',NULL),(44323,241,'active','2024-12-16 13:55:58',NULL),(44324,241,'active','2024-12-16 14:01:28',NULL),(44325,241,'active','2024-12-16 14:02:00',NULL),(44326,241,'active','2024-12-16 14:02:12',NULL),(44327,241,'active','2024-12-16 14:02:39',NULL),(44328,241,'active','2024-12-16 14:04:15',NULL),(44329,241,'active','2024-12-16 14:04:30',NULL),(44330,241,'active','2024-12-16 14:06:42',NULL),(44331,241,'active','2024-12-16 14:06:51',NULL),(44332,241,'active','2024-12-16 14:08:37',NULL),(44333,241,'active','2024-12-16 14:09:10',NULL),(44334,241,'active','2024-12-16 14:09:15',NULL),(44335,241,'active','2024-12-16 14:09:26',NULL),(44336,241,'active','2024-12-16 14:09:35',NULL),(44337,241,'active','2024-12-16 14:09:39',NULL),(44338,241,'active','2024-12-16 14:09:44',NULL),(44339,241,'active','2024-12-16 14:09:51',NULL),(44340,241,'active','2024-12-16 14:09:55',NULL),(44341,241,'active','2024-12-16 14:10:01',NULL),(44342,241,'active','2024-12-16 14:10:05',NULL),(44343,241,'active','2024-12-16 14:10:12',NULL),(44344,241,'active','2024-12-16 14:10:19',NULL),(44345,241,'active','2024-12-16 14:10:22',NULL),(44346,241,'active','2024-12-16 14:10:27',NULL),(44347,241,'active','2024-12-16 14:10:32',NULL),(44348,241,'active','2024-12-16 14:10:38',NULL),(44349,241,'active','2024-12-16 14:10:47',NULL),(44350,241,'active','2024-12-16 14:11:00',NULL),(44351,241,'active','2024-12-16 14:11:12',NULL),(44352,241,'active','2024-12-16 14:11:22',NULL),(44353,241,'active','2024-12-16 14:11:28',NULL),(44354,241,'active','2024-12-16 14:11:33',NULL),(44355,241,'active','2024-12-16 14:11:38',NULL),(44356,241,'active','2024-12-16 14:11:43',NULL),(44357,241,'active','2024-12-16 14:11:48',NULL),(44358,241,'active','2024-12-16 14:11:53',NULL),(44359,241,'active','2024-12-16 14:11:58',NULL),(44360,241,'active','2024-12-16 14:12:03',NULL),(44361,241,'active','2024-12-16 14:12:08',NULL),(44362,241,'active','2024-12-16 14:12:24',NULL),(44363,241,'active','2024-12-16 14:12:44',NULL),(44364,241,'active','2024-12-16 14:13:04',NULL),(44365,241,'active','2024-12-16 14:13:22',NULL),(44366,241,'active','2024-12-16 14:13:42',NULL),(44367,241,'active','2024-12-16 14:13:53',NULL),(44368,241,'active','2024-12-16 14:14:00',NULL),(44369,241,'active','2024-12-16 14:14:06',NULL),(44370,241,'active','2024-12-16 14:14:14',NULL),(44371,241,'active','2024-12-16 14:14:20',NULL),(44372,241,'active','2024-12-16 14:14:25',NULL),(44373,241,'active','2024-12-16 14:14:30',NULL),(44374,241,'active','2024-12-16 14:14:35',NULL),(44375,241,'active','2024-12-16 14:14:40',NULL),(44376,241,'active','2024-12-16 14:14:45',NULL),(44377,241,'active','2024-12-16 14:14:50',NULL),(44378,241,'active','2024-12-16 14:14:57',NULL),(44379,241,'active','2024-12-16 14:15:31',NULL),(44380,241,'active','2024-12-16 14:15:38',NULL),(44381,241,'active','2024-12-16 14:15:45',NULL),(44382,241,'active','2024-12-16 14:16:11',NULL),(44383,241,'active','2024-12-16 14:16:19',NULL),(44384,241,'active','2024-12-16 14:16:26',NULL),(44385,241,'active','2024-12-16 14:16:53',NULL),(44386,241,'active','2024-12-16 14:18:02',NULL),(44387,241,'active','2024-12-16 14:18:10',NULL),(44388,241,'active','2024-12-16 14:18:17',NULL),(44389,241,'active','2024-12-16 14:18:24',NULL),(44390,241,'active','2024-12-16 14:18:32',NULL),(44391,241,'active','2024-12-16 14:18:38',NULL),(44392,241,'active','2024-12-16 14:18:44',NULL),(44393,241,'active','2024-12-16 14:18:50',NULL),(44394,241,'active','2024-12-16 14:18:56',NULL),(44395,241,'active','2024-12-16 14:19:02',NULL),(44396,241,'active','2024-12-16 14:19:08',NULL),(44397,241,'active','2024-12-16 14:19:14',NULL),(44398,241,'active','2024-12-16 14:19:20',NULL),(44399,241,'active','2024-12-16 14:19:26',NULL),(44400,241,'active','2024-12-16 14:19:33',NULL),(44401,241,'active','2024-12-16 14:20:11',NULL),(44402,241,'active','2024-12-16 14:20:21',NULL),(44403,241,'active','2024-12-16 14:20:31',NULL),(44404,241,'active','2024-12-16 14:21:08',NULL),(44405,241,'active','2024-12-16 14:27:57',NULL),(44406,241,'active','2024-12-16 14:32:42',NULL),(44407,241,'active','2024-12-16 14:40:41',NULL),(44408,241,'active','2024-12-16 14:40:50',NULL),(44409,241,'active','2024-12-16 14:41:12',NULL),(44410,241,'active','2024-12-16 14:41:21',NULL),(44411,241,'active','2024-12-16 14:41:35',NULL),(44412,241,'active','2024-12-16 14:41:43',NULL),(44413,241,'active','2024-12-16 14:41:53',NULL),(44414,241,'active','2024-12-16 14:42:00',NULL),(44415,241,'active','2024-12-16 14:42:08',NULL),(44416,241,'active','2024-12-16 14:42:15',NULL),(44417,241,'active','2024-12-16 14:42:23',NULL),(44418,241,'active','2024-12-16 14:42:30',NULL),(44419,241,'active','2024-12-16 14:42:42',NULL),(44420,241,'active','2024-12-16 14:43:02',NULL),(44421,241,'active','2024-12-16 14:43:06',NULL),(44422,241,'active','2024-12-16 14:43:24',NULL),(44423,241,'active','2024-12-16 14:43:47',NULL),(44424,241,'active','2024-12-16 14:43:58',NULL),(44425,241,'active','2024-12-16 14:44:16',NULL),(44426,241,'active','2024-12-16 14:44:31',NULL),(44427,241,'active','2024-12-16 14:44:48',NULL),(44428,241,'active','2024-12-16 14:45:04',NULL),(44429,241,'active','2024-12-16 14:45:18',NULL),(44430,241,'active','2024-12-16 14:45:35',NULL),(44431,241,'active','2024-12-16 14:45:46',NULL),(44432,241,'active','2024-12-16 14:45:54',NULL),(44433,241,'active','2024-12-16 14:46:54',NULL),(44434,241,'active','2024-12-16 14:47:00',NULL),(44435,241,'active','2024-12-16 14:47:07',NULL),(44436,241,'active','2024-12-16 14:47:14',NULL),(44437,241,'active','2024-12-16 14:47:21',NULL),(44438,241,'active','2024-12-16 14:47:29',NULL),(44439,241,'active','2024-12-16 14:47:35',NULL),(44440,241,'active','2024-12-16 14:47:41',NULL),(44441,241,'active','2024-12-16 14:47:47',NULL),(44442,241,'active','2024-12-16 14:47:58',NULL),(44443,241,'active','2024-12-16 14:48:09',NULL),(44444,241,'active','2024-12-16 14:48:18',NULL),(44445,241,'active','2024-12-16 14:48:30',NULL),(44446,241,'active','2024-12-16 14:48:44',NULL),(44447,241,'active','2024-12-16 14:48:51',NULL),(44448,241,'active','2024-12-16 14:48:57',NULL),(44449,241,'active','2024-12-16 14:49:03',NULL),(44450,241,'active','2024-12-16 14:49:09',NULL),(44451,241,'active','2024-12-16 14:49:15',NULL),(44452,241,'active','2024-12-16 14:49:22',NULL),(44453,241,'active','2024-12-16 14:54:47',NULL),(44454,241,'active','2024-12-16 14:58:41',NULL),(44455,241,'active','2024-12-16 14:59:38',NULL),(44456,241,'active','2024-12-16 14:59:47',NULL),(44457,241,'active','2024-12-16 14:59:56',NULL),(44458,241,'active','2024-12-16 15:00:48',NULL),(44459,241,'active','2024-12-16 15:00:55',NULL),(44460,241,'active','2024-12-16 15:01:04',NULL),(44461,241,'active','2024-12-16 15:01:17',NULL),(44462,241,'active','2024-12-16 15:02:29',NULL),(44463,241,'active','2024-12-16 15:02:36',NULL),(44464,241,'active','2024-12-16 15:02:44',NULL),(44465,241,'active','2024-12-16 15:02:51',NULL),(44466,241,'active','2024-12-16 15:02:56',NULL),(44467,241,'active','2024-12-16 15:03:01',NULL),(44468,241,'active','2024-12-16 15:03:06',NULL),(44469,241,'active','2024-12-16 15:03:11',NULL),(44470,241,'active','2024-12-16 15:03:16',NULL),(44471,241,'active','2024-12-16 15:03:21',NULL),(44472,241,'active','2024-12-16 15:03:28',NULL),(44473,241,'active','2024-12-16 15:03:31',NULL),(44474,241,'active','2024-12-16 15:03:36',NULL),(44475,241,'active','2024-12-16 15:03:41',NULL),(44476,241,'active','2024-12-16 15:03:47',NULL),(44477,241,'active','2024-12-16 15:03:54',NULL),(44478,241,'active','2024-12-16 15:04:22',NULL),(44479,241,'active','2024-12-16 15:04:39',NULL),(44480,241,'active','2024-12-16 15:04:51',NULL),(44481,241,'active','2024-12-16 15:05:02',NULL),(44482,241,'active','2024-12-16 15:05:15',NULL),(44483,241,'active','2024-12-16 15:05:24',NULL),(44484,241,'active','2024-12-16 15:05:33',NULL),(44485,241,'active','2024-12-16 15:05:43',NULL),(44486,241,'active','2024-12-16 15:05:56',NULL),(44487,241,'active','2024-12-16 15:06:06',NULL),(44488,241,'active','2024-12-16 15:06:13',NULL),(44489,241,'active','2024-12-16 15:06:22',NULL),(44490,241,'active','2024-12-16 15:06:34',NULL),(44491,241,'active','2024-12-16 15:13:24',NULL),(44492,241,'active','2024-12-16 15:13:35',NULL),(44493,241,'active','2024-12-16 15:13:45',NULL),(44494,241,'active','2024-12-16 15:13:56',NULL),(44495,241,'active','2024-12-16 15:14:19',NULL),(44496,241,'active','2024-12-16 15:14:29',NULL),(44497,241,'active','2024-12-16 15:14:43',NULL),(44498,241,'active','2024-12-16 15:14:58',NULL),(44499,241,'active','2024-12-16 15:15:06',NULL),(44500,241,'active','2024-12-16 15:15:14',NULL),(44501,241,'active','2024-12-16 15:15:23',NULL),(44502,241,'active','2024-12-16 15:15:32',NULL),(44503,241,'active','2024-12-16 15:15:42',NULL),(44504,241,'active','2024-12-16 15:15:52',NULL),(44505,241,'active','2024-12-16 15:16:00',NULL),(44506,241,'active','2024-12-16 15:16:08',NULL),(44507,241,'active','2024-12-16 15:16:15',NULL),(44508,241,'active','2024-12-16 15:16:29',NULL),(44509,241,'active','2024-12-16 15:16:47',NULL),(44510,241,'active','2024-12-16 15:17:10',NULL),(44511,241,'active','2024-12-16 15:17:32',NULL),(44512,241,'active','2024-12-16 15:17:42',NULL),(44513,241,'active','2024-12-16 15:17:47',NULL),(44514,241,'active','2024-12-16 15:17:53',NULL),(44515,241,'active','2024-12-16 15:18:14',NULL),(44516,241,'active','2024-12-16 15:18:42',NULL),(44517,241,'active','2024-12-16 15:20:07',NULL),(44518,241,'active','2024-12-16 15:23:46',NULL),(44519,241,'active','2024-12-16 15:27:05',NULL),(44520,241,'active','2024-12-16 15:27:35',NULL),(44521,241,'active','2024-12-16 15:29:05',NULL),(44522,241,'active','2024-12-16 15:29:24',NULL),(44523,241,'active','2024-12-16 15:29:40',NULL),(44524,241,'active','2024-12-16 15:29:48',NULL),(44525,241,'active','2024-12-16 15:29:55',NULL),(44526,241,'active','2024-12-16 15:30:06',NULL),(44527,241,'active','2024-12-16 15:30:09',NULL),(44528,241,'active','2024-12-16 15:30:17',NULL),(44529,241,'active','2024-12-16 15:30:31',NULL),(44530,241,'active','2024-12-16 15:30:46',NULL),(44531,241,'active','2024-12-16 15:30:58',NULL),(44532,241,'active','2024-12-16 15:31:08',NULL),(44533,241,'active','2024-12-16 15:31:24',NULL),(44534,241,'active','2024-12-16 15:31:57',NULL),(44535,241,'active','2024-12-16 15:32:38',NULL),(44536,241,'active','2024-12-16 15:33:23',NULL),(44537,241,'active','2024-12-16 15:41:21',NULL),(44538,241,'active','2024-12-16 15:41:33',NULL),(44539,241,'active','2024-12-16 15:42:30',NULL),(44540,241,'active','2024-12-16 15:44:58',NULL),(44541,241,'active','2024-12-16 15:45:17',NULL),(44542,241,'active','2024-12-16 15:47:16',NULL),(44543,241,'active','2024-12-16 15:47:25',NULL),(44544,241,'active','2024-12-16 15:47:31',NULL),(44545,241,'active','2024-12-16 15:47:38',NULL),(44546,241,'active','2024-12-16 15:47:47',NULL),(44547,241,'active','2024-12-16 15:47:56',NULL),(44548,241,'active','2024-12-16 15:48:11',NULL),(44549,241,'active','2024-12-16 15:49:25',NULL),(44550,241,'active','2024-12-16 15:50:24',NULL),(44551,241,'active','2024-12-16 15:50:29',NULL),(44552,241,'active','2024-12-16 15:50:34',NULL),(44553,241,'active','2024-12-16 15:50:39',NULL),(44554,241,'active','2024-12-16 15:50:49',NULL),(44555,241,'active','2024-12-16 15:50:54',NULL),(44556,241,'active','2024-12-16 15:50:59',NULL),(44557,241,'active','2024-12-16 15:51:04',NULL),(44558,241,'active','2024-12-16 15:57:56',NULL),(44559,241,'active','2024-12-16 15:58:11',NULL),(44560,241,'active','2024-12-16 15:58:39',NULL),(44561,241,'active','2024-12-16 15:58:48',NULL),(44562,241,'active','2024-12-16 15:58:57',NULL),(44563,241,'active','2024-12-16 15:59:05',NULL),(44564,241,'active','2024-12-16 15:59:17',NULL),(44565,241,'active','2024-12-16 15:59:30',NULL),(44566,241,'active','2024-12-16 15:59:33',NULL),(44567,241,'active','2024-12-16 15:59:41',NULL),(44568,241,'active','2024-12-16 15:59:49',NULL),(44569,241,'active','2024-12-16 15:59:56',NULL),(44570,241,'active','2024-12-16 16:00:02',NULL),(44571,241,'active','2024-12-16 16:00:08',NULL),(44572,241,'active','2024-12-16 16:00:14',NULL),(44573,241,'active','2024-12-16 16:00:20',NULL),(44574,241,'active','2024-12-16 16:00:26',NULL),(44575,241,'active','2024-12-16 16:00:32',NULL),(44576,241,'active','2024-12-16 16:00:43',NULL),(44577,241,'active','2024-12-16 16:00:44',NULL),(44578,241,'active','2024-12-16 16:00:50',NULL),(44579,241,'active','2024-12-16 16:00:57',NULL),(44580,241,'active','2024-12-16 16:03:38',NULL),(44581,241,'active','2024-12-16 16:05:45',NULL),(44582,241,'active','2024-12-16 16:06:36',NULL),(44583,241,'active','2024-12-16 16:12:30',NULL),(44584,241,'active','2024-12-16 16:13:01','2024-12-16 17:56:49'),(44585,241,'active','2024-12-16 17:57:08',NULL),(44586,241,'active','2024-12-16 17:57:13',NULL),(44587,241,'active','2024-12-16 17:57:22',NULL),(44588,157,'active','2024-12-18 13:53:29',NULL),(44589,157,'active','2024-12-18 13:53:35',NULL),(44590,479,'active','2024-12-19 10:50:47',NULL),(44591,479,'active','2024-12-19 10:50:51','2024-12-19 13:34:28'),(44592,288,'active','2024-12-19 14:14:34',NULL),(44593,157,'active','2024-12-20 12:56:10',NULL),(44594,157,'active','2024-12-20 12:56:14',NULL),(44595,157,'active','2024-12-20 12:56:20',NULL),(44596,157,'active','2024-12-20 12:56:25',NULL),(44597,157,'active','2024-12-20 12:56:30',NULL),(44598,157,'active','2024-12-20 12:56:35',NULL),(44599,157,'active','2024-12-20 12:56:40',NULL),(44600,157,'active','2024-12-20 12:56:45',NULL),(44601,157,'active','2024-12-20 12:56:50',NULL),(44602,157,'active','2024-12-20 12:56:55',NULL),(44603,157,'active','2024-12-20 12:57:00',NULL),(44604,157,'active','2024-12-20 12:57:05',NULL),(44605,157,'active','2024-12-20 12:57:10',NULL),(44606,157,'active','2024-12-20 12:57:16',NULL),(44607,157,'active','2024-12-20 12:57:21',NULL),(44608,157,'active','2024-12-20 12:57:26',NULL),(44609,157,'active','2024-12-20 12:57:34',NULL),(44610,157,'active','2024-12-20 12:57:40',NULL),(44611,157,'active','2024-12-20 12:57:47',NULL),(44612,157,'active','2024-12-20 12:57:54',NULL),(44613,157,'active','2024-12-20 12:58:00',NULL),(44614,157,'active','2024-12-20 12:58:05',NULL),(44615,157,'active','2024-12-20 12:58:10',NULL),(44616,157,'active','2024-12-20 12:58:15',NULL),(44617,157,'active','2024-12-20 12:58:20',NULL),(44618,157,'active','2024-12-20 12:58:25',NULL),(44619,157,'active','2024-12-20 12:58:30',NULL),(44620,157,'active','2024-12-20 12:58:35',NULL),(44621,157,'active','2024-12-20 12:58:40',NULL),(44622,157,'active','2024-12-20 12:58:45',NULL),(44623,157,'active','2024-12-20 12:58:50',NULL),(44624,157,'active','2024-12-20 12:58:55',NULL),(44625,157,'active','2024-12-20 12:59:00',NULL),(44626,157,'active','2024-12-20 12:59:06',NULL),(44627,157,'active','2024-12-20 12:59:12',NULL),(44628,157,'active','2024-12-20 12:59:17',NULL),(44629,157,'active','2024-12-20 12:59:22',NULL),(44630,157,'active','2024-12-20 12:59:28',NULL),(44631,157,'active','2024-12-20 12:59:34',NULL),(44632,157,'active','2024-12-20 12:59:39',NULL),(44633,157,'active','2024-12-20 12:59:44',NULL),(44634,157,'active','2024-12-20 12:59:49',NULL),(44635,157,'active','2024-12-20 12:59:54',NULL),(44636,157,'active','2024-12-20 12:59:59',NULL),(44637,157,'active','2024-12-20 13:00:04',NULL),(44638,157,'active','2024-12-20 13:00:14',NULL),(44639,157,'active','2024-12-20 13:00:20',NULL),(44640,157,'active','2024-12-20 13:00:25',NULL),(44641,157,'active','2024-12-20 13:00:30',NULL),(44642,157,'active','2024-12-20 13:00:38',NULL),(44643,157,'active','2024-12-20 13:00:46',NULL),(44644,157,'active','2024-12-20 13:00:53',NULL),(44645,157,'active','2024-12-20 13:00:59',NULL),(44646,157,'active','2024-12-20 13:07:25',NULL),(44647,157,'active','2024-12-20 13:07:45',NULL),(44648,157,'active','2024-12-20 13:07:55',NULL),(44649,157,'active','2024-12-20 13:08:51',NULL),(44650,157,'active','2024-12-20 13:09:06',NULL),(44651,157,'active','2024-12-20 13:14:36',NULL),(44652,157,'active','2024-12-20 13:23:04',NULL),(44653,157,'active','2024-12-20 13:23:14',NULL),(44654,157,'active','2024-12-20 13:25:44',NULL),(44655,157,'active','2024-12-20 13:28:15',NULL),(44656,157,'active','2024-12-20 13:28:55',NULL),(44657,157,'active','2024-12-20 13:33:41',NULL),(44658,157,'active','2024-12-20 13:33:51',NULL),(44659,157,'active','2024-12-20 13:36:45',NULL),(44660,157,'active','2024-12-20 13:36:45',NULL),(44661,157,'active','2024-12-20 13:39:17',NULL),(44662,157,'active','2024-12-20 13:41:17',NULL),(44663,157,'active','2024-12-20 13:49:13',NULL),(44664,145,'active','2024-12-20 13:56:00',NULL),(44665,145,'active','2024-12-20 13:56:05',NULL),(44666,145,'active','2024-12-20 13:56:09',NULL),(44667,145,'active','2024-12-20 13:56:10',NULL),(44668,459,'active','2024-12-22 14:43:34',NULL),(44669,459,'active','2024-12-22 14:43:37',NULL),(44670,459,'active','2024-12-22 14:45:39',NULL),(44671,459,'active','2024-12-22 14:45:48',NULL),(44672,459,'active','2024-12-22 14:45:57',NULL),(44673,459,'active','2024-12-22 14:46:08',NULL),(44674,459,'active','2024-12-22 14:46:15',NULL),(44675,459,'active','2024-12-22 14:46:23',NULL),(44676,319,'active','2024-12-23 19:15:43',NULL),(44677,319,'active','2024-12-23 19:15:48',NULL),(44678,319,'active','2024-12-23 19:16:02',NULL),(44679,319,'active','2024-12-23 19:16:03',NULL),(44680,319,'active','2024-12-23 19:16:18',NULL),(44681,319,'active','2024-12-23 19:16:28',NULL),(44682,319,'active','2024-12-23 19:16:33',NULL),(44683,319,'active','2024-12-23 19:16:39',NULL),(44684,319,'active','2024-12-23 19:16:43',NULL),(44685,319,'active','2024-12-23 19:17:38',NULL),(44686,319,'active','2024-12-23 19:17:43',NULL),(44687,319,'active','2024-12-23 19:19:38',NULL),(44688,319,'active','2024-12-23 19:19:48',NULL),(44689,319,'active','2024-12-23 19:20:08',NULL),(44690,319,'active','2024-12-23 19:20:18',NULL),(44691,319,'active','2024-12-23 19:22:24',NULL),(44692,319,'active','2024-12-23 19:22:49',NULL),(44693,319,'active','2024-12-23 19:24:09',NULL),(44694,319,'active','2024-12-23 19:24:19',NULL),(44695,319,'active','2024-12-23 19:26:40',NULL),(44696,319,'active','2024-12-23 19:26:48',NULL),(44697,319,'active','2024-12-23 19:28:11',NULL),(44698,319,'active','2024-12-23 19:28:21',NULL),(44699,319,'active','2024-12-23 19:29:00',NULL),(44700,319,'active','2024-12-23 19:29:05',NULL),(44701,319,'active','2024-12-23 19:29:30',NULL),(44702,319,'active','2024-12-23 19:29:45',NULL),(44703,319,'active','2024-12-23 19:30:14',NULL),(44704,319,'active','2024-12-23 19:30:45',NULL),(44705,319,'active','2024-12-23 19:30:55',NULL),(44706,319,'active','2024-12-23 19:31:18',NULL),(44707,319,'active','2024-12-23 19:31:38',NULL),(44708,319,'active','2024-12-23 19:33:11',NULL),(44709,319,'active','2024-12-23 19:35:01',NULL),(44710,157,'active','2024-12-26 12:23:58',NULL),(44711,157,'active','2024-12-26 12:24:04',NULL),(44712,157,'active','2024-12-26 12:24:08',NULL),(44713,268,'active','2024-12-28 07:27:11',NULL),(44714,268,'active','2024-12-28 07:27:12',NULL),(44715,268,'active','2024-12-28 07:27:18',NULL),(44716,268,'active','2024-12-28 07:27:23',NULL),(44717,268,'active','2024-12-28 07:27:28',NULL),(44718,268,'active','2024-12-28 07:27:33','2025-01-18 11:47:06'),(44719,157,'active','2025-01-02 11:24:27',NULL),(44720,157,'active','2025-01-02 11:24:33',NULL),(44721,532,'active','2025-01-04 23:11:18',NULL),(44722,532,'active','2025-01-04 23:11:23',NULL),(44723,532,'active','2025-01-04 23:11:58',NULL),(44724,532,'active','2025-01-04 23:12:03',NULL),(44725,579,'active','2025-01-05 19:05:17',NULL),(44726,579,'active','2025-01-05 19:05:21',NULL),(44727,579,'active','2025-01-05 19:05:48',NULL),(44728,579,'active','2025-01-05 19:05:51',NULL),(44729,579,'active','2025-01-05 19:06:39',NULL),(44730,579,'active','2025-01-05 19:06:41',NULL),(44731,579,'active','2025-01-05 19:30:52',NULL),(44732,579,'active','2025-01-05 19:30:54',NULL),(44733,579,'active','2025-01-05 19:31:06',NULL),(44734,579,'active','2025-01-05 19:31:09',NULL),(44735,579,'active','2025-01-05 19:31:29',NULL),(44736,579,'active','2025-01-05 19:31:31',NULL),(44737,579,'active','2025-01-05 19:32:03',NULL),(44738,579,'active','2025-01-05 19:32:04',NULL),(44739,579,'active','2025-01-05 19:36:44',NULL),(44740,579,'active','2025-01-05 19:36:46',NULL),(44741,164,'active','2025-01-07 14:15:42',NULL),(44742,231,'active','2025-01-08 06:36:03',NULL),(44743,579,'active','2025-01-08 10:58:02',NULL),(44744,579,'active','2025-01-08 10:58:06',NULL),(44745,204,'active','2025-01-09 16:26:11',NULL),(44746,204,'active','2025-01-09 16:26:16',NULL),(44747,204,'active','2025-01-09 16:28:30',NULL),(44748,204,'active','2025-01-09 16:28:35',NULL),(44749,204,'active','2025-01-09 16:28:40',NULL),(44750,204,'active','2025-01-09 16:28:50',NULL),(44751,204,'active','2025-01-09 16:29:01',NULL),(44752,204,'active','2025-01-09 16:29:11',NULL),(44753,204,'active','2025-01-09 16:29:20',NULL),(44754,203,'active','2025-01-11 05:07:41',NULL),(44755,203,'active','2025-01-11 16:57:12',NULL),(44756,209,'active','2025-01-15 11:52:45',NULL),(44757,209,'active','2025-01-15 12:10:02',NULL),(44758,209,'active','2025-01-15 12:10:04',NULL),(44759,209,'active','2025-01-15 12:10:12',NULL),(44760,209,'active','2025-01-15 12:10:17',NULL),(44761,532,'active','2025-01-16 05:54:33',NULL),(44762,532,'active','2025-01-16 05:54:38',NULL),(44763,532,'active','2025-01-16 05:54:54',NULL),(44764,532,'active','2025-01-16 05:54:55','2025-01-16 05:55:29'),(44765,532,'active','2025-01-16 05:55:31',NULL),(44766,532,'active','2025-01-16 05:55:33',NULL),(44767,532,'active','2025-01-16 14:46:11',NULL),(44768,532,'active','2025-01-16 14:46:14',NULL),(44769,268,'active','2025-01-18 11:47:10',NULL),(44770,268,'active','2025-01-18 11:47:11',NULL),(44771,268,'active','2025-01-18 11:47:21',NULL),(44772,268,'active','2025-01-18 11:47:22',NULL),(44773,651,'active','2025-01-27 19:24:04',NULL),(44774,651,'active','2025-01-27 19:24:11',NULL),(44775,628,'active','2025-01-28 07:18:36',NULL),(44776,68,'active','2025-01-28 12:28:50',NULL),(44777,68,'active','2025-01-28 12:37:15',NULL),(44778,68,'active','2025-01-28 12:37:16',NULL),(44779,290,'active','2025-01-30 13:38:10',NULL),(44780,290,'active','2025-01-30 13:38:15',NULL),(44781,290,'active','2025-01-30 13:38:19',NULL),(44782,290,'active','2025-01-30 13:38:29',NULL),(44783,203,'active','2025-01-31 07:50:08',NULL),(44784,203,'active','2025-01-31 07:50:13',NULL),(44785,203,'active','2025-01-31 07:51:13',NULL),(44786,203,'active','2025-01-31 07:51:49',NULL),(44787,203,'active','2025-01-31 07:51:53','2025-01-31 07:51:56'),(44788,203,'active','2025-01-31 07:52:19',NULL),(44789,203,'active','2025-01-31 07:52:23',NULL),(44790,160,'active','2025-01-31 18:13:30',NULL),(44791,160,'active','2025-01-31 18:13:35',NULL),(44792,160,'active','2025-01-31 18:13:52',NULL),(44793,160,'active','2025-01-31 18:13:55',NULL),(44794,183,'active','2025-02-01 10:12:10',NULL),(44795,183,'active','2025-02-01 10:12:12',NULL),(44796,183,'active','2025-02-01 10:13:59',NULL),(44797,183,'active','2025-02-01 10:14:20',NULL),(44798,183,'active','2025-02-01 10:14:37',NULL),(44799,183,'active','2025-02-01 10:15:01',NULL),(44800,183,'active','2025-02-01 10:15:22',NULL),(44801,183,'active','2025-02-01 10:15:47',NULL),(44802,183,'active','2025-02-01 10:16:01',NULL),(44803,183,'active','2025-02-01 10:16:11',NULL),(44804,183,'active','2025-02-01 10:16:21',NULL),(44805,183,'active','2025-02-01 10:16:29',NULL),(44806,183,'active','2025-02-01 10:16:38',NULL),(44807,183,'active','2025-02-01 10:16:50',NULL),(44808,183,'active','2025-02-01 10:24:31',NULL),(44809,183,'active','2025-02-01 10:24:39',NULL),(44810,183,'active','2025-02-01 10:24:48',NULL),(44811,183,'active','2025-02-01 10:25:02',NULL),(44812,183,'active','2025-02-01 10:25:12',NULL),(44813,183,'active','2025-02-01 10:25:20',NULL),(44814,183,'active','2025-02-01 10:25:30',NULL),(44815,183,'active','2025-02-01 10:25:39',NULL),(44816,183,'active','2025-02-01 10:25:59',NULL),(44817,183,'active','2025-02-01 10:26:15',NULL),(44818,183,'active','2025-02-01 10:26:28',NULL),(44819,183,'active','2025-02-01 10:26:45',NULL),(44820,183,'active','2025-02-01 10:26:57',NULL),(44821,183,'active','2025-02-01 10:27:10',NULL),(44822,183,'active','2025-02-01 10:27:24',NULL),(44823,183,'active','2025-02-01 10:27:37',NULL),(44824,183,'active','2025-02-01 10:27:46',NULL),(44825,183,'active','2025-02-01 10:27:56',NULL),(44826,183,'active','2025-02-01 10:28:07',NULL),(44827,183,'active','2025-02-01 10:28:17',NULL),(44828,183,'active','2025-02-01 10:28:26',NULL),(44829,183,'active','2025-02-01 10:28:37',NULL),(44830,183,'active','2025-02-01 10:28:48',NULL),(44831,183,'active','2025-02-01 10:28:58',NULL),(44832,183,'active','2025-02-01 10:29:07',NULL),(44833,183,'active','2025-02-01 10:29:16',NULL),(44834,183,'active','2025-02-01 10:29:24',NULL),(44835,183,'active','2025-02-01 10:29:34',NULL),(44836,183,'active','2025-02-01 10:29:45',NULL),(44837,183,'active','2025-02-01 10:29:56',NULL),(44838,183,'active','2025-02-01 10:30:03',NULL),(44839,183,'active','2025-02-01 10:30:11',NULL),(44840,183,'active','2025-02-01 10:30:21',NULL),(44841,183,'active','2025-02-01 10:30:34',NULL),(44842,183,'active','2025-02-01 10:30:46',NULL),(44843,183,'active','2025-02-01 10:31:02',NULL),(44844,183,'active','2025-02-01 10:31:15',NULL),(44845,183,'active','2025-02-01 10:31:34',NULL),(44846,183,'active','2025-02-01 10:31:47',NULL),(44847,183,'active','2025-02-01 10:31:57',NULL),(44848,183,'active','2025-02-01 10:32:11',NULL),(44849,183,'active','2025-02-01 10:32:31',NULL),(44850,183,'active','2025-02-01 10:32:42',NULL),(44851,183,'active','2025-02-01 10:32:55',NULL),(44852,183,'active','2025-02-01 10:33:09',NULL),(44853,183,'active','2025-02-01 10:33:19',NULL),(44854,183,'active','2025-02-01 10:37:28',NULL),(44855,183,'active','2025-02-01 10:37:41',NULL),(44856,183,'active','2025-02-01 10:37:53',NULL),(44857,183,'active','2025-02-01 10:38:14',NULL),(44858,183,'active','2025-02-01 10:38:28',NULL),(44859,183,'active','2025-02-01 10:38:51',NULL),(44860,183,'active','2025-02-01 10:39:05',NULL),(44861,183,'active','2025-02-01 10:39:15',NULL),(44862,183,'active','2025-02-01 10:39:27',NULL),(44863,183,'active','2025-02-01 10:41:45',NULL),(44864,183,'active','2025-02-01 10:42:01',NULL),(44865,183,'active','2025-02-01 10:45:46',NULL),(44866,183,'active','2025-02-01 10:45:55',NULL),(44867,183,'active','2025-02-01 10:46:02',NULL),(44868,183,'active','2025-02-01 10:46:08',NULL),(44869,183,'active','2025-02-01 10:46:15',NULL),(44870,183,'active','2025-02-01 10:46:21',NULL),(44871,183,'active','2025-02-01 10:46:40',NULL),(44872,183,'active','2025-02-01 10:47:12',NULL),(44873,183,'active','2025-02-01 10:51:56',NULL),(44874,183,'active','2025-02-01 10:57:58',NULL),(44875,183,'active','2025-02-01 10:58:08',NULL),(44876,183,'active','2025-02-01 10:58:17',NULL),(44877,183,'active','2025-02-01 10:58:25',NULL),(44878,183,'active','2025-02-01 10:58:33',NULL),(44879,183,'active','2025-02-01 10:58:47',NULL),(44880,183,'active','2025-02-01 10:58:56',NULL),(44881,183,'active','2025-02-01 10:59:06',NULL),(44882,183,'active','2025-02-01 10:59:19',NULL),(44883,183,'active','2025-02-01 10:59:35',NULL),(44884,183,'active','2025-02-01 10:59:49',NULL),(44885,183,'active','2025-02-01 11:00:01',NULL),(44886,183,'active','2025-02-01 11:00:14',NULL),(44887,183,'active','2025-02-01 11:02:43',NULL),(44888,183,'active','2025-02-01 11:03:05',NULL),(44889,183,'active','2025-02-01 11:03:19',NULL),(44890,183,'active','2025-02-01 11:03:34',NULL),(44891,183,'active','2025-02-01 11:04:01',NULL),(44892,183,'active','2025-02-01 11:04:16',NULL),(44893,183,'active','2025-02-01 11:04:27',NULL),(44894,183,'active','2025-02-01 11:04:37',NULL),(44895,183,'active','2025-02-01 11:04:47',NULL),(44896,183,'active','2025-02-01 11:04:58',NULL),(44897,183,'active','2025-02-01 11:05:08',NULL),(44898,183,'active','2025-02-01 11:05:19',NULL),(44899,183,'active','2025-02-01 11:05:32',NULL),(44900,183,'active','2025-02-01 11:05:45',NULL),(44901,183,'active','2025-02-01 11:05:56',NULL),(44902,183,'active','2025-02-01 11:06:06',NULL),(44903,183,'active','2025-02-01 11:06:14',NULL),(44904,183,'active','2025-02-01 11:06:23',NULL),(44905,183,'active','2025-02-01 11:06:35',NULL),(44906,183,'active','2025-02-01 11:06:52',NULL),(44907,183,'active','2025-02-01 11:07:08',NULL),(44908,183,'active','2025-02-01 11:07:23',NULL),(44909,183,'active','2025-02-01 11:07:39',NULL),(44910,183,'active','2025-02-01 11:09:54',NULL),(44911,183,'active','2025-02-01 11:10:05',NULL),(44912,183,'active','2025-02-01 11:10:18',NULL),(44913,183,'active','2025-02-01 11:10:29',NULL),(44914,183,'active','2025-02-01 11:10:55',NULL),(44915,183,'active','2025-02-01 11:12:57',NULL),(44916,183,'active','2025-02-01 11:13:04',NULL),(44917,183,'active','2025-02-01 11:13:11',NULL),(44918,183,'active','2025-02-01 11:13:18',NULL),(44919,183,'active','2025-02-01 11:13:28',NULL),(44920,183,'active','2025-02-01 11:13:39',NULL),(44921,183,'active','2025-02-01 11:13:54',NULL),(44922,183,'active','2025-02-01 11:23:12',NULL),(44923,183,'active','2025-02-01 11:23:31',NULL),(44924,183,'active','2025-02-01 11:30:30',NULL),(44925,183,'active','2025-02-01 11:32:08',NULL),(44926,183,'active','2025-02-01 11:32:21',NULL),(44927,183,'active','2025-02-01 11:32:36',NULL),(44928,183,'active','2025-02-01 11:45:07',NULL),(44929,183,'active','2025-02-01 11:45:16',NULL),(44930,183,'active','2025-02-01 11:45:25',NULL),(44931,183,'active','2025-02-01 11:45:32',NULL),(44932,183,'active','2025-02-01 11:45:39',NULL),(44933,183,'active','2025-02-01 11:45:45',NULL),(44934,183,'active','2025-02-01 11:45:51',NULL),(44935,183,'active','2025-02-01 11:46:01',NULL),(44936,183,'active','2025-02-01 11:46:13',NULL),(44937,183,'active','2025-02-01 11:46:23',NULL),(44938,183,'active','2025-02-01 11:46:31',NULL),(44939,183,'active','2025-02-01 11:46:38',NULL),(44940,183,'active','2025-02-01 11:46:49',NULL),(44941,183,'active','2025-02-01 11:46:58',NULL),(44942,183,'active','2025-02-01 11:47:06',NULL),(44943,183,'active','2025-02-01 11:47:15',NULL),(44944,183,'active','2025-02-01 11:47:23',NULL),(44945,183,'active','2025-02-01 11:47:31',NULL),(44946,183,'active','2025-02-01 11:47:40',NULL),(44947,183,'active','2025-02-01 11:47:48',NULL),(44948,183,'active','2025-02-01 11:47:57',NULL),(44949,183,'active','2025-02-01 11:48:05',NULL),(44950,183,'active','2025-02-01 11:48:13',NULL),(44951,183,'active','2025-02-01 11:48:21',NULL),(44952,183,'active','2025-02-01 11:48:30',NULL),(44953,183,'active','2025-02-01 11:48:38',NULL),(44954,183,'active','2025-02-01 11:48:48',NULL),(44955,183,'active','2025-02-01 11:49:00',NULL),(44956,183,'active','2025-02-01 11:49:12',NULL),(44957,183,'active','2025-02-01 11:49:25',NULL),(44958,183,'active','2025-02-01 11:49:49',NULL),(44959,183,'active','2025-02-01 11:50:01',NULL),(44960,183,'active','2025-02-01 11:50:13',NULL),(44961,183,'active','2025-02-01 11:50:23',NULL),(44962,183,'active','2025-02-01 11:50:32',NULL),(44963,183,'active','2025-02-01 11:50:42',NULL),(44964,183,'active','2025-02-01 11:50:50',NULL),(44965,183,'active','2025-02-01 11:50:59',NULL),(44966,183,'active','2025-02-01 11:51:15',NULL),(44967,183,'active','2025-02-01 11:52:01',NULL),(44968,183,'active','2025-02-01 11:52:25',NULL),(44969,183,'active','2025-02-01 11:52:53',NULL),(44970,183,'active','2025-02-01 11:53:21',NULL),(44971,183,'active','2025-02-01 11:53:45',NULL),(44972,183,'active','2025-02-01 11:54:04',NULL),(44973,183,'active','2025-02-01 11:54:16',NULL),(44974,183,'active','2025-02-01 11:54:24',NULL),(44975,183,'active','2025-02-01 11:54:31',NULL),(44976,183,'active','2025-02-01 11:54:37',NULL),(44977,183,'active','2025-02-01 11:54:52',NULL),(44978,183,'active','2025-02-01 11:55:01',NULL),(44979,183,'active','2025-02-01 11:55:11',NULL),(44980,183,'active','2025-02-01 11:55:22',NULL),(44981,183,'active','2025-02-01 11:55:31',NULL),(44982,183,'active','2025-02-01 11:55:40',NULL),(44983,183,'active','2025-02-01 11:55:48',NULL),(44984,183,'active','2025-02-01 11:55:56',NULL),(44985,183,'active','2025-02-01 11:56:04',NULL),(44986,183,'active','2025-02-01 11:56:15',NULL),(44987,183,'active','2025-02-01 11:58:59',NULL),(44988,183,'active','2025-02-01 11:59:12',NULL),(44989,183,'active','2025-02-01 11:59:22',NULL),(44990,183,'active','2025-02-01 11:59:29',NULL),(44991,183,'active','2025-02-01 11:59:37',NULL),(44992,183,'active','2025-02-01 11:59:48',NULL),(44993,183,'active','2025-02-01 12:00:02',NULL),(44994,183,'active','2025-02-01 12:00:16',NULL),(44995,183,'active','2025-02-01 12:02:43',NULL),(44996,183,'active','2025-02-01 12:03:14',NULL),(44997,183,'active','2025-02-01 12:03:27',NULL),(44998,183,'active','2025-02-01 12:03:35',NULL),(44999,183,'active','2025-02-01 12:03:42',NULL),(45000,183,'active','2025-02-01 12:03:49',NULL),(45001,183,'active','2025-02-01 12:03:55',NULL),(45002,183,'active','2025-02-01 12:04:01',NULL),(45003,183,'active','2025-02-01 12:04:11',NULL),(45004,183,'active','2025-02-01 12:04:23',NULL),(45005,183,'active','2025-02-01 12:04:31',NULL),(45006,183,'active','2025-02-01 12:04:39',NULL),(45007,183,'active','2025-02-01 12:05:08',NULL),(45008,183,'active','2025-02-01 12:05:16',NULL),(45009,183,'active','2025-02-01 12:05:24',NULL),(45010,183,'active','2025-02-01 12:05:32',NULL),(45011,183,'active','2025-02-01 12:05:44',NULL),(45012,183,'active','2025-02-01 12:05:55',NULL),(45013,183,'active','2025-02-01 12:06:06',NULL),(45014,183,'active','2025-02-01 12:06:16',NULL),(45015,183,'active','2025-02-01 12:06:31',NULL),(45016,183,'active','2025-02-01 12:06:43',NULL),(45017,183,'active','2025-02-01 12:06:55',NULL),(45018,183,'active','2025-02-01 12:07:04',NULL),(45019,183,'active','2025-02-01 12:07:14',NULL),(45020,183,'active','2025-02-01 12:07:33',NULL),(45021,183,'active','2025-02-01 12:10:35',NULL),(45022,183,'active','2025-02-01 12:10:50',NULL),(45023,183,'active','2025-02-01 12:11:02',NULL),(45024,183,'active','2025-02-01 12:11:23',NULL),(45025,183,'active','2025-02-01 12:11:36',NULL),(45026,183,'active','2025-02-01 12:11:47',NULL),(45027,183,'active','2025-02-01 12:11:57',NULL),(45028,183,'active','2025-02-01 12:12:07',NULL),(45029,183,'active','2025-02-01 12:12:26',NULL),(45030,183,'active','2025-02-01 12:12:36',NULL),(45031,183,'active','2025-02-01 12:12:50',NULL),(45032,183,'active','2025-02-01 12:13:00',NULL),(45033,183,'active','2025-02-01 12:13:12',NULL),(45034,183,'active','2025-02-01 12:13:24',NULL),(45035,183,'active','2025-02-01 12:13:34',NULL),(45036,183,'active','2025-02-01 12:13:43',NULL),(45037,183,'active','2025-02-01 12:13:53',NULL),(45038,183,'active','2025-02-01 12:14:11',NULL),(45039,183,'active','2025-02-01 12:14:11',NULL),(45040,183,'active','2025-02-01 12:14:18',NULL),(45041,183,'active','2025-02-01 12:17:07',NULL),(45042,183,'active','2025-02-01 12:17:16',NULL),(45043,183,'active','2025-02-01 12:17:28',NULL),(45044,183,'active','2025-02-01 12:17:35',NULL),(45045,183,'active','2025-02-01 12:17:41',NULL),(45046,183,'active','2025-02-01 12:17:56',NULL),(45047,183,'active','2025-02-01 12:18:04',NULL),(45048,183,'active','2025-02-01 12:18:12',NULL),(45049,183,'active','2025-02-01 12:18:25',NULL),(45050,183,'active','2025-02-01 12:18:37',NULL),(45051,183,'active','2025-02-01 12:18:58',NULL),(45052,183,'active','2025-02-01 12:19:07',NULL),(45053,183,'active','2025-02-01 12:19:14',NULL),(45054,183,'active','2025-02-01 12:19:23',NULL),(45055,183,'active','2025-02-01 12:19:34',NULL),(45056,183,'active','2025-02-01 12:19:44',NULL),(45057,183,'active','2025-02-01 12:19:53',NULL),(45058,183,'active','2025-02-01 12:20:00',NULL),(45059,183,'active','2025-02-01 12:20:07',NULL),(45060,183,'active','2025-02-01 12:20:13',NULL),(45061,183,'active','2025-02-01 12:20:19',NULL),(45062,183,'active','2025-02-01 12:20:26',NULL),(45063,183,'active','2025-02-01 12:20:32',NULL),(45064,183,'active','2025-02-01 12:20:38',NULL),(45065,183,'active','2025-02-01 12:20:45',NULL),(45066,183,'active','2025-02-01 12:20:52',NULL),(45067,183,'active','2025-02-01 12:20:59',NULL),(45068,183,'active','2025-02-01 12:21:07',NULL),(45069,183,'active','2025-02-01 12:21:16',NULL),(45070,183,'active','2025-02-01 12:21:24',NULL),(45071,183,'active','2025-02-01 12:21:32',NULL),(45072,183,'active','2025-02-01 12:21:57',NULL),(45073,183,'active','2025-02-01 12:22:11',NULL),(45074,183,'active','2025-02-01 12:22:26',NULL),(45075,183,'active','2025-02-01 12:22:56',NULL),(45076,183,'active','2025-02-01 12:26:07',NULL),(45077,183,'active','2025-02-01 12:26:18',NULL),(45078,183,'active','2025-02-01 12:26:29',NULL),(45079,183,'active','2025-02-01 12:26:39',NULL),(45080,183,'active','2025-02-01 12:26:45',NULL),(45081,183,'active','2025-02-01 12:26:50',NULL),(45082,183,'active','2025-02-01 12:26:56',NULL),(45083,183,'active','2025-02-01 12:27:01',NULL),(45084,183,'active','2025-02-01 12:27:06',NULL),(45085,183,'active','2025-02-01 12:27:11',NULL),(45086,183,'active','2025-02-01 12:27:16',NULL),(45087,183,'active','2025-02-01 12:27:21',NULL),(45088,183,'active','2025-02-01 12:27:26',NULL),(45089,183,'active','2025-02-01 12:27:31',NULL),(45090,183,'active','2025-02-01 12:27:36',NULL),(45091,183,'active','2025-02-01 12:27:41',NULL),(45092,183,'active','2025-02-01 12:27:47',NULL),(45093,183,'active','2025-02-01 12:28:15',NULL),(45094,183,'active','2025-02-01 12:28:21',NULL),(45095,183,'active','2025-02-01 12:28:26',NULL),(45096,183,'active','2025-02-01 12:28:31',NULL),(45097,183,'active','2025-02-01 12:28:36',NULL),(45098,183,'active','2025-02-01 12:28:41',NULL),(45099,183,'active','2025-02-01 12:28:46',NULL),(45100,183,'active','2025-02-01 12:28:51',NULL),(45101,183,'active','2025-02-01 12:28:57',NULL),(45102,183,'active','2025-02-01 12:29:01',NULL),(45103,183,'active','2025-02-01 12:29:06',NULL),(45104,183,'active','2025-02-01 12:29:11',NULL),(45105,183,'active','2025-02-01 12:29:17',NULL),(45106,183,'active','2025-02-01 12:32:19',NULL),(45107,183,'active','2025-02-01 12:32:29',NULL),(45108,183,'active','2025-02-01 12:32:35',NULL),(45109,183,'active','2025-02-01 12:32:40',NULL),(45110,183,'active','2025-02-01 12:32:46',NULL),(45111,183,'active','2025-02-01 12:32:51',NULL),(45112,183,'active','2025-02-01 12:32:56',NULL),(45113,183,'active','2025-02-01 12:33:02',NULL),(45114,183,'active','2025-02-01 12:33:10',NULL),(45115,183,'active','2025-02-01 12:34:38',NULL),(45116,183,'active','2025-02-01 12:34:45',NULL),(45117,183,'active','2025-02-01 12:34:59',NULL),(45118,183,'active','2025-02-01 12:35:15',NULL),(45119,183,'active','2025-02-01 12:35:23',NULL),(45120,183,'active','2025-02-01 12:35:31',NULL),(45121,183,'active','2025-02-01 12:35:44',NULL),(45122,183,'active','2025-02-01 12:35:51',NULL),(45123,183,'active','2025-02-01 12:35:58',NULL),(45124,183,'active','2025-02-01 12:36:05',NULL),(45125,183,'active','2025-02-01 12:36:14',NULL),(45126,183,'active','2025-02-01 12:36:26',NULL),(45127,183,'active','2025-02-01 12:36:34',NULL),(45128,183,'active','2025-02-01 12:36:49',NULL),(45129,183,'active','2025-02-01 12:37:09',NULL),(45130,183,'active','2025-02-01 12:37:16',NULL),(45131,183,'active','2025-02-01 12:37:23',NULL),(45132,183,'active','2025-02-01 12:37:30',NULL),(45133,183,'active','2025-02-01 12:37:45',NULL),(45134,183,'active','2025-02-01 12:37:56',NULL),(45135,183,'active','2025-02-01 12:38:06',NULL),(45136,183,'active','2025-02-01 12:38:15',NULL),(45137,183,'active','2025-02-01 12:38:26',NULL),(45138,183,'active','2025-02-01 12:38:37',NULL),(45139,183,'active','2025-02-01 12:38:47',NULL),(45140,183,'active','2025-02-01 12:38:58',NULL),(45141,183,'active','2025-02-01 12:39:09',NULL),(45142,183,'active','2025-02-01 12:39:18',NULL),(45143,183,'active','2025-02-01 12:39:28',NULL),(45144,183,'active','2025-02-01 12:39:36',NULL),(45145,183,'active','2025-02-01 12:39:44',NULL),(45146,183,'active','2025-02-01 12:39:53',NULL),(45147,183,'active','2025-02-01 12:40:02',NULL),(45148,183,'active','2025-02-01 12:40:11',NULL),(45149,183,'active','2025-02-01 12:40:19',NULL),(45150,183,'active','2025-02-01 12:40:27',NULL),(45151,183,'active','2025-02-01 12:40:36',NULL),(45152,183,'active','2025-02-01 12:40:47',NULL),(45153,183,'active','2025-02-01 12:40:58',NULL),(45154,183,'active','2025-02-01 12:41:11',NULL),(45155,183,'active','2025-02-01 12:41:24',NULL),(45156,183,'active','2025-02-01 12:41:40',NULL),(45157,183,'active','2025-02-01 12:44:50',NULL),(45158,183,'active','2025-02-01 12:45:04',NULL),(45159,183,'active','2025-02-01 12:45:16',NULL),(45160,183,'active','2025-02-01 12:45:27',NULL),(45161,183,'active','2025-02-01 12:45:37',NULL),(45162,183,'active','2025-02-01 12:46:09',NULL),(45163,183,'active','2025-02-01 12:47:37',NULL),(45164,183,'active','2025-02-01 12:48:50',NULL),(45165,183,'active','2025-02-01 12:49:19',NULL),(45166,183,'active','2025-02-01 12:50:35',NULL),(45167,183,'active','2025-02-01 13:06:17',NULL),(45168,183,'active','2025-02-01 13:06:51',NULL),(45169,183,'active','2025-02-01 13:07:19',NULL),(45170,183,'active','2025-02-01 13:07:36',NULL),(45171,183,'active','2025-02-01 13:07:48',NULL),(45172,183,'active','2025-02-01 13:07:58',NULL),(45173,183,'active','2025-02-01 13:10:05',NULL),(45174,183,'active','2025-02-01 13:10:18',NULL),(45175,183,'active','2025-02-01 13:10:29',NULL),(45176,183,'active','2025-02-01 13:10:40',NULL),(45177,183,'active','2025-02-01 13:10:53',NULL),(45178,183,'active','2025-02-01 13:11:09',NULL),(45179,183,'active','2025-02-01 13:11:21',NULL),(45180,183,'active','2025-02-01 13:11:30',NULL),(45181,183,'active','2025-02-01 13:11:49',NULL),(45182,183,'active','2025-02-01 13:11:59',NULL),(45183,183,'active','2025-02-01 13:12:20',NULL),(45184,183,'active','2025-02-01 13:12:32',NULL),(45185,183,'active','2025-02-01 13:12:44',NULL),(45186,183,'active','2025-02-01 13:12:56',NULL),(45187,183,'active','2025-02-01 13:13:06',NULL),(45188,183,'active','2025-02-01 13:13:15',NULL),(45189,183,'active','2025-02-01 13:13:24',NULL),(45190,183,'active','2025-02-01 13:13:32',NULL),(45191,183,'active','2025-02-01 13:13:42',NULL),(45192,183,'active','2025-02-01 13:13:52',NULL),(45193,183,'active','2025-02-01 13:14:03',NULL),(45194,183,'active','2025-02-01 13:14:27',NULL),(45195,183,'active','2025-02-01 13:17:22',NULL),(45196,183,'active','2025-02-01 13:17:37',NULL),(45197,183,'active','2025-02-01 13:17:46',NULL),(45198,183,'active','2025-02-01 13:17:57',NULL),(45199,183,'active','2025-02-01 13:18:06',NULL),(45200,183,'active','2025-02-01 13:18:14',NULL),(45201,183,'active','2025-02-01 13:18:24',NULL),(45202,183,'active','2025-02-01 13:18:33',NULL),(45203,183,'active','2025-02-01 13:18:42',NULL),(45204,183,'active','2025-02-01 13:19:38',NULL),(45205,183,'active','2025-02-01 13:19:45',NULL),(45206,183,'active','2025-02-01 13:19:53',NULL),(45207,183,'active','2025-02-01 13:20:02',NULL),(45208,183,'active','2025-02-01 13:20:15',NULL),(45209,183,'active','2025-02-01 13:20:22',NULL),(45210,183,'active','2025-02-01 13:20:28',NULL),(45211,183,'active','2025-02-01 13:20:33',NULL),(45212,183,'active','2025-02-01 13:20:39',NULL),(45213,183,'active','2025-02-01 13:20:47',NULL),(45214,183,'active','2025-02-01 13:21:22',NULL),(45215,183,'active','2025-02-01 13:34:10',NULL),(45216,183,'active','2025-02-01 13:34:23',NULL),(45217,183,'active','2025-02-01 13:34:37',NULL),(45218,183,'active','2025-02-01 13:34:47',NULL),(45219,183,'active','2025-02-01 13:34:58',NULL),(45220,183,'active','2025-02-01 13:35:07',NULL),(45221,183,'active','2025-02-01 13:35:16',NULL),(45222,183,'active','2025-02-01 13:35:23',NULL),(45223,183,'active','2025-02-01 13:38:49',NULL),(45224,183,'active','2025-02-01 13:38:55',NULL),(45225,183,'active','2025-02-01 13:39:00',NULL),(45226,183,'active','2025-02-01 13:39:10',NULL),(45227,183,'active','2025-02-01 13:39:18',NULL),(45228,183,'active','2025-02-01 13:39:30',NULL),(45229,183,'active','2025-02-01 13:39:43',NULL),(45230,183,'active','2025-02-01 13:39:53',NULL),(45231,183,'active','2025-02-01 13:40:05',NULL),(45232,183,'active','2025-02-01 13:40:14',NULL),(45233,183,'active','2025-02-01 13:40:20',NULL),(45234,183,'active','2025-02-01 13:40:26',NULL),(45235,183,'active','2025-02-01 13:40:32',NULL),(45236,183,'active','2025-02-01 13:40:39',NULL),(45237,183,'active','2025-02-01 13:40:47',NULL),(45238,183,'active','2025-02-01 13:40:54',NULL),(45239,183,'active','2025-02-01 13:41:16',NULL),(45240,183,'active','2025-02-01 13:41:27',NULL),(45241,183,'active','2025-02-01 13:41:38',NULL),(45242,183,'active','2025-02-01 13:41:51',NULL),(45243,183,'active','2025-02-01 13:42:04',NULL),(45244,183,'active','2025-02-01 13:42:16',NULL),(45245,183,'active','2025-02-01 13:42:28',NULL),(45246,183,'active','2025-02-01 13:42:38',NULL),(45247,183,'active','2025-02-01 13:42:49',NULL),(45248,183,'active','2025-02-01 13:43:06',NULL),(45249,68,'active','2025-02-02 11:29:49',NULL),(45250,68,'active','2025-02-02 11:29:56',NULL),(45251,288,'active','2025-02-06 09:22:45',NULL),(45252,397,'active','2025-02-07 18:45:22',NULL),(45253,651,'active','2025-02-28 09:40:54',NULL),(45254,651,'active','2025-02-28 09:40:59',NULL),(45255,651,'active','2025-02-28 09:41:15',NULL),(45256,651,'active','2025-02-28 09:44:52',NULL),(45257,651,'active','2025-02-28 09:44:53',NULL),(45258,651,'active','2025-02-28 09:45:12',NULL),(45259,651,'active','2025-02-28 09:45:13',NULL),(45260,651,'active','2025-02-28 09:45:33',NULL),(45261,651,'active','2025-02-28 09:46:46',NULL),(45262,651,'active','2025-02-28 09:55:06',NULL),(45263,651,'active','2025-02-28 10:03:17',NULL),(45264,651,'active','2025-02-28 15:15:12',NULL),(45265,651,'active','2025-02-28 15:15:15',NULL),(45266,651,'active','2025-02-28 15:25:02',NULL),(45267,651,'active','2025-02-28 15:25:04','2025-02-28 15:25:05'),(45268,400,'active','2025-03-02 05:51:00',NULL),(45269,326,'active','2025-03-05 08:06:41','2025-03-05 08:08:03'),(45270,326,'active','2025-03-05 08:08:07',NULL),(45271,326,'active','2025-03-05 08:08:08',NULL),(45272,326,'active','2025-03-06 14:08:09',NULL),(45273,326,'active','2025-03-07 11:11:18',NULL),(45274,382,'active','2025-03-09 14:14:04',NULL),(45275,209,'active','2025-03-09 16:06:33',NULL),(45276,326,'active','2025-03-12 08:45:39',NULL),(45277,326,'active','2025-03-14 07:59:16','2025-03-14 07:59:59'),(45278,183,'active','2025-03-20 15:50:23',NULL),(45279,183,'active','2025-03-20 15:50:25',NULL),(45280,204,'active','2025-03-24 07:19:16',NULL),(45281,204,'active','2025-03-24 07:19:17',NULL),(45282,204,'active','2025-03-24 07:28:17',NULL),(45283,204,'active','2025-03-24 07:28:49',NULL),(45284,63,'active','2025-05-20 14:50:42',NULL),(45285,63,'active','2025-05-20 14:52:02','2025-05-20 14:52:35');
/*!40000 ALTER TABLE `vendorActivityLog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendorCar`
--

DROP TABLE IF EXISTS `vendorCar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `vendorCar` (
  `vcId` int NOT NULL AUTO_INCREMENT,
  `vcUserId` int NOT NULL,
  `vcPanelNumber` varchar(255) DEFAULT NULL,
  `vcCarlicenseExpire` date DEFAULT NULL,
  `vcDrivingExpire` date DEFAULT NULL,
  `vcCarBrand` varchar(255) DEFAULT NULL,
  `vcCarModel` varchar(255) DEFAULT NULL,
  `vcCarYear` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`vcId`),
  KEY `vcUserId` (`vcUserId`),
  CONSTRAINT `vendorCar_ibfk_1` FOREIGN KEY (`vcUserId`) REFERENCES `users` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=445 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendorCar`
--

LOCK TABLES `vendorCar` WRITE;
/*!40000 ALTER TABLE `vendorCar` DISABLE KEYS */;
INSERT INTO `vendorCar` VALUES (29,63,'112346','2031-01-21','2031-01-22','كيا','bongo ','2004'),(31,64,'42-28398','2024-10-25','2027-03-16','ميتسوبيشي','canter','2014'),(32,65,'40-63398','2024-10-23','2029-05-15','كيا','bongo','2018'),(33,66,'42-18969','2024-11-28','2031-10-09','كيا','Frontier ','1999'),(35,67,'42-42668','2024-09-03','2024-09-17','هونداي','HD.65','2016'),(36,69,'42-22103','2024-10-10','2028-05-09','كيا','bongo','2018'),(37,68,'1526615','2024-01-17','2024-01-31','ford','07777303017','2020'),(38,70,'40-84780','2024-10-08','2029-04-17','هونداي','porter','2020'),(39,71,'40-75590','2024-10-18','2027-03-11','كيا','bongo','2020'),(40,72,'41-31774','2024-06-18','2029-01-16','تويوتا','dyana','1994'),(41,73,'41-91044','2024-03-21','2028-04-07','كيا','Frontier ','1997'),(46,77,'38-48179','2024-10-01','2026-06-05','هونداي','h100','2000'),(47,78,'36-39789','2024-03-15','2025-09-09','ميتسوبيشي','mitsubishi','2023'),(48,80,'38-96867','2024-03-28','2030-09-19','هونداي','hyundai','1999'),(49,81,'41-63813','2024-04-19','2026-09-09','كيا','brigo','2001'),(50,82,'42-35475','2024-08-13','2027-08-18','هونداي','hyundai','2011'),(51,83,'42-36948','2025-01-16','2025-06-15','هونداي','hyundai','2010'),(52,84,'47-57646','2024-10-08','2026-04-14','هونداي','hyundai','2016'),(53,86,'53-982','2024-01-23','2024-01-23','كيا','2013','2013'),(54,87,'47-76897','2024-02-16','2024-02-16','بيجو ','بارتنر','2022'),(55,88,'12-3456','2024-02-01','2024-02-01','كورلا','٢٠٢٩','2019'),(56,90,'4144355','2024-03-06','2024-03-06','كيا','1999','1999'),(57,89,'42-44207','2024-11-01','2030-02-01','بنجو فحل','٢٠١٠','2010'),(58,109,'42-43847','2024-10-23','2027-05-13','هونداي','porter','2011'),(59,108,'3791242','2024-07-21','2028-06-20','jac','jac','2022'),(60,110,'48-46576','2024-05-23','2028-02-08','JAC','JAC','2022'),(61,107,'48-91858','2024-07-19','2032-04-12','هونداي','porter','2017'),(62,106,'40-89801','2024-11-11','2031-12-15','JAK','2022','2022'),(63,111,'40-58856','2024-09-04','2029-05-08','JAC','JAC','2022'),(64,114,'46-76795','2024-10-17','2024-04-05','هونداي','بورتر','2017'),(65,112,'4246685','2024-05-05','2026-12-24','كيا','bungo','2013'),(66,115,'41-47291','2024-05-10','2030-02-19','تويوتا','diana','1998'),(67,116,'41-69115','2024-11-17','2028-02-23','تويوتا','diana','1995'),(68,105,'42-11658','2025-01-23','2026-03-11','تويوتا','1998','2000'),(69,117,'60-8331','2025-02-20','2025-01-21','مرسيدس','mercedes','1983'),(70,118,'60-24990','2025-02-01','2026-02-11','مرسيدس','1999','1999'),(71,119,'60-8065','2025-02-01','2026-02-03','مرسيدس','1996','1996'),(72,120,'41-48492','2024-09-26','2026-02-10','تويوتا','0780496277','1988'),(73,121,'60-3817','2024-10-18','2029-06-28','مرسيدس','mercedes','1997'),(74,122,'60-49956','2026-02-02','2025-02-11','مرسيدس','2004','2004'),(75,123,'60-52091','2026-02-10','2026-02-05','مرسيدس','2003','2003'),(76,124,'41-83826','2025-02-13','2026-02-10','تويوتا','1995','1995'),(77,125,'60-14703','2024-05-23','2028-03-13','مرسيدس','benz','1997'),(78,127,'60-68008','2025-02-11','2026-02-10','مرسيدس','2012','2012'),(79,126,'60-58853','2025-01-26','2028-12-27','مرسيدس','benz','2015'),(80,128,'60-70026','2024-10-16','2028-05-07','إيسوزو','isuzu','2017'),(81,129,'42-51740','2025-02-25','2028-02-21','إيسوزو','isuzu','2005'),(82,130,'60-53965','2024-12-13','2025-08-20','مرسيدس','benz','2000'),(83,131,'60-38660','2025-02-11','2026-02-10','مرسيدس','1999','1999'),(84,132,'60-67791','2025-02-12','2026-02-11','مرسيدس','2013','2013'),(85,133,'60-71114','2025-02-12','2029-02-06','مرسيدس','2012','2012'),(86,134,'41-99468','2024-02-28','2024-02-28','هونداي','مايتي','2010'),(87,135,'60-70392','2024-09-24','2028-02-19','مرسيدس','2012','2012'),(88,136,'60-44438','2024-02-28','2025-05-13','ميتسوبيشي','كانتر','2009'),(89,137,'60-69794','2026-02-10','2029-02-14','مرسيدس','2012','2012'),(90,138,'41-68792','2025-09-10','2024-02-28','ديايا','سوزو','2007'),(91,139,'60-64963','2024-03-04','2024-10-08','مرسيدس','2012','2012'),(92,140,'41-51845','2024-02-28','2025-03-26','كيا ','بنغو','1996'),(93,141,'60-66781','2024-09-15','2026-12-29','مرسيدس','2012','2012'),(94,142,'60-11912','2024-11-28','2032-05-18','مرسيدس','1997','1997'),(95,144,'60-43949','2025-02-12','2026-02-11','مرسيدس','2003','2003'),(96,143,'42-131173','2024-02-29','2024-08-15','كيا','بنغو','2000'),(97,145,'42-2622','2024-06-21','2024-08-28','كيا','بنغو','1999'),(98,146,'60-51229','2024-05-10','2032-02-19','مرسيدس','1999','1999'),(99,147,'60-1863','2025-01-10','2030-02-21','مرسيدس','1994','1994'),(100,148,'42-40589','2024-02-29','2024-09-18','هونداي','بورتر','2011'),(101,149,'42-25812','2024-02-29','2024-04-19','هونداي','بورتر','2010'),(102,150,'60-62136','2024-12-25','2024-02-29','مرسيدس','2012','2012'),(103,151,'36-84595','2024-02-29','2024-07-25','هونكاي','بورتر','2017'),(104,152,'39-53367','2024-02-29','2024-06-06','بنغو','دبل كبين','2002'),(106,154,'98-754168','2024-05-15','2024-06-19','مرسيدس','٢٠٢٠','2010'),(107,155,'87-64325','2024-03-19','2025-01-08','مرسيدس','٢٠٢٠','2016'),(108,156,'42-39607','2024-11-27','2024-03-02','هونداي','هونداي','2019'),(109,157,'40-69470','2024-11-22','2024-03-02','jac','jac','2022'),(110,158,'60-32272','2024-12-26','2029-07-11','مرسيدس','benz','1982'),(111,160,'41-39512','2024-08-22','2032-03-10','كيا','بنغو','1997'),(112,161,'41-48380','2024-07-16','2028-10-10','تويوتا','ديانا','1992'),(113,162,'42-36651','2024-11-24','2026-07-22','هونداي','بنغو','2010'),(114,159,'60-52680','2024-05-10','2024-05-10','مرسيدس','mb2','2004'),(115,163,'41-49357','2024-07-19','2030-05-14','كيا','بنغو','1999'),(116,164,'41-83224','2024-10-22','2028-05-08','بيجو','Peugeot ','2010'),(117,167,'42-26943','2024-03-04','2030-03-13','تويوتا','ديانا','1990'),(118,166,'39-41638','2024-10-14','2026-11-02','كيا','bongo','2002'),(119,168,'60-63892','2025-03-11','2025-03-11','مرسيدس','2010','2010'),(120,169,'60-53757','2026-03-04','2025-03-07','مرسيدس','2000','2000'),(121,170,'60-53020','2025-03-04','2025-03-12','مرسيدس','2003','2003'),(122,171,'41-53524','2024-03-08','2028-05-21','كيا ','بنقو','1996'),(123,172,'41-97480','2024-09-05','2026-08-12','كيا','بنقو','1999'),(124,173,'60-54329','2025-03-11','2026-03-12','مرسيدس','2008','2008'),(125,174,'60-7559','2024-03-12','2029-03-15','مرسيدس','2008','2008'),(126,175,'6060802','2025-03-14','2031-08-21','تويوتا','diana','2002'),(127,176,'42-36086','2024-04-16','2027-10-02','تويوتا','كلتر','2016'),(128,177,'41-21927','2024-10-15','2029-06-20','تويوتا','dyana ','1995'),(129,178,'60-61810','2029-03-07','2026-03-12','مرسيدس','2010','2010'),(130,180,'4231241','2025-01-23','2029-07-17','كيا','kia','2008'),(131,183,'42-21695','2024-12-30','2030-06-12','كيا','bongo','2007'),(132,184,'41-57185','2024-08-20','2029-03-21','كيا','bongo','1998'),(133,185,'4185035','2024-12-19','2024-03-05','كيا','bungo','2005'),(134,179,'60-52560','2024-06-15','2027-06-07','مرسيدس','Atego','2004'),(135,190,'42-49745','2025-01-10','2028-10-23','كيا','bungo','2012'),(136,189,'٤١-٩٢٢٨٩','2024-09-27','2025-04-20','هونداي','ستاركس','2007'),(137,191,'42-36558','2024-07-30','2031-12-14','كيا','bongo','2010'),(138,192,'60_60103','2025-01-13','2025-04-01','مرسيدس','اتيكو','2008'),(139,193,'42-5569','2025-02-12','2025-07-27','كيا','bongo','1998'),(140,194,'50_20408','2024-08-19','2028-03-15','ميتسوبيشي','كانتر','1991'),(141,195,'42-27823','2025-03-06','2028-03-22','ميتسوبيشي','ديانا','2016'),(142,196,'41-15121','2024-07-25','2029-03-13','تويوتا','dyana','1988'),(143,197,'42-51417','2025-04-08','2031-03-12','هونداي','porter','2012'),(144,198,'46-58015','2024-09-24','2029-03-16','كيا','bongo','2012'),(145,199,'42-40118','2024-04-23','2029-06-12','هونداي','porter','2012'),(146,200,'42-45452','2025-02-08','2031-03-20','كيا','bongo','2012'),(147,201,'42-70776','2024-11-20','2025-12-16','تويوتا','diana','1992'),(148,202,'60-37670','2025-03-03','2028-04-20','مرسيدس','لب','1981'),(149,203,'60-23603','2024-08-22','2029-06-13','مرسيدس','ateco','1999'),(150,205,'41-39009','2025-03-12','2026-03-11','تويوتا','Daihana','1995'),(151,204,'60-71182','2024-06-28','2029-06-12','مرسيدس','ateco','2013'),(152,206,'38-92576','2025-03-18','2025-03-11','هونداي','2003','2003'),(153,207,'41-31774','2024-08-14','2028-06-14','تويوتا','dyana','1994'),(154,208,'36-37605','2025-03-12','2025-03-12','هونداي','portal','2017'),(155,209,'42-54990','2024-11-19','2028-05-17','هونداي','mighty ','2016'),(156,210,'38-61430','2026-03-12','2026-03-10','هونداي','2003','2003'),(157,211,'36_42397','2025-01-30','2024-03-20','دونفينك','msev','2023'),(158,212,'42-43340','2024-07-14','2029-03-22','كيا','bongo','2012'),(159,213,'42-43450','2024-07-18','2029-03-20','JAC','JAC','2018'),(160,214,'42-12345','2024-08-22','2027-03-23','كيا','bongo','2010'),(161,215,'41-95966','2024-03-31','2025-09-01','كيا','بنغو','2001'),(162,216,'41-94778','2024-07-15','2028-03-23','ميتسوبيشي','fuso','2005'),(163,217,'60-51968','2025-03-03','2029-03-08','مرسيدس','2003','2003'),(164,218,'60-20319','2024-07-18','2028-08-23','مرسيدس','٨١٣','1984'),(165,219,'60-56732','2025-03-11','2025-03-11','مرسيدس','2005','2005'),(166,220,'42-39974','2024-04-17','2029-03-28','كيا','بنغو','2013'),(167,221,'42-49134','2025-03-11','2028-03-14','كيا','bongo','2001'),(168,222,'42_4092','2025-02-05','2024-03-30','هونداي','بورتر','2012'),(169,223,'60/71928','2024-10-19','2028-03-12','ميتسوبيشي','ديانا','2004'),(170,224,'60-69368','2024-09-15','2029-03-13','مرسيدس','ateco','2011'),(171,225,'41-84004','2026-03-03','2025-03-04','مرسيدس','2006','2006'),(172,226,'41-60634','2024-09-17','2029-03-13','تويوتا','toyota','1992'),(173,227,'41-89525','2024-03-10','2028-03-15','مرسيدس','2006','2006'),(174,228,'60-73039','2025-02-19','2032-03-18','مرسيدس','benz','2001'),(175,229,'60/63129','2024-04-21','2024-03-10','مرسيدس','اتكو','2010'),(176,230,'60-10466','2024-07-18','2029-03-11','مرسيدس','ateco','1998'),(177,231,'42-54291','2025-03-04','2026-03-10','كيا','bongo','2013'),(178,232,'38-96257','2024-11-14','2024-09-17','هونداي','اتش ميه','2000'),(179,234,'42-32796','2028-03-15','2024-03-13','هونداي ','بورتر','2010'),(180,235,'44-29368','2024-06-15','2032-05-29','كيا','bingo','2016'),(181,236,'60_43711','2025-03-31','2028-03-15','مرسيدس','>١٨','1983'),(182,237,'41-66635','2024-07-17','2028-07-18','هونداي','mighty','2005'),(183,238,'41-55021','2024-08-12','2028-03-24','تويوتا','diana','1990'),(184,239,'41-78974','2025-03-11','2026-03-10','إيسوزو','2006','2006'),(185,240,'47-95035','2025-03-11','2026-03-10','هونداي','بورتر','2018'),(186,241,'60-24692','2028-03-08','2028-03-14','مرسيدس','1992','1992'),(187,242,'6-64048','2025-03-12','2029-03-08','مرسيدس','2010','2010'),(188,244,'60_65145','2024-12-21','2027-03-15','مرسيدس','816','2010'),(189,245,'60_23052','2024-06-27','2030-03-19','مرسيدس','816','1995'),(190,246,'60÷47192','2024-03-12','2024-03-30','مرسيدس','٧١٦','1998'),(191,250,'1234444','2024-03-26','2024-03-13','AAA','AAA','2016'),(192,251,'40 56788','2025-03-12','2026-03-11','كيا','bongo','2002'),(193,254,'42-21205','2024-05-27','2025-11-15','كيا','diana','2013'),(194,255,'60-20325','2024-07-18','2027-03-10','مرسيدس','1983','1983'),(195,256,'60-8485','2025-01-15','2030-03-19','مرسيدس','820','1999'),(196,257,'60 55932','2024-11-27','2031-04-22','مرسيدس','1223','2005'),(197,258,'40-46399','2024-10-11','2027-03-16','h100','2001','2001'),(198,262,'42-50672','2024-12-09','2025-03-17','كيا','بنغو','2018'),(199,263,'60-15707','2025-02-24','2029-09-10','مرسيدس','1981','1981'),(200,264,'60-79705','2024-09-10','2025-09-02','مرسيدس','2018','2018'),(201,265,'60_38437','2025-03-18','2025-03-10','إيسوزو','216','2000'),(202,266,'60-31921','2024-12-27','2029-08-22','مرسيدس','mercedes ','1996'),(203,268,'60-30496','2024-10-22','2028-06-20','مرسيدس','1999','1999'),(204,269,'60-70058','2024-04-14','2024-08-28','مرسيدس','2012','2012'),(205,270,'60-73008','2024-04-28','2024-03-15','مرسيدس','1884','1984'),(206,267,'60-66316','2024-09-10','2025-03-11','مرسيدس','1882','1982'),(207,271,'60-79657','2024-09-17','2028-03-15','مرسيدس','mb4','2016'),(208,275,'60-8234','2024-11-11','2026-08-09','مرسيدس','1996','1996'),(209,276,'60-57366','2024-06-12','2028-07-17','هونداي','mighty','1999'),(210,277,'41-83008','2025-02-07','2027-04-23','ميتسوبيشي','2006','2006'),(211,278,'60-51103','2024-04-24','2024-04-24','مرسيدس','2000','2000'),(212,279,'60-32737','2024-12-09','2025-03-12','مرسيدس','814','1986'),(213,280,'42-31045','2024-09-20','2024-08-20','كيا','bingo','2010'),(214,282,'41-91514','2024-03-27','2029-03-20','هونداي','mighty ','2001'),(215,283,'18/59668','2024-05-11','2026-04-19',', هايلوكس','0772506413','2008'),(216,285,'60-12802','2024-08-14','2029-03-12','مرسيدس','ateco','2002'),(217,284,'60-39644','2025-03-04','2025-03-12','تويوتا','1984','1984'),(218,286,'41-47564','2024-04-10','2028-03-23','تويوتا','diana','1987'),(219,287,'38-66017','2024-03-21','2024-05-21','هونداي','0781766662','2001'),(220,288,'41-40133','2024-06-01','2028-03-14','إيسوزو','isuzu','2004'),(221,281,'42-35864','2024-09-10','2025-03-20','كيا','بونجو','2010'),(222,289,'60-65696','2024-09-12','2028-03-19','مرسيدس','ateco','2010'),(223,290,'41-69697','2024-11-21','2029-03-20','إيسوزو','Isuzu ','2005'),(224,291,'60-15416','2024-05-30','2028-03-21','مرسيدس','ateco','1997'),(225,292,'60-48285','2024-05-16','2028-05-16','مرسيدس','814','1993'),(226,294,'60-62208','2024-12-29','2027-05-21','مرسيدس','ateco','2009'),(227,296,'42-33576','2024-06-24','2032-11-06','كيا','بينجو','2012'),(228,297,'39_47905','2025-03-13','2024-04-10','هونداي','بورتر','2005'),(229,298,'41-60605','2024-09-21','2024-08-05','ميتسوبيشي ','كانتر','2007'),(230,299,'41-70926','2024-11-29','2034-02-26','كيا','بينجو','2002'),(231,300,'42-11046','2024-03-17','2029-03-07','كيا بنجو','بنجو','2002'),(232,301,'22-78126','2024-05-01','2025-03-02','كيا','بينغو','2002'),(233,303,'60-67159','2024-06-07','2027-02-25','تويوتا','٢٠٠٥','2005'),(234,304,'42_21101','2024-11-27','2031-03-12','هينغو','s11','2013'),(235,305,'39-27476','2026-10-10','2024-09-09','كيا','بينغز','2005'),(236,306,'39-27456','2024-04-17','2024-10-03','كيا','بينغو','2002'),(237,308,'39-31781','2025-01-22','2028-06-13','كيا','بينغو','2007'),(238,309,'39-4258','2025-02-10','2027-11-24','كيا','بينجو','2001'),(239,310,'41-62227','2024-10-15','2028-05-16','كيا','بينغو','2002'),(240,312,'٣٨-٨٦١٩٣.','2024-08-28','2031-03-17','هونداي','١٠٠اتس','1997'),(241,314,'41-39023','2024-06-11','2028-03-14','تويوتا','ديانا','1998'),(242,313,'41-95647','2024-05-13','2026-01-20','كيا','بينجو','2001'),(243,315,'41 95647','2024-06-13','2030-03-12','كيا','بنغو','2001'),(244,316,'60-23143','2024-09-18','2028-07-02','تويوتا','ديانا','1985'),(245,317,'39-48818','2024-09-02','2024-03-17','كيا','بينغو','2015'),(246,319,'42-53484','2025-04-08','2027-03-14','كيا','بنغو','2013'),(247,320,'42-37571','2024-12-08','2028-05-05','هونداي','ديانا','2011'),(248,321,'41-74850','2024-12-22','2024-03-17','كيا','٢٠٠٢','2002'),(249,323,'42-8752','2024-08-02','2027-02-12','كيا','بينغو','2001'),(250,322,'41-62599','2025-04-30','2024-03-26','كيا','بنغو','1997'),(251,325,'36-78621','2024-05-20','2027-12-05',' هيونداي','اتش 100','2001'),(252,326,'41-98675','2024-10-08','2031-03-11','كيا','بينغو','2000'),(253,327,'38-95369','2024-10-31','2028-03-21','هونداي','اتش ٢٠٠','1999'),(254,331,'41-49021','2024-10-15','2027-06-24','تويوتا','ديانا','1982'),(255,330,'41-43236','2024-06-19','2030-02-18','تويوتا','ديانا','1988'),(256,332,'41-79576','2024-04-10','2026-03-10','تويوتا','1985','1985'),(257,333,'39-41693','2025-02-08','2029-07-22','كيا','بينغو','2003'),(258,334,'42-2754','2024-03-20','2027-09-12','كيا','بينجو','2002'),(259,335,'41-52498','2024-08-06','2026-12-26','كيا','بينجو','2001'),(260,336,'42-2402','2025-03-15','2027-10-16','هونداي','بورتر','2007'),(261,337,'42-38510','2025-01-15','2029-03-20','كيا','بنغو','2013'),(262,338,'41-67621','2024-11-06','2027-01-12','كيا','بينجو','2000'),(263,339,'41-91139','2025-03-27','2029-07-10','تويوتا','ديانا ','1993'),(264,341,'60-60642','2025-03-31','2025-08-19','مرسيدس','2009','2009'),(265,342,'60-63615','2024-06-19','2027-01-25','ميتسوبيشي','ديانا','2015'),(266,343,'٤١٠٧٩٢٨٧','2025-03-11','2031-03-18','كيا','بنغو','2002'),(267,344,'60-57370','2024-12-23','2025-08-16','مرسيدس','١٩٩٥','1995'),(268,345,'49-10534','2024-07-30','2025-03-02','كيا','بينغو','2018'),(269,346,'60-69833','2024-12-16','2026-05-01','تيوتوتا','ديانا','1997'),(270,347,'38-67689','2024-05-12','2025-03-09','كيا','بريجو','1996'),(271,302,'40-39858','2024-12-21','2030-05-02','هونداي','بورتر','2007'),(272,348,'60-47360','2024-10-23','2024-12-13','هيونداي','١٩٩٧','1996'),(273,349,'60-61339','2024-11-12','2025-10-17','مرسيدس','بنز','2009'),(274,351,'60-68591','2024-04-18','2031-07-27','مارسيدس','2011','2011'),(275,350,'60-34189','2024-08-13','2028-03-15','مرسيدس','بنز','2000'),(276,352,'42-29356','2024-06-02','2028-03-22','كيا','بينغو','2010'),(277,356,'42-49575','2024-09-29','2024-03-18','كيا','بينغو','2013'),(278,353,'42-45036','2025-01-28','2026-06-19','كيا','بنغو','2013'),(279,355,'41-85338','2024-12-31','2024-04-24','كيا','بينغو','1999'),(280,354,'41-48495','2024-07-16','2026-04-17','تويوتا','بينجو','1993'),(281,357,'42-50287','2024-12-28','2028-03-27','هونداي','بورتر','2013'),(282,360,'60-62793','2025-01-15','2030-06-18','مرسيدس ','اتيكو','2010'),(283,361,'42-25798','2024-07-17','2028-07-19','كيا','بينغو','2009'),(284,362,'44-87709','2024-03-19','2025-03-19','هونداي','2005','2005'),(285,363,'46-70993','2024-09-24','2024-05-21','ميتسوبيشي ','فوسو','2021'),(286,365,'41-50198','2025-03-20','2029-03-20','هونداي','1995','1995'),(287,364,'41-68072','2025-09-20','2032-03-20','مارسيدس','١٩٩٨','1998'),(288,366,'60-7485','2024-12-25','2024-06-25','مارسيدس','١٩٨٣','1983'),(289,367,'41-89760','2025-03-29','2028-03-30','isuzu','ديانا','2004'),(290,368,'45-46405','2024-06-02','2031-08-01','كيا','بينغو','2016'),(291,369,'60-49298','2024-08-13','2029-05-15','مرسيدس ','اكتروس','1998'),(292,370,'60-9687','2024-07-17','2031-03-20','مرسيدس','اكتروس','2003'),(293,371,'60-29988','2024-08-12','2028-06-12','مرسيدس','اتيكو','1997'),(294,372,'60-16177','2024-07-14','2028-06-12','مرسيدس ','اكتروس','2005'),(295,373,'60-58610','2024-09-17','2031-05-05','مرسيدس','اكتروس','2001'),(296,374,'42-25762','2024-10-20','2030-11-06','كيا','بينجو','2010'),(297,375,'60-46350','2024-08-13','2030-05-10','مرسيدي','اكتروس','1999'),(298,377,'60-22350','2024-08-09','2028-09-02','هيونداي','ونش','2001'),(299,376,'38-88767','2024-12-11','2032-06-19','هونداي','2000','2000'),(300,378,'39_16296','2025-03-20','2028-03-20','هونداي','اتتش100','2000'),(301,380,'45_88927','2025-04-08','2025-03-10',' تويوتا ','ديانا','1982'),(302,381,'60-12987','2025-03-02','2026-03-20','مرسيدس','2006','2006'),(303,382,'42/14951','2024-06-24','2025-07-14','  هونداي','ديانا','2010'),(304,383,'60-47730','2025-02-18','2029-05-16','مرسيدس ','اتيكو','1999'),(305,384,'60-19797','2024-07-17','2028-05-10','مرسيدي','اكتروس','1996'),(306,386,'60-12083','2024-04-18','2024-07-16','مارسيدس','1984','1984'),(307,387,'60_62573','2024-12-27','2028-03-20','مرسيدس','البي','1997'),(308,389,'60-58265','2024-08-10','2028-06-04','مرسيدس','اتيكو','2007'),(309,388,'42-3859','2024-08-12','2029-06-06','هونداي','مايتي','2007'),(310,390,'42-15977','2024-08-13','2025-06-18','هيونداي','ديانا','2011'),(311,391,'60-36935','2025-01-23','2028-03-17','مرسيدس ','اكتروس','2002'),(312,392,'39-49292','2024-09-12','2032-12-31','h100','هنداي','2003'),(313,394,'42-62561','2025-03-03','2025-03-21','هونداي','2014','2014'),(314,395,'60-32478','2024-12-17','2029-05-15','مرسيدس ','اكتروس','1995'),(315,396,'60-26130','2024-09-20','2028-03-24','مرسيدس','١١٨٣','1980'),(316,397,'60-71990','2024-09-16','2027-07-14','مرسيدس','اتيكو','2011'),(317,398,'60-52870','2025-01-19','2028-09-16','مرسيديس','١٩٩٩','1999'),(318,399,'42-24631','2024-05-15','2028-05-21','متسوبيشي','كانتر','2013'),(319,400,'60_58987','2024-06-26','2031-03-26','مرسيدس','٨١٦','2009'),(320,402,'60-38509','2024-07-23','2032-06-22','مرسيدس','١٩٩٦','1996'),(321,401,'60-5958','2024-03-29','2026-03-21','مرسيدس','بينز','1989'),(322,404,'60-24472','2024-09-01','2029-06-13','مرسيدس','اتيكو','1988'),(323,403,'60_21392','2024-07-31','2028-03-21','مرسيدس','٨١٦','1981'),(324,405,' 60-61308','2024-10-31','2029-05-22','مارسيدس','اكتروس','2009'),(325,406,'41-89762','2024-08-14','2027-07-08','هونداي','مايتي','2005'),(326,407,'41-56862','2025-03-21','2027-03-23','هونداي','مايتي','1996'),(327,408,'60-19498','2024-12-10','2025-03-20','مرسيدس','اكتروس','1999'),(328,409,'60-48821','2024-08-20','2029-06-05','مرسبدس','اكتروس','2000'),(329,410,'60-54991','2025-01-20','2029-07-10','مرسيديس','اكتروس ','2000'),(330,411,'60-66340','2024-10-07','2025-04-08','مرسيدس','اكتروس','2012'),(331,412,'49-37915','2024-10-15','2029-06-12','هونداي','ديانا','2010'),(332,413,'60-66157','2025-03-21','2025-03-21','مرسيدس','اكتروس','2012'),(333,414,'60-59385','2024-09-10','2029-06-06','مرسيدس','اكتروس','2008'),(334,416,'00_55257','2024-09-26','2031-03-27','daf','daf','2007'),(335,421,'41_68503','2024-03-24','2024-03-28','kia','2003','2002'),(336,422,'٤١١٥٣٦٧','2024-07-28','2024-10-15','تويوتا','١٩٩٦','1996'),(337,423,'٣٧/٦١٥٦٤','2024-03-24','2024-03-24','مستوبيشي ','٢٠٠٨','2008'),(338,420,'60\\11978','2024-04-27','2024-03-24','مرسيدس lb817','1996','1996'),(339,424,'3889122','2025-05-14','2031-03-26','هونداي','اتشنيه','1996'),(340,426,'39-13548','2025-03-11','2029-05-08','هونداي','H100','1996'),(341,425,'60-60149','2024-10-29','2024-03-24','مارسيدس','اكتروس','2008'),(342,427,'38-88323','2025-03-24','2029-03-27','هونداي','اتش ميه','1987'),(343,311,'٤٢/١٩٨٩٦','2024-03-24','2024-03-24','كيا ','بنجو ٣','2007'),(344,428,'39-53981','2025-01-08','2027-06-09','هونداي','H100','2003'),(345,429,'38 96628','2025-04-09','2031-03-27','هونداي ','اتش ','2001'),(346,430,'38-99041','2024-09-20','2029-07-17','هونداي','H100','1996'),(347,431,'40-40235','2024-04-25','2032-04-14','هيونداي','h100','2003'),(348,432,'45-62472','2024-08-12','2028-06-06','هونداي ','H100','2002'),(349,434,'39-12203','2024-07-22','2026-08-11','هونداي','h100','1999'),(350,435,'37_31275','2024-10-01','2028-03-30','هونداي','اتش ميه','2003'),(351,436,'3898913','2024-08-09','2028-03-27','هونداي','اتش ميه','2000'),(352,437,'38-91862','2024-09-19','2029-03-08','هونداي','H100','2000'),(353,439,'38-13169','2025-03-04','2029-03-24','هونداي ','H100','2002'),(354,438,'38_21920','2024-11-21','2028-03-27','هونداي','اتش مبه','1998'),(355,449,'41-58898','2024-08-15','2028-06-14','تويوتا','ديانا','2000'),(356,450,'41-99032','2024-11-09','2029-07-07','كيا','بينجو','2002'),(357,451,'41-36905','2024-10-20','2028-06-06','دايهاتسو','ديلتا','1992'),(358,452,'37-79921','2024-10-18','2026-08-24','كيا','بينجو','2007'),(359,453,'37-79921','2025-03-25','2026-04-25','هونداي','بورتر','2008'),(360,454,'41-48917','2024-07-17','2029-06-06','كيا','بينجو','2002'),(361,455,'42-35529','2024-06-04','2026-08-07','كيا','بينغو','2011'),(362,456,'42-3149','2024-10-14','2030-06-18','كيا','بينجو','2001'),(363,457,'42-17276','2025-02-09','2029-07-17','هونداي','ديانا','2012'),(364,459,'41-75682','2024-08-21','2029-06-12','اوبل','كامبيو','1988'),(365,458,'42-9812','2024-10-09','2027-09-09','كيا','بينغو','2003'),(366,460,'42_17446','2024-11-27','2031-03-27','كيا','بنغو','2010'),(367,462,'41-11221','2024-07-18','2028-03-17','كيا','بينغو','2018'),(368,463,'42-16434','2024-05-07','2026-03-25','كيا','بينغو','2010'),(369,464,'41-12345','2024-08-08','2029-06-06','مرسيدس','بنز','2013'),(370,468,'41-60376','2024-07-24','2028-06-21','هونداي','بينجو','1997'),(371,469,'42-28526','2024-08-11','2032-06-16','هونداي ','بورتر','2010'),(372,470,'41-60367','2024-08-11','2028-03-23','هيونداي','بينجو','1999'),(373,471,'41-76492','2025-01-12','2029-07-01','كيا','بينجو','1995'),(374,472,'42-18270','2025-02-16','2026-11-14','كيا','بينجو','2002'),(375,473,'42-33990','2025-04-16','2026-03-11','كيا','بينغو','2010'),(376,474,'42-35334','2025-03-13','2031-01-12','كيا','بينجو','2010'),(377,475,'41-71449','2025-02-12','2029-06-14','تويوتا','ديانا','1989'),(378,477,'42-8328','2024-12-17','2029-06-12','كيا ','بينغو','2003'),(379,478,'40-54321','2024-09-15','2032-03-22','كيا','بينجو','2005'),(380,479,'38-71980','2024-03-27','2024-03-27','هونداي ستاركس ','2001','2001'),(381,482,'41_71655','2024-11-13','2027-03-10','كيا','بنغو','2001'),(382,483,'42-41791','2024-09-16','2027-06-10','هونداي','ديانا','2005'),(383,484,'٤٢.٧٥١٥١','2024-12-09','2026-08-19','هونداي','٢٠٢٣','2023'),(384,485,'41-24105','2024-08-13','2029-03-21','تويوتا','ديانا','1995'),(385,486,'41-51265','2024-05-15','2027-03-15','كيا','بنغو','1995'),(386,488,'41-98980','2024-03-28','2026-03-24','كيا','بنغو','2003'),(387,489,'60-59139','2024-06-10','2024-06-01','مرسيدس ','اكتروس','2011'),(388,494,'38-35264','2024-08-10','2029-06-11','هونداي','H100','2006'),(389,495,'60-35825','2024-08-05','2028-07-16','كيا','بينجو','2010'),(390,496,'42-24832','2024-09-15','2029-03-15','كيا','بينجو','2010'),(391,498,'46-29323','2024-10-12','2029-04-17','هونداي','بورتر','2011'),(392,497,'48_75788','2024-09-17','2026-03-10','كيا','بنغو','2004'),(393,499,'60 63189','2024-04-29','2026-09-14','ميتسوبيشي','كانتر ','2015'),(394,500,'41-90618s','2024-09-16','2027-06-08','تويوتا','ديانا','1985'),(395,501,'35_43038','2025-04-08','2031-03-17','مرسيدس','817','1998'),(396,502,'٤٢÷٧٨٩٦٥','2024-08-05','2031-03-03','كيت','بنغو','2016'),(397,506,'40-38552','2024-09-17','2031-05-07','كيا','بينجو','2008'),(398,507,'42-11885','2024-08-15','2028-09-05','كيا','بينجو','2011'),(399,508,'42-53942','2024-11-09','2031-03-14','هونداي ','بورتر','2008'),(400,509,'39-33197','2025-03-31','2025-04-30','باص','ستاريكس','2007'),(401,510,'46\'33637','2024-11-12','2028-03-31','مرسيدس','باص','2011'),(402,511,'41-38354','2024-07-10','2025-06-10','تويوتا','ديانا','1994'),(403,512,'41-38354','2024-09-08','2028-06-14','تويوتا ','ديانا','2004'),(404,514,'41-45149','2024-09-25','2031-06-24','ايسوزو','٢٠٠٦','2006'),(405,515,'41 77082','2024-12-02','2028-03-14',' ايسزو','انكيتر','2005'),(406,516,'40-27113','2024-10-13','2029-07-15','كيا','بينجو','2007'),(407,517,'4839934','2025-04-11','2027-10-13','هونداي','بورتر','2003'),(408,519,'38-48025','2024-08-14','2032-09-12','هونداي ','H100 ','1996'),(409,520,'40-63246','2024-05-31','2025-03-31','هونداي','اتش 100','2001'),(410,521,'41-44371','2026-04-15','2026-03-11','كيا','بينغو','2006'),(411,522,'39-40399','2024-08-14','2029-07-18','هونداي ','H100','2001'),(412,524,'60-46338','2024-09-18','2029-07-17','مرسيدس','اتيكو','2006'),(413,523,'25-18588','2024-12-26','2024-12-26',' كيا','بينجو','2017'),(414,526,'40-54938','2024-09-19','2029-09-09','هونداي','بورتر','2008'),(415,529,'36-77988','2024-05-18','2030-02-16','كيا','بينجو','2015'),(416,530,'41-74352','2024-10-13','2029-07-17','كيا','بينجو','2007'),(417,531,'40-14788','2024-09-03','2028-04-18','كيا','بينجو','2009'),(418,532,'4239213','2025-03-14','2031-03-15','مرسيدس فيتو ','2011','2011'),(419,487,'40-72737','2024-10-08','2029-08-05','هونداي ','مايتي','2023'),(420,533,'41-99451','2024-08-08','2024-04-08','كيا ','فرونتير','1998'),(421,551,'42-11561','2025-01-15','2029-04-24','كيا','بنغو','2002'),(422,553,'42-48049','2024-09-16','2029-08-08','هونداي','بورتر','2011'),(423,555,'42-54358','2024-10-05','2029-07-29','هونداي','بورتر','2007'),(424,554,'44-56784','2024-04-16','2024-04-16',' كيا','بنغو','2019'),(425,556,'42_48382','2024-11-06','2029-04-03','كيا','بنغو','2001'),(426,103,'42-33994','2024-04-11','2024-04-11','هيونداي','2022','2024'),(427,578,'38-92530','2027-10-10','2025-06-16','باص 100H','1998','1998'),(428,579,'4523156','2025-04-25','2034-04-25','بنغو','كيا','2004'),(429,75,'52925251','2023-12-31','2023-12-31','Honda','Civic','2009'),(430,153,'12356','2024-06-29','2024-06-29','tggv','gggg','2024'),(431,600,'111111','2025-06-28','2025-06-30','honda','2005','2005'),(432,615,'4037485','2024-07-06','2024-07-16','هونداي ','٢٠٠٠٢','2002'),(433,614,'18-211','2024-07-25','2025-01-15','كيا','بينجو','2022'),(434,617,'41 83589','2024-08-11','2025-07-21','كيا فورتنر','0787397689','2018'),(435,618,'4242455','2025-04-10','2031-10-09','هونداي','2018','2018'),(436,619,'46473924','2025-07-14','2025-06-14','جاك','0795101170','2018'),(437,620,'4238291','2025-10-19','2026-07-19','هواندي','0792860028','2021'),(438,621,'4543381','2025-11-23','2025-06-22','هواندي','0799966451','2021'),(439,622,'79414','2024-09-20','2024-07-31','مرسيدس','0798052340','2018'),(440,628,'5210','2025-03-25','2026-02-01','kia','dyna','2015'),(441,651,'yygg','2024-09-18','2024-11-12','dasqwd','qwdqq','2024'),(442,649,'6080229','2025-06-01','2025-02-03','مرسيدس','2018','2018'),(443,674,'6049014','2025-07-25','2029-07-31','مرسيدس','1999','1999'),(444,702,'336543','2025-06-17','2025-04-16','kia','bongo','2008');
/*!40000 ALTER TABLE `vendorCar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendorSpecialties`
--

DROP TABLE IF EXISTS `vendorSpecialties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `vendorSpecialties` (
  `vsId` int NOT NULL AUTO_INCREMENT,
  `vsUserId` int NOT NULL,
  `subSpecId` int NOT NULL,
  PRIMARY KEY (`vsId`),
  KEY `vsUserId` (`vsUserId`),
  KEY `subSpecId` (`subSpecId`),
  CONSTRAINT `vendorSpecialties_ibfk_1` FOREIGN KEY (`vsUserId`) REFERENCES `users` (`userId`),
  CONSTRAINT `vendorSpecialties_ibfk_2` FOREIGN KEY (`subSpecId`) REFERENCES `subSpecialties` (`subSpecId`)
) ENGINE=InnoDB AUTO_INCREMENT=911 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendorSpecialties`
--

LOCK TABLES `vendorSpecialties` WRITE;
/*!40000 ALTER TABLE `vendorSpecialties` DISABLE KEYS */;
INSERT INTO `vendorSpecialties` VALUES (159,63,6),(161,64,2),(162,65,2),(163,66,2),(165,67,2),(166,69,2),(167,68,6),(168,70,2),(169,71,2),(170,72,2),(171,73,2),(176,77,1),(177,78,1),(178,80,1),(179,81,1),(180,82,1),(181,83,1),(182,84,1),(183,86,2),(184,87,1),(185,88,19),(186,90,2),(187,89,2),(188,109,2),(189,108,2),(190,110,2),(191,107,2),(192,106,2),(193,111,2),(194,114,2),(195,112,2),(196,115,2),(197,116,2),(198,105,2),(199,117,3),(200,118,5),(201,119,5),(202,120,2),(203,121,3),(204,122,5),(205,123,5),(206,124,2),(207,125,3),(208,127,5),(209,126,3),(210,128,3),(211,129,3),(212,130,3),(213,131,5),(214,132,5),(215,133,5),(216,134,6),(217,135,5),(218,136,7),(219,137,5),(220,138,6),(221,139,5),(222,140,2),(223,141,5),(224,142,5),(225,144,5),(226,143,2),(227,145,2),(228,146,5),(229,147,5),(230,148,19),(231,149,19),(232,150,5),(233,151,19),(234,152,19),(236,154,2),(237,155,19),(238,156,2),(239,157,2),(240,158,3),(241,160,2),(242,161,20),(243,162,19),(244,159,3),(245,163,2),(246,164,1),(247,167,2),(248,166,12),(249,168,5),(250,169,5),(251,170,5),(252,171,2),(253,172,2),(254,173,5),(255,174,5),(256,175,13),(257,176,20),(258,177,13),(259,178,5),(260,180,2),(261,183,2),(262,184,2),(263,185,2),(264,179,21),(265,190,2),(266,189,22),(267,191,2),(268,192,21),(269,193,1),(270,194,20),(271,195,2),(272,196,2),(273,197,1),(274,198,19),(275,199,19),(276,200,1),(277,201,2),(278,202,6),(279,203,6),(280,205,15),(281,204,6),(282,206,1),(283,207,2),(284,208,2),(285,209,1),(286,210,1),(287,211,22),(288,212,1),(289,213,2),(290,214,1),(291,215,19),(292,216,13),(293,217,3),(294,218,6),(295,219,6),(296,220,19),(297,221,12),(298,222,19),(299,223,20),(300,224,7),(301,225,3),(302,226,3),(303,227,3),(304,228,3),(305,229,7),(306,230,3),(307,231,12),(308,232,22),(309,234,1),(310,235,1),(311,236,6),(312,237,2),(313,238,2),(314,239,3),(315,240,19),(316,241,6),(317,242,6),(318,244,6),(319,245,6),(320,246,21),(321,250,19),(322,251,19),(323,254,13),(324,255,6),(325,256,6),(326,257,6),(327,258,22),(328,262,2),(329,263,5),(330,264,3),(331,265,6),(332,266,5),(333,268,5),(334,269,5),(335,270,3),(336,267,3),(337,271,3),(338,275,3),(339,276,20),(340,277,13),(341,278,7),(342,279,6),(343,280,19),(344,282,20),(345,283,11),(346,285,24),(347,284,20),(348,286,20),(349,287,22),(350,288,3),(351,281,12),(352,289,25),(353,290,3),(354,291,6),(355,292,6),(356,294,6),(357,296,12),(358,297,19),(359,298,3),(360,299,19),(361,300,19),(362,301,14),(363,303,20),(364,304,20),(365,305,12),(366,306,19),(367,308,19),(368,309,19),(369,310,19),(370,312,22),(371,314,15),(372,313,13),(373,315,19),(374,316,20),(375,317,19),(376,319,19),(377,320,20),(378,321,12),(379,323,12),(380,322,19),(381,325,22),(382,326,14),(383,327,22),(384,331,20),(385,330,13),(386,332,12),(387,333,19),(388,334,19),(389,335,12),(390,336,12),(391,337,19),(392,338,12),(393,339,20),(394,341,24),(395,342,13),(396,343,19),(397,344,7),(398,345,12),(399,346,20),(400,347,22),(401,302,19),(402,348,3),(403,349,3),(404,351,7),(405,350,6),(406,352,12),(407,356,19),(408,353,19),(409,355,12),(410,354,12),(411,357,19),(412,360,6),(413,361,16),(414,362,22),(415,363,3),(416,365,3),(417,364,3),(418,366,3),(419,367,3),(420,368,19),(421,369,3),(422,370,3),(423,371,3),(424,372,3),(425,373,3),(426,374,19),(427,375,3),(428,377,7),(429,376,22),(430,378,22),(431,380,20),(432,381,7),(433,382,3),(434,383,3),(435,384,3),(436,386,7),(437,387,6),(438,389,3),(439,388,3),(440,390,3),(441,391,3),(442,392,22),(443,394,3),(444,395,3),(445,396,6),(446,397,3),(447,398,3),(448,399,3),(449,400,6),(450,402,3),(451,401,3),(452,404,3),(453,403,6),(454,405,3),(455,406,3),(456,407,3),(457,408,3),(458,409,3),(459,410,3),(460,411,3),(461,412,3),(462,413,3),(463,414,3),(464,416,6),(465,421,2),(466,422,2),(467,423,20),(468,420,7),(469,424,22),(470,426,22),(471,425,7),(472,427,22),(473,311,9),(474,428,22),(475,429,22),(476,430,22),(477,431,22),(478,432,22),(479,434,22),(480,435,22),(481,436,22),(482,437,22),(483,439,22),(484,438,22),(485,449,2),(486,450,1),(487,451,2),(488,452,1),(489,453,1),(490,454,2),(491,455,1),(492,456,2),(493,457,2),(494,459,1),(495,458,1),(496,460,1),(497,462,1),(498,463,1),(499,464,1),(500,468,2),(501,469,1),(502,470,2),(503,471,1),(504,472,2),(505,473,2),(506,474,2),(507,475,2),(508,477,1),(509,478,1),(510,479,22),(511,482,1),(512,483,2),(513,484,2),(514,485,2),(515,486,2),(516,488,2),(517,489,3),(518,494,1),(519,495,2),(520,496,1),(521,498,1),(522,497,1),(523,499,13),(524,500,20),(525,501,6),(526,502,1),(527,506,1),(528,507,1),(529,508,2),(530,509,1),(531,510,1),(532,511,2),(533,512,2),(534,514,3),(535,515,3),(536,516,1),(537,517,1),(538,519,22),(539,520,22),(540,521,12),(541,522,22),(542,524,6),(543,523,1),(544,526,1),(545,529,2),(546,530,2),(547,531,2),(548,532,22),(549,487,2),(550,533,2),(551,551,1),(552,553,2),(553,555,2),(554,554,1),(555,556,2),(556,103,2),(557,578,22),(558,579,1),(559,75,1),(560,75,28),(561,75,29),(562,75,30),(563,153,1),(564,153,28),(565,153,29),(566,153,30),(567,600,19),(568,600,28),(569,600,29),(570,600,30),(571,77,28),(572,78,28),(573,80,28),(574,81,28),(575,82,28),(576,83,28),(577,84,28),(578,87,28),(579,164,28),(580,193,28),(581,197,28),(582,200,28),(583,206,28),(584,209,28),(585,210,28),(586,212,28),(587,214,28),(588,234,28),(589,235,28),(590,450,28),(591,452,28),(592,453,28),(593,455,28),(594,459,28),(595,458,28),(596,460,28),(597,462,28),(598,463,28),(599,464,28),(600,469,28),(601,471,28),(602,477,28),(603,478,28),(604,482,28),(605,494,28),(606,496,28),(607,498,28),(608,497,28),(609,502,28),(610,506,28),(611,507,28),(612,509,28),(613,510,28),(614,516,28),(615,517,33),(616,523,28),(617,526,28),(618,551,28),(619,554,28),(620,579,28),(634,77,29),(635,78,29),(636,80,29),(637,81,29),(638,82,29),(639,83,29),(640,84,29),(641,87,29),(642,164,29),(643,193,29),(644,197,29),(645,200,29),(646,206,29),(647,209,29),(648,210,29),(649,212,29),(650,214,29),(651,234,29),(652,235,29),(653,450,29),(654,452,29),(655,453,29),(656,455,29),(657,459,29),(658,458,29),(659,460,29),(660,462,29),(661,463,29),(662,464,29),(663,469,29),(664,471,29),(665,477,29),(666,478,29),(667,482,29),(668,494,29),(669,496,29),(670,498,29),(671,497,29),(672,502,29),(673,506,29),(674,507,29),(675,509,29),(676,510,29),(677,516,29),(678,517,29),(679,523,29),(680,526,29),(681,551,29),(682,554,29),(683,579,29),(697,77,30),(698,78,30),(699,80,30),(700,81,30),(701,82,30),(702,83,30),(703,84,30),(704,87,30),(705,164,30),(706,193,30),(707,197,30),(708,200,30),(709,206,30),(710,209,30),(711,210,30),(712,212,30),(713,214,30),(714,234,30),(715,235,30),(716,450,30),(717,452,30),(718,453,30),(719,455,30),(720,459,30),(721,458,30),(722,460,30),(723,462,30),(724,463,30),(725,464,30),(726,469,30),(727,471,30),(728,477,30),(729,478,30),(730,482,30),(731,494,30),(732,496,30),(733,498,30),(734,497,30),(735,502,30),(736,506,30),(737,507,30),(738,509,30),(739,510,30),(740,516,30),(741,517,30),(742,523,30),(743,526,30),(744,551,30),(745,554,30),(746,579,30),(760,64,32),(761,65,32),(762,66,32),(763,67,32),(764,69,32),(765,70,32),(766,71,32),(767,72,32),(768,73,32),(769,86,32),(770,90,32),(771,89,32),(772,109,32),(773,108,32),(774,110,32),(775,107,32),(776,106,32),(777,111,32),(778,114,32),(779,112,32),(780,115,32),(781,116,32),(782,105,32),(783,120,32),(784,124,32),(785,140,32),(786,143,32),(787,145,32),(788,154,32),(789,156,32),(790,157,32),(791,160,32),(792,163,32),(793,167,32),(794,171,32),(795,172,32),(796,180,32),(797,183,32),(798,184,32),(799,185,32),(800,190,32),(801,191,32),(802,195,32),(803,196,32),(804,201,32),(805,207,32),(806,208,32),(807,213,32),(808,237,32),(809,238,32),(810,262,32),(811,421,32),(812,422,32),(813,449,32),(814,451,32),(815,454,32),(816,456,32),(817,457,32),(818,468,32),(819,470,32),(820,472,32),(821,473,32),(822,474,32),(823,475,32),(824,483,32),(825,484,32),(826,485,32),(827,486,32),(828,488,32),(829,495,32),(830,508,32),(831,511,32),(832,512,32),(833,529,32),(834,530,32),(835,531,32),(836,487,32),(837,533,32),(838,553,32),(839,555,32),(840,556,32),(841,103,32),(887,615,22),(888,614,1),(889,614,28),(890,614,29),(891,614,30),(892,617,1),(893,617,28),(894,617,29),(895,617,30),(896,618,2),(897,618,32),(898,619,2),(899,619,32),(900,620,2),(901,620,32),(902,621,3),(903,622,3),(904,628,2),(905,628,32),(906,651,3),(908,649,3),(909,674,10),(910,702,3);
/*!40000 ALTER TABLE `vendorSpecialties` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-07-22 12:47:54
